/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.io.Device;
import plus.io.IoHelper;
import plus.io.PipedWriter;
import plus.spawn.system.Util;
import plus.spawn.system.UtilInterface;

public final class Command {
    private static final int REGX_GROUP3 = 3;
    private static final String REGX_REDIRECT_12 = "(\\d?)([<>]+)[ \t]*";
    private static final String REGX_SIMPLE_STRING = "[^ \t'\"|\n]+";
    private static final Pattern RX_PIPE = Pattern.compile("^([\n|]&?)[ \t]*");
    private static final Pattern RX_QUOTE = Pattern.compile("^(?:\"([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'([^']*)')");
    private static final Pattern RX_REDIRECT = Pattern.compile("^(\\d?)([<>]+)[ \t]*([^ \t'\"|\n]+)");
    private static final Pattern RX_REDIRECT_12 = Pattern.compile("^(\\d?)([<>]+)[ \t]*");
    private static final Pattern RX_SIMPLE_STRING = Pattern.compile("^[^ \t'\"|\n]+");
    private static final Pattern RX_SPACE_OF = Pattern.compile("^[^ \t<>|]+");
    private static final Pattern RX_SPACES = Pattern.compile("^[ \t]+");

    private Command() {
    }

    private static List<List<String>> parse(String command) {
        String arg = command.trim() + "|";
        int len = arg.length();
        ArrayList<List<String>> cmds = new ArrayList<List<String>>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block0: while (len > i) {
            ArrayList<String> args = new ArrayList<String>();
            while (len > i) {
                Matcher m;
                String x = arg.substring(i);
                char c = arg.charAt(i);
                if ('|' == c || '\n' == c) {
                    m = RX_PIPE.matcher(x);
                    if (!m.find()) {
                        throw new IllegalArgumentException("bug! " + m);
                    }
                    i += m.end();
                    if (0 < sb.length()) {
                        args.add(sb.toString());
                        sb.setLength(0);
                    }
                    if (args.isEmpty()) continue block0;
                    cmds.add(args);
                    continue block0;
                }
                if (' ' == c || '\t' == c) {
                    m = RX_SPACES.matcher(x);
                    if (!m.find()) {
                        throw new IllegalArgumentException("bug! " + m);
                    }
                    i += m.end();
                    if (0 >= sb.length()) continue;
                    args.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if ('\'' == c || '\"' == c) {
                    m = RX_QUOTE.matcher(x);
                    if (m.find()) {
                        sb.append(null != m.group(1) ? m.group(1) : m.group(2));
                    } else {
                        m = RX_SPACE_OF.matcher(x);
                        if (!m.find()) {
                            throw new IllegalArgumentException("bug! " + m);
                        }
                        sb.append(m.group());
                    }
                    i += m.end();
                    continue;
                }
                m = RX_REDIRECT_12.matcher(x);
                if (m.find()) {
                    String descriptor = m.group(1);
                    String rid = m.group(2);
                    if (descriptor.isEmpty()) {
                        descriptor = '<' == rid.charAt(0) ? "0" : "1";
                    }
                    sb.append(descriptor).append(rid);
                } else {
                    m = RX_SIMPLE_STRING.matcher(x);
                    if (!m.find()) {
                        throw new IllegalArgumentException("bug! " + m);
                    }
                    sb.append(m.group());
                }
                i += m.end();
            }
        }
        return cmds;
    }

    static Reader processReader(String command) throws IOException {
        String file = "/dev/stdin";
        List<List<String>> list = Command.parse(command);
        for (List<String> cmd : list) {
            int k = cmd.size();
            while (0 < --k) {
                String x = cmd.get(k);
                Matcher md = RX_REDIRECT.matcher(x);
                if (!md.find()) continue;
                String rid = md.group(2);
                assert (null != rid);
                if ('<' == rid.charAt(0)) {
                    String name = md.group(3);
                    assert (null != name);
                    file = "&0".equals(name) ? "/dev/stdin" : name;
                    System.err.println("`redirect " + x + " to `" + file + "`");
                }
                cmd.remove(k);
            }
        }
        PipedWriter writer = new PipedWriter();
        UtilInterface out = (UtilInterface)((Object)Util.spawn(list, writer));
        if (out.hasInput() || !"/dev/stdin".equals(file)) {
            IoHelper.copyline(file, (Writer)((Object)out));
        }
        out.close();
        return writer.getReader();
    }

    public static Writer processWriter(String command) throws IOException {
        String file = "/dev/stdout";
        String rid = ">";
        List<List<String>> list = Command.parse(command);
        for (List<String> cmd : list) {
            int k = cmd.size();
            while (0 < --k) {
                String x = cmd.get(k);
                Matcher md = RX_REDIRECT.matcher(x);
                if (!md.find()) continue;
                String descriptor = md.group(1);
                assert (null != descriptor);
                if ('1' == descriptor.charAt(0)) {
                    rid = md.group(2);
                    String name = md.group(3);
                    assert (null != rid && null != name);
                    file = "&1".equals(name) ? "/dev/stdout" : ("&2".equals(name) ? "/dev/stderr" : name);
                    System.err.println("`redirect " + x);
                }
                cmd.remove(k);
            }
        }
        Writer writer = Device.openOutput(rid, file);
        return Util.spawn(list, writer);
    }
}

