/* amd64-linux.elf-so_entry.h
   created from amd64-linux.elf-so_entry.bin, 6372 (0x18e4) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_AMD64_LINUX_ELF_SO_ENTRY_SIZE    6372
#define STUB_AMD64_LINUX_ELF_SO_ENTRY_ADLER32 0xf9607bd7
#define STUB_AMD64_LINUX_ELF_SO_ENTRY_CRC32   0x7ca0bbfb

unsigned char stub_amd64_linux_elf_so_entry[6372] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,120,  4,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 16,  0, 13,  0,
/* 0x0040 */ 233,  0,  0,  0,  0,233,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */  72,137, 92, 36,224, 72,137,108, 36,232, 76,137,100, 36,240, 76,
/* 0x0060 */ 137,108, 36,248, 72,131,236, 40, 72,137,251, 65,137,245, 72,141,
/* 0x0070 */  45,  0,  0,  0,  0,190, 16,  0,  0,  0, 72,137,239,232,  0,  0,
/* 0x0080 */   0,  0, 65,137,196,131,248,234,117, 16,190,  0,  0,  0,  0, 72,
/* 0x0090 */ 137,239,232,  0,  0,  0,  0, 65,137,196, 69,133,228,121, 46, 72,
/* 0x00a0 */ 141, 61,  0,  0,  0,  0,186,192,  1,  0,  0,190,  2,  0, 65,  0,
/* 0x00b0 */ 232,  0,  0,  0,  0, 65,137,196,133,192,121, 17, 72,141, 61,  0,
/* 0x00c0 */   0,  0,  0,184,  0,  0,  0,  0,232,  0,  0,  0,  0, 72,133,219,
/* 0x00d0 */ 116, 17,232,  0,  0,  0,  0,247,208, 33,216,137,194, 72, 41,211,
/* 0x00e0 */  65,  1,197, 69,133,237,116, 27,184,  1,  0,  0,  0,133,192,116,
/* 0x00f0 */  18, 68,137,238, 68,137,231,232,  0,  0,  0,  0, 72, 99,200,133,
/* 0x0100 */ 192,120,100, 72,133,219,116, 38,232,  0,  0,  0,  0,137,194,247,
/* 0x0110 */ 208,133,195,116, 15,247,218,137,210, 72,137,222, 68,137,231,232,
/* 0x0120 */   0,  0,  0,  0,185, 17,  0,  0,  0, 72,133,219,117,  5,185,  1,
/* 0x0130 */   0,  0,  0, 68,137,238, 65,185,  0,  0,  0,  0, 69,137,224,186,
/* 0x0140 */   3,  0,  0,  0, 72,137,223,232,  0,  0,  0,  0, 72,137,194, 72,
/* 0x0150 */ 137,193, 72, 61,  0,240,255,255,119, 13, 65,141, 68, 36,  1, 72,
/* 0x0160 */ 152, 72,137,193, 72,  9,209, 72,137,200, 72,139, 92, 36,  8, 72,
/* 0x0170 */ 139,108, 36, 16, 76,139,100, 36, 24, 76,139,108, 36, 32, 72,131,
/* 0x0180 */ 196, 40,195,  0, 72,137, 92, 36,224, 72,137,108, 36,232, 76,137,
/* 0x0190 */ 100, 36,240, 76,137,108, 36,248, 72,131,236, 40, 73,137,252, 65,
/* 0x01a0 */ 137,245, 72,141, 45,  0,  0,  0,  0,190, 16,  0,  0,  0, 72,137,
/* 0x01b0 */ 239,232,  0,  0,  0,  0,137,195,131,248,234,117, 15,190,  0,  0,
/* 0x01c0 */   0,  0, 72,137,239,232,  0,  0,  0,  0,137,195,133,219,121, 31,
/* 0x01d0 */  72,141, 61,  0,  0,  0,  0,186,192,  1,  0,  0,190,  2,  0, 65,
/* 0x01e0 */   0,232,  0,  0,  0,  0,137,195, 72, 99,208,133,192,120, 77, 68,
/* 0x01f0 */ 137,238,137,223,232,  0,  0,  0,  0, 72, 99,208,133,192,120, 60,
/* 0x0200 */  73,131,252,  1, 25,201,131,225,240,131,193, 17, 68,137,238, 65,
/* 0x0210 */ 185,  0,  0,  0,  0, 65,137,216,186,  3,  0,  0,  0, 76,137,231,
/* 0x0220 */ 232,  0,  0,  0,  0, 73,137,196,232,  0,  0,  0,  0, 76,137,226,
/* 0x0230 */  73, 57,196,115,  7,141, 67,  1, 74,141, 20, 32, 72,137,208, 72,
/* 0x0240 */ 139, 92, 36,  8, 72,139,108, 36, 16, 76,139,100, 36, 24, 76,139,
/* 0x0250 */ 108, 36, 32, 72,131,196, 40,195,144, 82, 86, 87, 83, 85, 72,137,
/* 0x0260 */ 229, 72,141, 29,  0,  0,  0,  0, 72,141,  5,217,255,255,255, 80,
/* 0x0270 */ 139,  3, 80, 72, 41,196, 72,131,228,240, 41,210, 72,141, 53, 74,
/* 0x0280 */   1,  0,  0, 41,255,104,  1,  1,  0,  0,232, 43,  1,  0,  0,133,
/* 0x0290 */ 192,120, 52, 80,186,  0,  2,  0,  0, 72,141,116, 36,  8, 95, 87,
/* 0x02a0 */ 106,  0,232, 19,  1,  0,  0, 76,141,  4, 48, 95,106,  3,232,  7,
/* 0x02b0 */   1,  0,  0, 72,137,230, 72,173, 72,145, 72,173, 72,131,249,  6,
/* 0x02c0 */ 116, 10, 76, 57,198,124,239,184,  0, 16,  0,  0, 72,247,216, 80,
/* 0x02d0 */  72,141, 21, 27,  0,  0,  0, 72,141,124, 36,  8, 85,139, 75,  4,
/* 0x02e0 */  72,141,115, 12, 72,  1,241, 81, 49,219, 49,201,106,255, 93,252,
/* 0x02f0 */ 235, 20,243, 15, 30,250,  1,219,116,  2,243,195,139, 30, 72,131,
/* 0x0300 */ 238,252, 17,219,195,164,255,210,114,251,141, 65,  1,255,210, 17,
/* 0x0310 */ 192,255,210,115,248,131,232,  3,114, 12,193,224,  8,172,131,240,
/* 0x0320 */ 255,116, 47, 72, 99,232,141, 65,  1,255,210, 17,201,255,210, 17,
/* 0x0330 */ 201,117, 13,137,193,131,192,  2,255,210, 17,201,255,210,115,248,
/* 0x0340 */ 129,253,  0,243,255,255, 17,193, 86, 72,141, 52, 47,243,164, 94,
/* 0x0350 */ 235,180, 89, 72, 57,206,116,  1,244, 93,104,117,112, 88,  0, 84,
/* 0x0360 */  95,106, 16, 94,184, 63,  1,  0,  0, 15,  5,133,192,121,  9,133,
/* 0x0370 */ 246,116,  4, 49,246,235,237,244, 89,143,  4, 36, 80, 95, 84, 94,
/* 0x0380 */  80, 72,139, 85,240,106,  1,232, 46,  0,  0,  0, 65, 88, 72,141,
/* 0x0390 */ 101,240, 94, 86, 69, 41,201,106,  2, 65, 90,106,  5, 90, 41,255,
/* 0x03a0 */ 106,  9,232, 19,  0,  0,  0, 80, 65, 80, 95,106,  3,232,  8,  0,
/* 0x03b0 */   0,  0, 88, 80, 72,131,192, 16,255,224, 72,139, 68, 36,  8, 15,
/* 0x03c0 */   5, 72, 61,  0,240,255,255,114,  1,204,194,  8,  0, 47,112,114,
/* 0x03d0 */ 111, 99, 47,115,101,108,102, 47, 97,117,120,118,  0,  0,  0,  0,
/* 0x03e0 */ 117,112,120,  0, 47,100,101,118, 47,115,104,109,  0,109,101,109,
/* 0x03f0 */ 102,100, 95, 99,114,101, 97,116,101,  0,117,112,120,  0, 47,100,
/* 0x0400 */ 101,118, 47,115,104,109,  0,  0, 46,115,121,109,116, 97, 98,  0,
/* 0x0410 */  46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97,
/* 0x0420 */  98,  0, 46,114,101,108, 97, 72, 85, 77, 70, 95, 65,  0, 46,114,
/* 0x0430 */ 101,108, 97, 72, 85, 77, 70, 95, 76,  0, 46,114,101,108, 97, 85,
/* 0x0440 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,101,108, 97,
/* 0x0450 */  85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 97, 69,
/* 0x0460 */  76, 70, 77, 65, 73, 78, 88,  0, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x0470 */   0, 83, 84, 82, 67, 79, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04b0 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x04c0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x04d0 */  64,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
/* 0x04e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x04f0 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x0500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0510 */ 160, 10,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x0520 */  14,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0530 */  24,  0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  1,  0,  0,  0,
/* 0x0540 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0550 */  69,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
/* 0x0560 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0570 */   0,  0,  0,  0,  0,  0,  0,  0, 39,  0,  0,  0,  4,  0,  0,  0,
/* 0x0580 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0590 */ 184, 10,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x05a0 */  14,  0,  0,  0,  3,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x05b0 */  24,  0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0,  1,  0,  0,  0,
/* 0x05c0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x05d0 */  80,  0,  0,  0,  0,  0,  0,  0, 51,  1,  0,  0,  0,  0,  0,  0,
/* 0x05e0 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x05f0 */   0,  0,  0,  0,  0,  0,  0,  0, 51,  0,  0,  0,  4,  0,  0,  0,
/* 0x0600 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0610 */ 208, 10,  0,  0,  0,  0,  0,  0, 32,  1,  0,  0,  0,  0,  0,  0,
/* 0x0620 */  14,  0,  0,  0,  5,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0630 */  24,  0,  0,  0,  0,  0,  0,  0, 73,  0,  0,  0,  1,  0,  0,  0,
/* 0x0640 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0650 */ 132,  1,  0,  0,  0,  0,  0,  0,212,  0,  0,  0,  0,  0,  0,  0,
/* 0x0660 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0670 */   0,  0,  0,  0,  0,  0,  0,  0, 68,  0,  0,  0,  4,  0,  0,  0,
/* 0x0680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0690 */ 240, 11,  0,  0,  0,  0,  0,  0,192,  0,  0,  0,  0,  0,  0,  0,
/* 0x06a0 */  14,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x06b0 */  24,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  1,  0,  0,  0,
/* 0x06c0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x06d0 */  88,  2,  0,  0,  0,  0,  0,  0,136,  1,  0,  0,  0,  0,  0,  0,
/* 0x06e0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x06f0 */   0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,  4,  0,  0,  0,
/* 0x0700 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0710 */ 176, 12,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x0720 */  14,  0,  0,  0,  9,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0730 */  24,  0,  0,  0,  0,  0,  0,  0, 97,  0,  0,  0,  1,  0,  0,  0,
/* 0x0740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0750 */ 224,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0760 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0770 */   0,  0,  0,  0,  0,  0,  0,  0,106,  0,  0,  0,  1,  0,  0,  0,
/* 0x0780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0790 */ 224,  3,  0,  0,  0,  0,  0,  0, 39,  0,  0,  0,  0,  0,  0,  0,
/* 0x07a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x07b0 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x07c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x07d0 */   7,  4,  0,  0,  0,  0,  0,  0,113,  0,  0,  0,  0,  0,  0,  0,
/* 0x07e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x07f0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x0800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0810 */ 120,  8,  0,  0,  0,  0,  0,  0,176,  1,  0,  0,  0,  0,  0,  0,
/* 0x0820 */  15,  0,  0,  0,  9,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x0830 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x0840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0850 */  40, 10,  0,  0,  0,  0,  0,  0,115,  0,  0,  0,  0,  0,  0,  0,
/* 0x0860 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0870 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0890 */   0,  0,  0,  0,  3,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,
/* 0x08b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08c0 */   1,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x08e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08f0 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0900 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x0910 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0920 */   0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  9,  0,
/* 0x0940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0950 */   8,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0960 */   0,  0,  0,  0,  0,  0,  0,  0, 22,  0,  0,  0, 16,  0,  0,  0,
/* 0x0970 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0980 */  32,  0,  0,  0, 18,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0990 */  51,  1,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0, 16,  0,  0,  0,
/* 0x09a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09b0 */  61,  0,  0,  0, 18,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09c0 */ 212,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0, 16,  0,  0,  0,
/* 0x09d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09e0 */  89,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09f0 */   0,  0,  0,  0,  0,  0,  0,  0,102,  0,  0,  0, 16,  0,  0,  0,
/* 0x0a00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a10 */ 110,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a20 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 95,115,116, 97,114,116,  0,
/* 0x0a30 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0,102,116,
/* 0x0a40 */ 114,117,110, 99, 97,116,101,  0,117,112,120, 95,109,109, 97,112,
/* 0x0a50 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,  0,
/* 0x0a60 */ 109,109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x0a70 */ 100, 95,102,100, 95,108,105,110,117,120,  0,119,114,105,116,101,
/* 0x0a80 */   0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,109,121,
/* 0x0a90 */  95, 98,107,112,116,  0,111,112,101,110,  0,  0,  0,  0,  0,  0,
/* 0x0aa0 */   1,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 11,  0,  0,  0,
/* 0x0ab0 */ 252,255,255,255,255,255,255,255,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ac0 */   2,  0,  0,  0, 13,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0ad0 */  33,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x0ae0 */ 252,255,255,255,255,255,255,255, 46,  0,  0,  0,  0,  0,  0,  0,
/* 0x0af0 */   4,  0,  0,  0, 15,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0b00 */  67,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 15,  0,  0,  0,
/* 0x0b10 */ 252,255,255,255,255,255,255,255, 82,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b20 */   2,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */  97,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x0b40 */ 252,255,255,255,255,255,255,255,111,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   2,  0,  0,  0,  2,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b60 */ 121,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,
/* 0x0b70 */ 252,255,255,255,255,255,255,255,131,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b80 */   4,  0,  0,  0,  9,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0b90 */ 168,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 10,  0,  0,  0,
/* 0x0ba0 */ 252,255,255,255,255,255,255,255,185,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bb0 */   4,  0,  0,  0,  9,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0bc0 */ 208,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 14,  0,  0,  0,
/* 0x0bd0 */ 252,255,255,255,255,255,255,255,248,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */   4,  0,  0,  0, 12,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0bf0 */  33,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x0c00 */  22,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c10 */   4,  0,  0,  0, 15,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0c20 */  66,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 15,  0,  0,  0,
/* 0x0c30 */ 252,255,255,255,255,255,255,255, 79,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c40 */   2,  0,  0,  0,  2,  0,  0,  0, 26,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c50 */  94,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x0c60 */ 252,255,255,255,255,255,255,255,113,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c70 */   4,  0,  0,  0, 10,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0c80 */ 157,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 12,  0,  0,  0,
/* 0x0c90 */ 252,255,255,255,255,255,255,255,165,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ca0 */   4,  0,  0,  0,  9,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x0cb0 */  12,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x0cc0 */ 252,255,255,255,255,255,255,255,102,105,108,101, 32,102,111,114,
/* 0x0cd0 */ 109, 97,116, 32,101,108,102, 54, 52, 45,120, 56, 54, 45, 54, 52,
/* 0x0ce0 */  10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32,
/* 0x0cf0 */  78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,
/* 0x0d00 */ 122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32,
/* 0x0d10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x0d20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101,
/* 0x0d30 */  32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,
/* 0x0d40 */ 115, 10, 32, 32, 48, 32, 72, 85, 77, 70, 95, 65, 32, 32, 32, 32,
/* 0x0d50 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x0d60 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0d70 */  83, 10, 32, 32, 49, 32, 72, 85, 77, 70, 95, 76, 32, 32, 32, 32,
/* 0x0d80 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x0d90 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0da0 */  83, 10, 32, 32, 50, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x0db0 */  68, 32, 32, 32, 48, 49, 51, 51, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x0dc0 */  48, 53, 48, 32, 32, 50, 42, 42, 52, 32, 32, 67, 79, 78, 84, 69,
/* 0x0dd0 */  78, 84, 83, 10, 32, 32, 51, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x0de0 */  88, 32, 32, 32, 32, 32, 48,100, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x0df0 */  32, 48, 49, 56, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78,
/* 0x0e00 */  84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 69, 76, 70, 77, 65, 73,
/* 0x0e10 */  78, 88, 32, 32, 32, 32, 32, 32, 48, 49, 56, 56, 32, 32, 48, 32,
/* 0x0e20 */  32, 48, 32, 32, 48, 50, 53, 56, 32, 32, 50, 42, 42, 50, 32, 32,
/* 0x0e30 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 69, 76, 70,
/* 0x0e40 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32,
/* 0x0e50 */  32, 48, 32, 32, 48, 51,101, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x0e60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 83, 84, 82,
/* 0x0e70 */  67, 79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 48, 50, 55, 32, 32,
/* 0x0e80 */  48, 32, 32, 48, 32, 32, 48, 51,101, 48, 32, 32, 50, 42, 42, 48,
/* 0x0e90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x0ea0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0ec0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70,
/* 0x0ed0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ee0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83,
/* 0x0ef0 */  84, 82, 67, 79, 78, 32, 48, 32, 83, 84, 82, 67, 79, 78, 10, 48,
/* 0x0f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0f10 */ 108, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x0f20 */  32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x0f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0f40 */ 100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85, 77, 70,
/* 0x0f50 */  95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f60 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70,
/* 0x0f70 */  95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48, 48, 48,
/* 0x0f80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x0f90 */  32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x0fa0 */  32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x0fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0fc0 */ 108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x0fd0 */  88, 32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x0fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0ff0 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x1000 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x1010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1020 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,103,101,116, 95,
/* 0x1030 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x1040 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x1050 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,116,114,117,110,
/* 0x1060 */  99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1070 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77,
/* 0x1080 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 49, 51, 51, 32,117,
/* 0x1090 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,
/* 0x10a0 */ 110,100,114,111,105,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x10b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x10c0 */  42, 85, 78, 68, 42, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48,
/* 0x10d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x10e0 */  32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32,
/* 0x10f0 */  48,100, 52, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x1100 */  95,102,100, 95,108,105,110,117,120, 10, 48, 48, 48, 48, 48, 48,
/* 0x1110 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x1120 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,119,114,105,116,101,
/* 0x1130 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1140 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x1150 */  48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x1160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1170 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x1180 */ 109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1190 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x11a0 */  32, 42, 85, 78, 68, 42, 32, 48, 32,111,112,101,110, 10, 10, 82,
/* 0x11b0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x11c0 */  83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58, 10,
/* 0x11d0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x11e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x11f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1200 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95,
/* 0x1210 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,117,112,120, 95,
/* 0x1220 */ 109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,
/* 0x1230 */ 111,105,100, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x1240 */ 102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1250 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1260 */  72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1270 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x1280 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x1290 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x12a0 */  48, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x12b0 */  32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x12c0 */ 100, 95,102,100, 95,108,105,110,117,120, 43, 48,120,102,102,102,
/* 0x12d0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10, 82,
/* 0x12e0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x12f0 */  83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1300 */  73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x1310 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1320 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82,
/* 0x1340 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x1350 */  32, 83, 84, 82, 67, 79, 78, 43, 48,120,102,102,102,102,102,102,
/* 0x1360 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x1370 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50,101, 32, 82, 95, 88, 56,
/* 0x1380 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,
/* 0x1390 */ 109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,
/* 0x13a0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x13b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82,
/* 0x13c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x13d0 */  32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,
/* 0x13e0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x13f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x1400 */  50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x1410 */  32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 10, 48, 48, 48, 48, 48,
/* 0x1420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 49, 32, 82, 95, 88, 56,
/* 0x1430 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,111,112,
/* 0x1440 */ 101,110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x1450 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1460 */  48, 48, 48, 48, 54,102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x1470 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43,
/* 0x1480 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1490 */  48, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x14a0 */  48, 55, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x14b0 */  51, 50, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 43, 48,120,
/* 0x14c0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x14d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x14e0 */  51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x14f0 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x1500 */ 107, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x1510 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1520 */  48, 48, 48, 97, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x1530 */  76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,
/* 0x1540 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x1550 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1560 */  48, 48, 48, 98, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x1570 */  76, 84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101,
/* 0x1580 */  95,109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x1590 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x15a0 */  48, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 88, 56, 54, 95,
/* 0x15b0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,119,114,105,116,
/* 0x15c0 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x15d0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x15e0 */  48, 48, 48,102, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x15f0 */  76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,
/* 0x1600 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x1610 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1620 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78,
/* 0x1630 */  85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x1640 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1650 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82,
/* 0x1670 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x1680 */  32, 83, 84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x1690 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 54, 10, 48, 48, 48, 48, 48,
/* 0x16a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50,101, 32, 82, 95, 88, 56,
/* 0x16b0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,
/* 0x16c0 */ 109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,
/* 0x16d0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x16e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 50, 32, 82,
/* 0x16f0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x1700 */  32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,
/* 0x1710 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x1720 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x1730 */ 102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x1740 */  32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48,
/* 0x1750 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 97, 10, 48, 48,
/* 0x1760 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,101, 32, 82,
/* 0x1770 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x1780 */  32,111,112,101,110, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x1790 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x17a0 */  48, 48, 48, 48, 48, 48, 48, 55, 49, 32, 82, 95, 88, 56, 54, 95,
/* 0x17b0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,
/* 0x17c0 */ 110, 99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x17d0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x17e0 */  48, 48, 48, 48, 48, 48, 48, 57,100, 32, 82, 95, 88, 56, 54, 95,
/* 0x17f0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112,
/* 0x1800 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x1810 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1820 */  48, 48, 97, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x1830 */  84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x1840 */ 109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x1850 */ 102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1860 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1870 */  91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x1880 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x1890 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x18a0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x18b0 */  48, 48, 48, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x18c0 */  67, 51, 50, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x18d0 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x18e0 */ 102,102, 99, 10
};
