; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-none-linux-gnu -mattr=+neon | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-none-linux-gnu -mattr=+neon -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <8 x i16> @test_sshll_v8i8(<8 x i8> %a) {
; CHECK-LABEL: test_sshll_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.8h, v0.8b, #3
; CHECK-NEXT:    ret
  %1 = sext <8 x i8> %a to <8 x i16>
  %tmp = shl <8 x i16> %1, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %tmp
}

define <8 x i16> @test_sshll_v8i8_big(<8 x i8> %a) {
; CHECK-SD-LABEL: test_sshll_v8i8_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll_v8i8_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-GI-NEXT:    ret
  %1 = sext <8 x i8> %a to <8 x i16>
  %tmp = shl <8 x i16> %1, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_sshll_v4i16(<4 x i16> %a) {
; CHECK-LABEL: test_sshll_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.4s, v0.4h, #9
; CHECK-NEXT:    ret
  %1 = sext <4 x i16> %a to <4 x i32>
  %tmp = shl <4 x i32> %1, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %tmp
}

define <4 x i32> @test_sshll_v4i16_big(<4 x i16> %a) {
; CHECK-SD-LABEL: test_sshll_v4i16_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll_v4i16_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-GI-NEXT:    ret
  %1 = sext <4 x i16> %a to <4 x i32>
  %tmp = shl <4 x i32> %1, <i32 19, i32 19, i32 19, i32 19>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_sshll_v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_sshll_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.2d, v0.2s, #19
; CHECK-NEXT:    ret
  %1 = sext <2 x i32> %a to <2 x i64>
  %tmp = shl <2 x i64> %1, <i64 19, i64 19>
  ret <2 x i64> %tmp
}

define <2 x i64> @test_sshll_v2i32_big(<2 x i32> %a) {
; CHECK-SD-LABEL: test_sshll_v2i32_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll_v2i32_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-GI-NEXT:    ret
  %1 = sext <2 x i32> %a to <2 x i64>
  %tmp = shl <2 x i64> %1, <i64 36, i64 36>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_ushll_v8i8(<8 x i8> %a) {
; CHECK-LABEL: test_ushll_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #3
; CHECK-NEXT:    ret
  %1 = zext <8 x i8> %a to <8 x i16>
  %tmp = shl <8 x i16> %1, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %tmp
}

define <8 x i16> @test_ushll_v8i8_big(<8 x i8> %a) {
; CHECK-LABEL: test_ushll_v8i8_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-NEXT:    ret
  %1 = zext <8 x i8> %a to <8 x i16>
  %tmp = shl <8 x i16> %1, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_ushll_v4i16(<4 x i16> %a) {
; CHECK-LABEL: test_ushll_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #9
; CHECK-NEXT:    ret
  %1 = zext <4 x i16> %a to <4 x i32>
  %tmp = shl <4 x i32> %1, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %tmp
}

define <4 x i32> @test_ushll_v4i16_big(<4 x i16> %a) {
; CHECK-LABEL: test_ushll_v4i16_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-NEXT:    ret
  %1 = zext <4 x i16> %a to <4 x i32>
  %tmp = shl <4 x i32> %1, <i32 19, i32 19, i32 19, i32 19>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_ushll_v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_ushll_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.2d, v0.2s, #19
; CHECK-NEXT:    ret
  %1 = zext <2 x i32> %a to <2 x i64>
  %tmp = shl <2 x i64> %1, <i64 19, i64 19>
  ret <2 x i64> %tmp
}

define <2 x i64> @test_ushll_v2i32_big(<2 x i32> %a) {
; CHECK-LABEL: test_ushll_v2i32_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-NEXT:    ret
  %1 = zext <2 x i32> %a to <2 x i64>
  %tmp = shl <2 x i64> %1, <i64 36, i64 36>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_sshll2_v16i8(<16 x i8> %a) {
; CHECK-SD-LABEL: test_sshll2_v16i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll2 v0.8h, v0.16b, #3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v16i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #3
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = sext <8 x i8> %1 to <8 x i16>
  %tmp = shl <8 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %tmp
}

define <8 x i16> @test_sshll2_v16i8_big(<16 x i8> %a) {
; CHECK-SD-LABEL: test_sshll2_v16i8_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-SD-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v16i8_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = sext <8 x i8> %1 to <8 x i16>
  %tmp = shl <8 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_sshll2_v8i16(<8 x i16> %a) {
; CHECK-SD-LABEL: test_sshll2_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll2 v0.4s, v0.8h, #9
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    sshll v0.4s, v0.4h, #9
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = sext <4 x i16> %1 to <4 x i32>
  %tmp = shl <4 x i32> %2, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %tmp
}

define <4 x i32> @test_sshll2_v8i16_big(<8 x i16> %a) {
; CHECK-SD-LABEL: test_sshll2_v8i16_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v8i16_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = sext <4 x i16> %1 to <4 x i32>
  %tmp = shl <4 x i32> %2, <i32 19, i32 19, i32 19, i32 19>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_sshll2_v4i32(<4 x i32> %a) {
; CHECK-SD-LABEL: test_sshll2_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sshll2 v0.2d, v0.4s, #19
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    sshll v0.2d, v0.2s, #19
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %2 = sext <2 x i32> %1 to <2 x i64>
  %tmp = shl <2 x i64> %2, <i64 19, i64 19>
  ret <2 x i64> %tmp
}

define <2 x i64> @test_sshll2_v4i32_big(<4 x i32> %a) {
; CHECK-SD-LABEL: test_sshll2_v4i32_big:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_sshll2_v4i32_big:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %2 = sext <2 x i32> %1 to <2 x i64>
  %tmp = shl <2 x i64> %2, <i64 36, i64 36>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_ushll2_v16i8(<16 x i8> %a) {
; CHECK-SD-LABEL: test_ushll2_v16i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.8h, v0.16b, #3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_ushll2_v16i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #3
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = zext <8 x i8> %1 to <8 x i16>
  %tmp = shl <8 x i16> %2, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %tmp
}

define <8 x i16> @test_ushll2_v16i8_big(<16 x i8> %a) {
; CHECK-LABEL: test_ushll2_v16i8_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = zext <8 x i8> %1 to <8 x i16>
  %tmp = shl <8 x i16> %2, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_ushll2_v8i16(<8 x i16> %a) {
; CHECK-SD-LABEL: test_ushll2_v8i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #9
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_ushll2_v8i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #9
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = zext <4 x i16> %1 to <4 x i32>
  %tmp = shl <4 x i32> %2, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %tmp
}

define <4 x i32> @test_ushll2_v8i16_big(<8 x i16> %a) {
; CHECK-LABEL: test_ushll2_v8i16_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-NEXT:    shl v0.4s, v0.4s, #19
; CHECK-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = zext <4 x i16> %1 to <4 x i32>
  %tmp = shl <4 x i32> %2, <i32 19, i32 19, i32 19, i32 19>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_ushll2_v4i32(<4 x i32> %a) {
; CHECK-SD-LABEL: test_ushll2_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #19
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_ushll2_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov d0, v0.d[1]
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #19
; CHECK-GI-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %2 = zext <2 x i32> %1 to <2 x i64>
  %tmp = shl <2 x i64> %2, <i64 19, i64 19>
  ret <2 x i64> %tmp
}

define <2 x i64> @test_ushll2_v4i32_big(<4 x i32> %a) {
; CHECK-LABEL: test_ushll2_v4i32_big:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-NEXT:    shl v0.2d, v0.2d, #36
; CHECK-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %2 = zext <2 x i32> %1 to <2 x i64>
  %tmp = shl <2 x i64> %2, <i64 36, i64 36>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_sshll_shl0_v8i8(<8 x i8> %a) {
; CHECK-LABEL: test_sshll_shl0_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-NEXT:    ret
  %tmp = sext <8 x i8> %a to <8 x i16>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_sshll_shl0_v4i16(<4 x i16> %a) {
; CHECK-LABEL: test_sshll_shl0_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %tmp = sext <4 x i16> %a to <4 x i32>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_sshll_shl0_v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_sshll_shl0_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %tmp = sext <2 x i32> %a to <2 x i64>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_ushll_shl0_v8i8(<8 x i8> %a) {
; CHECK-LABEL: test_ushll_shl0_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-NEXT:    ret
  %tmp = zext <8 x i8> %a to <8 x i16>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_ushll_shl0_v4i16(<4 x i16> %a) {
; CHECK-LABEL: test_ushll_shl0_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %tmp = zext <4 x i16> %a to <4 x i32>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_ushll_shl0_v2i32(<2 x i32> %a) {
; CHECK-LABEL: test_ushll_shl0_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %tmp = zext <2 x i32> %a to <2 x i64>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_sshll2_shl0_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_sshll2_shl0_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %tmp = sext <8 x i8> %1 to <8 x i16>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_sshll2_shl0_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_sshll2_shl0_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %tmp = sext <4 x i16> %1 to <4 x i32>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_sshll2_shl0_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_sshll2_shl0_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %tmp = sext <2 x i32> %1 to <2 x i64>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_ushll2_shl0_v16i8(<16 x i8> %a) {
; CHECK-LABEL: test_ushll2_shl0_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <16 x i8> %a, <16 x i8> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %tmp = zext <8 x i8> %1 to <8 x i16>
  ret <8 x i16> %tmp
}

define <4 x i32> @test_ushll2_shl0_v8i16(<8 x i16> %a) {
; CHECK-LABEL: test_ushll2_shl0_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <8 x i16> %a, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %tmp = zext <4 x i16> %1 to <4 x i32>
  ret <4 x i32> %tmp
}

define <2 x i64> @test_ushll2_shl0_v4i32(<4 x i32> %a) {
; CHECK-LABEL: test_ushll2_shl0_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-NEXT:    ret
  %1 = shufflevector <4 x i32> %a, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %tmp = zext <2 x i32> %1 to <2 x i64>
  ret <2 x i64> %tmp
}

define <8 x i16> @test_ushll_cmp(<8 x i8> %a, <8 x i8> %b) #0 {
; CHECK-SD-LABEL: test_ushll_cmp:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test_ushll_cmp:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    movi v1.2d, #0xff00ff00ff00ff
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    shl v0.8h, v0.8h, #15
; CHECK-GI-NEXT:    sshr v0.8h, v0.8h, #15
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %cmp.i = icmp eq <8 x i8> %a, %b
  %vcgtz.i.i = sext <8 x i1> %cmp.i to <8 x i8>
  %vmovl.i.i.i = zext <8 x i8> %vcgtz.i.i to <8 x i16>
  ret <8 x i16> %vmovl.i.i.i
}
