# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mattr=+rva23u64,+zfh -mcpu=generic-ooo -iterations=1 < %s | FileCheck %s

# Floating-Point Load and Store Instructions
## Half-Precision
flh ft0, 0(a0)
fsh ft0, 0(a0)

## Single-Precision
flw ft0, 0(a0)
fsw ft0, 0(a0)

## Double-Precision
fld ft0, 0(a0)
fsd ft0, 0(a0)

# Floating-Point Computational Instructions
## Half-Precision
fadd.h f26, f27, f28
fsub.h f29, f30, f31
fmul.h ft0, ft1, ft2
fdiv.h ft3, ft4, ft5
fsqrt.h ft6, ft7
fmin.h fa5, fa6, fa7
fmax.h fs2, fs3, fs4
fmadd.h f10, f11, f12, f31
fmsub.h f14, f15, f16, f17
fnmsub.h f18, f19, f20, f21
fnmadd.h f22, f23, f24, f25

## Single-Precision
fadd.s f26, f27, f28
fsub.s f29, f30, f31
fmul.s ft0, ft1, ft2
fdiv.s ft3, ft4, ft5
fsqrt.s ft6, ft7
fmin.s fa5, fa6, fa7
fmax.s fs2, fs3, fs4
fmadd.s f10, f11, f12, f31
fmsub.s f14, f15, f16, f17
fnmsub.s f18, f19, f20, f21
fnmadd.s f22, f23, f24, f25

## Double-Precision
fadd.d f26, f27, f28
fsub.d f29, f30, f31
fmul.d ft0, ft1, ft2
fdiv.d ft3, ft4, ft5
fsqrt.d ft6, ft7
fmin.d fa5, fa6, fa7
fmax.d fs2, fs3, fs4
fmadd.d f10, f11, f12, f31
fmsub.d f14, f15, f16, f17
fnmsub.d f18, f19, f20, f21
fnmadd.d f22, f23, f24, f25

# Floating-Point Conversion and Move Instructions
## Half-Precision
fmv.x.h a2, fs7
fmv.h.x ft1, a6

fcvt.s.h fa0, ft0
fcvt.s.h fa0, ft0, rup

fcvt.h.s ft2, fa2
fcvt.d.h fa0, ft0

fcvt.d.h fa0, ft0, rup
fcvt.h.d ft2, fa2

## Single-Precision
fcvt.w.s a0, fs5
fcvt.wu.s a1, fs6
fcvt.s.w ft11, a4
fcvt.s.wu ft0, a5

fcvt.l.s a0, ft0
fcvt.lu.s a1, ft1
fcvt.s.l ft2, a2
fcvt.s.lu ft3, a3

fmv.x.w a2, fs7
fmv.w.x ft1, a6

fsgnj.s fs1, fa0, fa1
fsgnjn.s fa1, fa3, fa4

## Double-Precision
fcvt.wu.d a4, ft11
fcvt.w.d a4, ft11
fcvt.d.w ft0, a5
fcvt.d.wu ft1, a6

fcvt.s.d fs5, fs6
fcvt.d.s fs7, fs8

fcvt.l.d a0, ft0
fcvt.lu.d a1, ft1
fcvt.d.l ft3, a3
fcvt.d.lu ft4, a4

fmv.x.d a2, ft2
fmv.d.x ft5, a5

fsgnj.d fs1, fa0, fa1
fsgnjn.d fa1, fa3, fa4

# Floating-Point Compare Instructions
## Half-Precision
feq.h a1, fs8, fs9
flt.h a2, fs10, fs11
fle.h a3, ft8, ft9

## Single-Precision
feq.s a1, fs8, fs9
flt.s a2, fs10, fs11
fle.s a3, ft8, ft9

## Double-Precision
feq.d a1, fs8, fs9
flt.d a2, fs10, fs11
fle.d a3, ft8, ft9

# Floating-Point Classify Instruction
## Half-Precision
fclass.s a3, ft10
## Single-Precision
fclass.s a3, ft10
## Double-Precision
fclass.d a3, ft10

# Zfa
## Load-Immediate Instructions
fli.h ft1, -1.0
fli.s ft1, -1.0
fli.d ft1, -1.0

## Minimum and Maximum Instructions
fminm.h fa0, fa1, fa2
fmaxm.h fs3, fs4, fs5

fminm.s fa0, fa1, fa2
fmaxm.s fs3, fs4, fs5

fminm.d fa0, fa1, fa2
fmaxm.d fs3, fs4, fs5

## Round-to-Integer Instructions
fround.h fs1, fs2
froundnx.h fs1, fs2

fround.s fs1, fs2
froundnx.s fs1, fs2

fround.d fs1, fs2
froundnx.d fs1, fs2

## Modular Convert-to-Integer Instruction
fcvtmod.w.d a1, ft1, rtz

## Comparison Instructions
fltq.h a1, fs1, fs2
fleq.h a1, ft1, ft2
fgtq.h a1, fs1, fs2
fgeq.h a1, ft1, ft2

fltq.s a1, fs1, fs2
fleq.s a1, ft1, ft2
fgtq.s a1, fs1, fs2
fgeq.s a1, ft1, ft2

fltq.d a1, fs1, fs2
fleq.d a1, ft1, ft2
fgtq.d a1, fs1, fs2
fgeq.d a1, ft1, ft2

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      113
# CHECK-NEXT: Total Cycles:      107
# CHECK-NEXT: Total uOps:        113

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    1.06
# CHECK-NEXT: IPC:               1.06
# CHECK-NEXT: Block RThroughput: 93.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     0.50    *                   flh	ft0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            fsh	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   flw	ft0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            fsw	ft0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                   fld	ft0, 0(a0)
# CHECK-NEXT:  1      1     0.50           *            fsd	ft0, 0(a0)
# CHECK-NEXT:  1      2     0.50                        fadd.h	fs10, fs11, ft8
# CHECK-NEXT:  1      2     0.50                        fsub.h	ft9, ft10, ft11
# CHECK-NEXT:  1      4     1.00                        fmul.h	ft0, ft1, ft2
# CHECK-NEXT:  1      9     9.00                        fdiv.h	ft3, ft4, ft5
# CHECK-NEXT:  1      9     9.00                        fsqrt.h	ft6, ft7
# CHECK-NEXT:  1      1     0.50                        fmin.h	fa5, fa6, fa7
# CHECK-NEXT:  1      1     0.50                        fmax.h	fs2, fs3, fs4
# CHECK-NEXT:  1      6     1.00                        fmadd.h	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      6     1.00                        fmsub.h	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      6     1.00                        fnmsub.h	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      6     1.00                        fnmadd.h	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        fadd.s	fs10, fs11, ft8
# CHECK-NEXT:  1      2     0.50                        fsub.s	ft9, ft10, ft11
# CHECK-NEXT:  1      4     1.00                        fmul.s	ft0, ft1, ft2
# CHECK-NEXT:  1      13    13.00                       fdiv.s	ft3, ft4, ft5
# CHECK-NEXT:  1      13    13.00                       fsqrt.s	ft6, ft7
# CHECK-NEXT:  1      1     0.50                        fmin.s	fa5, fa6, fa7
# CHECK-NEXT:  1      1     0.50                        fmax.s	fs2, fs3, fs4
# CHECK-NEXT:  1      6     1.00                        fmadd.s	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      6     1.00                        fmsub.s	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      6     1.00                        fnmsub.s	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      6     1.00                        fnmadd.s	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        fadd.d	fs10, fs11, ft8
# CHECK-NEXT:  1      2     0.50                        fsub.d	ft9, ft10, ft11
# CHECK-NEXT:  1      4     1.00                        fmul.d	ft0, ft1, ft2
# CHECK-NEXT:  1      17    17.00                       fdiv.d	ft3, ft4, ft5
# CHECK-NEXT:  1      17    17.00                       fsqrt.d	ft6, ft7
# CHECK-NEXT:  1      1     0.50                        fmin.d	fa5, fa6, fa7
# CHECK-NEXT:  1      1     0.50                        fmax.d	fs2, fs3, fs4
# CHECK-NEXT:  1      6     1.00                        fmadd.d	fa0, fa1, fa2, ft11
# CHECK-NEXT:  1      6     1.00                        fmsub.d	fa4, fa5, fa6, fa7
# CHECK-NEXT:  1      6     1.00                        fnmsub.d	fs2, fs3, fs4, fs5
# CHECK-NEXT:  1      6     1.00                        fnmadd.d	fs6, fs7, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        fmv.x.h	a2, fs7
# CHECK-NEXT:  1      2     0.50                        fmv.h.x	ft1, a6
# CHECK-NEXT:  1      2     0.50                        fcvt.s.h	fa0, ft0
# CHECK-NEXT:  1      2     0.50                        fcvt.s.h	fa0, ft0, rup
# CHECK-NEXT:  1      2     0.50                        fcvt.h.s	ft2, fa2
# CHECK-NEXT:  1      2     0.50                        fcvt.d.h	fa0, ft0
# CHECK-NEXT:  1      2     0.50                        fcvt.d.h	fa0, ft0, rup
# CHECK-NEXT:  1      2     0.50                        fcvt.h.d	ft2, fa2
# CHECK-NEXT:  1      2     0.50                        fcvt.w.s	a0, fs5
# CHECK-NEXT:  1      2     0.50                        fcvt.wu.s	a1, fs6
# CHECK-NEXT:  1      2     0.50                        fcvt.s.w	ft11, a4
# CHECK-NEXT:  1      2     0.50                        fcvt.s.wu	ft0, a5
# CHECK-NEXT:  1      2     0.50                        fcvt.l.s	a0, ft0
# CHECK-NEXT:  1      2     0.50                        fcvt.lu.s	a1, ft1
# CHECK-NEXT:  1      2     0.50                        fcvt.s.l	ft2, a2
# CHECK-NEXT:  1      2     0.50                        fcvt.s.lu	ft3, a3
# CHECK-NEXT:  1      2     0.50                        fmv.x.w	a2, fs7
# CHECK-NEXT:  1      2     0.50                        fmv.w.x	ft1, a6
# CHECK-NEXT:  1      1     0.50                        fsgnj.s	fs1, fa0, fa1
# CHECK-NEXT:  1      1     0.50                        fsgnjn.s	fa1, fa3, fa4
# CHECK-NEXT:  1      2     0.50                        fcvt.wu.d	a4, ft11
# CHECK-NEXT:  1      2     0.50                        fcvt.w.d	a4, ft11
# CHECK-NEXT:  1      2     0.50                        fcvt.d.w	ft0, a5
# CHECK-NEXT:  1      2     0.50                        fcvt.d.wu	ft1, a6
# CHECK-NEXT:  1      2     0.50                        fcvt.s.d	fs5, fs6
# CHECK-NEXT:  1      2     0.50                        fcvt.d.s	fs7, fs8
# CHECK-NEXT:  1      2     0.50                        fcvt.l.d	a0, ft0
# CHECK-NEXT:  1      2     0.50                        fcvt.lu.d	a1, ft1
# CHECK-NEXT:  1      2     0.50                        fcvt.d.l	ft3, a3
# CHECK-NEXT:  1      2     0.50                        fcvt.d.lu	ft4, a4
# CHECK-NEXT:  1      2     0.50                        fmv.x.d	a2, ft2
# CHECK-NEXT:  1      2     0.50                        fmv.d.x	ft5, a5
# CHECK-NEXT:  1      1     0.50                        fsgnj.d	fs1, fa0, fa1
# CHECK-NEXT:  1      1     0.50                        fsgnjn.d	fa1, fa3, fa4
# CHECK-NEXT:  1      2     0.50                        feq.h	a1, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        flt.h	a2, fs10, fs11
# CHECK-NEXT:  1      2     0.50                        fle.h	a3, ft8, ft9
# CHECK-NEXT:  1      2     0.50                        feq.s	a1, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        flt.s	a2, fs10, fs11
# CHECK-NEXT:  1      2     0.50                        fle.s	a3, ft8, ft9
# CHECK-NEXT:  1      2     0.50                        feq.d	a1, fs8, fs9
# CHECK-NEXT:  1      2     0.50                        flt.d	a2, fs10, fs11
# CHECK-NEXT:  1      2     0.50                        fle.d	a3, ft8, ft9
# CHECK-NEXT:  1      1     0.50                        fclass.s	a3, ft10
# CHECK-NEXT:  1      1     0.50                        fclass.s	a3, ft10
# CHECK-NEXT:  1      1     0.50                        fclass.d	a3, ft10
# CHECK-NEXT:  1      2     0.50                        fli.h	ft1, -1.0
# CHECK-NEXT:  1      2     0.50                        fli.s	ft1, -1.0
# CHECK-NEXT:  1      2     0.50                        fli.d	ft1, -1.0
# CHECK-NEXT:  1      1     0.50                        fminm.h	fa0, fa1, fa2
# CHECK-NEXT:  1      1     0.50                        fmaxm.h	fs3, fs4, fs5
# CHECK-NEXT:  1      1     0.50                        fminm.s	fa0, fa1, fa2
# CHECK-NEXT:  1      1     0.50                        fmaxm.s	fs3, fs4, fs5
# CHECK-NEXT:  1      1     0.50                        fminm.d	fa0, fa1, fa2
# CHECK-NEXT:  1      1     0.50                        fmaxm.d	fs3, fs4, fs5
# CHECK-NEXT:  1      2     0.50                        fround.h	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        froundnx.h	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fround.s	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        froundnx.s	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fround.d	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        froundnx.d	fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fcvtmod.w.d	a1, ft1, rtz
# CHECK-NEXT:  1      2     0.50                        fltq.h	a1, fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fleq.h	a1, ft1, ft2
# CHECK-NEXT:  1      2     0.50                        fltq.h	a1, fs2, fs1
# CHECK-NEXT:  1      2     0.50                        fleq.h	a1, ft2, ft1
# CHECK-NEXT:  1      2     0.50                        fltq.s	a1, fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fleq.s	a1, ft1, ft2
# CHECK-NEXT:  1      2     0.50                        fltq.s	a1, fs2, fs1
# CHECK-NEXT:  1      2     0.50                        fleq.s	a1, ft2, ft1
# CHECK-NEXT:  1      2     0.50                        fltq.d	a1, fs1, fs2
# CHECK-NEXT:  1      2     0.50                        fleq.d	a1, ft1, ft2
# CHECK-NEXT:  1      2     0.50                        fltq.d	a1, fs2, fs1
# CHECK-NEXT:  1      2     0.50                        fleq.d	a1, ft2, ft1

# CHECK:      Resources:
# CHECK-NEXT: [0]   - GenericOOOBranch
# CHECK-NEXT: [1]   - GenericOOOFMulDiv
# CHECK-NEXT: [2]   - GenericOOOFloat
# CHECK-NEXT: [3.0] - GenericOOOInt
# CHECK-NEXT: [3.1] - GenericOOOInt
# CHECK-NEXT: [4.0] - GenericOOOLSU
# CHECK-NEXT: [4.1] - GenericOOOLSU
# CHECK-NEXT: [5]   - GenericOOOMulDiv

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]
# CHECK-NEXT:  -     99.00  80.00   -      -     3.00   3.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     flh	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     fsh	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     flw	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     fsw	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     fld	ft0, 0(a0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     fsd	ft0, 0(a0)
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fadd.h	fs10, fs11, ft8
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fsub.h	ft9, ft10, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmul.h	ft0, ft1, ft2
# CHECK-NEXT:  -     9.00    -      -      -      -      -      -     fdiv.h	ft3, ft4, ft5
# CHECK-NEXT:  -     9.00    -      -      -      -      -      -     fsqrt.h	ft6, ft7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmin.h	fa5, fa6, fa7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmax.h	fs2, fs3, fs4
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmadd.h	fa0, fa1, fa2, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmsub.h	fa4, fa5, fa6, fa7
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmsub.h	fs2, fs3, fs4, fs5
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmadd.h	fs6, fs7, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fadd.s	fs10, fs11, ft8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fsub.s	ft9, ft10, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmul.s	ft0, ft1, ft2
# CHECK-NEXT:  -     13.00   -      -      -      -      -      -     fdiv.s	ft3, ft4, ft5
# CHECK-NEXT:  -     13.00   -      -      -      -      -      -     fsqrt.s	ft6, ft7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmin.s	fa5, fa6, fa7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmax.s	fs2, fs3, fs4
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmadd.s	fa0, fa1, fa2, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmsub.s	fa4, fa5, fa6, fa7
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmsub.s	fs2, fs3, fs4, fs5
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmadd.s	fs6, fs7, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fadd.d	fs10, fs11, ft8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fsub.d	ft9, ft10, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmul.d	ft0, ft1, ft2
# CHECK-NEXT:  -     17.00   -      -      -      -      -      -     fdiv.d	ft3, ft4, ft5
# CHECK-NEXT:  -     17.00   -      -      -      -      -      -     fsqrt.d	ft6, ft7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmin.d	fa5, fa6, fa7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmax.d	fs2, fs3, fs4
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmadd.d	fa0, fa1, fa2, ft11
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmsub.d	fa4, fa5, fa6, fa7
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmsub.d	fs2, fs3, fs4, fs5
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fnmadd.d	fs6, fs7, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.x.h	a2, fs7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.h.x	ft1, a6
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.h	fa0, ft0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.h	fa0, ft0, rup
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.h.s	ft2, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.h	fa0, ft0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.h	fa0, ft0, rup
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.h.d	ft2, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.w.s	a0, fs5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.wu.s	a1, fs6
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.w	ft11, a4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.wu	ft0, a5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.l.s	a0, ft0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.lu.s	a1, ft1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.l	ft2, a2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.s.lu	ft3, a3
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.x.w	a2, fs7
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.w.x	ft1, a6
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fsgnj.s	fs1, fa0, fa1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fsgnjn.s	fa1, fa3, fa4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.wu.d	a4, ft11
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.w.d	a4, ft11
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.w	ft0, a5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.wu	ft1, a6
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fcvt.s.d	fs5, fs6
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.s	fs7, fs8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.l.d	a0, ft0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.lu.d	a1, ft1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.l	ft3, a3
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvt.d.lu	ft4, a4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.x.d	a2, ft2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmv.d.x	ft5, a5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fsgnj.d	fs1, fa0, fa1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fsgnjn.d	fa1, fa3, fa4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     feq.h	a1, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     flt.h	a2, fs10, fs11
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fle.h	a3, ft8, ft9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     feq.s	a1, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     flt.s	a2, fs10, fs11
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fle.s	a3, ft8, ft9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     feq.d	a1, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     flt.d	a2, fs10, fs11
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fle.d	a3, ft8, ft9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fclass.s	a3, ft10
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fclass.s	a3, ft10
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fclass.d	a3, ft10
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fli.h	ft1, -1.0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fli.s	ft1, -1.0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fli.d	ft1, -1.0
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fminm.h	fa0, fa1, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmaxm.h	fs3, fs4, fs5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fminm.s	fa0, fa1, fa2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fmaxm.s	fs3, fs4, fs5
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     fminm.d	fa0, fa1, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fmaxm.d	fs3, fs4, fs5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fround.h	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     froundnx.h	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fround.s	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     froundnx.s	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fround.d	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     froundnx.d	fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fcvtmod.w.d	a1, ft1, rtz
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.h	a1, fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.h	a1, ft1, ft2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.h	a1, fs2, fs1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.h	a1, ft2, ft1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.s	a1, fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.s	a1, ft1, ft2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.s	a1, fs2, fs1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.s	a1, ft2, ft1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.d	a1, fs1, fs2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.d	a1, ft1, ft2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fltq.d	a1, fs2, fs1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     fleq.d	a1, ft2, ft1
