; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals smart
;; Tests that when InstCombine sets a DILocation on the new instruction when it
;; is created, we do not try to overwrite that DILocation when we later insert
;; the new instruction.
;; In this test, InstCombine replaces two loads joined by a PHI into a PHI of
;; the addresses followed by a load, and gives the new load a merge of the two
;; incoming load DILocations. This test verifies that the new load keeps that
;; DILocation, and doesn't have it overwritten by the DILocation of the original
;; PHI. It will, however, receive the !annotation attached to the original PHI.
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define void @test(ptr %xfA, ptr %xfB, i1 %cmp5) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP5:%.*]], label [[IF_ELSE:%.*]], label [[IF_THEN6:%.*]]
; CHECK:       if.then6:
; CHECK-NEXT:    br label [[IF_END11:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END11]]
; CHECK:       if.end11:
; CHECK-NEXT:    [[XFA_PN:%.*]] = phi ptr [ [[XFA:%.*]], [[IF_ELSE]] ], [ [[XFB:%.*]], [[IF_THEN6]] ]
; CHECK-NEXT:    [[XF1_SROA_8_0_IN:%.*]] = getelementptr i8, ptr [[XFA_PN]], i64 4
; CHECK-NEXT:    [[XF1_SROA_8_0:%.*]] = load float, ptr [[XF1_SROA_8_0_IN]], align 4, !dbg [[DBG3:![0-9]+]], !annotation [[META7:![0-9]+]]
; CHECK-NEXT:    [[CMP_I:%.*]] = fcmp ugt float [[XF1_SROA_8_0]], 0.000000e+00
; CHECK-NEXT:    br i1 [[CMP_I]], label [[IF_END_I:%.*]], label [[IF_THEN_I:%.*]]
; CHECK:       if.then.i:
; CHECK-NEXT:    br label [[IF_END_I]]
; CHECK:       if.end.i:
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cmp5, label %if.else, label %if.then6

if.then6:                                         ; preds = %entry
  %xf1.sroa.8.0.xfB.sroa_idx = getelementptr i8, ptr %xfB, i64 4
  %xf1.sroa.8.0.copyload = load float, ptr %xf1.sroa.8.0.xfB.sroa_idx, align 4, !dbg !3
  br label %if.end11

if.else:                                          ; preds = %entry
  %xf1.sroa.8.0.xfA.sroa_idx = getelementptr i8, ptr %xfA, i64 4
  %xf1.sroa.8.0.copyload494 = load float, ptr %xf1.sroa.8.0.xfA.sroa_idx, align 4, !dbg !7
  br label %if.end11

if.end11:                                         ; preds = %if.else, %if.then6
  %xf1.sroa.8.0 = phi float [ %xf1.sroa.8.0.copyload494, %if.else ], [ %xf1.sroa.8.0.copyload, %if.then6 ], !dbg !8, !annotation !9
  %cmp.i = fcmp ugt float %xf1.sroa.8.0, 0.000000e+00
  br i1 %cmp.i, label %if.end.i, label %if.then.i

if.then.i:                                        ; preds = %if.end11
  br label %if.end.i

if.end.i:                                         ; preds = %if.then.i, %if.end11
  ret void
}

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!2}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, producer: "clang version 20.0.0git", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug)
!1 = !DIFile(filename: "test.cpp", directory: "/tmp")
!2 = !{i32 2, !"Debug Info Version", i32 3}
!3 = !DILocation(line: 13, column: 12, scope: !4)
!4 = distinct !DISubprogram(name: "operator=", linkageName: "_ZN11btMatrix3x3aSERKS_", scope: null, file: !1, line: 61, type: !5, scopeLine: 62, spFlags: DISPFlagDefinition, unit: !0, retainedNodes: !6)
!5 = distinct !DISubroutineType(types: !6)
!6 = !{}
!7 = !DILocation(line: 13, column: 15, scope: !4)
!8 = !DILocation(line: 100, scope: !4)
!9 = !{!"Test String"}
;.
; CHECK: [[META0:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: [[META1:![0-9]+]], producer: "{{.*}}clang version {{.*}}", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug)
; CHECK: [[META1]] = !DIFile(filename: "test.cpp", directory: {{.*}})
; CHECK: [[DBG3]] = !DILocation(line: 13, scope: [[META4:![0-9]+]])
; CHECK: [[META4]] = distinct !DISubprogram(name: "operator=", linkageName: "_ZN11btMatrix3x3aSERKS_", scope: null, file: [[META1]], line: 61, type: [[META5:![0-9]+]], scopeLine: 62, spFlags: DISPFlagDefinition, unit: [[META0]], retainedNodes: [[META6:![0-9]+]])
; CHECK: [[META5]] = distinct !DISubroutineType(types: [[META6]])
; CHECK: [[META6]] = !{}
; CHECK: [[META7]] = !{!"Test String"}
;.
