; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+32s,+f,-d < %s | FileCheck %s --check-prefix=LA32F
; RUN: llc --mtriple=loongarch32 --mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32D
; RUN: llc --mtriple=loongarch64 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA64F
; RUN: llc --mtriple=loongarch64 --mattr=+d < %s | FileCheck %s --check-prefix=LA64D

define float @fldx_s(ptr %a, i64 %idx) nounwind {
; LA32F-LABEL: fldx_s:
; LA32F:       # %bb.0:
; LA32F-NEXT:    slli.w $a1, $a1, 2
; LA32F-NEXT:    fldx.s $fa0, $a0, $a1
; LA32F-NEXT:    ret
;
; LA32D-LABEL: fldx_s:
; LA32D:       # %bb.0:
; LA32D-NEXT:    slli.w $a1, $a1, 2
; LA32D-NEXT:    fldx.s $fa0, $a0, $a1
; LA32D-NEXT:    ret
;
; LA64F-LABEL: fldx_s:
; LA64F:       # %bb.0:
; LA64F-NEXT:    slli.d $a1, $a1, 2
; LA64F-NEXT:    fldx.s $fa0, $a0, $a1
; LA64F-NEXT:    ret
;
; LA64D-LABEL: fldx_s:
; LA64D:       # %bb.0:
; LA64D-NEXT:    slli.d $a1, $a1, 2
; LA64D-NEXT:    fldx.s $fa0, $a0, $a1
; LA64D-NEXT:    ret
  %1 = getelementptr float, ptr %a, i64 %idx
  %2 = load float, ptr %1
  ret float %2
}

define double @fldx_d(ptr %a, i64 %idx) nounwind {
; LA32F-LABEL: fldx_d:
; LA32F:       # %bb.0:
; LA32F-NEXT:    alsl.w $a1, $a1, $a0, 3
; LA32F-NEXT:    ld.w $a0, $a1, 0
; LA32F-NEXT:    ld.w $a1, $a1, 4
; LA32F-NEXT:    ret
;
; LA32D-LABEL: fldx_d:
; LA32D:       # %bb.0:
; LA32D-NEXT:    slli.w $a1, $a1, 3
; LA32D-NEXT:    fldx.d $fa0, $a0, $a1
; LA32D-NEXT:    ret
;
; LA64F-LABEL: fldx_d:
; LA64F:       # %bb.0:
; LA64F-NEXT:    slli.d $a1, $a1, 3
; LA64F-NEXT:    ldx.d $a0, $a0, $a1
; LA64F-NEXT:    ret
;
; LA64D-LABEL: fldx_d:
; LA64D:       # %bb.0:
; LA64D-NEXT:    slli.d $a1, $a1, 3
; LA64D-NEXT:    fldx.d $fa0, $a0, $a1
; LA64D-NEXT:    ret
  %1 = getelementptr double, ptr %a, i64 %idx
  %2 = load double, ptr %1
  ret double %2
}

define void @fstx_s(ptr %dst, i64 %idx, float %val) nounwind {
; LA32F-LABEL: fstx_s:
; LA32F:       # %bb.0:
; LA32F-NEXT:    slli.w $a1, $a1, 2
; LA32F-NEXT:    fstx.s $fa0, $a0, $a1
; LA32F-NEXT:    ret
;
; LA32D-LABEL: fstx_s:
; LA32D:       # %bb.0:
; LA32D-NEXT:    slli.w $a1, $a1, 2
; LA32D-NEXT:    fstx.s $fa0, $a0, $a1
; LA32D-NEXT:    ret
;
; LA64F-LABEL: fstx_s:
; LA64F:       # %bb.0:
; LA64F-NEXT:    slli.d $a1, $a1, 2
; LA64F-NEXT:    fstx.s $fa0, $a0, $a1
; LA64F-NEXT:    ret
;
; LA64D-LABEL: fstx_s:
; LA64D:       # %bb.0:
; LA64D-NEXT:    slli.d $a1, $a1, 2
; LA64D-NEXT:    fstx.s $fa0, $a0, $a1
; LA64D-NEXT:    ret
  %1 = getelementptr float, ptr %dst, i64 %idx
  store float %val, ptr %1
  ret void
}

define void @fstx_d(ptr %dst, i64 %idx, double %val) nounwind {
; LA32F-LABEL: fstx_d:
; LA32F:       # %bb.0:
; LA32F-NEXT:    alsl.w $a0, $a1, $a0, 3
; LA32F-NEXT:    st.w $a4, $a0, 4
; LA32F-NEXT:    st.w $a3, $a0, 0
; LA32F-NEXT:    ret
;
; LA32D-LABEL: fstx_d:
; LA32D:       # %bb.0:
; LA32D-NEXT:    slli.w $a1, $a1, 3
; LA32D-NEXT:    fstx.d $fa0, $a0, $a1
; LA32D-NEXT:    ret
;
; LA64F-LABEL: fstx_d:
; LA64F:       # %bb.0:
; LA64F-NEXT:    slli.d $a1, $a1, 3
; LA64F-NEXT:    stx.d $a2, $a0, $a1
; LA64F-NEXT:    ret
;
; LA64D-LABEL: fstx_d:
; LA64D:       # %bb.0:
; LA64D-NEXT:    slli.d $a1, $a1, 3
; LA64D-NEXT:    fstx.d $fa0, $a0, $a1
; LA64D-NEXT:    ret
  %1 = getelementptr double, ptr %dst, i64 %idx
  store double %val, ptr %1
  ret void
}
