; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -amdgpu-opt-vgpr-liverange=true -stop-after=si-opt-vgpr-liverange -verify-machineinstrs < %s | FileCheck -check-prefix=SI %s

; a normal if-else
define amdgpu_ps float @else1(i32 %z, float %v) #0 {
  ; SI-LABEL: name: else1
  ; SI: bb.0.main_body:
  ; SI-NEXT:   successors: %bb.3(0x40000000), %bb.1(0x40000000)
  ; SI-NEXT:   liveins: $vgpr0, $vgpr1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY1]], implicit $exec
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.3
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.Flow:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.4(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %9:vgpr_32, %bb.0, %4, %bb.3
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.0, undef %14:vgpr_32, %bb.3
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.4, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.if:
  ; SI-NEXT:   successors: %bb.4(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[PHI1]], 0, [[PHI1]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.4
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3.else:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_MUL_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_MUL_F32_e64 0, 1077936128, 0, killed [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4.end:
  ; SI-NEXT:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[V_ADD_F32_e64_]], %bb.2
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   $vgpr0 = COPY killed [[PHI2]]
  ; SI-NEXT:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = fmul float %v, 2.0
  br label %end

else:
  %v.else = fmul float %v, 3.0
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  ret float %r
}


; %v was used after if-else
define amdgpu_ps float @else2(i32 %z, float %v) #0 {
  ; SI-LABEL: name: else2
  ; SI: bb.0.main_body:
  ; SI-NEXT:   successors: %bb.3(0x40000000), %bb.1(0x40000000)
  ; SI-NEXT:   liveins: $vgpr0, $vgpr1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY1]], implicit $exec
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.3
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.Flow:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.4(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %10:vgpr_32, %bb.0, %4, %bb.3
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.4, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.if:
  ; SI-NEXT:   successors: %bb.4(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[COPY]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.4
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3.else:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_MUL_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_MUL_F32_e64 0, 1077936128, 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4.end:
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.1, [[V_ADD_F32_e64_]], %bb.2
  ; SI-NEXT:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[V_ADD_F32_e64_]], %bb.2
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   [[V_ADD_F32_e64_1:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[PHI1]], 0, killed [[PHI2]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   $vgpr0 = COPY killed [[V_ADD_F32_e64_1]]
  ; SI-NEXT:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = fmul float %v, 2.0
  br label %end

else:
  %v.else = fmul float %v, 3.0
  br label %end

end:
  %r0 = phi float [ %v.if, %if ], [ %v, %else ]
  %r1 = phi float [ %v.if, %if ], [ %v.else, %else ]
  %r2 = fadd float %r0, %r1
  ret float %r2
}

; if-else inside loop, %x can be optimized, but %v cannot be.
define amdgpu_ps float @else3(i32 %z, float %v, i32 inreg %bound, i32 %x0) #0 {
  ; SI-LABEL: name: else3
  ; SI: bb.0.entry:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT:   liveins: $vgpr0, $vgpr1, $sgpr0, $vgpr2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY killed $sgpr0
  ; SI-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY3]], implicit $exec
  ; SI-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.for.body:
  ; SI-NEXT:   successors: %bb.4(0x40000000), %bb.2(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:sreg_32 = PHI [[S_MOV_B32_]], %bb.0, %14, %bb.5
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.0, %13, %bb.5
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF [[V_CMP_GT_I32_e64_]], %bb.2, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.4
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.Flow:
  ; SI-NEXT:   successors: %bb.3(0x40000000), %bb.5(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI undef %25:vgpr_32, %bb.1, %10, %bb.4
  ; SI-NEXT:   [[PHI3:%[0-9]+]]:vgpr_32 = PHI undef %26:vgpr_32, %bb.1, %9, %bb.4
  ; SI-NEXT:   [[PHI4:%[0-9]+]]:vgpr_32 = PHI [[PHI1]], %bb.1, undef %32:vgpr_32, %bb.4
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.5, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.3
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3.if:
  ; SI-NEXT:   successors: %bb.5(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_MUL_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_MUL_F32_e64 0, [[PHI]], 0, [[COPY2]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 1, killed [[PHI4]], 0, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4.else:
  ; SI-NEXT:   successors: %bb.2(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_MUL_F32_e64_1:%[0-9]+]]:vgpr_32 = nofpexcept V_MUL_F32_e64 0, [[COPY2]], 0, [[PHI1]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   [[V_LSHL_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_LSHL_ADD_U32_e64 killed [[PHI1]], 1, [[PHI1]], implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.5.if.end:
  ; SI-NEXT:   successors: %bb.6(0x04000000), %bb.1(0x7c000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI [[PHI3]], %bb.2, [[V_MUL_F32_e64_]], %bb.3
  ; SI-NEXT:   [[PHI6:%[0-9]+]]:vgpr_32 = PHI [[PHI2]], %bb.2, [[V_ADD_U32_e64_]], %bb.3
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 1, [[PHI6]], 0, implicit $exec
  ; SI-NEXT:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 killed [[PHI]], 1, implicit-def dead $scc
  ; SI-NEXT:   S_CMP_LT_I32 [[S_ADD_I32_]], [[COPY1]], implicit-def $scc
  ; SI-NEXT:   S_CBRANCH_SCC1 %bb.1, implicit killed $scc
  ; SI-NEXT:   S_BRANCH %bb.6
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.6.for.end:
  ; SI-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[PHI6]], 0, killed [[PHI5]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   $vgpr0 = COPY killed [[V_ADD_F32_e64_]]
  ; SI-NEXT:   SI_RETURN_TO_EPILOG killed $vgpr0
entry:
  br label %for.body

for.body:
  %i = phi i32 [ 0, %entry ], [ %inc, %if.end ]
  %x = phi i32 [ %x0, %entry ], [ %xinc, %if.end ]
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %i.tmp = bitcast i32 %i to float
  %v.if = fmul float %v, %i.tmp
  %x.if = add i32 %x, 1
  br label %if.end

else:
  %x.tmp = bitcast i32 %x to float
  %v.else = fmul float %v, %x.tmp
  %x.else = mul i32 %x, 3
  br label %if.end

if.end:
  %v.endif = phi float [ %v.if, %if ], [ %v.else, %else ]
  %x.endif = phi i32 [ %x.if, %if ], [ %x.else, %else ]

  %xinc = add i32 %x.endif, 1
  %inc = add i32 %i, 1
  %cond = icmp slt i32 %inc, %bound
  br i1 %cond, label %for.body, label %for.end

for.end:
  %x_float = bitcast i32 %x.endif to float
  %r = fadd float %x_float, %v.endif
  ret float %r
}

; a loop inside an if-else
define amdgpu_ps float @loop(i32 %z, float %v, i32 inreg %bound, ptr %extern_func, ptr %extern_func2) #0 {
  ; SI-LABEL: name: loop
  ; SI: bb.0.main_body:
  ; SI-NEXT:   successors: %bb.6(0x40000000), %bb.1(0x40000000)
  ; SI-NEXT:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr5
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr4
  ; SI-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr3
  ; SI-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY5]], implicit $exec
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.6
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.Flow:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.10(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %16:vgpr_32, %bb.0, %4, %bb.9
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY4]], %bb.0, undef %48:vgpr_32, %bb.9
  ; SI-NEXT:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[COPY3]], %bb.0, undef %50:vgpr_32, %bb.9
  ; SI-NEXT:   [[PHI3:%[0-9]+]]:vgpr_32 = PHI [[COPY2]], %bb.0, undef %52:vgpr_32, %bb.9
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.10, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.if:
  ; SI-NEXT:   successors: %bb.3(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[PHI2]], %subreg.sub0, killed [[PHI3]], %subreg.sub1
  ; SI-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT:   [[COPY6:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3:
  ; SI-NEXT:   successors: %bb.4(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI4:%[0-9]+]]:vreg_64 = PHI undef %54:vreg_64, %bb.4, [[REG_SEQUENCE]], %bb.2
  ; SI-NEXT:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI undef %56:vgpr_32, %bb.4, [[PHI1]], %bb.2
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI4]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI4]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], killed [[PHI4]], implicit $exec
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4:
  ; SI-NEXT:   successors: %bb.3(0x40000000), %bb.5(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY6]]
  ; SI-NEXT:   $vgpr0 = COPY killed [[PHI5]]
  ; SI-NEXT:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE1]], 0, csr_amdgpu_si_gfx, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.3, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.5:
  ; SI-NEXT:   successors: %bb.10(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_]]
  ; SI-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY killed [[COPY7]]
  ; SI-NEXT:   S_BRANCH %bb.10
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.6.else:
  ; SI-NEXT:   successors: %bb.7(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[COPY1]], %subreg.sub0, killed [[COPY]], %subreg.sub1
  ; SI-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT:   [[COPY9:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.7:
  ; SI-NEXT:   successors: %bb.8(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI6:%[0-9]+]]:vreg_64 = PHI undef %58:vreg_64, %bb.8, [[REG_SEQUENCE2]], %bb.6
  ; SI-NEXT:   [[PHI7:%[0-9]+]]:vgpr_32 = PHI undef %60:vgpr_32, %bb.8, [[COPY4]], %bb.6
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI6]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI6]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_2]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE3]], killed [[PHI6]], implicit $exec
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_1]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.8:
  ; SI-NEXT:   successors: %bb.7(0x40000000), %bb.9(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY9]]
  ; SI-NEXT:   $vgpr0 = COPY killed [[PHI7]]
  ; SI-NEXT:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE3]], 0, csr_amdgpu_si_gfx, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_1]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.7, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.9:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_1]]
  ; SI-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY killed [[COPY10]]
  ; SI-NEXT:   S_BRANCH %bb.1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.10.end:
  ; SI-NEXT:   [[PHI8:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[COPY8]], %bb.5
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   $vgpr0 = COPY killed [[PHI8]]
  ; SI-NEXT:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = call amdgpu_gfx float %extern_func(float %v)
  br label %end

else:
  %v.else = call amdgpu_gfx float %extern_func2(float %v)
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  ret float %r
}

; a loop inside an if-else, but the variable is still in use after the if-else
define amdgpu_ps float @loop_with_use(i32 %z, float %v, i32 inreg %bound, ptr %extern_func, ptr %extern_func2) #0 {
  ; SI-LABEL: name: loop_with_use
  ; SI: bb.0.main_body:
  ; SI-NEXT:   successors: %bb.6(0x40000000), %bb.1(0x40000000)
  ; SI-NEXT:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr5
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr4
  ; SI-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr3
  ; SI-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY5]], implicit $exec
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.6
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.Flow:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.10(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %16:vgpr_32, %bb.0, %4, %bb.9
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY3]], %bb.0, undef %49:vgpr_32, %bb.9
  ; SI-NEXT:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[COPY2]], %bb.0, undef %51:vgpr_32, %bb.9
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.10, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.if:
  ; SI-NEXT:   successors: %bb.3(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[PHI1]], %subreg.sub0, killed [[PHI2]], %subreg.sub1
  ; SI-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT:   [[COPY6:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3:
  ; SI-NEXT:   successors: %bb.4(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI3:%[0-9]+]]:vreg_64 = PHI undef %53:vreg_64, %bb.4, [[REG_SEQUENCE]], %bb.2
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI3]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI3]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], killed [[PHI3]], implicit $exec
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4:
  ; SI-NEXT:   successors: %bb.3(0x40000000), %bb.5(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY6]]
  ; SI-NEXT:   $vgpr0 = COPY [[COPY4]]
  ; SI-NEXT:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE1]], 0, csr_amdgpu_si_gfx, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.3, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.5:
  ; SI-NEXT:   successors: %bb.10(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_]]
  ; SI-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY killed [[COPY7]]
  ; SI-NEXT:   S_BRANCH %bb.10
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.6.else:
  ; SI-NEXT:   successors: %bb.7(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[COPY1]], %subreg.sub0, killed [[COPY]], %subreg.sub1
  ; SI-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT:   [[COPY9:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.7:
  ; SI-NEXT:   successors: %bb.8(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI4:%[0-9]+]]:vreg_64 = PHI undef %55:vreg_64, %bb.8, [[REG_SEQUENCE2]], %bb.6
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI4]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[PHI4]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_2]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE3]], killed [[PHI4]], implicit $exec
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_1]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.8:
  ; SI-NEXT:   successors: %bb.7(0x40000000), %bb.9(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY9]]
  ; SI-NEXT:   $vgpr0 = COPY [[COPY4]]
  ; SI-NEXT:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE3]], 0, csr_amdgpu_si_gfx, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_1]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.7, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.9:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_1]]
  ; SI-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY killed [[COPY10]]
  ; SI-NEXT:   S_BRANCH %bb.1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.10.end:
  ; SI-NEXT:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[COPY8]], %bb.5
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[PHI5]], 0, killed [[COPY4]], 0, 0, implicit $mode, implicit $exec
  ; SI-NEXT:   $vgpr0 = COPY killed [[V_ADD_F32_e64_]]
  ; SI-NEXT:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = call amdgpu_gfx float %extern_func(float %v)
  br label %end

else:
  %v.else = call amdgpu_gfx float %extern_func2(float %v)
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  %r2 = fadd float %r, %v
  ret float %r2
}

define amdgpu_kernel void @livevariables_update_missed_block(ptr addrspace(1) %src1) {
  ; SI-LABEL: name: livevariables_update_missed_block
  ; SI: bb.0.entry:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.5(0x40000000)
  ; SI-NEXT:   liveins: $vgpr0, $sgpr4_sgpr5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:sgpr_64(p4) = COPY killed $sgpr4_sgpr5
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32(s32) = COPY killed $vgpr0
  ; SI-NEXT:   [[V_CMP_NE_U32_e64_:%[0-9]+]]:sreg_32 = V_CMP_NE_U32_e64 0, [[COPY1]](s32), implicit $exec
  ; SI-NEXT:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_NE_U32_e64_]], %bb.5, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.2
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.if.then:
  ; SI-NEXT:   successors: %bb.7(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   early-clobber %34:sreg_64_xexec = S_LOAD_DWORDX2_IMM_ec killed [[COPY]](p4), 36, 0 :: (dereferenceable invariant load (s64) from %ir.src1.kernarg.offset, align 4, addrspace 4)
  ; SI-NEXT:   [[V_ADD_CO_U32_e64_:%[0-9]+]]:vgpr_32, [[V_ADD_CO_U32_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_ADD_CO_U32_e64 %34.sub0, killed %55, 0, implicit $exec
  ; SI-NEXT:   [[V_ADDC_U32_e64_:%[0-9]+]]:vgpr_32, dead [[V_ADDC_U32_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_ADDC_U32_e64 0, killed %34.sub1, killed [[V_ADD_CO_U32_e64_1]], 0, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[V_ADD_CO_U32_e64_]], %subreg.sub0, killed [[V_ADDC_U32_e64_]], %subreg.sub1
  ; SI-NEXT:   [[GLOBAL_LOAD_UBYTE:%[0-9]+]]:vgpr_32 = GLOBAL_LOAD_UBYTE killed [[REG_SEQUENCE]], 0, 0, implicit $exec :: (load (s8) from %ir.i10, addrspace 1)
  ; SI-NEXT:   [[V_MOV_B:%[0-9]+]]:vreg_64 = V_MOV_B64_PSEUDO 0, implicit $exec
  ; SI-NEXT:   GLOBAL_STORE_BYTE killed [[V_MOV_B]], killed [[GLOBAL_LOAD_UBYTE]], 0, 0, implicit $exec :: (store (s8) into `ptr addrspace(1) null`, addrspace 1)
  ; SI-NEXT:   S_BRANCH %bb.7
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2.if.then9:
  ; SI-NEXT:   successors: %bb.4(0x40000000), %bb.3(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   S_CBRANCH_SCC0 %bb.4, implicit undef $scc
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3:
  ; SI-NEXT:   successors: %bb.6(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   S_BRANCH %bb.6
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4.sw.bb:
  ; SI-NEXT:   successors: %bb.6(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_MOV_B1:%[0-9]+]]:vreg_64 = V_MOV_B64_PSEUDO 0, implicit $exec
  ; SI-NEXT:   [[GLOBAL_LOAD_UBYTE1:%[0-9]+]]:vgpr_32 = GLOBAL_LOAD_UBYTE killed [[V_MOV_B1]], 0, 0, implicit $exec :: ("amdgpu-noclobber" load (s8) from `ptr addrspace(1) null`, addrspace 1)
  ; SI-NEXT:   S_BRANCH %bb.6
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.5.Flow:
  ; SI-NEXT:   successors: %bb.1(0x40000000), %bb.7(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI:%[0-9]+]]:vgpr_32 = PHI [[COPY1]](s32), %bb.0, undef %56:vgpr_32, %bb.6
  ; SI-NEXT:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.7, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_BRANCH %bb.1
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.6.sw.bb18:
  ; SI-NEXT:   successors: %bb.5(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI undef %42:vgpr_32, %bb.3, [[GLOBAL_LOAD_UBYTE1]], %bb.4
  ; SI-NEXT:   [[V_MOV_B2:%[0-9]+]]:vreg_64 = V_MOV_B64_PSEUDO 0, implicit $exec
  ; SI-NEXT:   GLOBAL_STORE_BYTE killed [[V_MOV_B2]], killed [[PHI1]], 0, 0, implicit $exec :: (store (s8) into `ptr addrspace(1) null`, addrspace 1)
  ; SI-NEXT:   S_BRANCH %bb.5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.7.UnifiedReturnBlock:
  ; SI-NEXT:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT:   S_ENDPGM 0
entry:
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i4 = add i32 0, %i2
  %i5 = zext i32 %i4 to i64
  %i6 = add i64 0, %i5
  %add = add i64 %i6, 0
  %cmp2 = icmp ult i64 %add, 1
  br i1 %cmp2, label %if.then, label %if.then9

if.then:                                          ; preds = %entry
  %i9 = mul i64 %i6, 1
  %i10 = getelementptr inbounds i8, ptr addrspace(1) %src1, i64 %i9
  %i11 = load i8, ptr addrspace(1) %i10, align 1
  %i12 = insertelement <3 x i8> zeroinitializer, i8 %i11, i64 0
  %i13 = insertelement <3 x i8> %i12, i8 0, i64 1
  %i14 = insertelement <3 x i8> %i13, i8 0, i64 1
  %i15 = select <3 x i1> zeroinitializer, <3 x i8> zeroinitializer, <3 x i8> %i14
  %i16 = extractelement <3 x i8> %i15, i64 0
  store i8 %i16, ptr addrspace(1) null, align 1
  ret void

if.then9:                                         ; preds = %entry
  %undef = freeze i1 poison
  br i1 %undef, label %sw.bb18, label %sw.bb

sw.bb:                                            ; preds = %if.then9
  %i17 = load i8, ptr addrspace(1) null, align 1
  %i18 = insertelement <4 x i8> zeroinitializer, i8 %i17, i64 0
  %a.sroa.0.0.vecblend = shufflevector <4 x i8> %i18, <4 x i8> zeroinitializer, <4 x i32> <i32 0, i32 0, i32 0, i32 poison>
  br label %sw.bb18

sw.bb18:                                          ; preds = %sw.bb, %if.then9
  %a.sroa.0.0 = phi <4 x i8> [ %a.sroa.0.0.vecblend, %sw.bb ], [ poison, %if.then9 ]
  %a.sroa.0.0.vec.extract61 = shufflevector <4 x i8> %a.sroa.0.0, <4 x i8> zeroinitializer, <3 x i32> <i32 poison, i32 1, i32 poison>
  %i19 = insertelement <3 x i8> %a.sroa.0.0.vec.extract61, i8 0, i64 0
  %i20 = select <3 x i1> zeroinitializer, <3 x i8> zeroinitializer, <3 x i8> %i19
  %i21 = extractelement <3 x i8> %i20, i64 1
  store i8 %i21, ptr addrspace(1) null, align 1
  ret void
}

%tex = type opaque
define protected amdgpu_kernel void @nested_waterfalls(ptr addrspace(1) %tex.coerce) local_unnamed_addr {
  ; SI-LABEL: name: nested_waterfalls
  ; SI: bb.0.entry:
  ; SI-NEXT:   successors: %bb.1(0x80000000)
  ; SI-NEXT:   liveins: $vgpr0, $sgpr4_sgpr5
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[COPY:%[0-9]+]]:sgpr_64(p4) = COPY killed $sgpr4_sgpr5
  ; SI-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32(s32) = COPY killed $vgpr0
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.1.if.then:
  ; SI-NEXT:   successors: %bb.2(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   early-clobber %11:sreg_64_xexec_xnull = S_LOAD_DWORDX2_IMM_ec killed [[COPY]](p4), 36, 0 :: (dereferenceable invariant load (s64) from %ir.tex.coerce.kernarg.offset, align 4, addrspace 4)
  ; SI-NEXT:   [[V_LSHLREV_B32_e64_:%[0-9]+]]:vgpr_32 = nuw nsw V_LSHLREV_B32_e64 3, killed [[COPY1]](s32), implicit $exec
  ; SI-NEXT:   [[GLOBAL_LOAD_DWORDX2_SADDR:%[0-9]+]]:vreg_64 = GLOBAL_LOAD_DWORDX2_SADDR killed %11, killed [[V_LSHLREV_B32_e64_]], 0, 0, implicit $exec :: (load (s64) from %ir.idx, addrspace 1)
  ; SI-NEXT:   [[GLOBAL_LOAD_DWORDX4_:%[0-9]+]]:vreg_128 = GLOBAL_LOAD_DWORDX4 [[GLOBAL_LOAD_DWORDX2_SADDR]], 16, 0, implicit $exec :: (invariant load (s128) from %ir.3 + 16, addrspace 4)
  ; SI-NEXT:   [[GLOBAL_LOAD_DWORDX4_1:%[0-9]+]]:vreg_128 = GLOBAL_LOAD_DWORDX4 [[GLOBAL_LOAD_DWORDX2_SADDR]], 0, 0, implicit $exec :: (invariant load (s128) from %ir.3, align 32, addrspace 4)
  ; SI-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_256 = REG_SEQUENCE killed [[GLOBAL_LOAD_DWORDX4_1]].sub0, %subreg.sub0, [[GLOBAL_LOAD_DWORDX4_1]].sub1, %subreg.sub1, [[GLOBAL_LOAD_DWORDX4_1]].sub2, %subreg.sub2, [[GLOBAL_LOAD_DWORDX4_1]].sub3, %subreg.sub3, killed [[GLOBAL_LOAD_DWORDX4_]].sub0, %subreg.sub4, [[GLOBAL_LOAD_DWORDX4_]].sub1, %subreg.sub5, [[GLOBAL_LOAD_DWORDX4_]].sub2, %subreg.sub6, [[GLOBAL_LOAD_DWORDX4_]].sub3, %subreg.sub7
  ; SI-NEXT:   [[GLOBAL_LOAD_DWORDX4_2:%[0-9]+]]:vreg_128 = GLOBAL_LOAD_DWORDX4 killed [[GLOBAL_LOAD_DWORDX2_SADDR]], 48, 0, implicit $exec :: (invariant load (s128) from %ir.add.ptr.i, addrspace 4)
  ; SI-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.2:
  ; SI-NEXT:   successors: %bb.3(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE1]], [[REG_SEQUENCE]].sub0_sub1, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub2, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub3, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE2]], [[REG_SEQUENCE]].sub2_sub3, implicit $exec
  ; SI-NEXT:   [[S_AND_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_B32 killed [[V_CMP_EQ_U64_e64_]], killed [[V_CMP_EQ_U64_e64_1]], implicit-def dead $scc
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub4, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub5, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_4]], %subreg.sub0, [[V_READFIRSTLANE_B32_5]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_2:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE3]], [[REG_SEQUENCE]].sub4_sub5, implicit $exec
  ; SI-NEXT:   [[S_AND_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_B32 killed [[S_AND_B32_]], killed [[V_CMP_EQ_U64_e64_2]], implicit-def dead $scc
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub6, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[REG_SEQUENCE]].sub7, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE4:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_6]], %subreg.sub0, [[V_READFIRSTLANE_B32_7]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_3:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE4]], [[REG_SEQUENCE]].sub6_sub7, implicit $exec
  ; SI-NEXT:   [[S_AND_B32_2:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_B32 killed [[S_AND_B32_1]], killed [[V_CMP_EQ_U64_e64_3]], implicit-def dead $scc
  ; SI-NEXT:   [[REG_SEQUENCE5:%[0-9]+]]:sgpr_256 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_1]], %subreg.sub1, killed [[V_READFIRSTLANE_B32_2]], %subreg.sub2, killed [[V_READFIRSTLANE_B32_3]], %subreg.sub3, killed [[V_READFIRSTLANE_B32_4]], %subreg.sub4, killed [[V_READFIRSTLANE_B32_5]], %subreg.sub5, killed [[V_READFIRSTLANE_B32_6]], %subreg.sub6, killed [[V_READFIRSTLANE_B32_7]], %subreg.sub7
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[S_AND_B32_2]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.3:
  ; SI-NEXT:   successors: %bb.4(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.4:
  ; SI-NEXT:   successors: %bb.5(0x80000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_8:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[GLOBAL_LOAD_DWORDX4_2]].sub0, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_9:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[GLOBAL_LOAD_DWORDX4_2]].sub1, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE6:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_8]], %subreg.sub0, [[V_READFIRSTLANE_B32_9]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_4:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE6]], [[GLOBAL_LOAD_DWORDX4_2]].sub0_sub1, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_10:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[GLOBAL_LOAD_DWORDX4_2]].sub2, implicit $exec
  ; SI-NEXT:   [[V_READFIRSTLANE_B32_11:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[GLOBAL_LOAD_DWORDX4_2]].sub3, implicit $exec
  ; SI-NEXT:   [[REG_SEQUENCE7:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[V_READFIRSTLANE_B32_10]], %subreg.sub0, [[V_READFIRSTLANE_B32_11]], %subreg.sub1
  ; SI-NEXT:   [[V_CMP_EQ_U64_e64_5:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 killed [[REG_SEQUENCE7]], [[GLOBAL_LOAD_DWORDX4_2]].sub2_sub3, implicit $exec
  ; SI-NEXT:   [[S_AND_B32_3:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_B32 killed [[V_CMP_EQ_U64_e64_4]], killed [[V_CMP_EQ_U64_e64_5]], implicit-def dead $scc
  ; SI-NEXT:   [[REG_SEQUENCE8:%[0-9]+]]:sgpr_128 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_8]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_9]], %subreg.sub1, killed [[V_READFIRSTLANE_B32_10]], %subreg.sub2, killed [[V_READFIRSTLANE_B32_11]], %subreg.sub3
  ; SI-NEXT:   [[S_AND_SAVEEXEC_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[S_AND_B32_3]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.5:
  ; SI-NEXT:   successors: %bb.4(0x40000000), %bb.6(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   [[IMAGE_SAMPLE_V1_V2_nsa_gfx10_:%[0-9]+]]:vgpr_32 = IMAGE_SAMPLE_V1_V2_nsa_gfx10 undef %29:vgpr_32, undef %31:vgpr_32, [[REG_SEQUENCE5]], killed [[REG_SEQUENCE8]], 1, 1, 0, 0, 0, 0, 0, 0, 0, implicit $exec :: (dereferenceable load (s32), addrspace 8)
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_1]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.4, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.6:
  ; SI-NEXT:   successors: %bb.2(0x40000000), %bb.7(0x40000000)
  ; SI-NEXT: {{  $}}
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_1]]
  ; SI-NEXT:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_]], implicit-def dead $scc
  ; SI-NEXT:   SI_WATERFALL_LOOP %bb.2, implicit $exec
  ; SI-NEXT: {{  $}}
  ; SI-NEXT: bb.7:
  ; SI-NEXT:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_]]
  ; SI-NEXT:   GLOBAL_STORE_DWORD undef %34:vreg_64, killed [[IMAGE_SAMPLE_V1_V2_nsa_gfx10_]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; SI-NEXT:   S_ENDPGM 0
entry:
  %0 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %1 = zext i32 %0 to i64
  br label %if.then

if.then:                                          ; preds = %entry
  %idx = getelementptr inbounds ptr, ptr addrspace(1) %tex.coerce, i64 %1
  %2 = load ptr, ptr addrspace(1) %idx, align 8
  %3 = addrspacecast ptr %2 to ptr addrspace(4)
  %add.ptr.i = getelementptr inbounds i32, ptr addrspace(4) %3, i64 12
  %4 = addrspacecast ptr %2 to ptr addrspace(4)
  %5 = load <8 x i32>, ptr addrspace(4) %4, align 32
  %6 = load <4 x i32>, ptr addrspace(4) %add.ptr.i, align 16
  %7 = tail call float @llvm.amdgcn.image.sample.2d.f32.f32(i32 1, float poison, float poison, <8 x i32> %5, <4 x i32> %6, i1 false, i32 0, i32 0)
  store float %7, ptr addrspace(1) poison, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

declare float @llvm.amdgcn.image.sample.2d.f32.f32(i32 immarg, float, float, <8 x i32>, <4 x i32>, i1 immarg, i32 immarg, i32 immarg) #2

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone speculatable willreturn }
attributes #2 = { nounwind readonly willreturn }
