; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -O2 -S < %s | FileCheck %s
; RUN: opt -passes=instcombine -S < %s | FileCheck %s --check-prefix=IC
; RUN: opt -passes=aggressive-instcombine,instcombine -S < %s | FileCheck %s --check-prefix=AIC_AND_IC

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i16 @foo(i1 %a) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:    [[TRUNC:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; CHECK-NEXT:    ret i16 [[TRUNC]]
;
; IC-LABEL: @foo(
; IC-NEXT:    [[TRUNC:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; IC-NEXT:    ret i16 [[TRUNC]]
;
; AIC_AND_IC-LABEL: @foo(
; AIC_AND_IC-NEXT:    [[LSHR:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; AIC_AND_IC-NEXT:    ret i16 [[LSHR]]
;
  %sext = sext i1 %a to i16
  %zext = zext i16 %sext to i32
  %lshr = lshr i32 %zext, 1
  %trunc = trunc i32 %lshr to i16
  ret i16 %trunc
}

define i16 @foo2(i1 %a) {
; CHECK-LABEL: @foo2(
; CHECK-NEXT:    [[LSHR:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; CHECK-NEXT:    ret i16 [[LSHR]]
;
; IC-LABEL: @foo2(
; IC-NEXT:    [[LSHR:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; IC-NEXT:    ret i16 [[LSHR]]
;
; AIC_AND_IC-LABEL: @foo2(
; AIC_AND_IC-NEXT:    [[LSHR:%.*]] = select i1 [[A:%.*]], i16 32767, i16 0
; AIC_AND_IC-NEXT:    ret i16 [[LSHR]]
;
  %s = sext i1 %a to i16
  %lshr = lshr i16 %s, 1
  ret i16 %lshr
}
