; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instsimplify -march=nvptx64 -S | FileCheck %s

; f2i/f2ui and d2i/d2ui - double/float to i32 tests

;###############################################################
;#               Tests with Positive 1.5                       #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2i                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_f2i_rm() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rm() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2i.rm(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2i_rn() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rn() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2i.rn(float 1.5)
  ret i32 %res
}


define i32 @test_pos_1_5_f2i_rp() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rp() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2i.rp(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2i_rz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2i.rz(float 1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2i_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_f2i_rm_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rm_ftz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2i.rm.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2i_rn_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rn_ftz() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2i.rn.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2i_rp_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rp_ftz() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2i.rp.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2i_rz_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2i_rz_ftz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2i.rz.ftz(float 1.5)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2i                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_d2i_rm() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2i_rm() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2i.rm(double 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_d2i_rn() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2i_rn() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.d2i.rn(double 1.5)
  ret i32 %res
}


define i32 @test_pos_1_5_d2i_rp() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2i_rp() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.d2i.rp(double 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_d2i_rz() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2i_rz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2i.rz(double 1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                        f2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_f2ui_rm() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rm() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2ui.rm(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2ui_rn() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rn() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2ui.rn(float 1.5)
  ret i32 %res
}


define i32 @test_pos_1_5_f2ui_rp() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rp() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2ui.rp(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2ui_rz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2ui.rz(float 1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2ui_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_f2ui_rm_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rm_ftz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2ui.rm.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2ui_rn_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rn_ftz() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2ui.rn.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2ui_rp_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rp_ftz() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.f2ui.rp.ftz(float 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_f2ui_rz_ftz() {
; CHECK-LABEL: define i32 @test_pos_1_5_f2ui_rz_ftz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2ui.rz.ftz(float 1.5)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_1_5_d2ui_rm() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2ui_rm() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2ui.rm(double 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_d2ui_rn() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2ui_rn() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.d2ui.rn(double 1.5)
  ret i32 %res
}


define i32 @test_pos_1_5_d2ui_rp() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2ui_rp() {
; CHECK-NEXT:    ret i32 2
;
  %res = call i32 @llvm.nvvm.d2ui.rp(double 1.5)
  ret i32 %res
}

define i32 @test_pos_1_5_d2ui_rz() {
; CHECK-LABEL: define i32 @test_pos_1_5_d2ui_rz() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2ui.rz(double 1.5)
  ret i32 %res
}

;###############################################################
;#               Tests with Negative 1.5                       #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2i                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_f2i_rm() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rm() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.f2i.rm(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2i_rn() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rn() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.f2i.rn(float -1.5)
  ret i32 %res
}


define i32 @test_neg_1_5_f2i_rp() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rp() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.f2i.rp(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2i_rz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rz() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.f2i.rz(float -1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2i_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_f2i_rm_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rm_ftz() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.f2i.rm.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2i_rn_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rn_ftz() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.f2i.rn.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2i_rp_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rp_ftz() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.f2i.rp.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2i_rz_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2i_rz_ftz() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.f2i.rz.ftz(float -1.5)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2i                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_d2i_rm() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2i_rm() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.d2i.rm(double -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_d2i_rn() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2i_rn() {
; CHECK-NEXT:    ret i32 -2
;
  %res = call i32 @llvm.nvvm.d2i.rn(double -1.5)
  ret i32 %res
}


define i32 @test_neg_1_5_d2i_rp() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2i_rp() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.d2i.rp(double -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_d2i_rz() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2i_rz() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.d2i.rz(double -1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                        f2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_f2ui_rm() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rm(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rm(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2ui_rn() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rn() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rn(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rn(float -1.5)
  ret i32 %res
}


define i32 @test_neg_1_5_f2ui_rp() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rp() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rp(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rp(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2ui_rz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rz(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rz(float -1.5)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2ui_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_f2ui_rm_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rm_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rm.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rm.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2ui_rn_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rn_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rn.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rn.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2ui_rp_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rp_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rp.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rp.ftz(float -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_f2ui_rz_ftz() {
; CHECK-LABEL: define i32 @test_neg_1_5_f2ui_rz_ftz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rz.ftz(float -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rz.ftz(float -1.5)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_1_5_d2ui_rm() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2ui_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.d2ui.rm(double -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.d2ui.rm(double -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_d2ui_rn() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2ui_rn() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.d2ui.rn(double -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.d2ui.rn(double -1.5)
  ret i32 %res
}


define i32 @test_neg_1_5_d2ui_rp() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2ui_rp() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.d2ui.rp(double -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.d2ui.rp(double -1.5)
  ret i32 %res
}

define i32 @test_neg_1_5_d2ui_rz() {
; CHECK-LABEL: define i32 @test_neg_1_5_d2ui_rz() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.d2ui.rz(double -1.500000e+00)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.d2ui.rz(double -1.5)
  ret i32 %res
}

;###############################################################
;#                    Tests with NaN                           #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2i                                  |
;+-------------------------------------------------------------+
define i32 @test_nan_f2i_rm() {
; CHECK-LABEL: define i32 @test_nan_f2i_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rm(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2i_rn() {
; CHECK-LABEL: define i32 @test_nan_f2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn(float 0x7FFFFF0000000000)
  ret i32 %res
}


define i32 @test_nan_f2i_rp() {
; CHECK-LABEL: define i32 @test_nan_f2i_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rp(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2i_rz() {
; CHECK-LABEL: define i32 @test_nan_f2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz(float 0x7FFFFF0000000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2i_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_nan_f2i_rm_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2i_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rm.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2i_rn_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2i_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2i_rp_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2i_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rp.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2i_rz_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2i_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2i                                  |
;+-------------------------------------------------------------+
define i32 @test_nan_d2i_rm() {
; CHECK-LABEL: define i32 @test_nan_d2i_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rm(double 0xFFF8000000000000)
  ret i32 %res
}

define i32 @test_nan_d2i_rn() {
; CHECK-LABEL: define i32 @test_nan_d2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rn(double 0xFFF8000000000000)
  ret i32 %res
}


define i32 @test_nan_d2i_rp() {
; CHECK-LABEL: define i32 @test_nan_d2i_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rp(double 0xFFF8000000000000)
  ret i32 %res
}

define i32 @test_nan_d2i_rz() {
; CHECK-LABEL: define i32 @test_nan_d2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rz(double 0xFFF8000000000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                        f2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_nan_f2ui_rm() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rm(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2ui_rn() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn(float 0x7FFFFF0000000000)
  ret i32 %res
}


define i32 @test_nan_f2ui_rp() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rp(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2ui_rz() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz(float 0x7FFFFF0000000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2ui_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_nan_f2ui_rm_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rm.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2ui_rn_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2ui_rp_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rp.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}

define i32 @test_nan_f2ui_rz_ftz() {
; CHECK-LABEL: define i32 @test_nan_f2ui_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz.ftz(float 0x7FFFFF0000000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_nan_d2ui_rm() {
; CHECK-LABEL: define i32 @test_nan_d2ui_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rm(double 0xFFF8000000000000)
  ret i32 %res
}

define i32 @test_nan_d2ui_rn() {
; CHECK-LABEL: define i32 @test_nan_d2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rn(double 0xFFF8000000000000)
  ret i32 %res
}


define i32 @test_nan_d2ui_rp() {
; CHECK-LABEL: define i32 @test_nan_d2ui_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rp(double 0xFFF8000000000000)
  ret i32 %res
}

define i32 @test_nan_d2ui_rz() {
; CHECK-LABEL: define i32 @test_nan_d2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rz(double 0xFFF8000000000000)
  ret i32 %res
}

;###############################################################
;#            Tests with Positive Subnormal                    #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2i                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_f2i_rm() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rm(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2i_rn() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn(float 0x380FFFFFC0000000)
  ret i32 %res
}


define i32 @test_pos_subnormal_f2i_rp() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rp() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2i.rp(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2i_rz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz(float 0x380FFFFFC0000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2i_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_f2i_rm_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rm.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2i_rn_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2i_rp_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rp.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2i_rz_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2i_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2i                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_d2i_rm() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2i_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rm(double 0x000fffffffffffff)
  ret i32 %res
}

define i32 @test_pos_subnormal_d2i_rn() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rn(double 0x000fffffffffffff)
  ret i32 %res
}


define i32 @test_pos_subnormal_d2i_rp() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2i_rp() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2i.rp(double 0x000fffffffffffff)
  ret i32 %res
}

define i32 @test_pos_subnormal_d2i_rz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rz(double 0x000fffffffffffff)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                        f2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_f2ui_rm() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rm(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2ui_rn() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn(float 0x380FFFFFC0000000)
  ret i32 %res
}


define i32 @test_pos_subnormal_f2ui_rp() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rp() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.f2ui.rp(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2ui_rz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz(float 0x380FFFFFC0000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2ui_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_f2ui_rm_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rm.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2ui_rn_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2ui_rp_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rp.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}

define i32 @test_pos_subnormal_f2ui_rz_ftz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_f2ui_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz.ftz(float 0x380FFFFFC0000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_pos_subnormal_d2ui_rm() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2ui_rm() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rm(double 0x000fffffffffffff)
  ret i32 %res
}

define i32 @test_pos_subnormal_d2ui_rn() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rn(double 0x000fffffffffffff)
  ret i32 %res
}


define i32 @test_pos_subnormal_d2ui_rp() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2ui_rp() {
; CHECK-NEXT:    ret i32 1
;
  %res = call i32 @llvm.nvvm.d2ui.rp(double 0x000fffffffffffff)
  ret i32 %res
}

define i32 @test_pos_subnormal_d2ui_rz() {
; CHECK-LABEL: define i32 @test_pos_subnormal_d2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rz(double 0x000fffffffffffff)
  ret i32 %res
}

;###############################################################
;#            Tests with Negative Subnormal                    #
;###############################################################

;+-------------------------------------------------------------+
;|                        f2i                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_f2i_rm() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rm() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.f2i.rm(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2i_rn() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn(float 0xB80FFFFFC0000000)
  ret i32 %res
}


define i32 @test_neg_subnormal_f2i_rp() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rp(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2i_rz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2i_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_f2i_rm_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rm.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2i_rn_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rn.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2i_rp_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rp.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2i_rz_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2i_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2i.rz.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2i                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_d2i_rm() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2i_rm() {
; CHECK-NEXT:    ret i32 -1
;
  %res = call i32 @llvm.nvvm.d2i.rm(double 0x800fffffffffffff)
  ret i32 %res
}

define i32 @test_neg_subnormal_d2i_rn() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2i_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rn(double 0x800fffffffffffff)
  ret i32 %res
}


define i32 @test_neg_subnormal_d2i_rp() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2i_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rp(double 0x800fffffffffffff)
  ret i32 %res
}

define i32 @test_neg_subnormal_d2i_rz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2i_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2i.rz(double 0x800fffffffffffff)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                        f2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_f2ui_rm() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.f2ui.rm(float 0xB80FFFFFC0000000)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.f2ui.rm(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2ui_rn() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn(float 0xB80FFFFFC0000000)
  ret i32 %res
}


define i32 @test_neg_subnormal_f2ui_rp() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rp(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2ui_rz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

;+-------------------------------------------------------------+
;|                      f2ui_ftz                                |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_f2ui_rm_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rm_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rm.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2ui_rn_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rn_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rn.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2ui_rp_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rp_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rp.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}

define i32 @test_neg_subnormal_f2ui_rz_ftz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_f2ui_rz_ftz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.f2ui.rz.ftz(float 0xB80FFFFFC0000000)
  ret i32 %res
}
;+-------------------------------------------------------------+
;|                        d2ui                                  |
;+-------------------------------------------------------------+
define i32 @test_neg_subnormal_d2ui_rm() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2ui_rm() {
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.nvvm.d2ui.rm(double 0x800FFFFFFFFFFFFF)
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.nvvm.d2ui.rm(double 0x800fffffffffffff)
  ret i32 %res
}

define i32 @test_neg_subnormal_d2ui_rn() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2ui_rn() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rn(double 0x800fffffffffffff)
  ret i32 %res
}


define i32 @test_neg_subnormal_d2ui_rp() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2ui_rp() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rp(double 0x800fffffffffffff)
  ret i32 %res
}

define i32 @test_neg_subnormal_d2ui_rz() {
; CHECK-LABEL: define i32 @test_neg_subnormal_d2ui_rz() {
; CHECK-NEXT:    ret i32 0
;
  %res = call i32 @llvm.nvvm.d2ui.rz(double 0x800fffffffffffff)
  ret i32 %res
}

declare i32 @llvm.nvvm.f2i.rm(float)
declare i32 @llvm.nvvm.f2i.rn(float)
declare i32 @llvm.nvvm.f2i.rp(float)
declare i32 @llvm.nvvm.f2i.rz(float)

declare i32 @llvm.nvvm.f2i.rm.ftz(float)
declare i32 @llvm.nvvm.f2i.rn.ftz(float)
declare i32 @llvm.nvvm.f2i.rp.ftz(float)
declare i32 @llvm.nvvm.f2i.rz.ftz(float)

declare i32 @llvm.nvvm.d2i.rm(double)
declare i32 @llvm.nvvm.d2i.rn(double)
declare i32 @llvm.nvvm.d2i.rp(double)
declare i32 @llvm.nvvm.d2i.rz(double)


declare i32 @llvm.nvvm.f2ui.rm(float)
declare i32 @llvm.nvvm.f2ui.rn(float)
declare i32 @llvm.nvvm.f2ui.rp(float)
declare i32 @llvm.nvvm.f2ui.rz(float)

declare i32 @llvm.nvvm.f2ui.rm.ftz(float)
declare i32 @llvm.nvvm.f2ui.rn.ftz(float)
declare i32 @llvm.nvvm.f2ui.rp.ftz(float)
declare i32 @llvm.nvvm.f2ui.rz.ftz(float)

declare i32 @llvm.nvvm.d2ui.rm(double)
declare i32 @llvm.nvvm.d2ui.rn(double)
declare i32 @llvm.nvvm.d2ui.rp(double)
declare i32 @llvm.nvvm.d2ui.rz(double)
