; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

@test.data = private unnamed_addr addrspace(2) constant [8 x i32] [i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7], align 4

define void @test_load(ptr addrspace(1) %out, i64 %x) {
; CHECK-LABEL: @test_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [8 x i32], ptr addrspace(2) @test.data, i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr addrspace(2) [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds [8 x i32], ptr %data, i64 0, i64 %x
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  ret void
}

; Same as previous test, but with gep nusw nuw instead of inbounds.
define void @test_load_gep_nusw_nuw(ptr addrspace(1) %out, i64 %x) {
; CHECK-LABEL: @test_load_gep_nusw_nuw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr nusw nuw [8 x i32], ptr addrspace(2) @test.data, i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr addrspace(2) [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr nusw nuw i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr nusw nuw [8 x i32], ptr %data, i64 0, i64 %x
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr nusw nuw i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  ret void
}

define void @test_load_bitcast_chain(ptr addrspace(1) %out, i64 %x) {
; CHECK-LABEL: @test_load_bitcast_chain(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr addrspace(2) @test.data, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr addrspace(2) [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds i32, ptr %data, i64 %x
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  ret void
}

define void @test_call(ptr addrspace(1) %out, i64 %x) {
; CHECK-LABEL: @test_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DATA:%.*]] = alloca [8 x i32], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p2.i64(ptr noundef nonnull align 4 dereferenceable(32) [[DATA]], ptr addrspace(2) noundef align 4 dereferenceable(32) @test.data, i64 32, i1 false)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [8 x i32], ptr [[DATA]], i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @foo(ptr nonnull [[ARRAYIDX]])
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds [8 x i32], ptr %data, i64 0, i64 %x
  %0 = call i32 @foo(ptr %arrayidx)
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  ret void
}

define void @test_call_no_null_opt(ptr addrspace(1) %out, i64 %x) #0 {
; CHECK-LABEL: @test_call_no_null_opt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DATA:%.*]] = alloca [8 x i32], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p2.i64(ptr noundef nonnull align 4 dereferenceable(32) [[DATA]], ptr addrspace(2) noundef align 4 dereferenceable(32) @test.data, i64 32, i1 false)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [8 x i32], ptr [[DATA]], i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @foo(ptr [[ARRAYIDX]])
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds [8 x i32], ptr %data, i64 0, i64 %x
  %0 = call i32 @foo(ptr %arrayidx)
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  ret void
}

define void @test_load_and_call(ptr addrspace(1) %out, i64 %x, i64 %y) {
; CHECK-LABEL: @test_load_and_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DATA:%.*]] = alloca [8 x i32], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p2.i64(ptr noundef nonnull align 4 dereferenceable(32) [[DATA]], ptr addrspace(2) noundef align 4 dereferenceable(32) @test.data, i64 32, i1 false)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [8 x i32], ptr [[DATA]], i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @foo(ptr nonnull [[ARRAYIDX]])
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT]], i64 [[Y:%.*]]
; CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[ARRAYIDX2]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds [8 x i32], ptr %data, i64 0, i64 %x
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  %1 = call i32 @foo(ptr %arrayidx)
  %arrayidx2 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %y
  store i32 %1, ptr addrspace(1) %arrayidx2, align 4
  ret void
}

define void @test_load_and_call_no_null_opt(ptr addrspace(1) %out, i64 %x, i64 %y) #0 {
; CHECK-LABEL: @test_load_and_call_no_null_opt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DATA:%.*]] = alloca [8 x i32], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p2.i64(ptr noundef nonnull align 4 dereferenceable(32) [[DATA]], ptr addrspace(2) noundef align 4 dereferenceable(32) @test.data, i64 32, i1 false)
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [8 x i32], ptr [[DATA]], i64 0, i64 [[X:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT:%.*]], i64 [[X]]
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(1) [[ARRAYIDX1]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @foo(ptr [[ARRAYIDX]])
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, ptr addrspace(1) [[OUT]], i64 [[Y:%.*]]
; CHECK-NEXT:    store i32 [[TMP1]], ptr addrspace(1) [[ARRAYIDX2]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %data = alloca [8 x i32], align 4
  call void @llvm.memcpy.p0.p2.i64(ptr align 4 %data, ptr addrspace(2) align 4 @test.data, i64 32, i1 false)
  %arrayidx = getelementptr inbounds [8 x i32], ptr %data, i64 0, i64 %x
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %x
  store i32 %0, ptr addrspace(1) %arrayidx1, align 4
  %1 = call i32 @foo(ptr %arrayidx)
  %arrayidx2 = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %y
  store i32 %1, ptr addrspace(1) %arrayidx2, align 4
  ret void
}

declare void @llvm.memcpy.p0.p2.i64(ptr nocapture writeonly, ptr addrspace(2) nocapture readonly, i64, i1)
declare i32 @foo(ptr %x)

attributes #0 = { null_pointer_is_valid }
