; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX1010 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GFX10,GFX1030 %s

define void @uniform_br_no_metadata(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef inreg %flag) {
; GFX9-LABEL: uniform_br_no_metadata:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lt_i32 s23, 1
; GFX9-NEXT:    s_cbranch_scc1 .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  .LBB0_2: ; %if.end
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: uniform_br_no_metadata:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lt_i32 s23, 1
; GFX10-NEXT:    s_cbranch_scc1 .LBB0_2
; GFX10-NEXT:  ; %bb.1: ; %if.then
; GFX10-NEXT:    v_mov_b32_e32 v0, s16
; GFX10-NEXT:    v_mov_b32_e32 v1, s21
; GFX10-NEXT:    s_mov_b32 s7, s20
; GFX10-NEXT:    s_mov_b32 s6, s19
; GFX10-NEXT:    s_mov_b32 s5, s18
; GFX10-NEXT:    s_mov_b32 s4, s17
; GFX10-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX10-NEXT:  .LBB0_2: ; %if.end
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

define void @uniform_br_unprofitable(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef inreg %flag) {
; GFX9-LABEL: uniform_br_unprofitable:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lt_i32 s23, 1
; GFX9-NEXT:    s_cbranch_scc1 .LBB1_2
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  .LBB1_2: ; %if.end
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: uniform_br_unprofitable:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lt_i32 s23, 1
; GFX10-NEXT:    s_cbranch_scc1 .LBB1_2
; GFX10-NEXT:  ; %bb.1: ; %if.then
; GFX10-NEXT:    v_mov_b32_e32 v0, s16
; GFX10-NEXT:    v_mov_b32_e32 v1, s21
; GFX10-NEXT:    s_mov_b32 s7, s20
; GFX10-NEXT:    s_mov_b32 s6, s19
; GFX10-NEXT:    s_mov_b32 s5, s18
; GFX10-NEXT:    s_mov_b32 s4, s17
; GFX10-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX10-NEXT:  .LBB1_2: ; %if.end
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end, !prof !0

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

define void @uniform_br_profitable(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef inreg %flag) {
; GFX9-LABEL: uniform_br_profitable:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lt_i32 s23, 1
; GFX9-NEXT:    s_cbranch_scc1 .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  .LBB2_2: ; %if.end
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: uniform_br_profitable:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lt_i32 s23, 1
; GFX10-NEXT:    s_cbranch_scc1 .LBB2_2
; GFX10-NEXT:  ; %bb.1: ; %if.then
; GFX10-NEXT:    v_mov_b32_e32 v0, s16
; GFX10-NEXT:    v_mov_b32_e32 v1, s21
; GFX10-NEXT:    s_mov_b32 s7, s20
; GFX10-NEXT:    s_mov_b32 s6, s19
; GFX10-NEXT:    s_mov_b32 s5, s18
; GFX10-NEXT:    s_mov_b32 s4, s17
; GFX10-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX10-NEXT:  .LBB2_2: ; %if.end
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end, !prof !1

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

define void @divergent_br_no_metadata(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef %flag) {
; GFX9-LABEL: divergent_br_no_metadata:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB3_2
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  .LBB3_2: ; %if.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-LABEL: divergent_br_no_metadata:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0, v0
; GFX1010-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1010-NEXT:    s_cbranch_execz .LBB3_2
; GFX1010-NEXT:  ; %bb.1: ; %if.then
; GFX1010-NEXT:    v_mov_b32_e32 v0, s16
; GFX1010-NEXT:    v_mov_b32_e32 v1, s21
; GFX1010-NEXT:    s_mov_b32 s7, s20
; GFX1010-NEXT:    s_mov_b32 s6, s19
; GFX1010-NEXT:    s_mov_b32 s5, s18
; GFX1010-NEXT:    s_mov_b32 s4, s17
; GFX1010-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1010-NEXT:  .LBB3_2: ; %if.end
; GFX1010-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-LABEL: divergent_br_no_metadata:
; GFX1030:       ; %bb.0: ; %entry
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_mov_b32 s8, exec_lo
; GFX1030-NEXT:    v_cmpx_lt_i32_e32 0, v0
; GFX1030-NEXT:    s_cbranch_execz .LBB3_2
; GFX1030-NEXT:  ; %bb.1: ; %if.then
; GFX1030-NEXT:    v_mov_b32_e32 v0, s16
; GFX1030-NEXT:    v_mov_b32_e32 v1, s21
; GFX1030-NEXT:    s_mov_b32 s7, s20
; GFX1030-NEXT:    s_mov_b32 s6, s19
; GFX1030-NEXT:    s_mov_b32 s5, s18
; GFX1030-NEXT:    s_mov_b32 s4, s17
; GFX1030-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1030-NEXT:  .LBB3_2: ; %if.end
; GFX1030-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

define void @divergent_br_unprofitable(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef %flag) {
; GFX9-LABEL: divergent_br_unprofitable:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  .LBB4_2: ; %if.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-LABEL: divergent_br_unprofitable:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0, v0
; GFX1010-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1010-NEXT:    s_cbranch_execz .LBB4_2
; GFX1010-NEXT:  ; %bb.1: ; %if.then
; GFX1010-NEXT:    v_mov_b32_e32 v0, s16
; GFX1010-NEXT:    v_mov_b32_e32 v1, s21
; GFX1010-NEXT:    s_mov_b32 s7, s20
; GFX1010-NEXT:    s_mov_b32 s6, s19
; GFX1010-NEXT:    s_mov_b32 s5, s18
; GFX1010-NEXT:    s_mov_b32 s4, s17
; GFX1010-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1010-NEXT:  .LBB4_2: ; %if.end
; GFX1010-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-LABEL: divergent_br_unprofitable:
; GFX1030:       ; %bb.0: ; %entry
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_mov_b32 s8, exec_lo
; GFX1030-NEXT:    v_cmpx_lt_i32_e32 0, v0
; GFX1030-NEXT:    s_cbranch_execz .LBB4_2
; GFX1030-NEXT:  ; %bb.1: ; %if.then
; GFX1030-NEXT:    v_mov_b32_e32 v0, s16
; GFX1030-NEXT:    v_mov_b32_e32 v1, s21
; GFX1030-NEXT:    s_mov_b32 s7, s20
; GFX1030-NEXT:    s_mov_b32 s6, s19
; GFX1030-NEXT:    s_mov_b32 s5, s18
; GFX1030-NEXT:    s_mov_b32 s4, s17
; GFX1030-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1030-NEXT:  .LBB4_2: ; %if.end
; GFX1030-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end, !prof !0

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

define void @divergent_br_profitable(i32 noundef inreg %value, ptr addrspace(8) nocapture writeonly inreg %res, i32 noundef inreg %v_offset, i32 noundef inreg %0, i32 noundef %flag) {
; GFX9-LABEL: divergent_br_profitable:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX9-NEXT:  ; %bb.1: ; %if.then
; GFX9-NEXT:    s_mov_b32 s7, s20
; GFX9-NEXT:    s_mov_b32 s6, s19
; GFX9-NEXT:    s_mov_b32 s5, s18
; GFX9-NEXT:    s_mov_b32 s4, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s21
; GFX9-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX9-NEXT:  ; %bb.2: ; %if.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-LABEL: divergent_br_profitable:
; GFX1010:       ; %bb.0: ; %entry
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0, v0
; GFX1010-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1010-NEXT:  ; %bb.1: ; %if.then
; GFX1010-NEXT:    v_mov_b32_e32 v0, s16
; GFX1010-NEXT:    v_mov_b32_e32 v1, s21
; GFX1010-NEXT:    s_mov_b32 s7, s20
; GFX1010-NEXT:    s_mov_b32 s6, s19
; GFX1010-NEXT:    s_mov_b32 s5, s18
; GFX1010-NEXT:    s_mov_b32 s4, s17
; GFX1010-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1010-NEXT:  ; %bb.2: ; %if.end
; GFX1010-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1010-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-LABEL: divergent_br_profitable:
; GFX1030:       ; %bb.0: ; %entry
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_mov_b32 s8, exec_lo
; GFX1030-NEXT:    v_cmpx_lt_i32_e32 0, v0
; GFX1030-NEXT:  ; %bb.1: ; %if.then
; GFX1030-NEXT:    v_mov_b32_e32 v0, s16
; GFX1030-NEXT:    v_mov_b32_e32 v1, s21
; GFX1030-NEXT:    s_mov_b32 s7, s20
; GFX1030-NEXT:    s_mov_b32 s6, s19
; GFX1030-NEXT:    s_mov_b32 s5, s18
; GFX1030-NEXT:    s_mov_b32 s4, s17
; GFX1030-NEXT:    buffer_store_dword v0, v1, s[4:7], 0 offen
; GFX1030-NEXT:  ; %bb.2: ; %if.end
; GFX1030-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1030-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    s_setpc_b64 s[30:31]
entry:
  %cmp = icmp sgt i32 %flag, 0
  br i1 %cmp, label %if.then, label %if.end, !prof !1

if.then:
  tail call void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32 %value, ptr addrspace(8) %res, i32 %v_offset, i32 0, i32 0)
  br label %if.end

if.end:
  call void @llvm.amdgcn.s.waitcnt(i32 0)
  ret void
}

declare void @llvm.amdgcn.raw.ptr.buffer.store.i32(i32, ptr addrspace(8) nocapture writeonly, i32, i32, i32 immarg)
declare void @llvm.amdgcn.s.waitcnt(i32)

!0 = !{!"branch_weights", i32 1000, i32 1000}
!1 = !{!"branch_weights", i32 2000, i32 1}
