; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=wasm32-unknown-unknown -mattr=+reference-types < %s | FileCheck %s

%externref = type ptr addrspace(10) ;; addrspace 10 is nonintegral
%funcref = type ptr addrspace(20)   ;; addrspace 20 is nonintegral

declare %externref @llvm.wasm.ref.null.extern() nounwind
declare %funcref @llvm.wasm.ref.null.func() nounwind
declare i32 @llvm.wasm.ref.is_null.extern(%externref) nounwind
declare i32 @llvm.wasm.ref.is_null.func(%funcref) nounwind

define %externref @get_null_extern() {
; CHECK-LABEL: get_null_extern:
; CHECK:         .functype get_null_extern () -> (externref)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    ref.null_extern
; CHECK-NEXT:    # fallthrough-return
  %null = call %externref @llvm.wasm.ref.null.extern()
  ret %externref %null
}

define %funcref @get_null_func() {
; CHECK-LABEL: get_null_func:
; CHECK:         .functype get_null_func () -> (funcref)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    ref.null_func
; CHECK-NEXT:    # fallthrough-return
  %null = call %funcref @llvm.wasm.ref.null.func()
  ret %funcref %null
}

define i32 @ref_is_null_extern(%externref %eref) {
; CHECK-LABEL: ref_is_null_extern:
; CHECK:         .functype ref_is_null_extern (externref) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    ref.null_extern
; CHECK-NEXT:    ref.is_null
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    ref.is_null
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    # fallthrough-return
  %null = call %externref @llvm.wasm.ref.null.extern()
  %is_null = call i32 @llvm.wasm.ref.is_null.extern(%externref %null)
  %arg_is_null = call i32 @llvm.wasm.ref.is_null.extern(%externref %eref)
  %res = add i32 %is_null, %arg_is_null
  ret i32 %res
}

define i32 @ref_is_null_func(%funcref %fref) {
; CHECK-LABEL: ref_is_null_func:
; CHECK:         .functype ref_is_null_func (funcref) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    ref.null_func
; CHECK-NEXT:    ref.is_null
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    ref.is_null
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    # fallthrough-return
  %null = call %funcref @llvm.wasm.ref.null.func()
  %is_null = call i32 @llvm.wasm.ref.is_null.func(%funcref %null)
  %arg_is_null = call i32 @llvm.wasm.ref.is_null.func(%funcref %fref)
  %res = add i32 %is_null, %arg_is_null
  ret i32 %res
}
