; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(i16)
declare void @llvm.assume(i1)

define void @test_monotonic_ptr_iv_inc_1_eq_to_uge(i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_eq_to_uge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp uge i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[LOOP_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, true
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.neg = icmp uge i16 %len, %a
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw nsw i16 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @test_remove_check_with_incrementing_integer_induction(i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_remove_check_with_incrementing_integer_induction(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG_NOT:%.*]] = icmp ult i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_NEG_NOT]], label [[LOOP_HEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp ne i16 [[IV]], [[LEN]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV]], [[A]]
; CHECK-NEXT:    [[OR_COND:%.*]] = and i1 [[C]], [[T_2]]
; CHECK-NEXT:    br i1 [[OR_COND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.neg.not = icmp ult i16 %len, %a
  br i1 %len.neg.not, label %loop.header, label %exit

loop.header:                                      ; preds = %entry, %loop.latch
  %iv = phi i16 [ %iv.next, %loop.latch ], [ 0, %entry ]
  %c = icmp ne i16 %iv, %len
  %t.2 = icmp ult i16 %iv, %a
  %or.cond = and i1 %c, %t.2
  br i1 %or.cond, label %loop.latch, label %exit

loop.latch:                                       ; preds = %loop.header
  call void @use(i16 %iv)
  %iv.next = add nuw nsw i16 %iv, 1
  br label %loop.header

exit:                                             ; preds = %loop.header, %entry
  ret void
}

define void @test_monotonic_ptr_iv_inc_2_eq_to_uge(i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2_eq_to_uge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_LT:%.*]] = icmp ult i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    br i1 [[LEN_LT]], label [[LOOP_PH:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, [[LOOP_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV]], [[A]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i16 [[IV]], 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.lt = icmp ult i16 %len, %a
  br i1 %len.lt, label %loop.ph, label %exit

loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw i16 %iv, 2
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_2_eq_to_uge_variable_start(i16 %start, i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2_eq_to_uge_variable_start(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_LT:%.*]] = icmp ult i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    [[START_LT:%.*]] = icmp ult i16 [[START:%.*]], [[LEN]]
; CHECK-NEXT:    [[AND_0:%.*]] = and i1 [[LEN_LT]], [[START_LT]]
; CHECK-NEXT:    br i1 [[AND_0]], label [[LOOP_PH:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ [[START]], [[LOOP_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq i16 [[IV]], [[LEN]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i16 [[IV]], [[A]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 true, [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i16 [[IV]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i16 [[IV]], 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %len.lt = icmp ult i16 %len, %a
  %start.lt = icmp ult i16 %start, %len
  %and.0 = and i1 %len.lt, %start.lt
  br i1 %and.0, label %loop.ph, label %exit

loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i16 [ %start, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw i16 %iv, 2
  br label %loop.header

exit:
  ret void
}


