; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s 2>&1 | FileCheck %s


define i8 @umax_of_add_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw i8 %a, %b
  %add2 = add nuw i8 %a, %c
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw_lhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw_lhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw nsw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw_lhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw_lhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw nsw i8 %a, %b
  %add2 = add nuw i8 %a, %c
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw_rhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw_rhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw nsw i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw_rhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw_rhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw i8 %a, %b
  %add2 = add nuw nsw i8 %a, %c
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw nsw i8 %b, %a
  %add2 = add nuw nsw i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umax_of_add_nuw_nsw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nuw_nsw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw nsw i8 %a, %b
  %add2 = add nuw nsw i8 %a, %c
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

; negative test
define i8 @umax_of_add_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add nsw i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nsw i8 [[C]], [[A]]
; CHECK-NEXT:    [[MAX:%.*]] = call i8 @llvm.umax.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

; negative test
define i8 @umax_of_add(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umax_of_add(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i8 [[C]], [[A]]
; CHECK-NEXT:    [[MAX:%.*]] = call i8 @llvm.umax.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add i8 %b, %a
  %add2 = add i8 %c, %a
  %max = call i8 @llvm.umax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @umin_of_add_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw i8 %a, %b
  %add2 = add nuw i8 %a, %c
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw_lhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw_lhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw nsw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw_lhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw_lhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw nsw i8 %a, %b
  %add2 = add nuw i8 %a, %c
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw_rhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw_rhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw nsw i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw_rhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw_rhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw i8 %a, %b
  %add2 = add nuw nsw i8 %a, %c
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw nsw i8 %b, %a
  %add2 = add nuw nsw i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @umin_of_add_nuw_nsw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nuw_nsw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.umin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw nsw i8 %a, %b
  %add2 = add nuw nsw i8 %a, %c
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

; negative test
define i8 @umin_of_add_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add nsw i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nsw i8 [[C]], [[A]]
; CHECK-NEXT:    [[MIN:%.*]] = call i8 @llvm.umin.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

; negative test
define i8 @umin_of_add(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @umin_of_add(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i8 [[C]], [[A]]
; CHECK-NEXT:    [[MIN:%.*]] = call i8 @llvm.umin.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add i8 %b, %a
  %add2 = add i8 %c, %a
  %min = call i8 @llvm.umin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

; negative test
define i8 @smax_of_add_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add nuw i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nuw i8 [[C]], [[A]]
; CHECK-NEXT:    [[MAX:%.*]] = call i8 @llvm.smax.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw i8 %a, %b
  %add2 = add nsw i8 %a, %c
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw_lhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw_lhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw nuw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw_lhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw_lhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw nuw i8 %a, %b
  %add2 = add nsw i8 %a, %c
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw_rhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw_rhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw nuw i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw_rhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw_rhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw i8 %a, %b
  %add2 = add nsw nuw i8 %a, %c
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw nuw i8 %b, %a
  %add2 = add nsw nuw i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

define i8 @smax_of_add_nsw_nuw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add_nsw_nuw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smax.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MAX:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add nsw nuw i8 %a, %b
  %add2 = add nsw nuw i8 %a, %c
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

; negative test
define i8 @smax_of_add(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smax_of_add(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i8 [[C]], [[A]]
; CHECK-NEXT:    [[MAX:%.*]] = call i8 @llvm.smax.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MAX]]
;
  %add1 = add i8 %b, %a
  %add2 = add i8 %c, %a
  %max = call i8 @llvm.smax.i8(i8 %add1, i8 %add2)
  ret i8 %max
}

; negative test
define i8 @smin_of_add_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add nuw i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nuw i8 [[C]], [[A]]
; CHECK-NEXT:    [[MIN:%.*]] = call i8 @llvm.smin.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nuw i8 %b, %a
  %add2 = add nuw i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw i8 %a, %b
  %add2 = add nsw i8 %a, %c
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw_lhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw_lhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw nuw i8 %b, %a
  %add2 = add nsw i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw_lhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw_lhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw nuw i8 %a, %b
  %add2 = add nsw i8 %a, %c
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw_rhs(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw_rhs(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw i8 %b, %a
  %add2 = add nsw nuw i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw_rhs_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw_rhs_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw i8 %a, %b
  %add2 = add nsw nuw i8 %a, %c
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw nuw i8 %b, %a
  %add2 = add nsw nuw i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

define i8 @smin_of_add_nsw_nuw_comm(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add_nsw_nuw_comm(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.smin.i8(i8 [[B]], i8 [[C]])
; CHECK-NEXT:    [[MIN:%.*]] = add nuw nsw i8 [[TMP1]], [[A]]
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add nsw nuw i8 %a, %b
  %add2 = add nsw nuw i8 %a, %c
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}

; negative test
define i8 @smin_of_add(i8 %a, i8 %b, i8 %c) {
; CHECK-LABEL: define i8 @smin_of_add(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[ADD1:%.*]] = add i8 [[B]], [[A]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i8 [[C]], [[A]]
; CHECK-NEXT:    [[MIN:%.*]] = call i8 @llvm.smin.i8(i8 [[ADD1]], i8 [[ADD2]])
; CHECK-NEXT:    ret i8 [[MIN]]
;
  %add1 = add i8 %b, %a
  %add2 = add i8 %c, %a
  %min = call i8 @llvm.smin.i8(i8 %add1, i8 %add2)
  ret i8 %min
}
