; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X86

define i32 @test_x86_avx512_vcvttsd2usis(<2 x double> %a0) {
; CHECK-LABEL: test_x86_avx512_vcvttsd2usis:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttsd2usis %xmm0, %ecx # encoding: [0x62,0xf5,0x7f,0x08,0x6c,0xc8]
; CHECK-NEXT:    vcvttsd2usis {sae}, %xmm0, %eax # encoding: [0x62,0xf5,0x7f,0x18,0x6c,0xc0]
; CHECK-NEXT:    addl %ecx, %eax # encoding: [0x01,0xc8]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call i32 @llvm.x86.avx10.vcvttsd2usis(<2 x double> %a0, i32 4) ;
  %res1 = call i32 @llvm.x86.avx10.vcvttsd2usis(<2 x double> %a0, i32 8) ;
  %res2 = add i32 %res0, %res1
  ret i32 %res2
}
declare i32 @llvm.x86.avx10.vcvttsd2usis(<2 x double>, i32) nounwind readnone

define i32 @test_x86_avx512_vcvttsd2sis(<2 x double> %a0) {
; CHECK-LABEL: test_x86_avx512_vcvttsd2sis:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttsd2sis %xmm0, %ecx # encoding: [0x62,0xf5,0x7f,0x08,0x6d,0xc8]
; CHECK-NEXT:    vcvttsd2sis {sae}, %xmm0, %eax # encoding: [0x62,0xf5,0x7f,0x18,0x6d,0xc0]
; CHECK-NEXT:    addl %ecx, %eax # encoding: [0x01,0xc8]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call i32 @llvm.x86.avx10.vcvttsd2sis(<2 x double> %a0, i32 4) ;
  %res1 = call i32 @llvm.x86.avx10.vcvttsd2sis(<2 x double> %a0, i32 8) ;
  %res2 = add i32 %res0, %res1
  ret i32 %res2
}
declare i32 @llvm.x86.avx10.vcvttsd2sis(<2 x double>, i32) nounwind readnone

define i32 @test_x86_avx512_vcvttss2sis(<4 x float> %a0) {
; CHECK-LABEL: test_x86_avx512_vcvttss2sis:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttss2sis {sae}, %xmm0, %ecx # encoding: [0x62,0xf5,0x7e,0x18,0x6d,0xc8]
; CHECK-NEXT:    vcvttss2sis %xmm0, %eax # encoding: [0x62,0xf5,0x7e,0x08,0x6d,0xc0]
; CHECK-NEXT:    addl %ecx, %eax # encoding: [0x01,0xc8]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call i32 @llvm.x86.avx10.vcvttss2sis(<4 x float> %a0, i32 8) ;
  %res1 = call i32 @llvm.x86.avx10.vcvttss2sis(<4 x float> %a0, i32 4) ;
  %res2 = add i32 %res0, %res1
  ret i32 %res2
}
declare i32 @llvm.x86.avx10.vcvttss2sis(<4 x float>, i32) nounwind readnone

define i32 @test_x86_avx512_vcvttss2sis_load(ptr %a0) {
; X64-LABEL: test_x86_avx512_vcvttss2sis_load:
; X64:       # %bb.0:
; X64-NEXT:    vcvttss2sis (%rdi), %eax # encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_x86_avx512_vcvttss2sis_load:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttss2sis (%eax), %eax # encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %a1 = load <4 x float>, ptr %a0
  %res = call i32 @llvm.x86.avx10.vcvttss2sis(<4 x float> %a1, i32 4) ;
  ret i32 %res
}

define i32 @test_x86_avx512_vcvttss2usis(<4 x float> %a0) {
; CHECK-LABEL: test_x86_avx512_vcvttss2usis:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttss2usis {sae}, %xmm0, %ecx # encoding: [0x62,0xf5,0x7e,0x18,0x6c,0xc8]
; CHECK-NEXT:    vcvttss2usis %xmm0, %eax # encoding: [0x62,0xf5,0x7e,0x08,0x6c,0xc0]
; CHECK-NEXT:    addl %ecx, %eax # encoding: [0x01,0xc8]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call i32 @llvm.x86.avx10.vcvttss2usis(<4 x float> %a0, i32 8) ;
  %res1 = call i32 @llvm.x86.avx10.vcvttss2usis(<4 x float> %a0, i32 4) ;
  %res2 = add i32 %res0, %res1
  ret i32 %res2
}
declare i32 @llvm.x86.avx10.vcvttss2usis(<4 x float>, i32) nounwind readnone

define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_256(<4 x double> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %ymm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x29,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %ymm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x29,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.round.256( <4 x double> %x0, <4 x i32> %src, i8 %mask, i32 4)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_maskz_vcvtt_pd2dqs_256_z(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2dqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6d,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2dqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6d,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.round.256( <4 x double> %x0, <4 x i32> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_256_undef(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6d,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6d,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.round.256( <4 x double> %x0, <4 x i32> undef, i8 %mask, i32 4)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_256_default(<4 x double>* %xptr) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttpd2dqsy (%rdi), %xmm0 # encoding: [0x62,0xf5,0xfc,0x28,0x6d,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2dqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttpd2dqsy (%eax), %xmm0 # encoding: [0x62,0xf5,0xfc,0x28,0x6d,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x0 = load <4 x double>, <4 x double> * %xptr
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.round.256( <4 x double> %x0, <4 x i32> undef, i8 -1, i32 4)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.round.256(<4 x double>, <4 x i32>, i8 , i32)

define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_256(<4 x double> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2udqs %ymm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x29,0x6c,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2udqs %ymm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x29,0x6c,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.round.256( <4 x double> %x0, <4 x i32> %src, i8 %mask, i32 4)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_maskz_vcvtt_pd2udqs_256_z(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2udqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2udqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6c,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2udqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2udqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6c,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.round.256( <4 x double> %x0, <4 x i32> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_256_undef(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2udqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6c,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2udqs %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0xa9,0x6c,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.round.256( <4 x double> %x0, <4 x i32> undef, i8 %mask, i32 4)
  ret <4 x i32> %res
}


define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_256_default(<4 x double>* %x0) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttpd2udqsy (%rdi), %xmm0 # encoding: [0x62,0xf5,0xfc,0x28,0x6c,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2udqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttpd2udqsy (%eax), %xmm0 # encoding: [0x62,0xf5,0xfc,0x28,0x6c,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x10 = load <4 x double>, <4 x double> * %x0
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.round.256( <4 x double> %x10, <4 x i32> undef, i8 -1, i32 4)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.round.256(<4 x double>, <4 x i32>, i8 , i32)

define <4 x i64> @test_int_x86_mask_vcvtt_pd2qqs_256(<4 x double> %x0, <4 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x29,0x6d,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x29,0x6d,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.round.256( <4 x double> %x0, <4 x i64> %src, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_maskz_vcvtt_pd2qqs_256_z(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2qqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2qqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.round.256( <4 x double> %x0, <4 x i64> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_mask_vcvtt_pd2qqs_256_undef(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.round.256( <4 x double> %x0, <4 x i64> undef, i8 %mask, i32 4)
  ret <4 x i64> %res
}


define <4 x i64> @test_int_x86_mask_vcvtt_pd2qqs_256_default(<4 x double>* %x0) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttpd2qqs (%rdi), %ymm0 # encoding: [0x62,0xf5,0xfd,0x28,0x6d,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2qqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs (%eax), %ymm0 # encoding: [0x62,0xf5,0xfd,0x28,0x6d,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x10 =  load <4 x double>, <4 x double>* %x0
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.round.256( <4 x double> %x10, <4 x i64> undef, i8 -1, i32 4)
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.round.256(<4 x double>, <4 x i64>, i8 , i32)

define <4 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_256(<4 x double> %x0, <4 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x29,0x6c,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x29,0x6c,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.round.256( <4 x double> %x0, <4 x i64> %src, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_maskz_vcvtt_pd2uqqs_256_z(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2uqqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2uqqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.round.256( <4 x double> %x0, <4 x i64> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_256_undef(<4 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.round.256( <4 x double> %x0, <4 x i64> undef, i8 %mask, i32 4)
  ret <4 x i64> %res
}


define <4 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_256_default(<4 x double>* %x0) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttpd2uqqs (%rdi), %ymm0 # encoding: [0x62,0xf5,0xfd,0x28,0x6c,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs (%eax), %ymm0 # encoding: [0x62,0xf5,0xfd,0x28,0x6c,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x10 =  load <4 x double>, <4 x double>* %x0
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.round.256( <4 x double> %x10, <4 x i64> undef, i8 -1, i32 4)
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.round.256(<4 x double>, <4 x i64>, i8 , i32)

define <8 x i32> @test_int_x86_mask_vcvtt_ps2dqs_256(<8 x float> %x0, <8 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x29,0x6d,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x29,0x6d,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.round.256( <8 x float> %x0, <8 x i32> %src, i8 %mask, i32 4)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_maskz_vcvtt_ps2dqs_256_z(<8 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2dqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2dqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.round.256( <8 x float> %x0, <8 x i32> zeroinitializer, i8 %mask, i32 4)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_mask_vcvtt_ps2dqs_256_undef(<8 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.round.256( <8 x float> %x0, <8 x i32> undef, i8 %mask, i32 4)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_mask_vcvtt_ps2dqs_256_default(<8 x float>* %x0) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttps2dqs (%rdi), %ymm0 # encoding: [0x62,0xf5,0x7c,0x28,0x6d,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2dqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttps2dqs (%eax), %ymm0 # encoding: [0x62,0xf5,0x7c,0x28,0x6d,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x10 =  load <8 x float>, <8 x float>* %x0
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.round.256( <8 x float> %x10, <8 x i32> undef, i8 -1, i32 4)
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.round.256(<8 x float>, <8 x i32>, i8 , i32)

define <8 x i32> @test_int_x86_mask_vcvtt_ps2udqs_256(<8 x float> %x0, <8 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x29,0x6c,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %ymm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x29,0x6c,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.round.256( <8 x float> %x0, <8 x i32> %src, i8 %mask, i32 4)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_maskz_vcvtt_ps2udqs_256_z(<8 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2udqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2udqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.round.256( <8 x float> %x0, <8 x i32> zeroinitializer, i8 %mask, i32 4)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_mask_vcvtt_ps2udqs_256_undef(<8 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.round.256( <8 x float> %x0, <8 x i32> undef, i8 %mask, i32 4)
  ret <8 x i32> %res
}


define <8 x i32> @test_int_x86_mask_vcvtt_ps2udqs_256_default(<8 x float>* %x0) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256_default:
; X64:       # %bb.0:
; X64-NEXT:    vcvttps2udqs (%rdi), %ymm0 # encoding: [0x62,0xf5,0x7c,0x28,0x6c,0x07]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2udqs_256_default:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x04]
; X86-NEXT:    vcvttps2udqs (%eax), %ymm0 # encoding: [0x62,0xf5,0x7c,0x28,0x6c,0x00]
; X86-NEXT:    retl # encoding: [0xc3]
  %x10 =  load <8 x float>, <8 x float>* %x0
  %res = call <8 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.round.256( <8 x float> %x10, <8 x i32> undef, i8 -1, i32 4)
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.round.256(<8 x float>, <8 x i32>, i8 , i32)

define <4 x i64> @test_int_x86_maskz_vcvtt_ps2qqs_256_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2qqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2qqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.round.256( <4 x float> %x0, <4 x i64> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_mask_vcvtt_ps2qqs_256_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2qqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2qqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.round.256( <4 x float> %x0, <4 x i64> undef, i8 %mask, i32 4)
  ret <4 x i64> %res
}
declare <4 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.round.256(<4 x float>, <4 x i64>, i8 , i32)

define <4 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_256(<4 x float> %x0, <4 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x29,0x6c,0xc8]
; X64-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x29,0x6c,0xc8]
; X86-NEXT:    vmovaps %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.round.256( <4 x float> %x0, <4 x i64> %src, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_maskz_vcvtt_ps2uqqs_256_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2uqqs_256_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2uqqs_256_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.round.256( <4 x float> %x0, <4 x i64> zeroinitializer, i8 %mask, i32 4)
  ret <4 x i64> %res
}

define <4 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_256_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_256_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_256_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xa9,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.round.256( <4 x float> %x0, <4 x i64> undef, i8 %mask, i32 4)
  ret <4 x i64> %res
}


define <4 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_256_default(<4 x float> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_256_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2uqqs %xmm0, %ymm0 # encoding: [0x62,0xf5,0x7d,0x28,0x6c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.round.256( <4 x float> %x0, <4 x i64> undef, i8 -1, i32 4)
  ret <4 x i64> %res
}

declare <4 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.round.256(<4 x float>, <4 x i64>, i8 , i32)

define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_128(<2 x double> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2dqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2dqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.128( <2 x double> %x0, <4 x i32> %src, i8 %mask)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_maskz_vcvtt_pd2dqs_128_z(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2dqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2dqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.128( <2 x double> %x0, <4 x i32> zeroinitializer, i8 %mask)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_128_undef(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2dqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2dqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.128( <2 x double> %x0, <4 x i32> undef, i8 %mask)
  ret <4 x i32> %res
}


define <4 x i32> @test_int_x86_mask_vcvtt_pd2dqs_128_default(<2 x double> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_pd2dqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0xfc,0x08,0x6d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.128( <2 x double> %x0, <4 x i32> undef, i8 -1)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2dqs.128(<2 x double>, <4 x i32>, i8)

define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_128(<2 x double> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2udqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2udqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.128( <2 x double> %x0, <4 x i32> %src, i8 %mask)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_maskz_vcvtt_pd2udqs_128_z(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2udqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2udqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfc,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.128( <2 x double> %x0, <4 x i32> zeroinitializer, i8 %mask)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_128_undef(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2udqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2udqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2dqs %xmm0, %xmm0 {%k1} # encoding: [0x62,0xf5,0xfc,0x09,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.128( <2 x double> %x0, <4 x i32> undef, i8 %mask)
  ret <4 x i32> %res
}


define <4 x i32> @test_int_x86_mask_vcvtt_pd2udqs_128_default(<2 x double> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_pd2udqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2udqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0xfc,0x08,0x6c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.128( <2 x double> %x0, <4 x i32> undef, i8 -1)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttpd2udqs.128(<2 x double>, <4 x i32>, i8)

define <2 x i64> @test_int_x86_mask_vcvtt_pd2qqs_128(<2 x double> %x0, <2 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2qqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x09,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2qqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x09,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.128( <2 x double> %x0, <2 x i64> %src, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_maskz_vcvtt_pd2qqs_128_z(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2qqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2qqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.128( <2 x double> %x0, <2 x i64> zeroinitializer, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_mask_vcvtt_pd2qqs_128_undef(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2qqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2qqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.128( <2 x double> %x0, <2 x i64> undef, i8 %mask)
  ret <2 x i64> %res
}


define <2 x i64> @test_int_x86_mask_vcvtt_pd2qqs_128_default(<2 x double> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_pd2qqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2qqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0xfd,0x08,0x6d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.128( <2 x double> %x0, <2 x i64> undef, i8 -1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx10.mask.vcvttpd2qqs.128(<2 x double>, <2 x i64>, i8)

define <2 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_128(<2 x double> %x0, <2 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x09,0x6c,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0xfd,0x09,0x6c,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.128( <2 x double> %x0, <2 x i64> %src, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_maskz_vcvtt_pd2uqqs_128_z(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_pd2uqqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_pd2uqqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.128( <2 x double> %x0, <2 x i64> zeroinitializer, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_128_undef(<2 x double> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttpd2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttpd2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfd,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.128( <2 x double> %x0, <2 x i64> undef, i8 %mask)
  ret <2 x i64> %res
}


define <2 x i64> @test_int_x86_mask_vcvtt_pd2uqqs_128_default(<2 x double> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_pd2uqqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2uqqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0xfd,0x08,0x6c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.128( <2 x double> %x0, <2 x i64> undef, i8 -1)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx10.mask.vcvttpd2uqqs.128(<2 x double>, <2 x i64>, i8)

define <2 x i64> @test_int_x86_mask_vcvtt_ps2qqs_128_default(<4 x float> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_ps2qqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2qqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x6d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.128( <4 x float> %x0, <2 x i64> undef, i8 -1)
  ret <2 x i64> %res
}

define <4 x i32> @test_int_x86_mask_vcvtt_ps2dqs_128(<4 x float> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2dqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x09,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2dqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x09,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.128( <4 x float> %x0, <4 x i32> %src, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_maskz_vcvtt_ps2dqs_128_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2dqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2dqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.128( <4 x float> %x0, <4 x i32> zeroinitializer, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_mask_vcvtt_ps2dqs_128_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2dqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2dqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2dqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.128( <4 x float> %x0, <4 x i32> undef, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_mask_vcvtt_ps2dqs_128_default(<4 x float> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_ps2dqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x6d,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.128( <4 x float> %x0, <4 x i32> undef, i8 -1)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttps2dqs.128(<4 x float>, <4 x i32>, i8)

define <4 x i32> @test_int_x86_mask_vcvtt_ps2udqs_128(<4 x float> %x0, <4 x i32> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2udqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x09,0x6c,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2udqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7c,0x09,0x6c,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.128( <4 x float> %x0, <4 x i32> %src, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_maskz_vcvtt_ps2udqs_128_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2udqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2udqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.128( <4 x float> %x0, <4 x i32> zeroinitializer, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_mask_vcvtt_ps2udqs_128_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2udqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2udqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2udqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2udqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.128( <4 x float> %x0, <4 x i32> undef, i8 %mask)
  ret <4 x i32> %res
}
define <4 x i32> @test_int_x86_mask_vcvtt_ps2udqs_128_default(<4 x float> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_ps2udqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2udqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x6c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <4 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.128( <4 x float> %x0, <4 x i32> undef, i8 -1)
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx10.mask.vcvttps2udqs.128(<4 x float>, <4 x i32>, i8)

define <2 x i64> @test_int_x86_mask_vcvtt_ps2qqs_128_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2qqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2qqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.128( <4 x float> %x0, <2 x i64> undef, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_maskz_vcvtt_ps2qqs_128_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2qqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6d,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2qqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6d,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.128( <4 x float> %x0, <2 x i64> zeroinitializer, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_mask_vcvtt_ps2qqs_128(<4 x float> %x0, <2 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2qqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2qqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x6d,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2qqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2qqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x6d,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.128( <4 x float> %x0, <2 x i64> %src, i8 %mask)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx10.mask.vcvttps2qqs.128(<4 x float>, <2 x i64>, i8)

define <2 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_128(<4 x float> %x0, <2 x i64> %src, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x6c,0xc8]
; X64-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7d,0x09,0x6c,0xc8]
; X86-NEXT:    vmovaps %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.128( <4 x float> %x0, <2 x i64> %src, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_128_undef(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_128_undef:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_128_undef:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.128( <4 x float> %x0, <2 x i64> undef, i8 %mask)
  ret <2 x i64> %res
}

define <2 x i64> @test_int_x86_mask_vcvtt_ps2uqqs_128_default(<4 x float> %x0) {
; CHECK-LABEL: test_int_x86_mask_vcvtt_ps2uqqs_128_default:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2uqqs %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7d,0x08,0x6c,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.128( <4 x float> %x0, <2 x i64> undef, i8 -1)
  ret <2 x i64> %res
}
define <2 x i64> @test_int_x86_maskz_vcvtt_ps2uqqs_128_z(<4 x float> %x0, i8 %mask) {
; X64-LABEL: test_int_x86_maskz_vcvtt_ps2uqqs_128_z:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvttps2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6c,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vcvtt_ps2uqqs_128_z:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvttps2uqqs %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0x89,0x6c,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <2 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.128( <4 x float> %x0, <2 x i64> zeroinitializer, i8 %mask)
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.avx10.mask.vcvttps2uqqs.128(<4 x float>, <2 x i64>, i8)

