; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -mattr=+altivec -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefixes=LE
; RUN: llc -mtriple=powerpc64-unknown-linux-gnu -mattr=+altivec,+direct-move -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefixes=BE

; LE-LABEL: .LCPI0_0:
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15
; LE-NEXT: 	.byte	30
; LE-NEXT: 	.byte	14
; LE-NEXT: 	.byte	29
; LE-NEXT: 	.byte	13
; LE-NEXT: 	.byte	28
; LE-NEXT: 	.byte	12
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15

; BE-LABEL: .LCPI0_0:
; BE-NEXT: 	.byte	0
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	1
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	2
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	3
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	0
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	0
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	0
; BE-NEXT: 	.byte	16
; BE-NEXT: 	.byte	0
; BE-NEXT: 	.byte	16

define <16 x i8> @test1(<16 x i8> %a) {
; LE-LABEL: test1:
; LE:       # %bb.0:
; LE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; LE-NEXT:    xxlxor vs36, vs36, vs36
; LE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; LE-NEXT:    lxvd2x vs0, 0, r3
; LE-NEXT:    xxswapd vs35, vs0
; LE-NEXT:    vperm v2, v4, v2, v3
; LE-NEXT:    blr
;
; BE-LABEL: test1:
; BE:       # %bb.0:
; BE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; BE-NEXT:    xxlxor vs36, vs36, vs36
; BE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; BE-NEXT:    lxvw4x vs35, 0, r3
; BE-NEXT:    vperm v2, v2, v4, v3
; BE-NEXT:    blr
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32> <i32 0, i32 16, i32 1, i32 16, i32 2, i32 16, i32 3, i32 16, i32 poison, i32 16, i32 poison, i32 16, i32 poison, i32 16, i32 poison, i32 16>
  ret <16 x i8> %shuffle
}

; LE-LABEL: .LCPI1_0:
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	15
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	14
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	13
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	12
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	11
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	10
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	9
; LE-NEXT: 	.byte	31
; LE-NEXT: 	.byte	8

define <16 x i8> @test2(<16 x i8> %a) {
; LE-LABEL: test2:
; LE:       # %bb.0:
; LE-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; LE-NEXT:    xxlxor vs36, vs36, vs36
; LE-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; LE-NEXT:    lxvd2x vs0, 0, r3
; LE-NEXT:    xxswapd vs35, vs0
; LE-NEXT:    vperm v2, v2, v4, v3
; LE-NEXT:    blr
;
; BE-LABEL: test2:
; BE:       # %bb.0:
; BE-NEXT:    xxlxor vs35, vs35, vs35
; BE-NEXT:    vmrghb v2, v3, v2
; BE-NEXT:    blr
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> zeroinitializer, <16 x i32> <i32 16, i32 0, i32 16, i32 1, i32 16, i32 2, i32 16, i32 3, i32 16, i32 4, i32 poison, i32 5, i32 poison, i32 6, i32 poison, i32 7>
  ret <16 x i8> %shuffle
}
