; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=m68k %s -stop-after=finalize-isel -o - | FileCheck %s

; We want to make sure caller doesn't pop the stack for callees using
; the M68k_RTD CC. However, we've implemented some frame optimization
; techniques to eliminate as many as frame setup/destroy instructions.
; Therefore, to make test case small and concise, we check the MIR generated
; after ISel instead.

declare dso_local m68k_rtdcc void @callee(i32 noundef)
declare dso_local m68k_rtdcc void @va_callee(i32 noundef, ...)

define dso_local i32 @caller(ptr noundef %y) {
  ; CHECK-LABEL: name: caller
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   [[MOV32rp:%[0-9]+]]:ar32 = MOV32rp 0, %fixed-stack.0, implicit-def dead $ccr :: (load (s32) from %fixed-stack.0, align 8)
  ; CHECK-NEXT:   [[MOV32rj:%[0-9]+]]:xr32 = MOV32rj killed [[MOV32rp]], implicit-def dead $ccr :: (load (s32) from %ir.y)
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def dead $sp, implicit-def dead $ccr, implicit $sp
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:ar32 = COPY $sp
  ; CHECK-NEXT:   MOV32jr [[COPY]], [[MOV32rj]], implicit-def dead $ccr :: (store (s32) into stack, align 2)
  ; CHECK-NEXT:   CALLb @callee, csr_std, implicit $sp, implicit-def $sp
  ; CHECK-NEXT:   ADJCALLSTACKUP 4, 4, implicit-def dead $sp, implicit-def dead $ccr, implicit $sp
  ; CHECK-NEXT:   $d0 = COPY [[MOV32rj]]
  ; CHECK-NEXT:   RET 0, $d0
entry:
  %0 = load i32, ptr %y, align 4
  call m68k_rtdcc void @callee(i32 noundef %0)
  ret i32 %0
}

define dso_local i32 @va_caller(ptr noundef %y) {
  ; CHECK-LABEL: name: va_caller
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   [[MOV32rp:%[0-9]+]]:ar32 = MOV32rp 0, %fixed-stack.0, implicit-def dead $ccr :: (load (s32) from %fixed-stack.0, align 8)
  ; CHECK-NEXT:   [[MOV32rj:%[0-9]+]]:xr32 = MOV32rj killed [[MOV32rp]], implicit-def dead $ccr :: (load (s32) from %ir.y)
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def dead $sp, implicit-def dead $ccr, implicit $sp
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:ar32 = COPY $sp
  ; CHECK-NEXT:   MOV32jr [[COPY]], [[MOV32rj]], implicit-def dead $ccr :: (store (s32) into stack, align 2)
  ; CHECK-NEXT:   CALLb @va_callee, csr_std, implicit $sp, implicit-def $sp
  ; CHECK-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def dead $sp, implicit-def dead $ccr, implicit $sp
  ; CHECK-NEXT:   $d0 = COPY [[MOV32rj]]
  ; CHECK-NEXT:   RET 0, $d0
entry:
  %0 = load i32, ptr %y, align 4
  call m68k_rtdcc void (i32, ...) @va_callee(i32 noundef %0)
  ret i32 %0
}

