; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=x86_64 < %s | FileCheck %s

define i128 @avgflooru_i128(i128 %x, i128 %y) {
; CHECK-LABEL: avgflooru_i128:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    addq %rdx, %rax
; CHECK-NEXT:    adcq %rcx, %rsi
; CHECK-NEXT:    setb %cl
; CHECK-NEXT:    shrdq $1, %rsi, %rax
; CHECK-NEXT:    movzbl %cl, %edx
; CHECK-NEXT:    shldq $63, %rsi, %rdx
; CHECK-NEXT:    retq
start:
  %xor = xor i128 %y, %x
  %lshr = lshr i128 %xor, 1
  %and = and i128 %y, %x
  %add = add i128 %lshr, %and
  ret i128 %add
}

declare void @use(i8)

define i128 @avgflooru_i128_multi_use(i128 %x, i128 %y) nounwind {
; CHECK-LABEL: avgflooru_i128_multi_use:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %r13
; CHECK-NEXT:    pushq %r12
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movq %rcx, %rbx
; CHECK-NEXT:    movq %rdx, %r14
; CHECK-NEXT:    movq %rsi, %r15
; CHECK-NEXT:    movq %rdi, %r12
; CHECK-NEXT:    movq %rdx, %r13
; CHECK-NEXT:    xorq %rdi, %r13
; CHECK-NEXT:    movq %rcx, %rbp
; CHECK-NEXT:    xorq %rsi, %rbp
; CHECK-NEXT:    movq %r13, %rdi
; CHECK-NEXT:    movq %rbp, %rsi
; CHECK-NEXT:    callq use@PLT
; CHECK-NEXT:    shrdq $1, %rbp, %r13
; CHECK-NEXT:    shrq %rbp
; CHECK-NEXT:    movq %r13, %rdi
; CHECK-NEXT:    movq %rbp, %rsi
; CHECK-NEXT:    callq use@PLT
; CHECK-NEXT:    addq %r14, %r12
; CHECK-NEXT:    adcq %rbx, %r15
; CHECK-NEXT:    setb %al
; CHECK-NEXT:    shrdq $1, %r15, %r12
; CHECK-NEXT:    movzbl %al, %edx
; CHECK-NEXT:    shldq $63, %r15, %rdx
; CHECK-NEXT:    movq %r12, %rax
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r12
; CHECK-NEXT:    popq %r13
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
start:
  %xor = xor i128 %y, %x
  call void @use(i128 %xor)
  %lshr = lshr i128 %xor, 1
  call void @use(i128 %lshr)
  %and = and i128 %y, %x
  %add = add i128 %lshr, %and
  ret i128 %add
}

; This test case shouldn't combine because it's not
; an avgflooru operation

define i128 @avgflooru_i128_negative(i128 %x, i128 %y) {
; CHECK-LABEL: avgflooru_i128_negative:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    andq %rsi, %rcx
; CHECK-NEXT:    notq %rsi
; CHECK-NEXT:    andq %rdi, %rdx
; CHECK-NEXT:    notq %rax
; CHECK-NEXT:    addq %rdx, %rax
; CHECK-NEXT:    adcq %rcx, %rsi
; CHECK-NEXT:    movq %rsi, %rdx
; CHECK-NEXT:    retq
start:
  %xor = xor i128 %x, -1
  %and = and i128 %y, %x
  %add = add i128 %xor, %and
  ret i128 %add
}

; This negative test case shouldn't combine, i32 is already properly
; handled in terms of legalization, compared to the i128

define i32 @avgflooru_i128_negative2(i32 %x, i32 %y) {
; CHECK-LABEL: avgflooru_i128_negative2:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    movl %edi, %ecx
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    addq %rcx, %rax
; CHECK-NEXT:    shrq %rax
; CHECK-NEXT:    # kill: def $eax killed $eax killed $rax
; CHECK-NEXT:    retq
start:
  %xor = xor i32 %y, %x
  %lshr = lshr i32 %xor, 1
  %and = and i32 %y, %x
  %add = add i32 %lshr, %and
  ret i32 %add
}

define <2 x i128> @avgflooru_i128_vec(<2 x i128> %x, <2 x i128> %y) {
; CHECK-LABEL: avgflooru_i128_vec:
; CHECK:       # %bb.0: # %start
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    addq %r9, %rsi
; CHECK-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; CHECK-NEXT:    setb %dil
; CHECK-NEXT:    movzbl %dil, %edi
; CHECK-NEXT:    shldq $63, %rdx, %rdi
; CHECK-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; CHECK-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; CHECK-NEXT:    setb %r9b
; CHECK-NEXT:    movzbl %r9b, %r9d
; CHECK-NEXT:    shldq $63, %r8, %r9
; CHECK-NEXT:    shldq $63, %rsi, %rdx
; CHECK-NEXT:    shldq $63, %rcx, %r8
; CHECK-NEXT:    movq %r8, 16(%rax)
; CHECK-NEXT:    movq %rdx, (%rax)
; CHECK-NEXT:    movq %r9, 24(%rax)
; CHECK-NEXT:    movq %rdi, 8(%rax)
; CHECK-NEXT:    retq
start:
  %xor = xor <2 x i128> %y, %x
  %lshr = lshr <2 x i128> %xor, <i128 1, i128 1>
  %and = and <2 x i128> %y, %x
  %add = add <2 x i128> %lshr, %and
  ret <2 x i128> %add
}
