; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib %s | FileCheck %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"

declare float @_Z4fabsf(float)
declare <2 x float> @_Z4fabsDv2_f(<2 x float>)
declare <3 x float> @_Z4fabsDv3_f(<3 x float>)
declare <4 x float> @_Z4fabsDv4_f(<4 x float>)
declare <8 x float> @_Z4fabsDv8_f(<8 x float>)
declare <16 x float> @_Z4fabsDv16_f(<16 x float>)

declare double @_Z4fabsd(double)
declare <2 x double> @_Z4fabsDv2_d(<2 x double>)
declare <3 x double> @_Z4fabsDv3_d(<3 x double>)
declare <4 x double> @_Z4fabsDv4_d(<4 x double>)
declare <8 x double> @_Z4fabsDv8_d(<8 x double>)
declare <16 x double> @_Z4fabsDv16_d(<16 x double>)

declare half @_Z4fabsDh(half)
declare <2 x half> @_Z4fabsDv2_Dh(<2 x half>)
declare <3 x half> @_Z4fabsDv3_Dh(<3 x half>)
declare <4 x half> @_Z4fabsDv4_Dh(<4 x half>)
declare <8 x half> @_Z4fabsDv8_Dh(<8 x half>)
declare <16 x half> @_Z4fabsDv16_Dh(<16 x half>)

define float @test_fabs_f32(float %arg) {
; CHECK-LABEL: define float @test_fabs_f32
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call float @llvm.fabs.f32(float [[ARG]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call float @_Z4fabsf(float %arg)
  ret float %fabs
}

define <2 x float> @test_fabs_v2f32(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_fabs_v2f32
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <2 x float> @llvm.fabs.v2f32(<2 x float> [[ARG]])
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %fabs = tail call <2 x float> @_Z4fabsDv2_f(<2 x float> %arg)
  ret <2 x float> %fabs
}

define <3 x float> @test_fabs_v3f32(<3 x float> %arg) {
; CHECK-LABEL: define <3 x float> @test_fabs_v3f32
; CHECK-SAME: (<3 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <3 x float> @llvm.fabs.v3f32(<3 x float> [[ARG]])
; CHECK-NEXT:    ret <3 x float> [[FABS]]
;
  %fabs = tail call <3 x float> @_Z4fabsDv3_f(<3 x float> %arg)
  ret <3 x float> %fabs
}

define <4 x float> @test_fabs_v4f32(<4 x float> %arg) {
; CHECK-LABEL: define <4 x float> @test_fabs_v4f32
; CHECK-SAME: (<4 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <4 x float> @llvm.fabs.v4f32(<4 x float> [[ARG]])
; CHECK-NEXT:    ret <4 x float> [[FABS]]
;
  %fabs = tail call <4 x float> @_Z4fabsDv4_f(<4 x float> %arg)
  ret <4 x float> %fabs
}

define <8 x float> @test_fabs_v8f32(<8 x float> %arg) {
; CHECK-LABEL: define <8 x float> @test_fabs_v8f32
; CHECK-SAME: (<8 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <8 x float> @llvm.fabs.v8f32(<8 x float> [[ARG]])
; CHECK-NEXT:    ret <8 x float> [[FABS]]
;
  %fabs = tail call <8 x float> @_Z4fabsDv8_f(<8 x float> %arg)
  ret <8 x float> %fabs
}

define <16 x float> @test_fabs_v16f32(<16 x float> %arg) {
; CHECK-LABEL: define <16 x float> @test_fabs_v16f32
; CHECK-SAME: (<16 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <16 x float> @llvm.fabs.v16f32(<16 x float> [[ARG]])
; CHECK-NEXT:    ret <16 x float> [[FABS]]
;
  %fabs = tail call <16 x float> @_Z4fabsDv16_f(<16 x float> %arg)
  ret <16 x float> %fabs
}

define double @test_fabs_f64(double %arg) {
; CHECK-LABEL: define double @test_fabs_f64
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call double @llvm.fabs.f64(double [[ARG]])
; CHECK-NEXT:    ret double [[FABS]]
;
  %fabs = tail call double @_Z4fabsd(double %arg)
  ret double %fabs
}

define <2 x double> @test_fabs_v2f64(<2 x double> %arg) {
; CHECK-LABEL: define <2 x double> @test_fabs_v2f64
; CHECK-SAME: (<2 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <2 x double> @llvm.fabs.v2f64(<2 x double> [[ARG]])
; CHECK-NEXT:    ret <2 x double> [[FABS]]
;
  %fabs = tail call <2 x double> @_Z4fabsDv2_d(<2 x double> %arg)
  ret <2 x double> %fabs
}

define <3 x double> @test_fabs_v3f64(<3 x double> %arg) {
; CHECK-LABEL: define <3 x double> @test_fabs_v3f64
; CHECK-SAME: (<3 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <3 x double> @llvm.fabs.v3f64(<3 x double> [[ARG]])
; CHECK-NEXT:    ret <3 x double> [[FABS]]
;
  %fabs = tail call <3 x double> @_Z4fabsDv3_d(<3 x double> %arg)
  ret <3 x double> %fabs
}

define <4 x double> @test_fabs_v4f64(<4 x double> %arg) {
; CHECK-LABEL: define <4 x double> @test_fabs_v4f64
; CHECK-SAME: (<4 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <4 x double> @llvm.fabs.v4f64(<4 x double> [[ARG]])
; CHECK-NEXT:    ret <4 x double> [[FABS]]
;
  %fabs = tail call <4 x double> @_Z4fabsDv4_d(<4 x double> %arg)
  ret <4 x double> %fabs
}

define <8 x double> @test_fabs_v8f64(<8 x double> %arg) {
; CHECK-LABEL: define <8 x double> @test_fabs_v8f64
; CHECK-SAME: (<8 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <8 x double> @llvm.fabs.v8f64(<8 x double> [[ARG]])
; CHECK-NEXT:    ret <8 x double> [[FABS]]
;
  %fabs = tail call <8 x double> @_Z4fabsDv8_d(<8 x double> %arg)
  ret <8 x double> %fabs
}

define <16 x double> @test_fabs_v16f64(<16 x double> %arg) {
; CHECK-LABEL: define <16 x double> @test_fabs_v16f64
; CHECK-SAME: (<16 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <16 x double> @llvm.fabs.v16f64(<16 x double> [[ARG]])
; CHECK-NEXT:    ret <16 x double> [[FABS]]
;
  %fabs = tail call <16 x double> @_Z4fabsDv16_d(<16 x double> %arg)
  ret <16 x double> %fabs
}

define half @test_fabs_f16(half %arg) {
; CHECK-LABEL: define half @test_fabs_f16
; CHECK-SAME: (half [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call half @llvm.fabs.f16(half [[ARG]])
; CHECK-NEXT:    ret half [[FABS]]
;
  %fabs = tail call half @_Z4fabsDh(half %arg)
  ret half %fabs
}

define <2 x half> @test_fabs_v2f16(<2 x half> %arg) {
; CHECK-LABEL: define <2 x half> @test_fabs_v2f16
; CHECK-SAME: (<2 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <2 x half> @llvm.fabs.v2f16(<2 x half> [[ARG]])
; CHECK-NEXT:    ret <2 x half> [[FABS]]
;
  %fabs = tail call <2 x half> @_Z4fabsDv2_Dh(<2 x half> %arg)
  ret <2 x half> %fabs
}

define <3 x half> @test_fabs_v3f16(<3 x half> %arg) {
; CHECK-LABEL: define <3 x half> @test_fabs_v3f16
; CHECK-SAME: (<3 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <3 x half> @llvm.fabs.v3f16(<3 x half> [[ARG]])
; CHECK-NEXT:    ret <3 x half> [[FABS]]
;
  %fabs = tail call <3 x half> @_Z4fabsDv3_Dh(<3 x half> %arg)
  ret <3 x half> %fabs
}

define <4 x half> @test_fabs_v4f16(<4 x half> %arg) {
; CHECK-LABEL: define <4 x half> @test_fabs_v4f16
; CHECK-SAME: (<4 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <4 x half> @llvm.fabs.v4f16(<4 x half> [[ARG]])
; CHECK-NEXT:    ret <4 x half> [[FABS]]
;
  %fabs = tail call <4 x half> @_Z4fabsDv4_Dh(<4 x half> %arg)
  ret <4 x half> %fabs
}

define <8 x half> @test_fabs_v8f16(<8 x half> %arg) {
; CHECK-LABEL: define <8 x half> @test_fabs_v8f16
; CHECK-SAME: (<8 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <8 x half> @llvm.fabs.v8f16(<8 x half> [[ARG]])
; CHECK-NEXT:    ret <8 x half> [[FABS]]
;
  %fabs = tail call <8 x half> @_Z4fabsDv8_Dh(<8 x half> %arg)
  ret <8 x half> %fabs
}

define <16 x half> @test_fabs_v16f16(<16 x half> %arg) {
; CHECK-LABEL: define <16 x half> @test_fabs_v16f16
; CHECK-SAME: (<16 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <16 x half> @llvm.fabs.v16f16(<16 x half> [[ARG]])
; CHECK-NEXT:    ret <16 x half> [[FABS]]
;
  %fabs = tail call <16 x half> @_Z4fabsDv16_Dh(<16 x half> %arg)
  ret <16 x half> %fabs
}

define float @test_fabs_f32_nobuiltin_callsite(float %arg) {
; CHECK-LABEL: define float @test_fabs_f32_nobuiltin_callsite
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call float @_Z4fabsf(float [[ARG]]) #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call float @_Z4fabsf(float %arg) #0
  ret float %fabs
}

define <2 x float> @test_fabs_v2f32_nobuiltin_callsite(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_fabs_v2f32_nobuiltin_callsite
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <2 x float> @_Z4fabsDv2_f(<2 x float> [[ARG]]) #[[ATTR4]]
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %fabs = tail call <2 x float> @_Z4fabsDv2_f(<2 x float> %arg) #0
  ret <2 x float> %fabs
}

; "no-builtins" should be ignored
define float @test_fabs_f32_nobuiltins(float %arg) #1 {
; CHECK-LABEL: define float @test_fabs_f32_nobuiltins
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[FABS:%.*]] = tail call float @_Z4fabsf(float [[ARG]]) #[[ATTR4]]
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call float @_Z4fabsf(float %arg) #0
  ret float %fabs
}

define <2 x float> @test_fabs_v2f32_nobuiltins(<2 x float> %arg) #1 {
; CHECK-LABEL: define <2 x float> @test_fabs_v2f32_nobuiltins
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FABS:%.*]] = tail call <2 x float> @_Z4fabsDv2_f(<2 x float> [[ARG]]) #[[ATTR4]]
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %fabs = tail call <2 x float> @_Z4fabsDv2_f(<2 x float> %arg) #0
  ret <2 x float> %fabs
}

define float @test_fabs_f32_preserve_flags(float %arg) {
; CHECK-LABEL: define float @test_fabs_f32_preserve_flags
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call nnan ninf float @llvm.fabs.f32(float [[ARG]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call nnan ninf float @_Z4fabsf(float %arg)
  ret float %fabs
}

define <2 x float> @test_fabs_v2f32_preserve_flags(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_fabs_v2f32_preserve_flags
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call nnan nsz contract <2 x float> @llvm.fabs.v2f32(<2 x float> [[ARG]])
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %fabs = tail call contract nsz nnan <2 x float> @_Z4fabsDv2_f(<2 x float> %arg)
  ret <2 x float> %fabs
}

define float @test_fabs_f32_preserve_flags_md(float %arg) {
; CHECK-LABEL: define float @test_fabs_f32_preserve_flags_md
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call nnan ninf float @llvm.fabs.f32(float [[ARG]]), !foo !0
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call nnan ninf float @_Z4fabsf(float %arg), !foo !0
  ret float %fabs
}

define <2 x float> @test_fabs_v2f32_preserve_flags_md(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_fabs_v2f32_preserve_flags_md
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call nnan nsz contract <2 x float> @llvm.fabs.v2f32(<2 x float> [[ARG]]), !foo !0
; CHECK-NEXT:    ret <2 x float> [[FABS]]
;
  %fabs = tail call contract nsz nnan <2 x float> @_Z4fabsDv2_f(<2 x float> %arg), !foo !0
  ret <2 x float> %fabs
}

; Test the libm name, not a recognized opencl builtin.
declare float @fabsf(float) #2
declare double @fabs(double) #2

define float @test_libm_fabs_f32(float %arg) {
; CHECK-LABEL: define float @test_libm_fabs_f32
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call float @fabsf(float [[ARG]])
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call float @fabsf(float %arg)
  ret float %fabs
}

define double @test_libm_fabs_f64(double %arg) {
; CHECK-LABEL: define double @test_libm_fabs_f64
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS:%.*]] = tail call double @fabs(double [[ARG]])
; CHECK-NEXT:    ret double [[FABS]]
;
  %fabs = tail call double @fabs(double %arg)
  ret double %fabs
}

define float @test_fabs_f32_strictfp(float %arg) #3 {
; CHECK-LABEL: define float @test_fabs_f32_strictfp
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[FABS:%.*]] = tail call nnan float @llvm.fabs.f32(float [[ARG]]) #[[ATTR2]]
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = tail call nnan float @_Z4fabsf(float %arg) #3
  ret float %fabs
}

attributes #0 = { nobuiltin }
attributes #1 = { "no-builtins" }
attributes #2 = { nounwind memory(none) }
attributes #3 = { strictfp }

!0 = !{i32 1234}
