; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32d | FileCheck -check-prefixes=CHECKIFD,RV32IFD %s
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck -check-prefixes=CHECKIFD,RV64IFD %s
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=RV32IZFINXZDINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=RV64IZFINXZDINX %s

define signext i8 @test_floor_si8(double %x) {
; RV32IFD-LABEL: test_floor_si8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rdn
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_si8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_si8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_si8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptosi double %a to i8
  ret i8 %b
}

define signext i16 @test_floor_si16(double %x) {
; RV32IFD-LABEL: test_floor_si16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rdn
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_si16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_si16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_si16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptosi double %a to i16
  ret i16 %b
}

define signext i32 @test_floor_si32(double %x) {
; CHECKIFD-LABEL: test_floor_si32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rdn
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_si32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_si32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptosi double %a to i32
  ret i32 %b
}

define i64 @test_floor_si64(double %x) {
; RV32IFD-LABEL: test_floor_si64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call floor
; RV32IFD-NEXT:    call __fixdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_si64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_si64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call floor
; RV32IZFINXZDINX-NEXT:    call __fixdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_si64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptosi double %a to i64
  ret i64 %b
}

define zeroext i8 @test_floor_ui8(double %x) {
; RV32IFD-LABEL: test_floor_ui8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rdn
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_ui8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_ui8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_ui8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptoui double %a to i8
  ret i8 %b
}

define zeroext i16 @test_floor_ui16(double %x) {
; RV32IFD-LABEL: test_floor_ui16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rdn
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_ui16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_ui16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_ui16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptoui double %a to i16
  ret i16 %b
}

define signext i32 @test_floor_ui32(double %x) {
; CHECKIFD-LABEL: test_floor_ui32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rdn
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_ui32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rdn
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_ui32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptoui double %a to i32
  ret i32 %b
}

define i64 @test_floor_ui64(double %x) {
; RV32IFD-LABEL: test_floor_ui64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call floor
; RV32IFD-NEXT:    call __fixunsdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_ui64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rdn
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_ui64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call floor
; RV32IZFINXZDINX-NEXT:    call __fixunsdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_ui64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rdn
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  %b = fptoui double %a to i64
  ret i64 %b
}

define signext i8 @test_ceil_si8(double %x) {
; RV32IFD-LABEL: test_ceil_si8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rup
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_si8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_si8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_si8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptosi double %a to i8
  ret i8 %b
}

define signext i16 @test_ceil_si16(double %x) {
; RV32IFD-LABEL: test_ceil_si16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rup
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_si16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_si16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_si16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptosi double %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_si32(double %x) {
; CHECKIFD-LABEL: test_ceil_si32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rup
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_si32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_si32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptosi double %a to i32
  ret i32 %b
}

define i64 @test_ceil_si64(double %x) {
; RV32IFD-LABEL: test_ceil_si64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call ceil
; RV32IFD-NEXT:    call __fixdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_si64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_si64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call ceil
; RV32IZFINXZDINX-NEXT:    call __fixdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_si64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptosi double %a to i64
  ret i64 %b
}

define zeroext i8 @test_ceil_ui8(double %x) {
; RV32IFD-LABEL: test_ceil_ui8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rup
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_ui8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_ui8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_ui8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptoui double %a to i8
  ret i8 %b
}

define zeroext i16 @test_ceil_ui16(double %x) {
; RV32IFD-LABEL: test_ceil_ui16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rup
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_ui16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_ui16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_ui16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptoui double %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_ui32(double %x) {
; CHECKIFD-LABEL: test_ceil_ui32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rup
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_ui32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rup
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_ui32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptoui double %a to i32
  ret i32 %b
}

define i64 @test_ceil_ui64(double %x) {
; RV32IFD-LABEL: test_ceil_ui64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call ceil
; RV32IFD-NEXT:    call __fixunsdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_ui64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rup
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_ui64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call ceil
; RV32IZFINXZDINX-NEXT:    call __fixunsdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_ui64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rup
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  %b = fptoui double %a to i64
  ret i64 %b
}

define signext i8 @test_trunc_si8(double %x) {
; RV32IFD-LABEL: test_trunc_si8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_si8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_si8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_si8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptosi double %a to i8
  ret i8 %b
}

define signext i16 @test_trunc_si16(double %x) {
; RV32IFD-LABEL: test_trunc_si16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_si16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_si16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_si16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptosi double %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_si32(double %x) {
; CHECKIFD-LABEL: test_trunc_si32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_si32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_si32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptosi double %a to i32
  ret i32 %b
}

define i64 @test_trunc_si64(double %x) {
; RV32IFD-LABEL: test_trunc_si64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call trunc
; RV32IFD-NEXT:    call __fixdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_si64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_si64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call trunc
; RV32IZFINXZDINX-NEXT:    call __fixdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_si64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptosi double %a to i64
  ret i64 %b
}

define zeroext i8 @test_trunc_ui8(double %x) {
; RV32IFD-LABEL: test_trunc_ui8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_ui8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_ui8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_ui8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptoui double %a to i8
  ret i8 %b
}

define zeroext i16 @test_trunc_ui16(double %x) {
; RV32IFD-LABEL: test_trunc_ui16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_ui16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_ui16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_ui16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptoui double %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_ui32(double %x) {
; CHECKIFD-LABEL: test_trunc_ui32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_ui32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rtz
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_ui32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptoui double %a to i32
  ret i32 %b
}

define i64 @test_trunc_ui64(double %x) {
; RV32IFD-LABEL: test_trunc_ui64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call trunc
; RV32IFD-NEXT:    call __fixunsdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_ui64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_ui64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call trunc
; RV32IZFINXZDINX-NEXT:    call __fixunsdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_ui64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rtz
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  %b = fptoui double %a to i64
  ret i64 %b
}

define signext i8 @test_round_si8(double %x) {
; RV32IFD-LABEL: test_round_si8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rmm
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_si8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_si8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_si8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptosi double %a to i8
  ret i8 %b
}

define signext i16 @test_round_si16(double %x) {
; RV32IFD-LABEL: test_round_si16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rmm
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_si16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_si16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_si16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptosi double %a to i16
  ret i16 %b
}

define signext i32 @test_round_si32(double %x) {
; CHECKIFD-LABEL: test_round_si32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rmm
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_si32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_si32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptosi double %a to i32
  ret i32 %b
}

define i64 @test_round_si64(double %x) {
; RV32IFD-LABEL: test_round_si64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call round
; RV32IFD-NEXT:    call __fixdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_si64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_si64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call round
; RV32IZFINXZDINX-NEXT:    call __fixdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_si64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptosi double %a to i64
  ret i64 %b
}

define zeroext i8 @test_round_ui8(double %x) {
; RV32IFD-LABEL: test_round_ui8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rmm
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_ui8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_ui8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_ui8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptoui double %a to i8
  ret i8 %b
}

define zeroext i16 @test_round_ui16(double %x) {
; RV32IFD-LABEL: test_round_ui16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rmm
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_ui16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_ui16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_ui16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptoui double %a to i16
  ret i16 %b
}

define signext i32 @test_round_ui32(double %x) {
; CHECKIFD-LABEL: test_round_ui32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rmm
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_ui32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_ui32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptoui double %a to i32
  ret i32 %b
}

define i64 @test_round_ui64(double %x) {
; RV32IFD-LABEL: test_round_ui64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call round
; RV32IFD-NEXT:    call __fixunsdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_ui64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_ui64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call round
; RV32IZFINXZDINX-NEXT:    call __fixunsdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_ui64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  %b = fptoui double %a to i64
  ret i64 %b
}

define signext i8 @test_roundeven_si8(double %x) {
; RV32IFD-LABEL: test_roundeven_si8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rne
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_si8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_si8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_si8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptosi double %a to i8
  ret i8 %b
}

define signext i16 @test_roundeven_si16(double %x) {
; RV32IFD-LABEL: test_roundeven_si16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rne
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_si16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_si16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_si16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptosi double %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_si32(double %x) {
; CHECKIFD-LABEL: test_roundeven_si32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rne
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_si32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_si32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptosi double %a to i32
  ret i32 %b
}

define i64 @test_roundeven_si64(double %x) {
; RV32IFD-LABEL: test_roundeven_si64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call roundeven
; RV32IFD-NEXT:    call __fixdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_si64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_si64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call roundeven
; RV32IZFINXZDINX-NEXT:    call __fixdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_si64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptosi double %a to i64
  ret i64 %b
}

define zeroext i8 @test_roundeven_ui8(double %x) {
; RV32IFD-LABEL: test_roundeven_ui8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rne
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_ui8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_ui8:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_ui8:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptoui double %a to i8
  ret i8 %b
}

define zeroext i16 @test_roundeven_ui16(double %x) {
; RV32IFD-LABEL: test_roundeven_ui16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rne
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_ui16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_ui16:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_ui16:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptoui double %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_ui32(double %x) {
; CHECKIFD-LABEL: test_roundeven_ui32:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rne
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_ui32:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rne
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_ui32:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.wu.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptoui double %a to i32
  ret i32 %b
}

define i64 @test_roundeven_ui64(double %x) {
; RV32IFD-LABEL: test_roundeven_ui64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call roundeven
; RV32IFD-NEXT:    call __fixunsdfdi
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    .cfi_restore ra
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_ui64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rne
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_ui64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call roundeven
; RV32IZFINXZDINX-NEXT:    call __fixunsdfdi
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_ui64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.lu.d a0, a0, rne
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  %b = fptoui double %a to i64
  ret i64 %b
}

define double @test_floor_double(double %x) {
; RV32IFD-LABEL: test_floor_double:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    tail floor
;
; RV64IFD-LABEL: test_floor_double:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI40_0)
; RV64IFD-NEXT:    fld fa5, %lo(.LCPI40_0)(a0)
; RV64IFD-NEXT:    fabs.d fa4, fa0
; RV64IFD-NEXT:    flt.d a0, fa4, fa5
; RV64IFD-NEXT:    beqz a0, .LBB40_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rdn
; RV64IFD-NEXT:    fcvt.d.l fa5, a0, rdn
; RV64IFD-NEXT:    fsgnj.d fa0, fa5, fa0
; RV64IFD-NEXT:  .LBB40_2:
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_floor_double:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call floor
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_floor_double:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    li a1, 1075
; RV64IZFINXZDINX-NEXT:    slli a1, a1, 52
; RV64IZFINXZDINX-NEXT:    fabs.d a2, a0
; RV64IZFINXZDINX-NEXT:    flt.d a1, a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a1, .LBB40_2
; RV64IZFINXZDINX-NEXT:  # %bb.1:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a1, a0, rdn
; RV64IZFINXZDINX-NEXT:    fcvt.d.l a1, a1, rdn
; RV64IZFINXZDINX-NEXT:    fsgnj.d a0, a1, a0
; RV64IZFINXZDINX-NEXT:  .LBB40_2:
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.floor.f64(double %x)
  ret double %a
}

define double @test_ceil_double(double %x) {
; RV32IFD-LABEL: test_ceil_double:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    tail ceil
;
; RV64IFD-LABEL: test_ceil_double:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI41_0)
; RV64IFD-NEXT:    fld fa5, %lo(.LCPI41_0)(a0)
; RV64IFD-NEXT:    fabs.d fa4, fa0
; RV64IFD-NEXT:    flt.d a0, fa4, fa5
; RV64IFD-NEXT:    beqz a0, .LBB41_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rup
; RV64IFD-NEXT:    fcvt.d.l fa5, a0, rup
; RV64IFD-NEXT:    fsgnj.d fa0, fa5, fa0
; RV64IFD-NEXT:  .LBB41_2:
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_ceil_double:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call ceil
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_ceil_double:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    li a1, 1075
; RV64IZFINXZDINX-NEXT:    slli a1, a1, 52
; RV64IZFINXZDINX-NEXT:    fabs.d a2, a0
; RV64IZFINXZDINX-NEXT:    flt.d a1, a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a1, .LBB41_2
; RV64IZFINXZDINX-NEXT:  # %bb.1:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a1, a0, rup
; RV64IZFINXZDINX-NEXT:    fcvt.d.l a1, a1, rup
; RV64IZFINXZDINX-NEXT:    fsgnj.d a0, a1, a0
; RV64IZFINXZDINX-NEXT:  .LBB41_2:
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.ceil.f64(double %x)
  ret double %a
}

define double @test_trunc_double(double %x) {
; RV32IFD-LABEL: test_trunc_double:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    tail trunc
;
; RV64IFD-LABEL: test_trunc_double:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI42_0)
; RV64IFD-NEXT:    fld fa5, %lo(.LCPI42_0)(a0)
; RV64IFD-NEXT:    fabs.d fa4, fa0
; RV64IFD-NEXT:    flt.d a0, fa4, fa5
; RV64IFD-NEXT:    beqz a0, .LBB42_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    fcvt.d.l fa5, a0, rtz
; RV64IFD-NEXT:    fsgnj.d fa0, fa5, fa0
; RV64IFD-NEXT:  .LBB42_2:
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_trunc_double:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call trunc
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_trunc_double:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    li a1, 1075
; RV64IZFINXZDINX-NEXT:    slli a1, a1, 52
; RV64IZFINXZDINX-NEXT:    fabs.d a2, a0
; RV64IZFINXZDINX-NEXT:    flt.d a1, a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a1, .LBB42_2
; RV64IZFINXZDINX-NEXT:  # %bb.1:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a1, a0, rtz
; RV64IZFINXZDINX-NEXT:    fcvt.d.l a1, a1, rtz
; RV64IZFINXZDINX-NEXT:    fsgnj.d a0, a1, a0
; RV64IZFINXZDINX-NEXT:  .LBB42_2:
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.trunc.f64(double %x)
  ret double %a
}

define double @test_round_double(double %x) {
; RV32IFD-LABEL: test_round_double:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    tail round
;
; RV64IFD-LABEL: test_round_double:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI43_0)
; RV64IFD-NEXT:    fld fa5, %lo(.LCPI43_0)(a0)
; RV64IFD-NEXT:    fabs.d fa4, fa0
; RV64IFD-NEXT:    flt.d a0, fa4, fa5
; RV64IFD-NEXT:    beqz a0, .LBB43_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    fcvt.d.l fa5, a0, rmm
; RV64IFD-NEXT:    fsgnj.d fa0, fa5, fa0
; RV64IFD-NEXT:  .LBB43_2:
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_round_double:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call round
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_round_double:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    li a1, 1075
; RV64IZFINXZDINX-NEXT:    slli a1, a1, 52
; RV64IZFINXZDINX-NEXT:    fabs.d a2, a0
; RV64IZFINXZDINX-NEXT:    flt.d a1, a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a1, .LBB43_2
; RV64IZFINXZDINX-NEXT:  # %bb.1:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a1, a0, rmm
; RV64IZFINXZDINX-NEXT:    fcvt.d.l a1, a1, rmm
; RV64IZFINXZDINX-NEXT:    fsgnj.d a0, a1, a0
; RV64IZFINXZDINX-NEXT:  .LBB43_2:
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.round.f64(double %x)
  ret double %a
}

define double @test_roundeven_double(double %x) {
; RV32IFD-LABEL: test_roundeven_double:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    tail roundeven
;
; RV64IFD-LABEL: test_roundeven_double:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, %hi(.LCPI44_0)
; RV64IFD-NEXT:    fld fa5, %lo(.LCPI44_0)(a0)
; RV64IFD-NEXT:    fabs.d fa4, fa0
; RV64IFD-NEXT:    flt.d a0, fa4, fa5
; RV64IFD-NEXT:    beqz a0, .LBB44_2
; RV64IFD-NEXT:  # %bb.1:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rne
; RV64IFD-NEXT:    fcvt.d.l fa5, a0, rne
; RV64IFD-NEXT:    fsgnj.d fa0, fa5, fa0
; RV64IFD-NEXT:  .LBB44_2:
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: test_roundeven_double:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    .cfi_offset ra, -4
; RV32IZFINXZDINX-NEXT:    call roundeven
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    .cfi_restore ra
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: test_roundeven_double:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    li a1, 1075
; RV64IZFINXZDINX-NEXT:    slli a1, a1, 52
; RV64IZFINXZDINX-NEXT:    fabs.d a2, a0
; RV64IZFINXZDINX-NEXT:    flt.d a1, a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a1, .LBB44_2
; RV64IZFINXZDINX-NEXT:  # %bb.1:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a1, a0, rne
; RV64IZFINXZDINX-NEXT:    fcvt.d.l a1, a1, rne
; RV64IZFINXZDINX-NEXT:    fsgnj.d a0, a1, a0
; RV64IZFINXZDINX-NEXT:  .LBB44_2:
; RV64IZFINXZDINX-NEXT:    ret
  %a = call double @llvm.roundeven.f64(double %x)
  ret double %a
}

declare double @llvm.floor.f64(double)
declare double @llvm.ceil.f64(double)
declare double @llvm.trunc.f64(double)
declare double @llvm.round.f64(double)
declare double @llvm.roundeven.f64(double)
