; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940 %s
; RUN: opt -mtriple=amdgcn-amd-amdhsa -S -passes=atomic-expand < %s | FileCheck --check-prefix=OPT %s

define i32 @global_agent_monotonic_idempotent_or(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_or:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_or(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("agent-one-as") monotonic, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") monotonic, align 4
  ret i32 %val
}

define i32 @global_agent_acquire_idempotent_or(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_acquire_idempotent_or:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_acquire_idempotent_or(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("agent-one-as") acquire, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") acquire, align 4
  ret i32 %val
}

define i32 @global_agent_release_idempotent_or(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_release_idempotent_or:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_or v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_release_idempotent_or(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = atomicrmw or ptr addrspace(1) [[IN:%.*]], i32 0 syncscope("agent-one-as") release, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") release, align 4
  ret i32 %val
}

define i32 @global_agent_acquire_release_idempotent_or(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_acquire_release_idempotent_or:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_or v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_acquire_release_idempotent_or(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = atomicrmw or ptr addrspace(1) [[IN:%.*]], i32 0 syncscope("agent-one-as") acq_rel, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") acq_rel, align 4
  ret i32 %val
}

define i32 @global_agent_acquire_release_idempotent_or__no_fine_grained(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_acquire_release_idempotent_or__no_fine_grained:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_or v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_acquire_release_idempotent_or__no_fine_grained(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = atomicrmw or ptr addrspace(1) [[IN:%.*]], i32 0 syncscope("agent-one-as") acq_rel, align 4, !amdgpu.no.fine.grained.memory [[META0:![0-9]+]]
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") acq_rel, align 4, !amdgpu.no.fine.grained.memory !0
  ret i32 %val
}

define i32 @global_agent_seq_cst_idempotent_or(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_seq_cst_idempotent_or:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_or v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_seq_cst_idempotent_or(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = atomicrmw or ptr addrspace(1) [[IN:%.*]], i32 0 syncscope("agent-one-as") seq_cst, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw or ptr addrspace(1) %in, i32 0 syncscope("agent-one-as") seq_cst, align 4
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_add(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_add:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_add(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("workgroup") monotonic, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw add ptr addrspace(1) %in, i32 0 syncscope("workgroup") monotonic, align 4
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_add__no_fine_grained(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_add__no_fine_grained:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_add__no_fine_grained(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("workgroup") monotonic, align 4, !amdgpu.no.fine.grained.memory [[META0]]
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw add ptr addrspace(1) %in, i32 0 syncscope("workgroup") monotonic, align 4, !amdgpu.no.fine.grained.memory !0
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_sub(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_sub:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_sub(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("wavefront") monotonic, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw sub ptr addrspace(1) %in, i32 0 syncscope("wavefront") monotonic, align 4
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_sub__no_fine_grained(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_sub__no_fine_grained:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_sub__no_fine_grained(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("wavefront") monotonic, align 4, !amdgpu.no.fine.grained.memory [[META0]]
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw sub ptr addrspace(1) %in, i32 0 syncscope("wavefront") monotonic, align 4, !amdgpu.no.fine.grained.memory !0
  ret i32 %val
}

define i32 @global_system_monotonic_idempotent_xor(ptr addrspace(1) %in) {
; GFX940-LABEL: global_system_monotonic_idempotent_xor:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_system_monotonic_idempotent_xor(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] monotonic, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw xor ptr addrspace(1) %in, i32 0 monotonic, align 4
  ret i32 %val
}

define i32 @global_system_monotonic_idempotent_xor__no_fine_grained(ptr addrspace(1) %in) {
; GFX940-LABEL: global_system_monotonic_idempotent_xor__no_fine_grained:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_system_monotonic_idempotent_xor__no_fine_grained(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] monotonic, align 4, !amdgpu.no.fine.grained.memory [[META0]]
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw xor ptr addrspace(1) %in, i32 0 monotonic, align 4, !amdgpu.no.fine.grained.memory !0
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_and(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_and:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_and(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("singlethread") monotonic, align 4
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw and ptr addrspace(1) %in, i32 -1 syncscope("singlethread") monotonic, align 4
  ret i32 %val
}

define i32 @global_agent_monotonic_idempotent_and_no_fined_grain(ptr addrspace(1) %in) {
; GFX940-LABEL: global_agent_monotonic_idempotent_and_no_fined_grain:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v0, v[0:1], off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
; OPT-LABEL: @global_agent_monotonic_idempotent_and_no_fined_grain(
; OPT-NEXT:  entry:
; OPT-NEXT:    [[VAL:%.*]] = load atomic i32, ptr addrspace(1) [[IN:%.*]] syncscope("singlethread") monotonic, align 4, !amdgpu.no.fine.grained.memory [[META0]]
; OPT-NEXT:    ret i32 [[VAL]]
;
entry:
  %val = atomicrmw and ptr addrspace(1) %in, i32 -1 syncscope("singlethread") monotonic, align 4, !amdgpu.no.fine.grained.memory !0
  ret i32 %val
}

!0 = !{}
