; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+sve2 -o - | FileCheck %s

target triple = "aarch64"

; Expected to transform
define <vscale x 4 x i32> @complex_mul_v4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: complex_mul_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, #0 // =0x0
; CHECK-NEXT:    cmla z2.s, z1.s, z0.s, #0
; CHECK-NEXT:    cmla z2.s, z1.s, z0.s, #90
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 2 x i32>, <vscale x 2 x i32> } @llvm.vector.deinterleave2.nxv4i32(<vscale x 4 x i32> %a)
  %a.real = extractvalue { <vscale x 2 x i32>, <vscale x 2 x i32> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 2 x i32>, <vscale x 2 x i32> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 2 x i32>, <vscale x 2 x i32> } @llvm.vector.deinterleave2.nxv4i32(<vscale x 4 x i32> %b)
  %b.real = extractvalue { <vscale x 2 x i32>, <vscale x 2 x i32> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 2 x i32>, <vscale x 2 x i32> } %b.deinterleaved, 1
  %0 = mul <vscale x 2 x i32> %b.imag, %a.real
  %1 = mul <vscale x 2 x i32> %b.real, %a.imag
  %2 = add <vscale x 2 x i32> %1, %0
  %3 = mul <vscale x 2 x i32> %b.real, %a.real
  %4 = mul <vscale x 2 x i32> %a.imag, %b.imag
  %5 = sub <vscale x 2 x i32> %3, %4
  %interleaved.vec = tail call <vscale x 4 x i32> @llvm.vector.interleave2.nxv4i32(<vscale x 2 x i32> %5, <vscale x 2 x i32> %2)
  ret <vscale x 4 x i32> %interleaved.vec
}

; Expected to transform
define <vscale x 8 x i32> @complex_mul_v8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %b) {
; CHECK-LABEL: complex_mul_v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z4.s, #0 // =0x0
; CHECK-NEXT:    mov z5.d, z4.d
; CHECK-NEXT:    cmla z4.s, z3.s, z1.s, #0
; CHECK-NEXT:    cmla z5.s, z2.s, z0.s, #0
; CHECK-NEXT:    cmla z4.s, z3.s, z1.s, #90
; CHECK-NEXT:    cmla z5.s, z2.s, z0.s, #90
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    mov z0.d, z5.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.vector.deinterleave2.nxv8i32(<vscale x 8 x i32> %a)
  %a.real = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.vector.deinterleave2.nxv8i32(<vscale x 8 x i32> %b)
  %b.real = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 4 x i32>, <vscale x 4 x i32> } %b.deinterleaved, 1
  %0 = mul <vscale x 4 x i32> %b.imag, %a.real
  %1 = mul <vscale x 4 x i32> %b.real, %a.imag
  %2 = add <vscale x 4 x i32> %1, %0
  %3 = mul <vscale x 4 x i32> %b.real, %a.real
  %4 = mul <vscale x 4 x i32> %a.imag, %b.imag
  %5 = sub <vscale x 4 x i32> %3, %4
  %interleaved.vec = tail call <vscale x 8 x i32> @llvm.vector.interleave2.nxv8i32(<vscale x 4 x i32> %5, <vscale x 4 x i32> %2)
  ret <vscale x 8 x i32> %interleaved.vec
}

; Expected to transform
define <vscale x 16 x i32> @complex_mul_v16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %b) {
; CHECK-LABEL: complex_mul_v16i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z24.s, #0 // =0x0
; CHECK-NEXT:    mov z25.d, z24.d
; CHECK-NEXT:    mov z26.d, z24.d
; CHECK-NEXT:    mov z27.d, z24.d
; CHECK-NEXT:    cmla z24.s, z7.s, z3.s, #0
; CHECK-NEXT:    cmla z25.s, z4.s, z0.s, #0
; CHECK-NEXT:    cmla z26.s, z5.s, z1.s, #0
; CHECK-NEXT:    cmla z27.s, z6.s, z2.s, #0
; CHECK-NEXT:    cmla z24.s, z7.s, z3.s, #90
; CHECK-NEXT:    cmla z25.s, z4.s, z0.s, #90
; CHECK-NEXT:    cmla z26.s, z5.s, z1.s, #90
; CHECK-NEXT:    cmla z27.s, z6.s, z2.s, #90
; CHECK-NEXT:    mov z3.d, z24.d
; CHECK-NEXT:    mov z0.d, z25.d
; CHECK-NEXT:    mov z1.d, z26.d
; CHECK-NEXT:    mov z2.d, z27.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 8 x i32>, <vscale x 8 x i32> } @llvm.vector.deinterleave2.nxv16i32(<vscale x 16 x i32> %a)
  %a.real = extractvalue { <vscale x 8 x i32>, <vscale x 8 x i32> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 8 x i32>, <vscale x 8 x i32> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 8 x i32>, <vscale x 8 x i32> } @llvm.vector.deinterleave2.nxv16i32(<vscale x 16 x i32> %b)
  %b.real = extractvalue { <vscale x 8 x i32>, <vscale x 8 x i32> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 8 x i32>, <vscale x 8 x i32> } %b.deinterleaved, 1
  %0 = mul <vscale x 8 x i32> %b.imag, %a.real
  %1 = mul <vscale x 8 x i32> %b.real, %a.imag
  %2 = add <vscale x 8 x i32> %1, %0
  %3 = mul <vscale x 8 x i32> %b.real, %a.real
  %4 = mul <vscale x 8 x i32> %a.imag, %b.imag
  %5 = sub <vscale x 8 x i32> %3, %4
  %interleaved.vec = tail call <vscale x 16 x i32> @llvm.vector.interleave2.nxv16i32(<vscale x 8 x i32> %5, <vscale x 8 x i32> %2)
  ret <vscale x 16 x i32> %interleaved.vec
}

declare { <vscale x 2 x i32>, <vscale x 2 x i32> } @llvm.vector.deinterleave2.nxv4i32(<vscale x 4 x i32>)
declare <vscale x 4 x i32> @llvm.vector.interleave2.nxv4i32(<vscale x 2 x i32>, <vscale x 2 x i32>)

declare { <vscale x 4 x i32>, <vscale x 4 x i32> } @llvm.vector.deinterleave2.nxv8i32(<vscale x 8 x i32>)
declare <vscale x 8 x i32> @llvm.vector.interleave2.nxv8i32(<vscale x 4 x i32>, <vscale x 4 x i32>)

declare { <vscale x 8 x i32>, <vscale x 8 x i32> } @llvm.vector.deinterleave2.nxv16i32(<vscale x 16 x i32>)
declare <vscale x 16 x i32> @llvm.vector.interleave2.nxv16i32(<vscale x 8 x i32>, <vscale x 8 x i32>)

