; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+lasx --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA32 %s
; RUN: llc --mtriple=loongarch64 --mattr=+lasx --verify-machineinstrs < %s \
; RUN:   | FileCheck --check-prefix=LA64 %s
; RUN: llc --mtriple=loongarch64 --mattr=+lasx --verify-machineinstrs \
; RUN:   --code-model=large < %s | FileCheck --check-prefix=LA64-LARGE %s

@g_i8 = dso_local global i8 0

define dso_local signext i8 @load_s8() nounwind {
; LA32-LABEL: load_s8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA32-NEXT:    ld.b $a0, $a0, %pc_lo12(g_i8)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_s8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-NEXT:    ld.b $a0, $a0, %pc_lo12(g_i8)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_s8:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8)
; LA64-LARGE-NEXT:    ldx.b $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i8, ptr @g_i8
  ret i8 %0
}

define dso_local zeroext i8 @load_u8() nounwind {
; LA32-LABEL: load_u8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA32-NEXT:    ld.bu $a0, $a0, %pc_lo12(g_i8)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_u8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-NEXT:    ld.bu $a0, $a0, %pc_lo12(g_i8)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_u8:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8)
; LA64-LARGE-NEXT:    ldx.bu $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i8, ptr @g_i8
  ret i8 %0
}

define dso_local void @store_i8() nounwind {
; LA32-LABEL: store_i8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.b $a1, $a0, %pc_lo12(g_i8)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.b $a1, $a0, %pc_lo12(g_i8)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_i8:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.b $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store i8 1, ptr @g_i8
  ret void
}

@g_i16 = dso_local global i16 0

define dso_local signext i16 @load_s16() nounwind {
; LA32-LABEL: load_s16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA32-NEXT:    ld.h $a0, $a0, %pc_lo12(g_i16)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_s16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-NEXT:    ld.h $a0, $a0, %pc_lo12(g_i16)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_s16:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i16)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i16)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i16)
; LA64-LARGE-NEXT:    ldx.h $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i16, ptr @g_i16
  ret i16 %0
}

define dso_local zeroext i16 @load_u16() nounwind {
; LA32-LABEL: load_u16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA32-NEXT:    ld.hu $a0, $a0, %pc_lo12(g_i16)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_u16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-NEXT:    ld.hu $a0, $a0, %pc_lo12(g_i16)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_u16:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i16)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i16)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i16)
; LA64-LARGE-NEXT:    ldx.hu $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i16, ptr @g_i16
  ret i16 %0
}

define dso_local void @store_i16() nounwind {
; LA32-LABEL: store_i16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.h $a1, $a0, %pc_lo12(g_i16)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.h $a1, $a0, %pc_lo12(g_i16)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_i16:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i16)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i16)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i16)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i16)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.h $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store i16 1, ptr @g_i16
  ret void
}

@g_i32 = dso_local global i32 0

define dso_local signext i32 @load_s32() nounwind {
; LA32-LABEL: load_s32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA32-NEXT:    ld.w $a0, $a0, %pc_lo12(g_i32)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_s32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-NEXT:    ld.w $a0, $a0, %pc_lo12(g_i32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_s32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32)
; LA64-LARGE-NEXT:    ldx.w $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i32, ptr @g_i32
  ret i32 %0
}

define dso_local zeroext i32 @load_u32() nounwind {
; LA32-LABEL: load_u32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA32-NEXT:    ld.w $a0, $a0, %pc_lo12(g_i32)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_u32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-NEXT:    ld.wu $a0, $a0, %pc_lo12(g_i32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_u32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32)
; LA64-LARGE-NEXT:    ldx.wu $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i32, ptr @g_i32
  ret i32 %0
}

define dso_local void @store_i32() nounwind {
; LA32-LABEL: store_i32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.w $a1, $a0, %pc_lo12(g_i32)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.w $a1, $a0, %pc_lo12(g_i32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_i32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.w $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store i32 1, ptr @g_i32
  ret void
}

@g_i64 = dso_local global i64 0

define dso_local i64 @load_64() nounwind {
; LA32-LABEL: load_64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA32-NEXT:    addi.w $a1, $a0, %pc_lo12(g_i64)
; LA32-NEXT:    ld.w $a0, $a1, 0
; LA32-NEXT:    ld.w $a1, $a1, 4
; LA32-NEXT:    ret
;
; LA64-LABEL: load_64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA64-NEXT:    ld.d $a0, $a0, %pc_lo12(g_i64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_64:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i64)
; LA64-LARGE-NEXT:    ldx.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i64, ptr @g_i64
  ret i64 %0
}

define dso_local void @store_i64() nounwind {
; LA32-LABEL: store_i64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_i64)
; LA32-NEXT:    st.w $zero, $a0, 4
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: store_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.d $a1, $a0, %pc_lo12(g_i64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_i64:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i64)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store i64 1, ptr @g_i64
  ret void
}

@g_f32 = dso_local global float 0.0

define dso_local float @load_f32() nounwind {
; LA32-LABEL: load_f32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA32-NEXT:    fld.s $fa0, $a0, %pc_lo12(g_f32)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_f32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA64-NEXT:    fld.s $fa0, $a0, %pc_lo12(g_f32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_f32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_f32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_f32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_f32)
; LA64-LARGE-NEXT:    fldx.s $fa0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load float, ptr @g_f32
  ret float %0
}

define dso_local void @store_f32() nounwind {
; LA32-LABEL: store_f32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA32-NEXT:    lu12i.w $a1, 260096
; LA32-NEXT:    st.w $a1, $a0, %pc_lo12(g_f32)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_f32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA64-NEXT:    lu12i.w $a1, 260096
; LA64-NEXT:    st.w $a1, $a0, %pc_lo12(g_f32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_f32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_f32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_f32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_f32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_f32)
; LA64-LARGE-NEXT:    lu12i.w $a2, 260096
; LA64-LARGE-NEXT:    stx.w $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store float 1.0, ptr @g_f32
  ret void
}

@g_f64 = dso_local global double 0.0

define dso_local double @load_f64() nounwind {
; LA32-LABEL: load_f64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA32-NEXT:    fld.d $fa0, $a0, %pc_lo12(g_f64)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_f64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA64-NEXT:    fld.d $fa0, $a0, %pc_lo12(g_f64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_f64:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_f64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_f64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_f64)
; LA64-LARGE-NEXT:    fldx.d $fa0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load double, ptr @g_f64
  ret double %0
}

define dso_local void @store_f64() nounwind {
; LA32-LABEL: store_f64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA32-NEXT:    vldi $vr0, -912
; LA32-NEXT:    fst.d $fa0, $a0, %pc_lo12(g_f64)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_f64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA64-NEXT:    lu52i.d $a1, $zero, 1023
; LA64-NEXT:    st.d $a1, $a0, %pc_lo12(g_f64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_f64:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_f64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_f64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_f64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_f64)
; LA64-LARGE-NEXT:    lu52i.d $a2, $zero, 1023
; LA64-LARGE-NEXT:    stx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store double 1.0, ptr @g_f64
  ret void
}

@g_m64 = dso_local global i64 0

define dso_local void @store_multi() nounwind {
; LA32-LABEL: store_multi:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_m64)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_m64)
; LA32-NEXT:    st.w $zero, $a0, 4
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    st.w $zero, $a0, 4
; LA32-NEXT:    ori $a1, $zero, 2
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: store_multi:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_m64)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.d $a1, $a0, %pc_lo12(g_m64)
; LA64-NEXT:    ori $a1, $zero, 2
; LA64-NEXT:    st.d $a1, $a0, %pc_lo12(g_m64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_multi:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_m64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_m64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_m64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_m64)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    ori $a2, $zero, 2
; LA64-LARGE-NEXT:    stx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store volatile i64 1, ptr @g_m64
  store volatile i64 2, ptr @g_m64
  ret void
}

@g_sf32 = dso_local global float 0.0

define dso_local void @store_sf32() nounwind {
; LA32-LABEL: store_sf32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_sf32)
; LA32-NEXT:    fld.s $fa0, $a0, %pc_lo12(g_sf32)
; LA32-NEXT:    fst.s $fa0, $a0, %pc_lo12(g_sf32)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_sf32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_sf32)
; LA64-NEXT:    fld.s $fa0, $a0, %pc_lo12(g_sf32)
; LA64-NEXT:    fst.s $fa0, $a0, %pc_lo12(g_sf32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_sf32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_sf32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_sf32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_sf32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_sf32)
; LA64-LARGE-NEXT:    fldx.s $fa0, $a1, $a0
; LA64-LARGE-NEXT:    fstx.s $fa0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load float, ptr @g_sf32
  store volatile float %0, ptr @g_sf32
  ret void
}

@g_sf64 = dso_local global double 0.0

define dso_local void @store_sf64() nounwind {
; LA32-LABEL: store_sf64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_sf64)
; LA32-NEXT:    fld.d $fa0, $a0, %pc_lo12(g_sf64)
; LA32-NEXT:    fst.d $fa0, $a0, %pc_lo12(g_sf64)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_sf64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_sf64)
; LA64-NEXT:    fld.d $fa0, $a0, %pc_lo12(g_sf64)
; LA64-NEXT:    fst.d $fa0, $a0, %pc_lo12(g_sf64)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_sf64:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_sf64)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_sf64)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_sf64)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_sf64)
; LA64-LARGE-NEXT:    fldx.d $fa0, $a1, $a0
; LA64-LARGE-NEXT:    fstx.d $fa0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load double, ptr @g_sf64
  store volatile double %0, ptr @g_sf64
  ret void
}

@g_i32x4_src = dso_local global [4 x i32] zeroinitializer, align 16
@g_i32x4_dst = dso_local global [4 x i32] zeroinitializer, align 16

define dso_local void @copy_i32x4() nounwind {
; LA32-LABEL: copy_i32x4:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA32-NEXT:    vld $vr0, $a0, %pc_lo12(g_i32x4_src)
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA32-NEXT:    vst $vr0, $a0, %pc_lo12(g_i32x4_dst)
; LA32-NEXT:    ret
;
; LA64-LABEL: copy_i32x4:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA64-NEXT:    vld $vr0, $a0, %pc_lo12(g_i32x4_src)
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA64-NEXT:    vst $vr0, $a0, %pc_lo12(g_i32x4_dst)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: copy_i32x4:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32x4_src)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32x4_src)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32x4_src)
; LA64-LARGE-NEXT:    vldx $vr0, $a1, $a0
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32x4_dst)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32x4_dst)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32x4_dst)
; LA64-LARGE-NEXT:    vstx $vr0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load <4 x i32>, ptr @g_i32x4_src, align 16
  store <4 x i32> %0, ptr @g_i32x4_dst, align 16
  ret void
}

@g_i32x8_src = dso_local global [8 x i32] zeroinitializer, align 32
@g_i32x8_dst = dso_local global [8 x i32] zeroinitializer, align 32

define dso_local void @copy_i32x8() nounwind {
; LA32-LABEL: copy_i32x8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA32-NEXT:    xvld $xr0, $a0, %pc_lo12(g_i32x4_src)
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA32-NEXT:    xvst $xr0, $a0, %pc_lo12(g_i32x4_dst)
; LA32-NEXT:    ret
;
; LA64-LABEL: copy_i32x8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA64-NEXT:    xvld $xr0, $a0, %pc_lo12(g_i32x4_src)
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA64-NEXT:    xvst $xr0, $a0, %pc_lo12(g_i32x4_dst)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: copy_i32x8:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_src)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32x4_src)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32x4_src)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32x4_src)
; LA64-LARGE-NEXT:    xvldx $xr0, $a1, $a0
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i32x4_dst)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i32x4_dst)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i32x4_dst)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i32x4_dst)
; LA64-LARGE-NEXT:    xvstx $xr0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load <8 x i32>, ptr @g_i32x4_src, align 32
  store <8 x i32> %0, ptr @g_i32x4_dst, align 32
  ret void
}

@g_i8x16 = dso_local global <16 x i8> zeroinitializer, align 16

define void @copy_i8_to_i8x16() {
; LA32-LABEL: copy_i8_to_i8x16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA32-NEXT:    vldrepl.b $vr0, $a0, %pc_lo12(g_i8)
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x16)
; LA32-NEXT:    vst $vr0, $a0, %pc_lo12(g_i8x16)
; LA32-NEXT:    ret
;
; LA64-LABEL: copy_i8_to_i8x16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-NEXT:    vldrepl.b $vr0, $a0, %pc_lo12(g_i8)
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x16)
; LA64-NEXT:    vst $vr0, $a0, %pc_lo12(g_i8x16)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: copy_i8_to_i8x16:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    vldrepl.b $vr0, $a0, 0
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x16)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8x16)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8x16)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8x16)
; LA64-LARGE-NEXT:    vstx $vr0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = call <16 x i8> @llvm.loongarch.lsx.vldrepl.b(ptr @g_i8, i32 0)
  store <16 x i8> %0, ptr @g_i8x16, align 16
  ret void
}

@g_i8x32 = dso_local global <32 x i8> zeroinitializer, align 32

define void @copy_i8_to_i8x32() {
; LA32-LABEL: copy_i8_to_i8x32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA32-NEXT:    xvldrepl.b $xr0, $a0, %pc_lo12(g_i8)
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x32)
; LA32-NEXT:    xvst $xr0, $a0, %pc_lo12(g_i8x32)
; LA32-NEXT:    ret
;
; LA64-LABEL: copy_i8_to_i8x32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-NEXT:    xvldrepl.b $xr0, $a0, %pc_lo12(g_i8)
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x32)
; LA64-NEXT:    xvst $xr0, $a0, %pc_lo12(g_i8x32)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: copy_i8_to_i8x32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    xvldrepl.b $xr0, $a0, 0
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_i8x32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_i8x32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_i8x32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_i8x32)
; LA64-LARGE-NEXT:    xvstx $xr0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = call <32 x i8> @llvm.loongarch.lasx.xvldrepl.b(ptr @g_i8, i32 0)
  store <32 x i8> %0, ptr @g_i8x32, align 32
  ret void
}

@g_rmw = dso_local global i64 0

define dso_local void @rmw() nounwind {
; LA32-LABEL: rmw:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_rmw)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_rmw)
; LA32-NEXT:    ld.w $a1, $a0, 0
; LA32-NEXT:    ld.w $a2, $a0, 4
; LA32-NEXT:    addi.w $a1, $a1, 1
; LA32-NEXT:    sltui $a3, $a1, 1
; LA32-NEXT:    add.w $a2, $a2, $a3
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    st.w $a2, $a0, 4
; LA32-NEXT:    ret
;
; LA64-LABEL: rmw:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_rmw)
; LA64-NEXT:    ld.d $a1, $a0, %pc_lo12(g_rmw)
; LA64-NEXT:    addi.d $a1, $a1, 1
; LA64-NEXT:    st.d $a1, $a0, %pc_lo12(g_rmw)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: rmw:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_rmw)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_rmw)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_rmw)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_rmw)
; LA64-LARGE-NEXT:    ldx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    addi.d $a2, $a2, 1
; LA64-LARGE-NEXT:    stx.d $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i64, ptr @g_rmw
  %1 = add i64 %0, 1
  store i64 %1, ptr @g_rmw
  ret void
}

@g_a32 = dso_local global [2048 x i32] zeroinitializer, align 4

define dso_local void @store_a32() nounwind {
; LA32-LABEL: store_a32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4096)
; LA32-NEXT:    ori $a1, $zero, 1
; LA32-NEXT:    st.w $a1, $a0, %pc_lo12(g_a32+4096)
; LA32-NEXT:    ret
;
; LA64-LABEL: store_a32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4096)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    st.w $a1, $a0, %pc_lo12(g_a32+4096)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_a32:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4096)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a32+4096)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a32+4096)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a32+4096)
; LA64-LARGE-NEXT:    ori $a2, $zero, 1
; LA64-LARGE-NEXT:    stx.w $a2, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  store i32 1, ptr getelementptr inbounds ([1 x i32], ptr @g_a32, i32 1024), align 4
  ret void
}

define dso_local void @store_a32_2() nounwind {
; LA32-LABEL: store_a32_2:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a32)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a32)
; LA32-NEXT:    lu12i.w $a1, 1
; LA32-NEXT:    add.w $a2, $a0, $a1
; LA32-NEXT:    ori $a3, $zero, 1
; LA32-NEXT:    st.w $a3, $a2, 0
; LA32-NEXT:    ori $a1, $a1, 8
; LA32-NEXT:    add.w $a0, $a0, $a1
; LA32-NEXT:    ori $a1, $zero, 2
; LA32-NEXT:    st.w $a1, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: store_a32_2:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a32)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a32)
; LA64-NEXT:    ori $a1, $zero, 1
; LA64-NEXT:    stptr.w $a1, $a0, 4096
; LA64-NEXT:    ori $a1, $zero, 2
; LA64-NEXT:    stptr.w $a1, $a0, 4104
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: store_a32_2:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a32)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a32)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a32)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a32)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ori $a1, $zero, 1
; LA64-LARGE-NEXT:    stptr.w $a1, $a0, 4096
; LA64-LARGE-NEXT:    ori $a1, $zero, 2
; LA64-LARGE-NEXT:    stptr.w $a1, $a0, 4104
; LA64-LARGE-NEXT:    ret
entry:
  store i32 1, ptr getelementptr inbounds ([1 x i32], ptr @g_a32, i32 1024), align 4
  store i32 2, ptr getelementptr inbounds ([1 x i32], ptr @g_a32, i32 1026), align 4
  ret void
}

define dso_local void @control_flow_with_mem_access() nounwind {
; LA32-LABEL: control_flow_with_mem_access:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4)
; LA32-NEXT:    ld.w $a1, $a0, %pc_lo12(g_a32+4)
; LA32-NEXT:    ori $a2, $zero, 1
; LA32-NEXT:    blt $a1, $a2, .LBB25_2
; LA32-NEXT:  # %bb.1: # %if.then
; LA32-NEXT:    ori $a1, $zero, 10
; LA32-NEXT:    st.w $a1, $a0, %pc_lo12(g_a32+4)
; LA32-NEXT:  .LBB25_2: # %if.end
; LA32-NEXT:    ret
;
; LA64-LABEL: control_flow_with_mem_access:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4)
; LA64-NEXT:    ld.w $a1, $a0, %pc_lo12(g_a32+4)
; LA64-NEXT:    ori $a2, $zero, 1
; LA64-NEXT:    blt $a1, $a2, .LBB25_2
; LA64-NEXT:  # %bb.1: # %if.then
; LA64-NEXT:    ori $a1, $zero, 10
; LA64-NEXT:    st.w $a1, $a0, %pc_lo12(g_a32+4)
; LA64-NEXT:  .LBB25_2: # %if.end
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: control_flow_with_mem_access:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a32+4)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a32+4)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a32+4)
; LA64-LARGE-NEXT:    ldx.w $a0, $a1, $a0
; LA64-LARGE-NEXT:    ori $a1, $zero, 1
; LA64-LARGE-NEXT:    blt $a0, $a1, .LBB25_2
; LA64-LARGE-NEXT:  # %bb.1: # %if.then
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a32+4)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a32+4)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a32+4)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a32+4)
; LA64-LARGE-NEXT:    ori $a2, $zero, 10
; LA64-LARGE-NEXT:    stx.w $a2, $a1, $a0
; LA64-LARGE-NEXT:  .LBB25_2: # %if.end
; LA64-LARGE-NEXT:    ret
entry:
  %0 = load i32, ptr getelementptr inbounds ([1 x i32], ptr @g_a32, i32 1), align 4
  %cmp = icmp sgt i32 %0, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 10, ptr getelementptr inbounds ([1 x i32], ptr @g_a32, i32 1), align 4
  br label %if.end

if.end:
  ret void
}

define dso_local ptr @load_ba_1() nounwind {
; LA32-LABEL: load_ba_1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:  .Ltmp0: # Block address taken
; LA32-NEXT:  # %bb.1: # %label
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp0)
; LA32-NEXT:    ld.w $a0, $a0, %pc_lo12(.Ltmp0)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_ba_1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:  .Ltmp0: # Block address taken
; LA64-NEXT:  # %bb.1: # %label
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp0)
; LA64-NEXT:    ld.d $a0, $a0, %pc_lo12(.Ltmp0)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_ba_1:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:  .Ltmp0: # Block address taken
; LA64-LARGE-NEXT:  # %bb.1: # %label
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp0)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(.Ltmp0)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(.Ltmp0)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(.Ltmp0)
; LA64-LARGE-NEXT:    ldx.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  br label %label
label:
  %0 = load ptr, ptr blockaddress(@load_ba_1, %label)
  ret ptr %0
}

define dso_local ptr @load_ba_2() nounwind {
; LA32-LABEL: load_ba_2:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:  .Ltmp1: # Block address taken
; LA32-NEXT:  # %bb.1: # %label
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp1+8)
; LA32-NEXT:    ld.w $a0, $a0, %pc_lo12(.Ltmp1+8)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_ba_2:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:  .Ltmp1: # Block address taken
; LA64-NEXT:  # %bb.1: # %label
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp1+8)
; LA64-NEXT:    ld.d $a0, $a0, %pc_lo12(.Ltmp1+8)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_ba_2:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:  .Ltmp1: # Block address taken
; LA64-LARGE-NEXT:  # %bb.1: # %label
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(.Ltmp1+8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(.Ltmp1+8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(.Ltmp1+8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(.Ltmp1+8)
; LA64-LARGE-NEXT:    ldx.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  br label %label
label:
  %0 = load ptr, ptr getelementptr inbounds (i8, ptr blockaddress(@load_ba_2, %label), i32 8)
  ret ptr %0
}

@g_a64 = dso_local global [614750729487779976 x i64] zeroinitializer, align 8

define dso_local ptr @load_addr_offset_1() nounwind {
; LA32-LABEL: load_addr_offset_1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+8)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+8)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_1:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+8)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+8)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+8)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 1)
}

define dso_local ptr @load_addr_offset_257() nounwind {
; LA32-LABEL: load_addr_offset_257:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2056)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+2056)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_257:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2056)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+2056)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_257:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2056)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+2056)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+2056)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+2056)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 257)
}

define dso_local ptr @load_addr_offset_1048576() nounwind {
; LA32-LABEL: load_addr_offset_1048576:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388608)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+8388608)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_1048576:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388608)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+8388608)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_1048576:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388608)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+8388608)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+8388608)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+8388608)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 1048576)
}

define dso_local ptr @load_addr_offset_1048577() nounwind {
; LA32-LABEL: load_addr_offset_1048577:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388616)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+8388616)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_1048577:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388616)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+8388616)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_1048577:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+8388616)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+8388616)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+8388616)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+8388616)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 1048577)
}

define dso_local ptr @load_addr_offset_268432896() nounwind {
; LA32-LABEL: load_addr_offset_268432896:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463168)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+2147463168)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_268432896:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463168)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+2147463168)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_268432896:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463168)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+2147463168)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+2147463168)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+2147463168)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 268432896)
}

define dso_local ptr @load_addr_offset_268432897() nounwind {
; LA32-LABEL: load_addr_offset_268432897:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463176)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+2147463176)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_268432897:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463176)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64+2147463176)
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_268432897:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2147463176)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+2147463176)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+2147463176)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+2147463176)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 268432897)
}

define dso_local ptr @load_addr_offset_281474439839744() nounwind {
; LA32-LABEL: load_addr_offset_281474439839744:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_281474439839744:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64)
; LA64-NEXT:    ori $a1, $zero, 0
; LA64-NEXT:    lu32i.d $a1, 524287
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_281474439839744:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2251795518717952)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+2251795518717952)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+2251795518717952)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+2251795518717952)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 281474439839744)
}

define dso_local ptr @load_addr_offset_248792680471040() nounwind {
; LA32-LABEL: load_addr_offset_248792680471040:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+2059194368)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+2059194368)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_248792680471040:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64)
; LA64-NEXT:    lu12i.w $a1, 502733
; LA64-NEXT:    lu32i.d $a1, 463412
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_248792680471040:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+1990341443768320)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+1990341443768320)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+1990341443768320)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+1990341443768320)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 248792680471040)
}

define dso_local ptr @load_addr_offset_9380351707272() nounwind {
; LA32-LABEL: load_addr_offset_9380351707272:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+1145062464)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+1145062464)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_9380351707272:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64)
; LA64-NEXT:    lu12i.w $a1, 279556
; LA64-NEXT:    ori $a1, $a1, 1088
; LA64-NEXT:    lu32i.d $a1, 17472
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_9380351707272:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+75042813658176)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+75042813658176)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+75042813658176)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+75042813658176)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 9380351707272)
}

define dso_local ptr @load_addr_offset_562949953421312() nounwind {
; LA32-LABEL: load_addr_offset_562949953421312:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_562949953421312:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64)
; LA64-NEXT:    lu52i.d $a1, $zero, 1
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_562949953421312:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+4503599627370496)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+4503599627370496)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+4503599627370496)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+4503599627370496)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 562949953421312)
}

define dso_local ptr @load_addr_offset_614749556925924693() nounwind {
; LA32-LABEL: load_addr_offset_614749556925924693:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+858794664)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(g_a64+858794664)
; LA32-NEXT:    ret
;
; LA64-LABEL: load_addr_offset_614749556925924693:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(g_a64)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(g_a64)
; LA64-NEXT:    lu12i.w $a1, 209666
; LA64-NEXT:    ori $a1, $a1, 2728
; LA64-NEXT:    lu32i.d $a1, 15288
; LA64-NEXT:    lu52i.d $a1, $a1, 1092
; LA64-NEXT:    add.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-LARGE-LABEL: load_addr_offset_614749556925924693:
; LA64-LARGE:       # %bb.0: # %entry
; LA64-LARGE-NEXT:    pcalau12i $a0, %pc_hi20(g_a64+4917996455407397544)
; LA64-LARGE-NEXT:    addi.d $a1, $zero, %pc_lo12(g_a64+4917996455407397544)
; LA64-LARGE-NEXT:    lu32i.d $a1, %pc64_lo20(g_a64+4917996455407397544)
; LA64-LARGE-NEXT:    lu52i.d $a1, $a1, %pc64_hi12(g_a64+4917996455407397544)
; LA64-LARGE-NEXT:    add.d $a0, $a1, $a0
; LA64-LARGE-NEXT:    ret
entry:
  ret ptr getelementptr inbounds ([1 x i64], ptr @g_a64, i64 614749556925924693)
}
