; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck %s -check-prefixes=GFX9,SDAG,GFX9-SDAG
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck %s -check-prefixes=GFX9,GFX9-GISEL
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck %s -check-prefixes=GFX10,SDAG,GFX10-SDAG
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck %s -check-prefixes=GFX10,GFX10-GISEL

declare void @foo(i32)

define amdgpu_ps void @test(ptr addrspace(1) inreg %ptr) {
; SDAG-LABEL: test:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_mov_b32 s2, src_pops_exiting_wave_id
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_mov_b32 s2, src_pops_exiting_wave_id
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: test:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_mov_b32 s2, src_pops_exiting_wave_id
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
  %id = call i32 @llvm.amdgcn.pops.exiting.wave.id()
  store i32 %id, ptr addrspace(1) %ptr
  ret void
}

define amdgpu_ps void @test_loop() {
; GFX9-LABEL: test_loop:
; GFX9:       ; %bb.0:
; GFX9-NEXT:  .LBB1_1: ; %loop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX9-NEXT:    s_cmp_eq_u32 s0, 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX9-NEXT:  ; %bb.2: ; %exit
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: test_loop:
; GFX10:       ; %bb.0:
; GFX10-NEXT:  .LBB1_1: ; %loop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX10-NEXT:    s_cmp_eq_u32 s0, 0
; GFX10-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %exit
; GFX10-NEXT:    s_endpgm
  br label %loop
loop:
  %id = call i32 @llvm.amdgcn.pops.exiting.wave.id()
  %cond = icmp eq i32 %id, 0
  br i1 %cond, label %loop, label %exit
exit:
  ret void
}

define amdgpu_ps i32 @test_if(i1 inreg %cond) {
; SDAG-LABEL: test_if:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_bitcmp0_b32 s0, 0
; SDAG-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; SDAG-NEXT:    s_cbranch_scc1 .LBB2_2
; SDAG-NEXT:  ; %bb.1: ; %body
; SDAG-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; SDAG-NEXT:  .LBB2_2: ; %exit
; SDAG-NEXT:    ; return to shader part epilog
;
; GFX9-GISEL-LABEL: test_if:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_mov_b32 s1, s0
; GFX9-GISEL-NEXT:    s_xor_b32 s1, s1, 1
; GFX9-GISEL-NEXT:    s_and_b32 s1, s1, 1
; GFX9-GISEL-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX9-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-GISEL-NEXT:    s_cbranch_scc1 .LBB2_2
; GFX9-GISEL-NEXT:  ; %bb.1: ; %body
; GFX9-GISEL-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX9-GISEL-NEXT:  .LBB2_2: ; %exit
; GFX9-GISEL-NEXT:    ; return to shader part epilog
;
; GFX10-GISEL-LABEL: test_if:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_xor_b32 s0, s0, 1
; GFX10-GISEL-NEXT:    s_and_b32 s1, s0, 1
; GFX10-GISEL-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX10-GISEL-NEXT:    s_cmp_lg_u32 s1, 0
; GFX10-GISEL-NEXT:    s_cbranch_scc1 .LBB2_2
; GFX10-GISEL-NEXT:  ; %bb.1: ; %body
; GFX10-GISEL-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX10-GISEL-NEXT:  .LBB2_2: ; %exit
; GFX10-GISEL-NEXT:    ; return to shader part epilog
entry:
  %id1 = call i32 @llvm.amdgcn.pops.exiting.wave.id()
  br i1 %cond, label %body, label %exit
body:
  %id2 = call i32 @llvm.amdgcn.pops.exiting.wave.id()
  br label %exit
exit:
  %id = phi i32 [ %id1, %entry ], [ %id2, %body ]
  ret i32 %id
}

define amdgpu_ps void @test_call(ptr addrspace(1) inreg %ptr) {
; GFX9-SDAG-LABEL: test_call:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-SDAG-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-SDAG-NEXT:    s_mov_b32 s38, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-SDAG-NEXT:    s_add_u32 s36, s36, s2
; GFX9-SDAG-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-SDAG-NEXT:    s_getpc_b64 s[0:1]
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, foo@gotpcrel32@lo+4
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, foo@gotpcrel32@hi+12
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-SDAG-NEXT:    s_mov_b32 s6, src_pops_exiting_wave_id
; GFX9-SDAG-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-SDAG-NEXT:    s_mov_b64 s[8:9], 36
; GFX9-SDAG-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s32, 0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: test_call:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-GISEL-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-GISEL-NEXT:    s_mov_b32 s38, -1
; GFX9-GISEL-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-GISEL-NEXT:    s_add_u32 s36, s36, s2
; GFX9-GISEL-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-GISEL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, foo@gotpcrel32@lo+4
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, foo@gotpcrel32@hi+12
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s2, src_pops_exiting_wave_id
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-GISEL-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-GISEL-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-GISEL-NEXT:    s_mov_b64 s[8:9], 36
; GFX9-GISEL-NEXT:    s_mov_b32 s32, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-LABEL: test_call:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX10-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX10-NEXT:    s_mov_b32 s38, -1
; GFX10-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX10-NEXT:    s_add_u32 s36, s36, s2
; GFX10-NEXT:    s_addc_u32 s37, s37, 0
; GFX10-NEXT:    s_getpc_b64 s[0:1]
; GFX10-NEXT:    s_add_u32 s0, s0, foo@gotpcrel32@lo+4
; GFX10-NEXT:    s_addc_u32 s1, s1, foo@gotpcrel32@hi+12
; GFX10-NEXT:    s_mov_b64 s[8:9], 36
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX10-NEXT:    s_mov_b32 s0, src_pops_exiting_wave_id
; GFX10-NEXT:    s_mov_b32 s32, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX10-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; GFX10-NEXT:    s_endpgm
  %id = call i32 @llvm.amdgcn.pops.exiting.wave.id()
  call void @foo(i32 %id)
  ret void
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10-SDAG: {{.*}}
