; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --tool build/bin/opt --version 5
; RUN: opt < %s -S -passes="msan<eager-checks;track-origins=2>" -msan-instrumentation-with-call-threshold=0 | FileCheck %s
;
; This test illustrates a bug in MemorySanitizer that will shortly be fixed
; (https://github.com/llvm/llvm-project/pull/96722).
;
; '-msan-instrumentation-with-call-threshold=0' makes it possible to detect the
; bug with a short test case.
;
; This is based on check-struct.ll.

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define { i32, i8 } @main() sanitize_memory {
; CHECK-LABEL: define { i32, i8 } @main(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[P:%.*]] = inttoptr i64 0 to ptr
; CHECK-NEXT:    [[O:%.*]] = load { i32, i8 }, ptr [[P]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 87960930222080
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    [[TMP4:%.*]] = add i64 [[TMP2]], 17592186044416
; CHECK-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP4]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load { i32, i8 }, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 4
; CHECK-NEXT:    store { i32, i8 } zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    [[TMP7:%.*]] = extractvalue { i32, i8 } [[_MSLD]], 0
; CHECK-NEXT:    [[TMP8:%.*]] = icmp ne i32 [[TMP7]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = extractvalue { i32, i8 } [[_MSLD]], 1
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ne i8 [[TMP9]], 0
; CHECK-NEXT:    [[TMP11:%.*]] = or i1 [[TMP8]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = zext i1 [[TMP11]] to i64
; CHECK-NEXT:    call void @__msan_maybe_warning_8(i64 zeroext [[TMP12]], i32 zeroext [[TMP6]])
; CHECK-NEXT:    ret { i32, i8 } [[O]]
;
  %p = inttoptr i64 0 to ptr
  %o = load { i32, i8 }, ptr %p
  ret { i32, i8 } %o
}
