; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s

define half @use_acosf16(half %a) nounwind {
; CHECK-LABEL: use_acosf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __extendhfsf2@PLT
; CHECK-NEXT:    callq acosf@PLT
; CHECK-NEXT:    callq __truncsfhf2@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
  %x = call half @llvm.acos.f16(half %a)
  ret half %x
}

define float @use_acosf32(float %a) nounwind {
; CHECK-LABEL: use_acosf32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp acosf@PLT # TAILCALL
  %x = call float @llvm.acos.f32(float %a)
  ret float %x
}

define double @use_acosf64(double %a) nounwind {
; CHECK-LABEL: use_acosf64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp acos@PLT # TAILCALL
  %x = call double @llvm.acos.f64(double %a)
  ret double %x
}

define x86_fp80 @use_acosf80(x86_fp80 %a) nounwind {
; CHECK-LABEL: use_acosf80:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subq $24, %rsp
; CHECK-NEXT:    fldt 32(%rsp)
; CHECK-NEXT:    fstpt (%rsp)
; CHECK-NEXT:    callq acosl@PLT
; CHECK-NEXT:    addq  $24, %rsp
; CHECK-NEXT:    retq
  %x = call x86_fp80 @llvm.acos.f80(x86_fp80 %a)
  ret x86_fp80 %x
}

define fp128 @use_acosfp128(fp128 %a) nounwind {
; CHECK-LABEL: use_acosfp128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp  acosf128@PLT # TAILCALL
  %x = call fp128 @llvm.acos.f128(fp128 %a)
  ret fp128 %x
}

define ppc_fp128 @use_acosppc_fp128(ppc_fp128 %a) nounwind {
; CHECK-LABEL: use_acosppc_fp128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq acosl@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
  %x = call ppc_fp128 @llvm.acos.ppcf128(ppc_fp128 %a)
  ret ppc_fp128 %x
}

declare half @llvm.acos.f16(half)
declare float @llvm.acos.f32(float)
declare double @llvm.acos.f64(double)
declare x86_fp80 @llvm.acos.f80(x86_fp80)
declare fp128 @llvm.acos.f128(fp128)
declare ppc_fp128 @llvm.acos.ppcf128(ppc_fp128)
