; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E-FPELIM %s
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -frame-pointer=all \
; RUN:   -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E-WITHFP %s
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -mattr=+save-restore -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E-FPELIM-SAVE-RESTORE %s
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -mattr=+save-restore -frame-pointer=all \
; RUN:   -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E-WITHFP-SAVE-RESTORE %s

; This file contains tests that will have differing output for the ilp32e ABIs.

define i32 @callee_float_in_regs(i32 %a, float %b) {
; ILP32E-FPELIM-LABEL: callee_float_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -8
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    mv s0, a0
; ILP32E-FPELIM-NEXT:    mv a0, a1
; ILP32E-FPELIM-NEXT:    call __fixsfsi
; ILP32E-FPELIM-NEXT:    add a0, s0, a0
; ILP32E-FPELIM-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 8
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_float_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 12
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    .cfi_offset s1, -12
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    mv s1, a0
; ILP32E-WITHFP-NEXT:    mv a0, a1
; ILP32E-WITHFP-NEXT:    call __fixsfsi
; ILP32E-WITHFP-NEXT:    add a0, s1, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 12
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    .cfi_restore s1
; ILP32E-WITHFP-NEXT:    addi sp, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_float_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv s0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call __fixsfsi
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, s0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_float_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s1, -12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv s1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call __fixsfsi
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, s1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_2
  %b_fptosi = fptosi float %b to i32
  %1 = add i32 %a, %b_fptosi
  ret i32 %1
}

define i32 @caller_float_in_regs() {
; ILP32E-FPELIM-LABEL: caller_float_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    lui a1, 262144
; ILP32E-FPELIM-NEXT:    call callee_float_in_regs
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_float_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    lui a1, 262144
; ILP32E-WITHFP-NEXT:    call callee_float_in_regs
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_float_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a1, 262144
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_float_in_regs
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_float_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a1, 262144
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_float_in_regs
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_float_in_regs(i32 1, float 2.0)
  ret i32 %1
}

define i32 @callee_float_on_stack(i64 %a, i64 %b, i64 %c, i64 %d, float %e) {
; ILP32E-FPELIM-LABEL: callee_float_on_stack:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a0, 8(sp)
; ILP32E-FPELIM-NEXT:    lw a1, 0(sp)
; ILP32E-FPELIM-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_float_on_stack:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a0, 8(s0)
; ILP32E-WITHFP-NEXT:    lw a1, 0(s0)
; ILP32E-WITHFP-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_float_on_stack:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_float_on_stack:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 8(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 0(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = trunc i64 %d to i32
  %2 = bitcast float %e to i32
  %3 = add i32 %1, %2
  ret i32 %3
}

define i32 @caller_float_on_stack() {
; ILP32E-FPELIM-LABEL: caller_float_on_stack:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -16
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 16
; ILP32E-FPELIM-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    lui a1, 264704
; ILP32E-FPELIM-NEXT:    li a3, 4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a2, 2
; ILP32E-FPELIM-NEXT:    li a4, 3
; ILP32E-FPELIM-NEXT:    sw a3, 0(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-NEXT:    li a1, 0
; ILP32E-FPELIM-NEXT:    li a3, 0
; ILP32E-FPELIM-NEXT:    li a5, 0
; ILP32E-FPELIM-NEXT:    call callee_float_on_stack
; ILP32E-FPELIM-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 16
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_float_on_stack:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -20
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 20
; ILP32E-WITHFP-NEXT:    sw ra, 16(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 20
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lui a1, 264704
; ILP32E-WITHFP-NEXT:    li a3, 4
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a2, 2
; ILP32E-WITHFP-NEXT:    li a4, 3
; ILP32E-WITHFP-NEXT:    sw a3, 0(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 4(sp)
; ILP32E-WITHFP-NEXT:    sw a1, 8(sp)
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    li a3, 0
; ILP32E-WITHFP-NEXT:    li a5, 0
; ILP32E-WITHFP-NEXT:    call callee_float_on_stack
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 20
; ILP32E-WITHFP-NEXT:    lw ra, 16(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 20
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_float_on_stack:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -12
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a1, 264704
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a3, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a5, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_float_on_stack
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 12
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_float_on_stack:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 20
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 20
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a1, 264704
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a3, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 4(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, 8(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a5, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_float_on_stack
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 20
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_float_on_stack(i64 1, i64 2, i64 3, i64 4, float 5.0)
  ret i32 %1
}

define float @callee_tiny_scalar_ret() {
; ILP32E-FPELIM-LABEL: callee_tiny_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lui a0, 260096
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_tiny_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lui a0, 260096
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_tiny_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a0, 260096
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_tiny_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a0, 260096
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  ret float 1.0
}

define i32 @caller_tiny_scalar_ret() {
; ILP32E-FPELIM-LABEL: caller_tiny_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    call callee_tiny_scalar_ret
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_tiny_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    call callee_tiny_scalar_ret
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_tiny_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_tiny_scalar_ret
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_tiny_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_tiny_scalar_ret
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call float @callee_tiny_scalar_ret()
  %2 = bitcast float %1 to i32
  ret i32 %2
}

; Check that on RV32 ilp32e, double is passed in a pair of registers. Unlike
; the convention for varargs, this need not be an aligned pair.

define i32 @callee_double_in_regs(i32 %a, double %b) {
; ILP32E-FPELIM-LABEL: callee_double_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -8
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    mv s0, a0
; ILP32E-FPELIM-NEXT:    mv a0, a1
; ILP32E-FPELIM-NEXT:    mv a1, a2
; ILP32E-FPELIM-NEXT:    call __fixdfsi
; ILP32E-FPELIM-NEXT:    add a0, s0, a0
; ILP32E-FPELIM-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 8
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_double_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 12
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    .cfi_offset s1, -12
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    mv s1, a0
; ILP32E-WITHFP-NEXT:    mv a0, a1
; ILP32E-WITHFP-NEXT:    mv a1, a2
; ILP32E-WITHFP-NEXT:    call __fixdfsi
; ILP32E-WITHFP-NEXT:    add a0, s1, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 12
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    .cfi_restore s1
; ILP32E-WITHFP-NEXT:    addi sp, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_double_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv s0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a1, a2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call __fixdfsi
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, s0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_double_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s1, -12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv s1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a1, a2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call __fixdfsi
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, s1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_2
  %b_fptosi = fptosi double %b to i32
  %1 = add i32 %a, %b_fptosi
  ret i32 %1
}

define i32 @caller_double_in_regs() {
; ILP32E-FPELIM-LABEL: caller_double_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    lui a2, 262144
; ILP32E-FPELIM-NEXT:    li a1, 0
; ILP32E-FPELIM-NEXT:    call callee_double_in_regs
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_double_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    lui a2, 262144
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    call callee_double_in_regs
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_double_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a2, 262144
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_double_in_regs
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_double_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a2, 262144
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_double_in_regs
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_double_in_regs(i32 1, double 2.0)
  ret i32 %1
}

; Check 2x*xlen values are aligned appropriately when passed on the stack
; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_aligned_stack(i32 %a, i32 %b, fp128 %c, i32 %d, i32 %e, i64 %f, i32 %g, i32 %h, double %i, i32 %j, [2 x i32] %k) {
; The double should be 8-byte aligned on the stack, but the two-element array
; should only be 4-byte aligned
; ILP32E-FPELIM-LABEL: callee_aligned_stack:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a0, 0(a2)
; ILP32E-FPELIM-NEXT:    lw a1, 12(sp)
; ILP32E-FPELIM-NEXT:    lw a2, 4(sp)
; ILP32E-FPELIM-NEXT:    lw a3, 8(sp)
; ILP32E-FPELIM-NEXT:    lw a4, 24(sp)
; ILP32E-FPELIM-NEXT:    lw a5, 20(sp)
; ILP32E-FPELIM-NEXT:    add a0, a0, a2
; ILP32E-FPELIM-NEXT:    add a1, a3, a1
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    add a4, a5, a4
; ILP32E-FPELIM-NEXT:    add a0, a0, a4
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_aligned_stack:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a0, 0(a2)
; ILP32E-WITHFP-NEXT:    lw a1, 12(s0)
; ILP32E-WITHFP-NEXT:    lw a2, 4(s0)
; ILP32E-WITHFP-NEXT:    lw a3, 8(s0)
; ILP32E-WITHFP-NEXT:    lw a4, 24(s0)
; ILP32E-WITHFP-NEXT:    lw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    add a0, a0, a2
; ILP32E-WITHFP-NEXT:    add a1, a3, a1
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    add a4, a5, a4
; ILP32E-WITHFP-NEXT:    add a0, a0, a4
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_aligned_stack:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 0(a2)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a2, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a3, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a4, 24(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a5, 20(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a1, a3, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a4, a5, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_aligned_stack:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 0(a2)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 12(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a2, 4(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a3, 8(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a4, 24(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a5, 20(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a1, a3, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a4, a5, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = bitcast fp128 %c to i128
  %2 = trunc i128 %1 to i32
  %3 = add i32 %2, %g
  %4 = add i32 %3, %h
  %5 = bitcast double %i to i64
  %6 = trunc i64 %5 to i32
  %7 = add i32 %4, %6
  %8 = add i32 %7, %j
  %9 = extractvalue [2 x i32] %k, 0
  %10 = add i32 %8, %9
  ret i32 %10
}

define void @caller_aligned_stack() {
; The double should be 8-byte aligned on the stack, but the two-element array
; should only be 4-byte aligned
; ILP32E-FPELIM-LABEL: caller_aligned_stack:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-FPELIM-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-NEXT:    li a3, 18
; ILP32E-FPELIM-NEXT:    li a4, 17
; ILP32E-FPELIM-NEXT:    li a5, 16
; ILP32E-FPELIM-NEXT:    lui a6, 262236
; ILP32E-FPELIM-NEXT:    lui a7, 377487
; ILP32E-FPELIM-NEXT:    li t0, 15
; ILP32E-FPELIM-NEXT:    li t1, 14
; ILP32E-FPELIM-NEXT:    li t2, 4
; ILP32E-FPELIM-NEXT:    lui t3, 262153
; ILP32E-FPELIM-NEXT:    lui t4, 545260
; ILP32E-FPELIM-NEXT:    lui t5, 964690
; ILP32E-FPELIM-NEXT:    lui t6, 335544
; ILP32E-FPELIM-NEXT:    lui s2, 688509
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 11
; ILP32E-FPELIM-NEXT:    addi a2, sp, 32
; ILP32E-FPELIM-NEXT:    addi a6, a6, 655
; ILP32E-FPELIM-NEXT:    sw a6, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 20(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32E-FPELIM-NEXT:    li a3, 12
; ILP32E-FPELIM-NEXT:    addi a4, a7, 1475
; ILP32E-FPELIM-NEXT:    sw t2, 0(sp)
; ILP32E-FPELIM-NEXT:    sw t1, 4(sp)
; ILP32E-FPELIM-NEXT:    sw t0, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    li a4, 13
; ILP32E-FPELIM-NEXT:    addi a6, t3, 491
; ILP32E-FPELIM-NEXT:    addi a7, t4, -1967
; ILP32E-FPELIM-NEXT:    addi t0, t5, -328
; ILP32E-FPELIM-NEXT:    addi t1, t6, 1311
; ILP32E-FPELIM-NEXT:    addi a5, s2, -2048
; ILP32E-FPELIM-NEXT:    sw t1, 32(sp)
; ILP32E-FPELIM-NEXT:    sw t0, 36(sp)
; ILP32E-FPELIM-NEXT:    sw a7, 40(sp)
; ILP32E-FPELIM-NEXT:    sw a6, 44(sp)
; ILP32E-FPELIM-NEXT:    call callee_aligned_stack
; ILP32E-FPELIM-NEXT:    addi sp, s0, -64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-FPELIM-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_aligned_stack:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-WITHFP-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-NEXT:    li a3, 18
; ILP32E-WITHFP-NEXT:    li a4, 17
; ILP32E-WITHFP-NEXT:    li a5, 16
; ILP32E-WITHFP-NEXT:    lui a6, 262236
; ILP32E-WITHFP-NEXT:    lui a7, 377487
; ILP32E-WITHFP-NEXT:    li t0, 15
; ILP32E-WITHFP-NEXT:    li t1, 14
; ILP32E-WITHFP-NEXT:    li t2, 4
; ILP32E-WITHFP-NEXT:    lui t3, 262153
; ILP32E-WITHFP-NEXT:    lui t4, 545260
; ILP32E-WITHFP-NEXT:    lui t5, 964690
; ILP32E-WITHFP-NEXT:    lui t6, 335544
; ILP32E-WITHFP-NEXT:    lui s2, 688509
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 11
; ILP32E-WITHFP-NEXT:    addi a2, sp, 32
; ILP32E-WITHFP-NEXT:    addi a6, a6, 655
; ILP32E-WITHFP-NEXT:    sw a6, 16(sp)
; ILP32E-WITHFP-NEXT:    sw a5, 20(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 24(sp)
; ILP32E-WITHFP-NEXT:    sw a3, 28(sp)
; ILP32E-WITHFP-NEXT:    li a3, 12
; ILP32E-WITHFP-NEXT:    addi a4, a7, 1475
; ILP32E-WITHFP-NEXT:    sw t2, 0(sp)
; ILP32E-WITHFP-NEXT:    sw t1, 4(sp)
; ILP32E-WITHFP-NEXT:    sw t0, 8(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-NEXT:    li a4, 13
; ILP32E-WITHFP-NEXT:    addi a6, t3, 491
; ILP32E-WITHFP-NEXT:    addi a7, t4, -1967
; ILP32E-WITHFP-NEXT:    addi t0, t5, -328
; ILP32E-WITHFP-NEXT:    addi t1, t6, 1311
; ILP32E-WITHFP-NEXT:    addi a5, s2, -2048
; ILP32E-WITHFP-NEXT:    sw t1, 32(sp)
; ILP32E-WITHFP-NEXT:    sw t0, 36(sp)
; ILP32E-WITHFP-NEXT:    sw a7, 40(sp)
; ILP32E-WITHFP-NEXT:    sw a6, 44(sp)
; ILP32E-WITHFP-NEXT:    call callee_aligned_stack
; ILP32E-WITHFP-NEXT:    addi sp, s0, -64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-WITHFP-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_aligned_stack:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -56
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 18
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 17
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a5, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a6, 262236
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a7, 377487
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li t0, 15
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li t1, 14
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li t2, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui t3, 262153
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui t4, 545260
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui t5, 964690
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui t6, 335544
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui s2, 688509
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 11
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a2, sp, 32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a6, a6, 655
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a6, 16(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a5, 20(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a4, 24(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a3, 28(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 12
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a4, a7, 1475
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t2, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t1, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t0, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 13
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a6, t3, 491
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a7, t4, -1967
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi t0, t5, -328
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi t1, t6, 1311
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a5, s2, -2048
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t1, 32(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t0, 36(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a7, 40(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a6, 44(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_aligned_stack
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 56
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_aligned_stack:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -56
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 18
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 17
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a5, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a6, 262236
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a7, 377487
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li t0, 15
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li t1, 14
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li t2, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui t3, 262153
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui t4, 545260
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui t5, 964690
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui t6, 335544
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui s2, 688509
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 11
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a2, sp, 32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a6, a6, 655
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a6, 16(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a5, 20(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a4, 24(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a3, 28(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 12
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a4, a7, 1475
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t2, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t1, 4(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t0, 8(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 13
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a6, t3, 491
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a7, t4, -1967
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi t0, t5, -328
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi t1, t6, 1311
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a5, s2, -2048
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t1, 32(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t0, 36(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a7, 40(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a6, 44(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_aligned_stack
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 56
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_aligned_stack(i32 1, i32 11,
    fp128 0xLEB851EB851EB851F400091EB851EB851, i32 12, i32 13,
    i64 20000000000, i32 14, i32 15, double 2.720000e+00, i32 16,
    [2 x i32] [i32 17, i32 18])
  ret void
}

define double @callee_small_scalar_ret() {
; ILP32E-FPELIM-LABEL: callee_small_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lui a1, 261888
; ILP32E-FPELIM-NEXT:    li a0, 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_small_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lui a1, 261888
; ILP32E-WITHFP-NEXT:    li a0, 0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_small_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a1, 261888
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_small_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a1, 261888
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  ret double 1.0
}

define i64 @caller_small_scalar_ret() {
; ILP32E-FPELIM-LABEL: caller_small_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    call callee_small_scalar_ret
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_small_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    call callee_small_scalar_ret
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_small_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_small_scalar_ret
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_small_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_small_scalar_ret
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call double @callee_small_scalar_ret()
  %2 = bitcast double %1 to i64
  ret i64 %2
}

; Check that on RV32, i64 is passed in a pair of registers. Unlike
; the convention for varargs, this need not be an aligned pair.

define i32 @callee_i64_in_regs(i32 %a, i64 %b) {
; ILP32E-FPELIM-LABEL: callee_i64_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_i64_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_i64_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_i64_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %b_trunc = trunc i64 %b to i32
  %1 = add i32 %a, %b_trunc
  ret i32 %1
}

define i32 @caller_i64_in_regs() {
; ILP32E-FPELIM-LABEL: caller_i64_in_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 2
; ILP32E-FPELIM-NEXT:    li a2, 0
; ILP32E-FPELIM-NEXT:    call callee_i64_in_regs
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_i64_in_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 2
; ILP32E-WITHFP-NEXT:    li a2, 0
; ILP32E-WITHFP-NEXT:    call callee_i64_in_regs
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_i64_in_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_i64_in_regs
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_i64_in_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_i64_in_regs
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_i64_in_regs(i32 1, i64 2)
  ret i32 %1
}

; Check that the stack is used once the GPRs are exhausted

define i32 @callee_many_scalars(i8 %a, i16 %b, i32 %c, i64 %d, i32 %e, i32 %f, i64 %g, i32 %h) {
; ILP32E-FPELIM-LABEL: callee_many_scalars:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a6, 12(sp)
; ILP32E-FPELIM-NEXT:    lw a7, 0(sp)
; ILP32E-FPELIM-NEXT:    lw t0, 4(sp)
; ILP32E-FPELIM-NEXT:    lw t1, 8(sp)
; ILP32E-FPELIM-NEXT:    andi a0, a0, 255
; ILP32E-FPELIM-NEXT:    slli a1, a1, 16
; ILP32E-FPELIM-NEXT:    srli a1, a1, 16
; ILP32E-FPELIM-NEXT:    add a0, a0, a2
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    add a0, a0, a5
; ILP32E-FPELIM-NEXT:    xor a1, a4, t1
; ILP32E-FPELIM-NEXT:    xor a2, a3, t0
; ILP32E-FPELIM-NEXT:    add a0, a0, a7
; ILP32E-FPELIM-NEXT:    or a1, a2, a1
; ILP32E-FPELIM-NEXT:    seqz a1, a1
; ILP32E-FPELIM-NEXT:    add a0, a0, a6
; ILP32E-FPELIM-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_many_scalars:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a6, 12(s0)
; ILP32E-WITHFP-NEXT:    lw a7, 0(s0)
; ILP32E-WITHFP-NEXT:    lw t0, 4(s0)
; ILP32E-WITHFP-NEXT:    lw t1, 8(s0)
; ILP32E-WITHFP-NEXT:    andi a0, a0, 255
; ILP32E-WITHFP-NEXT:    slli a1, a1, 16
; ILP32E-WITHFP-NEXT:    srli a1, a1, 16
; ILP32E-WITHFP-NEXT:    add a0, a0, a2
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    add a0, a0, a5
; ILP32E-WITHFP-NEXT:    xor a1, a4, t1
; ILP32E-WITHFP-NEXT:    xor a2, a3, t0
; ILP32E-WITHFP-NEXT:    add a0, a0, a7
; ILP32E-WITHFP-NEXT:    or a1, a2, a1
; ILP32E-WITHFP-NEXT:    seqz a1, a1
; ILP32E-WITHFP-NEXT:    add a0, a0, a6
; ILP32E-WITHFP-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_many_scalars:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a6, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a7, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw t0, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw t1, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi a0, a0, 255
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    slli a1, a1, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    srli a1, a1, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a5
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a1, a4, t1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a2, a3, t0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a7
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a1, a2, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    seqz a1, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a6
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_many_scalars:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a6, 12(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a7, 0(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw t0, 4(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw t1, 8(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi a0, a0, 255
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    slli a1, a1, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    srli a1, a1, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a5
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a1, a4, t1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a2, a3, t0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a7
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a1, a2, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    seqz a1, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a6
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %a_ext = zext i8 %a to i32
  %b_ext = zext i16 %b to i32
  %1 = add i32 %a_ext, %b_ext
  %2 = add i32 %1, %c
  %3 = icmp eq i64 %d, %g
  %4 = zext i1 %3 to i32
  %5 = add i32 %4, %2
  %6 = add i32 %5, %e
  %7 = add i32 %6, %f
  %8 = add i32 %7, %h
  ret i32 %8
}

define i32 @caller_many_scalars() {
; ILP32E-FPELIM-LABEL: caller_many_scalars:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -20
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 20
; ILP32E-FPELIM-NEXT:    sw ra, 16(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a4, 8
; ILP32E-FPELIM-NEXT:    li a6, 7
; ILP32E-FPELIM-NEXT:    li a7, 6
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 2
; ILP32E-FPELIM-NEXT:    li a2, 3
; ILP32E-FPELIM-NEXT:    li a3, 4
; ILP32E-FPELIM-NEXT:    li a5, 5
; ILP32E-FPELIM-NEXT:    sw a7, 0(sp)
; ILP32E-FPELIM-NEXT:    sw a6, 4(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    li a4, 0
; ILP32E-FPELIM-NEXT:    call callee_many_scalars
; ILP32E-FPELIM-NEXT:    lw ra, 16(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 20
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_many_scalars:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a4, 8
; ILP32E-WITHFP-NEXT:    li a6, 7
; ILP32E-WITHFP-NEXT:    li a7, 6
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 2
; ILP32E-WITHFP-NEXT:    li a2, 3
; ILP32E-WITHFP-NEXT:    li a3, 4
; ILP32E-WITHFP-NEXT:    li a5, 5
; ILP32E-WITHFP-NEXT:    sw a7, 0(sp)
; ILP32E-WITHFP-NEXT:    sw a6, 4(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 8(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-NEXT:    li a4, 0
; ILP32E-WITHFP-NEXT:    call callee_many_scalars
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_many_scalars:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 20
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a6, 7
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a7, 6
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a5, 5
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a7, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a6, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_many_scalars
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_many_scalars:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a6, 7
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a7, 6
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a5, 5
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a7, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a6, 4(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 8(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_many_scalars
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_many_scalars(i8 1, i16 2, i32 3, i64 4, i32 5, i32 6, i64 7, i32 8)
  ret i32 %1
}

; Check that i128 and fp128 are passed indirectly

define i32 @callee_large_scalars(i128 %a, fp128 %b) {
; ILP32E-FPELIM-LABEL: callee_large_scalars:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a2, 0(a1)
; ILP32E-FPELIM-NEXT:    lw a3, 4(a1)
; ILP32E-FPELIM-NEXT:    lw a4, 8(a1)
; ILP32E-FPELIM-NEXT:    lw a1, 12(a1)
; ILP32E-FPELIM-NEXT:    lw a5, 12(a0)
; ILP32E-FPELIM-NEXT:    lw a6, 4(a0)
; ILP32E-FPELIM-NEXT:    lw a7, 8(a0)
; ILP32E-FPELIM-NEXT:    lw a0, 0(a0)
; ILP32E-FPELIM-NEXT:    xor a1, a5, a1
; ILP32E-FPELIM-NEXT:    xor a3, a6, a3
; ILP32E-FPELIM-NEXT:    xor a4, a7, a4
; ILP32E-FPELIM-NEXT:    xor a0, a0, a2
; ILP32E-FPELIM-NEXT:    or a1, a3, a1
; ILP32E-FPELIM-NEXT:    or a0, a0, a4
; ILP32E-FPELIM-NEXT:    or a0, a0, a1
; ILP32E-FPELIM-NEXT:    seqz a0, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_large_scalars:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a2, 0(a1)
; ILP32E-WITHFP-NEXT:    lw a3, 4(a1)
; ILP32E-WITHFP-NEXT:    lw a4, 8(a1)
; ILP32E-WITHFP-NEXT:    lw a1, 12(a1)
; ILP32E-WITHFP-NEXT:    lw a5, 12(a0)
; ILP32E-WITHFP-NEXT:    lw a6, 4(a0)
; ILP32E-WITHFP-NEXT:    lw a7, 8(a0)
; ILP32E-WITHFP-NEXT:    lw a0, 0(a0)
; ILP32E-WITHFP-NEXT:    xor a1, a5, a1
; ILP32E-WITHFP-NEXT:    xor a3, a6, a3
; ILP32E-WITHFP-NEXT:    xor a4, a7, a4
; ILP32E-WITHFP-NEXT:    xor a0, a0, a2
; ILP32E-WITHFP-NEXT:    or a1, a3, a1
; ILP32E-WITHFP-NEXT:    or a0, a0, a4
; ILP32E-WITHFP-NEXT:    or a0, a0, a1
; ILP32E-WITHFP-NEXT:    seqz a0, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_large_scalars:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a2, 0(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a3, 4(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a4, 8(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 12(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a5, 12(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a6, 4(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a7, 8(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 0(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a1, a5, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a3, a6, a3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a4, a7, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a0, a0, a2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a1, a3, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a0, a0, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_large_scalars:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a2, 0(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a3, 4(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a4, 8(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 12(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a5, 12(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a6, 4(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a7, 8(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 0(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a1, a5, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a3, a6, a3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a4, a7, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a0, a0, a2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a1, a3, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a0, a0, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %b_bitcast = bitcast fp128 %b to i128
  %1 = icmp eq i128 %a, %b_bitcast
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @caller_large_scalars() {
; ILP32E-FPELIM-LABEL: caller_large_scalars:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -48
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 48
; ILP32E-FPELIM-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 48
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-NEXT:    lui a1, 524272
; ILP32E-FPELIM-NEXT:    li a2, 1
; ILP32E-FPELIM-NEXT:    addi a0, sp, 24
; ILP32E-FPELIM-NEXT:    sw zero, 0(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 4(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 12(sp)
; ILP32E-FPELIM-NEXT:    mv a1, sp
; ILP32E-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 28(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 32(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 36(sp)
; ILP32E-FPELIM-NEXT:    call callee_large_scalars
; ILP32E-FPELIM-NEXT:    addi sp, s0, -48
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 48
; ILP32E-FPELIM-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 48
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_large_scalars:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -48
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 48
; ILP32E-WITHFP-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 48
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-NEXT:    lui a1, 524272
; ILP32E-WITHFP-NEXT:    li a2, 1
; ILP32E-WITHFP-NEXT:    addi a0, sp, 24
; ILP32E-WITHFP-NEXT:    sw zero, 0(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 4(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 8(sp)
; ILP32E-WITHFP-NEXT:    sw a1, 12(sp)
; ILP32E-WITHFP-NEXT:    mv a1, sp
; ILP32E-WITHFP-NEXT:    sw a2, 24(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 28(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 32(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 36(sp)
; ILP32E-WITHFP-NEXT:    call callee_large_scalars
; ILP32E-WITHFP-NEXT:    addi sp, s0, -48
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 48
; ILP32E-WITHFP-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 48
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_large_scalars:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -40
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 48
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 48
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a1, 524272
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a0, sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a1, sp
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a2, 24(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 28(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 32(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 36(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_large_scalars
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -48
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 48
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 40
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_large_scalars:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 48
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 48
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a1, 524272
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a0, sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 4(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 8(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, 12(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a1, sp
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a2, 24(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 28(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 32(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 36(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_large_scalars
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -48
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 48
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_large_scalars(i128 1, fp128 0xL00000000000000007FFF000000000000)
  ret i32 %1
}

; Check that arguments larger than 2*xlen are handled correctly when their
; address is passed on the stack rather than in memory

; Must keep define on a single line due to an update_llc_test_checks.py limitation
define i32 @callee_large_scalars_exhausted_regs(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i128 %h, i32 %i, fp128 %j) {
; ILP32E-FPELIM-LABEL: callee_large_scalars_exhausted_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a0, 12(sp)
; ILP32E-FPELIM-NEXT:    lw a1, 4(sp)
; ILP32E-FPELIM-NEXT:    lw a2, 0(a0)
; ILP32E-FPELIM-NEXT:    lw a3, 4(a0)
; ILP32E-FPELIM-NEXT:    lw a4, 8(a0)
; ILP32E-FPELIM-NEXT:    lw a0, 12(a0)
; ILP32E-FPELIM-NEXT:    lw a5, 12(a1)
; ILP32E-FPELIM-NEXT:    lw a6, 4(a1)
; ILP32E-FPELIM-NEXT:    lw a7, 8(a1)
; ILP32E-FPELIM-NEXT:    lw a1, 0(a1)
; ILP32E-FPELIM-NEXT:    xor a0, a5, a0
; ILP32E-FPELIM-NEXT:    xor a3, a6, a3
; ILP32E-FPELIM-NEXT:    xor a4, a7, a4
; ILP32E-FPELIM-NEXT:    xor a1, a1, a2
; ILP32E-FPELIM-NEXT:    or a0, a3, a0
; ILP32E-FPELIM-NEXT:    or a1, a1, a4
; ILP32E-FPELIM-NEXT:    or a0, a1, a0
; ILP32E-FPELIM-NEXT:    seqz a0, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_large_scalars_exhausted_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a0, 12(s0)
; ILP32E-WITHFP-NEXT:    lw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    lw a2, 0(a0)
; ILP32E-WITHFP-NEXT:    lw a3, 4(a0)
; ILP32E-WITHFP-NEXT:    lw a4, 8(a0)
; ILP32E-WITHFP-NEXT:    lw a0, 12(a0)
; ILP32E-WITHFP-NEXT:    lw a5, 12(a1)
; ILP32E-WITHFP-NEXT:    lw a6, 4(a1)
; ILP32E-WITHFP-NEXT:    lw a7, 8(a1)
; ILP32E-WITHFP-NEXT:    lw a1, 0(a1)
; ILP32E-WITHFP-NEXT:    xor a0, a5, a0
; ILP32E-WITHFP-NEXT:    xor a3, a6, a3
; ILP32E-WITHFP-NEXT:    xor a4, a7, a4
; ILP32E-WITHFP-NEXT:    xor a1, a1, a2
; ILP32E-WITHFP-NEXT:    or a0, a3, a0
; ILP32E-WITHFP-NEXT:    or a1, a1, a4
; ILP32E-WITHFP-NEXT:    or a0, a1, a0
; ILP32E-WITHFP-NEXT:    seqz a0, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_large_scalars_exhausted_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a2, 0(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a3, 4(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a4, 8(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 12(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a5, 12(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a6, 4(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a7, 8(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 0(a1)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a0, a5, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a3, a6, a3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a4, a7, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a1, a1, a2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a0, a3, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a1, a1, a4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    or a0, a1, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_large_scalars_exhausted_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 12(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 4(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a2, 0(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a3, 4(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a4, 8(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 12(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a5, 12(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a6, 4(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a7, 8(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 0(a1)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a0, a5, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a3, a6, a3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a4, a7, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a1, a1, a2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a0, a3, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a1, a1, a4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    or a0, a1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %j_bitcast = bitcast fp128 %j to i128
  %1 = icmp eq i128 %h, %j_bitcast
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @caller_large_scalars_exhausted_regs() {
; ILP32E-FPELIM-LABEL: caller_large_scalars_exhausted_regs:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-FPELIM-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-NEXT:    addi a4, sp, 16
; ILP32E-FPELIM-NEXT:    li a5, 9
; ILP32E-FPELIM-NEXT:    addi a6, sp, 40
; ILP32E-FPELIM-NEXT:    li a7, 7
; ILP32E-FPELIM-NEXT:    lui t0, 524272
; ILP32E-FPELIM-NEXT:    li t1, 8
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 2
; ILP32E-FPELIM-NEXT:    li a2, 3
; ILP32E-FPELIM-NEXT:    li a3, 4
; ILP32E-FPELIM-NEXT:    sw a7, 0(sp)
; ILP32E-FPELIM-NEXT:    sw a6, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a5, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-NEXT:    li a4, 5
; ILP32E-FPELIM-NEXT:    sw zero, 16(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 20(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 24(sp)
; ILP32E-FPELIM-NEXT:    sw t0, 28(sp)
; ILP32E-FPELIM-NEXT:    li a5, 6
; ILP32E-FPELIM-NEXT:    sw t1, 40(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 44(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 48(sp)
; ILP32E-FPELIM-NEXT:    sw zero, 52(sp)
; ILP32E-FPELIM-NEXT:    call callee_large_scalars_exhausted_regs
; ILP32E-FPELIM-NEXT:    addi sp, s0, -64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-FPELIM-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 64
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_large_scalars_exhausted_regs:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-WITHFP-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-NEXT:    addi a4, sp, 16
; ILP32E-WITHFP-NEXT:    li a5, 9
; ILP32E-WITHFP-NEXT:    addi a6, sp, 40
; ILP32E-WITHFP-NEXT:    li a7, 7
; ILP32E-WITHFP-NEXT:    lui t0, 524272
; ILP32E-WITHFP-NEXT:    li t1, 8
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 2
; ILP32E-WITHFP-NEXT:    li a2, 3
; ILP32E-WITHFP-NEXT:    li a3, 4
; ILP32E-WITHFP-NEXT:    sw a7, 0(sp)
; ILP32E-WITHFP-NEXT:    sw a6, 4(sp)
; ILP32E-WITHFP-NEXT:    sw a5, 8(sp)
; ILP32E-WITHFP-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-NEXT:    li a4, 5
; ILP32E-WITHFP-NEXT:    sw zero, 16(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 20(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 24(sp)
; ILP32E-WITHFP-NEXT:    sw t0, 28(sp)
; ILP32E-WITHFP-NEXT:    li a5, 6
; ILP32E-WITHFP-NEXT:    sw t1, 40(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 44(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 48(sp)
; ILP32E-WITHFP-NEXT:    sw zero, 52(sp)
; ILP32E-WITHFP-NEXT:    call callee_large_scalars_exhausted_regs
; ILP32E-WITHFP-NEXT:    addi sp, s0, -64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-WITHFP-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 64
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_large_scalars_exhausted_regs:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -56
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a4, sp, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a5, 9
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi a6, sp, 40
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a7, 7
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui t0, 524272
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li t1, 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a7, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a6, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a5, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 5
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 16(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 20(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 24(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t0, 28(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a5, 6
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw t1, 40(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 44(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 48(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 52(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_large_scalars_exhausted_regs
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 56
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_large_scalars_exhausted_regs:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -56
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a4, sp, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a5, 9
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a6, sp, 40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a7, 7
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui t0, 524272
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li t1, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a7, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a6, 4(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a5, 8(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a4, 12(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 5
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 16(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 20(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 24(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t0, 28(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a5, 6
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw t1, 40(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 44(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 48(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 52(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_large_scalars_exhausted_regs
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 64
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 56
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_large_scalars_exhausted_regs(
      i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i128 8, i32 9,
      fp128 0xL00000000000000007FFF000000000000)
  ret i32 %1
}

; Ensure that libcalls generated in the middle-end obey the calling convention

define i32 @caller_mixed_scalar_libcalls(i64 %a) {
; ILP32E-FPELIM-LABEL: caller_mixed_scalar_libcalls:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-FPELIM-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -8
; ILP32E-FPELIM-NEXT:    mv a2, a1
; ILP32E-FPELIM-NEXT:    mv a1, a0
; ILP32E-FPELIM-NEXT:    mv a0, sp
; ILP32E-FPELIM-NEXT:    call __floatditf
; ILP32E-FPELIM-NEXT:    lw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    addi sp, s0, -24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-FPELIM-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_mixed_scalar_libcalls:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -8
; ILP32E-WITHFP-NEXT:    mv a2, a1
; ILP32E-WITHFP-NEXT:    mv a1, a0
; ILP32E-WITHFP-NEXT:    mv a0, sp
; ILP32E-WITHFP-NEXT:    call __floatditf
; ILP32E-WITHFP-NEXT:    lw a0, 0(sp)
; ILP32E-WITHFP-NEXT:    addi sp, s0, -24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_mixed_scalar_libcalls:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a2, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a1, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call __floatditf
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_mixed_scalar_libcalls:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a2, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call __floatditf
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = sitofp i64 %a to fp128
  %2 = bitcast fp128 %1 to i128
  %3 = trunc i128 %2 to i32
  ret i32 %3
}


; Check passing of coerced integer arrays

%struct.small = type { i32, ptr }

define i32 @callee_small_coerced_struct([2 x i32] %a.coerce) {
; ILP32E-FPELIM-LABEL: callee_small_coerced_struct:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    xor a0, a0, a1
; ILP32E-FPELIM-NEXT:    seqz a0, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_small_coerced_struct:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    xor a0, a0, a1
; ILP32E-WITHFP-NEXT:    seqz a0, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_small_coerced_struct:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    xor a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_small_coerced_struct:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    xor a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    seqz a0, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = extractvalue [2 x i32] %a.coerce, 0
  %2 = extractvalue [2 x i32] %a.coerce, 1
  %3 = icmp eq i32 %1, %2
  %4 = zext i1 %3 to i32
  ret i32 %4
}

define i32 @caller_small_coerced_struct() {
; ILP32E-FPELIM-LABEL: caller_small_coerced_struct:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 2
; ILP32E-FPELIM-NEXT:    call callee_small_coerced_struct
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_small_coerced_struct:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 2
; ILP32E-WITHFP-NEXT:    call callee_small_coerced_struct
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_small_coerced_struct:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_small_coerced_struct
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_small_coerced_struct:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_small_coerced_struct
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call i32 @callee_small_coerced_struct([2 x i32] [i32 1, i32 2])
  ret i32 %1
}

; Check large struct arguments, which are passed byval

%struct.large = type { i32, i32, i32, i32 }

define i32 @callee_large_struct(ptr byval(%struct.large) align 4 %a) {
; ILP32E-FPELIM-LABEL: callee_large_struct:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lw a1, 0(a0)
; ILP32E-FPELIM-NEXT:    lw a0, 12(a0)
; ILP32E-FPELIM-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_large_struct:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lw a1, 0(a0)
; ILP32E-WITHFP-NEXT:    lw a0, 12(a0)
; ILP32E-WITHFP-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_large_struct:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 0(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 12(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_large_struct:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 0(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 12(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a1, a0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = getelementptr inbounds %struct.large, ptr %a, i32 0, i32 0
  %2 = getelementptr inbounds %struct.large, ptr %a, i32 0, i32 3
  %3 = load i32, ptr %1
  %4 = load i32, ptr %2
  %5 = add i32 %3, %4
  ret i32 %5
}

define i32 @caller_large_struct() {
; ILP32E-FPELIM-LABEL: caller_large_struct:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -36
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 36
; ILP32E-FPELIM-NEXT:    sw ra, 32(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 2
; ILP32E-FPELIM-NEXT:    li a2, 3
; ILP32E-FPELIM-NEXT:    li a3, 4
; ILP32E-FPELIM-NEXT:    sw a0, 16(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 20(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 24(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 28(sp)
; ILP32E-FPELIM-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    sw a1, 4(sp)
; ILP32E-FPELIM-NEXT:    sw a2, 8(sp)
; ILP32E-FPELIM-NEXT:    sw a3, 12(sp)
; ILP32E-FPELIM-NEXT:    mv a0, sp
; ILP32E-FPELIM-NEXT:    call callee_large_struct
; ILP32E-FPELIM-NEXT:    lw ra, 32(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 36
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_large_struct:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -40
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 40
; ILP32E-WITHFP-NEXT:    sw ra, 36(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 32(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 40
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 2
; ILP32E-WITHFP-NEXT:    li a2, 3
; ILP32E-WITHFP-NEXT:    li a3, 4
; ILP32E-WITHFP-NEXT:    sw a0, -24(s0)
; ILP32E-WITHFP-NEXT:    sw a1, -20(s0)
; ILP32E-WITHFP-NEXT:    sw a2, -16(s0)
; ILP32E-WITHFP-NEXT:    sw a3, -12(s0)
; ILP32E-WITHFP-NEXT:    sw a0, -40(s0)
; ILP32E-WITHFP-NEXT:    sw a1, -36(s0)
; ILP32E-WITHFP-NEXT:    sw a2, -32(s0)
; ILP32E-WITHFP-NEXT:    sw a3, -28(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, -40
; ILP32E-WITHFP-NEXT:    call callee_large_struct
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 40
; ILP32E-WITHFP-NEXT:    lw ra, 36(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 32(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 40
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_large_struct:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 36
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a0, 16(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 20(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a2, 24(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a3, 28(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a0, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 4(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a2, 8(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a3, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_large_struct
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_large_struct:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a0, -24(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, -20(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a2, -16(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a3, -12(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a0, -40(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, -36(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a2, -32(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a3, -28(s0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi a0, s0, -40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_large_struct
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 40
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %ls = alloca %struct.large, align 4
  %1 = bitcast ptr %ls to ptr
  %a = getelementptr inbounds %struct.large, ptr %ls, i32 0, i32 0
  store i32 1, ptr %a
  %b = getelementptr inbounds %struct.large, ptr %ls, i32 0, i32 1
  store i32 2, ptr %b
  %c = getelementptr inbounds %struct.large, ptr %ls, i32 0, i32 2
  store i32 3, ptr %c
  %d = getelementptr inbounds %struct.large, ptr %ls, i32 0, i32 3
  store i32 4, ptr %d
  %2 = call i32 @callee_large_struct(ptr byval(%struct.large) align 4 %ls)
  ret i32 %2
}

; Check return of 2x xlen structs

define %struct.small @callee_small_struct_ret() {
; ILP32E-FPELIM-LABEL: callee_small_struct_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    li a0, 1
; ILP32E-FPELIM-NEXT:    li a1, 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_small_struct_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_small_struct_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_small_struct_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a0, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  ret %struct.small { i32 1, ptr null }
}

define i32 @caller_small_struct_ret() {
; ILP32E-FPELIM-LABEL: caller_small_struct_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    call callee_small_struct_ret
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    addi sp, sp, 4
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_small_struct_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    call callee_small_struct_ret
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_small_struct_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_small_struct_ret
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_0
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_small_struct_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_small_struct_ret
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call %struct.small @callee_small_struct_ret()
  %2 = extractvalue %struct.small %1, 0
  %3 = extractvalue %struct.small %1, 1
  %4 = ptrtoint ptr %3 to i32
  %5 = add i32 %2, %4
  ret i32 %5
}

; Check return of >2x xlen scalars

define fp128 @callee_large_scalar_ret() {
; ILP32E-FPELIM-LABEL: callee_large_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    lui a1, 524272
; ILP32E-FPELIM-NEXT:    sw zero, 0(a0)
; ILP32E-FPELIM-NEXT:    sw zero, 4(a0)
; ILP32E-FPELIM-NEXT:    sw zero, 8(a0)
; ILP32E-FPELIM-NEXT:    sw a1, 12(a0)
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_large_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    lui a1, 524272
; ILP32E-WITHFP-NEXT:    sw zero, 0(a0)
; ILP32E-WITHFP-NEXT:    sw zero, 4(a0)
; ILP32E-WITHFP-NEXT:    sw zero, 8(a0)
; ILP32E-WITHFP-NEXT:    sw a1, 12(a0)
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_large_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lui a1, 524272
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 0(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 4(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw zero, 8(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 12(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_large_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lui a1, 524272
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 0(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 4(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw zero, 8(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, 12(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  ret fp128 0xL00000000000000007FFF000000000000
}

define void @caller_large_scalar_ret() {
; ILP32E-FPELIM-LABEL: caller_large_scalar_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -32
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 32
; ILP32E-FPELIM-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 32
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-NEXT:    mv a0, sp
; ILP32E-FPELIM-NEXT:    call callee_large_scalar_ret
; ILP32E-FPELIM-NEXT:    addi sp, s0, -32
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 32
; ILP32E-FPELIM-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 32
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_large_scalar_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -32
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 32
; ILP32E-WITHFP-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 32
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-NEXT:    mv a0, sp
; ILP32E-WITHFP-NEXT:    call callee_large_scalar_ret
; ILP32E-WITHFP-NEXT:    addi sp, s0, -32
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 32
; ILP32E-WITHFP-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 32
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_large_scalar_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_large_scalar_ret
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 32
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_large_scalar_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_large_scalar_ret
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 32
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = call fp128 @callee_large_scalar_ret()
  ret void
}

; Check return of >2x xlen structs

define void @callee_large_struct_ret(ptr noalias sret(%struct.large) %agg.result) {
; ILP32E-FPELIM-LABEL: callee_large_struct_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    li a1, 1
; ILP32E-FPELIM-NEXT:    li a2, 2
; ILP32E-FPELIM-NEXT:    li a3, 3
; ILP32E-FPELIM-NEXT:    li a4, 4
; ILP32E-FPELIM-NEXT:    sw a1, 0(a0)
; ILP32E-FPELIM-NEXT:    sw a2, 4(a0)
; ILP32E-FPELIM-NEXT:    sw a3, 8(a0)
; ILP32E-FPELIM-NEXT:    sw a4, 12(a0)
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: callee_large_struct_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    li a1, 1
; ILP32E-WITHFP-NEXT:    li a2, 2
; ILP32E-WITHFP-NEXT:    li a3, 3
; ILP32E-WITHFP-NEXT:    li a4, 4
; ILP32E-WITHFP-NEXT:    sw a1, 0(a0)
; ILP32E-WITHFP-NEXT:    sw a2, 4(a0)
; ILP32E-WITHFP-NEXT:    sw a3, 8(a0)
; ILP32E-WITHFP-NEXT:    sw a4, 12(a0)
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 8
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: callee_large_struct_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a1, 1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a2, 2
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a3, 3
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    li a4, 4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a1, 0(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a2, 4(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a3, 8(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    sw a4, 12(a0)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    ret
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: callee_large_struct_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a1, 1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a2, 2
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a3, 3
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    li a4, 4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a1, 0(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a2, 4(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a3, 8(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    sw a4, 12(a0)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %a = getelementptr inbounds %struct.large, ptr %agg.result, i32 0, i32 0
  store i32 1, ptr %a, align 4
  %b = getelementptr inbounds %struct.large, ptr %agg.result, i32 0, i32 1
  store i32 2, ptr %b, align 4
  %c = getelementptr inbounds %struct.large, ptr %agg.result, i32 0, i32 2
  store i32 3, ptr %c, align 4
  %d = getelementptr inbounds %struct.large, ptr %agg.result, i32 0, i32 3
  store i32 4, ptr %d, align 4
  ret void
}

define i32 @caller_large_struct_ret() {
; ILP32E-FPELIM-LABEL: caller_large_struct_ret:
; ILP32E-FPELIM:       # %bb.0:
; ILP32E-FPELIM-NEXT:    addi sp, sp, -24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-FPELIM-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32E-FPELIM-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-NEXT:    addi s0, sp, 24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-NEXT:    andi sp, sp, -8
; ILP32E-FPELIM-NEXT:    mv a0, sp
; ILP32E-FPELIM-NEXT:    call callee_large_struct_ret
; ILP32E-FPELIM-NEXT:    lw a0, 0(sp)
; ILP32E-FPELIM-NEXT:    lw a1, 12(sp)
; ILP32E-FPELIM-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-NEXT:    addi sp, s0, -24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-FPELIM-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32E-FPELIM-NEXT:    .cfi_restore ra
; ILP32E-FPELIM-NEXT:    .cfi_restore s0
; ILP32E-FPELIM-NEXT:    addi sp, sp, 24
; ILP32E-FPELIM-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-FPELIM-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller_large_struct_ret:
; ILP32E-WITHFP:       # %bb.0:
; ILP32E-WITHFP-NEXT:    addi sp, sp, -24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-NEXT:    sw ra, 20(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 16(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    andi sp, sp, -8
; ILP32E-WITHFP-NEXT:    mv a0, sp
; ILP32E-WITHFP-NEXT:    call callee_large_struct_ret
; ILP32E-WITHFP-NEXT:    lw a0, 0(sp)
; ILP32E-WITHFP-NEXT:    lw a1, 12(sp)
; ILP32E-WITHFP-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-NEXT:    addi sp, s0, -24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-NEXT:    lw ra, 20(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 16(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    .cfi_restore ra
; ILP32E-WITHFP-NEXT:    .cfi_restore s0
; ILP32E-WITHFP-NEXT:    addi sp, sp, 24
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 0
; ILP32E-WITHFP-NEXT:    ret
;
; ILP32E-FPELIM-SAVE-RESTORE-LABEL: caller_large_struct_ret:
; ILP32E-FPELIM-SAVE-RESTORE:       # %bb.0:
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi s0, sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    andi sp, sp, -8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    call callee_large_struct_ret
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a0, 0(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    lw a1, 12(sp)
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, s0, -24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-FPELIM-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
;
; ILP32E-WITHFP-SAVE-RESTORE-LABEL: caller_large_struct_ret:
; ILP32E-WITHFP-SAVE-RESTORE:       # %bb.0:
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call t0, __riscv_save_1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, -16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi s0, sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    andi sp, sp, -8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    mv a0, sp
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    call callee_large_struct_ret
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a0, 0(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    lw a1, 12(sp)
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    add a0, a0, a1
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, s0, -24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa sp, 24
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    addi sp, sp, 16
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-WITHFP-SAVE-RESTORE-NEXT:    tail __riscv_restore_1
  %1 = alloca %struct.large
  call void @callee_large_struct_ret(ptr sret(%struct.large) %1)
  %2 = getelementptr inbounds %struct.large, ptr %1, i32 0, i32 0
  %3 = load i32, ptr %2
  %4 = getelementptr inbounds %struct.large, ptr %1, i32 0, i32 3
  %5 = load i32, ptr %4
  %6 = add i32 %3, %5
  ret i32 %6
}
