; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=gvn < %s | FileCheck %s

declare i32 @setjmp() returns_twice
declare void @longjmp()
declare ptr @malloc(i64)

define i32 @test() {
; CHECK-LABEL: define i32 @test() {
; CHECK-NEXT:    [[MALLOC:%.*]] = call noalias ptr @malloc(i64 4)
; CHECK-NEXT:    store i32 10, ptr [[MALLOC]], align 4
; CHECK-NEXT:    [[SJ:%.*]] = call i32 @setjmp()
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SJ]], 0
; CHECK-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    store i32 20, ptr [[MALLOC]], align 4
; CHECK-NEXT:    call void @longjmp()
; CHECK-NEXT:    unreachable
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    [[RES:%.*]] = load i32, ptr [[MALLOC]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
  %malloc = call noalias ptr @malloc(i64 4)
  store i32 10, ptr %malloc, align 4
  %sj = call i32 @setjmp()
  %cmp = icmp eq i32 %sj, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 20, ptr %malloc
  call void @longjmp()
  unreachable

if.end:
  %res = load i32, ptr %malloc
  ret i32 %res
}

; We are still allowed to optimize non-volatile accesses to allocas.
define i32 @test_alloca() {
; CHECK-LABEL: define i32 @test_alloca() {
; CHECK-NEXT:    [[ALLOC:%.*]] = alloca i43, align 8
; CHECK-NEXT:    store i32 10, ptr [[ALLOC]], align 4
; CHECK-NEXT:    [[SJ:%.*]] = call i32 @setjmp()
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SJ]], 0
; CHECK-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    store i32 20, ptr [[ALLOC]], align 4
; CHECK-NEXT:    call void @longjmp()
; CHECK-NEXT:    unreachable
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    ret i32 10
;
  %alloc = alloca i43
  store i32 10, ptr %alloc, align 4
  %sj = call i32 @setjmp()
  %cmp = icmp eq i32 %sj, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store i32 20, ptr %alloc
  call void @longjmp()
  unreachable

if.end:
  %res = load i32, ptr %alloc
  ret i32 %res
}

define i32 @test_alloca_volatile() {
; CHECK-LABEL: define i32 @test_alloca_volatile() {
; CHECK-NEXT:    [[ALLOC:%.*]] = alloca i43, align 8
; CHECK-NEXT:    store volatile i32 10, ptr [[ALLOC]], align 4
; CHECK-NEXT:    [[SJ:%.*]] = call i32 @setjmp()
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SJ]], 0
; CHECK-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    store volatile i32 20, ptr [[ALLOC]], align 4
; CHECK-NEXT:    call void @longjmp()
; CHECK-NEXT:    unreachable
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    [[RES:%.*]] = load volatile i32, ptr [[ALLOC]], align 4
; CHECK-NEXT:    ret i32 [[RES]]
;
  %alloc = alloca i43
  store volatile i32 10, ptr %alloc, align 4
  %sj = call i32 @setjmp()
  %cmp = icmp eq i32 %sj, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:
  store volatile i32 20, ptr %alloc
  call void @longjmp()
  unreachable

if.end:
  %res = load volatile i32, ptr %alloc
  ret i32 %res
}
