; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f           | FileCheck %s --check-prefixes=AVX512F
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW

; PR34666
define <64 x i8> @add_v64i8_broadcasts(<64 x i8> %a0, i64 %a1, i8 %a2) {
; AVX512F-LABEL: add_v64i8_broadcasts:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq %rdi, %rax
; AVX512F-NEXT:    movl %edi, %ecx
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    shrq $32, %rdi
; AVX512F-NEXT:    shrq $48, %rax
; AVX512F-NEXT:    shrl $16, %ecx
; AVX512F-NEXT:    vmovd %esi, %xmm1
; AVX512F-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm1, %zmm1
; AVX512F-NEXT:    kmovw %ecx, %k2
; AVX512F-NEXT:    kmovw %eax, %k3
; AVX512F-NEXT:    kmovw %edi, %k4
; AVX512F-NEXT:    vpternlogd $255, %zmm2, %zmm2, %zmm2 {%k4} {z}
; AVX512F-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512F-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k3} {z}
; AVX512F-NEXT:    vpmovdb %zmm3, %xmm3
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpternlogd $255, %zmm3, %zmm3, %zmm3 {%k1} {z}
; AVX512F-NEXT:    vpmovdb %zmm3, %xmm3
; AVX512F-NEXT:    vpternlogd $255, %zmm4, %zmm4, %zmm4 {%k2} {z}
; AVX512F-NEXT:    vpmovdb %zmm4, %xmm4
; AVX512F-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512F-NEXT:    vpternlogq $216, %zmm2, %zmm1, %zmm0
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpaddb %ymm1, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm4
; AVX512F-NEXT:    vpaddb %ymm1, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    vpternlogq $226, %zmm4, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: add_v64i8_broadcasts:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %esi, %zmm1
; AVX512BW-NEXT:    kmovq %rdi, %k1
; AVX512BW-NEXT:    vpbroadcastb %esi, %zmm0 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    retq
  %v = insertelement <64 x i8> undef, i8 %a2, i64 0
  %broadcast = shufflevector <64 x i8> %v, <64 x i8> poison, <64 x i32> zeroinitializer
  %mask = bitcast i64 %a1 to <64 x i1>
  %broadcast_mask = select <64 x i1> %mask, <64 x i8> %broadcast, <64 x i8> %a0
  %broadcast_maskz = select <64 x i1> %mask, <64 x i8> %broadcast, <64 x i8> zeroinitializer
  %add0 = add <64 x i8> %broadcast_mask, %broadcast
  %add1 = add <64 x i8> %add0, %broadcast_maskz
  ret <64 x i8> %add1
}
