; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -global-isel < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV64I %s
; RUN: llc -mtriple=riscv64 -global-isel -mattr=+d < %s \
; RUN:   | FileCheck -check-prefixes=CHECK,RV64D %s

; FIXME: Support RV32.

define fp128 @fadd(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: fadd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __addtf3
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
 %a = fadd fp128 %x, %y
  ret fp128 %a
}

define fp128 @fsub(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: fsub:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __subtf3
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fsub fp128 %x, %y
  ret fp128 %a
}

define fp128 @fmul(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: fmul:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __multf3
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fmul fp128 %x, %y
  ret fp128 %a
}

define fp128 @fdiv(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: fdiv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __divtf3
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fdiv fp128 %x, %y
  ret fp128 %a
}

define fp128 @frem(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: frem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call fmodl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = frem fp128 %x, %y
  ret fp128 %a
}

define fp128 @fma(fp128 %x, fp128 %y, fp128 %z) nounwind {
; CHECK-LABEL: fma:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call fmal
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = call fp128 @llvm.fma.f128(fp128 %x, fp128 %y, fp128 %z)
  ret fp128 %a
}

define fp128 @fneg(fp128 %x) {
; CHECK-LABEL: fneg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, -1
; CHECK-NEXT:    slli a2, a2, 63
; CHECK-NEXT:    xor a1, a1, a2
; CHECK-NEXT:    ret
  %a = fneg fp128 %x
  ret fp128 %a
}

define fp128 @fabs(fp128 %x) {
; CHECK-LABEL: fabs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    srli a1, a1, 1
; CHECK-NEXT:    ret
  %a = call fp128 @llvm.fabs.f128(fp128 %x)
  ret fp128 %a
}

define fp128 @fcopysign(fp128 %x, fp128 %y) {
; CHECK-LABEL: fcopysign:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    srli a3, a3, 63
; CHECK-NEXT:    srli a1, a1, 1
; CHECK-NEXT:    slli a3, a3, 63
; CHECK-NEXT:    or a1, a1, a3
; CHECK-NEXT:    ret
  %a = call fp128 @llvm.copysign.f128(fp128 %x, fp128 %y)
  ret fp128 %a
}

define i1 @fcmp(fp128 %x, fp128 %y) nounwind {
; CHECK-LABEL: fcmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __eqtf2
; CHECK-NEXT:    sext.w a0, a0
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fcmp oeq fp128 %x, %y
  ret i1 %a
}

define fp128 @constant(fp128 %x) nounwind {
; CHECK-LABEL: constant:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    lui a2, %hi(.LCPI10_0)
; CHECK-NEXT:    addi a3, a2, %lo(.LCPI10_0)
; CHECK-NEXT:    ld a2, 0(a3)
; CHECK-NEXT:    ld a3, 8(a3)
; CHECK-NEXT:    call __addtf3
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fadd fp128 %x, 0xL00000000000000007FFF000000000000
  ret fp128 %a
}

define fp128 @fpext_f32(float %x, float %y) nounwind {
; RV64I-LABEL: fpext_f32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    call __extendsftf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64D-LABEL: fpext_f32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    addi sp, sp, -16
; RV64D-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fadd.s fa0, fa0, fa1
; RV64D-NEXT:    call __extendsftf2
; RV64D-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64D-NEXT:    addi sp, sp, 16
; RV64D-NEXT:    ret
  %a = fadd float %x, %y
  %b = fpext float %a to fp128
  ret fp128 %b
}

define fp128 @fpext_f64(double %x, double %y) nounwind {
; RV64I-LABEL: fpext_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __adddf3
; RV64I-NEXT:    call __extenddftf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64D-LABEL: fpext_f64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    addi sp, sp, -16
; RV64D-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fadd.d fa0, fa0, fa1
; RV64D-NEXT:    call __extenddftf2
; RV64D-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64D-NEXT:    addi sp, sp, 16
; RV64D-NEXT:    ret
  %a = fadd double %x, %y
  %b = fpext double %a to fp128
  ret fp128 %b
}

define float @fptrunc_f32(fp128 %x, float %y) nounwind {
; RV64I-LABEL: fptrunc_f32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    call __trunctfsf2
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __addsf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64D-LABEL: fptrunc_f32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    addi sp, sp, -16
; RV64D-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fmv.s fs0, fa0
; RV64D-NEXT:    call __trunctfsf2
; RV64D-NEXT:    fadd.s fa0, fa0, fs0
; RV64D-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64D-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; RV64D-NEXT:    addi sp, sp, 16
; RV64D-NEXT:    ret
  %a = fptrunc fp128 %x to float
  %b = fadd float %a, %y
  ret float %b
}

define double @fptrunc_f64(fp128 %x, double %y) nounwind {
; RV64I-LABEL: fptrunc_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    call __trunctfdf2
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __adddf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64D-LABEL: fptrunc_f64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    addi sp, sp, -16
; RV64D-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; RV64D-NEXT:    fmv.d fs0, fa0
; RV64D-NEXT:    call __trunctfdf2
; RV64D-NEXT:    fadd.d fa0, fa0, fs0
; RV64D-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64D-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; RV64D-NEXT:    addi sp, sp, 16
; RV64D-NEXT:    ret
  %a = fptrunc fp128 %x to double
  %b = fadd double %a, %y
  ret double %b
}

define i8 @fptosi_i8(fp128 %x) nounwind {
; CHECK-LABEL: fptosi_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixtfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptosi fp128 %x to i8
  ret i8 %a
}

define i16 @fptosi_i16(fp128 %x) nounwind {
; CHECK-LABEL: fptosi_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixtfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptosi fp128 %x to i16
  ret i16 %a
}

define i32 @fptosi_i32(fp128 %x) nounwind {
; CHECK-LABEL: fptosi_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixtfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptosi fp128 %x to i32
  ret i32 %a
}

define i64 @fptosi_i64(fp128 %x) nounwind {
; CHECK-LABEL: fptosi_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixtfdi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptosi fp128 %x to i64
  ret i64 %a
}

define i128 @fptosi_i128(fp128 %x) nounwind {
; CHECK-LABEL: fptosi_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixtfti
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptosi fp128 %x to i128
  ret i128 %a
}

define i8 @fptoui_i8(fp128 %x) nounwind {
; CHECK-LABEL: fptoui_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunstfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptoui fp128 %x to i8
  ret i8 %a
}

define i16 @fptoui_i16(fp128 %x) nounwind {
; CHECK-LABEL: fptoui_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunstfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptoui fp128 %x to i16
  ret i16 %a
}

define i32 @fptoui_i32(fp128 %x) nounwind {
; CHECK-LABEL: fptoui_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunstfsi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptoui fp128 %x to i32
  ret i32 %a
}

define i64 @fptoui_i64(fp128 %x) nounwind {
; CHECK-LABEL: fptoui_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunstfdi
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptoui fp128 %x to i64
  ret i64 %a
}

define i128 @fptoui_i128(fp128 %x) nounwind {
; CHECK-LABEL: fptoui_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunstfti
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = fptoui fp128 %x to i128
  ret i128 %a
}

define fp128 @sitofp_i8(i8 %x) nounwind {
; CHECK-LABEL: sitofp_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    slli a0, a0, 56
; CHECK-NEXT:    srai a0, a0, 56
; CHECK-NEXT:    call __floatsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = sitofp i8 %x to fp128
  ret fp128 %a
}

define fp128 @sitofp_i16(i16 %x) nounwind {
; CHECK-LABEL: sitofp_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    slli a0, a0, 48
; CHECK-NEXT:    srai a0, a0, 48
; CHECK-NEXT:    call __floatsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = sitofp i16 %x to fp128
  ret fp128 %a
}

define fp128 @sitofp_i32(i32 %x) nounwind {
; CHECK-LABEL: sitofp_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sext.w a0, a0
; CHECK-NEXT:    call __floatsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = sitofp i32 %x to fp128
  ret fp128 %a
}

define fp128 @sitofp_i64(i64 %x) nounwind {
; CHECK-LABEL: sitofp_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floatditf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = sitofp i64 %x to fp128
  ret fp128 %a
}

define fp128 @sitofp_i128(i128 %x) nounwind {
; CHECK-LABEL: sitofp_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floattitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = sitofp i128 %x to fp128
  ret fp128 %a
}

define fp128 @uitofp_i8(i8 %x) nounwind {
; CHECK-LABEL: uitofp_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    andi a0, a0, 255
; CHECK-NEXT:    call __floatunsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = uitofp i8 %x to fp128
  ret fp128 %a
}

define fp128 @uitofp_i16(i16 %x) nounwind {
; CHECK-LABEL: uitofp_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    slli a0, a0, 48
; CHECK-NEXT:    srli a0, a0, 48
; CHECK-NEXT:    call __floatunsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = uitofp i16 %x to fp128
  ret fp128 %a
}

define fp128 @uitofp_i32(i32 %x) nounwind {
; CHECK-LABEL: uitofp_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sext.w a0, a0
; CHECK-NEXT:    call __floatunsitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = uitofp i32 %x to fp128
  ret fp128 %a
}

define fp128 @uitofp_i64(i64 %x) nounwind {
; CHECK-LABEL: uitofp_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floatunditf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = uitofp i64 %x to fp128
  ret fp128 %a
}

define fp128 @uitofp_i128(i128 %x) nounwind {
; CHECK-LABEL: uitofp_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floatuntitf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %a = uitofp i128 %x to fp128
  ret fp128 %a
}

define fp128 @sqrt(fp128 %a) nounwind {
; CHECK-LABEL: sqrt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call sqrtl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.sqrt.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @powi(fp128 %a, i32 %b) nounwind {
; CHECK-LABEL: powi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sext.w a2, a2
; CHECK-NEXT:    call __powitf2
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.powi.f128.i32(fp128 %a, i32 %b)
  ret fp128 %1
}

define fp128 @sin(fp128 %a) nounwind {
; CHECK-LABEL: sin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call sinl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.sin.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @cos(fp128 %a) nounwind {
; CHECK-LABEL: cos:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call cosl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.cos.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @pow(fp128 %a, fp128 %b) nounwind {
; CHECK-LABEL: pow:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call powl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.pow.f128(fp128 %a, fp128 %b)
  ret fp128 %1
}

define fp128 @exp(fp128 %a) nounwind {
; CHECK-LABEL: exp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call expl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.exp.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @exp2(fp128 %a) nounwind {
; CHECK-LABEL: exp2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call exp2l
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.exp2.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @exp10(fp128 %a) nounwind {
; CHECK-LABEL: exp10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call exp10l
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.exp10.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @log(fp128 %a) nounwind {
; CHECK-LABEL: log:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call logl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.log.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @log10(fp128 %a) nounwind {
; CHECK-LABEL: log10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call log10l
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.log10.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @log2(fp128 %a) nounwind {
; CHECK-LABEL: log2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call log2l
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.log2.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @minnum(fp128 %a, fp128 %b) nounwind {
; CHECK-LABEL: minnum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call fminl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.minnum.f128(fp128 %a, fp128 %b)
  ret fp128 %1
}

define fp128 @maxnum(fp128 %a, fp128 %b) nounwind {
; CHECK-LABEL: maxnum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call fmaxl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.maxnum.f128(fp128 %a, fp128 %b)
  ret fp128 %1
}

define fp128 @floor(fp128 %a) nounwind {
; CHECK-LABEL: floor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call floorl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.floor.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @ceil(fp128 %a) nounwind {
; CHECK-LABEL: ceil:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call ceill
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.ceil.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @trunc(fp128 %a) nounwind {
; CHECK-LABEL: trunc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call truncl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.trunc.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @rint(fp128 %a) nounwind {
; CHECK-LABEL: rint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call rintl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.rint.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @nearbyint(fp128 %a) nounwind {
; CHECK-LABEL: nearbyint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call nearbyintl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.nearbyint.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @round(fp128 %a) nounwind {
; CHECK-LABEL: round:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call roundl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.round.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @roundeven(fp128 %a) nounwind {
; CHECK-LABEL: roundeven:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call roundevenl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.roundeven.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @tan(fp128 %a) nounwind {
; CHECK-LABEL: tan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call tanl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.tan.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @ldexp_fp128(fp128 %x, i32 %y) nounwind {
; CHECK-LABEL: ldexp_fp128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sext.w a2, a2
; CHECK-NEXT:    call ldexpl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %z = call fp128 @llvm.ldexp.f128.i32(fp128 %x, i32 %y)
  ret fp128 %z
}

define fp128 @asin(fp128 %a) nounwind {
; CHECK-LABEL: asin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call asinl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.asin.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @acos(fp128 %a) nounwind {
; CHECK-LABEL: acos:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call acosl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.acos.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @atan(fp128 %a) nounwind {
; CHECK-LABEL: atan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call atanl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.atan.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @atan2(fp128 %a, fp128 %b) nounwind {
; CHECK-LABEL: atan2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call atan2l
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.atan2.f128(fp128 %a, fp128 %b)
  ret fp128 %1
}

define fp128 @sinh(fp128 %a) nounwind {
; CHECK-LABEL: sinh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call sinhl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.sinh.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @cosh(fp128 %a) nounwind {
; CHECK-LABEL: cosh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call coshl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.cosh.f128(fp128 %a)
  ret fp128 %1
}

define fp128 @tanh(fp128 %a) nounwind {
; CHECK-LABEL: tanh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call tanhl
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = call fp128 @llvm.tanh.f128(fp128 %a)
  ret fp128 %1
}
