; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx703 < %s | FileCheck -check-prefixes=GCN,GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 < %s | FileCheck -check-prefixes=GCN,GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx950 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX950 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GCN,GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 < %s | FileCheck -check-prefixes=GCN,GFX12 %s

define half @v_maximum_f16(half %src0, half %src1) {
; GFX7-LABEL: v_maximum_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define half @v_maximum_f16__nnan(half %src0, half %src1) {
; GFX7-LABEL: v_maximum_f16__nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16__nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16__nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16__nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16__nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16__nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16__nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define half @v_maximum_f16__nsz(half %src0, half %src1) {
; GFX7-LABEL: v_maximum_f16__nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16__nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16__nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16__nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16__nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16__nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16__nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nsz half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define half @v_maximum_f16__nnan_nsz(half %src0, half %src1) {
; GFX7-LABEL: v_maximum_f16__nnan_nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16__nnan_nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16__nnan_nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16__nnan_nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16__nnan_nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16__nnan_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16__nnan_nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan nsz half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define half @v_maximum_f16__nnan_src0(half %arg0, half %src1) {
; GFX7-LABEL: v_maximum_f16__nnan_src0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16__nnan_src0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16__nnan_src0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX900-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16__nnan_src0:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16__nnan_src0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX10-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16__nnan_src0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16__nnan_src0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %src0 = fadd nnan half %arg0, 1.0
  %op = call half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define half @v_maximum_f16__nnan_src1(half %src0, half %arg1) {
; GFX7-LABEL: v_maximum_f16__nnan_src1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_max_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_f16__nnan_src1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_f16__nnan_src1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX900-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_f16__nnan_src1:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_f16__nnan_src1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX10-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_f16__nnan_src1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_max_f16_e32 v2, v0, v1
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_f16__nnan_src1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v1, 1.0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %src1 = fadd nnan half %arg1, 1.0
  %op = call half @llvm.maximum.f16(half %src0, half %src1)
  ret half %op
}

define void @s_maximum_f16(half inreg %src0, half inreg %src1) {
; GFX7-LABEL: s_maximum_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, s17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, s16
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_f32_e32 v3, v1, v0
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: s_maximum_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s17
; GFX8-NEXT:    v_max_f16_e32 v1, s16, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, s16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: s_maximum_f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, s17
; GFX900-NEXT:    v_max_f16_e32 v1, s16, v0
; GFX900-NEXT:    v_mov_b32_e32 v2, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, s16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX900-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use v0
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: s_maximum_f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_mov_b32_e32 v0, s0
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, s1, s1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX950-NEXT:    ;;#ASMSTART
; GFX950-NEXT:    ; use v0
; GFX950-NEXT:    ;;#ASMEND
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: s_maximum_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v0, s16, s17
; GFX10-NEXT:    v_cmp_o_f16_e64 vcc_lo, s16, s17
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v0, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use v0
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: s_maximum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, s0, s1
; GFX11-NEXT:    v_cmp_o_f16_e64 vcc_lo, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v0, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use v0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: s_maximum_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_maximum_f16 s0, s0, s1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_2)
; GFX12-NEXT:    s_and_b32 s0, 0xffff, s0
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; use s0
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call half @llvm.maximum.f16(half %src0, half %src1)
  %cast = bitcast half %op to i16
  %zext = zext i16 %cast to i32
  call void asm sideeffect "; use $0", "s"(i32 %zext)
  ret void
}

define <2 x half> @v_maximum_v2f16(<2 x half> %src0, <2 x half> %src1) {
; GFX7-LABEL: v_maximum_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX7-NEXT:    v_max_f32_e32 v4, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v2, v1, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v2, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v4, v3, v2
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v5, v4, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v2f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v2, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v1 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v2f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v1 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v3, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v0, v2, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <2 x half> @llvm.maximum.v2f16(<2 x half> %src0, <2 x half> %src1)
  ret <2 x half> %op
}

define <2 x half> @v_maximum_v2f16__nnan(<2 x half> %src0, <2 x half> %src1) {
; GFX7-LABEL: v_maximum_v2f16__nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v2f16__nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v2f16__nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v2f16__nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v2f16__nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v2f16__nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v2f16__nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan <2 x half> @llvm.maximum.v2f16(<2 x half> %src0, <2 x half> %src1)
  ret <2 x half> %op
}

define <2 x half> @v_maximum_v2f16__nsz(<2 x half> %src0, <2 x half> %src1) {
; GFX7-LABEL: v_maximum_v2f16__nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX7-NEXT:    v_max_f32_e32 v4, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v2, v1, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v2, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v2f16__nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v4, v3, v2
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v5, v4, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v2f16__nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v2, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v1 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v2f16__nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v2f16__nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v1 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v3, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v0, v2, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v2f16__nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v5, vcc_lo
; GFX11-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v2f16__nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nsz <2 x half> @llvm.maximum.v2f16(<2 x half> %src0, <2 x half> %src1)
  ret <2 x half> %op
}

define <2 x half> @v_maximum_v2f16__nnan_nsz(<2 x half> %src0, <2 x half> %src1) {
; GFX7-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v1, v1
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v2f16__nnan_nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan nsz <2 x half> @llvm.maximum.v2f16(<2 x half> %src0, <2 x half> %src1)
  ret <2 x half> %op
}

define void @s_maximum_v2f16(<2 x half> inreg %src0, <2 x half> inreg %src1) {
; GFX7-LABEL: s_maximum_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, s19
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, s17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, s18
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, s16
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX7-NEXT:    v_max_f32_e32 v4, v1, v0
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v1, v3, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v3, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    ;;#ASMSTART
; GFX7-NEXT:    ; use v0
; GFX7-NEXT:    ;;#ASMEND
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: s_maximum_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s4, s17, 16
; GFX8-NEXT:    s_lshr_b32 s5, s16, 16
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_max_f16_e32 v1, s5, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, s5, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    v_max_f16_e32 v3, s16, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, s16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; use v0
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: s_maximum_v2f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v0, s17
; GFX900-NEXT:    v_mov_b32_e32 v1, s17
; GFX900-NEXT:    s_lshr_b32 s4, s17, 16
; GFX900-NEXT:    v_pk_max_f16 v1, s16, v1
; GFX900-NEXT:    v_mov_b32_e32 v2, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, s16, v0
; GFX900-NEXT:    s_lshr_b32 s5, s16, 16
; GFX900-NEXT:    v_mov_b32_e32 v3, s4
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, s5, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX900-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX900-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use v0
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: s_maximum_v2f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_mov_b32_e32 v0, s0
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, s1, s1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    ;;#ASMSTART
; GFX950-NEXT:    ; use v0
; GFX950-NEXT:    ;;#ASMEND
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: s_maximum_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, s16, s17
; GFX10-NEXT:    v_cmp_o_f16_e64 vcc_lo, s16, s17
; GFX10-NEXT:    s_lshr_b32 s4, s17, 16
; GFX10-NEXT:    s_lshr_b32 s5, s16, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v0, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e64 vcc_lo, s5, s4
; GFX10-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v1, vcc_lo
; GFX10-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use v0
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: s_maximum_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, s0, s1
; GFX11-NEXT:    v_cmp_o_f16_e64 vcc_lo, s0, s1
; GFX11-NEXT:    s_lshr_b32 s2, s1, 16
; GFX11-NEXT:    s_lshr_b32 s0, s0, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v0, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e64 vcc_lo, s0, s2
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v1, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use v0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: s_maximum_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, s0, s1
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; use v0
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <2 x half> @llvm.maximum.v2f16(<2 x half> %src0, <2 x half> %src1)
  %cast = bitcast <2 x half> %op to i32
  call void asm sideeffect "; use $0", "s"(i32 %cast)
  ret void
}

define <3 x half> @v_maximum_v3f16(<3 x half> %src0, <3 x half> %src1) {
; GFX7-LABEL: v_maximum_v3f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_max_f32_e32 v6, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v7, v6, vcc
; GFX7-NEXT:    v_max_f32_e32 v3, v1, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v7, v3, vcc
; GFX7-NEXT:    v_max_f32_e32 v3, v2, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v2, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v7, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v3f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v6, v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v7, v6, vcc
; GFX8-NEXT:    v_max_f16_e32 v5, v1, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v7, v5, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v7, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v3f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX900-NEXT:    v_pk_max_f16 v3, v0, v2
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v3, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v3f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v3f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v4, v0, v2
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_max_f16 v2, v1, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_perm_b32 v0, v0, v4, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v3f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v4, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v5
; GFX11-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v7, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX11-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v3f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <3 x half> @llvm.maximum.v3f16(<3 x half> %src0, <3 x half> %src1)
  ret <3 x half> %op
}

define <3 x half> @v_maximum_v3f16__nnan(<3 x half> %src0, <3 x half> %src1) {
; GFX7-LABEL: v_maximum_v3f16__nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v3f16__nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v3f16__nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v3f16__nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v3f16__nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v3f16__nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v3f16__nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan <3 x half> @llvm.maximum.v3f16(<3 x half> %src0, <3 x half> %src1)
  ret <3 x half> %op
}

define <3 x half> @v_maximum_v3f16__nsz(<3 x half> %src0, <3 x half> %src1) {
; GFX7-LABEL: v_maximum_v3f16__nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_max_f32_e32 v6, v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v7, v6, vcc
; GFX7-NEXT:    v_max_f32_e32 v3, v1, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v7, v3, vcc
; GFX7-NEXT:    v_max_f32_e32 v3, v2, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v2, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v7, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v3f16__nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v6, v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v7, v6, vcc
; GFX8-NEXT:    v_max_f16_e32 v5, v1, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v7, v5, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v7, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v3f16__nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX900-NEXT:    v_pk_max_f16 v3, v0, v2
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v3, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v3f16__nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v3f16__nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v4, v0, v2
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_max_f16 v2, v1, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_perm_b32 v0, v0, v4, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v3f16__nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v4, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v5
; GFX11-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v7, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX11-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v3f16__nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nsz <3 x half> @llvm.maximum.v3f16(<3 x half> %src0, <3 x half> %src1)
  ret <3 x half> %op
}

define <3 x half> @v_maximum_v3f16__nnan_nsz(<3 x half> %src0, <3 x half> %src1) {
; GFX7-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v3f16__nnan_nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan nsz <3 x half> @llvm.maximum.v3f16(<3 x half> %src0, <3 x half> %src1)
  ret <3 x half> %op
}

define <4 x half> @v_maximum_v4f16(<4 x half> %src0, <4 x half> %src1) {
; GFX7-LABEL: v_maximum_v4f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_f32_e32 v8, v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v1, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v2, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v2, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v9, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v3, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v3, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v9, v4, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_max_f16_e32 v6, v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v7, v6, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v8, v6, v5
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX8-NEXT:    v_max_f16_e32 v6, v1, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v7, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v4f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX900-NEXT:    v_pk_max_f16 v3, v0, v2
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v3, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v6, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v4f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v4f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_pk_max_f16 v5, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v7, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v0, v0, v5, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_perm_b32 v1, v1, v6, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-NEXT:    v_pk_max_f16 v7, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v7, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v9, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v5
; GFX11-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v4f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <4 x half> @llvm.maximum.v4f16(<4 x half> %src0, <4 x half> %src1)
  ret <4 x half> %op
}

define <4 x half> @v_maximum_v4f16__nnan(<4 x half> %src0, <4 x half> %src1) {
; GFX7-LABEL: v_maximum_v4f16__nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v4f16__nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v5, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v4f16__nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v4f16__nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v4f16__nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v4f16__nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v4f16__nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan <4 x half> @llvm.maximum.v4f16(<4 x half> %src0, <4 x half> %src1)
  ret <4 x half> %op
}

define <4 x half> @v_maximum_v4f16__nsz(<4 x half> %src0, <4 x half> %src1) {
; GFX7-LABEL: v_maximum_v4f16__nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_f32_e32 v8, v0, v4
; GFX7-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v1, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v2, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v2, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v9, v4, vcc
; GFX7-NEXT:    v_max_f32_e32 v4, v3, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v3, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v9, v4, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v4f16__nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_max_f16_e32 v6, v5, v4
; GFX8-NEXT:    v_mov_b32_e32 v7, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v7, v6, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v8, v6, v5
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX8-NEXT:    v_max_f16_e32 v6, v1, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX8-NEXT:    v_max_f16_e32 v3, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v7, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v4f16__nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc
; GFX900-NEXT:    v_pk_max_f16 v3, v0, v2
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v3, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v4, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v6, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v4f16__nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v4f16__nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_pk_max_f16 v5, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v7, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v0, v0, v5, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_perm_b32 v1, v1, v6, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v4f16__nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v4, v1, v3
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-NEXT:    v_pk_max_f16 v7, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v7, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v9, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v5
; GFX11-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v4, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v4f16__nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nsz <4 x half> @llvm.maximum.v4f16(<4 x half> %src0, <4 x half> %src1)
  ret <4 x half> %op
}

define <4 x half> @v_maximum_v4f16__nnan_nsz(<4 x half> %src0, <4 x half> %src1) {
; GFX7-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v5, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v2, v2
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v3, v3
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v4f16__nnan_nsz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call nnan nsz <4 x half> @llvm.maximum.v4f16(<4 x half> %src0, <4 x half> %src1)
  ret <4 x half> %op
}

define <8 x half> @v_maximum_v8f16(<8 x half> %src0, <8 x half> %src1) {
; GFX7-LABEL: v_maximum_v8f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v12, v12
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v13, v13
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v14, v14
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v15, v15
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v12, v12
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_max_f32_e32 v16, v0, v8
; GFX7-NEXT:    v_mov_b32_e32 v17, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v13, v13
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v1, v9
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v9
; GFX7-NEXT:    v_cvt_f32_f16_e32 v14, v14
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v2, v10
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v2, v10
; GFX7-NEXT:    v_cvt_f32_f16_e32 v15, v15
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v2, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v3, v11
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v3, v11
; GFX7-NEXT:    v_cndmask_b32_e32 v3, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v4, v12
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v4, v12
; GFX7-NEXT:    v_cndmask_b32_e32 v4, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v5, v13
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v5, v13
; GFX7-NEXT:    v_cndmask_b32_e32 v5, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v6, v14
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v6, v14
; GFX7-NEXT:    v_cndmask_b32_e32 v6, v17, v8, vcc
; GFX7-NEXT:    v_max_f32_e32 v8, v7, v15
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v7, v15
; GFX7-NEXT:    v_cndmask_b32_e32 v7, v17, v8, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v8f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; GFX8-NEXT:    v_max_f16_e32 v10, v9, v8
; GFX8-NEXT:    v_mov_b32_e32 v11, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v9, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v11, v10, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; GFX8-NEXT:    v_max_f16_e32 v12, v10, v9
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v10, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v11, v12, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v1
; GFX8-NEXT:    v_max_f16_e32 v13, v12, v10
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v12, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v11, v13, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v14, v13, v12
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v13, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v11, v14, vcc
; GFX8-NEXT:    v_max_f16_e32 v13, v3, v7
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v3, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v11, v13, vcc
; GFX8-NEXT:    v_max_f16_e32 v7, v2, v6
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v2, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v7, vcc
; GFX8-NEXT:    v_max_f16_e32 v6, v1, v5
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v11, v6, vcc
; GFX8-NEXT:    v_max_f16_e32 v5, v0, v4
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v11, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v12
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v10
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v8f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v8, v3, v7
; GFX900-NEXT:    v_mov_b32_e32 v9, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v3, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v3, v7 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v9, v8, vcc
; GFX900-NEXT:    v_pk_max_f16 v7, v2, v6
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v2, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v9, v7, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v2, v6 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v9, v7, vcc
; GFX900-NEXT:    v_pk_max_f16 v6, v1, v5
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v9, v6, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v5 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v9, v6, vcc
; GFX900-NEXT:    v_pk_max_f16 v5, v0, v4
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v9, v5, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v4 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v9, v5, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v6, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v7, s4
; GFX900-NEXT:    v_perm_b32 v2, v2, v8, s4
; GFX900-NEXT:    v_perm_b32 v3, v3, v10, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v8f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v4, v4
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v5, v5
; GFX950-NEXT:    v_pk_maximum3_f16 v2, v2, v6, v6
; GFX950-NEXT:    v_pk_maximum3_f16 v3, v3, v7, v7
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v8f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v8, v3, v7
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX10-NEXT:    v_pk_max_f16 v9, v2, v6
; GFX10-NEXT:    v_pk_max_f16 v12, v1, v5
; GFX10-NEXT:    v_pk_max_f16 v13, v0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v10, 0x7e00, v8, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v9
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v9, 0x7e00, v9, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v2, v6 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v11, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v13
; GFX10-NEXT:    v_perm_b32 v2, v2, v9, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v12, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v13, 0x7e00, v13, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v4 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v11, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v5 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v0, v0, v13, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v12, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v3, v7 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v1, v1, v6, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v8, vcc_lo
; GFX10-NEXT:    v_perm_b32 v3, v3, v10, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v8f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v8, v3, v7
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX11-NEXT:    v_pk_max_f16 v10, v2, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX11-NEXT:    v_pk_max_f16 v14, v1, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v9, 0x7e00, v8, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v10, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v12, v11
; GFX11-NEXT:    v_pk_max_f16 v11, v0, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v13, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v15, 16, v11
; GFX11-NEXT:    v_cndmask_b32_e32 v10, 0x7e00, v14, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v11, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v13, v12
; GFX11-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v15, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v14, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX11-NEXT:    v_perm_b32 v1, v1, v10, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v3, v3, v9, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v8f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v4
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v5
; GFX12-NEXT:    v_pk_maximum_f16 v2, v2, v6
; GFX12-NEXT:    v_pk_maximum_f16 v3, v3, v7
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <8 x half> @llvm.maximum.v8f16(<8 x half> %src0, <8 x half> %src1)
  ret <8 x half> %op
}

define <16 x half> @v_maximum_v16f16(<16 x half> %src0, <16 x half> %src1) {
; GFX7-LABEL: v_maximum_v16f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v1, v17
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v18
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cmp_o_f32_e64 s[4:5], v2, v17
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v19
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX7-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX7-NEXT:    v_cmp_o_f32_e64 s[6:7], v3, v17
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v20
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX7-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX7-NEXT:    v_cvt_f16_f32_e32 v18, v28
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v12, v12
; GFX7-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX7-NEXT:    v_cvt_f32_f16_e32 v18, v18
; GFX7-NEXT:    v_cmp_o_f32_e64 s[8:9], v4, v17
; GFX7-NEXT:    v_max_f32_e32 v4, v4, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v21
; GFX7-NEXT:    v_cvt_f32_f16_e32 v12, v12
; GFX7-NEXT:    v_cvt_f16_f32_e32 v13, v13
; GFX7-NEXT:    v_cvt_f16_f32_e32 v19, v16
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cmp_o_f32_e64 s[24:25], v12, v18
; GFX7-NEXT:    v_max_f32_e32 v12, v12, v18
; GFX7-NEXT:    v_cvt_f16_f32_e32 v18, v29
; GFX7-NEXT:    v_cmp_o_f32_e64 s[10:11], v5, v17
; GFX7-NEXT:    v_max_f32_e32 v5, v5, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v22
; GFX7-NEXT:    v_cvt_f16_f32_e32 v20, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v16, v18
; GFX7-NEXT:    v_cvt_f32_f16_e32 v18, v13
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v19
; GFX7-NEXT:    v_cvt_f32_f16_e32 v13, v20
; GFX7-NEXT:    v_cmp_o_f32_e64 s[26:27], v18, v16
; GFX7-NEXT:    v_cmp_o_f32_e64 s[12:13], v6, v17
; GFX7-NEXT:    v_max_f32_e32 v6, v6, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v23
; GFX7-NEXT:    v_max_f32_e32 v16, v18, v16
; GFX7-NEXT:    v_max_f32_e32 v18, v13, v0
; GFX7-NEXT:    v_cmp_o_f32_e64 s[28:29], v13, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v13, v15
; GFX7-NEXT:    v_cvt_f16_f32_e32 v15, v30
; GFX7-NEXT:    v_cvt_f16_f32_e32 v14, v14
; GFX7-NEXT:    v_cmp_o_f32_e64 s[14:15], v7, v17
; GFX7-NEXT:    v_max_f32_e32 v7, v7, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v24
; GFX7-NEXT:    v_cvt_f32_f16_e32 v15, v15
; GFX7-NEXT:    v_cvt_f32_f16_e32 v14, v14
; GFX7-NEXT:    v_cvt_f32_f16_e32 v20, v13
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_mov_b32_e32 v19, 0x7fc00000
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v19, v1, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v13, v19, v16, s[26:27]
; GFX7-NEXT:    v_cmp_o_f32_e64 s[16:17], v8, v17
; GFX7-NEXT:    v_max_f32_e32 v8, v8, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v25
; GFX7-NEXT:    v_max_f32_e32 v16, v14, v15
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v14, v15
; GFX7-NEXT:    v_cndmask_b32_e32 v14, v19, v16, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cndmask_b32_e64 v2, v19, v2, s[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v3, v19, v3, s[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v4, v19, v4, s[8:9]
; GFX7-NEXT:    v_cmp_o_f32_e64 s[18:19], v9, v17
; GFX7-NEXT:    v_max_f32_e32 v9, v9, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v26
; GFX7-NEXT:    v_cndmask_b32_e64 v5, v19, v5, s[10:11]
; GFX7-NEXT:    v_cndmask_b32_e64 v6, v19, v6, s[12:13]
; GFX7-NEXT:    v_cndmask_b32_e64 v7, v19, v7, s[14:15]
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cndmask_b32_e64 v8, v19, v8, s[16:17]
; GFX7-NEXT:    v_cndmask_b32_e64 v9, v19, v9, s[18:19]
; GFX7-NEXT:    v_cndmask_b32_e64 v12, v19, v12, s[24:25]
; GFX7-NEXT:    v_cmp_o_f32_e64 s[20:21], v10, v17
; GFX7-NEXT:    v_max_f32_e32 v10, v10, v17
; GFX7-NEXT:    v_cvt_f16_f32_e32 v17, v27
; GFX7-NEXT:    v_cndmask_b32_e64 v10, v19, v10, s[20:21]
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v17
; GFX7-NEXT:    v_cmp_o_f32_e64 s[22:23], v11, v17
; GFX7-NEXT:    v_max_f32_e32 v11, v11, v17
; GFX7-NEXT:    buffer_load_dword v17, off, s[0:3], s32
; GFX7-NEXT:    v_cndmask_b32_e64 v11, v19, v11, s[22:23]
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v17
; GFX7-NEXT:    v_cvt_f32_f16_e32 v17, v0
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v19, v18, s[28:29]
; GFX7-NEXT:    v_max_f32_e32 v15, v20, v17
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v20, v17
; GFX7-NEXT:    v_cndmask_b32_e32 v15, v19, v15, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximum_v16f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v14
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v6
; GFX8-NEXT:    v_max_f16_e32 v16, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v13
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v5
; GFX8-NEXT:    v_max_f16_e32 v20, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[4:5], v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v12
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v4
; GFX8-NEXT:    v_max_f16_e32 v21, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[6:7], v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v11
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v3
; GFX8-NEXT:    v_max_f16_e32 v22, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[8:9], v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v10
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v2
; GFX8-NEXT:    v_max_f16_e32 v23, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[10:11], v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v9
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v1
; GFX8-NEXT:    v_max_f16_e32 v24, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[12:13], v18, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v8
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v0
; GFX8-NEXT:    v_max_f16_e32 v25, v18, v17
; GFX8-NEXT:    v_cmp_o_f16_e64 s[14:15], v18, v17
; GFX8-NEXT:    v_max_f16_e32 v17, v6, v14
; GFX8-NEXT:    v_cmp_o_f16_e64 s[16:17], v6, v14
; GFX8-NEXT:    v_max_f16_e32 v6, v5, v13
; GFX8-NEXT:    v_cmp_o_f16_e64 s[18:19], v5, v13
; GFX8-NEXT:    v_max_f16_e32 v5, v4, v12
; GFX8-NEXT:    v_cmp_o_f16_e64 s[20:21], v4, v12
; GFX8-NEXT:    v_max_f16_e32 v4, v3, v11
; GFX8-NEXT:    v_cmp_o_f16_e64 s[22:23], v3, v11
; GFX8-NEXT:    v_max_f16_e32 v11, v7, v15
; GFX8-NEXT:    v_cmp_o_f16_e64 s[24:25], v7, v15
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v15
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX8-NEXT:    v_mov_b32_e32 v19, 0x7e00
; GFX8-NEXT:    v_max_f16_e32 v13, v7, v12
; GFX8-NEXT:    v_cmp_o_f16_e64 s[26:27], v7, v12
; GFX8-NEXT:    v_max_f16_e32 v3, v2, v10
; GFX8-NEXT:    v_cndmask_b32_e64 v12, v19, v13, s[26:27]
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v19, v16, vcc
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v2, v10
; GFX8-NEXT:    v_max_f16_e32 v14, v1, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v19, v3, vcc
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v1, v9
; GFX8-NEXT:    v_max_f16_e32 v7, v0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v18, v19, v22, s[8:9]
; GFX8-NEXT:    v_cndmask_b32_e64 v22, v19, v25, s[14:15]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v19, v14, vcc
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v8
; GFX8-NEXT:    v_cndmask_b32_e64 v16, v19, v21, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v21, v19, v24, s[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v19, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v22
; GFX8-NEXT:    v_cndmask_b32_e64 v15, v19, v20, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v20, v19, v23, s[10:11]
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v21
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v20
; GFX8-NEXT:    v_cndmask_b32_e64 v4, v19, v4, s[22:23]
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v18
; GFX8-NEXT:    v_cndmask_b32_e64 v5, v19, v5, s[20:21]
; GFX8-NEXT:    v_or_b32_sdwa v3, v4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v16
; GFX8-NEXT:    v_cndmask_b32_e64 v6, v19, v6, s[18:19]
; GFX8-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v15
; GFX8-NEXT:    v_cndmask_b32_e64 v11, v19, v11, s[24:25]
; GFX8-NEXT:    v_cndmask_b32_e64 v17, v19, v17, s[16:17]
; GFX8-NEXT:    v_or_b32_sdwa v5, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v12
; GFX8-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v7, v11, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximum_v16f16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_pk_max_f16 v16, v7, v15
; GFX900-NEXT:    v_mov_b32_e32 v17, 0x7e00
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v7, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v17, v16, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v16, 16, v16
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v7, v15 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v17, v16, vcc
; GFX900-NEXT:    v_pk_max_f16 v15, v6, v14
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v6, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v16, v17, v15, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v15, 16, v15
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v6, v14 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v17, v15, vcc
; GFX900-NEXT:    v_pk_max_f16 v14, v5, v13
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v5, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v17, v14, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v14, 16, v14
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v5, v13 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v17, v14, vcc
; GFX900-NEXT:    v_pk_max_f16 v13, v4, v12
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v4, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v17, v13, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v13, 16, v13
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v4, v12 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v17, v13, vcc
; GFX900-NEXT:    v_pk_max_f16 v12, v3, v11
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v3, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v17, v12, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v3, v11 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v17, v12, vcc
; GFX900-NEXT:    v_pk_max_f16 v11, v2, v10
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v2, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v17, v11, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v2, v10 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v17, v11, vcc
; GFX900-NEXT:    v_pk_max_f16 v10, v1, v9
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v1, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v17, v10, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v9 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v17, v10, vcc
; GFX900-NEXT:    v_pk_max_f16 v9, v0, v8
; GFX900-NEXT:    v_cmp_o_f16_e32 vcc, v0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v17, v9, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX900-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v8 src0_sel:WORD_1 src1_sel:WORD_1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v17, v9, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v10, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v11, s4
; GFX900-NEXT:    v_perm_b32 v2, v2, v12, s4
; GFX900-NEXT:    v_perm_b32 v3, v3, v13, s4
; GFX900-NEXT:    v_perm_b32 v4, v4, v14, s4
; GFX900-NEXT:    v_perm_b32 v5, v5, v15, s4
; GFX900-NEXT:    v_perm_b32 v6, v6, v16, s4
; GFX900-NEXT:    v_perm_b32 v7, v7, v18, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximum_v16f16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_pk_maximum3_f16 v0, v0, v8, v8
; GFX950-NEXT:    v_pk_maximum3_f16 v1, v1, v9, v9
; GFX950-NEXT:    v_pk_maximum3_f16 v2, v2, v10, v10
; GFX950-NEXT:    v_pk_maximum3_f16 v3, v3, v11, v11
; GFX950-NEXT:    v_pk_maximum3_f16 v4, v4, v12, v12
; GFX950-NEXT:    v_pk_maximum3_f16 v5, v5, v13, v13
; GFX950-NEXT:    v_pk_maximum3_f16 v6, v6, v14, v14
; GFX950-NEXT:    v_pk_maximum3_f16 v7, v7, v15, v15
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximum_v16f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v16, v7, v15
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v7, v15
; GFX10-NEXT:    v_pk_max_f16 v18, v6, v14
; GFX10-NEXT:    v_pk_max_f16 v19, v3, v11
; GFX10-NEXT:    v_pk_max_f16 v20, v2, v10
; GFX10-NEXT:    v_lshrrev_b32_e32 v17, 16, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v16, 0x7e00, v16, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v7, v15 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v15, 16, v18
; GFX10-NEXT:    v_pk_max_f16 v21, v0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v7, 0x7e00, v17, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v14
; GFX10-NEXT:    v_pk_max_f16 v17, v5, v13
; GFX10-NEXT:    v_lshrrev_b32_e32 v23, 16, v21
; GFX10-NEXT:    v_perm_b32 v7, v7, v16, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v18, 0x7e00, v18, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v6, v14 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v14, 16, v17
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v15, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v5, v13
; GFX10-NEXT:    v_perm_b32 v6, v6, v18, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v15, 0x7e00, v17, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v5, v13 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_max_f16 v17, v4, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v5, 0x7e00, v14, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v12
; GFX10-NEXT:    v_lshrrev_b32_e32 v14, 16, v17
; GFX10-NEXT:    v_perm_b32 v5, v5, v15, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v13, 0x7e00, v17, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v11
; GFX10-NEXT:    v_lshrrev_b32_e32 v17, 16, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v19, 0x7e00, v19, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v3, v11 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_max_f16 v11, v1, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v17, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v10
; GFX10-NEXT:    v_lshrrev_b32_e32 v22, 16, v11
; GFX10-NEXT:    v_perm_b32 v3, v3, v19, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v17, 0x7e00, v20, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v9
; GFX10-NEXT:    v_lshrrev_b32_e32 v20, 16, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v11, 0x7e00, v11, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v9 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v22, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v8
; GFX10-NEXT:    v_perm_b32 v1, v1, v11, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v9, 0x7e00, v21, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v8 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v23, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v2, v10 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v0, v0, v9, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v20, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v4, v12 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_perm_b32 v2, v2, v17, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v14, vcc_lo
; GFX10-NEXT:    v_perm_b32 v4, v4, v13, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximum_v16f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v16, v7, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v17, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v7
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v7, v15
; GFX11-NEXT:    v_pk_max_f16 v15, v6, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v16
; GFX11-NEXT:    v_pk_max_f16 v20, v4, v12
; GFX11-NEXT:    v_pk_max_f16 v22, v2, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v7, 0x7e00, v16, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v18, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v17, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v24, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v16, 0x7e00, v19, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v15
; GFX11-NEXT:    v_pk_max_f16 v14, v5, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_perm_b32 v7, v16, v7, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v15, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v18, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v17, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v15, 0x7e00, v19, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v5, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v14
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_perm_b32 v6, v15, v6, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v5, 0x7e00, v14, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v18, v17
; GFX11-NEXT:    v_pk_max_f16 v17, v3, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v20
; GFX11-NEXT:    v_cndmask_b32_e32 v13, 0x7e00, v19, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e32 v14, 0x7e00, v20, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v20, 16, v3
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v11
; GFX11-NEXT:    v_perm_b32 v5, v13, v5, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v17, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v20, v19
; GFX11-NEXT:    v_pk_max_f16 v19, v1, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v20, 16, v22
; GFX11-NEXT:    v_cndmask_b32_e32 v11, 0x7e00, v21, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_perm_b32 v3, v11, v3, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v17, 0x7e00, v22, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_pk_max_f16 v22, v0, v8
; GFX11-NEXT:    v_cndmask_b32_e32 v21, 0x7e00, v19, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v19, 16, v19
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 16, v22
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v19, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v8
; GFX11-NEXT:    v_perm_b32 v1, v1, v21, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v22, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v24, v23
; GFX11-NEXT:    v_cndmask_b32_e32 v8, 0x7e00, v25, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_perm_b32 v0, v8, v0, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v20, vcc_lo
; GFX11-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v12
; GFX11-NEXT:    v_perm_b32 v2, v2, v17, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v18, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v4, v4, v14, 0x5040100
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximum_v16f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_maximum_f16 v0, v0, v8
; GFX12-NEXT:    v_pk_maximum_f16 v1, v1, v9
; GFX12-NEXT:    v_pk_maximum_f16 v2, v2, v10
; GFX12-NEXT:    v_pk_maximum_f16 v3, v3, v11
; GFX12-NEXT:    v_pk_maximum_f16 v4, v4, v12
; GFX12-NEXT:    v_pk_maximum_f16 v5, v5, v13
; GFX12-NEXT:    v_pk_maximum_f16 v6, v6, v14
; GFX12-NEXT:    v_pk_maximum_f16 v7, v7, v15
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %op = call <16 x half> @llvm.maximum.v16f16(<16 x half> %src0, <16 x half> %src1)
  ret <16 x half> %op
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GFX9: {{.*}}
