; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=Iterative < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132 %s
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefix=GFX7LESS-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX9-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164-DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -amdgpu-atomic-optimizer-strategy=DPP < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132-DPP %s

declare float @div.float.value()
declare double @div.double.value()

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB0_2
; GFX7LESS-NEXT:  .LBB0_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB0_2
; GFX9-NEXT:  .LBB0_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB0_2
; GFX1064-NEXT:  .LBB0_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB0_2
; GFX1032-NEXT:  .LBB0_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX7LESS-DPP-NEXT:  .LBB0_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX9-DPP-NEXT:  .LBB0_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX1064-DPP-NEXT:  .LBB0_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB0_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-DPP-NEXT:  .LBB0_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB0_2
; GFX1032-DPP-NEXT:  .LBB0_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-DPP-NEXT:  .LBB0_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-DPP-NEXT:  .LBB0_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0 syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX7LESS-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB1_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB1_4
; GFX7LESS-NEXT:  .LBB1_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB1_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB1_4
; GFX9-NEXT:  .LBB1_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB1_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1064-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB1_4
; GFX1064-NEXT:  .LBB1_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB1_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1032-NEXT:  .LBB1_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB1_4
; GFX1032-NEXT:  .LBB1_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX1164-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB1_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB1_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB1_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v1, s2, v1
; GFX1132-NEXT:    s_cbranch_scc1 .LBB1_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB1_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v2, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB1_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB1_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB1_2
; GFX9-DPP-NEXT:  .LBB1_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 32
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_add_f32_e64 v3, s2, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB1_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1064-DPP-NEXT:  .LBB1_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB1_2
; GFX1064-DPP-NEXT:  .LBB1_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s0
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB1_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1032-DPP-NEXT:  .LBB1_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB1_2
; GFX1032-DPP-NEXT:  .LBB1_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB1_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s0
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB1_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value()
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %divValue syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB2_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB2_2
; GFX7LESS-NEXT:  .LBB2_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-NEXT:    s_add_u32 s12, s12, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB2_2
; GFX9-NEXT:  .LBB2_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB2_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB2_2
; GFX1064-NEXT:  .LBB2_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s14, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB2_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB2_2
; GFX1032-NEXT:  .LBB2_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v1, v0, s[0:1]
; GFX1164-NEXT:  .LBB2_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v1, v0, s[0:1]
; GFX1132-NEXT:  .LBB2_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX7LESS-DPP-NEXT:  .LBB2_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s14, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX9-DPP-NEXT:  .LBB2_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX1064-DPP-NEXT:  .LBB2_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB2_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:  .LBB2_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB2_2
; GFX1032-DPP-NEXT:  .LBB2_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB2_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB2_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0 syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}


define amdgpu_kernel void @global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX7LESS-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB3_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB3_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB3_4
; GFX7LESS-NEXT:  .LBB3_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB3_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB3_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1064-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB3_4
; GFX1064-NEXT:  .LBB3_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB3_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1032-NEXT:  .LBB3_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB3_4
; GFX1032-NEXT:  .LBB3_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX1164-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB3_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB3_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB3_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v1, s2, v1
; GFX1132-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB3_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB3_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v2, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB3_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB3_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB3_2
; GFX9-DPP-NEXT:  .LBB3_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 32
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_add_f32_e64 v3, s2, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB3_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1064-DPP-NEXT:  .LBB3_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB3_2
; GFX1064-DPP-NEXT:  .LBB3_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s0
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB3_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1032-DPP-NEXT:  .LBB3_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB3_2
; GFX1032-DPP-NEXT:  .LBB3_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB3_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s0
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB3_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %divValue syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp(ptr addrspace(1) %ptr) #2{
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB4_2
; GFX7LESS-NEXT:  .LBB4_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-NEXT:    s_add_u32 s12, s12, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB4_2
; GFX9-NEXT:  .LBB4_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1064-NEXT:  .LBB4_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s14, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1032-NEXT:  .LBB4_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB4_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1164-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1164-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1164-NEXT:  .LBB4_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB4_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v1, s3 :: v_dual_mul_f32 v2, 4.0, v0
; GFX1132-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1132-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1132-NEXT:  .LBB4_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX7LESS-DPP-NEXT:  .LBB4_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s14, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX9-DPP-NEXT:  .LBB4_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1064-DPP-NEXT:  .LBB4_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1032-DPP-NEXT:  .LBB4_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1164-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1164-DPP-NEXT:  .LBB4_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_agent_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB4_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, s3 :: v_dual_mul_f32 v2, 4.0, v0
; GFX1132-DPP-NEXT:  .LBB4_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB4_2
; GFX1132-DPP-NEXT:  .LBB4_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0 syncscope("agent") monotonic
  ret void
}


define amdgpu_kernel void @global_atomic_fadd_uni_address_div_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX7LESS-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB5_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB5_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB5_4
; GFX7LESS-NEXT:  .LBB5_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB5_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB5_4
; GFX9-NEXT:  .LBB5_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB5_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1064-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB5_4
; GFX1064-NEXT:  .LBB5_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB5_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1032-NEXT:  .LBB5_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB5_4
; GFX1032-NEXT:  .LBB5_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX1164-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB5_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB5_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v1, s2, v1
; GFX1132-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB5_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB5_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v2, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB5_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB5_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB5_2
; GFX9-DPP-NEXT:  .LBB5_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 32
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_add_f32_e64 v3, s2, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB5_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1064-DPP-NEXT:  .LBB5_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB5_2
; GFX1064-DPP-NEXT:  .LBB5_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s0
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB5_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1032-DPP-NEXT:  .LBB5_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB5_2
; GFX1032-DPP-NEXT:  .LBB5_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB5_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s0
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB5_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value()
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %divValue syncscope("agent") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}


define amdgpu_kernel void @global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX7LESS-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB6_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB6_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB6_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB6_4
; GFX7LESS-NEXT:  .LBB6_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB6_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB6_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB6_4
; GFX9-NEXT:  .LBB6_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB6_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1064-NEXT:  .LBB6_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB6_4
; GFX1064-NEXT:  .LBB6_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB6_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1032-NEXT:  .LBB6_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB6_4
; GFX1032-NEXT:  .LBB6_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX1164-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB6_4
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1164-NEXT:  .LBB6_4:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB6_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v1, s2, v1
; GFX1132-NEXT:    s_cbranch_scc1 .LBB6_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB6_4
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v0, v1, s[0:1]
; GFX1132-NEXT:  .LBB6_4:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v2, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB6_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX9-DPP-NEXT:  .LBB6_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 32
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_add_f32_e64 v3, s2, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1064-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1064-DPP-NEXT:  .LBB6_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s0
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB6_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1032-DPP-NEXT:  .LBB6_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB6_2
; GFX1032-DPP-NEXT:  .LBB6_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1164-DPP-NEXT:  .LBB6_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s0
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB6_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v4, v0, s[0:1]
; GFX1132-DPP-NEXT:  .LBB6_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %divValue syncscope("agent") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_default_scope_strictfp(ptr addrspace(1) %ptr) #2 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB7_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB7_2
; GFX7LESS-NEXT:  .LBB7_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-NEXT:    s_add_u32 s12, s12, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB7_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB7_2
; GFX9-NEXT:  .LBB7_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB7_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1064-NEXT:  .LBB7_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s14, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB7_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1032-NEXT:  .LBB7_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB7_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1164-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1164-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1164-NEXT:  .LBB7_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB7_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v1, s3 :: v_dual_mul_f32 v2, 4.0, v0
; GFX1132-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1132-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1132-NEXT:  .LBB7_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s0, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s1, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s6, s[0:1]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX7LESS-DPP-NEXT:  .LBB7_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s14, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX9-DPP-NEXT:  .LBB7_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1064-DPP-NEXT:  .LBB7_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1032-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[0:1]
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1032-DPP-NEXT:  .LBB7_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1164-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1164-DPP-NEXT:  .LBB7_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_default_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB7_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, s3 :: v_dual_mul_f32 v2, 4.0, v0
; GFX1132-DPP-NEXT:  .LBB7_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB7_2
; GFX1132-DPP-NEXT:  .LBB7_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0 monotonic, align 4
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_div_value_default_scope_strictfp(ptr addrspace(1) %ptr) #2 {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX7LESS-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s4, v0, s2
; GFX7LESS-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB8_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB8_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB8_4
; GFX7LESS-NEXT:  .LBB8_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s4, v0, s2
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX9-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB8_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX9-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB8_4
; GFX9-NEXT:  .LBB8_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1064-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB8_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1064-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB8_4
; GFX1064-NEXT:  .LBB8_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1032-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB8_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dword v1, v3, s[0:1]
; GFX1032-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB8_4
; GFX1032-NEXT:  .LBB8_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s4, v0, s2
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f32_e32 v2, s4, v2
; GFX1164-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB8_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b32 v1, v3, s[0:1]
; GFX1164-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1164-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB8_4
; GFX1164-NEXT:  .LBB8_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f32_e32 v2, s2, v2
; GFX1132-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB8_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b32 v1, v3, s[0:1]
; GFX1132-NEXT:  .LBB8_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1132-NEXT:    global_atomic_cmpswap_b32 v0, v3, v[0:1], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB8_4
; GFX1132-NEXT:  .LBB8_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dword v2, off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v1, v2, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB8_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v4, v3, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v5, v4 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-DPP-NEXT:    v_readlane_b32 s4, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dword v1, v2, s[0:1]
; GFX9-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v2, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX9-DPP-NEXT:  .LBB8_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v3, 32
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_add_f32_e64 v3, s2, s3
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1064-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1064-DPP-NEXT:  .LBB8_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v4, 0x80000000, v0, s0
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v4, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v3
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dword v1, v6, s[0:1]
; GFX1032-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v6, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1032-DPP-NEXT:  .LBB8_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s[0:1]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v2, v1
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v4, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b32 v5, v6, s[0:1]
; GFX1164-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f32_e32 v4, v5, v0
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b32 v4, v6, v[4:5], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, v4
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1164-DPP-NEXT:  .LBB8_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_div_value_default_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v2, 0x80000000, v0, s0
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v1, v2 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v1 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v1 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v2, v1, 0, 0
; GFX1132-DPP-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v4, exec_lo, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB8_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b32 v5, v6, s[0:1]
; GFX1132-DPP-NEXT:  .LBB8_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f32_e32 v4, v5, v0
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b32 v4, v6, v[4:5], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v4, v5
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v5, v4
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB8_2
; GFX1132-DPP-NEXT:  .LBB8_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call float @div.float.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %divValue monotonic, align 4
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v3, s0, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v3, s1, v3
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB9_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX7LESS-NEXT:    v_cvt_f64_u32_e32 v[1:2], s2
; GFX7LESS-NEXT:    v_or_b32_e32 v4, v0, v4
; GFX7LESS-NEXT:    v_mul_f64 v[41:42], v[1:2], 4.0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-NEXT:    v_or_b32_e32 v40, v4, v3
; GFX7LESS-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB9_2
; GFX7LESS-NEXT:  .LBB9_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s50, -1
; GFX9-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, s0, 0
; GFX9-NEXT:    s_add_u32 s48, s48, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, s1, v3
; GFX9-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_movk_i32 s32, 0x800
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB9_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX9-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b32 s33, s10
; GFX9-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX9-NEXT:    s_mov_b32 s42, s9
; GFX9-NEXT:    s_mov_b32 s43, s8
; GFX9-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[3:4], v[41:42]
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:4
; GFX9-NEXT:    buffer_store_dword v3, off, s[48:51], 0
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:12
; GFX9-NEXT:    buffer_store_dword v0, off, s[48:51], 0 offset:8
; GFX9-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    buffer_load_dword v3, off, s[48:51], 0
; GFX9-NEXT:    buffer_load_dword v4, off, s[48:51], 0 offset:4
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-NEXT:    s_cbranch_execnz .LBB9_2
; GFX9-NEXT:  .LBB9_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s50, -1
; GFX1064-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-NEXT:    s_mov_b32 s33, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], exec
; GFX1064-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v3, s10, 0
; GFX1064-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v3, s11, v3
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB9_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1064-NEXT:    s_bcnt1_i32_b64 s0, s[10:11]
; GFX1064-NEXT:    s_mov_b32 s42, s9
; GFX1064-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX1064-NEXT:    s_mov_b32 s43, s8
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1064-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1064-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1064-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1064-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v2, s1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s0
; GFX1064-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-NEXT:    s_add_u32 s8, s36, 44
; GFX1064-NEXT:    s_addc_u32 s9, s37, 0
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1064-NEXT:  .LBB9_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s42, s9
; GFX1032-NEXT:    s_mov_b32 s9, exec_lo
; GFX1032-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s50, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v3, s9, 0
; GFX1032-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-NEXT:    s_mov_b32 s46, 0
; GFX1032-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB9_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1032-NEXT:    s_bcnt1_i32_b32 s0, s9
; GFX1032-NEXT:    s_mov_b32 s33, s10
; GFX1032-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX1032-NEXT:    s_mov_b32 s43, s8
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1032-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1032-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1032-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1032-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-NEXT:    s_add_u32 s8, s36, 44
; GFX1032-NEXT:    s_addc_u32 s9, s37, 0
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1032-NEXT:  .LBB9_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b32 s33, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], exec
; GFX1164-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s10, 0
; GFX1164-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-NEXT:    s_mov_b32 s32, 32
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s11, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB9_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, s[10:11]
; GFX1164-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1164-NEXT:    v_cvt_f64_u32_e32 v[0:1], s0
; GFX1164-NEXT:    s_mov_b32 s42, s9
; GFX1164-NEXT:    s_mov_b32 s43, s8
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1164-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mul_f64 v[41:42], v[0:1], 4.0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-NEXT:    .p2align 6
; GFX1164-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-NEXT:    s_add_u32 s8, s36, 44
; GFX1164-NEXT:    s_addc_u32 s9, s37, 0
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1164-NEXT:  .LBB9_3:
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b32 s8, exec_lo
; GFX1132-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1132-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-NEXT:    s_mov_b32 s46, 0
; GFX1132-NEXT:    s_mov_b32 s32, 32
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB9_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, s8
; GFX1132-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1132-NEXT:    v_cvt_f64_u32_e32 v[0:1], s0
; GFX1132-NEXT:    s_mov_b32 s33, s15
; GFX1132-NEXT:    s_mov_b32 s42, s14
; GFX1132-NEXT:    s_mov_b32 s43, s13
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1132-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mul_f64 v[41:42], v[0:1], 4.0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-NEXT:    .p2align 6
; GFX1132-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-NEXT:    s_add_u32 s8, s36, 44
; GFX1132-NEXT:    s_addc_u32 s9, s37, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1132-NEXT:    s_mov_b32 s12, s43
; GFX1132-NEXT:    s_mov_b32 s13, s42
; GFX1132-NEXT:    s_mov_b32 s14, s33
; GFX1132-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1132-NEXT:  .LBB9_3:
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v3, s0, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v3, s1, v3
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX7LESS-DPP-NEXT:    v_cvt_f64_u32_e32 v[1:2], s2
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v4, v0, v4
; GFX7LESS-DPP-NEXT:    v_mul_f64 v[41:42], v[1:2], 4.0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v40, v4, v3
; GFX7LESS-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX7LESS-DPP-NEXT:  .LBB9_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s50, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, s1, v3
; GFX9-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX9-DPP-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b32 s33, s10
; GFX9-DPP-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s42, s9
; GFX9-DPP-NEXT:    s_mov_b32 s43, s8
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, s1
; GFX9-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], v[3:4], v[41:42]
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:4
; GFX9-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:12
; GFX9-DPP-NEXT:    buffer_store_dword v0, off, s[48:51], 0 offset:8
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    buffer_load_dword v3, off, s[48:51], 0
; GFX9-DPP-NEXT:    buffer_load_dword v4, off, s[48:51], 0 offset:4
; GFX9-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX9-DPP-NEXT:  .LBB9_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], exec
; GFX1064-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, s10, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, s11, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[10:11]
; GFX1064-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1064-DPP-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX1064-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1064-DPP-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1064-DPP-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1064-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_clause 0x1
; GFX1064-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1064-DPP-NEXT:  .LBB9_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1032-DPP-NEXT:    s_mov_b32 s9, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, s9, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1032-DPP-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s0, s9
; GFX1032-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1032-DPP-NEXT:    v_cvt_f64_u32_e32 v[3:4], s0
; GFX1032-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1032-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1032-DPP-NEXT:    v_mul_f64 v[41:42], v[3:4], 4.0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1032-DPP-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_clause 0x1
; GFX1032-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1032-DPP-NEXT:  .LBB9_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s11, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[10:11]
; GFX1164-DPP-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_cvt_f64_u32_e32 v[0:1], s0
; GFX1164-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1164-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mul_f64 v[41:42], v[0:1], 4.0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-DPP-NEXT:    .p2align 6
; GFX1164-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1164-DPP-NEXT:  .LBB9_3:
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b32 s8, exec_lo
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1132-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB9_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, s8
; GFX1132-DPP-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_cvt_f64_u32_e32 v[0:1], s0
; GFX1132-DPP-NEXT:    s_mov_b32 s33, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s42, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s43, s13
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1132-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mul_f64 v[41:42], v[0:1], 4.0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-DPP-NEXT:    .p2align 6
; GFX1132-DPP-NEXT:  .LBB9_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB9_2
; GFX1132-DPP-NEXT:  .LBB9_3:
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double 4.0 syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v40, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v41, 0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX7LESS-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB10_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB10_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[44:45], s[36:37], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s47, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s46, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[0:1], off, s[44:47], 0
; GFX7LESS-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB10_4
; GFX7LESS-NEXT:  .LBB10_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s50, -1
; GFX9-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-NEXT:    s_add_u32 s48, s48, s11
; GFX9-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-NEXT:    s_mov_b32 s43, s8
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_mov_b32 s42, s9
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b32 s33, s10
; GFX9-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    s_movk_i32 s32, 0x800
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v41, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX9-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB10_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[44:45], s[36:37], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX9-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX9-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX9-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-NEXT:    s_cbranch_execnz .LBB10_4
; GFX9-NEXT:  .LBB10_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s50, -1
; GFX1064-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-NEXT:    s_mov_b32 s43, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s42, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s33, s10
; GFX1064-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v41, 0
; GFX1064-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB10_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1064-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-NEXT:    s_cbranch_execnz .LBB10_4
; GFX1064-NEXT:  .LBB10_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s50, -1
; GFX1032-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-NEXT:    s_mov_b32 s43, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s42, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s33, s10
; GFX1032-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v41, 0
; GFX1032-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s46, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB10_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1032-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-NEXT:    s_cbranch_execnz .LBB10_4
; GFX1032-NEXT:  .LBB10_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s43, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s42, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    s_mov_b32 s33, s10
; GFX1164-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    s_mov_b32 s32, 32
; GFX1164-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v41, 0
; GFX1164-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB10_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-NEXT:    .p2align 6
; GFX1164-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-NEXT:    s_cbranch_execnz .LBB10_4
; GFX1164-NEXT:  .LBB10_5:
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1132-NEXT:    s_mov_b32 s42, s14
; GFX1132-NEXT:    s_mov_b32 s43, s13
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 32
; GFX1132-NEXT:    s_mov_b32 s33, s15
; GFX1132-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    v_mov_b32_e32 v41, 0
; GFX1132-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB10_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB10_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s46, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB10_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-NEXT:    .p2align 6
; GFX1132-NEXT:  .LBB10_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-NEXT:    s_mov_b32 s12, s43
; GFX1132-NEXT:    s_mov_b32 s13, s42
; GFX1132-NEXT:    s_mov_b32 s14, s33
; GFX1132-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-NEXT:    s_cbranch_execnz .LBB10_4
; GFX1132-NEXT:  .LBB10_5:
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s47, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s46, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v42, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v42
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v41, v1
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[0:1], off, s[44:47], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-DPP-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[0:1], v[40:41]
; GFX7LESS-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v42
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB10_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s52, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s53, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s54, -1
; GFX9-DPP-NEXT:    s_mov_b32 s55, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s52, s52, s11
; GFX9-DPP-NEXT:    s_addc_u32 s53, s53, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s43, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_mov_b32 s42, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b32 s33, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[52:53]
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[54:55]
; GFX9-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v11, v9, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s45, v9, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s44, v8, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[46:47], s[36:37], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[48:49], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[46:47]
; GFX9-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], s[44:45]
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[52:53]
; GFX9-DPP-NEXT:    buffer_store_dword v2, off, s[52:55], 0 offset:4
; GFX9-DPP-NEXT:    buffer_store_dword v1, off, s[52:55], 0
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    buffer_store_dword v4, off, s[52:55], 0 offset:12
; GFX9-DPP-NEXT:    buffer_store_dword v3, off, s[52:55], 0 offset:8
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[54:55]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s46
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s47
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    buffer_load_dword v1, off, s[52:55], 0
; GFX9-DPP-NEXT:    buffer_load_dword v2, off, s[52:55], 0 offset:4
; GFX9-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-DPP-NEXT:    s_or_b64 s[48:49], vcc, s[48:49]
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[48:49]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX9-DPP-NEXT:  .LBB10_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v9, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v8, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v9, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v8, 32
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], s[2:3], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1064-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_clause 0x1
; GFX1064-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1064-DPP-NEXT:  .LBB10_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1032-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1032-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_clause 0x1
; GFX1032-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1032-DPP-NEXT:  .LBB10_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_permlane64_b32 v11, v9
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v10, v8
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v1
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-DPP-NEXT:    .p2align 6
; GFX1164-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1164-DPP-NEXT:  .LBB10_3:
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_align4_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b32 s42, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s43, s13
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1132-DPP-NEXT:    s_mov_b32 s33, s15
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v41, v8
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1132-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v1
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB10_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-DPP-NEXT:    .p2align 6
; GFX1132-DPP-NEXT:  .LBB10_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB10_2
; GFX1132-DPP-NEXT:  .LBB10_3:
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.float.value()
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %divValue syncscope("agent") monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB11_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[2:3]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s8
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s9
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB11_2
; GFX7LESS-NEXT:  .LBB11_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-NEXT:    s_add_u32 s12, s12, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB11_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB11_2
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB11_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s3, 0x43300000
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1064-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    v_mov_b32_e32 v3, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1064-NEXT:  .LBB11_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s14, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB11_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s6, s0
; GFX1032-NEXT:    s_mov_b32 s7, 0x43300000
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[6:7]
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1032-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v2, s4
; GFX1032-NEXT:    v_mov_b32_e32 v3, s5
; GFX1032-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1032-NEXT:  .LBB11_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB11_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1164-NEXT:  .LBB11_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB11_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1132-NEXT:  .LBB11_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s6, s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX7LESS-DPP-NEXT:  .LBB11_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s14, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX9-DPP-NEXT:  .LBB11_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b32 s3, 0x43300000
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1064-DPP-NEXT:  .LBB11_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s6, s0
; GFX1032-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[6:7]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX1032-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1032-DPP-NEXT:  .LBB11_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1164-DPP-NEXT:  .LBB11_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_one_as_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB11_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-DPP-NEXT:  .LBB11_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB11_2
; GFX1132-DPP-NEXT:  .LBB11_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double 4.0 syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX7LESS-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB12_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB12_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB12_4
; GFX7LESS-NEXT:  .LBB12_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB12_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB12_4
; GFX9-NEXT:  .LBB12_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB12_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1064-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB12_4
; GFX1064-NEXT:  .LBB12_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB12_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1032-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB12_4
; GFX1032-NEXT:  .LBB12_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB12_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB12_4
; GFX1164-NEXT:  .LBB12_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB12_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB12_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB12_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB12_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB12_4
; GFX1132-NEXT:  .LBB12_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[4:5], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[4:5]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB12_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[9:10], v[11:12], s[0:1]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX9-DPP-NEXT:  .LBB12_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], s[2:3], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1064-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1064-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[9:10]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX1064-DPP-NEXT:  .LBB12_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1032-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1032-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[9:10]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX1032-DPP-NEXT:  .LBB12_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX1164-DPP-NEXT:  .LBB12_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_one_as_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB12_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB12_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB12_2
; GFX1132-DPP-NEXT:  .LBB12_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.double.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %divValue syncscope("one-as") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp(ptr addrspace(1) %ptr) #2{
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB13_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[2:3]
; GFX7LESS-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s8
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s9
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB13_2
; GFX7LESS-NEXT:  .LBB13_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-NEXT:    s_add_u32 s12, s12, s11
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB13_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB13_2
; GFX9-NEXT:  .LBB13_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB13_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX1064-NEXT:    s_mov_b32 s3, 0x43300000
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1064-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-NEXT:    v_mov_b32_e32 v3, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1064-NEXT:  .LBB13_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s14, -1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB13_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s6, s0
; GFX1032-NEXT:    s_mov_b32 s7, 0x43300000
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[6:7]
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1032-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v2, s4
; GFX1032-NEXT:    v_mov_b32_e32 v3, s5
; GFX1032-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1032-NEXT:  .LBB13_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB13_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1164-NEXT:  .LBB13_3:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB13_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1132-NEXT:  .LBB13_3:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s6, s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], s[6:7], v[0:1]
; GFX7LESS-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX7LESS-DPP-NEXT:  .LBB13_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s14, -1
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-DPP-NEXT:    s_mov_b32 s15, 0xe00000
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX9-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX9-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], s[0:1], v[0:1]
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX9-DPP-NEXT:  .LBB13_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s15, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1064-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b32 s3, 0x43300000
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1064-DPP-NEXT:  .LBB13_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, -1
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s15, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s12, s12, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s13, s13, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s6, s0
; GFX1032-DPP-NEXT:    s_mov_b32 s7, 0x43300000
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, s[6:7]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s4
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s5
; GFX1032-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-DPP-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1032-DPP-NEXT:  .LBB13_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s3
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1164-DPP-NEXT:  .LBB13_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_agent_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0x43300000 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:4
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB13_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mul_f64 v[4:5], 4.0, v[0:1]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX1132-DPP-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1132-DPP-NEXT:  .LBB13_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double 4.0 syncscope("agent") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe(ptr addrspace(1) %ptr) #0 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX7LESS-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB14_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB14_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB14_4
; GFX7LESS-NEXT:  .LBB14_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB14_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB14_4
; GFX9-NEXT:  .LBB14_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB14_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1064-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB14_4
; GFX1064-NEXT:  .LBB14_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB14_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1032-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB14_4
; GFX1032-NEXT:  .LBB14_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB14_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB14_4
; GFX1164-NEXT:  .LBB14_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB14_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB14_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB14_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB14_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB14_4
; GFX1132-NEXT:  .LBB14_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[4:5], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[4:5]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB14_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB14_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[9:10], v[11:12], s[0:1]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB14_2
; GFX9-DPP-NEXT:  .LBB14_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], s[2:3], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB14_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1064-DPP-NEXT:  .LBB14_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1064-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[9:10]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB14_2
; GFX1064-DPP-NEXT:  .LBB14_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB14_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1032-DPP-NEXT:  .LBB14_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1032-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[9:10]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB14_2
; GFX1032-DPP-NEXT:  .LBB14_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB14_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB14_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB14_2
; GFX1164-DPP-NEXT:  .LBB14_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.double.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.double.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB14_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB14_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB14_2
; GFX1132-DPP-NEXT:  .LBB14_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.double.value()
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %divValue syncscope("agent") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp(ptr addrspace(1) %ptr) #1 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-NEXT:    s_mov_b32 s39, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s36, s36, s11
; GFX7LESS-NEXT:    s_addc_u32 s37, s37, 0
; GFX7LESS-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s8, s34, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s35, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX7LESS-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB15_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB15_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[2:3], off, s[0:3], 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v9, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v8, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v6
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v7
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB15_4
; GFX7LESS-NEXT:  .LBB15_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s38, -1
; GFX9-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_add_u32 s8, s34, 44
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX9-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB15_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX9-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB15_4
; GFX9-NEXT:  .LBB15_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s38, -1
; GFX1064-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-NEXT:    s_mov_b32 s12, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s13, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s14, s10
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-NEXT:    s_mov_b32 s32, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB15_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1064-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1064-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB15_4
; GFX1064-NEXT:  .LBB15_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s38, -1
; GFX1032-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-NEXT:    s_mov_b32 s12, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s13, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s14, s10
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-NEXT:    s_mov_b32 s32, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB15_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dwordx2 v[2:3], v6, s[0:1]
; GFX1032-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1032-NEXT:    global_atomic_cmpswap_x2 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB15_4
; GFX1032-NEXT:  .LBB15_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s12, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s13, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-NEXT:    s_mov_b32 s14, s10
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b32 s32, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB15_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1164-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1164-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[2:3]
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB15_4
; GFX1164-NEXT:  .LBB15_5:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB15_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_add_f64 v[4:5], v[4:5], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB15_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s2, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB15_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[2:3], v6, s[0:1]
; GFX1132-NEXT:  .LBB15_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], v[2:3], v[4:5]
; GFX1132-NEXT:    global_atomic_cmpswap_b64 v[0:1], v6, v[0:3], s[0:1] glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[0:1], v[2:3]
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-NEXT:    s_cbranch_execnz .LBB15_4
; GFX1132-NEXT:  .LBB15_5:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s32, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s40, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s41, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s40, s40, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s41, s41, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s39, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s38, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s4, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s5, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX7LESS-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[42:43]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[4:5], off, s[36:39], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], 0
; GFX7LESS-DPP-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[0:1]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, v3
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, v2
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap_x2 v[6:9], off, s[36:39], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[4:5]
; GFX7LESS-DPP-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v6
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, v7
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB15_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s38, -1
; GFX9-DPP-NEXT:    s_mov_b32 s39, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX9-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX9-DPP-NEXT:    s_mov_b32 s13, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX9-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s14, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b32 s32, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v6, v4, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v6 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v7, v5 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[5:6], v[5:6], v[7:8]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s3, v4, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s2, v3, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB15_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[2:3], s[34:35], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[11:12], v0, s[2:3]
; GFX9-DPP-NEXT:  .LBB15_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[9:10], v[11:12], s[0:1]
; GFX9-DPP-NEXT:    global_atomic_cmpswap_x2 v[1:2], v0, v[9:12], s[2:3] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[1:2], v[11:12]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB15_2
; GFX9-DPP-NEXT:  .LBB15_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s39, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1064-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v4, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v3, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v4, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v3, 32
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], s[2:3], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v7, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v7
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB15_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1064-DPP-NEXT:  .LBB15_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1064-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[7:8], v[9:10]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB15_2
; GFX1064-DPP-NEXT:  .LBB15_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s36, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s37, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s38, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s39, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s36, s36, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s37, s37, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1032-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v4, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v6, 0x80000000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v4, v6 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[5:6], v[3:4]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v6, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v6, v4 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v6, v4, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[3:4], v[5:6]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v7, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v4
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v7
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB15_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dwordx2 v[9:10], v2, s[0:1]
; GFX1032-DPP-NEXT:  .LBB15_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[7:8], v[9:10], v[0:1]
; GFX1032-DPP-NEXT:    global_atomic_cmpswap_x2 v[7:8], v2, v[7:10], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[7:8], v[9:10]
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, v8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB15_2
; GFX1032-DPP-NEXT:  .LBB15_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1164-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    v_permlane64_b32 v5, v3
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v4, v2
; GFX1164-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB15_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1164-DPP-NEXT:  .LBB15_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1164-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[8:9]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v9, v7
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, v6
; GFX1164-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB15_2
; GFX1164-DPP-NEXT:  .LBB15_3:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_agent_scope_unsafe_structfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[4:5]
; GFX1132-DPP-NEXT:    s_add_u32 s4, s4, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s5, s5, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_load_b64 s[16:17], s[4:5], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v3, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v5, 0x80000000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v4, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v3, v5 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v2, v4 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[4:5], v[2:3]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v5, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v5, v3 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v4, v2 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v5, v3, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v4, v2, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[2:3], v[2:3], v[4:5]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, v2
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v10, 0 :: v_dual_mov_b32 v1, v3
; GFX1132-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v6
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB15_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[34:35], 0x24
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[8:9], v10, s[0:1]
; GFX1132-DPP-NEXT:  .LBB15_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[6:7], v[8:9], v[0:1]
; GFX1132-DPP-NEXT:    global_atomic_cmpswap_b64 v[6:7], v10, v[6:9], s[0:1] glc
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[6:7], v[8:9]
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v9, v7 :: v_dual_mov_b32 v8, v6
; GFX1132-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s2
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB15_2
; GFX1132-DPP-NEXT:  .LBB15_3:
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.float.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %divValue syncscope("agent") monotonic, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp(ptr addrspace(1) %ptr) #2 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v5, exec_lo, 0
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX7LESS-NEXT:    s_mov_b32 s1, 0x43300000
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0xc3300000
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v5, exec_hi, v5
; GFX7LESS-NEXT:    v_add_f64 v[3:4], s[0:1], v[3:4]
; GFX7LESS-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB16_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v3, v0, v1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-NEXT:    v_or_b32_e32 v40, v3, v2
; GFX7LESS-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB16_2
; GFX7LESS-NEXT:  .LBB16_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s50, -1
; GFX9-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-NEXT:    s_add_u32 s48, s48, s11
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xc3300000
; GFX9-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-NEXT:    v_add_f64 v[3:4], s[0:1], v[3:4]
; GFX9-NEXT:    s_movk_i32 s32, 0x800
; GFX9-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB16_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX9-NEXT:    s_mov_b32 s33, s10
; GFX9-NEXT:    s_mov_b32 s42, s9
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX9-NEXT:    s_mov_b32 s43, s8
; GFX9-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX9-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX9-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX9-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-NEXT:    s_cbranch_execnz .LBB16_2
; GFX9-NEXT:  .LBB16_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s50, -1
; GFX1064-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1064-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-NEXT:    v_add_f64 v[3:4], 0xc3300000, s[0:1]
; GFX1064-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB16_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1064-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1064-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1064-NEXT:    s_mov_b32 s33, s10
; GFX1064-NEXT:    s_mov_b32 s42, s9
; GFX1064-NEXT:    s_mov_b32 s43, s8
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1064-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1064-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1064-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v2, s1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s0
; GFX1064-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-NEXT:    s_add_u32 s8, s36, 44
; GFX1064-NEXT:    s_addc_u32 s9, s37, 0
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1064-NEXT:  .LBB16_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s50, -1
; GFX1032-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1032-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-NEXT:    s_mov_b32 s46, 0
; GFX1032-NEXT:    v_add_f64 v[3:4], 0xc3300000, s[0:1]
; GFX1032-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB16_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1032-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1032-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1032-NEXT:    s_mov_b32 s33, s10
; GFX1032-NEXT:    s_mov_b32 s42, s9
; GFX1032-NEXT:    s_mov_b32 s43, s8
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1032-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1032-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1032-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-NEXT:    s_add_u32 s8, s36, 44
; GFX1032-NEXT:    s_addc_u32 s9, s37, 0
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1032-NEXT:  .LBB16_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    s_mov_b32 s32, 32
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    scratch_store_b32 off, v0, off offset:20
; GFX1164-NEXT:    scratch_store_b32 off, v1, off offset:16
; GFX1164-NEXT:    scratch_load_b64 v[0:1], off, off offset:16
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mul_f64 v[41:42], 4.0, v[0:1]
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB16_3
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b32 s33, s10
; GFX1164-NEXT:    s_mov_b32 s42, s9
; GFX1164-NEXT:    s_mov_b32 s43, s8
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1164-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v2, s1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-NEXT:    .p2align 6
; GFX1164-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-NEXT:    s_add_u32 s8, s36, 44
; GFX1164-NEXT:    s_addc_u32 s9, s37, 0
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1164-NEXT:  .LBB16_3:
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v40, v0 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1132-NEXT:    s_mov_b32 s46, 0
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    scratch_store_b32 off, v0, off offset:20
; GFX1132-NEXT:    scratch_store_b32 off, v1, off offset:16
; GFX1132-NEXT:    scratch_load_b64 v[0:1], off, off offset:16
; GFX1132-NEXT:    s_mov_b32 s32, 32
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mul_f64 v[41:42], 4.0, v[0:1]
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB16_3
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s33, s15
; GFX1132-NEXT:    s_mov_b32 s42, s14
; GFX1132-NEXT:    s_mov_b32 s43, s13
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1132-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1132-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-NEXT:    .p2align 6
; GFX1132-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-NEXT:    s_add_u32 s8, s36, 44
; GFX1132-NEXT:    s_addc_u32 s9, s37, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1132-NEXT:    s_mov_b32 s12, s43
; GFX1132-NEXT:    s_mov_b32 s13, s42
; GFX1132-NEXT:    s_mov_b32 s14, s33
; GFX1132-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1132-NEXT:  .LBB16_3:
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v5, exec_lo, 0
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX7LESS-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, 0xc3300000
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v5, exec_hi, v5
; GFX7LESS-DPP-NEXT:    v_add_f64 v[3:4], s[0:1], v[3:4]
; GFX7LESS-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v3, v0, v1
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, s0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v40, v3, v2
; GFX7LESS-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX7LESS-DPP-NEXT:  .LBB16_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s50, -1
; GFX9-DPP-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0xc3300000
; GFX9-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], s[0:1], v[3:4]
; GFX9-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX9-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX9-DPP-NEXT:    s_mov_b32 s33, s10
; GFX9-DPP-NEXT:    s_mov_b32 s42, s9
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX9-DPP-NEXT:    s_mov_b32 s43, s8
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-DPP-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX9-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX9-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX9-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX9-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX9-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX9-DPP-NEXT:  .LBB16_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1064-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1064-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], 0xc3300000, s[0:1]
; GFX1064-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1064-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1064-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1064-DPP-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1064-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1064-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_clause 0x1
; GFX1064-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1064-DPP-NEXT:  .LBB16_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s1, 0x43300000
; GFX1032-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], 0xc3300000, s[0:1]
; GFX1032-DPP-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[3:4]
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v3
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x24
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v3, 20, v2
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v4, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1032-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1032-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1032-DPP-NEXT:    v_or3_b32 v40, v0, v4, v3
; GFX1032-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1032-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[44:45], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1032-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_clause 0x1
; GFX1032-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1032-DPP-NEXT:  .LBB16_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, exec
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1164-DPP-NEXT:    s_clause 0x1
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v0, off offset:20
; GFX1164-DPP-NEXT:    scratch_store_b32 off, v1, off offset:16
; GFX1164-DPP-NEXT:    scratch_load_b64 v[0:1], off, off offset:16
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[0:1]
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1164-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1164-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1164-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, s0
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-DPP-NEXT:    .p2align 6
; GFX1164-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1164-DPP-NEXT:  .LBB16_3:
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_uni_value_default_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v40, v0 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v0, 0x43300000
; GFX1132-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1132-DPP-NEXT:    s_clause 0x1
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v0, off offset:20
; GFX1132-DPP-NEXT:    scratch_store_b32 off, v1, off offset:16
; GFX1132-DPP-NEXT:    scratch_load_b64 v[0:1], off, off offset:16
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[0:1], 0xc3300000, v[0:1]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mul_f64 v[41:42], 4.0, v[0:1]
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB16_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[44:45], s[4:5], 0x24
; GFX1132-DPP-NEXT:    s_mov_b32 s33, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s42, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s43, s13
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX1132-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[44:45], 0x0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-DPP-NEXT:    .p2align 6
; GFX1132-DPP-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1132-DPP-NEXT:  .LBB16_3:
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double 4.0 monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp(ptr addrspace(1) %ptr) #2 {
; GFX7LESS-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v40, v0, v2
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS-NEXT:    v_mov_b32_e32 v41, 0
; GFX7LESS-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX7LESS-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX7LESS-NEXT:    v_readlane_b32 s3, v1, s4
; GFX7LESS-NEXT:    v_readlane_b32 s2, v0, s4
; GFX7LESS-NEXT:    s_lshl_b64 s[4:5], 1, s4
; GFX7LESS-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[4:5]
; GFX7LESS-NEXT:    v_cmp_ne_u64_e64 s[4:5], s[0:1], 0
; GFX7LESS-NEXT:    s_and_b64 vcc, exec, s[4:5]
; GFX7LESS-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX7LESS-NEXT:    s_cbranch_vccnz .LBB17_1
; GFX7LESS-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX7LESS-NEXT:    s_cbranch_execz .LBB17_5
; GFX7LESS-NEXT:  ; %bb.3:
; GFX7LESS-NEXT:    s_load_dwordx2 s[44:45], s[36:37], 0x9
; GFX7LESS-NEXT:    s_mov_b32 s47, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s46, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    buffer_load_dwordx2 v[0:1], off, s[44:47], 0
; GFX7LESS-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_add_f64 v[2:3], v[0:1], v[41:42]
; GFX7LESS-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-NEXT:    v_mov_b32_e32 v31, v40
; GFX7LESS-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB17_4
; GFX7LESS-NEXT:  .LBB17_5:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s50, -1
; GFX9-NEXT:    s_mov_b32 s51, 0xe00000
; GFX9-NEXT:    s_add_u32 s48, s48, s11
; GFX9-NEXT:    s_addc_u32 s49, s49, 0
; GFX9-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-NEXT:    s_mov_b32 s43, s8
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_mov_b32 s42, s9
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b32 s33, s10
; GFX9-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    s_movk_i32 s32, 0x800
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_mov_b32_e32 v41, 0
; GFX9-NEXT:    s_mov_b64 s[0:1], exec
; GFX9-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX9-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX9-NEXT:    v_readlane_b32 s3, v1, s4
; GFX9-NEXT:    v_readlane_b32 s2, v0, s4
; GFX9-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX9-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX9-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX9-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9-NEXT:    s_cbranch_execz .LBB17_5
; GFX9-NEXT:  ; %bb.3:
; GFX9-NEXT:    s_load_dwordx2 s[44:45], s[36:37], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_mov_b64 s[46:47], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX9-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX9-NEXT:    s_add_u32 s8, s36, 44
; GFX9-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-NEXT:    s_getpc_b64 s[0:1]
; GFX9-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX9-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX9-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX9-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX9-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-NEXT:    s_mov_b32 s12, s43
; GFX9-NEXT:    s_mov_b32 s13, s42
; GFX9-NEXT:    s_mov_b32 s14, s33
; GFX9-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX9-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s44
; GFX9-NEXT:    v_mov_b32_e32 v3, s45
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX9-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX9-NEXT:    s_cbranch_execnz .LBB17_4
; GFX9-NEXT:  .LBB17_5:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-NEXT:    s_mov_b32 s50, -1
; GFX1064-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-NEXT:    s_mov_b32 s43, s8
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_mov_b32 s42, s9
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1064-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-NEXT:    s_mov_b32 s33, s10
; GFX1064-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1064-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    v_mov_b32_e32 v41, 0
; GFX1064-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1064-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_ff1_i32_b64 s4, s[0:1]
; GFX1064-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1064-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1064-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1064-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1064-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1064-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064-NEXT:    s_cbranch_execz .LBB17_5
; GFX1064-NEXT:  ; %bb.3:
; GFX1064-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1064-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1064-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-NEXT:    s_mov_b32 s12, s43
; GFX1064-NEXT:    s_mov_b32 s13, s42
; GFX1064-NEXT:    s_mov_b32 s14, s33
; GFX1064-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-NEXT:    s_cbranch_execnz .LBB17_4
; GFX1064-NEXT:  .LBB17_5:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-NEXT:    s_mov_b32 s50, -1
; GFX1032-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-NEXT:    s_mov_b32 s43, s8
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_mov_b32 s42, s9
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1032-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-NEXT:    s_mov_b32 s33, s10
; GFX1032-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1032-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    v_mov_b32_e32 v41, 0
; GFX1032-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1032-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1032-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1032-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1032-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    s_mov_b32 s46, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032-NEXT:    s_cbranch_execz .LBB17_5
; GFX1032-NEXT:  ; %bb.3:
; GFX1032-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1032-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1032-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-NEXT:    s_mov_b32 s12, s43
; GFX1032-NEXT:    s_mov_b32 s13, s42
; GFX1032-NEXT:    s_mov_b32 s14, s33
; GFX1032-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-NEXT:    s_cbranch_execnz .LBB17_4
; GFX1032-NEXT:  .LBB17_5:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-NEXT:    s_mov_b32 s43, s8
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_mov_b32 s42, s9
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1164-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    s_mov_b32 s33, s10
; GFX1164-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    s_mov_b32 s32, 32
; GFX1164-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v41, 0
; GFX1164-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    s_ctz_i32_b64 s4, s[0:1]
; GFX1164-NEXT:    v_readlane_b32 s3, v1, s4
; GFX1164-NEXT:    v_readlane_b32 s2, v0, s4
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1164-NEXT:    s_lshl_b64 s[2:3], 1, s4
; GFX1164-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1164-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164-NEXT:    s_cbranch_execz .LBB17_5
; GFX1164-NEXT:  ; %bb.3:
; GFX1164-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1164-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-NEXT:    .p2align 6
; GFX1164-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-NEXT:    s_mov_b32 s12, s43
; GFX1164-NEXT:    s_mov_b32 s13, s42
; GFX1164-NEXT:    s_mov_b32 s14, s33
; GFX1164-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-NEXT:    s_cbranch_execnz .LBB17_4
; GFX1164-NEXT:  .LBB17_5:
; GFX1164-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1132-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1132-NEXT:    s_mov_b32 s42, s14
; GFX1132-NEXT:    s_mov_b32 s43, s13
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-NEXT:    s_mov_b32 s12, s13
; GFX1132-NEXT:    s_mov_b32 s13, s14
; GFX1132-NEXT:    s_mov_b32 s14, s15
; GFX1132-NEXT:    s_mov_b32 s32, 32
; GFX1132-NEXT:    s_mov_b32 s33, s15
; GFX1132-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    v_mov_b32_e32 v41, 0
; GFX1132-NEXT:    v_bfrev_b32_e32 v42, 1
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:  .LBB17_1: ; %ComputeLoop
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132-NEXT:    v_readlane_b32 s3, v1, s1
; GFX1132-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1132-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132-NEXT:    v_add_f64 v[41:42], v[41:42], s[2:3]
; GFX1132-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132-NEXT:    s_cbranch_scc1 .LBB17_1
; GFX1132-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-NEXT:    s_mov_b32 s46, 0
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132-NEXT:    s_cbranch_execz .LBB17_5
; GFX1132-NEXT:  ; %bb.3:
; GFX1132-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1132-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-NEXT:    .p2align 6
; GFX1132-NEXT:  .LBB17_4: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-NEXT:    s_mov_b32 s12, s43
; GFX1132-NEXT:    s_mov_b32 s13, s42
; GFX1132-NEXT:    s_mov_b32 s14, s33
; GFX1132-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-NEXT:    s_cbranch_execnz .LBB17_4
; GFX1132-NEXT:  .LBB17_5:
; GFX1132-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX7LESS-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s50, -1
; GFX7LESS-DPP-NEXT:    s_mov_b32 s51, 0xe8f000
; GFX7LESS-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX7LESS-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s33, s10
; GFX7LESS-DPP-NEXT:    s_mov_b32 s42, s9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s43, s8
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[44:45], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_mov_b32 s47, 0xf000
; GFX7LESS-DPP-NEXT:    s_mov_b32 s46, -1
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX7LESS-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7LESS-DPP-NEXT:    v_or_b32_e32 v42, v0, v2
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v42
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v41, v1
; GFX7LESS-DPP-NEXT:    buffer_load_dwordx2 v[0:1], off, s[44:47], 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX7LESS-DPP-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_add_f64 v[2:3], v[0:1], v[40:41]
; GFX7LESS-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    buffer_store_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX7LESS-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:12
; GFX7LESS-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:8
; GFX7LESS-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX7LESS-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX7LESS-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX7LESS-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(2)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX7LESS-DPP-NEXT:    s_mov_b32 s12, s43
; GFX7LESS-DPP-NEXT:    s_mov_b32 s13, s42
; GFX7LESS-DPP-NEXT:    s_mov_b32 s14, s33
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v31, v42
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX7LESS-DPP-NEXT:    v_and_b32_e32 v2, 1, v0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v0, off, s[48:51], 0
; GFX7LESS-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0 offset:4
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7LESS-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7LESS-DPP-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b32 s52, SCRATCH_RSRC_DWORD0
; GFX9-DPP-NEXT:    s_mov_b32 s53, SCRATCH_RSRC_DWORD1
; GFX9-DPP-NEXT:    s_mov_b32 s54, -1
; GFX9-DPP-NEXT:    s_mov_b32 s55, 0xe00000
; GFX9-DPP-NEXT:    s_add_u32 s52, s52, s11
; GFX9-DPP-NEXT:    s_addc_u32 s53, s53, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[36:37], s[4:5]
; GFX9-DPP-NEXT:    s_mov_b32 s43, s8
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_mov_b32 s42, s9
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-DPP-NEXT:    s_mov_b32 s33, s10
; GFX9-DPP-NEXT:    s_mov_b64 s[34:35], s[6:7]
; GFX9-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX9-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[52:53]
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[54:55]
; GFX9-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v11, v9, v1, s[0:1]
; GFX9-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX9-DPP-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-DPP-NEXT:    s_nop 0
; GFX9-DPP-NEXT:    v_mov_b32_dpp v13, v11 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v12, v10 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[10:11], v[10:11], v[12:13]
; GFX9-DPP-NEXT:    s_nop 1
; GFX9-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX9-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX9-DPP-NEXT:    v_readlane_b32 s45, v9, 63
; GFX9-DPP-NEXT:    v_readlane_b32 s44, v8, 63
; GFX9-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB17_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[46:47], s[36:37], 0x24
; GFX9-DPP-NEXT:    s_mov_b64 s[48:49], 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[46:47]
; GFX9-DPP-NEXT:  .LBB17_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], s[44:45]
; GFX9-DPP-NEXT:    s_add_u32 s8, s36, 44
; GFX9-DPP-NEXT:    s_addc_u32 s9, s37, 0
; GFX9-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX9-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX9-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX9-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX9-DPP-NEXT:    s_mov_b64 s[0:1], s[52:53]
; GFX9-DPP-NEXT:    buffer_store_dword v2, off, s[52:55], 0 offset:4
; GFX9-DPP-NEXT:    buffer_store_dword v1, off, s[52:55], 0
; GFX9-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX9-DPP-NEXT:    buffer_store_dword v4, off, s[52:55], 0 offset:12
; GFX9-DPP-NEXT:    buffer_store_dword v3, off, s[52:55], 0 offset:8
; GFX9-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX9-DPP-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GFX9-DPP-NEXT:    s_mov_b32 s12, s43
; GFX9-DPP-NEXT:    s_mov_b32 s13, s42
; GFX9-DPP-NEXT:    s_mov_b32 s14, s33
; GFX9-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], s[54:55]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v2, s46
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, s47
; GFX9-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-DPP-NEXT:    buffer_load_dword v1, off, s[52:55], 0
; GFX9-DPP-NEXT:    buffer_load_dword v2, off, s[52:55], 0 offset:4
; GFX9-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-DPP-NEXT:    s_or_b64 s[48:49], vcc, s[48:49]
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[48:49]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB17_2
; GFX9-DPP-NEXT:  .LBB17_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1064-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1064-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1064-DPP-NEXT:    s_mov_b32 s51, 0x31e16000
; GFX1064-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1064-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1064-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1064-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1064-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1064-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1064-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1064-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    s_movk_i32 s32, 0x800
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s[0:1]
; GFX1064-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1064-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1064-DPP-NEXT:    v_readlane_b32 s3, v9, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s2, v8, 0
; GFX1064-DPP-NEXT:    v_readlane_b32 s5, v9, 32
; GFX1064-DPP-NEXT:    v_readlane_b32 s4, v8, 32
; GFX1064-DPP-NEXT:    v_add_f64 v[8:9], s[2:3], s[4:5]
; GFX1064-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB17_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1064-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1064-DPP-NEXT:  .LBB17_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1064-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1064-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1064-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1064-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1064-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1064-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1064-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1064-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1064-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1064-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1064-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1064-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1064-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1064-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1064-DPP-NEXT:    s_clause 0x1
; GFX1064-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1064-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1064-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[46:47]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB17_2
; GFX1064-DPP-NEXT:  .LBB17_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s48, SCRATCH_RSRC_DWORD0
; GFX1032-DPP-NEXT:    s_mov_b32 s49, SCRATCH_RSRC_DWORD1
; GFX1032-DPP-NEXT:    s_mov_b32 s50, -1
; GFX1032-DPP-NEXT:    s_mov_b32 s51, 0x31c16000
; GFX1032-DPP-NEXT:    s_add_u32 s48, s48, s11
; GFX1032-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1032-DPP-NEXT:    s_addc_u32 s49, s49, 0
; GFX1032-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX1032-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1032-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1032-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1032-DPP-NEXT:    v_or3_b32 v40, v0, v1, v2
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    s_movk_i32 s32, 0x400
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s0
; GFX1032-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1032-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1032-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1032-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1032-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB17_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[44:45], s[34:35], 0x24
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    global_load_dwordx2 v[1:2], v0, s[44:45]
; GFX1032-DPP-NEXT:  .LBB17_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1032-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1032-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1032-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1032-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1032-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1032-DPP-NEXT:    buffer_store_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    buffer_store_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[16:17], s[0:1], 0x0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032-DPP-NEXT:    s_mov_b64 s[0:1], s[48:49]
; GFX1032-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1032-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1032-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1032-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1032-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1032-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1032-DPP-NEXT:    s_mov_b64 s[2:3], s[50:51]
; GFX1032-DPP-NEXT:    buffer_store_dword v4, off, s[48:51], 0 offset:12
; GFX1032-DPP-NEXT:    buffer_store_dword v3, off, s[48:51], 0 offset:8
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX1032-DPP-NEXT:    s_clause 0x1
; GFX1032-DPP-NEXT:    buffer_load_dword v1, off, s[48:51], 0
; GFX1032-DPP-NEXT:    buffer_load_dword v2, off, s[48:51], 0 offset:4
; GFX1032-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s46
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB17_2
; GFX1032-DPP-NEXT:  .LBB17_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1164-DPP-NEXT:    s_mov_b32 s43, s8
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_mov_b32 s42, s9
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    s_mov_b32 s33, s10
; GFX1164-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1164-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s[0:1]
; GFX1164-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1164-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    v_permlane64_b32 v11, v9
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_permlane64_b32 v10, v8
; GFX1164-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1164-DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v41, v8
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_waitcnt_depctr 0xfffe
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v1
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB17_3
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1164-DPP-NEXT:    s_mov_b64 s[46:47], 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-DPP-NEXT:    .p2align 6
; GFX1164-DPP-NEXT:  .LBB17_2: ; %atomicrmw.start
; GFX1164-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1164-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1164-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1164-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1164-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1164-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1164-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v31, v40
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v0, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v2, s44
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v5, 8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1164-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1164-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1164-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1164-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1164-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1164-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1164-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v3, s45
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1164-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1164-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1164-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX1164-DPP-NEXT:    s_or_b64 s[46:47], vcc, s[46:47]
; GFX1164-DPP-NEXT:    s_and_not1_b64 exec, exec, s[46:47]
; GFX1164-DPP-NEXT:    s_cbranch_execnz .LBB17_2
; GFX1164-DPP-NEXT:  .LBB17_3:
; GFX1164-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_double_uni_address_div_value_default_scope_strictfp:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b64 s[34:35], s[4:5]
; GFX1132-DPP-NEXT:    s_mov_b64 s[40:41], s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, div.float.value@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, div.float.value@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v31, v0
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    s_mov_b64 s[36:37], s[6:7]
; GFX1132-DPP-NEXT:    s_mov_b32 s42, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s43, s13
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s13
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s14
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s15
; GFX1132-DPP-NEXT:    s_mov_b32 s32, 32
; GFX1132-DPP-NEXT:    s_mov_b32 s33, s15
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v40, v0
; GFX1132-DPP-NEXT:    s_mov_b64 s[38:39], s[2:3]
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v9, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v11, 0x80000000, v1, s0
; GFX1132-DPP-NEXT:    v_cndmask_b32_e64 v10, 0, v0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v9, v11 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v8, v10 row_xmask:1 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[10:11], v[8:9]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:2 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:4 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v10, 0
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v11, v9 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_mov_b32_dpp v10, v8 row_xmask:8 row_mask:0xf bank_mask:0xf
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v11, v9, 0, 0
; GFX1132-DPP-NEXT:    v_permlanex16_b32 v10, v8, 0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_add_f64 v[8:9], v[8:9], v[10:11]
; GFX1132-DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v41, v8
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v42, v9
; GFX1132-DPP-NEXT:    s_mov_b32 s46, 0
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v1
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB17_3
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[44:45], s[34:35], 0x24
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_load_b64 v[1:2], v0, s[44:45]
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-DPP-NEXT:    .p2align 6
; GFX1132-DPP-NEXT:  .LBB17_2: ; %atomicrmw.start
; GFX1132-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-DPP-NEXT:    v_add_f64 v[3:4], v[1:2], v[41:42]
; GFX1132-DPP-NEXT:    s_add_u32 s8, s34, 44
; GFX1132-DPP-NEXT:    s_addc_u32 s9, s35, 0
; GFX1132-DPP-NEXT:    s_getpc_b64 s[0:1]
; GFX1132-DPP-NEXT:    s_add_u32 s0, s0, __atomic_compare_exchange@gotpcrel32@lo+4
; GFX1132-DPP-NEXT:    s_addc_u32 s1, s1, __atomic_compare_exchange@gotpcrel32@hi+12
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[1:2], off
; GFX1132-DPP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v31, v40 :: v_dual_mov_b32 v0, 8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v2, s44
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v5, 8 :: v_dual_mov_b32 v6, 0
; GFX1132-DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1132-DPP-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GFX1132-DPP-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GFX1132-DPP-NEXT:    s_mov_b64 s[10:11], s[36:37]
; GFX1132-DPP-NEXT:    s_mov_b32 s12, s43
; GFX1132-DPP-NEXT:    s_mov_b32 s13, s42
; GFX1132-DPP-NEXT:    s_mov_b32 s14, s33
; GFX1132-DPP-NEXT:    scratch_store_b64 off, v[3:4], off offset:8
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v3, s45 :: v_dual_mov_b32 v4, 0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX1132-DPP-NEXT:    scratch_load_b64 v[1:2], off, off
; GFX1132-DPP-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX1132-DPP-NEXT:    s_or_b32 s46, vcc_lo, s46
; GFX1132-DPP-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s46
; GFX1132-DPP-NEXT:    s_cbranch_execnz .LBB17_2
; GFX1132-DPP-NEXT:  .LBB17_3:
; GFX1132-DPP-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-DPP-NEXT:    s_endpgm
  %divValue = call double @div.float.value() strictfp
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %divValue monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr addrspace(1) %ptr) {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB18_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB18_2
; GFX7LESS-NEXT:  .LBB18_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB18_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB18_2
; GFX9-NEXT:  .LBB18_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB18_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB18_2
; GFX1064-NEXT:  .LBB18_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB18_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB18_2
; GFX1032-NEXT:  .LBB18_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB18_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-NEXT:  .LBB18_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB18_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-NEXT:  .LBB18_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB18_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB18_2
; GFX7LESS-DPP-NEXT:  .LBB18_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB18_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB18_2
; GFX9-DPP-NEXT:  .LBB18_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB18_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-DPP-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB18_2
; GFX1064-DPP-NEXT:  .LBB18_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB18_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-DPP-NEXT:  .LBB18_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB18_2
; GFX1032-DPP-NEXT:  .LBB18_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-DPP-NEXT:  .LBB18_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_ignore_denormal_mode__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB18_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-DPP-NEXT:  .LBB18_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0  monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.no.remote.memory !1, !amdgpu.ignore.denormal.mode !1
  ret void
}

define amdgpu_kernel void @global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory(ptr addrspace(1) %ptr) {
; GFX7LESS-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB19_3
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB19_2
; GFX7LESS-NEXT:  .LBB19_3:
; GFX7LESS-NEXT:    s_endpgm
;
; GFX9-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB19_3
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB19_2
; GFX9-NEXT:  .LBB19_3:
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB19_3
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB19_2
; GFX1064-NEXT:  .LBB19_3:
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-NEXT:    s_mov_b32 s2, 0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB19_3
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-NEXT:    s_cbranch_execnz .LBB19_2
; GFX1032-NEXT:  .LBB19_3:
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB19_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-NEXT:  .LBB19_2:
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB19_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-NEXT:  .LBB19_2:
; GFX1132-NEXT:    s_endpgm
;
; GFX7LESS-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX7LESS-DPP:       ; %bb.0:
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX7LESS-DPP-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s2, 0
; GFX7LESS-DPP-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s3, v0
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7LESS-DPP-NEXT:    s_cbranch_execz .LBB19_3
; GFX7LESS-DPP-NEXT:  ; %bb.1:
; GFX7LESS-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7LESS-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX7LESS-DPP-NEXT:    s_mov_b64 s[4:5], 0
; GFX7LESS-DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX7LESS-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX7LESS-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-DPP-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-DPP-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX7LESS-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7LESS-DPP-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v4, v1
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v3, v0
; GFX7LESS-DPP-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7LESS-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7LESS-DPP-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7LESS-DPP-NEXT:    v_mov_b32_e32 v1, v3
; GFX7LESS-DPP-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7LESS-DPP-NEXT:    s_cbranch_execnz .LBB19_2
; GFX7LESS-DPP-NEXT:  .LBB19_3:
; GFX7LESS-DPP-NEXT:    s_endpgm
;
; GFX9-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX9-DPP:       ; %bb.0:
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX9-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX9-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9-DPP-NEXT:    s_cbranch_execz .LBB19_3
; GFX9-DPP-NEXT:  ; %bb.1:
; GFX9-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DPP-NEXT:    s_bcnt1_i32_b64 s5, s[2:3]
; GFX9-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s5
; GFX9-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX9-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-DPP-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX9-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX9-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX9-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX9-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-DPP-NEXT:    s_cbranch_execnz .LBB19_2
; GFX9-DPP-NEXT:  .LBB19_3:
; GFX9-DPP-NEXT:    s_endpgm
;
; GFX1064-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1064-DPP:       ; %bb.0:
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s2, 0
; GFX1064-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s3, v0
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-DPP-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064-DPP-NEXT:    s_cbranch_execz .LBB19_3
; GFX1064-DPP-NEXT:  ; %bb.1:
; GFX1064-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064-DPP-NEXT:    s_bcnt1_i32_b64 s2, s[2:3]
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s2
; GFX1064-DPP-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1064-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-DPP-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX1064-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1064-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1064-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-DPP-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX1064-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1064-DPP-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-DPP-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-DPP-NEXT:    s_cbranch_execnz .LBB19_2
; GFX1064-DPP-NEXT:  .LBB19_3:
; GFX1064-DPP-NEXT:    s_endpgm
;
; GFX1032-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1032-DPP:       ; %bb.0:
; GFX1032-DPP-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032-DPP-NEXT:    s_mov_b32 s2, 0
; GFX1032-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s3, 0
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-DPP-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032-DPP-NEXT:    s_cbranch_execz .LBB19_3
; GFX1032-DPP-NEXT:  ; %bb.1:
; GFX1032-DPP-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032-DPP-NEXT:    s_bcnt1_i32_b32 s3, s3
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s3
; GFX1032-DPP-NEXT:    v_mul_f32_e32 v2, 4.0, v0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1032-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-DPP-NEXT:  .LBB19_2: ; %atomicrmw.start
; GFX1032-DPP-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-DPP-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX1032-DPP-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX1032-DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX1032-DPP-NEXT:    v_mov_b32_e32 v1, v0
; GFX1032-DPP-NEXT:    s_or_b32 s2, vcc_lo, s2
; GFX1032-DPP-NEXT:    s_andn2_b32 exec_lo, exec_lo, s2
; GFX1032-DPP-NEXT:    s_cbranch_execnz .LBB19_2
; GFX1032-DPP-NEXT:  .LBB19_3:
; GFX1032-DPP-NEXT:    s_endpgm
;
; GFX1164-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1164-DPP:       ; %bb.0:
; GFX1164-DPP-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164-DPP-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX1164-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1164-DPP-NEXT:  ; %bb.1:
; GFX1164-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1164-DPP-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX1164-DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1164-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-DPP-NEXT:    v_mul_f32_e32 v0, 4.0, v0
; GFX1164-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1164-DPP-NEXT:  .LBB19_2:
; GFX1164-DPP-NEXT:    s_endpgm
;
; GFX1132-DPP-LABEL: global_atomic_fadd_uni_address_uni_value_system_scope__amdgpu_no_fine_grained_memory__amdgpu_no_remote_memory:
; GFX1132-DPP:       ; %bb.0:
; GFX1132-DPP-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132-DPP-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132-DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-DPP-NEXT:    s_cbranch_execz .LBB19_2
; GFX1132-DPP-NEXT:  ; %bb.1:
; GFX1132-DPP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132-DPP-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX1132-DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-DPP-NEXT:    v_cvt_f32_ubyte0_e32 v0, s0
; GFX1132-DPP-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mul_f32 v0, 4.0, v0
; GFX1132-DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-DPP-NEXT:    global_atomic_add_f32 v1, v0, s[2:3]
; GFX1132-DPP-NEXT:  .LBB19_2:
; GFX1132-DPP-NEXT:    s_endpgm
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float 4.0  monotonic, align 4, !amdgpu.no.fine.grained.memory !1, !amdgpu.no.remote.memory !1
  ret void
}

attributes #0 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign"  }
attributes #1 = { strictfp "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #2 = { strictfp }

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"amdhsa_code_object_version", i32 500}
!1 = !{}
