; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 -mattr=-bf16 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+bf16 | FileCheck %s --check-prefixes=CHECK,CHECK-BF16

define <8 x bfloat> @add_h(<8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-CVT-LABEL: add_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    shll2 v3.4s, v1.8h, #16
; CHECK-CVT-NEXT:    shll2 v4.4s, v0.8h, #16
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fadd v3.4s, v4.4s, v3.4s
; CHECK-CVT-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    and v2.16b, v5.16b, v2.16b
; CHECK-CVT-NEXT:    movi v1.4s, #127, msl #8
; CHECK-CVT-NEXT:    fcmeq v5.4s, v3.4s, v3.4s
; CHECK-CVT-NEXT:    add v4.4s, v3.4s, v2.4s
; CHECK-CVT-NEXT:    orr v3.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v2.4s, v0.4s, v2.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v1.4s
; CHECK-CVT-NEXT:    add v1.4s, v2.4s, v1.4s
; CHECK-CVT-NEXT:    mov v2.16b, v5.16b
; CHECK-CVT-NEXT:    bsl v2.16b, v4.16b, v3.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: add_h:
; CHECK-BF16:       // %bb.0: // %entry
; CHECK-BF16-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll2 v1.4s, v1.8h, #16
; CHECK-BF16-NEXT:    shll2 v0.4s, v0.8h, #16
; CHECK-BF16-NEXT:    fadd v2.4s, v3.4s, v2.4s
; CHECK-BF16-NEXT:    fadd v1.4s, v0.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
entry:
  %0 = fadd <8 x bfloat> %a, %b
  ret <8 x bfloat> %0
}


define <8 x bfloat> @sub_h(<8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-CVT-LABEL: sub_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    shll2 v3.4s, v1.8h, #16
; CHECK-CVT-NEXT:    shll2 v4.4s, v0.8h, #16
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fsub v3.4s, v4.4s, v3.4s
; CHECK-CVT-NEXT:    fsub v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    and v2.16b, v5.16b, v2.16b
; CHECK-CVT-NEXT:    movi v1.4s, #127, msl #8
; CHECK-CVT-NEXT:    fcmeq v5.4s, v3.4s, v3.4s
; CHECK-CVT-NEXT:    add v4.4s, v3.4s, v2.4s
; CHECK-CVT-NEXT:    orr v3.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v2.4s, v0.4s, v2.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v1.4s
; CHECK-CVT-NEXT:    add v1.4s, v2.4s, v1.4s
; CHECK-CVT-NEXT:    mov v2.16b, v5.16b
; CHECK-CVT-NEXT:    bsl v2.16b, v4.16b, v3.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sub_h:
; CHECK-BF16:       // %bb.0: // %entry
; CHECK-BF16-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll2 v1.4s, v1.8h, #16
; CHECK-BF16-NEXT:    shll2 v0.4s, v0.8h, #16
; CHECK-BF16-NEXT:    fsub v2.4s, v3.4s, v2.4s
; CHECK-BF16-NEXT:    fsub v1.4s, v0.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
entry:
  %0 = fsub <8 x bfloat> %a, %b
  ret <8 x bfloat> %0
}


define <8 x bfloat> @mul_h(<8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-CVT-LABEL: mul_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    shll2 v3.4s, v1.8h, #16
; CHECK-CVT-NEXT:    shll2 v4.4s, v0.8h, #16
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-CVT-NEXT:    fmul v3.4s, v4.4s, v3.4s
; CHECK-CVT-NEXT:    fmul v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    and v2.16b, v5.16b, v2.16b
; CHECK-CVT-NEXT:    movi v1.4s, #127, msl #8
; CHECK-CVT-NEXT:    fcmeq v5.4s, v3.4s, v3.4s
; CHECK-CVT-NEXT:    add v4.4s, v3.4s, v2.4s
; CHECK-CVT-NEXT:    orr v3.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v2.4s, v0.4s, v2.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v1.4s
; CHECK-CVT-NEXT:    add v1.4s, v2.4s, v1.4s
; CHECK-CVT-NEXT:    mov v2.16b, v5.16b
; CHECK-CVT-NEXT:    bsl v2.16b, v4.16b, v3.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: mul_h:
; CHECK-BF16:       // %bb.0: // %entry
; CHECK-BF16-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll2 v1.4s, v1.8h, #16
; CHECK-BF16-NEXT:    shll2 v0.4s, v0.8h, #16
; CHECK-BF16-NEXT:    fmul v2.4s, v3.4s, v2.4s
; CHECK-BF16-NEXT:    fmul v1.4s, v0.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
entry:
  %0 = fmul <8 x bfloat> %a, %b
  ret <8 x bfloat> %0
}


define <8 x bfloat> @div_h(<8 x bfloat> %a, <8 x bfloat> %b) {
; CHECK-CVT-LABEL: div_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    shll2 v2.4s, v1.8h, #16
; CHECK-CVT-NEXT:    shll2 v3.4s, v0.8h, #16
; CHECK-CVT-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-CVT-NEXT:    movi v4.4s, #127, msl #8
; CHECK-CVT-NEXT:    fdiv v2.4s, v3.4s, v2.4s
; CHECK-CVT-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-CVT-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-CVT-NEXT:    fdiv v1.4s, v3.4s, v1.4s
; CHECK-CVT-NEXT:    movi v3.4s, #1
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v3.16b
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-CVT-NEXT:    fcmeq v4.4s, v2.4s, v2.4s
; CHECK-CVT-NEXT:    add v3.4s, v2.4s, v0.4s
; CHECK-CVT-NEXT:    orr v2.4s, #64, lsl #16
; CHECK-CVT-NEXT:    fcmeq v5.4s, v1.4s, v1.4s
; CHECK-CVT-NEXT:    add v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    orr v1.4s, #64, lsl #16
; CHECK-CVT-NEXT:    bit v2.16b, v3.16b, v4.16b
; CHECK-CVT-NEXT:    bif v0.16b, v1.16b, v5.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: div_h:
; CHECK-BF16:       // %bb.0: // %entry
; CHECK-BF16-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-BF16-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-BF16-NEXT:    shll2 v1.4s, v1.8h, #16
; CHECK-BF16-NEXT:    shll2 v0.4s, v0.8h, #16
; CHECK-BF16-NEXT:    fdiv v2.4s, v3.4s, v2.4s
; CHECK-BF16-NEXT:    fdiv v1.4s, v0.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
entry:
  %0 = fdiv <8 x bfloat> %a, %b
  ret <8 x bfloat> %0
}


define <8 x bfloat> @load_h(ptr %a) {
; CHECK-LABEL: load_h:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ret
entry:
  %0 = load <8 x bfloat>, ptr %a, align 4
  ret <8 x bfloat> %0
}


define void @store_h(ptr %a, <8 x bfloat> %b) {
; CHECK-LABEL: store_h:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
entry:
  store <8 x bfloat> %b, ptr %a, align 4
  ret void
}

define <8 x bfloat> @s_to_h(<8 x float> %a) {
; CHECK-CVT-LABEL: s_to_h:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    movi v3.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v4.4s, v1.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    and v4.16b, v4.16b, v2.16b
; CHECK-CVT-NEXT:    add v6.4s, v1.4s, v3.4s
; CHECK-CVT-NEXT:    and v2.16b, v5.16b, v2.16b
; CHECK-CVT-NEXT:    add v3.4s, v0.4s, v3.4s
; CHECK-CVT-NEXT:    fcmeq v5.4s, v1.4s, v1.4s
; CHECK-CVT-NEXT:    orr v1.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v6.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v2.4s, v2.4s, v3.4s
; CHECK-CVT-NEXT:    bit v1.16b, v4.16b, v5.16b
; CHECK-CVT-NEXT:    bit v0.16b, v2.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v1.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: s_to_h:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = fptrunc <8 x float> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <8 x bfloat> @d_to_h(<8 x double> %a) {
; CHECK-CVT-LABEL: d_to_h:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtxn v2.2s, v2.2d
; CHECK-CVT-NEXT:    fcvtxn v0.2s, v0.2d
; CHECK-CVT-NEXT:    fcvtxn2 v2.4s, v3.2d
; CHECK-CVT-NEXT:    fcvtxn2 v0.4s, v1.2d
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v3.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v4.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    add v6.4s, v2.4s, v3.4s
; CHECK-CVT-NEXT:    add v3.4s, v0.4s, v3.4s
; CHECK-CVT-NEXT:    and v4.16b, v4.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    fcmeq v5.4s, v2.4s, v2.4s
; CHECK-CVT-NEXT:    orr v2.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v6.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v3.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    bit v2.16b, v4.16b, v5.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: d_to_h:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    fcvtxn v0.2s, v0.2d
; CHECK-BF16-NEXT:    fcvtxn v2.2s, v2.2d
; CHECK-BF16-NEXT:    fcvtxn2 v0.4s, v1.2d
; CHECK-BF16-NEXT:    fcvtxn2 v2.4s, v3.2d
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v2.4s
; CHECK-BF16-NEXT:    ret
  %1 = fptrunc <8 x double> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <8 x float> @h_to_s(<8 x bfloat> %a) {
; CHECK-LABEL: h_to_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll2 v1.4s, v0.8h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    ret
  %1 = fpext <8 x bfloat> %a to <8 x float>
  ret <8 x float> %1
}

define <8 x double> @h_to_d(<8 x bfloat> %a) {
; CHECK-LABEL: h_to_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll v1.4s, v0.4h, #16
; CHECK-NEXT:    shll2 v2.4s, v0.8h, #16
; CHECK-NEXT:    fcvtl v0.2d, v1.2s
; CHECK-NEXT:    fcvtl2 v3.2d, v2.4s
; CHECK-NEXT:    fcvtl2 v1.2d, v1.4s
; CHECK-NEXT:    fcvtl v2.2d, v2.2s
; CHECK-NEXT:    ret
  %1 = fpext <8 x bfloat> %a to <8 x double>
  ret <8 x double> %1
}


define <8 x bfloat> @bitcast_i_to_h(float, <8 x i16> %a) {
; CHECK-LABEL: bitcast_i_to_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = bitcast <8 x i16> %a to <8 x bfloat>
  ret <8 x bfloat> %2
}

define <8 x i16> @bitcast_h_to_i(float, <8 x bfloat> %a) {
; CHECK-LABEL: bitcast_h_to_i:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = bitcast <8 x bfloat> %a to <8 x i16>
  ret <8 x i16> %2
}

define <4 x bfloat> @sitofp_v4i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v4i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v2.4s, v0.4s, #16
; CHECK-CVT-NEXT:    and v1.16b, v2.16b, v1.16b
; CHECK-CVT-NEXT:    movi v2.4s, #127, msl #8
; CHECK-CVT-NEXT:    add v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v0.4s, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_v4i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-BF16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-BF16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-BF16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <4 x i8> %a to <4 x bfloat>
  ret <4 x bfloat> %1
}

define <8 x bfloat> @sitofp_v8i8(<8 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v8i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v4.4s, #127, msl #8
; CHECK-CVT-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-CVT-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    scvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    scvtf v3.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v0.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v4.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v2.4s, v0.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v3.4s, v1.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_v8i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-BF16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-BF16-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-BF16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v1.4s
; CHECK-BF16-NEXT:    scvtf v1.4s, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <8 x i8> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <16 x bfloat> @sitofp_v16i8(<16 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_v16i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll2 v2.8h, v0.16b, #0
; CHECK-CVT-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v7.4s, #127, msl #8
; CHECK-CVT-NEXT:    sshll v3.4s, v2.4h, #0
; CHECK-CVT-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-CVT-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-CVT-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    scvtf v3.4s, v3.4s
; CHECK-CVT-NEXT:    scvtf v4.4s, v4.4s
; CHECK-CVT-NEXT:    scvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    scvtf v6.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    ushr v0.4s, v4.4s, #16
; CHECK-CVT-NEXT:    ushr v16.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v17.4s, v6.4s, #16
; CHECK-CVT-NEXT:    and v5.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v16.16b, v16.16b, v1.16b
; CHECK-CVT-NEXT:    and v17.16b, v17.16b, v1.16b
; CHECK-CVT-NEXT:    add v5.4s, v5.4s, v7.4s
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v7.4s
; CHECK-CVT-NEXT:    addhn v1.4h, v3.4s, v5.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v4.4s, v0.4s
; CHECK-CVT-NEXT:    add v3.4s, v16.4s, v7.4s
; CHECK-CVT-NEXT:    add v4.4s, v17.4s, v7.4s
; CHECK-CVT-NEXT:    addhn2 v1.8h, v2.4s, v3.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v6.4s, v4.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_v16i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-BF16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-BF16-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-BF16-NEXT:    sshll v3.4s, v0.4h, #0
; CHECK-BF16-NEXT:    sshll2 v4.4s, v1.8h, #0
; CHECK-BF16-NEXT:    sshll2 v5.4s, v0.8h, #0
; CHECK-BF16-NEXT:    scvtf v2.4s, v2.4s
; CHECK-BF16-NEXT:    scvtf v3.4s, v3.4s
; CHECK-BF16-NEXT:    bfcvtn v1.4h, v2.4s
; CHECK-BF16-NEXT:    scvtf v2.4s, v4.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v3.4s
; CHECK-BF16-NEXT:    scvtf v3.4s, v5.4s
; CHECK-BF16-NEXT:    bfcvtn2 v1.8h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v3.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <16 x i8> %a to <16 x bfloat>
  ret <16 x bfloat> %1
}

define <8 x bfloat> @sitofp_i16(<8 x i16> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-CVT-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v4.4s, #127, msl #8
; CHECK-CVT-NEXT:    scvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    scvtf v3.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v0.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v4.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v2.4s, v0.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v3.4s, v1.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_i16:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-BF16-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-BF16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v1.4s
; CHECK-BF16-NEXT:    scvtf v1.4s, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <8 x i16> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <8 x bfloat> @sitofp_i32(<8 x i32> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    scvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    movi v5.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v3.4s, v0.4s, #16
; CHECK-CVT-NEXT:    ushr v4.4s, v1.4s, #16
; CHECK-CVT-NEXT:    and v3.16b, v3.16b, v2.16b
; CHECK-CVT-NEXT:    and v2.16b, v4.16b, v2.16b
; CHECK-CVT-NEXT:    add v0.4s, v3.4s, v0.4s
; CHECK-CVT-NEXT:    add v1.4s, v2.4s, v1.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v0.4s, v5.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v1.4s, v5.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_i32:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-BF16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <8 x i32> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}


define <8 x bfloat> @sitofp_i64(<8 x i64> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i64:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    scvtf v2.2d, v2.2d
; CHECK-CVT-NEXT:    scvtf v0.2d, v0.2d
; CHECK-CVT-NEXT:    scvtf v3.2d, v3.2d
; CHECK-CVT-NEXT:    scvtf v1.2d, v1.2d
; CHECK-CVT-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-CVT-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-CVT-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-CVT-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v3.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v4.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    add v6.4s, v2.4s, v3.4s
; CHECK-CVT-NEXT:    add v3.4s, v0.4s, v3.4s
; CHECK-CVT-NEXT:    and v4.16b, v4.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    fcmeq v5.4s, v2.4s, v2.4s
; CHECK-CVT-NEXT:    orr v2.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v6.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v3.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    bit v2.16b, v4.16b, v5.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: sitofp_i64:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-BF16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-BF16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-BF16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-BF16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-BF16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-BF16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-BF16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v2.4s
; CHECK-BF16-NEXT:    ret
  %1 = sitofp <8 x i64> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <4 x bfloat> @uitofp_v4i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v4i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v2.4s, v0.4s, #16
; CHECK-CVT-NEXT:    and v1.16b, v2.16b, v1.16b
; CHECK-CVT-NEXT:    movi v2.4s, #127, msl #8
; CHECK-CVT-NEXT:    add v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v0.4s, v2.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_v4i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-BF16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-BF16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <4 x i8> %a to <4 x bfloat>
  ret <4 x bfloat> %1
}

define <8 x bfloat> @uitofp_v8i8(<8 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v8i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v4.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    ucvtf v3.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v0.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v4.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v2.4s, v0.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v3.4s, v1.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_v8i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-BF16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-BF16-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-BF16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v1.4s
; CHECK-BF16-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <8 x i8> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define <16 x bfloat> @uitofp_v16i8(<16 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_v16i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll2 v2.8h, v0.16b, #0
; CHECK-CVT-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v7.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushll v3.4s, v2.4h, #0
; CHECK-CVT-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-CVT-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-CVT-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-CVT-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    ucvtf v6.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    ushr v0.4s, v4.4s, #16
; CHECK-CVT-NEXT:    ushr v16.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v17.4s, v6.4s, #16
; CHECK-CVT-NEXT:    and v5.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v16.16b, v16.16b, v1.16b
; CHECK-CVT-NEXT:    and v17.16b, v17.16b, v1.16b
; CHECK-CVT-NEXT:    add v5.4s, v5.4s, v7.4s
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v7.4s
; CHECK-CVT-NEXT:    addhn v1.4h, v3.4s, v5.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v4.4s, v0.4s
; CHECK-CVT-NEXT:    add v3.4s, v16.4s, v7.4s
; CHECK-CVT-NEXT:    add v4.4s, v17.4s, v7.4s
; CHECK-CVT-NEXT:    addhn2 v1.8h, v2.4s, v3.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v6.4s, v4.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_v16i8:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ushll2 v1.8h, v0.16b, #0
; CHECK-BF16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-BF16-NEXT:    ushll v2.4s, v1.4h, #0
; CHECK-BF16-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-BF16-NEXT:    ushll2 v4.4s, v1.8h, #0
; CHECK-BF16-NEXT:    ushll2 v5.4s, v0.8h, #0
; CHECK-BF16-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-BF16-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-BF16-NEXT:    bfcvtn v1.4h, v2.4s
; CHECK-BF16-NEXT:    ucvtf v2.4s, v4.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v3.4s
; CHECK-BF16-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-BF16-NEXT:    bfcvtn2 v1.8h, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v3.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <16 x i8> %a to <16 x bfloat>
  ret <16 x bfloat> %1
}


define <8 x bfloat> @uitofp_i16(<8 x i16> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v4.4s, #127, msl #8
; CHECK-CVT-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-CVT-NEXT:    ucvtf v3.4s, v0.4s
; CHECK-CVT-NEXT:    ushr v0.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v3.4s, #16
; CHECK-CVT-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    add v0.4s, v0.4s, v4.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v4.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v2.4s, v0.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v3.4s, v1.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_i16:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-BF16-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-BF16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v1.4s
; CHECK-BF16-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <8 x i16> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}


define <8 x bfloat> @uitofp_i32(<8 x i32> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i32:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    movi v2.4s, #1
; CHECK-CVT-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-CVT-NEXT:    movi v5.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v3.4s, v0.4s, #16
; CHECK-CVT-NEXT:    ushr v4.4s, v1.4s, #16
; CHECK-CVT-NEXT:    and v3.16b, v3.16b, v2.16b
; CHECK-CVT-NEXT:    and v2.16b, v4.16b, v2.16b
; CHECK-CVT-NEXT:    add v0.4s, v3.4s, v0.4s
; CHECK-CVT-NEXT:    add v1.4s, v2.4s, v1.4s
; CHECK-CVT-NEXT:    addhn v0.4h, v0.4s, v5.4s
; CHECK-CVT-NEXT:    addhn2 v0.8h, v1.4s, v5.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_i32:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-BF16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v1.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <8 x i32> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}


define <8 x bfloat> @uitofp_i64(<8 x i64> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i64:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-CVT-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-CVT-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-CVT-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-CVT-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-CVT-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-CVT-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-CVT-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-CVT-NEXT:    movi v1.4s, #1
; CHECK-CVT-NEXT:    movi v3.4s, #127, msl #8
; CHECK-CVT-NEXT:    ushr v4.4s, v2.4s, #16
; CHECK-CVT-NEXT:    ushr v5.4s, v0.4s, #16
; CHECK-CVT-NEXT:    add v6.4s, v2.4s, v3.4s
; CHECK-CVT-NEXT:    add v3.4s, v0.4s, v3.4s
; CHECK-CVT-NEXT:    and v4.16b, v4.16b, v1.16b
; CHECK-CVT-NEXT:    and v1.16b, v5.16b, v1.16b
; CHECK-CVT-NEXT:    fcmeq v5.4s, v2.4s, v2.4s
; CHECK-CVT-NEXT:    orr v2.4s, #64, lsl #16
; CHECK-CVT-NEXT:    add v4.4s, v4.4s, v6.4s
; CHECK-CVT-NEXT:    fcmeq v6.4s, v0.4s, v0.4s
; CHECK-CVT-NEXT:    add v1.4s, v1.4s, v3.4s
; CHECK-CVT-NEXT:    orr v0.4s, #64, lsl #16
; CHECK-CVT-NEXT:    bit v2.16b, v4.16b, v5.16b
; CHECK-CVT-NEXT:    bit v0.16b, v1.16b, v6.16b
; CHECK-CVT-NEXT:    uzp2 v0.8h, v0.8h, v2.8h
; CHECK-CVT-NEXT:    ret
;
; CHECK-BF16-LABEL: uitofp_i64:
; CHECK-BF16:       // %bb.0:
; CHECK-BF16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-BF16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-BF16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-BF16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-BF16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-BF16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-BF16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-BF16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-BF16-NEXT:    bfcvtn v0.4h, v0.4s
; CHECK-BF16-NEXT:    bfcvtn2 v0.8h, v2.4s
; CHECK-BF16-NEXT:    ret
  %1 = uitofp <8 x i64> %a to <8 x bfloat>
  ret <8 x bfloat> %1
}

define void @test_insert_at_zero(bfloat %a, ptr %b) #0 {
; CHECK-LABEL: test_insert_at_zero:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $q0
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
  %1 = insertelement <8 x bfloat> undef, bfloat %a, i64 0
  store <8 x bfloat> %1, ptr %b, align 4
  ret void
}

define <8 x i8> @fptosi_i8(<8 x bfloat> %a) #0 {
; CHECK-LABEL: fptosi_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll2 v1.4s, v0.8h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    xtn v0.8b, v0.8h
; CHECK-NEXT:    ret
  %1 = fptosi<8 x bfloat> %a to <8 x i8>
  ret <8 x i8> %1
}

define <8 x i16> @fptosi_i16(<8 x bfloat> %a) #0 {
; CHECK-LABEL: fptosi_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll2 v1.4s, v0.8h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzs v1.4s, v1.4s
; CHECK-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %1 = fptosi<8 x bfloat> %a to <8 x i16>
  ret <8 x i16> %1
}

define <8 x i8> @fptoui_i8(<8 x bfloat> %a) #0 {
; CHECK-LABEL: fptoui_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll2 v1.4s, v0.8h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    xtn v0.8b, v0.8h
; CHECK-NEXT:    ret
  %1 = fptoui<8 x bfloat> %a to <8 x i8>
  ret <8 x i8> %1
}

define <8 x i16> @fptoui_i16(<8 x bfloat> %a) #0 {
; CHECK-LABEL: fptoui_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shll2 v1.4s, v0.8h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    fcvtzu v1.4s, v1.4s
; CHECK-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %1 = fptoui<8 x bfloat> %a to <8 x i16>
  ret <8 x i16> %1
}

define <8 x i1> @test_fcmp_une(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_une:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, ne
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, ne
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp une <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ueq(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ueq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, eq
; CHECK-NEXT:    csinv w9, w9, wzr, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    csinv w8, w8, wzr, vc
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ueq <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ugt(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, hi
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, hi
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ugt <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_uge(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, pl
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, pl
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp uge <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ult(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, lt
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, lt
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ult <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ule(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, le
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, le
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ule <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_uno(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_uno:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, vs
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, vs
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp uno <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_one(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_one:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, mi
; CHECK-NEXT:    csinv w9, w9, wzr, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    csinv w8, w8, wzr, le
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp one <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_oeq(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_oeq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, eq
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, eq
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp oeq <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ogt(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ogt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, gt
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, gt
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ogt <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_oge(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_oge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, ge
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, ge
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp oge <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_olt(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_olt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, mi
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, mi
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp olt <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ole(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ole:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, ls
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, ls
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ole <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

define <8 x i1> @test_fcmp_ord(<8 x bfloat> %a, <8 x bfloat> %b) #0 {
; CHECK-LABEL: test_fcmp_ord:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v2.4h, v1.h[1]
; CHECK-NEXT:    dup v3.4h, v0.h[1]
; CHECK-NEXT:    dup v4.4h, v1.h[2]
; CHECK-NEXT:    dup v5.4h, v0.h[2]
; CHECK-NEXT:    dup v6.4h, v0.h[3]
; CHECK-NEXT:    shll v2.4s, v2.4h, #16
; CHECK-NEXT:    shll v3.4s, v3.4h, #16
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v2.4s, v1.4h, #16
; CHECK-NEXT:    shll v3.4s, v0.4h, #16
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s3, s2
; CHECK-NEXT:    shll v3.4s, v4.4h, #16
; CHECK-NEXT:    shll v4.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.4h, v1.h[3]
; CHECK-NEXT:    csetm w9, vc
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[4]
; CHECK-NEXT:    dup v6.8h, v0.h[4]
; CHECK-NEXT:    mov v2.h[1], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[5]
; CHECK-NEXT:    dup v6.8h, v0.h[5]
; CHECK-NEXT:    mov v2.h[2], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    dup v5.8h, v1.h[6]
; CHECK-NEXT:    dup v6.8h, v0.h[6]
; CHECK-NEXT:    dup v1.8h, v1.h[7]
; CHECK-NEXT:    dup v0.8h, v0.h[7]
; CHECK-NEXT:    mov v2.h[3], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    shll v3.4s, v5.4h, #16
; CHECK-NEXT:    shll v4.4s, v6.4h, #16
; CHECK-NEXT:    shll v1.4s, v1.4h, #16
; CHECK-NEXT:    shll v0.4s, v0.4h, #16
; CHECK-NEXT:    mov v2.h[4], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s4, s3
; CHECK-NEXT:    mov v2.h[5], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    mov v2.h[6], w8
; CHECK-NEXT:    csetm w8, vc
; CHECK-NEXT:    mov v2.h[7], w8
; CHECK-NEXT:    xtn v0.8b, v2.8h
; CHECK-NEXT:    ret
  %1 = fcmp ord <8 x bfloat> %a, %b
  ret <8 x i1> %1
}

attributes #0 = { nounwind }
