/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"




extern "C" {static void assign_wxVariantList(void *, Py_ssize_t, void *);}
static void assign_wxVariantList(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxVariantList *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxVariantList *>(sipSrc);
}


extern "C" {static void *array_wxVariantList(Py_ssize_t);}
static void *array_wxVariantList(Py_ssize_t sipNrElem)
{
    return new ::wxVariantList[sipNrElem];
}


extern "C" {static void *copy_wxVariantList(const void *, Py_ssize_t);}
static void *copy_wxVariantList(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxVariantList(reinterpret_cast<const ::wxVariantList *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxVariantList(void *, int);}
static void release_wxVariantList(void *sipCppV, int)
{
    ::wxVariantList *sipCpp = reinterpret_cast< ::wxVariantList *>(sipCppV);
    Py_BEGIN_ALLOW_THREADS
    delete sipCpp;
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxVariantList(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxVariantList(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxVariantList **sipCppPtr = reinterpret_cast< ::wxVariantList **>(sipCppPtrV);
        // Code to test a PyObject for compatibility.
        if (!sipIsErr) {
            // Any type sequence type is okay.
            int success = PySequence_Check(sipPy);
            if (!success)
                PyErr_SetString(PyExc_TypeError, "Sequence type expected.");
            return success;
        }

        // Code to create a new wxVariantList from the PyObject sequence
        wxVariantList* value =  new wxVariantList();
        Py_ssize_t len = PySequence_Length(sipPy);
        Py_ssize_t idx = 0;
        while (idx < len) {
            PyObject* item = PySequence_GetItem(sipPy, idx);
            value->Append(new wxVariant(wxVariant_in_helper(item)));
            Py_DECREF(item);
        }
        *sipCppPtr = value;
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxVariantList(void *, PyObject *);}
static PyObject *convertFrom_wxVariantList(void *sipCppV, PyObject *)
{
    ::wxVariantList *sipCpp = reinterpret_cast< ::wxVariantList *>(sipCppV);
        // Code to convert a wxVariantList to a Python list.
        if (sipCpp == NULL) {
            return Py_None;
        } else {
            size_t idx = 0;
            PyObject* value = PyList_New(0);
            for (idx=0; idx < sipCpp->GetCount(); idx++) {
                PyObject* item = wxVariant_out_helper(sipCpp->Item(idx)->GetData());
                PyList_Append(value, item);
            }
            return value;
        }
}


sipMappedTypeDef sipTypeDef__core_wxVariantList = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_wxVariantList,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_wxVariantList,
    array_wxVariantList,
    copy_wxVariantList,
    release_wxVariantList,
    convertTo_wxVariantList,
    convertFrom_wxVariantList
};
