#pragma once

#include "codegenv2.h"

struct Instr_Def InstrTableV2[] = {

	/* | mnemonic | operand count | operand types | encoding group | flags | opcode len | opcode bytes | op size | modRM | sib | OSO | ASO | Valid segment modes | opnd direction | mandatory prefix type | immediate Operand? | memory Operand? | CPU mode | */

	/* No operand gp instructions */
	{ "clc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "cld",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "cli",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "clts",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x06, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "cmc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "cpuid",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xa2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "daa",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x27, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "das",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x2f, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "hlt",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "invd",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x08, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "lahf",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x9f, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "leave",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xc9, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "stc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "std",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "sti",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },

	/* FPU no operand instructions */
	{ "f2xm1",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fabs",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe1, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fchs",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fclex",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 3, { 0x9b, 0xdb, 0xe2 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fnclex", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xe2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fcos",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xff, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fdecstp",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf6, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fincstp",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf7, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "finit",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 3, { 0x9b, 0xdb, 0xe3 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fninit", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xe3, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fld1",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldl2t", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldl2e", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xea, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldpi",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xeb, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldlg2", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xec, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldln2", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xed, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fldz",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xee, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fnop",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fpatan", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf3, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fprem",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fprem1", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf5, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fptan",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "frndint",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfc, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fscale", 0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfd, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fsin",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfe, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fsincos",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfb, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fsqrt",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfa, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "ftst",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe4, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fxam",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe5, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fxch",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xc9, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fxtract",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf4, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fyl2x",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf1, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	{ "fyl2xp1",0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf9, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
	
	/* General Purpose Reg->Reg moves (We use 8a/8b(masm) instead of 88/89(gcc) */
	{ "mov",    2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                              NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64            ), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	/* CR0-CR8 register moves */
	{ "mov",    2, { R32,      R_CR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R64,      R_CR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R_CR    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),			      NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      R_CR8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R_CR8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	      NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_CR,     R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R_CR,     R64     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_CR,     R64E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_CR8,    R64     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_CR8,    R64E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	/* DR0-DR7 register moves */
	{ "mov",    2, { R32,      R_DR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R64,      R_DR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R_DR    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),			      NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_DR,     R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R_DR,     R64     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_DR,     R64E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	/* Segment register to register moves */
	{ "mov",    2, { R16,      R_SEG   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R16,      R_SEGE  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R32,      R_SEG   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R32,      R_SEGE  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R64,      R_SEG   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      R_SEGE  }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16E,     R_SEG   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16E,     R_SEGE  }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32E,     R_SEG   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32E,     R_SEGE  }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R_SEG   }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     R_SEGE  }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEG,    R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R_SEGE,   R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R_SEG,    R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R_SEGE,   R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
	{ "mov",    2, { R_SEG,    R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEGE,   R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEG,    R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEGE,   R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEG,    R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,	   NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEGE,   R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEG,    R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R_SEGE,   R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
	/* Reg->Immediate moves */
	{ "mov",    2, { R8,       IMM8    }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8H,      IMM8    }, GP0, (F_OPCODE_REG),													  NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R8U,      IMM8    }, GP3, (REX) | (F_OPCODE_REG),											  NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),							          NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16,      IMM8    }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R16,      IMM16   }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32,      IMM8    }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32,      IMM16   }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R32,      IMM32   }, GP0, (F_OPCODE_REG),												      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
	{ "mov",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      IMM64   }, GP3, (REX | REXW) | (F_OPCODE_REG),								      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64E,     IMM64   }, GP3, (REX | REXW | REXB) | (F_OPCODE_REG),						      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
	{ "mov",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),						      NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	{ "mov",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	{ "mov",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	{ "mov",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	{ "mov",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),							  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	{ "mov",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
	/* Mem->Reg moves */
	{ "mov",    2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
	{ "mov",    2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
	{ "mov",    2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
	{ "mov",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
	{ "mov",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	      NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						  NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			      NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	      NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
	/* Moffset moves */
	{ "mov",    2, { R8_AL,    M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { R8_AL,    M8      }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { M8,       R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { R16_AX,   M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { R16_AX,   M16     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { M16,      R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { R32_EAX,  M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		              NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { R32_EAX,  M32     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "mov",    2, { M32,      R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		              NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "mov",    2, { R64_RAX,  M_ANY   }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
	{ "mov",    2, { M_ANY,    R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
	{ "mov",    2, { R64_RAX,  M64     }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
	{ "mov",    2, { M64,      R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
	{ "movabs", 2, { R8_AL,    M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { R8_AL,    M8      }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { M_ANY,    R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { M8,       R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { R16_AX,   M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { M_ANY,    R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { R16_AX,   M16     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { M16,      R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				      NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { R32_EAX,  M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { M_ANY,    R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		              NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { R32_EAX,  M32     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
	{ "movabs", 2, { M32,      R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		              NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
	{ "movabs", 2, { R64_RAX,  M_ANY   }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
	{ "movabs", 2, { M_ANY,    R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
	{ "movabs", 2, { R64_RAX,  M64     }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
	{ "movabs", 2, { M64,      R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
	/* Mem->Immediate moves*/
	{ "mov",    2, { M8,       IMM8    }, GP3, ALLOW_SEG | (F_MODRM),											  NO_VEX, NO_EVEX, 1, 1, { 0xc6, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	            ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M16,      IMM8    }, GP3, ALLOW_SEG | (F_MODRM),											  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M16,      IMM16   }, GP3, ALLOW_SEG | (F_MODRM),											  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M32,      IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M32,      IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M32,      IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M64,      IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M64,      IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M64,      IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc6, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
	{ "mov",    2, { M_ANY,    IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },

	/* SSE */
	{ "movaps",    2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),						  NO_VEX, NO_EVEX, 4, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0xF  , NO_IMM,     NO_MEM,    P_686 | P_SSE1,0, NULL },
	{ "movaps",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),									  NO_VEX, NO_EVEX, 4, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0xF  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE1,0, NULL },
	{ "movaps",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),									  NO_VEX, NO_EVEX, 4, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  PFX_0xF  , NO_IMM,     MEM_OPND_0,P_686 | P_SSE1,0, NULL },
	{ "mulps",     2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),						  NO_VEX, NO_EVEX, 4, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0xF  , NO_IMM,     NO_MEM,    P_686 | P_SSE1,0, NULL },
	{ "mulps",     2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),									  NO_VEX, NO_EVEX, 4, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0xF  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE1,0, NULL },
	{ "pshufd",    3, { R_XMM,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,		      NO_VEX, NO_EVEX, 4, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,    P_686 | P_SSE1,0, NULL },
	{ "pshufd",    3, { R_XMM,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,		                  NO_VEX, NO_EVEX, 4, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1,0, NULL },
	{ "blendvps",  2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),						  NO_VEX, NO_EVEX, 4, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0x66F38  , NO_IMM,     NO_MEM,    P_686 | P_SSE4,0, NULL },
	{ "blendvps",  2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),									  NO_VEX, NO_EVEX, 4, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, PFX_0x66F38  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE4,0, NULL },
	{ "mpsadbw",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),						  NO_VEX, NO_EVEX, 4, 1, { 0x42, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, PFX_0x66F3A  , NO_IMM,     NO_MEM,    P_686 | P_SSE4,0, NULL },
	{ "mpsadbw",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),									  NO_VEX, NO_EVEX, 4, 1, { 0x42, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, PFX_0x66F3A  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE4,0, NULL },
	
	/* ----------------------------------------------------------------------------------------------- */
	/* VMOVAPS */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vmovaps", 2, { R_XMM,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | (SRCHDSTL), (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),			  1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_YMM,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | (SRCHDSTL), (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),			  1, 1, { 0x29, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_XMM,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_YMM,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_XMM,   M_ANY                   }, AVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_YMM,   M_ANY                   }, AVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),          (EVEX_W0 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { M_ANY,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),	         (EVEX_W0 | EVEX_MASK),                      1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { M_ANY,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX),	         (EVEX_W0 | EVEX_MASK),                      1, 1, { 0x29, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_ZMM,   R_ZMM                   }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (EVEX | VEX_0F | VEX_2OPND),					         (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z), 1, 1, { 0x28, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { R_ZMM,   M_ANY                   }, EVX0, (F_MODRM | F_MODRM_REG),						   (EVEX | VEX_0F | VEX_2OPND),					         (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z), 1, 1, { 0x28, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovaps", 2, { M_ANY,   R_ZMM                   }, EVX0, (F_MODRM | F_MODRM_REG),						   (EVEX | VEX_0F | VEX_2OPND),					         (EVEX_ONLY | EVEX_W0 | EVEX_MASK),          1, 1, { 0x29, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0               ,0                  , (      X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VMOVAPD */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vmovapd", 2, { R_XMM,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | (SRCHDSTL), (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),			 1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_YMM,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | (SRCHDSTL), (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),			 1, 1, { 0x29, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_XMM,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_YMM,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_XMM,   M_ANY                   }, AVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_YMM,   M_ANY                   }, AVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),          (EVEX_W1 | EVEX_MASK | EVEX_Z),             1, 1, { 0x28, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { M_ANY,   R_XMM                   }, AVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),	         (EVEX_W1 | EVEX_MASK),                      1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0               ,0                  , (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { M_ANY,   R_YMM                   }, AVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_WIG | VEX_0F | VEX_2OPND | EVEX | VEX_66),	         (EVEX_W1 | EVEX_MASK),                      1, 1, { 0x29, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0               ,0                  , (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_ZMM,   R_ZMM                   }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			   (EVEX | VEX_0F | VEX_2OPND | VEX_66),					         (EVEX_ONLY | EVEX_W1 | EVEX_MASK | EVEX_Z), 1, 1, { 0x28, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { R_ZMM,   M_ANY                   }, EVX0, (F_MODRM | F_MODRM_REG),						   (EVEX | VEX_0F | VEX_2OPND | VEX_66),					         (EVEX_ONLY | EVEX_W1 | EVEX_MASK | EVEX_Z), 1, 1, { 0x28, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_1, P_686 | P_AVX, 0, NULL },
	{ "vmovapd", 2, { M_ANY,   R_ZMM                   }, EVX0, (F_MODRM | F_MODRM_REG),						   (EVEX | VEX_0F | VEX_2OPND | VEX_66),					         (EVEX_ONLY | EVEX_W1 | EVEX_MASK),          1, 1, { 0x29, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0               ,0                  , (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_686 | P_AVX, 0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VMULPS */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vmulps",  3, { R_XMM,  R_XMM, R_XMM             }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_WIG | VEX_0F | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_RND),             4,  1, { 0x59, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmulps",  3, { R_XMM,  R_XMM, M_ANY             }, AVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_WIG | VEX_0F | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD),             4,  1, { 0x59, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },
	{ "vmulps",  3, { R_YMM,  R_YMM, R_YMM             }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_WIG | VEX_0F | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_RND),             8,  1, { 0x59, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmulps",  3, { R_YMM,  R_YMM, M_ANY             }, AVX1, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_WIG | VEX_0F | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD),             8,  1, { 0x59, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },
		/* special implicit NDS forms */																														         
		{ "vmulps",  2, { R_XMM,  R_XMM                }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_WIG | VEX_0F | VEX_DUP_NDS),               (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_RND),             4,  1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
		{ "vmulps",  2, { R_YMM,  R_YMM                }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_WIG | VEX_0F | VEX_DUP_NDS),               (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_RND),             8,  1, { 0x59, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmulps",  3, { R_ZMM,  R_ZMM, R_ZMM             }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (EVEX | VEX_0F | VEX_NDS),                            (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_RND), 16, 1, { 0x59, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vmulps",  3, { R_ZMM,  R_ZMM, M_ANY             }, EVX0, (F_MODRM | F_MODRM_REG),                           (EVEX | VEX_0F | VEX_NDS),                            (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD), 16, 1, { 0x59, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VPSHUFD */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vpshufd",    3, { R_XMM,  R_XMM,  IMM8          }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_W0 | EVEX_MASK | EVEX_Z),                        4,  1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, NO_MEM,    P_686 | P_AVX,0, NULL },
	{ "vpshufd",    3, { R_XMM,  M_ANY,  IMM8          }, AVX0, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD),             4,  1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, MEM_OPND_1,P_686 | P_AVX,0, NULL },
	{ "vpshufd",    3, { R_YMM,  R_YMM,  IMM8          }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_W0 | EVEX_MASK | EVEX_Z),                        8,  1, { 0x70, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, NO_MEM,    P_686 | P_AVX,0, NULL },
	{ "vpshufd",    3, { R_YMM,  M_ANY,  IMM8          }, AVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD),             8,  1, { 0x70, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, MEM_OPND_1,P_686 | P_AVX,0, NULL },
	{ "vpshufd",    3, { R_ZMM,  R_ZMM,  IMM8          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z),            16, 1, { 0x70, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, NO_MEM,    P_686 | P_AVX,0, NULL },
	{ "vpshufd",    3, { R_ZMM,  M_ANY,  IMM8          }, EVX0, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_WIG | VEX_0F | VEX_66 | VEX_2OPND | EVEX), (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_Z | EVEX_BRD), 16, 1, { 0x70, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, MEM_OPND_1,P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VGATHERDPS */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vgatherdps", 3, { R_XMM,  M_ANY,  R_XMM         }, AVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_0F38 | VEX_DDS | VEX_VSIB),		    (NO_EVEX),											    4,  1, { 0x92, 0x00, 0x00 }, 16, 2, NO_MOD,      0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX,0, NULL },
	{ "vgatherdps", 3, { R_YMM,  M_ANY,  R_YMM         }, AVX1, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_0F38 | VEX_DDS | VEX_VSIB),		    (NO_EVEX),											    8,  1, { 0x92, 0x00, 0x00 }, 32, 2, NO_MOD,      0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX,0, NULL },
	{ "vgatherdps", 2, { R_ZMM,  M_ANY                 }, EVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_0F38 | VEX_2OPND | VEX_VSIB | EVEX), (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_K | EVEX_VSIB), 16, 1, { 0x92, 0x00, 0x00 }, 64, 1, NO_MOD,      0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX,0, NULL },
	{ "vgatherdps", 2, { R_XMM,  M_ANY                 }, EVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_0F38 | VEX_2OPND | VEX_VSIB | EVEX), (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_K | EVEX_VSIB), 4,  1, { 0x92, 0x00, 0x00 }, 16, 1, NO_MOD,      0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX,0, NULL },
	{ "vgatherdps", 2, { R_YMM,  M_ANY                 }, EVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_0F38 | VEX_2OPND | VEX_VSIB | EVEX), (EVEX_ONLY | EVEX_W0 | EVEX_MASK | EVEX_K | EVEX_VSIB), 8,  1, { 0x92, 0x00, 0x00 }, 32, 1, NO_MOD,      0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VBLENDVPS */
	/* ----------------------------------------------------------------------------------------------- */																																																					         
	{ "vblendvps",  4, { R_XMM,  R_XMM, R_XMM,  R_XMM  }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_0F3A | VEX_NDS | VEX_4OPND | VEX_W0), (NO_EVEX),												4,  1, { 0x4a, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,        P_686 | P_AVX,0, NULL },
	{ "vblendvps",  4, { R_XMM,  R_XMM, M_ANY,  R_XMM  }, AVX0, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_66 | VEX_0F3A | VEX_NDS | VEX_4OPND | VEX_W0), (NO_EVEX),												4,  1, { 0x4a, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,    P_686 | P_AVX,0, NULL },
	{ "vblendvps",  4, { R_YMM,  R_YMM, R_YMM,  R_YMM  }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_0F3A | VEX_NDS | VEX_4OPND | VEX_W0), (NO_EVEX),												8,  1, { 0x4a, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,        P_686 | P_AVX,0, NULL },
	{ "vblendvps",  4, { R_YMM,  R_YMM, M_ANY,  R_YMM  }, AVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_66 | VEX_0F3A | VEX_NDS | VEX_4OPND | VEX_W0), (NO_EVEX),												8,  1, { 0x4a, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,    P_686 | P_AVX,0, NULL },
																																																																															         
	/* ----------------------------------------------------------------------------------------------- */																																																					         
	/* VMPSADBW */																																																																											         
	/* ----------------------------------------------------------------------------------------------- */																																																					         
	{ "vmpsadbw",   4, { R_XMM,  R_XMM, R_XMM, IMM8    }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_NDS),	         (NO_EVEX),												4,  1, { 0x42, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,        P_686 | P_AVX,0, NULL },
	{ "vmpsadbw",   4, { R_XMM,  R_XMM, M_ANY, IMM8    }, AVX0, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_NDS),            (NO_EVEX),												4,  1, { 0x42, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,    P_686 | P_AVX,0, NULL },
	{ "vmpsadbw",   4, { R_YMM,  R_YMM, R_YMM, IMM8    }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_NDS),	         (NO_EVEX),												8,  1, { 0x42, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,        P_686 | P_AVX,0, NULL },
	{ "vmpsadbw",   4, { R_YMM,  R_YMM, M_ANY, IMM8    }, AVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,               (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_NDS),	         (NO_EVEX),												8,  1, { 0x42, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,    P_686 | P_AVX,0, NULL },
		/* Implicit NDS forms */																																																																							         
		{ "vmpsadbw",   3, { R_XMM,  R_XMM,  IMM8      }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_DUP_NDS),	     (NO_EVEX),												4,  1, { 0x42, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, NO_MEM,        P_686 | P_AVX,0, NULL },
		{ "vmpsadbw",   3, { R_YMM,  R_YMM,  IMM8      }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  (VEX | VEX_66 | VEX_WIG | VEX_0F3A | VEX_DUP_NDS),	     (NO_EVEX),												8,  1, { 0x42, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_2, NO_MEM,        P_686 | P_AVX,0, NULL },
																																																																															         
	/* ----------------------------------------------------------------------------------------------- */																																																					         
	/* VPMOVZXBQ */																																																																											         
	/* ----------------------------------------------------------------------------------------------- */																																																					         
	{ "vpmovzxbq",   2, { R_XMM,  R_XMM,               }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX), 	 (EVEX_MASK | EVEX_Z),									2, 1, { 0x32, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpmovzxbq",   2, { R_XMM,  M_ANY,               }, AVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX),	 (EVEX_MASK | EVEX_Z),									2, 1, { 0x32, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vpmovzxbq",   2, { R_YMM,  R_XMM,               }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX), 	 (EVEX_MASK | EVEX_Z),									4, 1, { 0x32, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpmovzxbq",   2, { R_YMM,  M_ANY,               }, AVX1, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX),	 (EVEX_MASK | EVEX_Z),									4, 1, { 0x32, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vpmovzxbq",   2, { R_ZMM,  R_XMM,               }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),              (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX), 	 (EVEX_ONLY | EVEX_MASK | EVEX_Z),						8, 1, { 0x32, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpmovzxbq",   2, { R_ZMM,  M_ANY,               }, EVX0, (F_MODRM | F_MODRM_REG),                           (VEX | VEX_66 | VEX_WIG | VEX_2OPND | VEX_0F38 | EVEX),	 (EVEX_ONLY | EVEX_MASK | EVEX_Z),						8, 1, { 0x32, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VBROADCASTSD */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vbroadcastsd",   2, { R_YMM,  M_ANY,               }, AVX1, (F_MODRM | F_MODRM_REG),                        (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),							8,  1, { 0x19, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vbroadcastsd",   2, { R_YMM,  R_XMM,               }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),							8,  1, { 0x19, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vbroadcastsd",   2, { R_ZMM,  R_XMM,               }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				8,  1, { 0x19, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vbroadcastsd",   2, { R_ZMM,  M_ANY,               }, EVX0, (F_MODRM | F_MODRM_REG),                        (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				8,  1, { 0x19, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VBLENDMPD */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vblendmpd",      3, { R_XMM,  R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					2,  1, { 0x65, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vblendmpd",      3, { R_YMM,  R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					4,  1, { 0x65, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vblendmpd",      3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0x65, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vblendmpd",      3, { R_XMM,  R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		2,  1, { 0x65, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vblendmpd",      3, { R_YMM,  R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		4,  1, { 0x65, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vblendmpd",      3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0x65, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (      X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	{ "vcvtdq2pd",      2, { R_XMM,  R_XMM        }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                   (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND | EVEX),    (EVEX_MASK | EVEX_Z | EVEX_W0),                         2,  1, { 0xe6, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_XMM,  M_ANY        }, AVX0, (F_MODRM | F_MODRM_REG),                                (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND | EVEX),    (EVEX_MASK | EVEX_Z | EVEX_W0 | EVEX_BRD),              2,  1, { 0xe6, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_YMM,  R_XMM        }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                   (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND | EVEX),    (EVEX_MASK | EVEX_Z | EVEX_W0),                         4,  1, { 0xe6, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_YMM,  M_ANY        }, AVX1, (F_MODRM | F_MODRM_REG),                                (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND | EVEX),    (EVEX_MASK | EVEX_Z | EVEX_W0 | EVEX_BRD),              4,  1, { 0xe6, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_ZMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                   (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),                    (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),             8,  1, { 0xe6, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),                                (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),                    (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0 | EVEX_BRD),  8,  1, { 0xe6, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },
	{ "vcvtdq2pd",      2, { R_ZMM,  M256         }, EVX0, (F_MODRM | F_MODRM_REG),                                (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),                    (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),             2,  1, { 0xe6, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	// VCVTSI2SS xmm1, xmm2, r/m32     VEX.LIG.F3.0F.W0 2A /r
	// VCVTSI2SS xmm1, xmm2, r/m64     VEX.LIG.F3.0F.W1 2A /r
	// VCVTSI2SS xmm1, xmm2, r/m32{er} EVEX.LIG.F3.0F.W0 2A /r
	// VCVTSI2SS xmm1, xmm2, r/m64{er} EVEX.LIG.F3.0F.W1 2A /r
	/* ----------------------------------------------------------------------------------------------- */
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, R32           }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W0 | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_RND),     4,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, R32E          }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W0 | VEX_NDS | EVEX),            (EVEX_W0 | EVEX_RND),     4,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, M32           }, AVX0, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W0 | VEX_NDS | EVEX),            (EVEX_W0),                4,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, R64           }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W1 | VEX_NDS | EVEX),            (EVEX_W1 | EVEX_RND),     2,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, R64E          }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W1 | VEX_NDS | EVEX),            (EVEX_W1 | EVEX_RND),     2,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, M64           }, AVX0, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W1 | VEX_NDS | EVEX),            (EVEX_W1),                2,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },
	{ "vcvtsi2ss",      3, { R_XMM,  R_XMM, M_ANY         }, AVX0, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_F3 | VEX_0F | VEX_LIG | VEX_W0 | VEX_NDS | EVEX),            (EVEX_W0),                4,  1, { 0x2a, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM,     MEM_OPND_2, P_686 | P_AVX, 0, NULL },
	/* ----------------------------------------------------------------------------------------------- */
	// CVTSI2SS xmm1, r/m32 F3 0F 2A /r
	// CVTSI2SS xmm1, r/m64 F3 REX.W 0F 2A /r
	{ "cvtsi2ss",       2, { R_XMM,    R32                }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                     NO_VEX, NO_EVEX, 4, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    M32                }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                          NO_VEX, NO_EVEX, 4, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    M_ANY              }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                          NO_VEX, NO_EVEX, 4, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    R64                }, SSE0, (EREX | REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 2, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X64),       REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    M64                }, SSE0, (EREX | REX | REXW) | (F_MODRM | F_MODRM_REG),		              NO_VEX, NO_EVEX, 2, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    R32E               }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                     NO_VEX, NO_EVEX, 4, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2,0, NULL },
	{ "cvtsi2ss",       2, { R_XMM,    R64E               }, SSE0, (EREX | REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 4, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2,0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
			//VMOVDQA xmm1, xmm2 / m128    VEX.128.66.0F.WIG 6F / r
			//VMOVDQA xmm2 / m128, xmm1    VEX.128.66.0F.WIG 7F / r
			//VMOVDQA ymm1, ymm2 / m256    VEX.256.66.0F.WIG 6F / r
			//VMOVDQA ymm2 / m256, ymm1    VEX.256.66.0F.WIG 7F / r
			/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqa",      2, { R_XMM,  R_XMME       }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { R_XMM,  R_XMM        }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { R_XMM,  M_ANY        }, AVX0, (F_MODRM | F_MODRM_REG),						              (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { M_ANY,  R_XMM        }, AVX0, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { R_YMM,  R_YMME       }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { R_YMM,  R_YMM        }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { R_YMM,  M_ANY        }, AVX1, (F_MODRM | F_MODRM_REG),						              (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },
	{ "vmovdqa",      2, { M_ANY,  R_YMM        }, AVX1, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_66 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },

		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQA32 xmm1{k1}{z},xmm2 / m128    EVEX.128.66.0F.W0 6F / r
		//VMOVDQA32 ymm1{k1}{z},ymm2 / m256    EVEX.256.66.0F.W0 6F / r
		//VMOVDQA32 zmm1{k1}{z},zmm2 / m512    EVEX.512.66.0F.W0 6F / r
		//VMOVDQA32 xmm2 / m128{k1}{z},xmm1    EVEX.128.66.0F.W0 7F / r
		//VMOVDQA32 ymm2 / m256{k1}{z},ymm1    EVEX.256.66.0F.W0 7F / r
		//VMOVDQA32 zmm2 / m512{k1}{z},zmm1    EVEX.512.66.0F.W0 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqa32",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),	       1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa32",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQA64 xmm1{k1}{z},xmm2 / m128    EVEX.128.66.0F.W1 6F / r
		//VMOVDQA64 ymm1{k1}{z},ymm2 / m256    EVEX.256.66.0F.W1 6F / r
		//VMOVDQA64 zmm1{k1}{z}, zmm2 / m512    EVEX.512.66.0F.W1 6F / r
		//VMOVDQA64 xmm2 / m128{k1}{z},xmm1    EVEX.128.66.0F.W1 7F / r
		//VMOVDQA64 ymm2 / m256{k1}{z},ymm1    EVEX.256.66.0F.W1 7F /r
		//VMOVDQA64 zmm2 / m512{k1}{z},zmm1    EVEX.512.66.0F.W1 7F /r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqa64",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),	        1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqa64",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_66 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQU xmm1, xmm2 / m128    VEX.128.F3.0F.WIG 6F / r
		//VMOVDQU xmm2 / m128, xmm1    VEX.128.F3.0F.WIG 7F / r
		//VMOVDQU ymm1, ymm2 / m256    VEX.256.F3.0F.WIG 6F / r
		//VMOVDQU ymm2 / m256, ymm1    VEX.256.F3.0F.WIG 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqu",      2, { R_XMM,  R_XMME       }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { R_XMM,  R_XMM        }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { R_XMM,  M_ANY        }, AVX0, (F_MODRM | F_MODRM_REG),						              (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { M_ANY,  R_XMM        }, AVX0, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { R_YMM,  R_YMME       }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { R_YMM,  R_YMM        }, AVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { R_YMM,  M_ANY        }, AVX1, (F_MODRM | F_MODRM_REG),						              (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },
	{ "vmovdqu",      2, { M_ANY,  R_YMM        }, AVX1, (F_MODRM | F_MODRM_REG),                         (VEX | VEX_F3 | VEX_0F | VEX_WIG | VEX_2OPND),    (NO_EVEX),          1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQU8 xmm1{k1}{z}, xmm2 / m128    EVEX.128.F2.0F.W0 6F / r
		//VMOVDQU8 ymm1{k1}{z}, ymm2 / m256    EVEX.256.F2.0F.W0 6F / r
		//VMOVDQU8 zmm1{k1}{z}, zmm2 / m512    EVEX.512.F2.0F.W0 6F / r
		//VMOVDQU8 xmm2 / m128{k1}{z}, xmm1    EVEX.128.F2.0F.W0 7F / r
		//VMOVDQU8 ymm2 / m256{k1}{z}, ymm1    EVEX.256.F2.0F.W0 7F / r
		//VMOVDQU8 zmm2 / m512{k1}{z}, zmm1    EVEX.512.F2.0F.W0 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqu8",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						             (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),	        1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu8",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQU16 xmm1{k1}{z}, xmm2 / m128    EVEX.128.F2.0F.W1 6F / r
		//VMOVDQU16 ymm1{k1}{z}, ymm2 / m256    EVEX.256.F2.0F.W1 6F / r
		//VMOVDQU16 zmm1{k1}{z}, zmm2 / m512    EVEX.512.F2.0F.W1 6F / r
		//VMOVDQU16 xmm2 / m128{k1}{z}, xmm1    EVEX.128.F2.0F.W1 7F / r
		//VMOVDQU16 ymm2 / m256{k1}{z}, ymm1    EVEX.256.F2.0F.W1 7F / r
		//VMOVDQU16 zmm2 / m512{k1}{z}, zmm1    EVEX.512.F2.0F.W1 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqu16",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),	        1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu16",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F2 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQU32 xmm1{k1}{z},xmm2 / mm128    EVEX.128.F3.0F.W0 6F / r
		//VMOVDQU32 ymm1{k1}{z}, ymm2 / m256    EVEX.256.F3.0F.W0 6F / r
		//VMOVDQU32 zmm1{k1}{z}, zmm2 / m512    EVEX.512.F3.0F.W0 6F / r
		//VMOVDQU32 xmm2 / m128{k1}{z}, xmm1    EVEX.128.F3.0F.W0 7F / r
		//VMOVDQU32 ymm2 / m256{k1}{z}, ymm1    EVEX.256.F3.0F.W0 7F / r
		//VMOVDQU32 zmm2 / m512{k1}{z}, zmm1    EVEX.512.F3.0F.W0 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqu32",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						              (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),	        1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu32",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */
		//VMOVDQU64 xmm1{k1}{z}, xmm2 / m128    EVEX.128.F3.0F.W1 6F / r
		//VMOVDQU64 ymm1{k1}{z}, ymm2 / m256    EVEX.256.F3.0F.W1 6F / r
		//VMOVDQU64 zmm1{k1}{z}, zmm2 / m512    EVEX.512.F3.0F.W1 6F / r
		//VMOVDQU64 xmm2 / m128{k1}{z}, xmm1    EVEX.256.F3.0F.W1 7F / r
		//VMOVDQU64 ymm2 / m256{k1}{z}, ymm1    EVEX.256.F3.0F.W1 7F / r
		//VMOVDQU64 zmm2 / m512{k1}{z}, zmm1    EVEX.512.F3.0F.W1 7F / r
		/* ----------------------------------------------------------------------------------------------- */
	{ "vmovdqu64",      2, { R_XMM,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { R_XMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						    (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { M_ANY,  R_XMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { R_YMM,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { R_YMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						    (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 32, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { M_ANY,  R_YMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 32, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { R_ZMM,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),            (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,        P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { R_ZMM,  M_ANY        }, EVX0, (F_MODRM | F_MODRM_REG),						    (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),	      1,  1, { 0x6f, 0x00, 0x00 }, 64, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,    P_686 | P_AVX, 0, NULL },
	{ "vmovdqu64",      2, { M_ANY,  R_ZMM        }, EVX0, (F_MODRM | F_MODRM_REG),                         (EVEX | VEX_F3 | VEX_0F | VEX_2OPND),         (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),         1,  1, { 0x7f, 0x00, 0x00 }, 64, 1, MOD_MEM_REG, 0, 0,  0, (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,    P_686 | P_AVX, 0, NULL },
		/* ----------------------------------------------------------------------------------------------- */

	/* ----------------------------------------------------------------------------------------------- */
	/* VPBROADCAST D/Q special R32/R64 forms not supported in legacy Codegen */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vpbroadcastd",   2, { R_XMM,  R32          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastd",   2, { R_XMM,  R32E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastd",   2, { R_YMM,  R32          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastd",   2, { R_YMM,  R32E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastd",   2, { R_ZMM,  R32          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastd",   2, { R_ZMM,  R32E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W0),				1,  1, { 0x7c, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },

	{ "vpbroadcastq",   2, { R_XMM,  R64          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastq",   2, { R_XMM,  R64E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastq",   2, { R_YMM,  R64          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastq",   2, { R_YMM,  R64E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 32, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastq",   2, { R_ZMM,  R64          }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpbroadcastq",   2, { R_ZMM,  R64E         }, EVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_2OPND | VEX_0F38 | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),				1,  1, { 0x7c, 0x00, 0x00 }, 64, 1, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },

	// BEXTR r32a, r / m32, r32b VEX.LZ.0F38.W0 F7 / r
	// BEXTR r64a, r / m64, r64b VEX.LZ.0F38.W1 F7 / r
	{ "bextr",     3, { R32,  R32,     R32     }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),               (VEX | VEX_W0 | VEX_0F38 | VEX_3RD_OP), (NO_EVEX), 1,  1, { 0xf7, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "bextr",     3, { R32,  M_ANY,   R32     }, AVX0, (F_MODRM | F_MODRM_REG),					        (VEX | VEX_W0 | VEX_0F38 | VEX_3RD_OP), (NO_EVEX), 1,  1, { 0xf7, 0x00, 0x00 }, 4, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },
	{ "bextr",     3, { R64,  R64,     R64     }, AVX0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),               (VEX | VEX_W1 | VEX_0F38 | VEX_3RD_OP), (NO_EVEX), 1,  1, { 0xf7, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX, 0, NULL },
	{ "bextr",     3, { R64,  M_ANY,   R64     }, AVX0, (F_MODRM | F_MODRM_REG),					        (VEX | VEX_W1 | VEX_0F38 | VEX_3RD_OP), (NO_EVEX), 1,  1, { 0xf7, 0x00, 0x00 }, 8, 1, MOD_REG_MEM, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1,         P_686 | P_AVX, 0, NULL },

	/* AVX512BW and AVX512DQ */
	{ "ktestb",    2, { R_K,  R_K              }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			    (VEX | VEX_W0 | VEX_0F | VEX_66 | VEX_2OPND), (NO_EVEX), 1,  1, { 0x99, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,         P_686 | P_AVX, 0, NULL },
	{ "ktestw",    2, { R_K,  R_K              }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			    (VEX | VEX_W0 | VEX_0F | VEX_2OPND         ), (NO_EVEX), 1,  1, { 0x99, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,         P_686 | P_AVX, 0, NULL },
	{ "ktestd",    2, { R_K,  R_K              }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			    (VEX | VEX_W1 | VEX_0F | VEX_66 | VEX_2OPND), (NO_EVEX), 1,  1, { 0x99, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,         P_686 | P_AVX, 0, NULL },
	{ "ktestq",    2, { R_K,  R_K              }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),			    (VEX | VEX_W1 | VEX_0F | VEX_2OPND         ), (NO_EVEX), 1,  1, { 0x99, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,  0, (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,         P_686 | P_AVX, 0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* VPDPBUSDS, VPDPBUSD, VPDPDWSSDS, VPDPWSS (AVX-VNNI and AVX512-VNNI) */
	/* ----------------------------------------------------------------------------------------------- */
	{ "vpdpbusds",      3, { R_XMM,  R_XMM,  R_XMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0x51, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusds",      3, { R_YMM,  R_YMM,  R_YMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0x51, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusds",      3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0x51, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusds",      3, { R_XMM,  R_XMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0x51, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpbusds",      3, { R_YMM,  R_YMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0x51, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpbusds",      3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0x51, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	{ "vpdpbusd",       3, { R_XMM,  R_XMM,  R_XMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0x50, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusd",       3, { R_YMM,  R_YMM,  R_YMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0x50, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusd",       3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0x50, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpbusd",       3, { R_XMM,  R_XMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0x50, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpbusd",       3, { R_YMM,  R_YMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0x50, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpbusd",       3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0x50, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	{ "vpdpwssds",      3, { R_XMM,  R_XMM,  R_XMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0x53, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssds",      3, { R_YMM,  R_YMM,  R_YMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0x53, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssds",      3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0x53, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssds",      3, { R_XMM,  R_XMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0x53, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpwssds",      3, { R_YMM,  R_YMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0x53, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpwssds",      3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0x53, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	{ "vpdpwssd",       3, { R_XMM,  R_XMM,  R_XMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0x52, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssd",       3, { R_YMM,  R_YMM,  R_YMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0x52, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssd",       3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0x52, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vpdpwssd",       3, { R_XMM,  R_XMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0x52, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpwssd",       3, { R_YMM,  R_YMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0x52, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vpdpwssd",       3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0x52, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	/* ----------------------------------------------------------------------------------------------- */
	/* GFNI + AVX GFNI (VGF2P8AFFINEQB, VGF2P8AFFINEINVQB, VGF2P8MULB)*/
	/* ----------------------------------------------------------------------------------------------- */
	{ "vgf2p8mulb",     3, { R_XMM,  R_XMM,  R_XMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0xcf, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8mulb",     3, { R_YMM,  R_YMM,  R_YMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0xcf, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8mulb",     3, { R_ZMM,  R_ZMM,  R_ZMM        }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM),           (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0xcf, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8mulb",     3, { R_XMM,  R_XMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0xcf, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8mulb",     3, { R_YMM,  R_YMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0xcf, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8mulb",     3, { R_ZMM,  R_ZMM,  M_ANY        }, EVX1, (F_MODRM | F_MODRM_REG),						   (VEX | VEX_66 | VEX_NDS | VEX_0F38 | VEX_W0 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0xcf, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	{ "vgf2p8affineqb", 4, { R_XMM,  R_XMM,  R_XMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0xce, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineqb", 4, { R_YMM,  R_YMM,  R_YMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0xce, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineqb", 4, { R_ZMM,  R_ZMM,  R_ZMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0xce, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineqb", 4, { R_XMM,  R_XMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0xce, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineqb", 4, { R_YMM,  R_YMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0xce, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineqb", 4, { R_ZMM,  R_ZMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0xce, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },

	{ "vgf2p8affineinvqb", 4, { R_XMM,  R_XMM,  R_XMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								2,  1, { 0xcf, 0x00, 0x00 }, 16, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineinvqb", 4, { R_YMM,  R_YMM,  R_YMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1),								4,  1, { 0xcf, 0x00, 0x00 }, 32, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineinvqb", 4, { R_ZMM,  R_ZMM,  R_ZMM, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1),					8,  1, { 0xcf, 0x00, 0x00 }, 64, 2, MOD_REG_REG, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, NO_MEM,             P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineinvqb", 4, { R_XMM,  R_XMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					2,  1, { 0xcf, 0x00, 0x00 }, 16, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineinvqb", 4, { R_YMM,  R_YMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),					4,  1, { 0xcf, 0x00, 0x00 }, 32, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
	{ "vgf2p8affineinvqb", 4, { R_ZMM,  R_ZMM,  M_ANY, IMM8  }, EVX1, (F_MODRM | F_MODRM_REG) | IMM8_ONLY,						   (VEX | VEX_66 | VEX_NDS | VEX_0F3A | VEX_W1 | EVEX), (EVEX_ONLY | EVEX_MASK | EVEX_Z | EVEX_W1 | EVEX_BRD),		8,  1, { 0xcf, 0x00, 0x00 }, 64, 2, MOD_REG_MEM, 0, 0               ,0                  , (X32 | X64), REG_DST, NO_PREFIX, IMM_OPND_3, MEM_OPND_2,         P_686 | P_AVX,0, NULL },
};
