/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 332
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 79
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  QVariant* yy15;
  SqliteSortOrder* yy25;
  SqliteColumnType* yy29;
  SqliteUpsert* yy34;
  SqliteFilterOver::Filter* yy37;
  SqliteQuery* yy43;
  ParserResultColumnList* yy75;
  SqliteWith* yy91;
  SqliteSelect::Core::SingleSource* yy95;
  SqliteWith::CommonTableExpression::AsMode* yy109;
  ParserCteList* yy114;
  SqliteSelect::CompoundOperator* yy116;
  ParserExprNestedList* yy118;
  ParserIndexedColumnList* yy121;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy122;
  ParserXFullName* yy128;
  SqliteConflictAlgo* yy134;
  ParserFullName* yy136;
  SqliteForeignKey::Condition* yy165;
  SqliteIndexedColumn* yy166;
  SqliteCreateTable::Column* yy215;
  SqliteInitially* yy218;
  SqliteWindowDefinition* yy219;
  SqliteCreateTable::Constraint* yy240;
  SqliteCreateTrigger::Scope* yy247;
  QString* yy267;
  SqliteSelect::Core::JoinOp* yy273;
  ParserOrderByList* yy277;
  ParserStubInsertOrReplace* yy284;
  SqliteCreateTable::Column::Constraint* yy298;
  ParserFkConditionList* yy316;
  ParserStubExplain* yy317;
  QStringList* yy327;
  SqliteLimit* yy330;
  ParserCreateTableColumnConstraintList* yy333;
  ParserStubTransDetails* yy338;
  SqliteExpr* yy339;
  int* yy348;
  ParserCreateTableConstraintList* yy365;
  SqliteWindowDefinition::Window::Frame::Exclude* yy366;
  ParserWindowDefList* yy369;
  SqliteSelect* yy379;
  ParserSetValueList* yy387;
  ParserCreateTableOptionList* yy399;
  SqliteWith::CommonTableExpression* yy404;
  SqliteFilterOver* yy405;
  SqliteNulls* yy409;
  SqliteForeignKey::Condition::Reaction* yy410;
  ParserQueryList* yy412;
  SqliteSelect::Core::JoinConstraint* yy421;
  SqliteExpr::LikeOp* yy436;
  SqliteFilterOver::Over* yy437;
  SqliteWindowDefinition::Window::Frame::Bound* yy453;
  SqliteWindowDefinition::Window::Frame* yy463;
  SqliteCreateTrigger::Event* yy469;
  bool* yy473;
  SqliteSelect::Core* yy492;
  ParserDeferSubClause* yy497;
  ParserExprList* yy498;
  ParserStubAlias* yy516;
  SqliteWindowDefinition::Window* yy518;
  ParserOtherSourceList* yy527;
  ParserIndexedBy* yy542;
  SqliteSelect::Core::JoinSource* yy567;
  SqliteCreateTrigger::Time* yy568;
  ParserTermOrLiteral* yy622;
  ParserCreateTableColumnList* yy658;
  ParserStubCreateTableOption* yy661;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 903
#define YYNRULE 507
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (3482)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   895,  264,  263,  262,   29,  895,  713,   72,   73,  544,
 /*    10 */   296,  903,  543,  846,  846,   70,   70,   71,   71,   71,
 /*    20 */    71,  712,   69,   69,   69,   69,   68,   68,   67,   67,
 /*    30 */    67,   66,   64,  276,   83, 1279,   72,   73,  544,  296,
 /*    40 */   420,  900,  846,  846,   70,   70,   71,   71,   71,   71,
 /*    50 */   546,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*    60 */    66,   64,  276,  895, 1329,  735,  735,  268,  738,  895,
 /*    70 */   493,  631,  844,  279,   71,   71,   71,   71,   61,   69,
 /*    80 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*    90 */   276,  770,  863,  371,  482,   58,   59,  745,  866,   84,
 /*   100 */   521,  895,  450,   60, 1077,  894,  865,  864,  863,   42,
 /*   110 */   143,    2, 1077,  543,  894,  332,  854, 1077,  334,  901,
 /*   120 */   540, 1151,  895,  895,  863,  892,  305,  895,  895,  307,
 /*   130 */   866,   67,   67,   67,   66,   64,  276,  854,  865,  864,
 /*   140 */   863,  721, 1077,   68,   68,   67,   67,   67,   66,   64,
 /*   150 */   276,  546,  297,  867,  843, 1077,  868, 1077, 1077,   63,
 /*   160 */   895, 1077,  412,  369,  259,  258, 1077, 1077, 1077, 1077,
 /*   170 */  1077, 1077,  854,  844,  308,  854,  850,  842,   12,   61,
 /*   180 */    74,   66,   64,  276,  686,  895,  895,  893,  892, 1077,
 /*   190 */   298,  895,  895,  863,  873,   95,   58,   59,  894,  866,
 /*   200 */   853,   81,  895,  206,   60, 1151,  167,  865,  864,  863,
 /*   210 */   349,  110,    2, 1151,  543,  782,  798,  854, 1151,  363,
 /*   220 */   284,  540,  673,  895,  895,  863,  892,  610,  277,  516,
 /*   230 */   895,  866,  511,  894,  676,  853,  782,  706,  854,  865,
 /*   240 */   864,  863,  782, 1151,  677,  850,  306,  466,  494,  899,
 /*   250 */   740,  739,  546,  517,  556,  625, 1151,  841, 1151, 1151,
 /*   260 */   626,  895,   93,  376,  612,  662,  700, 1151, 1151, 1151,
 /*   270 */  1151,  806, 1151,  854,  844,  789,  854,  122,  842,   12,
 /*   280 */    61,  685,  895,  895,  893,  892,  437,    8,  166,  173,
 /*   290 */  1151,  474,  471,  470,  478,   45,  806,   58,   59,  826,
 /*   300 */   849,  526,  595,   86,  118,   60, 1136,  770,  139,  469,
 /*   310 */   699,  391,  825,    2, 1136,  506,  782,  340,  854, 1136,
 /*   320 */   452,  894,  540,  895,  895,  895,  863,  892,  806,  850,
 /*   330 */     9,  483,  866,  594,  894,  593,  765,  782,  592,  854,
 /*   340 */   865,  864,  863,  782, 1136,   57,  570,   55,  363,  295,
 /*   350 */   294,  510,  895,  895,  893,  892,   94, 1136,  744, 1136,
 /*   360 */  1136,   24,  894,  895,  559, 1244, 1244,  570, 1136,  849,
 /*   370 */  1136, 1136,  855, 1136,  854,  891,  346,  854,  401,  842,
 /*   380 */    12,  790,  889,  895,  895,  893,  892,  415,  530,  752,
 /*   390 */   890, 1136,  836,  835,  345,  570,  895,  171,  853,  282,
 /*   400 */   895, 1249,  406,   47,  550,   72,   73,  544,  296, 1244,
 /*   410 */  1244,  846,  846,   70,   70,   71,   71,   71,   71,  895,
 /*   420 */    69,   69,   69,   69,   68,   68,   67,   67,   67,   66,
 /*   430 */    64,  276,  178,  853,    1,  751,  747,  268,  738,  860,
 /*   440 */   493,  818,  173,  445,  802,  895,  895,  893,  892,  727,
 /*   450 */  1244, 1244,  801,  849,  773,   72,   73,  544,  296,  174,
 /*   460 */    49,  846,  846,   70,   70,   71,   71,   71,   71,  528,
 /*   470 */    69,   69,   69,   69,   68,   68,   67,   67,   67,   66,
 /*   480 */    64,  276,  875,  348,  729,  895,  895,  893,  892,  765,
 /*   490 */    72,   73,  544,  296, 1244, 1244,  846,  846,   70,   70,
 /*   500 */    71,   71,   71,   71,  726,   69,   69,   69,   69,   68,
 /*   510 */    68,   67,   67,   67,   66,   64,  276,  824,  895,  895,
 /*   520 */   893,  892,  895,  895,  893,  892,  639,  701,  702,  823,
 /*   530 */   269,   48,  782,  858,   14,  573,  563,  758,  348,  729,
 /*   540 */   686,  895,  895,  893,  892,  368,  817, 1244, 1244,  578,
 /*   550 */   672,   95,  757,  782,  894,  574,  573,  118, 1249,  782,
 /*   560 */  1249,   71,   71,   71,   71,   43,   69,   69,   69,   69,
 /*   570 */    68,   68,   67,   67,   67,   66,   64,  276,  742,  776,
 /*   580 */   895,  710,  613,   63,  573, 1250,  537,   72,   73,  544,
 /*   590 */   296, 1244, 1244,  846,  846,   70,   70,   71,   71,   71,
 /*   600 */    71,   77,   69,   69,   69,   69,   68,   68,   67,   67,
 /*   610 */    67,   66,   64,  276,  142,  314,  458,  324,  377, 1360,
 /*   620 */   416,  839,  838,   82, 1360,  291,  496,   76, 1244, 1244,
 /*   630 */   610,  146,  166,  125,  392,  474,  471,  470,   47,   72,
 /*   640 */    73,  544,  296, 1315,  850,  846,  846,   70,   70,   71,
 /*   650 */    71,   71,   71,  469,   69,   69,   69,   69,   68,   68,
 /*   660 */    67,   67,   67,   66,   64,  276,  376,  611,   72,   73,
 /*   670 */   544,  296, 1244, 1244,  846,  846,   70,   70,   71,   71,
 /*   680 */    71,   71,  175,   69,   69,   69,   69,   68,   68,   67,
 /*   690 */    67,   67,   66,   64,  276,  895,  623,  267,  834,  627,
 /*   700 */   628,  439,  895,  895,  893,  892,  872,  543,  158,  160,
 /*   710 */    72,   73,  544,  296,  694,  477,  846,  846,   70,   70,
 /*   720 */    71,   71,   71,   71,  436,   69,   69,   69,   69,   68,
 /*   730 */    68,   67,   67,   67,   66,   64,  276,   27, 1315,  806,
 /*   740 */   613,  895, 1250,  845, 1250,  546,   69,   69,   69,   69,
 /*   750 */    68,   68,   67,   67,   67,   66,   64,  276,  895,  836,
 /*   760 */   835,  686,   83,  895,  806,  623,  766,  844,  849,  717,
 /*   770 */   861,  562,   95,   61,  876,  894,  377, 1359,  491,  139,
 /*   780 */   848,  385, 1359,  879,  552,  831,  687,  274,  894,  895,
 /*   790 */    58,   59,  716,  862,  243,  895,  806,  446,   60,  622,
 /*   800 */   290,  840,  548,  158,  157,  433,    2, 1256,   83,  734,
 /*   810 */    23,  854,  895,  746,  861,  540,  126,  895,  895,  863,
 /*   820 */   892,  895,  531,   82,  543,  866,  644,  513,  552,   62,
 /*   830 */   525,  492,  854,  865,  864,  863,  269,  862,  243, 1411,
 /*   840 */   198,  557,    3,  348,  729,  861,  548,  521, 1368, 1368,
 /*   850 */   490,  208,   75, 1087,  895,  386,  485,  753,  895,  552,
 /*   860 */   126,  894,  546,  895,  895,  893,  892,  854,  862,  226,
 /*   870 */   854,  617,  842,   12,  417,  512,  877,  548,  754,  895,
 /*   880 */   895,  895,  893,  892,  844,  895,  895,  893,  892,  824,
 /*   890 */    61,   63,    6,  753, 1368, 1368,  350,  895,  870,  386,
 /*   900 */    75,  823,  850,  408,  167,  753,  116,   58,   59,  543,
 /*   910 */   894,  895,  895,  893,  892,   60,  829,  895,  895,  893,
 /*   920 */   892, 1264,  867,    2,  895,  868,  754,  272,  854,  850,
 /*   930 */   811,  354,  540,  539,  895,  895,  863,  892,  999,  895,
 /*   940 */   524,  753,  866,  895,  895,  893,  892,  546,  475,  854,
 /*   950 */   865,  864,  863,  177,  130,  347,  480,  342,  479,  168,
 /*   960 */   775,  381,  522,  799,   83,  515,  120,  651,  784,  844,
 /*   970 */   579,  126,  169,  340,  618,   61,  895,  895,  893,  892,
 /*   980 */   895,  895,  893,  892,  854,  764,  761,  854,  763,  842,
 /*   990 */    12,  269,   58,   59,  609,  609,  770,  895,  876,  850,
 /*  1000 */    60,  895,  895,  893,  892,  553, 1020,  874,    2,  391,
 /*  1010 */   894,  674,  894,  854,  158,  156,  304,  540,  828,  895,
 /*  1020 */   895,  863,  892,  831,  541,  274,  849,  866,  830,  364,
 /*  1030 */   894,  431,  456,  795,  854,  865,  864,  863,  579,  668,
 /*  1040 */   668,  618,   23,  894,  850,  894,  895,  895,  893,  892,
 /*  1050 */  1368, 1368,  465,  849,  795,  655,  418,  394,  260,  895,
 /*  1060 */   815,  895,  895,  893,  892,  820,  894,  400,  338,  854,
 /*  1070 */   485,  543,  854,  118,  842,   12,  655,  662,  542,  839,
 /*  1080 */   838,   72,   73,  544,  296,  816,  895,  846,  846,   70,
 /*  1090 */    70,   71,   71,   71,   71,  895,   69,   69,   69,   69,
 /*  1100 */    68,   68,   67,   67,   67,   66,   64,  276,   75,  546,
 /*  1110 */   188,  591,  173,  753,  633,   86,  861,  291,  496,  895,
 /*  1120 */   895,  893,  892,  849,  894,  782,  856,  467,  551,  207,
 /*  1130 */   552,  844,  118,  453,  754,  902,    3,   61,  174,  862,
 /*  1140 */   127,  534,  518,  814,  364,  634,  782,  636,  548,  753,
 /*  1150 */   635,  895,  782,  585,   58,   59,  834,  535,  894,  765,
 /*  1160 */  1094, 1094,   60,  452,  451,  662,  895,  894,  849,  174,
 /*  1170 */     2, 1256,  443,  586,  587,  854,  895,  894,  812,  540,
 /*  1180 */   692,  895,  895,  863,  892,  357,  169,  356,  543,  866,
 /*  1190 */   523,  513,  861,  796,    4,  126,  854,  865,  864,  863,
 /*  1200 */   461,  811,  633,   86,  333, 1253,  552,  770,  895,  895,
 /*  1210 */   893,  892,  691,  690,  894,  862,  243,  895,  895,  893,
 /*  1220 */   892,  894,  524,  576,  548, 1256,  546,  519,  777,    4,
 /*  1230 */   671,  854,  861,  634,  854,  636,  842,   12,  635,  512,
 /*  1240 */   895,  810,  280,  529,  328,   92,  552,  763,  844,  588,
 /*  1250 */   834,  576,  525,  549,   61,  862,  226,  895,  827,   22,
 /*  1260 */   442,  509,  895,   52,  548,  316,  895,  664,  126,  350,
 /*  1270 */    47,   58,   59,  895,  895,  893,  892,  386,  281,   60,
 /*  1280 */   363,  430,  649,  894,  719,  608,  718,    2,  895,  895,
 /*  1290 */   893,  892,  854,  188,  894,  894,  540,  895,  895,  895,
 /*  1300 */   863,  892,  664,  649,  364,   83,  866,  894,  895,  543,
 /*  1310 */   363,  363,  513,  854,  865,  864,  863,  811,  894,  283,
 /*  1320 */    72,   73,  544,  296,  894,  894,  846,  846,   70,   70,
 /*  1330 */    71,   71,   71,   71,  287,   69,   69,   69,   69,   68,
 /*  1340 */    68,   67,   67,   67,   66,   64,  276,  546,  854,  405,
 /*  1350 */   404,  854,  352,  842,   12,  784,  809,  770,  666,  654,
 /*  1360 */   514,  718,  895,  895,  893,  892,   51,  444,  115,  844,
 /*  1370 */   504,  894,  896,  818,   21,   61,  766,  572,  641,  895,
 /*  1380 */   895,  893,  892,  808,  895,  895,  893,  892,  895,  895,
 /*  1390 */   893,  892,   58,   59,  895,  638,  126,  311,  722,  641,
 /*  1400 */    60,  403,   47,  818,  818,  572,  455,  869,    2,  763,
 /*  1410 */   486,  777,    4,  854,  505,  894,  538,  540,  814,  895,
 /*  1420 */   895,  863,  892,  759,  606,  781,    4,  866,  438,  650,
 /*  1430 */   895,  895,  893,  892,  854,  865,  864,  863,  780,    4,
 /*  1440 */    83,   72,   73,  544,  296,  606,  807,  846,  846,   70,
 /*  1450 */    70,   71,   71,   71,   71,  353,   69,   69,   69,   69,
 /*  1460 */    68,   68,   67,   67,   67,   66,   64,  276, 1251,  854,
 /*  1470 */    63,  615,  854,  201,  842,   12,  378, 1300,  123,  520,
 /*  1480 */   449,   72,   73,  544,  296,  174,   80,  846,  846,   70,
 /*  1490 */    70,   71,   71,   71,   71,  797,   69,   69,   69,   69,
 /*  1500 */    68,   68,   67,   67,   67,   66,   64,  276,  778,    4,
 /*  1510 */   779,    4,  402,  561,   47,  269,  895,  895,  893,  892,
 /*  1520 */   119,  895,   72,   73,  544,  296,  894,  894,  846,  846,
 /*  1530 */    70,   70,   71,   71,   71,   71,   20,   69,   69,   69,
 /*  1540 */    69,   68,   68,   67,   67,   67,   66,   64,  276,   72,
 /*  1550 */    73,  544,  296,  895,  767,  846,  846,   70,   70,   71,
 /*  1560 */    71,   71,   71,  766,   69,   69,   69,   69,   68,   68,
 /*  1570 */    67,   67,   67,   66,   64,  276,  791,  318,  766,  792,
 /*  1580 */    72,   73,  544,  296,  200,   56,  846,  846,   70,   70,
 /*  1590 */    71,   71,   71,   71,  766,   69,   69,   69,   69,   68,
 /*  1600 */    68,   67,   67,   67,   66,   64,  276,    5,  786,  783,
 /*  1610 */   756,   72,   73,  544,  296,  126,  733,  846,  846,   70,
 /*  1620 */    70,   71,   71,   71,   71,  755,   69,   69,   69,   69,
 /*  1630 */    68,   68,   67,   67,   67,   66,   64,  276,  428,  785,
 /*  1640 */    19,  202,  604,  895,  895,  893,  892,  728,   72,   73,
 /*  1650 */   544,  296,  894,   53,  846,  846,   70,   70,   71,   71,
 /*  1660 */    71,   71,   18,   69,   69,   69,   69,   68,   68,   67,
 /*  1670 */    67,   67,   66,   64,  276,  895,  895,  893,  892,   72,
 /*  1680 */    73,  544,  296,   17,  725,  846,  846,   70,   70,   71,
 /*  1690 */    71,   71,   71,  897,   69,   69,   69,   69,   68,   68,
 /*  1700 */    67,   67,   67,   66,   64,  276,  663,  894,   11,  117,
 /*  1710 */    72,   73,  544,  296,  172,  708,  846,  846,   70,   70,
 /*  1720 */    71,   71,   71,   71,  885,   69,   69,   69,   69,   68,
 /*  1730 */    68,   67,   67,   67,   66,   64,  276,  760,  894,  598,
 /*  1740 */   895,   72,   73,  544,  296,  191,  195,  846,  846,   70,
 /*  1750 */    70,   71,   71,   71,   71,  883,   69,   69,   69,   69,
 /*  1760 */    68,   68,   67,   67,   67,   66,   64,  276,  420,  894,
 /*  1770 */   190,  189,   72,   73,  544,  296,  748,  337,  846,  846,
 /*  1780 */    70,   70,   71,   71,   71,   71,  881,   69,   69,   69,
 /*  1790 */    69,   68,   68,   67,   67,   67,   66,   64,  276,  133,
 /*  1800 */   894,  497,  895,  743,   72,   73,  544,  296,   16,   30,
 /*  1810 */   846,  846,   70,   70,   71,   71,   71,   71,  895,   69,
 /*  1820 */    69,   69,   69,   68,   68,   67,   67,   67,   66,   64,
 /*  1830 */   276,  741, 1330,   72,   73,  544,  296,  737,  736,  846,
 /*  1840 */   846,   70,   70,   71,   71,   71,   71,  901,   69,   69,
 /*  1850 */    69,   69,   68,   68,   67,   67,   67,   66,   64,  276,
 /*  1860 */   895, 1328,  895,  895,  893,  892,  489,  488,   72,   73,
 /*  1870 */   544,  296,  543,  487,  846,  846,   70,   70,   71,   71,
 /*  1880 */    71,   71,   40,   69,   69,   69,   69,   68,   68,   67,
 /*  1890 */    67,   67,   66,   64,  276,  731,   72,   41,  544,  296,
 /*  1900 */   660,  895,  846,  846,   70,   70,   71,   71,   71,   71,
 /*  1910 */   546,   69,   69,   69,   69,   68,   68,   67,   67,   67,
 /*  1920 */    66,   64,  276,  878,  895,  895,  893,  892,  484,   39,
 /*  1930 */   871,  399,  844,  585,  596,  427,   15,  894,   61,  600,
 /*  1940 */   895,  895,  893,  892,  894,  894,  861,  894,  132,  894,
 /*  1950 */   302,  124,  278,  586,  424,   58,   59,   26,  859,  186,
 /*  1960 */   552,  895,  301,   60,  286,  373,  698, 1258,  476,  862,
 /*  1970 */   226,    2,  894,  543,  852,   38,  854,  689,  548,  473,
 /*  1980 */   540,   89,  895,  895,  863,  892,  339,  165, 1258,   88,
 /*  1990 */   866,  136,   25,  895, 1258,  861,  370,  854,  865,  864,
 /*  2000 */   863,  372,  180,  319,  596,   87,  468,  112,  463,  552,
 /*  2010 */    83,  546,  164,  131,  345,  667,  205,  602,  862,  243,
 /*  2020 */   163,  161,   10,  895,  895,  893,  892,  548,  895,  425,
 /*  2030 */   834,  811,  854,  844,  108,  854,  527,  842,   12,   61,
 /*  2040 */   159, 1258,  776,   37,  426,  851,  895,  422,  597, 1258,
 /*  2050 */   374,  388,  194,  602, 1258,  289,   58,   59,  894,  894,
 /*  2060 */    36,  894,  895,  106,   60,   35,   34, 1247,  351,  787,
 /*  2070 */   398,  396,    2,  707,  543,  105,  772,  854,  104, 1258,
 /*  2080 */   386,  540,  895,  895,  895,  893,  892,  315,  295,  294,
 /*  2090 */   894,  866, 1258,  387, 1258, 1258,  861,  768,  854,  865,
 /*  2100 */   864,  863,  643, 1258,  637, 1258, 1258,  762, 1258,  632,
 /*  2110 */   552,  894,  546,  170,  440,  895,  895,  893,  892,  862,
 /*  2120 */   243,  894,  582,  895,  630,  113, 1258,  894,  548,  500,
 /*  2130 */   423,  836,  835,  854,  844,  584,  854,  583,  842,   12,
 /*  2140 */    61,  624,  174,  894,  599,  895,  730,  341,  154,  313,
 /*  2150 */   895,  895,  893,  892,   13,  310,  288,   58,   59,  184,
 /*  2160 */   894,  894,  560,  895,  209,   60,  861,  895,  895,  895,
 /*  2170 */   893,  892,  152,    2,  336,  543,   99,  705,  854,  605,
 /*  2180 */   552,  386,  540,  560,  895,  895,  863,  892,  884,  862,
 /*  2190 */   243,  894,  866,  599,  895,  683,  861,   90,  548,  854,
 /*  2200 */   865,  864,  863,  335,  895,  895,  893,  892,  669,  894,
 /*  2210 */   552,  581,  144,  546,  151,  150,  149,  894,  330,  862,
 /*  2220 */   243,  580,  894,  419,  457,  147,  525,  503,  548,  882,
 /*  2230 */   861,  265,  894,  558,  854,  844,  661,  854,  894,  842,
 /*  2240 */    12,   61,   97,  269,  552,  895,  895,  893,  892,  658,
 /*  2250 */   894,  386,  285,  862,  127,  121,  525,  410,   58,   59,
 /*  2260 */   813,  434,  548,  894,  568,  261,   60,  895,  895,  893,
 /*  2270 */   892,  390,  898,  880,    2,  894,  182,  888,  894,  854,
 /*  2280 */   389,  386,  887,  540,  895,  895,  895,  863,  892,  895,
 /*  2290 */   895,  893,  892,  866,  886,  421,  543,  861,  566,  464,
 /*  2300 */   854,  865,  864,  863,  193,  555,  181,   78,  895,  894,
 /*  2310 */   367,  552,  894,  861,  554,  811,  895,  895,  893,  892,
 /*  2320 */   862,  127,  179,  111,  894,  861,  857,  552,  176,  548,
 /*  2330 */   895,  276,  547,   91,  546,  854,  862,  243,  854,  552,
 /*  2340 */   842,   12, 1254,  362,  861,  548,  894,  895,  862,  127,
 /*  2350 */   331,  454,  273,  536,  293,  312,  844,  548,  552,  543,
 /*  2360 */   414,  861,   61,  292,  894,  894,  771,  862,  127,  894,
 /*  2370 */   359,  192,  895,  411,   54,  552,  548,  895,   24,   58,
 /*  2380 */    59,  358,  811,  508,  862,  127,  203,   60,  861,  309,
 /*  2390 */    50,   46,  895,  548,  805,    2, 1256,  546,  386,  409,
 /*  2400 */   854,  303,  552,  894,  540,  895,  895,  895,  863,  892,
 /*  2410 */   811,  862,  243,  299,  866,  894,  355,  524,  397,  844,
 /*  2420 */   548,  854,  865,  864,  863,   61,  804,  894,  803,  811,
 /*  2430 */   895,  895,  893,  892,  413,  395,  266,  300,  895,  800,
 /*  2440 */   794,  187,   58,   59,  496,  695,  811,  141,  895,  788,
 /*  2450 */    60,  894,  895,  895,  893,  892,  854,  895,    2,  854,
 /*  2460 */   543,  842,   12,  854,  732,  495,  169,  540,  895,  895,
 /*  2470 */   895,  863,  892,  532,  895,  714,  361,  866,  895,  720,
 /*  2480 */   481,  715,  895,  407,  854,  865,  864,  863,   79,  861,
 /*  2490 */   343,  711,  710,  750,  895,  895,  893,  892,  546,  895,
 /*  2500 */   895,  893,  892,  552,  709,  380,  895,  688,  681,  861,
 /*  2510 */   680,  679,  862,  243,  895,  895,  893,  892,  678,  854,
 /*  2520 */   844,  548,  854,  552,  842,   12,   61,  895,  895,  893,
 /*  2530 */   892,  379,  862,  234,  109,  749,  271,  140,  704,  462,
 /*  2540 */   682,  548,  162,   58,   59,  329,  441,  459,   33,  507,
 /*  2550 */   327,   60,  326,  210,  325,  107,  656,  185,  322,    2,
 /*  2560 */   895,  895,  893,  892,  854,  895,  114,  320,  540,  895,
 /*  2570 */   895,  895,  893,  892,  386,  675,  895,  321,  866,  895,
 /*  2580 */   895,  893,  892,  670,  652,  854,  865,  864,  863,  317,
 /*  2590 */   895,  895,  893,  892,  811,  895,  895,  895,  893,  892,
 /*  2600 */   895,  895,  893,  892,  895,  895,  893,  892,  665,  199,
 /*  2610 */   447,  629,  895,  448,  646,  659,  895,  642,  640,  653,
 /*  2620 */   854,  616,  138,  854,  435,  842,   12,  155,  895,  895,
 /*  2630 */   893,  892,  620,   73,  544,  296,  137,  432,  846,  846,
 /*  2640 */    70,   70,   71,   71,   71,   71,  153,   69,   69,   69,
 /*  2650 */    69,   68,   68,   67,   67,   67,   66,   64,  276,  895,
 /*  2660 */   103,  544,  296,  895,  429,  846,  846,   70,   70,   71,
 /*  2670 */    71,   71,   71,  895,   69,   69,   69,   69,   68,   68,
 /*  2680 */    67,   67,   67,   66,   64,  276,  102,  895,  895,  893,
 /*  2690 */   892,  895,  895,  893,  892,  101,  895,  100,  895,  895,
 /*  2700 */   893,  892,  350,  895,  590,  393,  648,   32,  895,  575,
 /*  2710 */   502,  148,   31,  895,  577,   28,  894,  895,  895,  893,
 /*  2720 */   892,  895,  135,  571,  134,  657,   85,  563,  183,  861,
 /*  2730 */   895,  861,  619,   65,  895,  895,  893,  892,  895,  895,
 /*  2740 */   893,  892,  895,  552,  822,  552,  895,  211,  126,  607,
 /*  2750 */   360,  533,  862,  246,  862,  244,  837,  833,  197,  621,
 /*  2760 */   196,  548,  774,  548,  344,  257,  501,  381,  603,  706,
 /*  2770 */   472,  647,  323,  895,  645,  145,  375,  861,    7,  847,
 /*  2780 */   832,  895,  895,  893,  892,  895,  895,  893,  892,  821,
 /*  2790 */   693,  552,  460,  270,   44,  895,  895,  893,  892,  204,
 /*  2800 */   862,  254,  545,  793,   98,  703,  697,  724,  614,  548,
 /*  2810 */   569,  567,  723,  696,  811,   83,  811, 1412,  895,  895,
 /*  2820 */   893,  892, 1412,  684,  601,  895,  895,  893,  892,  565,
 /*  2830 */   895,  895,  893,  892, 1412,  895,  895,  893,  892, 1412,
 /*  2840 */  1412, 1412, 1412,  895,  895,  893,  892,  589, 1412,  861,
 /*  2850 */  1412, 1412,  895,  895,  893,  892, 1412, 1412, 1412, 1412,
 /*  2860 */   861,  813,  811,  552,  895,  895,  893,  892,  895,  895,
 /*  2870 */   893,  892,  862,  253,  552,  564,  861, 1412, 1412, 1412,
 /*  2880 */  1412,  548, 1412,  862,  255,  819, 1412,  861, 1412,  861,
 /*  2890 */   552, 1412,  548,  861,  685,  895,  895,  893,  892,  862,
 /*  2900 */   256,  552,  769,  552,  861, 1412,  861,  552,  548, 1412,
 /*  2910 */   862,  275,  862,  366, 1412,   32,  862,  252,  552,  548,
 /*  2920 */   552,  548, 1412,  861, 1412,  548, 1412,  862,  365,  862,
 /*  2930 */   222, 1412, 1412, 1412,  811,  861,  548,  552,  548,  861,
 /*  2940 */  1412, 1412, 1412, 1412, 1412,  811,  862,  240, 1412,  552,
 /*  2950 */  1412, 1412, 1412,  552, 1412,  548, 1412, 1412,  862,  245,
 /*  2960 */  1412,  811,  862,  384, 1412, 1412, 1412,  548, 1412, 1412,
 /*  2970 */  1412,  548,  811, 1412,  811, 1412, 1412, 1412,  811, 1412,
 /*  2980 */  1412, 1412,  861, 1412, 1412, 1412,  861, 1412, 1412,  811,
 /*  2990 */  1412,  811, 1412,  861, 1412, 1412,  552, 1412, 1412, 1412,
 /*  3000 */   552, 1412, 1412, 1412, 1412,  862,  383,  552,  811,  862,
 /*  3010 */   382, 1412, 1412, 1412,  548,  861,  862,  239,  548,  861,
 /*  3020 */   811,  861, 1412, 1412,  811,  548,  861, 1412, 1412,  552,
 /*  3030 */  1412, 1412,  861,  552, 1412,  552, 1412, 1412,  862,  224,
 /*  3040 */   552, 1412,  862,  238,  862,  237,  552,  548, 1412,  862,
 /*  3050 */   223,  548,  861,  548, 1412,  862,  251, 1412,  548,  861,
 /*  3060 */  1412, 1412, 1412, 1412,  548,  861,  552,  811, 1412, 1412,
 /*  3070 */  1412,  811, 1412,  552, 1412,  862,  250, 1412,  811,  552,
 /*  3080 */  1412, 1412,  862,  212,  548, 1412, 1412, 1412,  862,  221,
 /*  3090 */  1412,  548, 1412, 1412, 1412,  861, 1412,  548,  861, 1412,
 /*  3100 */   811,  861, 1412, 1412,  811, 1412,  811, 1412, 1412,  552,
 /*  3110 */  1412,  811,  552, 1412, 1412,  552, 1412,  811,  862,  220,
 /*  3120 */  1412,  862,  128, 1412,  862,  219, 1412,  548,  861, 1412,
 /*  3130 */   548, 1412,  861,  548,  861, 1412, 1412,  811, 1412,  861,
 /*  3140 */  1412, 1412,  552, 1412,  811, 1412,  552, 1412,  552, 1412,
 /*  3150 */   811,  862,  217,  552, 1412,  862,  247,  862,  249, 1412,
 /*  3160 */   548, 1412,  862,  242,  548, 1412,  548,  861, 1412, 1412,
 /*  3170 */  1412,  548, 1412, 1412, 1412, 1412, 1412, 1412, 1412,  861,
 /*  3180 */   811,  552, 1412,  811, 1412, 1412,  811, 1412, 1412, 1412,
 /*  3190 */   862,  248, 1412,  552, 1412, 1412, 1412, 1412,  861,  548,
 /*  3200 */  1412, 1412,  862,  236, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3210 */  1412,  548,  552,  811,  861, 1412, 1412,  811, 1412,  811,
 /*  3220 */  1412,  862,  235, 1412,  811,  861, 1412, 1412,  552, 1412,
 /*  3230 */   548,  861, 1412, 1412, 1412, 1412, 1412,  862,  232,  552,
 /*  3240 */  1412, 1412, 1412, 1412,  861,  552,  548,  861,  862,  216,
 /*  3250 */  1412, 1412,  811, 1412,  862,  215, 1412,  548,  552, 1412,
 /*  3260 */  1412,  552, 1412,  548,  811, 1412, 1412,  862,  214, 1412,
 /*  3270 */   862,  213,  861, 1412, 1412, 1412,  548, 1412, 1412,  548,
 /*  3280 */  1412, 1412, 1412,  811, 1412, 1412,  552, 1412,  861, 1412,
 /*  3290 */  1412, 1412, 1412, 1412,  861,  862,  225, 1412, 1412,  811,
 /*  3300 */  1412, 1412,  552, 1412,  548, 1412, 1412, 1412,  552, 1412,
 /*  3310 */   811,  862,  230, 1412,  861, 1412,  811,  862,  229, 1412,
 /*  3320 */   548, 1412, 1412, 1412, 1412, 1412,  548,  861,  552,  811,
 /*  3330 */   861, 1412,  811, 1412, 1412, 1412, 1412,  862,  129, 1412,
 /*  3340 */  1412,  552,  861, 1412,  552, 1412,  548, 1412, 1412, 1412,
 /*  3350 */   862,  228, 1412,  862,  227, 1412,  552,  811,  861,  548,
 /*  3360 */  1412,  861,  548,  861, 1412,  862,  241, 1412, 1412, 1412,
 /*  3370 */  1412, 1412,  552,  811,  548,  552, 1412,  552, 1412,  811,
 /*  3380 */  1412,  862,  233, 1412,  862,  231,  862,  218, 1412, 1412,
 /*  3390 */   548, 1412, 1412,  548, 1412,  548,  861, 1412, 1412,  811,
 /*  3400 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3410 */   552, 1412,  811, 1412, 1412,  811, 1412, 1412, 1412,  862,
 /*  3420 */    96, 1412, 1412, 1412, 1412, 1412, 1412,  811,  499, 1412,
 /*  3430 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3440 */  1412, 1412, 1412,  811, 1412, 1412,  811, 1412,  811, 1412,
 /*  3450 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3460 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3470 */  1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
 /*  3480 */  1412,  811,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  147,  148,  149,   48,    4,   21,   80,   81,   82,
 /*    10 */    83,    0,   16,   86,   87,   88,   89,   90,   91,   92,
 /*    20 */    93,   36,   95,   96,   97,   98,   99,  100,  101,  102,
 /*    30 */   103,  104,  105,  106,   71,  108,   80,   81,   82,   83,
 /*    40 */    29,  108,   86,   87,   88,   89,   90,   91,   92,   93,
 /*    50 */    54,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*    60 */   104,  105,  106,    4,  108,   40,   41,  251,  252,    4,
 /*    70 */   254,  108,   76,   75,   90,   91,   92,   93,   82,   95,
 /*    80 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*    90 */   106,  204,  128,  112,  101,   99,  100,  101,  134,  116,
 /*   100 */   204,    4,  286,  107,  108,  218,  142,  143,  144,   84,
 /*   110 */    85,  115,  116,   16,  218,   66,  120,  121,   69,  108,
 /*   120 */   124,   24,  126,  127,  128,  129,   66,  126,  127,   69,
 /*   130 */   134,  101,  102,  103,  104,  105,  106,  141,  142,  143,
 /*   140 */   144,   76,  146,   99,  100,  101,  102,  103,  104,  105,
 /*   150 */   106,   54,  154,  160,  116,  159,  163,  161,  162,  121,
 /*   160 */     4,  165,  275,  114,   99,  100,  170,  171,  172,  173,
 /*   170 */   174,  175,  176,   76,  114,  179,    4,  181,  182,   82,
 /*   180 */   115,  104,  105,  106,  204,  126,  127,  128,  129,  193,
 /*   190 */   192,  126,  127,  128,  214,  215,   99,  100,  218,  134,
 /*   200 */   141,  115,    4,  117,  107,  108,   41,  142,  143,  144,
 /*   210 */   121,  121,  115,  116,   16,   34,  320,  120,  121,  204,
 /*   220 */   240,  124,  242,  126,  127,  128,  129,   79,  115,   19,
 /*   230 */     4,  134,   51,  218,  234,  176,   55,  237,  141,  142,
 /*   240 */   143,  144,   61,  146,  244,    4,  186,   82,  159,  196,
 /*   250 */   161,  162,   54,   43,  201,    7,  159,  116,  161,  162,
 /*   260 */    12,    4,  121,  115,  116,  212,   15,  170,  171,  172,
 /*   270 */   173,    5,  175,  176,   76,   65,  179,  116,  181,  182,
 /*   280 */    82,  125,  126,  127,  128,  129,   38,  115,  132,  117,
 /*   290 */   193,  135,  136,  137,   43,  146,   30,   99,  100,  116,
 /*   300 */   128,   35,  249,  250,  121,  107,  108,  204,  121,  153,
 /*   310 */    59,  146,  297,  115,  116,  166,   34,  152,  120,  121,
 /*   320 */   204,  218,  124,    4,  126,  127,  128,  129,   62,    4,
 /*   330 */   115,  170,  134,  280,  218,  282,  164,   55,  285,  141,
 /*   340 */   142,  143,  144,   61,  146,  183,  120,  185,  204,   99,
 /*   350 */   100,  170,  126,  127,  128,  129,  115,  159,  101,  161,
 /*   360 */   162,  174,  218,    4,  311,   40,   41,  141,  170,  128,
 /*   370 */   172,  173,  116,  175,  176,   21,  134,  179,  275,  181,
 /*   380 */   182,  171,   28,  126,  127,  128,  129,  243,   82,  121,
 /*   390 */    36,  193,  142,  143,  152,  169,    4,  129,  141,  283,
 /*   400 */     4,   26,  151,  121,  121,   80,   81,   82,   83,   84,
 /*   410 */    85,   86,   87,   88,   89,   90,   91,   92,   93,    4,
 /*   420 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   430 */   105,  106,   73,  176,  115,  167,  168,  251,  252,  120,
 /*   440 */   254,  297,  117,   24,   31,  126,  127,  128,  129,  295,
 /*   450 */    40,   41,   39,  128,  116,   80,   81,   82,   83,  121,
 /*   460 */    50,   86,   87,   88,   89,   90,   91,   92,   93,  163,
 /*   470 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   480 */   105,  106,  123,  329,  330,  126,  127,  128,  129,  164,
 /*   490 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   500 */    90,   91,   92,   93,  295,   95,   96,   97,   98,   99,
 /*   510 */   100,  101,  102,  103,  104,  105,  106,   10,  126,  127,
 /*   520 */   128,  129,  126,  127,  128,  129,   58,  133,  134,   22,
 /*   530 */   290,  121,   34,  141,  115,  120,   17,  141,  329,  330,
 /*   540 */   204,  126,  127,  128,  129,  209,   42,   40,   41,  309,
 /*   550 */   214,  215,  156,   55,  218,  140,  141,  121,  183,   61,
 /*   560 */   185,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   570 */    99,  100,  101,  102,  103,  104,  105,  106,  116,  121,
 /*   580 */     4,  145,   79,  121,  169,   26,   82,   80,   81,   82,
 /*   590 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   600 */    93,   89,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   610 */   103,  104,  105,  106,  118,  147,  148,  149,  115,  116,
 /*   620 */   223,  224,  225,  165,  121,  157,  158,  115,   40,   41,
 /*   630 */    79,  112,  132,  116,  206,  135,  136,  137,  121,   80,
 /*   640 */    81,   82,   83,   13,    4,   86,   87,   88,   89,   90,
 /*   650 */    91,   92,   93,  153,   95,   96,   97,   98,   99,  100,
 /*   660 */   101,  102,  103,  104,  105,  106,  115,  116,   80,   81,
 /*   670 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   680 */    92,   93,  118,   95,   96,   97,   98,   99,  100,  101,
 /*   690 */   102,  103,  104,  105,  106,    4,  120,  115,  301,  147,
 /*   700 */   148,  149,  126,  127,  128,  129,  226,   16,  117,  118,
 /*   710 */    80,   81,   82,   83,  234,  235,   86,   87,   88,   89,
 /*   720 */    90,   91,   92,   93,  296,   95,   96,   97,   98,   99,
 /*   730 */   100,  101,  102,  103,  104,  105,  106,  121,  108,    5,
 /*   740 */    79,    4,  183,  134,  185,   54,   95,   96,   97,   98,
 /*   750 */    99,  100,  101,  102,  103,  104,  105,  106,    4,  142,
 /*   760 */   143,  204,   71,    4,   30,  189,  220,   76,  128,   35,
 /*   770 */   204,  214,  215,   82,  204,  218,  115,  116,  212,  121,
 /*   780 */   140,  216,  121,  213,  218,  220,  221,  222,  218,    4,
 /*   790 */    99,  100,   58,  227,  228,    4,   62,  149,  107,   64,
 /*   800 */   256,  116,  236,  117,  118,   70,  115,  116,   71,  295,
 /*   810 */   266,  120,    4,  267,  204,  124,  250,  126,  127,  128,
 /*   820 */   129,    4,  212,  165,   16,  134,  178,   19,  218,  115,
 /*   830 */   264,  265,  141,  142,  143,  144,  290,  227,  228,  197,
 /*   840 */   198,  199,  200,  329,  330,  204,  236,  204,  157,  158,
 /*   850 */    72,  115,  115,  116,    4,  289,   78,  120,    4,  218,
 /*   860 */   250,  218,   54,  126,  127,  128,  129,  176,  227,  228,
 /*   870 */   179,  136,  181,  182,  264,   67,  122,  236,  141,    4,
 /*   880 */   126,  127,  128,  129,   76,  126,  127,  128,  129,   10,
 /*   890 */    82,  121,   84,  156,  157,  158,  204,    4,  139,  289,
 /*   900 */   115,   22,    4,   82,   41,  120,  115,   99,  100,   16,
 /*   910 */   218,  126,  127,  128,  129,  107,  116,  126,  127,  128,
 /*   920 */   129,  186,  160,  115,    4,  163,  141,  106,  120,    4,
 /*   930 */   289,  230,  124,  212,  126,  127,  128,  129,  117,    4,
 /*   940 */   170,  156,  134,  126,  127,  128,  129,   54,  127,  141,
 /*   950 */   142,  143,  144,  132,  133,  134,  135,  136,  137,  138,
 /*   960 */   268,  269,  319,  320,   71,  324,  121,  176,  327,   76,
 /*   970 */   120,  250,  194,  152,  120,   82,  126,  127,  128,  129,
 /*   980 */   126,  127,  128,  129,  176,  274,  169,  179,  277,  181,
 /*   990 */   182,  290,   99,  100,  119,  120,  204,    4,  204,    4,
 /*  1000 */   107,  126,  127,  128,  129,  211,  116,  213,  115,  146,
 /*  1010 */   218,  121,  218,  120,  117,  118,  204,  124,  116,  126,
 /*  1020 */   127,  128,  129,  220,  221,  222,  128,  134,  130,  204,
 /*  1030 */   218,  204,  256,   32,  141,  142,  143,  144,  188,  119,
 /*  1040 */   120,  187,  266,  218,    4,  218,  126,  127,  128,  129,
 /*  1050 */   157,  158,  204,  128,   53,  120,  208,  312,  313,    4,
 /*  1060 */   116,  126,  127,  128,  129,  140,  218,  275,  116,  176,
 /*  1070 */    78,   16,  179,  121,  181,  182,  141,  212,  223,  224,
 /*  1080 */   225,   80,   81,   82,   83,   42,    4,   86,   87,   88,
 /*  1090 */    89,   90,   91,   92,   93,    4,   95,   96,   97,   98,
 /*  1100 */    99,  100,  101,  102,  103,  104,  105,  106,  115,   54,
 /*  1110 */   204,  299,  117,  120,  249,  250,  204,  157,  158,  126,
 /*  1120 */   127,  128,  129,  128,  218,   34,  252,  116,  254,  115,
 /*  1130 */   218,   76,  121,  116,  141,  199,  200,   82,  121,  227,
 /*  1140 */   228,  316,   51,  318,  204,  280,   55,  282,  236,  156,
 /*  1150 */   285,    4,   61,  204,   99,  100,  301,  212,  218,  164,
 /*  1160 */   167,  168,  107,  204,  116,  212,    4,  218,  128,  121,
 /*  1170 */   115,  116,  307,  224,  225,  120,    4,  218,   26,  124,
 /*  1180 */   140,  126,  127,  128,  129,  261,  194,  263,   16,  134,
 /*  1190 */   278,   19,  204,  322,  323,  250,  141,  142,  143,  144,
 /*  1200 */   204,  289,  249,  250,  208,  183,  218,  204,  126,  127,
 /*  1210 */   128,  129,  218,  219,  218,  227,  228,  126,  127,  128,
 /*  1220 */   129,  218,  170,  141,  236,  170,   54,  321,  322,  323,
 /*  1230 */   212,  176,  204,  280,  179,  282,  181,  182,  285,   67,
 /*  1240 */     4,  116,  283,  163,  274,  193,  218,  277,   76,  300,
 /*  1250 */   301,  169,  264,  265,   82,  227,  228,    4,  318,  306,
 /*  1260 */   307,  170,    4,  165,  236,  116,    4,  120,  250,  204,
 /*  1270 */   121,   99,  100,  126,  127,  128,  129,  289,  275,  107,
 /*  1280 */   204,  204,  120,  218,  245,  208,  247,  115,  126,  127,
 /*  1290 */   128,  129,  120,  204,  218,  218,  124,    4,  126,  127,
 /*  1300 */   128,  129,  155,  141,  204,   71,  134,  218,    4,   16,
 /*  1310 */   204,  204,   19,  141,  142,  143,  144,  289,  218,  243,
 /*  1320 */    80,   81,   82,   83,  218,  218,   86,   87,   88,   89,
 /*  1330 */    90,   91,   92,   93,  269,   95,   96,   97,   98,   99,
 /*  1340 */   100,  101,  102,  103,  104,  105,  106,   54,  176,  243,
 /*  1350 */   243,  179,  324,  181,  182,  327,  116,  204,  212,  245,
 /*  1360 */    67,  247,  126,  127,  128,  129,  165,  133,  115,   76,
 /*  1370 */    82,  218,  110,  297,   14,   82,  220,  141,  120,  126,
 /*  1380 */   127,  128,  129,  116,  126,  127,  128,  129,  126,  127,
 /*  1390 */   128,  129,   99,  100,    4,   26,  250,  116,  218,  141,
 /*  1400 */   107,  204,  121,  297,  297,  169,  274,  227,  115,  277,
 /*  1410 */   321,  322,  323,  120,  126,  218,  316,  124,  318,  126,
 /*  1420 */   127,  128,  129,  267,  120,  322,  323,  134,  275,  176,
 /*  1430 */   126,  127,  128,  129,  141,  142,  143,  144,  322,  323,
 /*  1440 */    71,   80,   81,   82,   83,  141,  116,   86,   87,   88,
 /*  1450 */    89,   90,   91,   92,   93,  230,   95,   96,   97,   98,
 /*  1460 */    99,  100,  101,  102,  103,  104,  105,  106,   26,  176,
 /*  1470 */   121,  116,  179,  276,  181,  182,  121,  108,  117,  117,
 /*  1480 */   116,   80,   81,   82,   83,  121,  115,   86,   87,   88,
 /*  1490 */    89,   90,   91,   92,   93,  116,   95,   96,   97,   98,
 /*  1500 */    99,  100,  101,  102,  103,  104,  105,  106,  322,  323,
 /*  1510 */   322,  323,  204,  204,  121,  290,  126,  127,  128,  129,
 /*  1520 */   121,    4,   80,   81,   82,   83,  218,  218,   86,   87,
 /*  1530 */    88,   89,   90,   91,   92,   93,   14,   95,   96,   97,
 /*  1540 */    98,   99,  100,  101,  102,  103,  104,  105,  106,   80,
 /*  1550 */    81,   82,   83,    4,  164,   86,   87,   88,   89,   90,
 /*  1560 */    91,   92,   93,  220,   95,   96,   97,   98,   99,  100,
 /*  1570 */   101,  102,  103,  104,  105,  106,   60,  212,  220,   45,
 /*  1580 */    80,   81,   82,   83,  276,  184,   86,   87,   88,   89,
 /*  1590 */    90,   91,   92,   93,  220,   95,   96,   97,   98,   99,
 /*  1600 */   100,  101,  102,  103,  104,  105,  106,   81,   32,   53,
 /*  1610 */   267,   80,   81,   82,   83,  250,  116,   86,   87,   88,
 /*  1620 */    89,   90,   91,   92,   93,  267,   95,   96,   97,   98,
 /*  1630 */    99,  100,  101,  102,  103,  104,  105,  106,  204,   60,
 /*  1640 */    14,  267,  208,  126,  127,  128,  129,  116,   80,   81,
 /*  1650 */    82,   83,  218,  184,   86,   87,   88,   89,   90,   91,
 /*  1660 */    92,   93,   14,   95,   96,   97,   98,   99,  100,  101,
 /*  1670 */   102,  103,  104,  105,  106,  126,  127,  128,  129,   80,
 /*  1680 */    81,   82,   83,   14,  116,   86,   87,   88,   89,   90,
 /*  1690 */    91,   92,   93,  204,   95,   96,   97,   98,   99,  100,
 /*  1700 */   101,  102,  103,  104,  105,  106,  189,  218,   14,  115,
 /*  1710 */    80,   81,   82,   83,   14,  116,   86,   87,   88,   89,
 /*  1720 */    90,   91,   92,   93,  204,   95,   96,   97,   98,   99,
 /*  1730 */   100,  101,  102,  103,  104,  105,  106,  126,  218,  190,
 /*  1740 */     4,   80,   81,   82,   83,  116,  116,   86,   87,   88,
 /*  1750 */    89,   90,   91,   92,   93,  204,   95,   96,   97,   98,
 /*  1760 */    99,  100,  101,  102,  103,  104,  105,  106,   29,  218,
 /*  1770 */   116,  116,   80,   81,   82,   83,  167,  116,   86,   87,
 /*  1780 */    88,   89,   90,   91,   92,   93,  204,   95,   96,   97,
 /*  1790 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  118,
 /*  1800 */   218,  118,    4,  101,   80,   81,   82,   83,  115,  117,
 /*  1810 */    86,   87,   88,   89,   90,   91,   92,   93,    4,   95,
 /*  1820 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1830 */   106,  160,  108,   80,   81,   82,   83,  116,  116,   86,
 /*  1840 */    87,   88,   89,   90,   91,   92,   93,  108,   95,   96,
 /*  1850 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1860 */     4,  108,  126,  127,  128,  129,  171,  115,   80,   81,
 /*  1870 */    82,   83,   16,  170,   86,   87,   88,   89,   90,   91,
 /*  1880 */    92,   93,   14,   95,   96,   97,   98,   99,  100,  101,
 /*  1890 */   102,  103,  104,  105,  106,  116,   80,   81,   82,   83,
 /*  1900 */   164,    4,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1910 */    54,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1920 */   104,  105,  106,  204,  126,  127,  128,  129,  115,  174,
 /*  1930 */   204,  204,   76,  204,  120,  204,   14,  218,   82,  208,
 /*  1940 */   126,  127,  128,  129,  218,  218,  204,  218,    9,  218,
 /*  1950 */    11,  116,   13,  224,  225,   99,  100,  115,  204,   18,
 /*  1960 */   218,    4,   23,  107,   48,   26,    6,   34,  117,  227,
 /*  1970 */   228,  115,  218,   16,  176,  115,  120,    8,  236,   48,
 /*  1980 */   124,  115,  126,  127,  128,  129,  116,  138,   55,  115,
 /*  1990 */   134,   52,  115,    4,   61,  204,   57,  141,  142,  143,
 /*  2000 */   144,   62,   63,  276,  190,  115,   48,   68,   82,  218,
 /*  2010 */    71,   54,  118,   74,  152,  124,  117,  120,  227,  228,
 /*  2020 */   118,  146,   13,  126,  127,  128,  129,  236,    4,  300,
 /*  2030 */   301,  289,  176,   76,  165,  179,  180,  181,  182,   82,
 /*  2040 */   117,  108,  121,   89,  204,  204,    4,  204,  208,  116,
 /*  2050 */   111,  208,  113,  156,  121,  264,   99,  100,  218,  218,
 /*  2060 */    89,  218,    4,  151,  107,   89,   89,  108,  326,  327,
 /*  2070 */    18,   24,  115,  116,   16,  177,  204,  120,  151,  146,
 /*  2080 */   289,  124,    4,  126,  127,  128,  129,  158,   99,  100,
 /*  2090 */   218,  134,  159,  154,  161,  162,  204,  204,  141,  142,
 /*  2100 */   143,  144,  178,  170,  108,  172,  173,  204,  175,  108,
 /*  2110 */   218,  218,   54,  204,   25,  126,  127,  128,  129,  227,
 /*  2120 */   228,  218,  133,    4,   60,   49,  193,  218,  236,  204,
 /*  2130 */   191,  142,  143,  176,   76,  146,  179,  148,  181,  182,
 /*  2140 */    82,   49,  121,  218,  120,    4,  204,  204,  146,  186,
 /*  2150 */   126,  127,  128,  129,  115,  114,  264,   99,  100,  166,
 /*  2160 */   218,  218,  120,    4,  115,  107,  204,    4,  126,  127,
 /*  2170 */   128,  129,  118,  115,  116,   16,  114,  204,  120,  124,
 /*  2180 */   218,  289,  124,  141,  126,  127,  128,  129,  110,  227,
 /*  2190 */   228,  218,  134,  169,    4,  204,  204,   56,  236,  141,
 /*  2200 */   142,  143,  144,  204,  126,  127,  128,  129,  204,  218,
 /*  2210 */   218,  116,  112,   54,  118,  118,  118,  218,  204,  227,
 /*  2220 */   228,  116,  218,   47,  204,  118,  264,  265,  236,  110,
 /*  2230 */   204,  270,  218,   46,  176,   76,  204,  179,  218,  181,
 /*  2240 */   182,   82,  217,  290,  218,  126,  127,  128,  129,  204,
 /*  2250 */   218,  289,  233,  227,  228,  233,  264,  265,   99,  100,
 /*  2260 */   119,  204,  236,  218,  204,  313,  107,  126,  127,  128,
 /*  2270 */   129,  315,  203,  110,  115,  218,  109,  203,  218,  120,
 /*  2280 */   315,  289,  203,  124,    4,  126,  127,  128,  129,  126,
 /*  2290 */   127,  128,  129,  134,   63,  204,   16,  204,  204,   77,
 /*  2300 */   141,  142,  143,  144,  278,  203,  205,  121,    4,  218,
 /*  2310 */   204,  218,  218,  204,  210,  289,  126,  127,  128,  129,
 /*  2320 */   227,  228,  205,  207,  218,  204,  273,  218,  118,  236,
 /*  2330 */     4,  106,  204,  115,   54,  176,  227,  228,  179,  218,
 /*  2340 */   181,  182,  183,  232,  204,  236,  218,    4,  227,  228,
 /*  2350 */   204,  204,  106,  317,  298,  204,   76,  236,  218,   16,
 /*  2360 */   117,  204,   82,  293,  218,  218,  176,  227,  228,  218,
 /*  2370 */   258,  278,    4,  264,  183,  218,  236,    4,  174,   99,
 /*  2380 */   100,  259,  289,  171,  227,  228,  260,  107,  204,  204,
 /*  2390 */   173,  172,    4,  236,  262,  115,  116,   54,  289,  278,
 /*  2400 */   120,  204,  218,  218,  124,    4,  126,  127,  128,  129,
 /*  2410 */   289,  227,  228,  204,  134,  218,  261,  170,  278,   76,
 /*  2420 */   236,  141,  142,  143,  144,   82,  262,  218,  279,  289,
 /*  2430 */   126,  127,  128,  129,   44,  278,   27,  204,    4,  279,
 /*  2440 */   325,  273,   99,  100,  158,  141,  289,  118,    4,  325,
 /*  2450 */   107,  218,  126,  127,  128,  129,  176,    4,  115,  179,
 /*  2460 */    16,  181,  182,  120,  330,  254,  194,  124,    4,  126,
 /*  2470 */   127,  128,  129,  289,    4,  239,  292,  134,    4,  229,
 /*  2480 */   146,  229,    4,   37,  141,  142,  143,  144,  115,  204,
 /*  2490 */   229,  231,  145,  167,  126,  127,  128,  129,   54,  126,
 /*  2500 */   127,  128,  129,  218,  229,  232,    4,  239,  229,  204,
 /*  2510 */   229,  229,  227,  228,  126,  127,  128,  129,  229,  176,
 /*  2520 */    76,  236,  179,  218,  181,  182,   82,  126,  127,  128,
 /*  2530 */   129,  232,  227,  228,  207,  167,  273,  207,  150,  232,
 /*  2540 */   139,  236,  118,   99,  100,  304,   33,  305,  183,  264,
 /*  2550 */   258,  107,  281,  175,  261,  246,  262,   80,  258,  115,
 /*  2560 */   126,  127,  128,  129,  120,    4,  115,  261,  124,    4,
 /*  2570 */   126,  127,  128,  129,  289,  141,    4,  281,  134,  126,
 /*  2580 */   127,  128,  129,  119,  262,  141,  142,  143,  144,  287,
 /*  2590 */   126,  127,  128,  129,  289,    4,  126,  127,  128,  129,
 /*  2600 */   126,  127,  128,  129,  126,  127,  128,  129,  155,  284,
 /*  2610 */   258,  141,    4,  146,  281,  141,    4,  281,  246,  141,
 /*  2620 */   176,  119,  207,  179,  273,  181,  182,  118,  126,  127,
 /*  2630 */   128,  129,  258,   81,   82,   83,  207,  273,   86,   87,
 /*  2640 */    88,   89,   90,   91,   92,   93,  118,   95,   96,   97,
 /*  2650 */    98,   99,  100,  101,  102,  103,  104,  105,  106,    4,
 /*  2660 */   248,   82,   83,    4,   77,   86,   87,   88,   89,   90,
 /*  2670 */    91,   92,   93,    4,   95,   96,   97,   98,   99,  100,
 /*  2680 */   101,  102,  103,  104,  105,  106,  248,  126,  127,  128,
 /*  2690 */   129,  126,  127,  128,  129,  248,    4,  248,  126,  127,
 /*  2700 */   128,  129,  204,    4,  299,  273,  141,  177,    4,  273,
 /*  2710 */   212,  118,  308,    4,   20,  308,  218,  126,  127,  128,
 /*  2720 */   129,    4,  118,  273,  118,  164,  310,   17,  310,  204,
 /*  2730 */     4,  204,  141,  290,  126,  127,  128,  129,  126,  127,
 /*  2740 */   128,  129,    4,  218,  230,  218,    4,  255,  250,  141,
 /*  2750 */   257,  294,  227,  228,  227,  228,  301,  301,  261,  187,
 /*  2760 */   261,  236,  272,  236,  230,  241,  268,  269,  156,  237,
 /*  2770 */   231,  288,  257,    4,  258,  310,  202,  204,  255,  220,
 /*  2780 */   220,  126,  127,  128,  129,  126,  127,  128,  129,  220,
 /*  2790 */   220,  218,  303,  302,  291,  126,  127,  128,  129,  253,
 /*  2800 */   227,  228,  247,  328,  271,  238,  238,  227,  314,  236,
 /*  2810 */   141,  119,  227,  238,  289,   71,  289,  331,  126,  127,
 /*  2820 */   128,  129,  331,  242,  169,  126,  127,  128,  129,  125,
 /*  2830 */   126,  127,  128,  129,  331,  126,  127,  128,  129,  331,
 /*  2840 */   331,  331,  331,  126,  127,  128,  129,  188,  331,  204,
 /*  2850 */   331,  331,  126,  127,  128,  129,  331,  331,  331,  331,
 /*  2860 */   204,  119,  289,  218,  126,  127,  128,  129,  126,  127,
 /*  2870 */   128,  129,  227,  228,  218,  176,  204,  331,  331,  331,
 /*  2880 */   331,  236,  331,  227,  228,  176,  331,  204,  331,  204,
 /*  2890 */   218,  331,  236,  204,  125,  126,  127,  128,  129,  227,
 /*  2900 */   228,  218,  176,  218,  204,  331,  204,  218,  236,  331,
 /*  2910 */   227,  228,  227,  228,  331,  177,  227,  228,  218,  236,
 /*  2920 */   218,  236,  331,  204,  331,  236,  331,  227,  228,  227,
 /*  2930 */   228,  331,  331,  331,  289,  204,  236,  218,  236,  204,
 /*  2940 */   331,  331,  331,  331,  331,  289,  227,  228,  331,  218,
 /*  2950 */   331,  331,  331,  218,  331,  236,  331,  331,  227,  228,
 /*  2960 */   331,  289,  227,  228,  331,  331,  331,  236,  331,  331,
 /*  2970 */   331,  236,  289,  331,  289,  331,  331,  331,  289,  331,
 /*  2980 */   331,  331,  204,  331,  331,  331,  204,  331,  331,  289,
 /*  2990 */   331,  289,  331,  204,  331,  331,  218,  331,  331,  331,
 /*  3000 */   218,  331,  331,  331,  331,  227,  228,  218,  289,  227,
 /*  3010 */   228,  331,  331,  331,  236,  204,  227,  228,  236,  204,
 /*  3020 */   289,  204,  331,  331,  289,  236,  204,  331,  331,  218,
 /*  3030 */   331,  331,  204,  218,  331,  218,  331,  331,  227,  228,
 /*  3040 */   218,  331,  227,  228,  227,  228,  218,  236,  331,  227,
 /*  3050 */   228,  236,  204,  236,  331,  227,  228,  331,  236,  204,
 /*  3060 */   331,  331,  331,  331,  236,  204,  218,  289,  331,  331,
 /*  3070 */   331,  289,  331,  218,  331,  227,  228,  331,  289,  218,
 /*  3080 */   331,  331,  227,  228,  236,  331,  331,  331,  227,  228,
 /*  3090 */   331,  236,  331,  331,  331,  204,  331,  236,  204,  331,
 /*  3100 */   289,  204,  331,  331,  289,  331,  289,  331,  331,  218,
 /*  3110 */   331,  289,  218,  331,  331,  218,  331,  289,  227,  228,
 /*  3120 */   331,  227,  228,  331,  227,  228,  331,  236,  204,  331,
 /*  3130 */   236,  331,  204,  236,  204,  331,  331,  289,  331,  204,
 /*  3140 */   331,  331,  218,  331,  289,  331,  218,  331,  218,  331,
 /*  3150 */   289,  227,  228,  218,  331,  227,  228,  227,  228,  331,
 /*  3160 */   236,  331,  227,  228,  236,  331,  236,  204,  331,  331,
 /*  3170 */   331,  236,  331,  331,  331,  331,  331,  331,  331,  204,
 /*  3180 */   289,  218,  331,  289,  331,  331,  289,  331,  331,  331,
 /*  3190 */   227,  228,  331,  218,  331,  331,  331,  331,  204,  236,
 /*  3200 */   331,  331,  227,  228,  331,  331,  331,  331,  331,  331,
 /*  3210 */   331,  236,  218,  289,  204,  331,  331,  289,  331,  289,
 /*  3220 */   331,  227,  228,  331,  289,  204,  331,  331,  218,  331,
 /*  3230 */   236,  204,  331,  331,  331,  331,  331,  227,  228,  218,
 /*  3240 */   331,  331,  331,  331,  204,  218,  236,  204,  227,  228,
 /*  3250 */   331,  331,  289,  331,  227,  228,  331,  236,  218,  331,
 /*  3260 */   331,  218,  331,  236,  289,  331,  331,  227,  228,  331,
 /*  3270 */   227,  228,  204,  331,  331,  331,  236,  331,  331,  236,
 /*  3280 */   331,  331,  331,  289,  331,  331,  218,  331,  204,  331,
 /*  3290 */   331,  331,  331,  331,  204,  227,  228,  331,  331,  289,
 /*  3300 */   331,  331,  218,  331,  236,  331,  331,  331,  218,  331,
 /*  3310 */   289,  227,  228,  331,  204,  331,  289,  227,  228,  331,
 /*  3320 */   236,  331,  331,  331,  331,  331,  236,  204,  218,  289,
 /*  3330 */   204,  331,  289,  331,  331,  331,  331,  227,  228,  331,
 /*  3340 */   331,  218,  204,  331,  218,  331,  236,  331,  331,  331,
 /*  3350 */   227,  228,  331,  227,  228,  331,  218,  289,  204,  236,
 /*  3360 */   331,  204,  236,  204,  331,  227,  228,  331,  331,  331,
 /*  3370 */   331,  331,  218,  289,  236,  218,  331,  218,  331,  289,
 /*  3380 */   331,  227,  228,  331,  227,  228,  227,  228,  331,  331,
 /*  3390 */   236,  331,  331,  236,  331,  236,  204,  331,  331,  289,
 /*  3400 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3410 */   218,  331,  289,  331,  331,  289,  331,  331,  331,  227,
 /*  3420 */   228,  331,  331,  331,  331,  331,  331,  289,  236,  331,
 /*  3430 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3440 */   331,  331,  331,  289,  331,  331,  289,  331,  289,  331,
 /*  3450 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3460 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3470 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3480 */   331,  289,
};
#define YY_SHIFT_USE_DFLT (-147)
#define YY_SHIFT_COUNT (556)
#define YY_SHIFT_MIN   (-146)
#define YY_SHIFT_MAX   (2769)
static const short yy_shift_ofst[] = {
 /*     0 */  1739,  691,  893, 1939,  808, 1293, 1172, 1055, 2280, 2280,
 /*    10 */   -37,  198, 2159, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    20 */  2343, 2343, 1369,   -4,   97, 2058, 1957, 1856, 2343, 2343,
 /*    30 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2444, 2343,
 /*    40 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    50 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    60 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    70 */  2343, 2343, 2343, 2343, 2343,  737, 1989, 1989,  156, 1091,
 /*    80 */  1091, 2769,  993, 2141,  359, 2769,  468, 2709, 2709, 2709,
 /*    90 */  2742, 2709, 2717,  250,  250,  898,  325,  821,  785, 2042,
 /*   100 */  1814, 2024, 1897, 1304, 1253, 1258, 1253, 1162,  935, 1147,
 /*   110 */   359,  920, 2738, 2726, 2726, 2726, 2726, 2726, 2709, 2717,
 /*   120 */  2717,  165,  778,  898,  992,  992,  960,  507,  507,  -44,
 /*   130 */    65,  415,  226,  257, 1236, 1082,  850,  875,  854,  791,
 /*   140 */   576,  396,   59,  319, 2704, 2699, 2692, 2669, 2659, 1549,
 /*   150 */  2655, 2612, 2608, 2502, 2591, 2572, 2565, 2478, 2561, 1736,
 /*   160 */  2474, 2470, 1517, 2453, 2464, 2434, 2401, 2388, 2304, 2373,
 /*   170 */  2368, 2326,  817, 1390, 2190, 1798,  392,  759,  754, 2163,
 /*   180 */  2119, 2078, 1262, 2717, 2717,  734,  734,  172,  181,  995,
 /*   190 */   995,  995,  282,  282,  735,    1,  498,  498,   11, 1234,
 /*   200 */  1288, 1288, 1288, 1052,  960, 2744, 2744, 2744, 2744, -147,
 /*   210 */  -147, -147,  410,  588,  588,  588,  588,  588,  588,  588,
 /*   220 */   588,  588,  588,  559,  375,  630, 1001, 1753, 1724, 1692,
 /*   230 */   -73, 1661, 1630, 1599, 1568, 1531, 1500, 1469, 1442, 1401,
 /*   240 */  1361, 1240, 1816, 1788, 2552, 2579, 2579,  471,  -16,  -16,
 /*   250 */   -16,  -16,  -16,  -16,  651,   44,   30,  500,  -36,  -36,
 /*   260 */   661,  503,  251,  251,  251,  268,  210,  266,   89,   25,
 /*   270 */   552,  248, 1040,  925,  241,   77,  640,   -7,  354,  519,
 /*   280 */   187, 1364,  658,  436,  890,  863,  879,  149,  770,  770,
 /*   290 */   458,  762,  162,  879,  617,  617,  306, 2710, 2710, 2606,
 /*   300 */  2604, 2694, 2694, 2593, 2530, 2587, 2587, 2587, 2587, 2528,
 /*   310 */  2222, 2204, 2509, 2222, 2477, 2378, 2204, 2378, 2467, 2451,
 /*   320 */  2217, 2247, 2378, 2204, 2477, 2217, 2247, 2378, 2204, 2365,
 /*   330 */  2513, 2424, 2222, 2218, 2222, 2218, 2334, 2334, 2334, 2334,
 /*   340 */  2446, 2218, 2334, 2347, 2334, 2446, 2334, 2334, 2272, 2286,
 /*   350 */  2329, 2409, 2409, 2390, 2390, 2217, 2247, 2217, 2219, 2212,
 /*   360 */  2204, 2191, 2243, 2246, 2218, 2225, 2225, 2210, 2186, 2222,
 /*   370 */  2231, 2231, 2167, 2167, 2167, 2167, -147, -147, -147, -147,
 /*   380 */  -147, -147, -147, -147, -147, -147, 1933,   60,   -2,  551,
 /*   390 */   148, -146,   49,  512, 1355, 1281,  648, 1149,  419,  897,
 /*   400 */  1048, 1017,  686,  591, 1011,  952,  394,  -15,  242,  517,
 /*   410 */   161,  462,  338,  413,  504,  183,  141,   38,   86, 2187,
 /*   420 */  2176, 2100, 2107, 2062, 2105, 2095, 2098, 2097, 2096, 2055,
 /*   430 */  2054, 2049, 1993, 2041, 2039, 2002, 1963, 2092, 2021, 2076,
 /*   440 */  2064, 2089, 2001, 1996, 1929, 1924, 1927, 2047, 2052, 1959,
 /*   450 */  1898, 1977, 1976, 1971, 1954, 1912, 1921, 1923, 1869, 2009,
 /*   460 */  1875, 1902, 1899, 1891, 1926, 1894, 1862, 1849, 1890, 1958,
 /*   470 */  1877, 1874, 1870, 1866, 1931, 1969, 1860, 1851, 1960, 1842,
 /*   480 */  1916, 1941, 1835, 1922, 1755, 1813, 1779, 1868, 1703, 1752,
 /*   490 */  1695, 1722, 1721,  283, 1671,  283, 1693, 1702, 1683, 1681,
 /*   500 */  1609, 1655, 1654, 1629, 1611, 1700, 1594, 1349, 1694, 1669,
 /*   510 */  1648, 1626, 1556, 1579, 1576, 1526, 1516, 1534, 1522, 1379,
 /*   520 */  1371, 1362, 1399, 1393, 1360, 1349, 1330, 1267, 1201, 1098,
 /*   530 */  1080, 1125, 1022, 1152,  845,  944, 1014, 1043,  845,  902,
 /*   540 */   736,  800,  685,  714,  609,  616,  582,  564,  496,  256,
 /*   550 */   215,  283,  113,   90,  -17,  -19,  -67,
};
#define YY_REDUCE_USE_DFLT (-185)
#define YY_REDUCE_COUNT (385)
#define YY_REDUCE_MIN   (-184)
#define YY_REDUCE_MAX   (3192)
static const short yy_reduce_ofst[] = {
 /*     0 */   642,  566,  610,   53, 1028, 1742,  641, 1992, 1962,  988,
 /*    10 */   953, 2285, 2184, 2157, 2140, 2121, 2109, 2093, 2026, 1892,
 /*    20 */  1791,  912,  865, 3192, 3159, 3157, 3154, 3138, 3126, 3123,
 /*    30 */  3110, 3090, 3084, 3068, 3043, 3040, 3027, 3021, 3010, 2994,
 /*    40 */  2975, 2963, 2935, 2930, 2928, 2924, 2897, 2894, 2891, 2861,
 /*    50 */  2855, 2848, 2828, 2822, 2817, 2815, 2811, 2789, 2782, 2778,
 /*    60 */  2735, 2731, 2719, 2702, 2700, 2689, 2685, 2683, 2672, 2656,
 /*    70 */  2645, 2573, 2527, 2525, 2305, 2498, 1729,  949,  -20, 1089,
 /*    80 */   906,  336,  692, 1100,  794,  557, -184, 1107, 1106, 1076,
 /*    90 */   825,  144,  643,  855,  397,  565,  546,  480, 1065, 1843,
 /*   100 */  1840, 1731, 1434, 1077,  959, 1727,  116, 1308, 1197,  996,
 /*   110 */   570,  848,  812, 1153, 1003,  792,  103, -113,   15, -104,
 /*   120 */   940,    0,  514,  803,  209,  154,  186, 1225,  701,  240,
 /*   130 */  1180, 2233, 2209, 2128, 1754, 1754, 2197, 2185, 2151, 2147,
 /*   140 */  2146, 1754, 2128, 2106, 2094, 2091, 2060, 2004, 1754, 2004,
 /*   150 */  2004, 2004, 2004, 1754, 2057, 1754, 2020, 2020, 2045, 2032,
 /*   160 */  2020, 2014, 1754, 2004, 2004, 1999, 1991, 1973, 1943, 1942,
 /*   170 */  1925, 1909, 1903, 1893, 1872, 1841, 1754, 1726, 1719, 1582,
 /*   180 */  1551, 1520, 1489, 1309,  827, 1114, 1039, 1374, 1188, 1358,
 /*   190 */  1343, 1156, 1186, 1116,  428,  994, 1103,  871,  936, 1365,
 /*   200 */  1132,  970,  711,  924,  874, 1146, 1018,  945,  721,  745,
 /*   210 */   776,  544, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953,
 /*   220 */  1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953,
 /*   230 */  1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953,
 /*   240 */  1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953, 1953,
 /*   250 */  1953, 1953, 1953, 1953, 1953, 1953, 1953, 2581, 2585, 2580,
 /*   260 */  2494, 2494, 2575, 2568, 2567, 2533, 2475, 2555, 2546, 2503,
 /*   270 */  2489, 2491, 2570, 2569, 2560, 1953, 2559, 2523, 2574, 2465,
 /*   280 */  2516, 2483, 2515, 2539, 2524, 2532, 2534, 2490, 2499, 2497,
 /*   290 */  2493, 2492, 2457, 2514, 2456, 2455, 2443, 2418, 2416, 2450,
 /*   300 */  2436, 2407, 2404, 2432, 2405, 2449, 2447, 2438, 2412, 2364,
 /*   310 */  2429, 2374, 2351, 2415, 2372, 2336, 2352, 2333, 2302, 2325,
 /*   320 */  2322, 2306, 2296, 2300, 2309, 2294, 2293, 2271, 2292, 2242,
 /*   330 */  2241, 2263, 2330, 2307, 2327, 2299, 2289, 2282, 2281, 2279,
 /*   340 */  2268, 2273, 2275, 2260, 2261, 2236, 2252, 2250, 2134, 2211,
 /*   350 */  2168, 2124, 2115, 2160, 2149, 2164, 2155, 2132, 2126, 2122,
 /*   360 */  2112, 2070, 2036, 2056, 2111, 1953, 1953, 2053, 2104, 2116,
 /*   370 */  2117, 2101, 2102, 2079, 2074, 2069, 1965, 1956, 1952, 2022,
 /*   380 */  2019, 1961, 1953, 1953, 1953, 2025,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   908, 1242, 1242, 1368, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    10 */  1368, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    20 */  1242, 1242, 1368, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    30 */  1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    40 */  1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    50 */  1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    60 */  1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242,
 /*    70 */  1242, 1242, 1242, 1242, 1242, 1094, 1410, 1410, 1410, 1387,
 /*    80 */  1387, 1410, 1087, 1410,  936, 1410, 1410, 1410, 1410, 1410,
 /*    90 */  1410, 1410, 1410, 1410, 1410,  960, 1083,  949, 1094, 1410,
 /*   100 */  1410, 1410, 1410, 1410, 1164, 1179, 1164, 1156, 1145, 1410,
 /*   110 */  1410, 1410, 1280, 1172, 1172, 1172, 1172, 1172, 1410, 1410,
 /*   120 */  1410, 1033, 1206, 1410, 1208, 1207, 1410, 1130, 1130, 1244,
 /*   130 */  1410, 1333, 1338, 1200, 1410, 1410, 1410, 1410, 1410, 1165,
 /*   140 */  1410, 1095, 1200, 1410, 1410, 1348, 1410, 1410, 1410, 1410,
 /*   150 */  1410, 1410, 1410, 1410, 1410, 1410, 1180, 1157, 1410, 1410,
 /*   160 */  1146, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410,
 /*   170 */  1410, 1410, 1410, 1410, 1410, 1202, 1410, 1410, 1410, 1410,
 /*   180 */  1410, 1410,  914, 1410, 1410, 1410, 1410, 1083, 1387, 1083,
 /*   190 */  1083, 1083, 1387, 1387,  946,  954, 1387, 1387,  908, 1368,
 /*   200 */  1119, 1119, 1119, 1124, 1410, 1368, 1368, 1368, 1368, 1361,
 /*   210 */  1073, 1073, 1140, 1163, 1162, 1161, 1160, 1100, 1150, 1138,
 /*   220 */  1142, 1141, 1257, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*   230 */  1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244, 1244,
 /*   240 */  1244, 1244, 1244, 1244, 1210, 1224, 1209, 1217, 1229, 1218,
 /*   250 */  1223, 1222, 1221, 1212, 1211, 1213, 1214, 1410, 1410, 1410,
 /*   260 */  1410, 1410, 1410, 1410, 1410, 1086, 1410, 1410, 1055, 1410,
 /*   270 */  1410, 1307, 1410, 1410,  962, 1215, 1410, 1071,  917, 1352,
 /*   280 */  1149, 1246, 1084, 1000, 1024,  984, 1130, 1102, 1124, 1124,
 /*   290 */  1084, 1071, 1252, 1130, 1410, 1410, 1244, 1352, 1352, 1103,
 /*   300 */  1103, 1332, 1332, 1103, 1280, 1046, 1046, 1046, 1046, 1103,
 /*   310 */   943, 1149, 1103,  943, 1037, 1152, 1149, 1152, 1185, 1168,
 /*   320 */  1139, 1124, 1152, 1149, 1037, 1139, 1124, 1152, 1149, 1314,
 /*   330 */  1312, 1103,  943, 1265,  943, 1265, 1035, 1035, 1035, 1035,
 /*   340 */  1016, 1265, 1035, 1000, 1035, 1016, 1035, 1035, 1406, 1410,
 /*   350 */  1103, 1397, 1397, 1133, 1133, 1139, 1124, 1139, 1137, 1134,
 /*   360 */  1149, 1410, 1410, 1271, 1265, 1228, 1216, 1103, 1019,  943,
 /*   370 */   925,  925,  913,  913,  913,  913, 1365, 1365, 1361, 1002,
 /*   380 */  1002, 1089, 1227, 1226, 1225,  971, 1243, 1410, 1410, 1410,
 /*   390 */  1410, 1410, 1410, 1281, 1410, 1410, 1410, 1410, 1410, 1107,
 /*   400 */  1410, 1410, 1107, 1107, 1410, 1410, 1410, 1410, 1410, 1410,
 /*   410 */  1410, 1410, 1410, 1410, 1371, 1410, 1410, 1410, 1410, 1410,
 /*   420 */   909, 1410, 1105, 1410, 1410, 1410, 1105, 1105, 1105, 1410,
 /*   430 */  1105, 1355, 1410, 1410, 1410, 1410, 1410, 1410, 1311, 1310,
 /*   440 */  1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1169,
 /*   450 */  1410, 1410, 1410, 1410, 1410, 1410, 1153, 1108, 1410, 1299,
 /*   460 */  1410, 1105, 1410, 1410, 1410, 1105, 1410, 1410, 1410, 1410,
 /*   470 */  1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410,
 /*   480 */  1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410,
 /*   490 */  1410, 1410, 1410, 1059, 1065, 1060, 1410, 1410, 1410, 1198,
 /*   500 */  1410, 1410, 1410, 1410, 1410, 1410, 1410, 1135, 1410, 1410,
 /*   510 */  1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410, 1410,
 /*   520 */  1410, 1410, 1403, 1125, 1410, 1255, 1410, 1410, 1410, 1410,
 /*   530 */  1245, 1410, 1243, 1410, 1370, 1410, 1410, 1410, 1369, 1410,
 /*   540 */  1410, 1410, 1410, 1410, 1245, 1410, 1410, 1199, 1198, 1410,
 /*   550 */  1410, 1058,  957,  932, 1410,  923, 1410,  905,  910, 1354,
 /*   560 */  1351, 1344, 1343, 1353, 1347, 1349, 1345, 1346, 1342, 1350,
 /*   570 */  1341, 1339, 1340, 1337, 1335, 1334, 1336, 1331, 1327, 1287,
 /*   580 */  1285, 1283, 1292, 1291, 1290, 1289, 1288, 1284, 1282, 1286,
 /*   590 */  1278, 1277, 1175, 1154, 1143, 1053, 1326, 1324, 1325, 1276,
 /*   600 */  1274, 1275, 1052, 1051, 1050, 1045, 1044, 1043, 1042, 1358,
 /*   610 */  1367, 1366, 1364, 1363, 1362, 1356, 1357, 1263, 1262, 1260,
 /*   620 */  1259, 1261,  945, 1303, 1306, 1305, 1304, 1309, 1308, 1301,
 /*   630 */  1313, 1318, 1317, 1322, 1321, 1320, 1319, 1316, 1298, 1184,
 /*   640 */  1183, 1181, 1177, 1188, 1187, 1186, 1176, 1178, 1182, 1159,
 /*   650 */  1167, 1166, 1155, 1158, 1038, 1148, 1144, 1112, 1110, 1147,
 /*   660 */  1111, 1109, 1054, 1302, 1049, 1048, 1047,  944,  935, 1106,
 /*   670 */   934,  933,  948, 1022, 1023, 1031, 1034, 1029, 1032, 1028,
 /*   680 */  1027, 1026, 1030, 1025, 1021,  951,  950,  961, 1015,  998,
 /*   690 */   987,  953,  989,  986,  985,  990, 1007, 1006, 1013, 1012,
 /*   700 */  1011, 1010, 1009, 1005, 1008, 1004, 1003,  991,  983,  982,
 /*   710 */  1001,  981, 1018, 1017, 1014,  980, 1041, 1040, 1039, 1036,
 /*   720 */   979,  978,  977,  976,  975,  974, 1240, 1239, 1409, 1405,
 /*   730 */  1408, 1407, 1404, 1241, 1238, 1248, 1232, 1230, 1056, 1068,
 /*   740 */  1067, 1066, 1063, 1078, 1076, 1075, 1074, 1118, 1117, 1116,
 /*   750 */  1115, 1114, 1113, 1099, 1097, 1092, 1091, 1098, 1096, 1093,
 /*   760 */  1122, 1123, 1121, 1120, 1090, 1082, 1080, 1081, 1079, 1174,
 /*   770 */  1171, 1173, 1170, 1101, 1088, 1085, 1072, 1385, 1383, 1386,
 /*   780 */  1384, 1382, 1390, 1392, 1391, 1396, 1394, 1393, 1389, 1402,
 /*   790 */  1401, 1400, 1399, 1398, 1388, 1395, 1381, 1380, 1379, 1378,
 /*   800 */  1127, 1132, 1131, 1126, 1062, 1061, 1323, 1236, 1195, 1237,
 /*   810 */  1231, 1243, 1235, 1376, 1374, 1377, 1373, 1372, 1268, 1270,
 /*   820 */  1273, 1272, 1269, 1129, 1128, 1267, 1266, 1375, 1234, 1205,
 /*   830 */   967,  965,  966, 1295, 1294, 1297, 1296, 1293,  969,  968,
 /*   840 */   964,  963, 1203, 1197, 1196, 1220, 1219, 1204, 1194,  956,
 /*   850 */   955, 1201, 1193, 1192, 1191, 1064, 1057, 1233, 1190, 1104,
 /*   860 */  1189,  997,  996,  995,  994,  993,  992, 1070, 1069,  973,
 /*   870 */   988,  972,  970,  947,  937,  942,  940,  941,  939,  938,
 /*   880 */   930,  927,  929,  926,  931,  928,  924,  922,  921,  920,
 /*   890 */   919,  918,  959,  958,  957,  952,  916,  915,  912,  911,
 /*   900 */   907,  906,  904,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /* MATERIALIZED => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*     WITHIN => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
    4,  /*     FILTER => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GROUPS",        "IGNORE",      
  "IMMEDIATE",     "INITIALLY",     "INSTEAD",       "LAST",        
  "LIKE_KW",       "MATCH",         "MATERIALIZED",  "NO",          
  "NULLS",         "OTHERS",        "PLAN",          "QUERY",       
  "KEY",           "OF",            "OFFSET",        "PARTITION",   
  "PRAGMA",        "PRECEDING",     "RAISE",         "RANGE",       
  "RECURSIVE",     "RELEASE",       "REPLACE",       "RESTRICT",    
  "ROW",           "ROWS",          "ROLLBACK",      "SAVEPOINT",   
  "TEMP",          "TIES",          "TRIGGER",       "UNBOUNDED",   
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHIN",        "WITHOUT",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "IF",            "FILTER",        "ANY",         
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "PTR",           "COLLATE",       "BITNOT",      
  "SEMI",          "TRANSACTION",   "ID_TRANS",      "COMMIT",      
  "TO",            "CREATE",        "TABLE",         "LP",          
  "RP",            "AS",            "DOT",           "ID_TAB_NEW",  
  "ID_DB",         "COMMA",         "CTX_ROWID_KW",  "CTX_STRICT_KW",
  "EXISTS",        "ID_COL_NEW",    "INDEXED",       "GENERATED",   
  "STRING",        "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC", 
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "ID_CONSTR",   
  "ID_COLLATE",    "ID_TAB",        "INTEGER",       "FLOAT",       
  "BLOB",          "AUTOINCR",      "ON",            "INSERT",      
  "DELETE",        "UPDATE",        "ID_FK_MATCH",   "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "ID_VIEW_NEW", 
  "ID_VIEW",       "SELECT",        "VALUES",        "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "DISTINCT",    
  "ID_ALIAS",      "FROM",          "USING",         "JOIN",        
  "ID_JOIN_OPTS",  "ID_IDX",        "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "RETURNING",   
  "ID_COL",        "INTO",          "NOTHING",       "ID_FN",       
  "ID_ERR_MSG",    "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ID_IDX_NEW",  
  "ID_PRAGMA",     "ID_TRIG_NEW",   "ID_TRIG",       "ALTER",       
  "ADD",           "WINDOW",        "OVER",          "error",       
  "cmd",           "input",         "cmdlist",       "ecmd",        
  "explain",       "cmdx",          "transtype",     "trans_opt",   
  "nm",            "savepoint_opt",  "temp",          "ifnotexists", 
  "fullname",      "columnlist",    "conslist_opt",  "table_options",
  "select",        "table_option",  "column",        "columnid",    
  "type",          "carglist",      "id",            "id_opt",      
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "ccons",         "term",        
  "expr",          "onconf",        "sortorder",     "autoinc",     
  "idxlist_opt",   "refargs",       "defer_subclause",  "gen_always",  
  "tnm",           "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tconscomma",    "tcons",         "idxlist",     
  "defer_subclause_opt",  "resolvetype",   "orconf",        "raisetype",   
  "ifexists",      "select_stmt",   "with",          "selectnowith",
  "oneselect",     "multiselect_op",  "values",        "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "window_clause",
  "nexprlist",     "exprlist",      "sclp",          "as",          
  "joinsrc",       "singlesrc",     "seltablist",    "joinop",      
  "joinconstr_opt",  "dbnm",          "indexed_opt",   "idlist",      
  "xfullname",     "indexed_by",    "sortlist",      "nulls",       
  "delete_stmt",   "returning",     "update_stmt",   "setlist",     
  "idlist_opt",    "insert_stmt",   "insert_cmd",    "upsert",      
  "rp_opt",        "exprx",         "not_opt",       "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "filter_over", 
  "uniqueflag",    "idxlist_single",  "collate",       "vinto",       
  "nmnum",         "number",        "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd_list",  "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "kwcolumn_opt",  "create_vtab", 
  "vtabarglist",   "vtabarg",       "vtabargtoken",  "anylist",     
  "wqlist",        "wqas",          "wqcte",         "windowdefn_list",
  "windowdefn",    "window",        "frame_opt",     "range_or_rows",
  "frame_bound_s",  "frame_exclude_opt",  "frame_bound_e",  "frame_bound", 
  "frame_exclude",  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= table_option",
 /*  35 */ "table_options ::= table_options COMMA table_option",
 /*  36 */ "table_option ::= WITHOUT nm",
 /*  37 */ "table_option ::= nm",
 /*  38 */ "table_option ::= WITHOUT CTX_ROWID_KW",
 /*  39 */ "table_option ::= CTX_STRICT_KW",
 /*  40 */ "ifnotexists ::=",
 /*  41 */ "ifnotexists ::= IF NOT EXISTS",
 /*  42 */ "temp ::= TEMP",
 /*  43 */ "temp ::=",
 /*  44 */ "columnlist ::= columnlist COMMA column",
 /*  45 */ "columnlist ::= column",
 /*  46 */ "column ::= columnid type carglist",
 /*  47 */ "columnid ::= nm",
 /*  48 */ "columnid ::= ID_COL_NEW",
 /*  49 */ "id ::= ID|INDEXED|GENERATED",
 /*  50 */ "id_opt ::= id",
 /*  51 */ "id_opt ::=",
 /*  52 */ "ids ::= ID",
 /*  53 */ "ids ::= STRING",
 /*  54 */ "nm ::= id",
 /*  55 */ "nm ::= STRING",
 /*  56 */ "nm ::= JOIN_KW",
 /*  57 */ "type ::=",
 /*  58 */ "type ::= typetoken",
 /*  59 */ "typetoken ::= typename",
 /*  60 */ "typetoken ::= typename LP signed RP",
 /*  61 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  62 */ "typename ::= ids",
 /*  63 */ "typename ::= typename ids",
 /*  64 */ "typename ::= ID_COL_TYPE",
 /*  65 */ "signed ::= plus_num",
 /*  66 */ "signed ::= minus_num",
 /*  67 */ "carglist ::= carglist ccons",
 /*  68 */ "carglist ::=",
 /*  69 */ "ccons ::= CONSTRAINT nm",
 /*  70 */ "ccons ::= DEFAULT term",
 /*  71 */ "ccons ::= DEFAULT LP expr RP",
 /*  72 */ "ccons ::= DEFAULT PLUS term",
 /*  73 */ "ccons ::= DEFAULT MINUS term",
 /*  74 */ "ccons ::= DEFAULT id",
 /*  75 */ "ccons ::= DEFAULT CTIME_KW",
 /*  76 */ "ccons ::= NULL onconf",
 /*  77 */ "ccons ::= NOT NULL onconf",
 /*  78 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  79 */ "ccons ::= UNIQUE onconf",
 /*  80 */ "ccons ::= CHECK LP expr RP",
 /*  81 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  82 */ "ccons ::= defer_subclause",
 /*  83 */ "ccons ::= COLLATE ids",
 /*  84 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  85 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  86 */ "ccons ::= COLLATE ID_COLLATE",
 /*  87 */ "ccons ::= REFERENCES ID_TAB",
 /*  88 */ "ccons ::= CHECK LP RP",
 /*  89 */ "term ::= NULL",
 /*  90 */ "term ::= INTEGER",
 /*  91 */ "term ::= FLOAT",
 /*  92 */ "term ::= STRING|BLOB",
 /*  93 */ "tnm ::= term",
 /*  94 */ "tnm ::= nm",
 /*  95 */ "gen_always ::= GENERATED ALWAYS",
 /*  96 */ "gen_always ::=",
 /*  97 */ "autoinc ::=",
 /*  98 */ "autoinc ::= AUTOINCR",
 /*  99 */ "refargs ::=",
 /* 100 */ "refargs ::= refargs refarg",
 /* 101 */ "refarg ::= MATCH nm",
 /* 102 */ "refarg ::= ON INSERT refact",
 /* 103 */ "refarg ::= ON DELETE refact",
 /* 104 */ "refarg ::= ON UPDATE refact",
 /* 105 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 106 */ "refact ::= SET NULL",
 /* 107 */ "refact ::= SET DEFAULT",
 /* 108 */ "refact ::= CASCADE",
 /* 109 */ "refact ::= RESTRICT",
 /* 110 */ "refact ::= NO ACTION",
 /* 111 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 112 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 113 */ "init_deferred_pred_opt ::=",
 /* 114 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 115 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 116 */ "conslist_opt ::=",
 /* 117 */ "conslist_opt ::= COMMA conslist",
 /* 118 */ "conslist ::= conslist tconscomma tcons",
 /* 119 */ "conslist ::= tcons",
 /* 120 */ "tconscomma ::= COMMA",
 /* 121 */ "tconscomma ::=",
 /* 122 */ "tcons ::= CONSTRAINT nm",
 /* 123 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 124 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 125 */ "tcons ::= CHECK LP expr RP onconf",
 /* 126 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 127 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 128 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 129 */ "tcons ::= CHECK LP RP onconf",
 /* 130 */ "defer_subclause_opt ::=",
 /* 131 */ "defer_subclause_opt ::= defer_subclause",
 /* 132 */ "onconf ::=",
 /* 133 */ "onconf ::= ON CONFLICT resolvetype",
 /* 134 */ "orconf ::=",
 /* 135 */ "orconf ::= OR resolvetype",
 /* 136 */ "resolvetype ::= raisetype",
 /* 137 */ "resolvetype ::= IGNORE",
 /* 138 */ "resolvetype ::= REPLACE",
 /* 139 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 140 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 141 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 142 */ "ifexists ::= IF EXISTS",
 /* 143 */ "ifexists ::=",
 /* 144 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 145 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 146 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 147 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 148 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 149 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 150 */ "cmd ::= select_stmt",
 /* 151 */ "select_stmt ::= select",
 /* 152 */ "select ::= with selectnowith",
 /* 153 */ "selectnowith ::= oneselect",
 /* 154 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 155 */ "selectnowith ::= selectnowith multiselect_op values",
 /* 156 */ "selectnowith ::= values",
 /* 157 */ "selectnowith ::= selectnowith COMMA values",
 /* 158 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 159 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 160 */ "values ::= VALUES LP nexprlist RP",
 /* 161 */ "values ::= values COMMA LP exprlist RP",
 /* 162 */ "multiselect_op ::= UNION",
 /* 163 */ "multiselect_op ::= UNION ALL",
 /* 164 */ "multiselect_op ::= EXCEPT",
 /* 165 */ "multiselect_op ::= INTERSECT",
 /* 166 */ "distinct ::= DISTINCT",
 /* 167 */ "distinct ::= ALL",
 /* 168 */ "distinct ::=",
 /* 169 */ "sclp ::= selcollist COMMA",
 /* 170 */ "sclp ::=",
 /* 171 */ "selcollist ::= sclp expr as",
 /* 172 */ "selcollist ::= sclp STAR",
 /* 173 */ "selcollist ::= sclp tnm DOT STAR",
 /* 174 */ "selcollist ::= sclp",
 /* 175 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 176 */ "as ::= AS nm",
 /* 177 */ "as ::= ids",
 /* 178 */ "as ::= AS ID_ALIAS",
 /* 179 */ "as ::= ID_ALIAS",
 /* 180 */ "as ::=",
 /* 181 */ "from ::=",
 /* 182 */ "from ::= FROM joinsrc",
 /* 183 */ "joinsrc ::= singlesrc seltablist",
 /* 184 */ "joinsrc ::=",
 /* 185 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 186 */ "seltablist ::=",
 /* 187 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 188 */ "singlesrc ::= LP select RP as",
 /* 189 */ "singlesrc ::= LP joinsrc RP as",
 /* 190 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 191 */ "singlesrc ::=",
 /* 192 */ "singlesrc ::= nm DOT",
 /* 193 */ "singlesrc ::= nm DOT ID_TAB",
 /* 194 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 195 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 196 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 197 */ "joinconstr_opt ::= ON expr",
 /* 198 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 199 */ "joinconstr_opt ::=",
 /* 200 */ "dbnm ::=",
 /* 201 */ "dbnm ::= DOT nm",
 /* 202 */ "fullname ::= nm",
 /* 203 */ "fullname ::= nm DOT nm",
 /* 204 */ "xfullname ::= nm",
 /* 205 */ "xfullname ::= nm DOT nm",
 /* 206 */ "xfullname ::= nm DOT nm AS nm",
 /* 207 */ "xfullname ::= nm AS nm",
 /* 208 */ "xfullname ::= nm DOT nm AS ID_ALIAS",
 /* 209 */ "xfullname ::= nm AS ID_ALIAS",
 /* 210 */ "joinop ::= COMMA",
 /* 211 */ "joinop ::= JOIN",
 /* 212 */ "joinop ::= JOIN_KW JOIN",
 /* 213 */ "joinop ::= JOIN_KW nm JOIN",
 /* 214 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 215 */ "joinop ::= ID_JOIN_OPTS",
 /* 216 */ "indexed_opt ::=",
 /* 217 */ "indexed_opt ::= indexed_by",
 /* 218 */ "indexed_by ::= INDEXED BY nm",
 /* 219 */ "indexed_by ::= NOT INDEXED",
 /* 220 */ "indexed_by ::= INDEXED BY ID_IDX",
 /* 221 */ "orderby_opt ::=",
 /* 222 */ "orderby_opt ::= ORDER BY sortlist",
 /* 223 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 224 */ "sortlist ::= expr sortorder nulls",
 /* 225 */ "sortorder ::= ASC",
 /* 226 */ "sortorder ::= DESC",
 /* 227 */ "sortorder ::=",
 /* 228 */ "nulls ::= NULLS FIRST",
 /* 229 */ "nulls ::= NULLS LAST",
 /* 230 */ "nulls ::=",
 /* 231 */ "groupby_opt ::=",
 /* 232 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 233 */ "groupby_opt ::= GROUP BY",
 /* 234 */ "having_opt ::=",
 /* 235 */ "having_opt ::= HAVING expr",
 /* 236 */ "limit_opt ::=",
 /* 237 */ "limit_opt ::= LIMIT expr",
 /* 238 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 239 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 240 */ "cmd ::= delete_stmt",
 /* 241 */ "delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt",
 /* 242 */ "delete_stmt ::= with DELETE FROM",
 /* 243 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 244 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 245 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 246 */ "where_opt ::=",
 /* 247 */ "where_opt ::= WHERE expr",
 /* 248 */ "where_opt ::= WHERE",
 /* 249 */ "returning ::=",
 /* 250 */ "returning ::= RETURNING selcollist",
 /* 251 */ "cmd ::= update_stmt",
 /* 252 */ "update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt",
 /* 253 */ "update_stmt ::= with UPDATE orconf",
 /* 254 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 255 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 256 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 257 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 258 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 259 */ "setlist ::= nm EQ expr",
 /* 260 */ "setlist ::= LP idlist RP EQ expr",
 /* 261 */ "setlist ::=",
 /* 262 */ "setlist ::= setlist COMMA",
 /* 263 */ "setlist ::= setlist COMMA ID_COL",
 /* 264 */ "setlist ::= ID_COL",
 /* 265 */ "idlist_opt ::=",
 /* 266 */ "idlist_opt ::= LP idlist RP",
 /* 267 */ "idlist ::= idlist COMMA nm",
 /* 268 */ "idlist ::= nm",
 /* 269 */ "idlist ::=",
 /* 270 */ "idlist ::= idlist COMMA ID_COL",
 /* 271 */ "idlist ::= ID_COL",
 /* 272 */ "cmd ::= insert_stmt",
 /* 273 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning",
 /* 274 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning",
 /* 275 */ "insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt",
 /* 276 */ "insert_stmt ::= with insert_cmd INTO",
 /* 277 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 278 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 279 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 280 */ "insert_cmd ::= INSERT orconf",
 /* 281 */ "insert_cmd ::= REPLACE",
 /* 282 */ "upsert ::=",
 /* 283 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 284 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 285 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 286 */ "exprx ::= expr not_opt IN ID_DB",
 /* 287 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 288 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 289 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 290 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 291 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 292 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 293 */ "exprx ::= CTIME_KW",
 /* 294 */ "exprx ::= LP nexprlist RP",
 /* 295 */ "exprx ::= tnm",
 /* 296 */ "exprx ::= tnm DOT nm",
 /* 297 */ "exprx ::= tnm DOT",
 /* 298 */ "exprx ::= tnm DOT nm DOT nm",
 /* 299 */ "exprx ::= tnm DOT nm DOT",
 /* 300 */ "exprx ::= VARIABLE",
 /* 301 */ "exprx ::= expr COLLATE ids",
 /* 302 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 303 */ "exprx ::= id LP distinct exprlist RP",
 /* 304 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP",
 /* 305 */ "exprx ::= id LP STAR RP",
 /* 306 */ "exprx ::= expr AND expr",
 /* 307 */ "exprx ::= expr OR expr",
 /* 308 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 309 */ "exprx ::= expr EQ|NE expr",
 /* 310 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 311 */ "exprx ::= expr PLUS|MINUS expr",
 /* 312 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 313 */ "exprx ::= expr CONCAT expr",
 /* 314 */ "exprx ::= expr not_opt likeop expr",
 /* 315 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 316 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 317 */ "exprx ::= expr NOT NULL",
 /* 318 */ "exprx ::= expr IS not_opt expr",
 /* 319 */ "exprx ::= expr IS NOT DISTINCT FROM expr",
 /* 320 */ "exprx ::= expr IS DISTINCT FROM expr",
 /* 321 */ "exprx ::= NOT expr",
 /* 322 */ "exprx ::= BITNOT expr",
 /* 323 */ "exprx ::= MINUS expr",
 /* 324 */ "exprx ::= PLUS expr",
 /* 325 */ "exprx ::= expr PTR expr",
 /* 326 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 327 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 328 */ "exprx ::= LP select RP",
 /* 329 */ "exprx ::= expr not_opt IN LP select RP",
 /* 330 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 331 */ "exprx ::= EXISTS LP select RP",
 /* 332 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 333 */ "exprx ::= RAISE LP IGNORE RP",
 /* 334 */ "exprx ::= RAISE LP raisetype COMMA expr RP",
 /* 335 */ "exprx ::= id LP distinct exprlist RP filter_over",
 /* 336 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over",
 /* 337 */ "exprx ::= id LP STAR RP filter_over",
 /* 338 */ "exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP",
 /* 339 */ "expr ::=",
 /* 340 */ "expr ::= exprx",
 /* 341 */ "not_opt ::=",
 /* 342 */ "not_opt ::= NOT",
 /* 343 */ "rp_opt ::=",
 /* 344 */ "rp_opt ::= RP",
 /* 345 */ "likeop ::= LIKE_KW|MATCH",
 /* 346 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 347 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 348 */ "case_else ::= ELSE expr",
 /* 349 */ "case_else ::=",
 /* 350 */ "case_operand ::= exprx",
 /* 351 */ "case_operand ::=",
 /* 352 */ "exprlist ::= nexprlist",
 /* 353 */ "exprlist ::=",
 /* 354 */ "nexprlist ::= nexprlist COMMA expr",
 /* 355 */ "nexprlist ::= exprx",
 /* 356 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 357 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 358 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 359 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 360 */ "uniqueflag ::= UNIQUE",
 /* 361 */ "uniqueflag ::=",
 /* 362 */ "idxlist_opt ::=",
 /* 363 */ "idxlist_opt ::= LP idxlist RP",
 /* 364 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 365 */ "idxlist ::= idxlist_single",
 /* 366 */ "idxlist_single ::= nm collate sortorder",
 /* 367 */ "idxlist_single ::= ID_COL",
 /* 368 */ "collate ::=",
 /* 369 */ "collate ::= COLLATE ids",
 /* 370 */ "collate ::= COLLATE ID_COLLATE",
 /* 371 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 372 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 373 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 374 */ "cmd ::= VACUUM vinto",
 /* 375 */ "cmd ::= VACUUM nm vinto",
 /* 376 */ "vinto ::= INTO expr",
 /* 377 */ "vinto ::=",
 /* 378 */ "cmd ::= PRAGMA nm dbnm",
 /* 379 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 380 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 381 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 382 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 383 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 384 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 385 */ "nmnum ::= plus_num",
 /* 386 */ "nmnum ::= nm",
 /* 387 */ "nmnum ::= ON",
 /* 388 */ "nmnum ::= DELETE",
 /* 389 */ "nmnum ::= DEFAULT",
 /* 390 */ "plus_num ::= PLUS number",
 /* 391 */ "plus_num ::= number",
 /* 392 */ "minus_num ::= MINUS number",
 /* 393 */ "number ::= INTEGER",
 /* 394 */ "number ::= FLOAT",
 /* 395 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 396 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 397 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 398 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 399 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 400 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 401 */ "trigger_time ::= BEFORE",
 /* 402 */ "trigger_time ::= AFTER",
 /* 403 */ "trigger_time ::= INSTEAD OF",
 /* 404 */ "trigger_time ::=",
 /* 405 */ "trigger_event ::= DELETE",
 /* 406 */ "trigger_event ::= INSERT",
 /* 407 */ "trigger_event ::= UPDATE",
 /* 408 */ "trigger_event ::= UPDATE OF idlist",
 /* 409 */ "foreach_clause ::=",
 /* 410 */ "foreach_clause ::= FOR EACH ROW",
 /* 411 */ "when_clause ::=",
 /* 412 */ "when_clause ::= WHEN expr",
 /* 413 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 414 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 415 */ "trigger_cmd_list ::= SEMI",
 /* 416 */ "trigger_cmd ::= update_stmt",
 /* 417 */ "trigger_cmd ::= insert_stmt",
 /* 418 */ "trigger_cmd ::= delete_stmt",
 /* 419 */ "trigger_cmd ::= select_stmt",
 /* 420 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 421 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 422 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 423 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 424 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 425 */ "cmd ::= DETACH database_kw_opt expr",
 /* 426 */ "key_opt ::=",
 /* 427 */ "key_opt ::= KEY expr",
 /* 428 */ "database_kw_opt ::= DATABASE",
 /* 429 */ "database_kw_opt ::=",
 /* 430 */ "cmd ::= REINDEX",
 /* 431 */ "cmd ::= REINDEX nm dbnm",
 /* 432 */ "cmd ::= REINDEX ID_COLLATE",
 /* 433 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 434 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 435 */ "cmd ::= ANALYZE",
 /* 436 */ "cmd ::= ANALYZE nm dbnm",
 /* 437 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 438 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 439 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 440 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 441 */ "cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm",
 /* 442 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO nm",
 /* 443 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 444 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt ID_COL",
 /* 445 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt",
 /* 446 */ "cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO ID_COL_NEW",
 /* 447 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 448 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 449 */ "kwcolumn_opt ::=",
 /* 450 */ "kwcolumn_opt ::= COLUMNKW",
 /* 451 */ "cmd ::= create_vtab",
 /* 452 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 453 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 454 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 455 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 456 */ "vtabarglist ::= vtabarg",
 /* 457 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 458 */ "vtabarg ::=",
 /* 459 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 460 */ "vtabargtoken ::= ANY",
 /* 461 */ "vtabargtoken ::= LP anylist RP",
 /* 462 */ "anylist ::=",
 /* 463 */ "anylist ::= anylist LP anylist RP",
 /* 464 */ "anylist ::= anylist ANY",
 /* 465 */ "with ::=",
 /* 466 */ "with ::= WITH wqlist",
 /* 467 */ "with ::= WITH RECURSIVE wqlist",
 /* 468 */ "wqas ::= AS",
 /* 469 */ "wqas ::= AS MATERIALIZED",
 /* 470 */ "wqas ::= AS NOT MATERIALIZED",
 /* 471 */ "wqlist ::= wqcte",
 /* 472 */ "wqlist ::= wqlist COMMA wqcte",
 /* 473 */ "wqlist ::= ID_TAB_NEW",
 /* 474 */ "wqcte ::= nm idxlist_opt wqas LP select RP",
 /* 475 */ "windowdefn_list ::= windowdefn",
 /* 476 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 477 */ "windowdefn ::= nm AS LP window RP",
 /* 478 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 479 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 480 */ "window ::= ORDER BY sortlist frame_opt",
 /* 481 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 482 */ "window ::= frame_opt",
 /* 483 */ "window ::= nm frame_opt",
 /* 484 */ "frame_opt ::=",
 /* 485 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 486 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 487 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 488 */ "frame_bound_s ::= frame_bound",
 /* 489 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 490 */ "frame_bound_e ::= frame_bound",
 /* 491 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 492 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 493 */ "frame_bound ::= CURRENT ROW",
 /* 494 */ "frame_exclude_opt ::=",
 /* 495 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 496 */ "frame_exclude ::= NO OTHERS",
 /* 497 */ "frame_exclude ::= CURRENT ROW",
 /* 498 */ "frame_exclude ::= GROUP",
 /* 499 */ "frame_exclude ::= TIES",
 /* 500 */ "window_clause ::= WINDOW windowdefn_list",
 /* 501 */ "filter_over ::= filter_clause over_clause",
 /* 502 */ "filter_over ::= over_clause",
 /* 503 */ "filter_over ::= filter_clause",
 /* 504 */ "over_clause ::= OVER LP window RP",
 /* 505 */ "over_clause ::= OVER nm",
 /* 506 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 196: /* cmd */
    case 199: /* ecmd */
    case 201: /* cmdx */
    case 249: /* select_stmt */
    case 280: /* delete_stmt */
    case 282: /* update_stmt */
    case 285: /* insert_stmt */
    case 307: /* trigger_cmd */
    case 311: /* create_vtab */
{
parser_safe_delete((yypminor->yy43));
}
      break;
    case 200: /* explain */
{
parser_safe_delete((yypminor->yy317));
}
      break;
    case 202: /* transtype */
    case 203: /* trans_opt */
{
parser_safe_delete((yypminor->yy338));
}
      break;
    case 204: /* nm */
    case 215: /* columnid */
    case 218: /* id */
    case 219: /* id_opt */
    case 220: /* ids */
    case 222: /* typename */
    case 273: /* dbnm */
    case 298: /* collate */
    case 313: /* vtabarg */
    case 314: /* vtabargtoken */
    case 315: /* anylist */
{
parser_safe_delete((yypminor->yy267));
}
      break;
    case 205: /* savepoint_opt */
    case 207: /* ifnotexists */
    case 231: /* autoinc */
    case 235: /* gen_always */
    case 241: /* tconscomma */
    case 248: /* ifexists */
    case 288: /* rp_opt */
    case 290: /* not_opt */
    case 296: /* uniqueflag */
    case 308: /* database_kw_opt */
    case 310: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy473));
}
      break;
    case 206: /* temp */
    case 255: /* distinct */
{
parser_safe_delete((yypminor->yy348));
}
      break;
    case 208: /* fullname */
{
parser_safe_delete((yypminor->yy136));
}
      break;
    case 209: /* columnlist */
{
parser_safe_delete((yypminor->yy658));
}
      break;
    case 210: /* conslist_opt */
    case 240: /* conslist */
{
parser_safe_delete((yypminor->yy365));
}
      break;
    case 211: /* table_options */
{
parser_safe_delete((yypminor->yy399));
}
      break;
    case 212: /* select */
    case 251: /* selectnowith */
{
parser_safe_delete((yypminor->yy379));
}
      break;
    case 213: /* table_option */
{
parser_safe_delete((yypminor->yy661));
}
      break;
    case 214: /* column */
{
parser_safe_delete((yypminor->yy215));
}
      break;
    case 216: /* type */
    case 221: /* typetoken */
{
parser_safe_delete((yypminor->yy29));
}
      break;
    case 217: /* carglist */
{
parser_safe_delete((yypminor->yy333));
}
      break;
    case 223: /* signed */
    case 224: /* plus_num */
    case 225: /* minus_num */
    case 227: /* term */
    case 300: /* nmnum */
    case 301: /* number */
{
parser_safe_delete((yypminor->yy15));
}
      break;
    case 226: /* ccons */
{
parser_safe_delete((yypminor->yy298));
}
      break;
    case 228: /* expr */
    case 258: /* where_opt */
    case 260: /* having_opt */
    case 289: /* exprx */
    case 292: /* case_operand */
    case 294: /* case_else */
    case 299: /* vinto */
    case 305: /* when_clause */
    case 309: /* key_opt */
{
parser_safe_delete((yypminor->yy339));
}
      break;
    case 229: /* onconf */
    case 245: /* resolvetype */
    case 246: /* orconf */
{
parser_safe_delete((yypminor->yy134));
}
      break;
    case 230: /* sortorder */
{
parser_safe_delete((yypminor->yy25));
}
      break;
    case 232: /* idxlist_opt */
    case 243: /* idxlist */
{
parser_safe_delete((yypminor->yy121));
}
      break;
    case 233: /* refargs */
{
parser_safe_delete((yypminor->yy316));
}
      break;
    case 234: /* defer_subclause */
    case 244: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy497));
}
      break;
    case 236: /* tnm */
{
parser_safe_delete((yypminor->yy622));
}
      break;
    case 237: /* refarg */
{
parser_safe_delete((yypminor->yy165));
}
      break;
    case 238: /* refact */
{
parser_safe_delete((yypminor->yy410));
}
      break;
    case 239: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy218));
}
      break;
    case 242: /* tcons */
{
parser_safe_delete((yypminor->yy240));
}
      break;
    case 250: /* with */
{
parser_safe_delete((yypminor->yy91));
}
      break;
    case 252: /* oneselect */
{
parser_safe_delete((yypminor->yy492));
}
      break;
    case 253: /* multiselect_op */
{
parser_safe_delete((yypminor->yy116));
}
      break;
    case 254: /* values */
{
parser_safe_delete((yypminor->yy118));
}
      break;
    case 256: /* selcollist */
    case 266: /* sclp */
    case 281: /* returning */
{
parser_safe_delete((yypminor->yy75));
}
      break;
    case 257: /* from */
    case 268: /* joinsrc */
{
parser_safe_delete((yypminor->yy567));
}
      break;
    case 259: /* groupby_opt */
    case 264: /* nexprlist */
    case 265: /* exprlist */
    case 293: /* case_exprlist */
{
parser_safe_delete((yypminor->yy498));
}
      break;
    case 261: /* orderby_opt */
    case 278: /* sortlist */
{
parser_safe_delete((yypminor->yy277));
}
      break;
    case 262: /* limit_opt */
{
parser_safe_delete((yypminor->yy330));
}
      break;
    case 263: /* window_clause */
    case 319: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy369));
}
      break;
    case 267: /* as */
{
parser_safe_delete((yypminor->yy516));
}
      break;
    case 269: /* singlesrc */
{
parser_safe_delete((yypminor->yy95));
}
      break;
    case 270: /* seltablist */
{
parser_safe_delete((yypminor->yy527));
}
      break;
    case 271: /* joinop */
{
parser_safe_delete((yypminor->yy273));
}
      break;
    case 272: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy421));
}
      break;
    case 274: /* indexed_opt */
    case 277: /* indexed_by */
{
parser_safe_delete((yypminor->yy542));
}
      break;
    case 275: /* idlist */
    case 284: /* idlist_opt */
    case 312: /* vtabarglist */
{
parser_safe_delete((yypminor->yy327));
}
      break;
    case 276: /* xfullname */
{
parser_safe_delete((yypminor->yy128));
}
      break;
    case 279: /* nulls */
{
parser_safe_delete((yypminor->yy409));
}
      break;
    case 283: /* setlist */
{
parser_safe_delete((yypminor->yy387));
}
      break;
    case 286: /* insert_cmd */
{
parser_safe_delete((yypminor->yy284));
}
      break;
    case 287: /* upsert */
{
parser_safe_delete((yypminor->yy34));
}
      break;
    case 291: /* likeop */
{
parser_safe_delete((yypminor->yy436));
}
      break;
    case 295: /* filter_over */
{
parser_safe_delete((yypminor->yy405));
}
      break;
    case 297: /* idxlist_single */
{
parser_safe_delete((yypminor->yy166));
}
      break;
    case 302: /* trigger_time */
{
parser_safe_delete((yypminor->yy568));
}
      break;
    case 303: /* trigger_event */
{
parser_safe_delete((yypminor->yy469));
}
      break;
    case 304: /* foreach_clause */
{
parser_safe_delete((yypminor->yy247));
}
      break;
    case 306: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy412));
}
      break;
    case 316: /* wqlist */
{
parser_safe_delete((yypminor->yy114));
}
      break;
    case 317: /* wqas */
{
parser_safe_delete((yypminor->yy109));
}
      break;
    case 318: /* wqcte */
{
parser_safe_delete((yypminor->yy404));
}
      break;
    case 320: /* windowdefn */
{
parser_safe_delete((yypminor->yy219));
}
      break;
    case 321: /* window */
{
parser_safe_delete((yypminor->yy518));
}
      break;
    case 322: /* frame_opt */
{
parser_safe_delete((yypminor->yy463));
}
      break;
    case 323: /* range_or_rows */
{
parser_safe_delete((yypminor->yy122));
}
      break;
    case 324: /* frame_bound_s */
    case 326: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy453));
}
      break;
    case 327: /* frame_bound */
{
parser_safe_delete((yypminor->yy453));parser_safe_delete((yypminor->yy453));parser_safe_delete((yypminor->yy453));
}
      break;
    case 329: /* filter_clause */
{
parser_safe_delete((yypminor->yy37));
}
      break;
    case 330: /* over_clause */
{
parser_safe_delete((yypminor->yy437));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 197, 1 },
  { 198, 2 },
  { 198, 1 },
  { 199, 1 },
  { 199, 3 },
  { 200, 0 },
  { 200, 1 },
  { 200, 3 },
  { 201, 1 },
  { 196, 3 },
  { 203, 0 },
  { 203, 1 },
  { 203, 2 },
  { 203, 2 },
  { 202, 0 },
  { 202, 1 },
  { 202, 1 },
  { 202, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 205, 1 },
  { 205, 0 },
  { 196, 2 },
  { 196, 3 },
  { 196, 5 },
  { 196, 2 },
  { 196, 3 },
  { 196, 5 },
  { 196, 10 },
  { 196, 7 },
  { 196, 7 },
  { 196, 5 },
  { 211, 0 },
  { 211, 1 },
  { 211, 3 },
  { 213, 2 },
  { 213, 1 },
  { 213, 2 },
  { 213, 1 },
  { 207, 0 },
  { 207, 3 },
  { 206, 1 },
  { 206, 0 },
  { 209, 3 },
  { 209, 1 },
  { 214, 3 },
  { 215, 1 },
  { 215, 1 },
  { 218, 1 },
  { 219, 1 },
  { 219, 0 },
  { 220, 1 },
  { 220, 1 },
  { 204, 1 },
  { 204, 1 },
  { 204, 1 },
  { 216, 0 },
  { 216, 1 },
  { 221, 1 },
  { 221, 4 },
  { 221, 6 },
  { 222, 1 },
  { 222, 2 },
  { 222, 1 },
  { 223, 1 },
  { 223, 1 },
  { 217, 2 },
  { 217, 0 },
  { 226, 2 },
  { 226, 2 },
  { 226, 4 },
  { 226, 3 },
  { 226, 3 },
  { 226, 2 },
  { 226, 2 },
  { 226, 2 },
  { 226, 3 },
  { 226, 5 },
  { 226, 2 },
  { 226, 4 },
  { 226, 4 },
  { 226, 1 },
  { 226, 2 },
  { 226, 6 },
  { 226, 2 },
  { 226, 2 },
  { 226, 2 },
  { 226, 3 },
  { 227, 1 },
  { 227, 1 },
  { 227, 1 },
  { 227, 1 },
  { 236, 1 },
  { 236, 1 },
  { 235, 2 },
  { 235, 0 },
  { 231, 0 },
  { 231, 1 },
  { 233, 0 },
  { 233, 2 },
  { 237, 2 },
  { 237, 3 },
  { 237, 3 },
  { 237, 3 },
  { 237, 2 },
  { 238, 2 },
  { 238, 2 },
  { 238, 1 },
  { 238, 1 },
  { 238, 2 },
  { 234, 3 },
  { 234, 2 },
  { 239, 0 },
  { 239, 2 },
  { 239, 2 },
  { 210, 0 },
  { 210, 2 },
  { 240, 3 },
  { 240, 1 },
  { 241, 1 },
  { 241, 0 },
  { 242, 2 },
  { 242, 7 },
  { 242, 5 },
  { 242, 5 },
  { 242, 10 },
  { 242, 2 },
  { 242, 7 },
  { 242, 4 },
  { 244, 0 },
  { 244, 1 },
  { 229, 0 },
  { 229, 3 },
  { 246, 0 },
  { 246, 2 },
  { 245, 1 },
  { 245, 1 },
  { 245, 1 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 248, 2 },
  { 248, 0 },
  { 196, 8 },
  { 196, 7 },
  { 196, 5 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 1 },
  { 249, 1 },
  { 212, 2 },
  { 251, 1 },
  { 251, 3 },
  { 251, 3 },
  { 251, 1 },
  { 251, 3 },
  { 252, 9 },
  { 252, 10 },
  { 254, 4 },
  { 254, 5 },
  { 253, 1 },
  { 253, 2 },
  { 253, 1 },
  { 253, 1 },
  { 255, 1 },
  { 255, 1 },
  { 255, 0 },
  { 266, 2 },
  { 266, 0 },
  { 256, 3 },
  { 256, 2 },
  { 256, 4 },
  { 256, 1 },
  { 256, 4 },
  { 267, 2 },
  { 267, 1 },
  { 267, 2 },
  { 267, 1 },
  { 267, 0 },
  { 257, 0 },
  { 257, 2 },
  { 268, 2 },
  { 268, 0 },
  { 270, 4 },
  { 270, 0 },
  { 269, 4 },
  { 269, 4 },
  { 269, 4 },
  { 269, 6 },
  { 269, 0 },
  { 269, 2 },
  { 269, 3 },
  { 269, 1 },
  { 269, 3 },
  { 269, 1 },
  { 272, 2 },
  { 272, 4 },
  { 272, 0 },
  { 273, 0 },
  { 273, 2 },
  { 208, 1 },
  { 208, 3 },
  { 276, 1 },
  { 276, 3 },
  { 276, 5 },
  { 276, 3 },
  { 276, 5 },
  { 276, 3 },
  { 271, 1 },
  { 271, 1 },
  { 271, 2 },
  { 271, 3 },
  { 271, 4 },
  { 271, 1 },
  { 274, 0 },
  { 274, 1 },
  { 277, 3 },
  { 277, 2 },
  { 277, 3 },
  { 261, 0 },
  { 261, 3 },
  { 278, 5 },
  { 278, 3 },
  { 230, 1 },
  { 230, 1 },
  { 230, 0 },
  { 279, 2 },
  { 279, 2 },
  { 279, 0 },
  { 259, 0 },
  { 259, 3 },
  { 259, 2 },
  { 260, 0 },
  { 260, 2 },
  { 262, 0 },
  { 262, 2 },
  { 262, 4 },
  { 262, 4 },
  { 196, 1 },
  { 280, 9 },
  { 280, 3 },
  { 280, 5 },
  { 280, 6 },
  { 280, 4 },
  { 258, 0 },
  { 258, 2 },
  { 258, 1 },
  { 281, 0 },
  { 281, 2 },
  { 196, 1 },
  { 282, 12 },
  { 282, 3 },
  { 282, 5 },
  { 282, 6 },
  { 282, 4 },
  { 283, 5 },
  { 283, 7 },
  { 283, 3 },
  { 283, 5 },
  { 283, 0 },
  { 283, 2 },
  { 283, 3 },
  { 283, 1 },
  { 284, 0 },
  { 284, 3 },
  { 275, 3 },
  { 275, 1 },
  { 275, 0 },
  { 275, 3 },
  { 275, 1 },
  { 196, 1 },
  { 285, 8 },
  { 285, 8 },
  { 285, 7 },
  { 285, 3 },
  { 285, 5 },
  { 285, 4 },
  { 285, 6 },
  { 286, 2 },
  { 286, 1 },
  { 287, 0 },
  { 287, 11 },
  { 287, 8 },
  { 287, 4 },
  { 289, 4 },
  { 289, 6 },
  { 289, 1 },
  { 289, 3 },
  { 289, 5 },
  { 289, 3 },
  { 289, 6 },
  { 289, 1 },
  { 289, 3 },
  { 289, 1 },
  { 289, 3 },
  { 289, 2 },
  { 289, 5 },
  { 289, 4 },
  { 289, 1 },
  { 289, 3 },
  { 289, 6 },
  { 289, 5 },
  { 289, 8 },
  { 289, 4 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 4 },
  { 289, 6 },
  { 289, 2 },
  { 289, 3 },
  { 289, 4 },
  { 289, 6 },
  { 289, 5 },
  { 289, 2 },
  { 289, 2 },
  { 289, 2 },
  { 289, 2 },
  { 289, 3 },
  { 289, 6 },
  { 289, 6 },
  { 289, 3 },
  { 289, 6 },
  { 289, 5 },
  { 289, 4 },
  { 289, 5 },
  { 289, 4 },
  { 289, 6 },
  { 289, 6 },
  { 289, 9 },
  { 289, 5 },
  { 289, 12 },
  { 228, 0 },
  { 228, 1 },
  { 290, 0 },
  { 290, 1 },
  { 288, 0 },
  { 288, 1 },
  { 291, 1 },
  { 293, 5 },
  { 293, 4 },
  { 294, 2 },
  { 294, 0 },
  { 292, 1 },
  { 292, 0 },
  { 265, 1 },
  { 265, 0 },
  { 264, 3 },
  { 264, 1 },
  { 196, 12 },
  { 196, 8 },
  { 196, 7 },
  { 196, 5 },
  { 296, 1 },
  { 296, 0 },
  { 232, 0 },
  { 232, 3 },
  { 243, 3 },
  { 243, 1 },
  { 297, 3 },
  { 297, 1 },
  { 298, 0 },
  { 298, 2 },
  { 298, 2 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 2 },
  { 196, 3 },
  { 299, 2 },
  { 299, 0 },
  { 196, 3 },
  { 196, 5 },
  { 196, 6 },
  { 196, 5 },
  { 196, 6 },
  { 196, 4 },
  { 196, 2 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 224, 2 },
  { 224, 1 },
  { 225, 2 },
  { 301, 1 },
  { 301, 1 },
  { 196, 15 },
  { 196, 12 },
  { 196, 14 },
  { 196, 10 },
  { 196, 7 },
  { 196, 5 },
  { 302, 1 },
  { 302, 1 },
  { 302, 2 },
  { 302, 0 },
  { 303, 1 },
  { 303, 1 },
  { 303, 1 },
  { 303, 3 },
  { 304, 0 },
  { 304, 3 },
  { 305, 0 },
  { 305, 2 },
  { 306, 3 },
  { 306, 2 },
  { 306, 1 },
  { 307, 1 },
  { 307, 1 },
  { 307, 1 },
  { 307, 1 },
  { 247, 1 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 6 },
  { 196, 3 },
  { 309, 0 },
  { 309, 2 },
  { 308, 1 },
  { 308, 0 },
  { 196, 1 },
  { 196, 3 },
  { 196, 2 },
  { 196, 4 },
  { 196, 2 },
  { 196, 1 },
  { 196, 3 },
  { 196, 4 },
  { 196, 2 },
  { 196, 6 },
  { 196, 6 },
  { 196, 6 },
  { 196, 8 },
  { 196, 6 },
  { 196, 6 },
  { 196, 5 },
  { 196, 8 },
  { 196, 5 },
  { 196, 3 },
  { 310, 0 },
  { 310, 1 },
  { 196, 1 },
  { 311, 8 },
  { 311, 11 },
  { 311, 7 },
  { 311, 5 },
  { 312, 1 },
  { 312, 3 },
  { 313, 0 },
  { 313, 2 },
  { 314, 1 },
  { 314, 3 },
  { 315, 0 },
  { 315, 4 },
  { 315, 2 },
  { 250, 0 },
  { 250, 2 },
  { 250, 3 },
  { 317, 1 },
  { 317, 2 },
  { 317, 3 },
  { 316, 1 },
  { 316, 3 },
  { 316, 1 },
  { 318, 6 },
  { 319, 1 },
  { 319, 3 },
  { 320, 5 },
  { 321, 5 },
  { 321, 6 },
  { 321, 4 },
  { 321, 5 },
  { 321, 1 },
  { 321, 2 },
  { 322, 0 },
  { 322, 3 },
  { 322, 6 },
  { 323, 1 },
  { 324, 1 },
  { 324, 2 },
  { 326, 1 },
  { 326, 2 },
  { 327, 2 },
  { 327, 2 },
  { 325, 0 },
  { 325, 2 },
  { 328, 2 },
  { 328, 2 },
  { 328, 1 },
  { 328, 1 },
  { 263, 2 },
  { 295, 2 },
  { 295, 1 },
  { 295, 1 },
  { 330, 4 },
  { 330, 2 },
  { 329, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy43); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy43);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy43 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy43 = yymsp[-1].minor.yy43;
                                                yygotominor.yy43->explain = yymsp[-2].minor.yy317->explain;
                                                yygotominor.yy43->queryPlan = yymsp[-2].minor.yy317->queryPlan;
                                                delete yymsp[-2].minor.yy317;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy317 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy317 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy317 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 416: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==416);
      case 417: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==417);
      case 418: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==418);
      case 419: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==419);
      case 451: /* cmd ::= create_vtab */ yytestcase(yyruleno==451);
{yygotominor.yy43 = yymsp[0].minor.yy43;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy43 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy338->type,
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                delete yymsp[-1].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy338 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->transactionKw = true;
                                                yygotominor.yy338->name = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy43 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy43 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy43 = new SqliteRollback(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 41: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==41);
      case 95: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==95);
      case 98: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==98);
      case 120: /* tconscomma ::= COMMA */ yytestcase(yyruleno==120);
      case 142: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==142);
      case 342: /* not_opt ::= NOT */ yytestcase(yyruleno==342);
      case 344: /* rp_opt ::= RP */ yytestcase(yyruleno==344);
      case 360: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==360);
      case 428: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==428);
      case 450: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==450);
{yygotominor.yy473 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 40: /* ifnotexists ::= */ yytestcase(yyruleno==40);
      case 96: /* gen_always ::= */ yytestcase(yyruleno==96);
      case 97: /* autoinc ::= */ yytestcase(yyruleno==97);
      case 121: /* tconscomma ::= */ yytestcase(yyruleno==121);
      case 143: /* ifexists ::= */ yytestcase(yyruleno==143);
      case 341: /* not_opt ::= */ yytestcase(yyruleno==341);
      case 343: /* rp_opt ::= */ yytestcase(yyruleno==343);
      case 361: /* uniqueflag ::= */ yytestcase(yyruleno==361);
      case 429: /* database_kw_opt ::= */ yytestcase(yyruleno==429);
      case 449: /* kwcolumn_opt ::= */ yytestcase(yyruleno==449);
{yygotominor.yy473 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy43 = new SqliteSavepoint(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy43 = new SqliteRelease(*(yymsp[-1].minor.yy473), *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy43 = new SqliteRollback(
                                                        yymsp[-3].minor.yy338->transactionKw,
                                                        *(yymsp[-1].minor.yy473),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,205,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy43 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy473),
                                                        *(yymsp[-8].minor.yy348),
                                                        yymsp[-5].minor.yy136->name1,
                                                        yymsp[-5].minor.yy136->name2,
                                                        *(yymsp[-3].minor.yy658),
                                                        *(yymsp[-2].minor.yy365),
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[-6].minor.yy473;
                                                delete yymsp[-8].minor.yy348;
                                                delete yymsp[-3].minor.yy658;
                                                delete yymsp[-2].minor.yy365;
                                                delete yymsp[-5].minor.yy136;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy43 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy473),
                                                        *(yymsp[-5].minor.yy348),
                                                        yymsp[-2].minor.yy136->name1,
                                                        yymsp[-2].minor.yy136->name2,
                                                        yymsp[0].minor.yy379
                                                    );
                                                delete yymsp[-3].minor.yy473;
                                                delete yymsp[-5].minor.yy348;
                                                delete yymsp[-2].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 145: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==145);
      case 399: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==399);
{  yy_destructor(yypParser,206,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 146: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==146);
      case 400: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==400);
{  yy_destructor(yypParser,206,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
{yygotominor.yy399 = new ParserCreateTableOptionList();}
        break;
      case 34: /* table_options ::= table_option */
{
                                                yygotominor.yy399 = new ParserCreateTableOptionList();
                                                yygotominor.yy399->append(yymsp[0].minor.yy661);
                                            }
        break;
      case 35: /* table_options ::= table_options COMMA table_option */
{
                                                yymsp[-2].minor.yy399->append(yymsp[0].minor.yy661);
                                                yygotominor.yy399 = yymsp[-2].minor.yy399;
                                                DONT_INHERIT_TOKENS("table_options");
                                            }
        break;
      case 36: /* table_option ::= WITHOUT nm */
{
                                                if (yymsp[0].minor.yy267->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy661 = new ParserStubCreateTableOption(ParserStubCreateTableOption::WITHOUT_ROWID);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 37: /* table_option ::= nm */
      case 38: /* table_option ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==38);
      case 39: /* table_option ::= CTX_STRICT_KW */ yytestcase(yyruleno==39);
{
                                                if (yymsp[0].minor.yy267->toLower() != "strict")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy661 = new ParserStubCreateTableOption(ParserStubCreateTableOption::STRICT);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 42: /* temp ::= TEMP */
{yygotominor.yy348 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 43: /* temp ::= */
      case 168: /* distinct ::= */ yytestcase(yyruleno==168);
{yygotominor.yy348 = new int(0);}
        break;
      case 44: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy658->append(yymsp[0].minor.yy215);
                                                yygotominor.yy658 = yymsp[-2].minor.yy658;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 45: /* columnlist ::= column */
{
                                                yygotominor.yy658 = new ParserCreateTableColumnList();
                                                yygotominor.yy658->append(yymsp[0].minor.yy215);
                                            }
        break;
      case 46: /* column ::= columnid type carglist */
{
                                                yygotominor.yy215 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy267), yymsp[-1].minor.yy29, *(yymsp[0].minor.yy333));
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy333;
                                                objectForTokens = yygotominor.yy215;
                                            }
        break;
      case 47: /* columnid ::= nm */
      case 48: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==48);
      case 54: /* nm ::= id */ yytestcase(yyruleno==54);
      case 62: /* typename ::= ids */ yytestcase(yyruleno==62);
      case 201: /* dbnm ::= DOT nm */ yytestcase(yyruleno==201);
      case 369: /* collate ::= COLLATE ids */ yytestcase(yyruleno==369);
      case 370: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==370);
{yygotominor.yy267 = yymsp[0].minor.yy267;}
        break;
      case 49: /* id ::= ID|INDEXED|GENERATED */
{
                                                yygotominor.yy267 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 50: /* id_opt ::= id */
{
                                                yygotominor.yy267 = yymsp[0].minor.yy267;
                                            }
        break;
      case 51: /* id_opt ::= */
{
                                                yygotominor.yy267 = new QString();
                                            }
        break;
      case 52: /* ids ::= ID */
      case 56: /* nm ::= JOIN_KW */ yytestcase(yyruleno==56);
{yygotominor.yy267 = new QString(stripObjName(yymsp[0].minor.yy0->value));}
        break;
      case 53: /* ids ::= STRING */
      case 55: /* nm ::= STRING */ yytestcase(yyruleno==55);
{yygotominor.yy267 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 57: /* type ::= */
{yygotominor.yy29 = nullptr;}
        break;
      case 58: /* type ::= typetoken */
{yygotominor.yy29 = yymsp[0].minor.yy29;}
        break;
      case 59: /* typetoken ::= typename */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 60: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[-3].minor.yy267), *(yymsp[-1].minor.yy15));
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 61: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[-5].minor.yy267), *(yymsp[-3].minor.yy15), *(yymsp[-1].minor.yy15));
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy15;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 63: /* typename ::= typename ids */
      case 64: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==64);
{
                                                yymsp[-1].minor.yy267->append(" " + *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                            }
        break;
      case 65: /* signed ::= plus_num */
      case 66: /* signed ::= minus_num */ yytestcase(yyruleno==66);
      case 385: /* nmnum ::= plus_num */ yytestcase(yyruleno==385);
      case 390: /* plus_num ::= PLUS number */ yytestcase(yyruleno==390);
      case 391: /* plus_num ::= number */ yytestcase(yyruleno==391);
{yygotominor.yy15 = yymsp[0].minor.yy15;}
        break;
      case 67: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy333->append(yymsp[0].minor.yy298);
                                                yygotominor.yy333 = yymsp[-1].minor.yy333;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 68: /* carglist ::= */
{yygotominor.yy333 = new ParserCreateTableColumnConstraintList();}
        break;
      case 69: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefNameOnly(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15));
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 71: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefExpr(yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 72: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15), false);
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 73: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15), true);
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 74: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefId(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 75: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 76: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initNull(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 77: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initNotNull(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 78: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initPk(*(yymsp[-2].minor.yy25), *(yymsp[-1].minor.yy134), *(yymsp[0].minor.yy473));
                                                delete yymsp[-2].minor.yy25;
                                                delete yymsp[0].minor.yy473;
                                                delete yymsp[-1].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 79: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initUnique(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initCheck(yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 81: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initFk(*(yymsp[-2].minor.yy267), *(yymsp[-1].minor.yy121), *(yymsp[0].minor.yy316));
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy316;
                                                delete yymsp[-1].minor.yy121;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 82: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefer(yymsp[0].minor.yy497->initially, yymsp[0].minor.yy497->deferrable);
                                                delete yymsp[0].minor.yy497;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 83: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initColl(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 84: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 85: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==85);
      case 86: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==86);
      case 87: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==87);
{
                                                if (!yymsp[0].minor.yy267->isNull() && yymsp[0].minor.yy267->toLower() != "stored" && yymsp[0].minor.yy267->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initGeneratedAs(yymsp[-2].minor.yy339, *(yymsp[-5].minor.yy473), *(yymsp[0].minor.yy267));
                                                delete yymsp[-5].minor.yy473;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 88: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initCheck();
                                                objectForTokens = yygotominor.yy298;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 89: /* term ::= NULL */
{yygotominor.yy15 = new QVariant();}
        break;
      case 90: /* term ::= INTEGER */
      case 393: /* number ::= INTEGER */ yytestcase(yyruleno==393);
{yygotominor.yy15 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 91: /* term ::= FLOAT */
      case 394: /* number ::= FLOAT */ yytestcase(yyruleno==394);
{yygotominor.yy15 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 92: /* term ::= STRING|BLOB */
{
                                                if (yymsp[0].minor.yy0->value.length() >= 3 && yymsp[0].minor.yy0->value.startsWith("x'", Qt::CaseInsensitive))
                                                    yygotominor.yy15 = new QVariant(blobFromLiteral(yymsp[0].minor.yy0->value));
                                                else
                                                    yygotominor.yy15 = new QVariant(stripString(yymsp[0].minor.yy0->value));
                                            }
        break;
      case 93: /* tnm ::= term */
{
												yygotominor.yy622 = new ParserTermOrLiteral(*(yymsp[0].minor.yy15));
												delete yymsp[0].minor.yy15;
											}
        break;
      case 94: /* tnm ::= nm */
{
												yygotominor.yy622 = new ParserTermOrLiteral(*(yymsp[0].minor.yy267));
												delete yymsp[0].minor.yy267;
											}
        break;
      case 99: /* refargs ::= */
{yygotominor.yy316 = new ParserFkConditionList();}
        break;
      case 100: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy316->append(yymsp[0].minor.yy165);
                                                yygotominor.yy316 = yymsp[-1].minor.yy316;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 101: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy165 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 102: /* refarg ::= ON INSERT refact */
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 103: /* refarg ::= ON DELETE refact */
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 104: /* refarg ::= ON UPDATE refact */
      case 105: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==105);
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 106: /* refact ::= SET NULL */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 107: /* refact ::= SET DEFAULT */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 108: /* refact ::= CASCADE */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 109: /* refact ::= RESTRICT */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 110: /* refact ::= NO ACTION */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 111: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy218));
                                                delete yymsp[0].minor.yy218;
                                            }
        break;
      case 112: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy218));
                                                delete yymsp[0].minor.yy218;
                                            }
        break;
      case 113: /* init_deferred_pred_opt ::= */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 114: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 115: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 116: /* conslist_opt ::= */
{yygotominor.yy365 = new ParserCreateTableConstraintList();}
        break;
      case 117: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy365 = yymsp[0].minor.yy365;}
        break;
      case 118: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy240->afterComma = *(yymsp[-1].minor.yy473);
                                                yymsp[-2].minor.yy365->append(yymsp[0].minor.yy240);
                                                yygotominor.yy365 = yymsp[-2].minor.yy365;
                                                delete yymsp[-1].minor.yy473;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 119: /* conslist ::= tcons */
{
                                                yygotominor.yy365 = new ParserCreateTableConstraintList();
                                                yygotominor.yy365->append(yymsp[0].minor.yy240);
                                            }
        break;
      case 122: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initNameOnly(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 123: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initPk(*(yymsp[-3].minor.yy121), *(yymsp[-2].minor.yy473), *(yymsp[0].minor.yy134));
                                                delete yymsp[-2].minor.yy473;
                                                delete yymsp[0].minor.yy134;
                                                delete yymsp[-3].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 124: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initUnique(*(yymsp[-2].minor.yy121), *(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                delete yymsp[-2].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 125: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initCheck(yymsp[-2].minor.yy339, *(yymsp[0].minor.yy134));
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 126: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 127: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==127);
      case 128: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==128);
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initFk(
                                                    *(yymsp[-6].minor.yy121),
                                                    *(yymsp[-3].minor.yy267),
                                                    *(yymsp[-2].minor.yy121),
                                                    *(yymsp[-1].minor.yy316),
                                                    yymsp[0].minor.yy497->initially,
                                                    yymsp[0].minor.yy497->deferrable
                                                );
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy316;
                                                delete yymsp[0].minor.yy497;
                                                delete yymsp[-2].minor.yy121;
                                                delete yymsp[-6].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 129: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initCheck();
                                                objectForTokens = yygotominor.yy240;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,229,&yymsp[0].minor);
}
        break;
      case 130: /* defer_subclause_opt ::= */
{yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 131: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy497 = yymsp[0].minor.yy497;}
        break;
      case 132: /* onconf ::= */
      case 134: /* orconf ::= */ yytestcase(yyruleno==134);
{yygotominor.yy134 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 133: /* onconf ::= ON CONFLICT resolvetype */
      case 135: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==135);
{yygotominor.yy134 = yymsp[0].minor.yy134;}
        break;
      case 136: /* resolvetype ::= raisetype */
      case 137: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==137);
      case 138: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==138);
{yygotominor.yy134 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 139: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropTable(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 140: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 141: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==141);
      case 148: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==148);
      case 149: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==149);
      case 193: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==193);
      case 194: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==194);
      case 195: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==195);
      case 196: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==196);
      case 358: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==358);
      case 359: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==359);
      case 372: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==372);
      case 373: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==373);
      case 383: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==383);
      case 384: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==384);
      case 422: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==422);
      case 423: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==423);
      case 433: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==433);
      case 434: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==434);
      case 437: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==437);
      case 438: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==438);
      case 447: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==447);
      case 448: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==448);
      case 454: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==454);
      case 455: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==455);
{  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 144: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy43 = new SqliteCreateView(*(yymsp[-6].minor.yy348), *(yymsp[-4].minor.yy473), yymsp[-3].minor.yy136->name1, yymsp[-3].minor.yy136->name2, yymsp[0].minor.yy379, *(yymsp[-2].minor.yy121));
                                                delete yymsp[-6].minor.yy348;
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                delete yymsp[-2].minor.yy121;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 147: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropView(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 150: /* cmd ::= select_stmt */
      case 240: /* cmd ::= delete_stmt */ yytestcase(yyruleno==240);
      case 251: /* cmd ::= update_stmt */ yytestcase(yyruleno==251);
      case 272: /* cmd ::= insert_stmt */ yytestcase(yyruleno==272);
{
                                                yygotominor.yy43 = yymsp[0].minor.yy43;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 151: /* select_stmt ::= select */
{
                                                yygotominor.yy43 = yymsp[0].minor.yy379;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 152: /* select ::= with selectnowith */
{
                                                yygotominor.yy379 = yymsp[0].minor.yy379;
                                                yymsp[0].minor.yy379->setWith(yymsp[-1].minor.yy91);
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 153: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[0].minor.yy492);
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 154: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[-2].minor.yy379, *(yymsp[-1].minor.yy116), yymsp[0].minor.yy492);
                                                delete yymsp[-1].minor.yy116;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 155: /* selectnowith ::= selectnowith multiselect_op values */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[-2].minor.yy379, *(yymsp[-1].minor.yy116), *(yymsp[0].minor.yy118));
                                                delete yymsp[-1].minor.yy116;
                                                delete yymsp[0].minor.yy118;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 156: /* selectnowith ::= values */
{
                                                yygotominor.yy379 = SqliteSelect::append(*(yymsp[0].minor.yy118));
                                                delete yymsp[0].minor.yy118;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 157: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[-2].minor.yy379, SqliteSelect::CompoundOperator::COMMA, *(yymsp[0].minor.yy118));
                                                delete yymsp[0].minor.yy118;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 158: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy492 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy348),
                                                        *(yymsp[-6].minor.yy75),
                                                        yymsp[-5].minor.yy567,
                                                        yymsp[-4].minor.yy339,
                                                        *(yymsp[-3].minor.yy498),
                                                        yymsp[-2].minor.yy339,
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-6].minor.yy75;
                                                delete yymsp[-7].minor.yy348;
                                                delete yymsp[-3].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                objectForTokens = yygotominor.yy492;
                                            }
        break;
      case 159: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy492 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy348),
                                                        *(yymsp[-7].minor.yy75),
                                                        yymsp[-6].minor.yy567,
                                                        yymsp[-5].minor.yy339,
                                                        *(yymsp[-4].minor.yy498),
                                                        yymsp[-3].minor.yy339,
                                                        *(yymsp[-2].minor.yy369),
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-7].minor.yy75;
                                                delete yymsp[-8].minor.yy348;
                                                delete yymsp[-4].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                delete yymsp[-2].minor.yy369;
                                                objectForTokens = yygotominor.yy492;
                                            }
        break;
      case 160: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy118 = new ParserExprNestedList();
                                                yygotominor.yy118->append(*(yymsp[-1].minor.yy498));
                                                delete yymsp[-1].minor.yy498;
                                            }
        break;
      case 161: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy118->append(*(yymsp[-1].minor.yy498));
                                                yygotominor.yy118 = yymsp[-4].minor.yy118;
                                                delete yymsp[-1].minor.yy498;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 162: /* multiselect_op ::= UNION */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 163: /* multiselect_op ::= UNION ALL */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 164: /* multiselect_op ::= EXCEPT */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 165: /* multiselect_op ::= INTERSECT */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 166: /* distinct ::= DISTINCT */
{yygotominor.yy348 = new int(1);}
        break;
      case 167: /* distinct ::= ALL */
{yygotominor.yy348 = new int(2);}
        break;
      case 169: /* sclp ::= selcollist COMMA */
{yygotominor.yy75 = yymsp[-1].minor.yy75;}
        break;
      case 170: /* sclp ::= */
      case 249: /* returning ::= */ yytestcase(yyruleno==249);
{yygotominor.yy75 = new ParserResultColumnList();}
        break;
      case 171: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy339,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );

                                                yymsp[-2].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-2].minor.yy75;
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 172: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-1].minor.yy75;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 173: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy622->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy622->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-3].minor.yy75;
                                                delete yymsp[-2].minor.yy622;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 174: /* selcollist ::= sclp */
      case 175: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==175);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy75 = yymsp[0].minor.yy75;
                                            }
        break;
      case 176: /* as ::= AS nm */
{
                                                yygotominor.yy516 = new ParserStubAlias(*(yymsp[0].minor.yy267), true);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 177: /* as ::= ids */
      case 178: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==178);
      case 179: /* as ::= ID_ALIAS */ yytestcase(yyruleno==179);
{
                                                yygotominor.yy516 = new ParserStubAlias(*(yymsp[0].minor.yy267), false);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 180: /* as ::= */
{yygotominor.yy516 = nullptr;}
        break;
      case 181: /* from ::= */
{yygotominor.yy567 = nullptr;}
        break;
      case 182: /* from ::= FROM joinsrc */
{yygotominor.yy567 = yymsp[0].minor.yy567;}
        break;
      case 183: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy567 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy95,
                                                        *(yymsp[0].minor.yy527)
                                                    );
                                                delete yymsp[0].minor.yy527;
                                                objectForTokens = yygotominor.yy567;
                                            }
        break;
      case 184: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy567 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy567;
                                            }
        break;
      case 185: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy273, yymsp[-1].minor.yy95, yymsp[0].minor.yy421);

                                                yymsp[-3].minor.yy527->append(src);
                                                yygotominor.yy527 = yymsp[-3].minor.yy527;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 186: /* seltablist ::= */
{
                                                yygotominor.yy527 = new ParserOtherSourceList();
                                            }
        break;
      case 187: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        yymsp[-1].minor.yy516 ? yymsp[-1].minor.yy516->asKw : false,
                                                        yymsp[-1].minor.yy516 ? yymsp[-1].minor.yy516->name : QString(),
                                                        yymsp[0].minor.yy542 ? yymsp[0].minor.yy542->notIndexedKw : false,
                                                        yymsp[0].minor.yy542 ? yymsp[0].minor.yy542->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-1].minor.yy516;
                                                if (yymsp[0].minor.yy542)
                                                    delete yymsp[0].minor.yy542;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 188: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy379,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 189: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy567,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 190: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-4].minor.yy267),
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString(),
                                                        *(yymsp[-2].minor.yy498)
                                                    );
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[0].minor.yy516;
                                                if (yymsp[-2].minor.yy498)
                                                    delete yymsp[-2].minor.yy498;

                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 191: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 192: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy95->database = *(yymsp[-1].minor.yy267);
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 197: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy421 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy421;
                                            }
        break;
      case 198: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy421 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy327));
                                                delete yymsp[-1].minor.yy327;
                                                objectForTokens = yygotominor.yy421;
                                            }
        break;
      case 199: /* joinconstr_opt ::= */
{yygotominor.yy421 = nullptr;}
        break;
      case 200: /* dbnm ::= */
      case 368: /* collate ::= */ yytestcase(yyruleno==368);
      case 458: /* vtabarg ::= */ yytestcase(yyruleno==458);
      case 462: /* anylist ::= */ yytestcase(yyruleno==462);
{yygotominor.yy267 = new QString();}
        break;
      case 202: /* fullname ::= nm */
{
                                                yygotominor.yy136 = new ParserFullName();
                                                yygotominor.yy136->name1 = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 203: /* fullname ::= nm DOT nm */
{
                                                yygotominor.yy136 = new ParserFullName();
                                                yygotominor.yy136->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy136->name2 = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 204: /* xfullname ::= nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 205: /* xfullname ::= nm DOT nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 206: /* xfullname ::= nm DOT nm AS nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-4].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->alias = *(yymsp[0].minor.yy267);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 207: /* xfullname ::= nm AS nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->alias = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 208: /* xfullname ::= nm DOT nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-4].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[-2].minor.yy267);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 209: /* xfullname ::= nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 210: /* joinop ::= COMMA */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 211: /* joinop ::= JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 212: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 213: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 214: /* joinop ::= JOIN_KW nm nm JOIN */
      case 215: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==215);
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy267), *(yymsp[-1].minor.yy267));
                                                delete yymsp[-2].minor.yy267;
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 216: /* indexed_opt ::= */
{yygotominor.yy542 = nullptr;}
        break;
      case 217: /* indexed_opt ::= indexed_by */
{yygotominor.yy542 = yymsp[0].minor.yy542;}
        break;
      case 218: /* indexed_by ::= INDEXED BY nm */
{
                                                yygotominor.yy542 = new ParserIndexedBy(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 219: /* indexed_by ::= NOT INDEXED */
{yygotominor.yy542 = new ParserIndexedBy(true);}
        break;
      case 220: /* indexed_by ::= INDEXED BY ID_IDX */
{parserContext->minorErrorBeforeNextToken("Syntax error");}
        break;
      case 221: /* orderby_opt ::= */
{yygotominor.yy277 = new ParserOrderByList();}
        break;
      case 222: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy277 = yymsp[0].minor.yy277;}
        break;
      case 223: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy339, *(yymsp[-1].minor.yy25), *(yymsp[0].minor.yy409));
                                                yymsp[-4].minor.yy277->append(obj);
                                                yygotominor.yy277 = yymsp[-4].minor.yy277;
                                                delete yymsp[-1].minor.yy25;
												delete yymsp[0].minor.yy409;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 224: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy339, *(yymsp[-1].minor.yy25), *(yymsp[0].minor.yy409));
                                                yygotominor.yy277 = new ParserOrderByList();
                                                yygotominor.yy277->append(obj);
                                                delete yymsp[-1].minor.yy25;
												delete yymsp[0].minor.yy409;
                                                objectForTokens = obj;
                                            }
        break;
      case 225: /* sortorder ::= ASC */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 226: /* sortorder ::= DESC */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 227: /* sortorder ::= */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 228: /* nulls ::= NULLS FIRST */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 229: /* nulls ::= NULLS LAST */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 230: /* nulls ::= */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 231: /* groupby_opt ::= */
      case 353: /* exprlist ::= */ yytestcase(yyruleno==353);
{yygotominor.yy498 = new ParserExprList();}
        break;
      case 232: /* groupby_opt ::= GROUP BY nexprlist */
      case 352: /* exprlist ::= nexprlist */ yytestcase(yyruleno==352);
{yygotominor.yy498 = yymsp[0].minor.yy498;}
        break;
      case 233: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy498 = new ParserExprList();
                                            }
        break;
      case 234: /* having_opt ::= */
      case 246: /* where_opt ::= */ yytestcase(yyruleno==246);
      case 349: /* case_else ::= */ yytestcase(yyruleno==349);
      case 351: /* case_operand ::= */ yytestcase(yyruleno==351);
      case 377: /* vinto ::= */ yytestcase(yyruleno==377);
      case 411: /* when_clause ::= */ yytestcase(yyruleno==411);
      case 426: /* key_opt ::= */ yytestcase(yyruleno==426);
{yygotominor.yy339 = nullptr;}
        break;
      case 235: /* having_opt ::= HAVING expr */
      case 247: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==247);
      case 340: /* expr ::= exprx */ yytestcase(yyruleno==340);
      case 348: /* case_else ::= ELSE expr */ yytestcase(yyruleno==348);
      case 350: /* case_operand ::= exprx */ yytestcase(yyruleno==350);
      case 376: /* vinto ::= INTO expr */ yytestcase(yyruleno==376);
      case 412: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==412);
      case 427: /* key_opt ::= KEY expr */ yytestcase(yyruleno==427);
{yygotominor.yy339 = yymsp[0].minor.yy339;}
        break;
      case 236: /* limit_opt ::= */
{yygotominor.yy330 = nullptr;}
        break;
      case 237: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 238: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[-2].minor.yy339, yymsp[0].minor.yy339, true);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 239: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[-2].minor.yy339, yymsp[0].minor.yy339, false);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 241: /* delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt */
{
                                                if (yymsp[-4].minor.yy542)
                                                {
                                                    if (!yymsp[-4].minor.yy542->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy43 = new SqliteDelete(
                                                                yymsp[-5].minor.yy128->name1,
                                                                yymsp[-5].minor.yy128->name2,
                                                                yymsp[-5].minor.yy128->alias,
                                                                yymsp[-4].minor.yy542->indexedBy,
                                                                yymsp[-3].minor.yy339,
                                                                yymsp[-8].minor.yy91,
                                                                *(yymsp[-2].minor.yy75),
                                                                *(yymsp[-1].minor.yy277),
                                                                yymsp[0].minor.yy330
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy43 = new SqliteDelete(
                                                                yymsp[-5].minor.yy128->name1,
                                                                yymsp[-5].minor.yy128->name2,
                                                                yymsp[-5].minor.yy128->alias,
                                                                yymsp[-4].minor.yy542->notIndexedKw,
                                                                yymsp[-3].minor.yy339,
                                                                yymsp[-8].minor.yy91,
                                                                *(yymsp[-2].minor.yy75),
                                                                *(yymsp[-1].minor.yy277),
                                                                yymsp[0].minor.yy330
                                                            );
                                                    }
                                                    delete yymsp[-4].minor.yy542;
                                                }
                                                else
                                                {
                                                    yygotominor.yy43 = new SqliteDelete(
                                                            yymsp[-5].minor.yy128->name1,
                                                            yymsp[-5].minor.yy128->name2,
                                                            yymsp[-5].minor.yy128->alias,
                                                            false,
                                                            yymsp[-3].minor.yy339,
                                                            yymsp[-8].minor.yy91,
                                                            *(yymsp[-2].minor.yy75),
                                                            *(yymsp[-1].minor.yy277),
                                                            yymsp[0].minor.yy330
                                                        );
                                                }
                                                delete yymsp[-5].minor.yy128;
                                                delete yymsp[-2].minor.yy75;
                                                delete yymsp[-1].minor.yy277;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 242: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 243: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 244: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 255: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==255);
{  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 245: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 256: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==256);
{  yy_destructor(yypParser,250,&yymsp[-3].minor);
}
        break;
      case 248: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy339 = new SqliteExpr();
                                            }
        break;
      case 250: /* returning ::= RETURNING selcollist */
{yygotominor.yy75 = yymsp[0].minor.yy75;}
        break;
      case 252: /* update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt */
{
                                                yygotominor.yy43 = new SqliteUpdate(
                                                        *(yymsp[-9].minor.yy134),
                                                        yymsp[-8].minor.yy128->name1,
                                                        yymsp[-8].minor.yy128->name2,
                                                        yymsp[-8].minor.yy128->alias,
                                                        yymsp[-7].minor.yy542 ? yymsp[-7].minor.yy542->notIndexedKw : false,
                                                        yymsp[-7].minor.yy542 ? yymsp[-7].minor.yy542->indexedBy : QString(),
                                                        *(yymsp[-5].minor.yy387),
                                                        yymsp[-4].minor.yy567,
                                                        yymsp[-3].minor.yy339,
                                                        yymsp[-11].minor.yy91,
                                                        *(yymsp[-2].minor.yy75),
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-9].minor.yy134;
                                                delete yymsp[-8].minor.yy128;
                                                delete yymsp[-5].minor.yy387;
                                                delete yymsp[-2].minor.yy75;
                                                delete yymsp[-1].minor.yy277;
                                                if (yymsp[-7].minor.yy542)
                                                    delete yymsp[-7].minor.yy542;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 253: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[0].minor.yy134;
                                            }
        break;
      case 254: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-2].minor.yy134;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 257: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy387->append(ParserSetValue(*(yymsp[-2].minor.yy267), yymsp[0].minor.yy339));
                                                yygotominor.yy387 = yymsp[-4].minor.yy387;
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 258: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy387->append(ParserSetValue(*(yymsp[-3].minor.yy327), yymsp[0].minor.yy339));
                                                yygotominor.yy387 = yymsp[-6].minor.yy387;
                                                delete yymsp[-3].minor.yy327;
                                            }
        break;
      case 259: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy387 = new ParserSetValueList();
                                                yygotominor.yy387->append(ParserSetValue(*(yymsp[-2].minor.yy267), yymsp[0].minor.yy339));
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 260: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy387 = new ParserSetValueList();
                                                yygotominor.yy387->append(ParserSetValue(*(yymsp[-3].minor.yy327), yymsp[0].minor.yy339));
                                                delete yymsp[-3].minor.yy327;
                                            }
        break;
      case 261: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy387 = new ParserSetValueList();
                                            }
        break;
      case 262: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy387 = yymsp[-1].minor.yy387;
                                            }
        break;
      case 263: /* setlist ::= setlist COMMA ID_COL */
      case 264: /* setlist ::= ID_COL */ yytestcase(yyruleno==264);
{  yy_destructor(yypParser,283,&yymsp[-2].minor);
}
        break;
      case 265: /* idlist_opt ::= */
{yygotominor.yy327 = new QStringList();}
        break;
      case 266: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy327 = yymsp[-1].minor.yy327;}
        break;
      case 267: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy327 = yymsp[-2].minor.yy327;
                                                *(yygotominor.yy327) << *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 268: /* idlist ::= nm */
{
                                                yygotominor.yy327 = new QStringList();
                                                *(yygotominor.yy327) << *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 269: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy327 = new QStringList();
                                            }
        break;
      case 270: /* idlist ::= idlist COMMA ID_COL */
      case 271: /* idlist ::= ID_COL */ yytestcase(yyruleno==271);
{  yy_destructor(yypParser,275,&yymsp[-2].minor);
}
        break;
      case 273: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning */
{
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-6].minor.yy284->replace,
                                                        yymsp[-6].minor.yy284->orConflict,
                                                        yymsp[-4].minor.yy128->name1,
                                                        yymsp[-4].minor.yy128->name2,
                                                        yymsp[-4].minor.yy128->alias,
                                                        *(yymsp[-3].minor.yy327),
                                                        yymsp[-2].minor.yy379,
                                                        yymsp[-7].minor.yy91,
                                                        yymsp[-1].minor.yy34,
                                                        *(yymsp[0].minor.yy75)
                                                    );
                                                delete yymsp[-4].minor.yy128;
                                                delete yymsp[-6].minor.yy284;
                                                delete yymsp[-3].minor.yy327;
                                                delete yymsp[0].minor.yy75;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 274: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning */
{
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-6].minor.yy284->replace,
                                                        yymsp[-6].minor.yy284->orConflict,
                                                        yymsp[-4].minor.yy128->name1,
                                                        yymsp[-4].minor.yy128->name2,
                                                        yymsp[-4].minor.yy128->alias,
                                                        *(yymsp[-3].minor.yy327),
                                                        yymsp[-7].minor.yy91,
                                                        *(yymsp[0].minor.yy75)
                                                    );
                                                delete yymsp[-4].minor.yy128;
                                                delete yymsp[-6].minor.yy284;
                                                delete yymsp[-3].minor.yy327;
                                                delete yymsp[0].minor.yy75;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 275: /* insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-5].minor.yy284->replace,
                                                        yymsp[-5].minor.yy284->orConflict,
                                                        yymsp[-3].minor.yy128->name1,
                                                        yymsp[-3].minor.yy128->name2,
                                                        yymsp[-3].minor.yy128->alias,
                                                        *(yymsp[-1].minor.yy327),
                                                        yymsp[-6].minor.yy91,
                                                        QList<SqliteResultColumn*>()
                                                    );
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-3].minor.yy128;
                                                delete yymsp[-1].minor.yy327;
                                                delete yymsp[-5].minor.yy284;
                                                delete yymsp[0].minor.yy473;
                                            }
        break;
      case 276: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy284->replace;
                                                q->onConflict = yymsp[-1].minor.yy284->orConflict;
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-1].minor.yy284;
                                            }
        break;
      case 277: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy284->replace;
                                                q->onConflict = yymsp[-3].minor.yy284->orConflict;
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-3].minor.yy284;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 278: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,250,&yymsp[-3].minor);
  yy_destructor(yypParser,286,&yymsp[-2].minor);
}
        break;
      case 279: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,286,&yymsp[-4].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 280: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy284 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                            }
        break;
      case 281: /* insert_cmd ::= REPLACE */
{yygotominor.yy284 = new ParserStubInsertOrReplace(true);}
        break;
      case 282: /* upsert ::= */
{
                                                yygotominor.yy34 = nullptr;
                                            }
        break;
      case 283: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy34 = new SqliteUpsert(*(yymsp[-7].minor.yy277), yymsp[-5].minor.yy339, *(yymsp[-1].minor.yy387), yymsp[0].minor.yy339);
                                                delete yymsp[-7].minor.yy277;
                                                delete yymsp[-1].minor.yy387;
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 284: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy34 = new SqliteUpsert(*(yymsp[-4].minor.yy277), yymsp[-2].minor.yy339);
                                                delete yymsp[-4].minor.yy277;
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 285: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy34 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 286: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,228,&yymsp[-3].minor);
}
        break;
      case 287: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 288: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==288);
{  yy_destructor(yypParser,228,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 289: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,236,&yymsp[-2].minor);
}
        break;
      case 290: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,236,&yymsp[-4].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 291: /* exprx ::= expr COLLATE ID_COLLATE */
      case 292: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==292);
{  yy_destructor(yypParser,228,&yymsp[-2].minor);
}
        break;
      case 293: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 294: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRowValue(*(yymsp[-1].minor.yy498));
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 295: /* exprx ::= tnm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[0].minor.yy622->isLiteral())
                                                    yygotominor.yy339->initLiteral(yymsp[0].minor.yy622->toLiteral());
                                                else
                                                    yygotominor.yy339->initId(yymsp[0].minor.yy622->toName());
                                                    //parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy622;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 296: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[-2].minor.yy622->isName())
                                                    yygotominor.yy339->initId(yymsp[-2].minor.yy622->toName(), *(yymsp[0].minor.yy267));
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy622;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 297: /* exprx ::= tnm DOT */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                if (yymsp[-1].minor.yy622->isName())
                                                {
                                                    yygotominor.yy339->initId(yymsp[-1].minor.yy622->toName(), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-1].minor.yy622;
                                            }
        break;
      case 298: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy339 = new SqliteExpr();
												if (yymsp[-4].minor.yy622->isName())
													yygotominor.yy339->initId(yymsp[-4].minor.yy622->toName(), *(yymsp[-2].minor.yy267), *(yymsp[0].minor.yy267));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy622;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 299: /* exprx ::= tnm DOT nm DOT */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                if (yymsp[-3].minor.yy622->isName())
                                                {
                                                    yygotominor.yy339->initId(yymsp[-3].minor.yy622->toName(), *(yymsp[-1].minor.yy267), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-3].minor.yy622;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 300: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 301: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCollate(yymsp[-2].minor.yy339, *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 302: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCast(yymsp[-3].minor.yy339, yymsp[-1].minor.yy29);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 303: /* exprx ::= id LP distinct exprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-4].minor.yy267)), *(yymsp[-2].minor.yy348), *(yymsp[-1].minor.yy498));
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy348;
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 304: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-7].minor.yy267)), *(yymsp[-5].minor.yy348), *(yymsp[-4].minor.yy498), *(yymsp[-1].minor.yy277));
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-5].minor.yy348;
                                                delete yymsp[-4].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 305: /* exprx ::= id LP STAR RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-3].minor.yy267)), true);
                                                delete yymsp[-3].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 306: /* exprx ::= expr AND expr */
      case 307: /* exprx ::= expr OR expr */ yytestcase(yyruleno==307);
      case 308: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==308);
      case 309: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==309);
      case 310: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==310);
      case 311: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==311);
      case 312: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==312);
      case 313: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==313);
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBinOp(yymsp[-2].minor.yy339, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 314: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initLike(yymsp[-3].minor.yy339, *(yymsp[-2].minor.yy473), *(yymsp[-1].minor.yy436), yymsp[0].minor.yy339);
                                                delete yymsp[-2].minor.yy473;
                                                delete yymsp[-1].minor.yy436;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 315: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initLike(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), *(yymsp[-3].minor.yy436), yymsp[-2].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy436;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 316: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initNull(yymsp[-1].minor.yy339, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 317: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initNull(yymsp[-2].minor.yy339, "NOT NULL");
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 318: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIs(yymsp[-3].minor.yy339, *(yymsp[-1].minor.yy473), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 319: /* exprx ::= expr IS NOT DISTINCT FROM expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initDistinct(yymsp[-5].minor.yy339, true, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 320: /* exprx ::= expr IS DISTINCT FROM expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initDistinct(yymsp[-4].minor.yy339, false, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 321: /* exprx ::= NOT expr */
      case 322: /* exprx ::= BITNOT expr */ yytestcase(yyruleno==322);
      case 324: /* exprx ::= PLUS expr */ yytestcase(yyruleno==324);
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initUnaryOp(yymsp[0].minor.yy339, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 323: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[0].minor.yy339->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy339->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy339->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy339;
                                                }
                                                else
                                                {
                                                    yygotominor.yy339->initUnaryOp(yymsp[0].minor.yy339, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 325: /* exprx ::= expr PTR expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initPtrOp(yymsp[-2].minor.yy339, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 326: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBetween(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), yymsp[-2].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 327: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), *(yymsp[-1].minor.yy498));
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 328: /* exprx ::= LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initSubSelect(yymsp[-1].minor.yy379);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 329: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), yymsp[-1].minor.yy379);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 330: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-4].minor.yy339, *(yymsp[-3].minor.yy473), *(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-3].minor.yy473;
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 331: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initExists(yymsp[-1].minor.yy379);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 332: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCase(yymsp[-3].minor.yy339, *(yymsp[-2].minor.yy498), yymsp[-1].minor.yy339);
                                                delete yymsp[-2].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 333: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 334: /* exprx ::= RAISE LP raisetype COMMA expr RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRaise(yymsp[-3].minor.yy0->value, yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 335: /* exprx ::= id LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-5].minor.yy267)), *(yymsp[-3].minor.yy348), *(yymsp[-2].minor.yy498), yymsp[0].minor.yy405);
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy348;
                                                delete yymsp[-2].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 336: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-8].minor.yy267)), *(yymsp[-6].minor.yy348), *(yymsp[-5].minor.yy498), *(yymsp[-2].minor.yy277), yymsp[0].minor.yy405);
                                                delete yymsp[-8].minor.yy267;
                                                delete yymsp[-6].minor.yy348;
                                                delete yymsp[-5].minor.yy498;
                                                delete yymsp[-2].minor.yy277;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 337: /* exprx ::= id LP STAR RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-4].minor.yy267)), yymsp[0].minor.yy405);
                                                delete yymsp[-4].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 338: /* exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initOrderedSetAggregate(stripObjName(*(yymsp[-11].minor.yy267)), *(yymsp[-9].minor.yy348), *(yymsp[-8].minor.yy498), yymsp[-1].minor.yy339);
                                                delete yymsp[-11].minor.yy267;
                                                delete yymsp[-9].minor.yy348;
                                                delete yymsp[-8].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 339: /* expr ::= */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 345: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy436 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 346: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy498->append(yymsp[-2].minor.yy339);
                                                yymsp[-4].minor.yy498->append(yymsp[0].minor.yy339);
                                                yygotominor.yy498 = yymsp[-4].minor.yy498;
                                            }
        break;
      case 347: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy498 = new ParserExprList();
                                                yygotominor.yy498->append(yymsp[-2].minor.yy339);
                                                yygotominor.yy498->append(yymsp[0].minor.yy339);
                                            }
        break;
      case 354: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy498->append(yymsp[0].minor.yy339);
                                                yygotominor.yy498 = yymsp[-2].minor.yy498;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 355: /* nexprlist ::= exprx */
{
                                                yygotominor.yy498 = new ParserExprList();
                                                yygotominor.yy498->append(yymsp[0].minor.yy339);
                                            }
        break;
      case 356: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy43 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy473),
                                                        *(yymsp[-8].minor.yy473),
                                                        *(yymsp[-7].minor.yy267),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-4].minor.yy267),
                                                        *(yymsp[-2].minor.yy277),
                                                        yymsp[0].minor.yy339
                                                    );
                                                delete yymsp[-8].minor.yy473;
                                                delete yymsp[-10].minor.yy473;
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-6].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy277;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 357: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,204,&yymsp[-3].minor);
}
        break;
      case 362: /* idxlist_opt ::= */
{yygotominor.yy121 = new ParserIndexedColumnList();}
        break;
      case 363: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy121 = yymsp[-1].minor.yy121;}
        break;
      case 364: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy121->append(yymsp[0].minor.yy166);
                                                yygotominor.yy121 = yymsp[-2].minor.yy121;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 365: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy121 = new ParserIndexedColumnList();
                                                yygotominor.yy121->append(yymsp[0].minor.yy166);
                                            }
        break;
      case 366: /* idxlist_single ::= nm collate sortorder */
      case 367: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==367);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[-1].minor.yy267),
                                                        *(yymsp[0].minor.yy25)
                                                    );
                                                yygotominor.yy166 = obj;
                                                delete yymsp[0].minor.yy25;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy166;
                                            }
        break;
      case 371: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropIndex(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 374: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy43 = new SqliteVacuum(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 375: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy43 = new SqliteVacuum(*(yymsp[-1].minor.yy267), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 378: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 379: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 381: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==381);
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-3].minor.yy267), *(yymsp[-2].minor.yy267), *(yymsp[0].minor.yy15), true);
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 380: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 382: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==382);
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-4].minor.yy267), *(yymsp[-3].minor.yy267), *(yymsp[-1].minor.yy15), false);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 386: /* nmnum ::= nm */
{
                                                yygotominor.yy15 = new QVariant(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 387: /* nmnum ::= ON */
      case 388: /* nmnum ::= DELETE */ yytestcase(yyruleno==388);
      case 389: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==389);
{yygotominor.yy15 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 392: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy15->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy15) = -(yymsp[0].minor.yy15->toDouble());
                                                else if (yymsp[0].minor.yy15->type() == QVariant::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy15) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy15) = -(yymsp[0].minor.yy15->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy15 = yymsp[0].minor.yy15;
                                            }
        break;
      case 395: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy43 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy348),
                                                        *(yymsp[-11].minor.yy473),
                                                        *(yymsp[-10].minor.yy267),
                                                        *(yymsp[-9].minor.yy267),
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-8].minor.yy568),
                                                        yymsp[-7].minor.yy469,
                                                        *(yymsp[-4].minor.yy247),
                                                        yymsp[-3].minor.yy339,
                                                        *(yymsp[-1].minor.yy412),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy473;
                                                delete yymsp[-13].minor.yy348;
                                                delete yymsp[-8].minor.yy568;
                                                delete yymsp[-4].minor.yy247;
                                                delete yymsp[-10].minor.yy267;
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-9].minor.yy267;
                                                delete yymsp[-1].minor.yy412;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 396: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy43 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy348),
                                                        *(yymsp[-8].minor.yy473),
                                                        *(yymsp[-7].minor.yy267),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[-5].minor.yy568),
                                                        yymsp[-4].minor.yy469,
                                                        *(yymsp[-1].minor.yy247),
                                                        yymsp[0].minor.yy339,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy473;
                                                delete yymsp[-10].minor.yy348;
                                                delete yymsp[-5].minor.yy568;
                                                delete yymsp[-1].minor.yy247;
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-6].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 397: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy43 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy348),
													*(yymsp[-10].minor.yy473),
													*(yymsp[-9].minor.yy267),
													*(yymsp[-8].minor.yy267),
													*(yymsp[-4].minor.yy267),
													*(yymsp[-7].minor.yy568),
													yymsp[-6].minor.yy469,
													*(yymsp[-3].minor.yy247),
													yymsp[-2].minor.yy339,
													*(yymsp[0].minor.yy412),
													3
                                                );
                                                delete yymsp[-10].minor.yy473;
                                                delete yymsp[-12].minor.yy348;
                                                delete yymsp[-7].minor.yy568;
                                                delete yymsp[-3].minor.yy247;
                                                delete yymsp[-9].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-8].minor.yy267;
                                                delete yymsp[0].minor.yy412;
                                                objectForTokens = yygotominor.yy43;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 398: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,206,&yymsp[-8].minor);
  yy_destructor(yypParser,204,&yymsp[-5].minor);
  yy_destructor(yypParser,302,&yymsp[-3].minor);
  yy_destructor(yypParser,303,&yymsp[-2].minor);
}
        break;
      case 401: /* trigger_time ::= BEFORE */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 402: /* trigger_time ::= AFTER */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 403: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 404: /* trigger_time ::= */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 405: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 406: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 407: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 408: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy327));
                                                delete yymsp[0].minor.yy327;
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 409: /* foreach_clause ::= */
{yygotominor.yy247 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 410: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy247 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 413: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy412->append(yymsp[-1].minor.yy43);
                                                yygotominor.yy412 = yymsp[-2].minor.yy412;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 414: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy412 = new ParserQueryList();
                                                yygotominor.yy412->append(yymsp[-1].minor.yy43);
                                            }
        break;
      case 415: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy412 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 420: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 421: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropTrigger(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 424: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy43 = new SqliteAttach(*(yymsp[-4].minor.yy473), yymsp[-3].minor.yy339, yymsp[-1].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 425: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy43 = new SqliteDetach(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy473;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 430: /* cmd ::= REINDEX */
{yygotominor.yy43 = new SqliteReindex();}
        break;
      case 431: /* cmd ::= REINDEX nm dbnm */
      case 432: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==432);
{
                                                yygotominor.yy43 = new SqliteReindex(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 435: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy43 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 436: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy43 = new SqliteAnalyze(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 439: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[0].minor.yy267;
                                                delete yymsp[-3].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 440: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[-1].minor.yy473),
                                                        yymsp[0].minor.yy215
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 441: /* cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[-1].minor.yy473),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 442: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO nm */
{
                                               yygotominor.yy43 = new SqliteAlterTable(
                                                       yymsp[-5].minor.yy136->name1,
                                                       yymsp[-5].minor.yy136->name2,
                                                       *(yymsp[-3].minor.yy473),
                                                       *(yymsp[-2].minor.yy267),
                                                       *(yymsp[0].minor.yy267)
                                                   );
                                               delete yymsp[-3].minor.yy473;
                                               delete yymsp[-5].minor.yy136;
                                               delete yymsp[-2].minor.yy267;
                                               delete yymsp[0].minor.yy267;
                                               objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 443: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
      case 444: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt ID_COL */ yytestcase(yyruleno==444);
{  yy_destructor(yypParser,208,&yymsp[-3].minor);
}
        break;
      case 445: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-2].minor.yy136->name1,
                                                        yymsp[-2].minor.yy136->name2,
                                                        *(yymsp[0].minor.yy473),
                                                        QString(),
                                                        QString()
                                                    );
                                                delete yymsp[0].minor.yy473;
                                                delete yymsp[-2].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 446: /* cmd ::= ALTER TABLE fullname RENAME kwcolumn_opt nm TO ID_COL_NEW */
{  yy_destructor(yypParser,208,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 452: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy43 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy473),
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 453: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy43 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy473),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-1].minor.yy327)
                                                    );
                                                delete yymsp[-6].minor.yy267;
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-7].minor.yy473;
                                                delete yymsp[-1].minor.yy327;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 456: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy327 = new QStringList();
                                                yygotominor.yy327->append((yymsp[0].minor.yy267)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 457: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy327->append((yymsp[0].minor.yy267)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy327 = yymsp[-2].minor.yy327;
                                                delete yymsp[0].minor.yy267;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 459: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy267->append(" "+ *(yymsp[0].minor.yy267));
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 460: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy267 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 461: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy267 = new QString("(");
                                                yygotominor.yy267->append(*(yymsp[-1].minor.yy267));
                                                yygotominor.yy267->append(")");
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 463: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy267 = yymsp[-3].minor.yy267;
                                                yygotominor.yy267->append("(");
                                                yygotominor.yy267->append(*(yymsp[-1].minor.yy267));
                                                yygotominor.yy267->append(")");
                                                delete yymsp[-1].minor.yy267;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 464: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                                yygotominor.yy267->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 465: /* with ::= */
{yygotominor.yy91 = nullptr;}
        break;
      case 466: /* with ::= WITH wqlist */
{
                                                yygotominor.yy91 = new SqliteWith(*(yymsp[0].minor.yy114));
                                                delete yymsp[0].minor.yy114;
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 467: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy91 = new SqliteWith(*(yymsp[0].minor.yy114));
                                                yygotominor.yy91->recursive = true;
                                                delete yymsp[0].minor.yy114;
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 468: /* wqas ::= AS */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::ANY);}
        break;
      case 469: /* wqas ::= AS MATERIALIZED */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::MATERIALIZED);}
        break;
      case 470: /* wqas ::= AS NOT MATERIALIZED */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::NOT_MATERIALIZED);}
        break;
      case 471: /* wqlist ::= wqcte */
{
                                                yygotominor.yy114 = new ParserCteList();
                                                yygotominor.yy114->append(yymsp[0].minor.yy404);
                                            }
        break;
      case 472: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy114 = yymsp[-2].minor.yy114;
                                                yygotominor.yy114->append(yymsp[0].minor.yy404);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 473: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 474: /* wqcte ::= nm idxlist_opt wqas LP select RP */
{
                                                yygotominor.yy404 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy267), *(yymsp[-4].minor.yy121), yymsp[-1].minor.yy379, *(yymsp[-3].minor.yy109));
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-4].minor.yy121;
                                                delete yymsp[-3].minor.yy109;
                                                objectForTokens = yygotominor.yy404;
                                            }
        break;
      case 475: /* windowdefn_list ::= windowdefn */
{
                                                    yygotominor.yy369 = new ParserWindowDefList();
                                                    yygotominor.yy369->append(yymsp[0].minor.yy219);
                                                }
        break;
      case 476: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy369->append(yymsp[0].minor.yy219);
												yygotominor.yy369 = yymsp[-2].minor.yy369;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 477: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy219 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy267), yymsp[-1].minor.yy518);
												delete yymsp[-4].minor.yy267;
												objectForTokens = yygotominor.yy219;
											}
        break;
      case 478: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initPartitionBy(QString(), *(yymsp[-2].minor.yy498), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-2].minor.yy498;
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 479: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initPartitionBy(*(yymsp[-5].minor.yy267), *(yymsp[-2].minor.yy498), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-2].minor.yy498;
												delete yymsp[-5].minor.yy267;
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 480: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initOrderBy(QString(), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 481: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initOrderBy(*(yymsp[-4].minor.yy267), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy277;
												delete yymsp[-4].minor.yy267;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 482: /* window ::= frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->init(QString(), yymsp[0].minor.yy463);
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 483: /* window ::= nm frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->init(QString(), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy267;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 484: /* frame_opt ::= */
{yygotominor.yy463 = nullptr;}
        break;
      case 485: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy463 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy122), yymsp[-1].minor.yy453, nullptr, *(yymsp[0].minor.yy366));
												delete yymsp[-2].minor.yy122;
												delete yymsp[0].minor.yy366;
												objectForTokens = yygotominor.yy463;
											}
        break;
      case 486: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy463 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy122), yymsp[-3].minor.yy453, yymsp[-1].minor.yy453, *(yymsp[0].minor.yy366));
												delete yymsp[-5].minor.yy122;
												delete yymsp[0].minor.yy366;
												objectForTokens = yygotominor.yy463;
											}
        break;
      case 487: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy122 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 488: /* frame_bound_s ::= frame_bound */
      case 490: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==490);
{
												yygotominor.yy453 = yymsp[0].minor.yy453;
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 489: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 491: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==491);
      case 493: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==493);
{
												yygotominor.yy453 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 492: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy453 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy339, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 494: /* frame_exclude_opt ::= */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 495: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy366 = yymsp[0].minor.yy366;
											}
        break;
      case 496: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 497: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 498: /* frame_exclude ::= GROUP */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 499: /* frame_exclude ::= TIES */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 500: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy369 = yymsp[0].minor.yy369;
											}
        break;
      case 501: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(yymsp[-1].minor.yy37, yymsp[0].minor.yy437);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 502: /* filter_over ::= over_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy437);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 503: /* filter_over ::= filter_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(yymsp[0].minor.yy37, nullptr);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 504: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy437 = new SqliteFilterOver::Over(yymsp[-1].minor.yy518);
												objectForTokens = yygotominor.yy437;
											}
        break;
      case 505: /* over_clause ::= OVER nm */
{
												yygotominor.yy437 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy267));
												delete yymsp[0].minor.yy267;
												objectForTokens = yygotominor.yy437;
											}
        break;
      case 506: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy37 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy339);
												objectForTokens = yygotominor.yy37;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens && yypParser->yyidx >= 0)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

int sqlite3ParserFallback(int iToken) {
    return yyFallback[iToken];
}
