// This file implements the IPropertyStore Interface and Gateway for Python.
// Generated by makegw.py

#include "PyIPropertyStore.h"
#include "PyPROPVARIANT.h"
// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIPropertyStore::PyIPropertyStore(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIPropertyStore::~PyIPropertyStore() {}

/* static */ IPropertyStore *PyIPropertyStore::GetI(PyObject *self) { return (IPropertyStore *)PyIUnknown::GetI(self); }

// @pymethod int|PyIPropertyStore|GetCount|Returns the number of properties in the store
PyObject *PyIPropertyStore::GetCount(PyObject *self, PyObject *args)
{
    IPropertyStore *pIPS = GetI(self);
    if (pIPS == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":GetCount"))
        return NULL;
    DWORD cProps;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPS->GetCount(&cProps);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPS, IID_IPropertyStore);
    return PyLong_FromLong(cProps);
}

// @pymethod <o PyPROPERTYKEY>|PyIPropertyStore|GetAt|Returns the property key for the specified property
PyObject *PyIPropertyStore::GetAt(PyObject *self, PyObject *args)
{
    IPropertyStore *pIPS = GetI(self);
    if (pIPS == NULL)
        return NULL;
    // @pyparm int|iProp||Zero-based index of property
    PROPERTYKEY key;
    DWORD iProp;
    if (!PyArg_ParseTuple(args, "k:GetAt", &iProp))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPS->GetAt(iProp, &key);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPS, IID_IPropertyStore);
    return PyWinObject_FromPROPERTYKEY(key);
}

// @pymethod <o PyPROPVARIANT>|PyIPropertyStore|GetValue|Retrieves the value of a property
PyObject *PyIPropertyStore::GetValue(PyObject *self, PyObject *args)
{
    IPropertyStore *pIPS = GetI(self);
    if (pIPS == NULL)
        return NULL;
    PROPERTYKEY key;
    PROPVARIANT val;
    // @pyparm <o PyPROPERTYKEY>|Key||Property key as returned by <om PyIPropertyStore.GetAt>
    if (!PyArg_ParseTuple(args, "O&:GetValue", PyWinObject_AsPROPERTYKEY, &key))
        return NULL;
    PropVariantInit(&val);
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPS->GetValue(key, &val);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPS, IID_IPropertyStore);
    return PyWinObject_FromPROPVARIANT(&val);
}

// @pymethod |PyIPropertyStore|SetValue|Sets the value of a property
PyObject *PyIPropertyStore::SetValue(PyObject *self, PyObject *args)
{
    IPropertyStore *pIPS = GetI(self);
    if (pIPS == NULL)
        return NULL;

    PROPERTYKEY key;
    PROPVARIANT *val;
    // @pyparm <o PyPROPERTYKEY>|Key||Property key (see <om PyIPropertyStore.GetAt>)
    // @pyparm <o PyPROPVARIANT>|Value||Variant value which can be converted to the appropriate variant type for the
    // property Pass a VT_EMPTY variant to indicate that the property should be removed.
    if (!PyArg_ParseTuple(args, "O&O&:SetValue", PyWinObject_AsPROPERTYKEY, &key, PyWinObject_AsPROPVARIANT, &val))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPS->SetValue(key, *val);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPS, IID_IPropertyStore);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIPropertyStore|Commit|Commits property changes
PyObject *PyIPropertyStore::Commit(PyObject *self, PyObject *args)
{
    IPropertyStore *pIPS = GetI(self);
    if (pIPS == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":Commit"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIPS->Commit();

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIPS, IID_IPropertyStore);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIPropertyStore|Contains a collection of properties
static struct PyMethodDef PyIPropertyStore_methods[] = {
    {"GetCount", PyIPropertyStore::GetCount, 1},  // @pymeth GetCount|Returns the number of properties in the store
    {"GetAt", PyIPropertyStore::GetAt, 1},        // @pymeth GetAt|Returns the property key for the specified property
    {"GetValue", PyIPropertyStore::GetValue, 1},  // @pymeth GetValue|Retrieves the value of a property
    {"SetValue", PyIPropertyStore::SetValue, 1},  // @pymeth SetValue|Sets the value of a property
    {"Commit", PyIPropertyStore::Commit, 1},      // @pymeth Commit|Commits property changes
    {NULL}};

PyComTypeObject PyIPropertyStore::type("PyIPropertyStore", &PyIUnknown::type, sizeof(PyIPropertyStore),
                                       PyIPropertyStore_methods, GET_PYCOM_CTOR(PyIPropertyStore));

// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGPropertyStore::GetCount(DWORD *cProps)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetCount", &result);
    if (FAILED(hr))
        return hr;
    *cProps = PyLong_AsUnsignedLong(result);
    if (*cProps == (DWORD)-1 && PyErr_Occurred())
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetCount");
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGPropertyStore::GetAt(DWORD iProp, PROPERTYKEY *pkey)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetAt", &result, "k", iProp);
    if (FAILED(hr))
        return hr;
    if (!PyWinObject_AsPROPERTYKEY(result, pkey))
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetAt");
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGPropertyStore::GetValue(REFPROPERTYKEY key, PROPVARIANT *pv)
{
    PY_GATEWAY_METHOD;
    PyObject *obkey = PyWinObject_FromPROPERTYKEY(key);
    if (obkey == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetValue");
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetValue", &result, "(O)", obkey);
    Py_DECREF(obkey);
    if (FAILED(hr))
        return hr;

    PROPVARIANT *pypv;
    if (!PyWinObject_AsPROPVARIANT(result, &pypv))
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetValue");
    else
        hr = PropVariantCopy(pv, pypv);
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGPropertyStore::SetValue(REFPROPERTYKEY key, REFPROPVARIANT propvar)
{
    PY_GATEWAY_METHOD;
    PyObject *obkey = PyWinObject_FromPROPERTYKEY(key);
    if (obkey == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("SetValue");
    PyObject *obpropvar = PyWinObject_FromPROPVARIANT(propvar);
    if (obpropvar == NULL) {
        Py_DECREF(obkey);
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("SetValue");
    }
    HRESULT hr = InvokeViaPolicy("SetValue", NULL, "OO", obkey, obpropvar);
    Py_DECREF(obkey);
    Py_DECREF(obpropvar);
    return hr;
}

STDMETHODIMP PyGPropertyStore::Commit(void)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("Commit", NULL);
    return hr;
}
