fn main() -> Result<(), Box<dyn std::error::Error>> {
    // --8<-- [start:write]
    let mut df = df!(
        "foo" => &[1, 2, 3],
        "bar" => &[None, Some("bak"), Some("baz")],
    )
    .unwrap();

    let mut file = std::fs::File::create("docs/assets/data/path.json").unwrap();

    // json
    JsonWriter::new(&mut file)
        .with_json_format(JsonFormat::Json)
        .finish(&mut df)
        .unwrap();

    // ndjson
    JsonWriter::new(&mut file)
        .with_json_format(JsonFormat::JsonLines)
        .finish(&mut df)
        .unwrap();
    // --8<-- [end:write]

    // --8<-- [start:read]
    use polars::prelude::*;

    let mut file = std::fs::File::open("docs/assets/data/path.json").unwrap();
    let df = JsonReader::new(&mut file).finish()?;
    // --8<-- [end:read]
    println!("{df}");

    // --8<-- [start:readnd]
    let df = LazyJsonLineReader::new(PlRefPath::new("docs/assets/data/path.json"))
        .finish()
        .unwrap()
        .collect()
        .unwrap();
    // --8<-- [end:readnd]
    println!("{}", df);

    // --8<-- [start:scan]
    let lf = LazyJsonLineReader::new(PlRefPath::new("docs/assets/data/path.json"))
        .finish()
        .unwrap();
    // --8<-- [end:scan]
    println!("{}", lf.collect()?);

    Ok(())
}
