import React from "react";
import PropTypes from "prop-types";

function selectValue(value, selected, all) {
  var at = all.indexOf(value);
  var updated = selected.slice(0, at).concat(value, selected.slice(at)); // As inserting values at predefined index positions doesn't work with empty
  // arrays, we need to reorder the updated selection to match the initial order

  return updated.sort(function (a, b) {
    return all.indexOf(a) > all.indexOf(b);
  });
}

function deselectValue(value, selected) {
  return selected.filter(function (v) {
    return v !== value;
  });
}

function CheckboxesWidget(props) {
  var id = props.id,
      disabled = props.disabled,
      options = props.options,
      value = props.value,
      autofocus = props.autofocus,
      readonly = props.readonly,
      _onChange = props.onChange;
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled,
      inline = options.inline;
  return React.createElement("div", {
    className: "checkboxes",
    id: id
  }, enumOptions.map(function (option, index) {
    var checked = value.indexOf(option.value) !== -1;
    var itemDisabled = enumDisabled && enumDisabled.indexOf(option.value) != -1;
    var disabledCls = disabled || itemDisabled || readonly ? "disabled" : "";
    var checkbox = React.createElement("span", null, React.createElement("input", {
      type: "checkbox",
      id: "".concat(id, "_").concat(index),
      checked: checked,
      disabled: disabled || itemDisabled || readonly,
      autoFocus: autofocus && index === 0,
      onChange: function onChange(event) {
        var all = enumOptions.map(function (_ref) {
          var value = _ref.value;
          return value;
        });

        if (event.target.checked) {
          _onChange(selectValue(option.value, value, all));
        } else {
          _onChange(deselectValue(option.value, value));
        }
      }
    }), React.createElement("span", null, option.label));
    return inline ? React.createElement("label", {
      key: index,
      className: "checkbox-inline ".concat(disabledCls)
    }, checkbox) : React.createElement("div", {
      key: index,
      className: "checkbox ".concat(disabledCls)
    }, React.createElement("label", null, checkbox));
  }));
}

CheckboxesWidget.defaultProps = {
  autofocus: false,
  options: {
    inline: false
  }
};

if (process.env.NODE_ENV !== "production") {
  CheckboxesWidget.propTypes = {
    schema: PropTypes.object.isRequired,
    id: PropTypes.string.isRequired,
    options: PropTypes.shape({
      enumOptions: PropTypes.array,
      inline: PropTypes.bool
    }).isRequired,
    value: PropTypes.any,
    required: PropTypes.bool,
    readonly: PropTypes.bool,
    disabled: PropTypes.bool,
    multiple: PropTypes.bool,
    autofocus: PropTypes.bool,
    onChange: PropTypes.func
  };
}

export default CheckboxesWidget;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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