import React from "react";
import PropTypes from "prop-types";
var REQUIRED_FIELD_SYMBOL = "*";

function TitleField(props) {
  var id = props.id,
      title = props.title,
      required = props.required;
  return React.createElement("legend", {
    id: id
  }, title, required && React.createElement("span", {
    className: "required"
  }, REQUIRED_FIELD_SYMBOL));
}

if (process.env.NODE_ENV !== "production") {
  TitleField.propTypes = {
    id: PropTypes.string,
    title: PropTypes.string,
    required: PropTypes.bool
  };
}

export default TitleField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL2ZpZWxkcy9UaXRsZUZpZWxkLmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiUkVRVUlSRURfRklFTERfU1lNQk9MIiwiVGl0bGVGaWVsZCIsInByb3BzIiwiaWQiLCJ0aXRsZSIsInJlcXVpcmVkIiwicHJvY2VzcyIsImVudiIsIk5PREVfRU5WIiwicHJvcFR5cGVzIiwic3RyaW5nIiwiYm9vbCJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsS0FBUCxNQUFrQixPQUFsQjtBQUNBLE9BQU9DLFNBQVAsTUFBc0IsWUFBdEI7QUFFQSxJQUFNQyxxQkFBcUIsR0FBRyxHQUE5Qjs7QUFFQSxTQUFTQyxVQUFULENBQW9CQyxLQUFwQixFQUEyQjtBQUFBLE1BQ2pCQyxFQURpQixHQUNPRCxLQURQLENBQ2pCQyxFQURpQjtBQUFBLE1BQ2JDLEtBRGEsR0FDT0YsS0FEUCxDQUNiRSxLQURhO0FBQUEsTUFDTkMsUUFETSxHQUNPSCxLQURQLENBQ05HLFFBRE07QUFFekIsU0FDRTtBQUFRLElBQUEsRUFBRSxFQUFFRjtBQUFaLEtBQ0dDLEtBREgsRUFFR0MsUUFBUSxJQUFJO0FBQU0sSUFBQSxTQUFTLEVBQUM7QUFBaEIsS0FBNEJMLHFCQUE1QixDQUZmLENBREY7QUFNRDs7QUFFRCxJQUFJTSxPQUFPLENBQUNDLEdBQVIsQ0FBWUMsUUFBWixLQUF5QixZQUE3QixFQUEyQztBQUN6Q1AsRUFBQUEsVUFBVSxDQUFDUSxTQUFYLEdBQXVCO0FBQ3JCTixJQUFBQSxFQUFFLEVBQUVKLFNBQVMsQ0FBQ1csTUFETztBQUVyQk4sSUFBQUEsS0FBSyxFQUFFTCxTQUFTLENBQUNXLE1BRkk7QUFHckJMLElBQUFBLFFBQVEsRUFBRU4sU0FBUyxDQUFDWTtBQUhDLEdBQXZCO0FBS0Q7O0FBRUQsZUFBZVYsVUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuY29uc3QgUkVRVUlSRURfRklFTERfU1lNQk9MID0gXCIqXCI7XG5cbmZ1bmN0aW9uIFRpdGxlRmllbGQocHJvcHMpIHtcbiAgY29uc3QgeyBpZCwgdGl0bGUsIHJlcXVpcmVkIH0gPSBwcm9wcztcbiAgcmV0dXJuIChcbiAgICA8bGVnZW5kIGlkPXtpZH0+XG4gICAgICB7dGl0bGV9XG4gICAgICB7cmVxdWlyZWQgJiYgPHNwYW4gY2xhc3NOYW1lPVwicmVxdWlyZWRcIj57UkVRVUlSRURfRklFTERfU1lNQk9MfTwvc3Bhbj59XG4gICAgPC9sZWdlbmQ+XG4gICk7XG59XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gXCJwcm9kdWN0aW9uXCIpIHtcbiAgVGl0bGVGaWVsZC5wcm9wVHlwZXMgPSB7XG4gICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgdGl0bGU6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgcmVxdWlyZWQ6IFByb3BUeXBlcy5ib29sLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBUaXRsZUZpZWxkO1xuIl19