# Просунуті типи Python { #advanced-python-types }

Ось кілька додаткових ідей, які можуть бути корисні під час роботи з типами в Python.

## Використання `Union` або `Optional` { #using-union-or-optional }

Якщо ваш код з якоїсь причини не може використовувати `|`, наприклад, якщо це не анотація типів, а щось на кшталт `response_model=`, замість вертикальної риски (`|`) ви можете використати `Union` з `typing`.

Наприклад, ви можете оголосити, що щось може бути `str` або `None`:

```python
from typing import Union


def say_hi(name: Union[str, None]):
        print(f"Hi {name}!")
```

У `typing` також є скорочення, щоб оголосити, що щось може бути `None`, - `Optional`.

Ось порада з моєї дуже «суб'єктивної» точки зору:

- 🚨 Уникайте використання `Optional[SomeType]`
- Натомість ✨ **використовуйте `Union[SomeType, None]`** ✨.

Обидва варіанти еквівалентні і під капотом однакові, але я рекомендую `Union` замість `Optional`, тому що слово «**optional**» ніби натякає, що значення є необов'язковим, а насправді означає «може бути `None`», навіть якщо воно не є необов'язковим і все ще обов'язкове.

Вважаю, `Union[SomeType, None]` більш явно це передає.

Йдеться лише про слова та назви. Але ці слова можуть впливати на те, як ви та ваша команда думаєте про код.

Як приклад, розгляньмо цю функцію:

```python
from typing import Optional


def say_hi(name: Optional[str]):
    print(f"Hey {name}!")
```

Параметр `name` визначено як `Optional[str]`, але він не є необов'язковим, ви не можете викликати функцію без цього параметра:

```Python
say_hi()  # О ні, це викликає помилку! 😱
```

Параметр `name` все ще обов'язковий (не «необов'язковий»), тому що не має значення за замовчуванням. Водночас `name` приймає `None` як значення:

```Python
say_hi(name=None)  # Це працює, None припустимий 🎉
```

Гарна новина: у більшості випадків ви зможете просто використовувати `|`, щоб визначати об'єднання типів:

```python
def say_hi(name: str | None):
    print(f"Hey {name}!")
```

Тож зазвичай вам не доведеться перейматися такими назвами, як `Optional` і `Union`. 😎
