# 현재 사용자 가져오기 { #get-current-user }

이전 장에서 (의존성 주입 시스템을 기반으로 한) 보안 시스템은 *경로 처리 함수*에 `str`로 `token`을 제공했습니다:

{* ../../docs_src/security/tutorial001_an_py39.py hl[12] *}

하지만 이는 여전히 그다지 유용하지 않습니다.

현재 사용자를 제공하도록 해봅시다.

## 사용자 모델 생성하기 { #create-a-user-model }

먼저 Pydantic 사용자 모델을 만들어 봅시다.

Pydantic을 사용해 본문을 선언하는 것과 같은 방식으로, 다른 곳에서도 어디서든 사용할 수 있습니다:

{* ../../docs_src/security/tutorial002_an_py310.py hl[5,12:6] *}

## `get_current_user` 의존성 생성하기 { #create-a-get-current-user-dependency }

의존성 `get_current_user`를 만들어 봅시다.

의존성이 하위 의존성을 가질 수 있다는 것을 기억하시나요?

`get_current_user`는 이전에 생성한 것과 동일한 `oauth2_scheme`에 대한 의존성을 갖게 됩니다.

이전에 *경로 처리*에서 직접 수행했던 것과 동일하게, 새 의존성 `get_current_user`는 하위 의존성 `oauth2_scheme`로부터 `str`로 `token`을 받게 됩니다:

{* ../../docs_src/security/tutorial002_an_py310.py hl[25] *}

## 사용자 가져오기 { #get-the-user }

`get_current_user`는 우리가 만든 (가짜) 유틸리티 함수를 사용합니다. 이 함수는 `str`로 토큰을 받아 Pydantic `User` 모델을 반환합니다:

{* ../../docs_src/security/tutorial002_an_py310.py hl[19:22,26:27] *}

## 현재 사용자 주입하기 { #inject-the-current-user }

이제 *경로 처리*에서 `get_current_user`와 함께 같은 `Depends`를 사용할 수 있습니다:

{* ../../docs_src/security/tutorial002_an_py310.py hl[31] *}

`current_user`의 타입을 Pydantic 모델 `User`로 선언한다는 점에 주목하세요.

이는 함수 내부에서 자동 완성과 타입 체크에 도움을 줍니다.

/// tip | 팁

요청 본문도 Pydantic 모델로 선언된다는 것을 기억하실지도 모릅니다.

여기서 **FastAPI**는 `Depends`를 사용하고 있기 때문에 혼동하지 않습니다.

///

/// check | 확인

이 의존성 시스템이 설계된 방식은 모두 `User` 모델을 반환하는 서로 다른 의존성(서로 다른 "dependables")을 가질 수 있도록 합니다.

해당 타입의 데이터를 반환할 수 있는 의존성이 하나만 있어야 하는 것으로 제한되지 않습니다.

///

## 다른 모델 { #other-models }

이제 *경로 처리 함수*에서 현재 사용자를 직접 가져올 수 있으며, `Depends`를 사용해 **의존성 주입** 수준에서 보안 메커니즘을 처리할 수 있습니다.

그리고 보안 요구 사항을 위해 어떤 모델이나 데이터든 사용할 수 있습니다(이 경우 Pydantic 모델 `User`).

하지만 특정 데이터 모델, 클래스 또는 타입만 사용해야 하는 것은 아닙니다.

모델에 `id`와 `email`이 있고 `username`은 없게 하고 싶으신가요? 물론입니다. 같은 도구를 사용할 수 있습니다.

`str`만 갖고 싶으신가요? 아니면 `dict`만요? 또는 데이터베이스 클래스 모델 인스턴스를 직접 쓰고 싶으신가요? 모두 같은 방식으로 동작합니다.

애플리케이션에 로그인하는 사용자는 없고, 액세스 토큰만 가진 로봇, 봇 또는 다른 시스템만 있나요? 이것도 마찬가지로 모두 동일하게 동작합니다.

애플리케이션에 필요한 어떤 종류의 모델, 어떤 종류의 클래스, 어떤 종류의 데이터베이스든 사용하세요. **FastAPI**는 의존성 주입 시스템으로 이를 지원합니다.

## 코드 크기 { #code-size }

이 예시는 장황해 보일 수 있습니다. 동일한 파일에서 보안, 데이터 모델, 유틸리티 함수 및 *경로 처리*를 섞어서 사용하고 있다는 점을 기억하세요.

하지만 여기 핵심이 있습니다.

보안과 의존성 주입 관련 코드는 한 번만 작성합니다.

그리고 원하는 만큼 복잡하게 만들 수 있습니다. 그럼에도 여전히 한 번만, 한 곳에만 작성하면 됩니다. 유연성을 모두 유지하면서요.

하지만 같은 보안 시스템을 사용해 수천 개의 엔드포인트(*경로 처리*)를 가질 수 있습니다.

그리고 그들 모두(또는 원하는 일부)는 이러한 의존성 또는 여러분이 생성한 다른 의존성을 재사용하는 이점을 얻을 수 있습니다.

그리고 이 수천 개의 *경로 처리*는 3줄 정도로도 만들 수 있습니다:

{* ../../docs_src/security/tutorial002_an_py310.py hl[30:32] *}

## 요약 { #recap }

이제 *경로 처리 함수*에서 현재 사용자를 직접 가져올 수 있습니다.

우리는 이미 절반은 왔습니다.

사용자/클라이언트가 실제로 `username`과 `password`를 보내도록 하는 *경로 처리*만 추가하면 됩니다.

다음에 이어집니다.
