# Моделі Query параметрів

Якщо у Вас є група **query параметрів**, які пов’язані між собою, Ви можете створити **Pydantic-модель** для їх оголошення.

Це дозволить Вам **повторно використовувати модель** у **різних місцях**, а також оголошувати перевірки та метадані для всіх параметрів одночасно. 😎

/// note | Примітка

Ця можливість підтримується, починаючи з версії FastAPI `0.115.0`. 🤓

///

## Query параметри з Pydantic-моделлю

Оголосіть **query параметри**, які Вам потрібні, у **Pydantic-моделі**, а потім оголосіть цей параметр як `Query`:

{* ../../docs_src/query_param_models/tutorial001_an_py310.py hl[9:13,17] *}

**FastAPI**  буде **витягувати** дані для **кожного поля** з **query параметрів** у запиті та передавати їх у визначену вами Pydantic-модель.

## Перевірте документацію

Ви можете побачити параметри запиту в UI документації за `/docs`:

<div class="screenshot">
<img src="/img/tutorial/query-param-models/image01.png">
</div>

## Заборона зайвих Query параметрів

У деяких особливих випадках (ймовірно, не дуже поширених) Ви можете захотіти **обмежити** query параметри, які дозволено отримувати.

Ви можете використати конфігурацію моделі Pydantic, щоб заборонити (`forbid`) будь-які зайві (`extra`) поля:

{* ../../docs_src/query_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати **зайві** дані у **query параметрах**, він отримає **помилку**.

Наприклад, якщо клієнт спробує надіслати query параметр `tool` зі значенням `plumbus`, як у цьому запиті:

```http
https://example.com/items/?limit=10&tool=plumbus
```

Він отримає відповідь з **помилкою**, яка повідомить, що query параметр `tool ` не дозволено:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["query", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus"
        }
    ]
}
```

## Підсумок

Ви можете використовувати **Pydantic-моделі** для оголошення **query параметрів** у **FastAPI**. 😎

/// tip | Підказка

Спойлер: Ви також можете використовувати Pydantic-моделі для оголошення cookie та заголовків, але про це Ви дізнаєтеся пізніше в цьому посібнику. 🤫

///
