#ifndef PRECICE_NO_MPI

#include "testing/Testing.hpp"

#include <precice/precice.hpp>
#include <vector>

BOOST_AUTO_TEST_SUITE(Integration)
BOOST_AUTO_TEST_SUITE(Parallel)
PRECICE_TEST_SETUP("ParallelSolver"_on(3_ranks), "SerialSolver"_on(1_rank))
BOOST_AUTO_TEST_CASE(PrimaryRankSockets)
{
  PRECICE_TEST();

  std::string myMeshName;
  if (context.isNamed("ParallelSolver")) {
    myMeshName = "ParallelMesh";
  } else {
    myMeshName = "SerialMesh";
  }
  precice::Participant interface(context.name, context.config(), context.rank, context.size);
  auto                 meshName    = myMeshName;
  double               position[2] = {0, 0};
  interface.setMeshVertex(meshName, position);
  interface.initialize();
  interface.advance(1.0);
  interface.finalize();
}

BOOST_AUTO_TEST_SUITE_END() // Integration
BOOST_AUTO_TEST_SUITE_END() // Parallel

#endif // PRECICE_NO_MPI
