/* PSF2 font for wide builds.  Glyphs extracted from Unifont with
'sub_hex',  then converted to the following array using 'hex2psf2'.
This font contains 271 glyphs. The first 256 are from CP437;  the last
fifteen add glyphs for "thick box characters" and scan line 1, 3, 7, and
9 glyphs,  so that we have all ACS and WACS glyphs.         */

int PDC_font_height = 16;
int PDC_font_width = 8;

#define UNICODE_INFO_OFFSET   4368
#define UNICODE_INFO_SIZE      824

static const unsigned char font_bytes[5192] = {
    0x72, 0xB5, 0x4A, 0x86,   /* 'magic' PSF2 bytes */
    0x00, 0x00, 0x00, 0x00,   /* version */
    0x20, 0x00, 0x00, 0x00,   /* this header is 0x20 bytes long */
    0x01, 0x00, 0x00, 0x00,   /* flagged as 'has Unicode tbl' */
    0x0f, 0x01, 0x00, 0x00,   /* 271 glyphs */
    0x10, 0x00, 0x00, 0x00,   /* bytes/glyph */
    0x10, 0x00, 0x00, 0x00,   /* glyph height (=16 pixels) */
    0x08, 0x00, 0x00, 0x00,   /* glyph width (=8 pixels) */
 /* U+0    */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+263a */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0xa5, 0x81, 0xa5, 0x99, 0x42, 0x3c, 0x00, 0x00, 0x00,
 /* U+263b */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0xff, 0xdb, 0xff, 0xdb, 0xe7, 0x7e, 0x3c, 0x00, 0x00, 0x00,
 /* U+2665 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x08, 0x00, 0x00,
 /* U+2666 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00, 0x00,
 /* U+2663 */  0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x08, 0x7f, 0x7f, 0x6b, 0x08, 0x08, 0x1c, 0x00, 0x00,
 /* U+2660 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x7f, 0x3e, 0x08, 0x1c, 0x00, 0x00,
 /* U+2024 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
 /* U+25d8 */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
 /* U+25bc */  0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+25d9 */  0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,
 /* U+2642 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x05, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00,
 /* U+2640 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00,
 /* U+266a */  0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0x0a, 0x0a, 0x08, 0x08, 0x08, 0x38, 0x78, 0x70, 0x00, 0x00,
 /* U+266c */  0x00, 0x00, 0x00, 0x1c, 0x17, 0x11, 0x1d, 0x17, 0x11, 0x71, 0xf1, 0xe7, 0x0f, 0x0e, 0x00, 0x00,
 /* U+263c */  0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x2a, 0x1c, 0x77, 0x1c, 0x2a, 0x49, 0x00, 0x00, 0x00, 0x00,
 /* U+25b6 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x78, 0x7e, 0x7e, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+25c0 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x7e, 0x7e, 0x1e, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2195 */  0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00,
 /* U+203c */  0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x24, 0x00, 0x00,
 /* U+b6 */  0x00, 0x00, 0x00, 0x00, 0x3f, 0x7a, 0x7a, 0x7a, 0x3a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00,
 /* U+a7 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x42, 0x42, 0x3c, 0x02, 0x42, 0x3c, 0x00, 0x00,
 /* U+2582 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
 /* U+280d */  0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x22, 0x00, 0x00, 0x32, 0x30, 0x00, 0x22, 0x00, 0x00, 0x00,
 /* U+2191 */  0x00, 0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2193 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x2a, 0x1c, 0x08, 0x00, 0x00,
 /* U+2192 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2190 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2319 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+280c */  0x00, 0x00, 0x00, 0x26, 0x06, 0x00, 0x22, 0x00, 0x00, 0x32, 0x30, 0x00, 0x22, 0x00, 0x00, 0x00,
 /* U+25b2 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+25bc */  0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+20 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+21 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00,
 /* U+22 */  0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+23 */  0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x7e, 0x24, 0x24, 0x7e, 0x48, 0x48, 0x48, 0x00, 0x00,
 /* U+24 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x3e, 0x49, 0x48, 0x38, 0x0e, 0x09, 0x49, 0x3e, 0x08, 0x00, 0x00,
 /* U+25 */  0x00, 0x00, 0x00, 0x00, 0x31, 0x4a, 0x4a, 0x34, 0x08, 0x08, 0x16, 0x29, 0x29, 0x46, 0x00, 0x00,
 /* U+26 */  0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x22, 0x14, 0x18, 0x29, 0x45, 0x42, 0x46, 0x39, 0x00, 0x00,
 /* U+27 */  0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+28 */  0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00,
 /* U+29 */  0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x00,
 /* U+2a */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x49, 0x2a, 0x1c, 0x2a, 0x49, 0x08, 0x00, 0x00, 0x00,
 /* U+2b */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
 /* U+2c */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x10,
 /* U+2d */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2e */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
 /* U+2f */  0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x40, 0x40, 0x00, 0x00,
 /* U+30 */  0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x24, 0x18, 0x00, 0x00,
 /* U+31 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+32 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x0c, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00,
 /* U+33 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+34 */  0x00, 0x00, 0x00, 0x00, 0x04, 0x0c, 0x14, 0x24, 0x44, 0x44, 0x7e, 0x04, 0x04, 0x04, 0x00, 0x00,
 /* U+35 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00,
 /* U+36 */  0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+37 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
 /* U+38 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+39 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x04, 0x38, 0x00, 0x00,
 /* U+3a */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
 /* U+3b */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x10, 0x00,
 /* U+3c */  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00,
 /* U+3d */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
 /* U+3e */  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00,
 /* U+3f */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00,
 /* U+40 */  0x00, 0x00, 0x00, 0x00, 0x1c, 0x22, 0x4a, 0x56, 0x52, 0x52, 0x52, 0x4e, 0x20, 0x1e, 0x00, 0x00,
 /* U+41 */  0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+42 */  0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00,
 /* U+43 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+44 */  0x00, 0x00, 0x00, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x78, 0x00, 0x00,
 /* U+45 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00,
 /* U+46 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
 /* U+47 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+48 */  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+49 */  0x00, 0x00, 0x00, 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+4a */  0x00, 0x00, 0x00, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00,
 /* U+4b */  0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00,
 /* U+4c */  0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00,
 /* U+4d */  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x66, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+4e */  0x00, 0x00, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00,
 /* U+4f */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+50 */  0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
 /* U+51 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x66, 0x3c, 0x03, 0x00,
 /* U+52 */  0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x44, 0x42, 0x42, 0x00, 0x00,
 /* U+53 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+54 */  0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
 /* U+55 */  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+56 */  0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x41, 0x22, 0x22, 0x22, 0x14, 0x14, 0x08, 0x08, 0x00, 0x00,
 /* U+57 */  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x66, 0x42, 0x42, 0x00, 0x00,
 /* U+58 */  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00, 0x00,
 /* U+59 */  0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
 /* U+5a */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00,
 /* U+5b */  0x00, 0x00, 0x00, 0x0e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0e, 0x00,
 /* U+5c */  0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x00, 0x00,
 /* U+5d */  0x00, 0x00, 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00,
 /* U+5e */  0x00, 0x00, 0x18, 0x24, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+5f */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00,
 /* U+60 */  0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+61 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+62 */  0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00,
 /* U+63 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+64 */  0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+65 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+66 */  0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00,
 /* U+67 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x3a, 0x44, 0x44, 0x44, 0x38, 0x20, 0x3c, 0x42, 0x42, 0x3c,
 /* U+68 */  0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+69 */  0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+6a */  0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x48, 0x30,
 /* U+6b */  0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00,
 /* U+6c */  0x00, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+6d */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00,
 /* U+6e */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+6f */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+70 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x40, 0x40,
 /* U+71 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x02,
 /* U+72 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
 /* U+73 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x30, 0x0c, 0x02, 0x42, 0x3c, 0x00, 0x00,
 /* U+74 */  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00,
 /* U+75 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+76 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00,
 /* U+77 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x36, 0x00, 0x00,
 /* U+78 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00,
 /* U+79 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x02, 0x3c,
 /* U+7a */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7e, 0x00, 0x00,
 /* U+7b */  0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x08, 0x08, 0x10, 0x20, 0x10, 0x08, 0x08, 0x10, 0x10, 0x0c,
 /* U+7c */  0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+7d */  0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x10, 0x10, 0x08, 0x04, 0x08, 0x10, 0x10, 0x08, 0x08, 0x30,
 /* U+7e */  0x00, 0x00, 0x00, 0x31, 0x49, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2302 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x00, 0x00,
 /* U+c7 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x08, 0x30,
 /* U+fc */  0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+e9 */  0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+e2 */  0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+e4 */  0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+e0 */  0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+e5 */  0x00, 0x18, 0x24, 0x18, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+e7 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x08, 0x30,
 /* U+ea */  0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+eb */  0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+e8 */  0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+ef */  0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+ee */  0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+ec */  0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+c4 */  0x24, 0x24, 0x00, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+c5 */  0x18, 0x24, 0x18, 0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+c9 */  0x0c, 0x30, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00,
 /* U+e6 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x49, 0x09, 0x3f, 0x48, 0x48, 0x49, 0x3e, 0x00, 0x00,
 /* U+c6 */  0x00, 0x00, 0x00, 0x00, 0x1f, 0x28, 0x48, 0x48, 0x7f, 0x48, 0x48, 0x48, 0x48, 0x4f, 0x00, 0x00,
 /* U+f4 */  0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+f5 */  0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+f2 */  0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+fb */  0x00, 0x00, 0x18, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+f9 */  0x00, 0x00, 0x30, 0x0c, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+ff */  0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x02, 0x3c,
 /* U+d6 */  0x24, 0x24, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+dc */  0x24, 0x24, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+a2 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x3e, 0x49, 0x48, 0x48, 0x49, 0x3e, 0x08, 0x08, 0x00, 0x00,
 /* U+a3 */  0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x3e, 0x61, 0x00, 0x00,
 /* U+a5 */  0x00, 0x00, 0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x7f, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x00, 0x00,
 /* U+20a7 */  0x00, 0x00, 0x00, 0x00, 0x68, 0x58, 0x5f, 0x5c, 0x6c, 0x4a, 0x49, 0x49, 0x49, 0x4e, 0x00, 0x00,
 /* U+192 */  0x00, 0x00, 0x00, 0x0c, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x60, 0x00,
 /* U+e1 */  0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x3e, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+ed */  0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
 /* U+f3 */  0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+fa */  0x00, 0x00, 0x0c, 0x30, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 0x00,
 /* U+f1 */  0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+d1 */  0x32, 0x4c, 0x00, 0x00, 0x42, 0x62, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x46, 0x42, 0x00, 0x00,
 /* U+aa */  0x00, 0x00, 0x1c, 0x02, 0x1e, 0x22, 0x1e, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+ba */  0x00, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+bf */  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x20, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+2310 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x00, 0x00,
 /* U+ac */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x00, 0x00,
 /* U+bd */  0x00, 0x00, 0x00, 0x00, 0x22, 0x62, 0x24, 0x28, 0x28, 0x14, 0x1a, 0x22, 0x44, 0x4e, 0x00, 0x00,
 /* U+bc */  0x00, 0x00, 0x00, 0x00, 0x22, 0x62, 0x24, 0x28, 0x28, 0x12, 0x16, 0x2a, 0x4e, 0x42, 0x00, 0x00,
 /* U+a1 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
 /* U+ab */  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x24, 0x24, 0x48, 0x24, 0x24, 0x12, 0x12, 0x00, 0x00,
 /* U+bb */  0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x24, 0x24, 0x12, 0x24, 0x24, 0x48, 0x48, 0x00, 0x00,
 /* U+2591 */  0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22,
 /* U+2592 */  0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55,
 /* U+2593 */  0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb,
 /* U+2502 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2524 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2561 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2562 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xf4, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2556 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2555 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2563 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xf4, 0x04, 0xf4, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2551 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2557 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x04, 0xf4, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+255d */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xf4, 0x04, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+255c */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+255b */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2510 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2514 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2534 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+252c */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+251c */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2500 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+253c */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+255e */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+255f */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+255a */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2554 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2569 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2566 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2560 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x10, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2550 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+256c */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xf7, 0x00, 0xf7, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2567 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2568 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2564 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2565 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+2559 */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2558 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2552 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2553 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+256b */  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xff, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
 /* U+256a */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0xff, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2518 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+250c */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2588 */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
 /* U+2584 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
 /* U+258c */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
 /* U+2590 */  0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
 /* U+2580 */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+3b1 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4a, 0x44, 0x44, 0x44, 0x44, 0x4a, 0x32, 0x00, 0x00,
 /* U+df */  0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x48, 0x58, 0x44, 0x42, 0x42, 0x52, 0x4c, 0x00, 0x00,
 /* U+393 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
 /* U+3c0 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
 /* U+3a3 */  0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x08, 0x10, 0x20, 0x40, 0x7e, 0x00, 0x00,
 /* U+3c3 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x48, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00,
 /* U+b5 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x66, 0x59, 0x40, 0x80,
 /* U+3c4 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00,
 /* U+3a6 */  0x00, 0x00, 0x00, 0x00, 0x7f, 0x08, 0x3e, 0x49, 0x49, 0x49, 0x49, 0x3e, 0x08, 0x7f, 0x00, 0x00,
 /* U+398 */  0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+3a9 */  0x00, 0x00, 0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x22, 0x14, 0x14, 0x77, 0x00, 0x00,
 /* U+3b4 */  0x00, 0x00, 0x00, 0x00, 0x1c, 0x20, 0x20, 0x20, 0x18, 0x24, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00,
 /* U+221e */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x49, 0x49, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+3c6 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x3e, 0x08, 0x08,
 /* U+3b5 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x3c, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00,
 /* U+2229 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00,
 /* U+2261 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
 /* U+b1 */  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x7f, 0x08, 0x08, 0x08, 0x00, 0x7f, 0x00, 0x00, 0x00,
 /* U+2265 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x18, 0x06, 0x18, 0x60, 0x00, 0x7e, 0x00, 0x00, 0x00,
 /* U+2264 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, 0x60, 0x18, 0x06, 0x00, 0x7e, 0x00, 0x00, 0x00,
 /* U+2320 */  0x00, 0x00, 0x00, 0x00, 0x06, 0x0a, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2321 */  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x30, 0x00, 0x00, 0x00, 0x00,
 /* U+f7 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
 /* U+2248 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x00, 0x00,
 /* U+b0 */  0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2219 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
 /* U+b7 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+221a */  0x00, 0x00, 0x07, 0x04, 0x04, 0x04, 0x04, 0x04, 0x74, 0x14, 0x14, 0x0c, 0x0c, 0x04, 0x04, 0x00,
 /* U+207f */  0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+b2 */  0x00, 0x00, 0x00, 0x38, 0x44, 0x04, 0x18, 0x20, 0x40, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+25a0 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 0x00,
 /* U+a0 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2513 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+251b */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+250f */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+2517 */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+253b */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+252f */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
 /* U+2523 */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+252b */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+2501 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+2503 */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+254b */  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
 /* U+23ba */  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+23bb */  0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 /* U+23bc */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
 /* U+23bd */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
 /* U+0    */ 0x00, 0xff,
 /* U+263a */ 0xe2, 0x98, 0xba, 0xff,
 /* U+263b */ 0xe2, 0x98, 0xbb, 0xff,
 /* U+2665 */ 0xe2, 0x99, 0xa5, 0xff,
 /* U+2666 */ 0xe2, 0x99, 0xa6, 0xff,
 /* U+2663 */ 0xe2, 0x99, 0xa3, 0xff,
 /* U+2660 */ 0xe2, 0x99, 0xa0, 0xff,
 /* U+2024 */ 0xe2, 0x80, 0xa4, 0xff,
 /* U+25d8 */ 0xe2, 0x97, 0x98, 0xff,
 /* U+25bc */ 0xe2, 0x96, 0xbc, 0xff,
 /* U+25d9 */ 0xe2, 0x97, 0x99, 0xff,
 /* U+2642 */ 0xe2, 0x99, 0x82, 0xff,
 /* U+2640 */ 0xe2, 0x99, 0x80, 0xff,
 /* U+266a */ 0xe2, 0x99, 0xaa, 0xff,
 /* U+266c */ 0xe2, 0x99, 0xac, 0xff,
 /* U+263c */ 0xe2, 0x98, 0xbc, 0xff,
 /* U+25b6 */ 0xe2, 0x96, 0xb6, 0xff,
 /* U+25c0 */ 0xe2, 0x97, 0x80, 0xff,
 /* U+2195 */ 0xe2, 0x86, 0x95, 0xff,
 /* U+203c */ 0xe2, 0x80, 0xbc, 0xff,
 /* U+b6 */ 0xc2, 0xb6, 0xff,
 /* U+a7 */ 0xc2, 0xa7, 0xff,
 /* U+2582 */ 0xe2, 0x96, 0x82, 0xff,
 /* U+280d */ 0xe2, 0xa0, 0x8d, 0xff,
 /* U+2191 */ 0xe2, 0x86, 0x91, 0xff,
 /* U+2193 */ 0xe2, 0x86, 0x93, 0xff,
 /* U+2192 */ 0xe2, 0x86, 0x92, 0xff,
 /* U+2190 */ 0xe2, 0x86, 0x90, 0xff,
 /* U+2319 */ 0xe2, 0x8c, 0x99, 0xff,
 /* U+280c */ 0xe2, 0xa0, 0x8c, 0xff,
 /* U+25b2 */ 0xe2, 0x96, 0xb2, 0xff,
 /* U+25bc */ 0xe2, 0x96, 0xbc, 0xff,
 /* U+20   */ 0x20, 0xff,
 /* U+21 ! */ 0x21, 0xff,
 /* U+22 " */ 0x22, 0xff,
 /* U+23 # */ 0x23, 0xff,
 /* U+24 $ */ 0x24, 0xff,
 /* U+25 % */ 0x25, 0xff,
 /* U+26 & */ 0x26, 0xff,
 /* U+27 ' */ 0x27, 0xff,
 /* U+28 ( */ 0x28, 0xff,
 /* U+29 ) */ 0x29, 0xff,
 /* U+2a * */ 0x2a, 0xff,
 /* U+2b + */ 0x2b, 0xff,
 /* U+2c , */ 0x2c, 0xff,
 /* U+2d - */ 0x2d, 0xff,
 /* U+2e . */ 0x2e, 0xff,
 /* U+2f / */ 0x2f, 0xff,
 /* U+30 0 */ 0x30, 0xff,
 /* U+31 1 */ 0x31, 0xff,
 /* U+32 2 */ 0x32, 0xff,
 /* U+33 3 */ 0x33, 0xff,
 /* U+34 4 */ 0x34, 0xff,
 /* U+35 5 */ 0x35, 0xff,
 /* U+36 6 */ 0x36, 0xff,
 /* U+37 7 */ 0x37, 0xff,
 /* U+38 8 */ 0x38, 0xff,
 /* U+39 9 */ 0x39, 0xff,
 /* U+3a : */ 0x3a, 0xff,
 /* U+3b ; */ 0x3b, 0xff,
 /* U+3c < */ 0x3c, 0xff,
 /* U+3d = */ 0x3d, 0xff,
 /* U+3e > */ 0x3e, 0xff,
 /* U+3f ? */ 0x3f, 0xff,
 /* U+40 @ */ 0x40, 0xff,
 /* U+41 A */ 0x41, 0xff,
 /* U+42 B */ 0x42, 0xff,
 /* U+43 C */ 0x43, 0xff,
 /* U+44 D */ 0x44, 0xff,
 /* U+45 E */ 0x45, 0xff,
 /* U+46 F */ 0x46, 0xff,
 /* U+47 G */ 0x47, 0xff,
 /* U+48 H */ 0x48, 0xff,
 /* U+49 I */ 0x49, 0xff,
 /* U+4a J */ 0x4a, 0xff,
 /* U+4b K */ 0x4b, 0xff,
 /* U+4c L */ 0x4c, 0xff,
 /* U+4d M */ 0x4d, 0xff,
 /* U+4e N */ 0x4e, 0xff,
 /* U+4f O */ 0x4f, 0xff,
 /* U+50 P */ 0x50, 0xff,
 /* U+51 Q */ 0x51, 0xff,
 /* U+52 R */ 0x52, 0xff,
 /* U+53 S */ 0x53, 0xff,
 /* U+54 T */ 0x54, 0xff,
 /* U+55 U */ 0x55, 0xff,
 /* U+56 V */ 0x56, 0xff,
 /* U+57 W */ 0x57, 0xff,
 /* U+58 X */ 0x58, 0xff,
 /* U+59 Y */ 0x59, 0xff,
 /* U+5a Z */ 0x5a, 0xff,
 /* U+5b [ */ 0x5b, 0xff,
 /* U+5c \ */ 0x5c, 0xff,
 /* U+5d ] */ 0x5d, 0xff,
 /* U+5e ^ */ 0x5e, 0xff,
 /* U+5f _ */ 0x5f, 0xff,
 /* U+60 ` */ 0x60, 0xff,
 /* U+61 a */ 0x61, 0xff,
 /* U+62 b */ 0x62, 0xff,
 /* U+63 c */ 0x63, 0xff,
 /* U+64 d */ 0x64, 0xff,
 /* U+65 e */ 0x65, 0xff,
 /* U+66 f */ 0x66, 0xff,
 /* U+67 g */ 0x67, 0xff,
 /* U+68 h */ 0x68, 0xff,
 /* U+69 i */ 0x69, 0xff,
 /* U+6a j */ 0x6a, 0xff,
 /* U+6b k */ 0x6b, 0xff,
 /* U+6c l */ 0x6c, 0xff,
 /* U+6d m */ 0x6d, 0xff,
 /* U+6e n */ 0x6e, 0xff,
 /* U+6f o */ 0x6f, 0xff,
 /* U+70 p */ 0x70, 0xff,
 /* U+71 q */ 0x71, 0xff,
 /* U+72 r */ 0x72, 0xff,
 /* U+73 s */ 0x73, 0xff,
 /* U+74 t */ 0x74, 0xff,
 /* U+75 u */ 0x75, 0xff,
 /* U+76 v */ 0x76, 0xff,
 /* U+77 w */ 0x77, 0xff,
 /* U+78 x */ 0x78, 0xff,
 /* U+79 y */ 0x79, 0xff,
 /* U+7a z */ 0x7a, 0xff,
 /* U+7b { */ 0x7b, 0xff,
 /* U+7c | */ 0x7c, 0xff,
 /* U+7d } */ 0x7d, 0xff,
 /* U+7e ~ */ 0x7e, 0xff,
 /* U+2302 */ 0xe2, 0x8c, 0x82, 0xff,
 /* U+c7 */ 0xc3, 0x87, 0xff,             /* UPPERCASE_C_CEDILLA    */
 /* U+fc */ 0xc3, 0xbc, 0xff,             /* LOWERCASE_U_UMLAUT     */
 /* U+e9 */ 0xc3, 0xa9, 0xff,             /* LOWERCASE_E_ACUTE      */
 /* U+e2 */ 0xc3, 0xa2, 0xff,             /* LOWERCASE_A_CIRCUMFLEX */
 /* U+e4 */ 0xc3, 0xa4, 0xff,             /* LOWERCASE_A_UMLAUT     */
 /* U+e0 */ 0xc3, 0xa0, 0xff,             /* LOWERCASE_A_GRAVE      */
 /* U+e5 */ 0xc3, 0xa5, 0xff,             /* LOWERCASE_A_RING       */
 /* U+e7 */ 0xc3, 0xa7, 0xff,             /* LOWERCASE_C_CEDILLA    */
 /* U+ea */ 0xc3, 0xaa, 0xff,             /* LOWERCASE_E_CIRCUMFLEX */
 /* U+eb */ 0xc3, 0xab, 0xff,             /* LOWERCASE_E_UMLAUT     */
 /* U+e8 */ 0xc3, 0xa8, 0xff,             /* LOWERCASE_E_GRAVE      */
 /* U+ef */ 0xc3, 0xaf, 0xff,             /* LOWERCASE_I_UMLAUT     */
 /* U+ee */ 0xc3, 0xae, 0xff,             /* LOWERCASE_I_CIRCUMFLEX */
 /* U+ec */ 0xc3, 0xac, 0xff,             /* LOWERCASE_I_GRAVE      */
 /* U+c4 */ 0xc3, 0x84, 0xff,             /* UPPERCASE_A_UMLAUT     */
 /* U+c5 */ 0xc3, 0x85, 0xff,             /* UPPERCASE_A_RING       */
 /* U+c9 */ 0xc3, 0x89, 0xff,             /* UPPERCASE_E_ACUTE      */
 /* U+e6 */ 0xc3, 0xa6, 0xff,             /* LOWERCASE_AE_LIGATURE  */
 /* U+c6 */ 0xc3, 0x86, 0xff,             /* UPPERCASE_AE_LIGATURE  */
 /* U+f4 */ 0xc3, 0xb4, 0xff,             /* LOWERCASE_O_CIRCUMFLE  */
 /* U+f5 */ 0xc3, 0xb5, 0xff,             /* LOWERCASE_O_UMLAUT     */
 /* U+f2 */ 0xc3, 0xb2, 0xff,             /* LOWERCASE_O_GRAVE      */
 /* U+fb */ 0xc3, 0xbb, 0xff,             /* LOWERCASE_U_CIRCUMFLE  */
 /* U+f9 */ 0xc3, 0xb9, 0xff,             /* LOWERCASE_U_GRAVE      */
 /* U+ff */ 0xc3, 0xbf, 0xff,             /* LOWERCASE_Y_UMLAUT     */
 /* U+d6 */ 0xc3, 0x96, 0xff,             /* UPPERCASE_O_UMLAUT     */
 /* U+dc */ 0xc3, 0x9c, 0xff,             /* UPPERCASE_U_UMLAUT     */
 /* U+a2 */ 0xc2, 0xa2, 0xff,             /* CENT_SIGN              */
 /* U+a3 */ 0xc2, 0xa3, 0xff,             /* STERLING_SIGN          */
 /* U+a5 */ 0xc2, 0xa5, 0xff,             /* YEN_SIGN               */
 /* U+20a7 */ 0xe2, 0x82, 0xa7, 0xff,     /* PESETA_SIGN            */
 /* U+192 */ 0xc6, 0x92, 0xff,            /* F_WITH_HOOK            */
 /* U+e1 */ 0xc3, 0xa1, 0xff,             /* LOWERCASE_A_ACUTE      */
 /* U+ed */ 0xc3, 0xad, 0xff,             /* LOWERCASE_I_ACUTE      */
 /* U+f3 */ 0xc3, 0xb3, 0xff,             /* LOWERCASE_O_ACUTE      */
 /* U+fa */ 0xc3, 0xba, 0xff,             /* LOWERCASE_U_ACUTE      */
 /* U+f1 */ 0xc3, 0xb1, 0xff,             /* LOWERCASE_N_TILDE      */
 /* U+d1 */ 0xc3, 0x91, 0xff,             /* UPPERCASE_N_TILDE      */
 /* U+aa */ 0xc2, 0xaa, 0xff,             /* A_ORDINAL              */
 /* U+ba */ 0xc2, 0xba, 0xff,             /* O_ORDINAL              */
 /* U+bf */ 0xc2, 0xbf, 0xff,             /* INVERTED_QUESTION_MARK */
 /* U+2310 */ 0xe2, 0x8c, 0x90, 0xff,     /* REVERSED_NOT_SIGN      */
 /* U+ac */ 0xc2, 0xac, 0xff,             /* NOT_SIGN               */
 /* U+bd */ 0xc2, 0xbd, 0xff,             /* VULGAR_HALF            */
 /* U+bc */ 0xc2, 0xbc, 0xff,             /* VULGAR_QUARTER         */
 /* U+a1 */ 0xc2, 0xa1, 0xff,             /* INVERTED_EXCLAMATION_M */
 /* U+ab */ 0xc2, 0xab, 0xff,             /* LEFT_ANGLE_QUOTE_MARK  */
 /* U+bb */ 0xc2, 0xbb, 0xff,             /* RIGHT_ANGLE_QUOTE_MARK */
 /* U+2591 */ 0xe2, 0x96, 0x91, 0xff,     /* LIGHT_SHADE            */
 /* U+2592 */ 0xe2, 0x96, 0x92, 0xff,     /* MEDIUM_SHADE        */
 /* U+2593 */ 0xe2, 0x96, 0x93, 0xff,     /* DARK_SHADE          */
 /* U+2502 */ 0xe2, 0x94, 0x82, 0xff,     /* BOX_VLINE           */
 /* U+2524 */ 0xe2, 0x94, 0xa4, 0xff,     /* BOX_RTEE            */
 /* U+2561 */ 0xe2, 0x95, 0xa1, 0xff,     /* BOX_SD_RTEE         */
 /* U+2562 */ 0xe2, 0x95, 0xa2, 0xff,     /* BOX_DS_RTEE         */
 /* U+2556 */ 0xe2, 0x95, 0x96, 0xff,     /* BOX_DS_URCORNER     */
 /* U+2555 */ 0xe2, 0x95, 0x95, 0xff,     /* BOX_SD_URCORNER     */
 /* U+2563 */ 0xe2, 0x95, 0xa3, 0xff,     /* BOX_D_RTEE          */
 /* U+2551 */ 0xe2, 0x95, 0x91, 0xff,     /* BOX_D_VLINE         */
 /* U+2557 */ 0xe2, 0x95, 0x97, 0xff,     /* BOX_D_URCORNER      */
 /* U+255d */ 0xe2, 0x95, 0x9d, 0xff,     /* BOX_D_LRCORNER      */
 /* U+255c */ 0xe2, 0x95, 0x9c, 0xff,     /* BOX_DS_LRCORNER     */
 /* U+255b */ 0xe2, 0x95, 0x9b, 0xff,     /* BOX_SD_LRCORNER     */
 /* U+2510 */ 0xe2, 0x94, 0x90, 0xff,     /* BOX_URCORNER        */
 /* U+2514 */ 0xe2, 0x94, 0x94, 0xff,     /* BOX_LLCORNER        */
 /* U+2534 */ 0xe2, 0x94, 0xb4, 0xff,     /* BOX_BTEE            */
 /* U+252c */ 0xe2, 0x94, 0xac, 0xff,     /* BOX_TTEE            */
 /* U+251c */ 0xe2, 0x94, 0x9c, 0xff,     /* BOX_LTEE            */
 /* U+2500 */ 0xe2, 0x94, 0x80, 0xff,     /* BOX_HLINE           */
 /* U+253c */ 0xe2, 0x94, 0xbc, 0xff,     /* BOX_PLUS            */
 /* U+255e */ 0xe2, 0x95, 0x9e, 0xff,     /* BOX_SD_LTEE         */
 /* U+255f */ 0xe2, 0x95, 0x9f, 0xff,     /* BOX_DS_LTEE         */
 /* U+255a */ 0xe2, 0x95, 0x9a, 0xff,     /* BOX_D_LLCORNER      */
 /* U+2554 */ 0xe2, 0x95, 0x94, 0xff,     /* BOX_D_ULCORNER      */
 /* U+2569 */ 0xe2, 0x95, 0xa9, 0xff,     /* BOX_D_BTEE          */
 /* U+2566 */ 0xe2, 0x95, 0xa6, 0xff,     /* BOX_D_TTEE          */
 /* U+2560 */ 0xe2, 0x95, 0xa0, 0xff,     /* BOX_D_LTEE          */
 /* U+2550 */ 0xe2, 0x95, 0x90, 0xff,     /* BOX_D_HLINE         */
 /* U+256c */ 0xe2, 0x95, 0xac, 0xff,     /* BOX_D_PLUS          */
 /* U+2567 */ 0xe2, 0x95, 0xa7, 0xff,     /* BOX_SD_BTEE         */
 /* U+2568 */ 0xe2, 0x95, 0xa8, 0xff,     /* BOX_DS_BTEE         */
 /* U+2564 */ 0xe2, 0x95, 0xa4, 0xff,     /* BOX_SD_TTEE         */
 /* U+2565 */ 0xe2, 0x95, 0xa5, 0xff,     /* BOX_DS_TTEE         */
 /* U+2559 */ 0xe2, 0x95, 0x99, 0xff,     /* BOX_DS_LLCORNER     */
 /* U+2558 */ 0xe2, 0x95, 0x98, 0xff,     /* BOX_SD_LLCORNER     */
 /* U+2552 */ 0xe2, 0x95, 0x92, 0xff,     /* BOX_SD_ULCORNER     */
 /* U+2553 */ 0xe2, 0x95, 0x93, 0xff,     /* BOX_DS_ULCORNER     */
 /* U+256b */ 0xe2, 0x95, 0xab, 0xff,     /* BOX_DS_PLUS         */
 /* U+256a */ 0xe2, 0x95, 0xaa, 0xff,     /* BOX_SD_PLUS         */
 /* U+2518 */ 0xe2, 0x94, 0x98, 0xff,     /* BOX_LRCORNER        */
 /* U+250c */ 0xe2, 0x94, 0x8c, 0xff,     /* BOX_ULCORNER        */
 /* U+2588 */ 0xe2, 0x96, 0x88, 0xff,     /* FULL_BLOCK          */
 /* U+2584 */ 0xe2, 0x96, 0x84, 0xff,     /* LOWER_HALF_BLOCK    */
 /* U+258c */ 0xe2, 0x96, 0x8c, 0xff,     /* LEFT_HALF_BLOCK     */
 /* U+2590 */ 0xe2, 0x96, 0x90, 0xff,     /* RIGHT_HALF_BLOCK    */
 /* U+2580 */ 0xe2, 0x96, 0x80, 0xff,     /* UPPER_HALF_BLOCK    */
 /* U+3b1 */ 0xce, 0xb1, 0xff,            /* alpha               */
 /* U+df */ 0xc3, 0x9f, 0xff,             /* beta                */
 /* U+393 */ 0xce, 0x93, 0xff,            /* gamma               */
 /* U+3c0 */ 0xcf, 0x80, 0xff,            /* pi                  */
 /* U+3a3 */ 0xce, 0xa3, 0xff,            /* Sigma               */
 /* U+3c3 */ 0xcf, 0x83, 0xff,            /* sigma               */
 /* U+b5 */ 0xc2, 0xb5, 0xff,             /* mu                  */
 /* U+3c4 */ 0xcf, 0x84, 0xff,            /* tau                 */
 /* U+3a6 */ 0xce, 0xa6, 0xff,            /* Phi                 */
 /* U+398 */ 0xce, 0x98, 0xff,            /* theta               */
 /* U+3a9 */ 0xce, 0xa9, 0xff,            /* omega               */
 /* U+3b4 */ 0xce, 0xb4, 0xff,            /* delta               */
 /* U+221e */ 0xe2, 0x88, 0x9e, 0xff,     /* infinity            */
 /* U+3c6 */ 0xcf, 0x86, 0xff,            /* phi                 */
 /* U+3b5 */ 0xce, 0xb5, 0xff,            /* epsilon             */
 /* U+2229 */ 0xe2, 0x88, 0xa9, 0xff,     /* intersection        */
 /* U+2261 */ 0xe2, 0x89, 0xa1, 0xff,     /* triple bar          */
 /* U+b1 */ 0xc2, 0xb1, 0xff,             /* plus or minus       */
 /* U+2265 */ 0xe2, 0x89, 0xa5, 0xff,     /* greater or equal to */
 /* U+2264 */ 0xe2, 0x89, 0xa4, 0xff,     /* lesser or equal to  */
 /* U+2320 */ 0xe2, 0x8c, 0xa0, 0xff,     /* upper half integral sign */
 /* U+2321 */ 0xe2, 0x8c, 0xa1, 0xff,     /* lower half integral sign */
 /* U+f7 */ 0xc3, 0xb7, 0xff,             /* division sign     */
 /* U+2248 */ 0xe2, 0x89, 0x88, 0xff,     /* approx equals     */
 /* U+b0 */ 0xc2, 0xb0, 0xff,             /* degree sign       */
 /* U+2219 */ 0xe2, 0x88, 0x99, 0xff,     /* Large bullet      */
 /* U+b7 */ 0xc2, 0xb7, 0xff,             /* Small bullet      */
 /* U+221a */ 0xe2, 0x88, 0x9a, 0xff,     /* Square root       */
 /* U+207f */ 0xe2, 0x81, 0xbf, 0xff,     /* Superscript n     */
 /* U+b2 */ 0xc2, 0xb2, 0xff,             /* Superscript 2     */
 /* U+25a0 */ 0xe2, 0x96, 0xa0, 0xff,     /* CENTERED_SQUARE   */
 /* U+a0 */ 0xc2, 0xa0, 0xff,
 /* U+2513 */ 0xe2, 0x94, 0x93, 0xff,     /* BOX_T_URCORNER    */
 /* U+251b */ 0xe2, 0x94, 0x9b, 0xff,     /* BOX_T_LRCORNER    */
 /* U+250f */ 0xe2, 0x94, 0x8f, 0xff,     /* BOX_T_ULCORNER    */
 /* U+2517 */ 0xe2, 0x94, 0x97, 0xff,     /* BOX_T_LLCORNER    */
 /* U+253b */ 0xe2, 0x94, 0xbb, 0xff,     /* BOX_T_BTEE        */
 /* U+252f */ 0xe2, 0x94, 0xaf, 0xff,     /* BOX_T_TTEE        */
 /* U+2523 */ 0xe2, 0x94, 0xa3, 0xff,     /* BOX_T_LTEE        */
 /* U+252b */ 0xe2, 0x94, 0xab, 0xff,     /* BOX_T_RTEE        */
 /* U+2501 */ 0xe2, 0x94, 0x81, 0xff,     /* BOX_T_HLINE       */
 /* U+2503 */ 0xe2, 0x94, 0x83, 0xff,     /* BOX_T_VLINE       */
 /* U+254b */ 0xe2, 0x95, 0x8b, 0xff,     /* BOX_T_PLUS        */
 /* U+23ba */ 0xe2, 0x8e, 0xba, 0xff,     /* Horiz scan line 1 */
 /* U+23bb */ 0xe2, 0x8e, 0xbb, 0xff,     /* Horiz scan line 3 */
 /* U+23bc */ 0xe2, 0x8e, 0xbc, 0xff,     /* Horiz scan line 7 */
 /* U+23bd */ 0xe2, 0x8e, 0xbd, 0xff      /* Horiz scan line 9 */
};
