/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_pw86.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t33, t37, t38, t40, t41, t42, t43;
  double t44, t45, t47, t51, t53, t54, t55, t56;
  double t60, t61, t65, tzk0;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = params->aa * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t37 = t20 * t20;
  t38 = params->bb * t37;
  t40 = 0.1e1 / t23 / t22;
  t41 = t38 * t40;
  t42 = sigma[0] * sigma[0];
  t43 = t42 * t27;
  t44 = t30 * t30;
  t45 = t44 * rho[0];
  t47 = 0.1e1 / t18 / t45;
  t51 = t22 * t22;
  t53 = params->cc / t51;
  t54 = t42 * sigma[0];
  t55 = t44 * t44;
  t56 = 0.1e1 / t55;
  t60 = 0.1e1 + t26 * t29 * t33 / 0.24e2 + t41 * t43 * t47 / 0.288e3 + t53 * t54 * t56 / 0.576e3;
  t61 = pow(t60, 0.1e1 / 0.15e2);
  t65 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t61);
  tzk0 = 0.2e1 * t65;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t33, t37, t38, t40, t41, t42, t43;
  double t44, t45, t47, t51, t53, t54, t55, t56;
  double t60, t61, t65, tzk0;

  double t66, t71, t72, t73, t75, t76, t77, t78;
  double t79, t81, t85, t87, t91, t92, t96, t101;
  double tvrho0, t104, t108, t115, t119, tvsigma0;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = params->aa * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t37 = t20 * t20;
  t38 = params->bb * t37;
  t40 = 0.1e1 / t23 / t22;
  t41 = t38 * t40;
  t42 = sigma[0] * sigma[0];
  t43 = t42 * t27;
  t44 = t30 * t30;
  t45 = t44 * rho[0];
  t47 = 0.1e1 / t18 / t45;
  t51 = t22 * t22;
  t53 = params->cc / t51;
  t54 = t42 * sigma[0];
  t55 = t44 * t44;
  t56 = 0.1e1 / t55;
  t60 = 0.1e1 + t26 * t29 * t33 / 0.24e2 + t41 * t43 * t47 / 0.288e3 + t53 * t54 * t56 / 0.576e3;
  t61 = pow(t60, 0.1e1 / 0.15e2);
  t65 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t61);
  tzk0 = 0.2e1 * t65;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = 0.1e1 / t31;
  t71 = t6 * t17;
  t72 = t61 * t61;
  t73 = t72 * t72;
  t75 = t73 * t73;
  t76 = t75 * t73 * t72;
  t77 = 0.1e1 / t76;
  t78 = t18 * t77;
  t79 = t30 * rho[0];
  t81 = 0.1e1 / t31 / t79;
  t85 = t44 * t30;
  t87 = 0.1e1 / t18 / t85;
  t91 = t55 * rho[0];
  t92 = 0.1e1 / t91;
  t96 = -t26 * t29 * t81 / 0.9e1 - t41 * t43 * t87 / 0.54e2 - t53 * t54 * t92 / 0.72e2;
  t101 = my_piecewise3(t2, 0, -t6 * t17 * t66 * t61 / 0.8e1 - t71 * t78 * t96 / 0.4e2);
  tvrho0 = 0.2e1 * rho[0] * t101 + 0.2e1 * t65;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t104 = t25 * t28;
  t108 = sigma[0] * t27;
  t115 = t21 * t104 * t33 / 0.24e2 + t41 * t108 * t47 / 0.144e3 + t53 * t42 * t56 / 0.192e3;
  t119 = my_piecewise3(t2, 0, -t71 * t78 * t115 / 0.4e2);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t33, t37, t38, t40, t41, t42, t43;
  double t44, t45, t47, t51, t53, t54, t55, t56;
  double t60, t61, t65, tzk0;

  double t66, t71, t72, t73, t75, t76, t77, t78;
  double t79, t81, t85, t87, t91, t92, t96, t101;
  double tvrho0, t104, t108, t115, t119, tvsigma0;

  double t123, t128, t133, t134, t135, t140, t144, t146;
  double t151, t155, t160, tv2rho20, t166, t179, t184, tv2rhosigma0;
  double t187, t191, t198, t203, tv2sigma20;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = params->aa * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t37 = t20 * t20;
  t38 = params->bb * t37;
  t40 = 0.1e1 / t23 / t22;
  t41 = t38 * t40;
  t42 = sigma[0] * sigma[0];
  t43 = t42 * t27;
  t44 = t30 * t30;
  t45 = t44 * rho[0];
  t47 = 0.1e1 / t18 / t45;
  t51 = t22 * t22;
  t53 = params->cc / t51;
  t54 = t42 * sigma[0];
  t55 = t44 * t44;
  t56 = 0.1e1 / t55;
  t60 = 0.1e1 + t26 * t29 * t33 / 0.24e2 + t41 * t43 * t47 / 0.288e3 + t53 * t54 * t56 / 0.576e3;
  t61 = pow(t60, 0.1e1 / 0.15e2);
  t65 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t61);
  tzk0 = 0.2e1 * t65;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = 0.1e1 / t31;
  t71 = t6 * t17;
  t72 = t61 * t61;
  t73 = t72 * t72;
  t75 = t73 * t73;
  t76 = t75 * t73 * t72;
  t77 = 0.1e1 / t76;
  t78 = t18 * t77;
  t79 = t30 * rho[0];
  t81 = 0.1e1 / t31 / t79;
  t85 = t44 * t30;
  t87 = 0.1e1 / t18 / t85;
  t91 = t55 * rho[0];
  t92 = 0.1e1 / t91;
  t96 = -t26 * t29 * t81 / 0.9e1 - t41 * t43 * t87 / 0.54e2 - t53 * t54 * t92 / 0.72e2;
  t101 = my_piecewise3(t2, 0, -t6 * t17 * t66 * t61 / 0.8e1 - t71 * t78 * t96 / 0.4e2);
  tvrho0 = 0.2e1 * rho[0] * t101 + 0.2e1 * t65;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t104 = t25 * t28;
  t108 = sigma[0] * t27;
  t115 = t21 * t104 * t33 / 0.24e2 + t41 * t108 * t47 / 0.144e3 + t53 * t42 * t56 / 0.192e3;
  t119 = my_piecewise3(t2, 0, -t71 * t78 * t115 / 0.4e2);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t123 = 0.1e1 / t31 / rho[0];
  t128 = t66 * t77;
  t133 = 0.1e1 / t76 / t60;
  t134 = t18 * t133;
  t135 = t96 * t96;
  t140 = 0.1e1 / t31 / t44;
  t144 = t44 * t79;
  t146 = 0.1e1 / t18 / t144;
  t151 = 0.1e1 / t55 / t30;
  t155 = 0.11e2 / 0.27e2 * t26 * t29 * t140 + 0.19e2 / 0.162e3 * t41 * t43 * t146 + t53 * t54 * t151 / 0.8e1;
  t160 = my_piecewise3(t2, 0, t6 * t17 * t123 * t61 / 0.12e2 - t71 * t128 * t96 / 0.6e2 + 0.7e1 / 0.3e3 * t71 * t134 * t135 - t71 * t78 * t155 / 0.4e2);
  tv2rho20 = 0.2e1 * rho[0] * t160 + 0.4e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t166 = t115 * t96;
  t179 = -t21 * t104 * t81 / 0.9e1 - t41 * t108 * t87 / 0.27e2 - t53 * t42 * t92 / 0.24e2;
  t184 = my_piecewise3(t2, 0, -t71 * t128 * t115 / 0.12e3 + 0.7e1 / 0.3e3 * t71 * t134 * t166 - t71 * t78 * t179 / 0.4e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t184 + 0.2e1 * t119;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t187 = t115 * t115;
  t191 = t40 * t27;
  t198 = t38 * t191 * t47 / 0.144e3 + t53 * sigma[0] * t56 / 0.96e2;
  t203 = my_piecewise3(t2, 0, 0.7e1 / 0.3e3 * t71 * t134 * t187 - t71 * t78 * t198 / 0.4e2);
  tv2sigma20 = 0.2e1 * rho[0] * t203;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t33, t37, t38, t40, t41, t42, t43;
  double t44, t45, t47, t51, t53, t54, t55, t56;
  double t60, t61, t65, tzk0;

  double t66, t71, t72, t73, t75, t76, t77, t78;
  double t79, t81, t85, t87, t91, t92, t96, t101;
  double tvrho0, t104, t108, t115, t119, tvsigma0;

  double t123, t128, t133, t134, t135, t140, t144, t146;
  double t151, t155, t160, tv2rho20, t166, t179, t184, tv2rhosigma0;
  double t187, t191, t198, t203, tv2sigma20;

  double t210, t214, t221, t223, t224, t225, t229, t234;
  double t239, t244, t248, t253, tv3rho30, t266, t270, t274;
  double t287, t292, tv3rho2sigma0, t298, t302, t309, t319, t324;
  double tv3rhosigma20, t327, t331, t338, t340, t346, tv3sigma30;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = params->aa * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t37 = t20 * t20;
  t38 = params->bb * t37;
  t40 = 0.1e1 / t23 / t22;
  t41 = t38 * t40;
  t42 = sigma[0] * sigma[0];
  t43 = t42 * t27;
  t44 = t30 * t30;
  t45 = t44 * rho[0];
  t47 = 0.1e1 / t18 / t45;
  t51 = t22 * t22;
  t53 = params->cc / t51;
  t54 = t42 * sigma[0];
  t55 = t44 * t44;
  t56 = 0.1e1 / t55;
  t60 = 0.1e1 + t26 * t29 * t33 / 0.24e2 + t41 * t43 * t47 / 0.288e3 + t53 * t54 * t56 / 0.576e3;
  t61 = pow(t60, 0.1e1 / 0.15e2);
  t65 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t61);
  tzk0 = 0.2e1 * t65;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = 0.1e1 / t31;
  t71 = t6 * t17;
  t72 = t61 * t61;
  t73 = t72 * t72;
  t75 = t73 * t73;
  t76 = t75 * t73 * t72;
  t77 = 0.1e1 / t76;
  t78 = t18 * t77;
  t79 = t30 * rho[0];
  t81 = 0.1e1 / t31 / t79;
  t85 = t44 * t30;
  t87 = 0.1e1 / t18 / t85;
  t91 = t55 * rho[0];
  t92 = 0.1e1 / t91;
  t96 = -t26 * t29 * t81 / 0.9e1 - t41 * t43 * t87 / 0.54e2 - t53 * t54 * t92 / 0.72e2;
  t101 = my_piecewise3(t2, 0, -t6 * t17 * t66 * t61 / 0.8e1 - t71 * t78 * t96 / 0.4e2);
  tvrho0 = 0.2e1 * rho[0] * t101 + 0.2e1 * t65;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t104 = t25 * t28;
  t108 = sigma[0] * t27;
  t115 = t21 * t104 * t33 / 0.24e2 + t41 * t108 * t47 / 0.144e3 + t53 * t42 * t56 / 0.192e3;
  t119 = my_piecewise3(t2, 0, -t71 * t78 * t115 / 0.4e2);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t123 = 0.1e1 / t31 / rho[0];
  t128 = t66 * t77;
  t133 = 0.1e1 / t76 / t60;
  t134 = t18 * t133;
  t135 = t96 * t96;
  t140 = 0.1e1 / t31 / t44;
  t144 = t44 * t79;
  t146 = 0.1e1 / t18 / t144;
  t151 = 0.1e1 / t55 / t30;
  t155 = 0.11e2 / 0.27e2 * t26 * t29 * t140 + 0.19e2 / 0.162e3 * t41 * t43 * t146 + t53 * t54 * t151 / 0.8e1;
  t160 = my_piecewise3(t2, 0, t6 * t17 * t123 * t61 / 0.12e2 - t71 * t128 * t96 / 0.6e2 + 0.7e1 / 0.3e3 * t71 * t134 * t135 - t71 * t78 * t155 / 0.4e2);
  tv2rho20 = 0.2e1 * rho[0] * t160 + 0.4e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t166 = t115 * t96;
  t179 = -t21 * t104 * t81 / 0.9e1 - t41 * t108 * t87 / 0.27e2 - t53 * t42 * t92 / 0.24e2;
  t184 = my_piecewise3(t2, 0, -t71 * t128 * t115 / 0.12e3 + 0.7e1 / 0.3e3 * t71 * t134 * t166 - t71 * t78 * t179 / 0.4e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t184 + 0.2e1 * t119;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t187 = t115 * t115;
  t191 = t40 * t27;
  t198 = t38 * t191 * t47 / 0.144e3 + t53 * sigma[0] * t56 / 0.96e2;
  t203 = my_piecewise3(t2, 0, 0.7e1 / 0.3e3 * t71 * t134 * t187 - t71 * t78 * t198 / 0.4e2);
  tv2sigma20 = 0.2e1 * rho[0] * t203;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t210 = t123 * t77;
  t214 = t66 * t133;
  t221 = t60 * t60;
  t223 = 0.1e1 / t76 / t221;
  t224 = t18 * t223;
  t225 = t135 * t96;
  t229 = t96 * t155;
  t234 = 0.1e1 / t31 / t45;
  t239 = 0.1e1 / t18 / t55;
  t244 = 0.1e1 / t55 / t79;
  t248 = -0.154e3 / 0.81e2 * t26 * t29 * t234 - 0.209e3 / 0.243e3 * t41 * t43 * t239 - 0.5e1 / 0.4e1 * t53 * t54 * t244;
  t253 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t33 * t61 + t71 * t210 * t96 / 0.6e2 + 0.7e1 / 0.3e3 * t71 * t214 * t135 - t71 * t128 * t155 / 0.4e2 - 0.203e3 / 0.45e4 * t71 * t224 * t225 + 0.7e1 / 0.1e3 * t71 * t134 * t229 - t71 * t78 * t248 / 0.4e2);
  tv3rho30 = 0.2e1 * rho[0] * t253 + 0.6e1 * t160;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t266 = t115 * t135;
  t270 = t179 * t96;
  t274 = t115 * t155;
  t287 = 0.11e2 / 0.27e2 * t21 * t104 * t140 + 0.19e2 / 0.81e2 * t41 * t108 * t146 + 0.3e1 / 0.8e1 * t53 * t42 * t151;
  t292 = my_piecewise3(t2, 0, t71 * t210 * t115 / 0.18e3 + 0.7e1 / 0.45e3 * t71 * t214 * t166 - t71 * t128 * t179 / 0.6e2 - 0.203e3 / 0.45e4 * t71 * t224 * t266 + 0.7e1 / 0.15e3 * t71 * t134 * t270 + 0.7e1 / 0.3e3 * t71 * t134 * t274 - t71 * t78 * t287 / 0.4e2);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t292 + 0.4e1 * t184;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t298 = t187 * t96;
  t302 = t115 * t179;
  t309 = t198 * t96;
  t319 = -t38 * t191 * t87 / 0.27e2 - t53 * sigma[0] * t92 / 0.12e2;
  t324 = my_piecewise3(t2, 0, 0.7e1 / 0.9e3 * t71 * t214 * t187 - 0.203e3 / 0.45e4 * t71 * t224 * t298 + 0.7e1 / 0.15e3 * t71 * t134 * t302 - t71 * t128 * t198 / 0.12e3 + 0.7e1 / 0.3e3 * t71 * t134 * t309 - t71 * t78 * t319 / 0.4e2);
  tv3rhosigma20 = 0.2e1 * rho[0] * t324 + 0.2e1 * t203;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t327 = t187 * t115;
  t331 = t115 * t198;
  t338 = t3 / t4 / t51 * t17;
  t340 = 0.1e1 / t31 / t144;
  t346 = my_piecewise3(t2, 0, -0.203e3 / 0.45e4 * t71 * t224 * t327 + 0.7e1 / 0.1e3 * t71 * t134 * t331 - t338 * t340 * t77 * params->cc / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t346;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t29, t30;
  double t31, t33, t37, t38, t40, t41, t42, t43;
  double t44, t45, t47, t51, t53, t54, t55, t56;
  double t60, t61, t65, tzk0;

  double t66, t71, t72, t73, t75, t76, t77, t78;
  double t79, t81, t85, t87, t91, t92, t96, t101;
  double tvrho0, t104, t108, t115, t119, tvsigma0;

  double t123, t128, t133, t134, t135, t140, t144, t146;
  double t151, t155, t160, tv2rho20, t166, t179, t184, tv2rhosigma0;
  double t187, t191, t198, t203, tv2sigma20;

  double t210, t214, t221, t223, t224, t225, t229, t234;
  double t239, t244, t248, t253, tv3rho30, t266, t270, t274;
  double t287, t292, tv3rho2sigma0, t298, t302, t309, t319, t324;
  double tv3rhosigma20, t327, t331, t338, t340, t346, tv3sigma30;

  double t353, t357, t364, t377, t378, t386, t413, t414;
  double tv4rho40, t444, t445, t477, t478, tv4rho3sigma0, t502, t541;
  double t542, tv4rho2sigma20, t576, t582, tv4rhosigma30, t585, t593, t602;
  double tv4sigma40;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = M_CBRT6;
  t21 = params->aa * t20;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t18 * t18;
  t33 = 0.1e1 / t31 / t30;
  t37 = t20 * t20;
  t38 = params->bb * t37;
  t40 = 0.1e1 / t23 / t22;
  t41 = t38 * t40;
  t42 = sigma[0] * sigma[0];
  t43 = t42 * t27;
  t44 = t30 * t30;
  t45 = t44 * rho[0];
  t47 = 0.1e1 / t18 / t45;
  t51 = t22 * t22;
  t53 = params->cc / t51;
  t54 = t42 * sigma[0];
  t55 = t44 * t44;
  t56 = 0.1e1 / t55;
  t60 = 0.1e1 + t26 * t29 * t33 / 0.24e2 + t41 * t43 * t47 / 0.288e3 + t53 * t54 * t56 / 0.576e3;
  t61 = pow(t60, 0.1e1 / 0.15e2);
  t65 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t61);
  tzk0 = 0.2e1 * t65;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t66 = 0.1e1 / t31;
  t71 = t6 * t17;
  t72 = t61 * t61;
  t73 = t72 * t72;
  t75 = t73 * t73;
  t76 = t75 * t73 * t72;
  t77 = 0.1e1 / t76;
  t78 = t18 * t77;
  t79 = t30 * rho[0];
  t81 = 0.1e1 / t31 / t79;
  t85 = t44 * t30;
  t87 = 0.1e1 / t18 / t85;
  t91 = t55 * rho[0];
  t92 = 0.1e1 / t91;
  t96 = -t26 * t29 * t81 / 0.9e1 - t41 * t43 * t87 / 0.54e2 - t53 * t54 * t92 / 0.72e2;
  t101 = my_piecewise3(t2, 0, -t6 * t17 * t66 * t61 / 0.8e1 - t71 * t78 * t96 / 0.4e2);
  tvrho0 = 0.2e1 * rho[0] * t101 + 0.2e1 * t65;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t104 = t25 * t28;
  t108 = sigma[0] * t27;
  t115 = t21 * t104 * t33 / 0.24e2 + t41 * t108 * t47 / 0.144e3 + t53 * t42 * t56 / 0.192e3;
  t119 = my_piecewise3(t2, 0, -t71 * t78 * t115 / 0.4e2);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t123 = 0.1e1 / t31 / rho[0];
  t128 = t66 * t77;
  t133 = 0.1e1 / t76 / t60;
  t134 = t18 * t133;
  t135 = t96 * t96;
  t140 = 0.1e1 / t31 / t44;
  t144 = t44 * t79;
  t146 = 0.1e1 / t18 / t144;
  t151 = 0.1e1 / t55 / t30;
  t155 = 0.11e2 / 0.27e2 * t26 * t29 * t140 + 0.19e2 / 0.162e3 * t41 * t43 * t146 + t53 * t54 * t151 / 0.8e1;
  t160 = my_piecewise3(t2, 0, t6 * t17 * t123 * t61 / 0.12e2 - t71 * t128 * t96 / 0.6e2 + 0.7e1 / 0.3e3 * t71 * t134 * t135 - t71 * t78 * t155 / 0.4e2);
  tv2rho20 = 0.2e1 * rho[0] * t160 + 0.4e1 * t101;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t166 = t115 * t96;
  t179 = -t21 * t104 * t81 / 0.9e1 - t41 * t108 * t87 / 0.27e2 - t53 * t42 * t92 / 0.24e2;
  t184 = my_piecewise3(t2, 0, -t71 * t128 * t115 / 0.12e3 + 0.7e1 / 0.3e3 * t71 * t134 * t166 - t71 * t78 * t179 / 0.4e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t184 + 0.2e1 * t119;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t187 = t115 * t115;
  t191 = t40 * t27;
  t198 = t38 * t191 * t47 / 0.144e3 + t53 * sigma[0] * t56 / 0.96e2;
  t203 = my_piecewise3(t2, 0, 0.7e1 / 0.3e3 * t71 * t134 * t187 - t71 * t78 * t198 / 0.4e2);
  tv2sigma20 = 0.2e1 * rho[0] * t203;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t210 = t123 * t77;
  t214 = t66 * t133;
  t221 = t60 * t60;
  t223 = 0.1e1 / t76 / t221;
  t224 = t18 * t223;
  t225 = t135 * t96;
  t229 = t96 * t155;
  t234 = 0.1e1 / t31 / t45;
  t239 = 0.1e1 / t18 / t55;
  t244 = 0.1e1 / t55 / t79;
  t248 = -0.154e3 / 0.81e2 * t26 * t29 * t234 - 0.209e3 / 0.243e3 * t41 * t43 * t239 - 0.5e1 / 0.4e1 * t53 * t54 * t244;
  t253 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t33 * t61 + t71 * t210 * t96 / 0.6e2 + 0.7e1 / 0.3e3 * t71 * t214 * t135 - t71 * t128 * t155 / 0.4e2 - 0.203e3 / 0.45e4 * t71 * t224 * t225 + 0.7e1 / 0.1e3 * t71 * t134 * t229 - t71 * t78 * t248 / 0.4e2);
  tv3rho30 = 0.2e1 * rho[0] * t253 + 0.6e1 * t160;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t266 = t115 * t135;
  t270 = t179 * t96;
  t274 = t115 * t155;
  t287 = 0.11e2 / 0.27e2 * t21 * t104 * t140 + 0.19e2 / 0.81e2 * t41 * t108 * t146 + 0.3e1 / 0.8e1 * t53 * t42 * t151;
  t292 = my_piecewise3(t2, 0, t71 * t210 * t115 / 0.18e3 + 0.7e1 / 0.45e3 * t71 * t214 * t166 - t71 * t128 * t179 / 0.6e2 - 0.203e3 / 0.45e4 * t71 * t224 * t266 + 0.7e1 / 0.15e3 * t71 * t134 * t270 + 0.7e1 / 0.3e3 * t71 * t134 * t274 - t71 * t78 * t287 / 0.4e2);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t292 + 0.4e1 * t184;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t298 = t187 * t96;
  t302 = t115 * t179;
  t309 = t198 * t96;
  t319 = -t38 * t191 * t87 / 0.27e2 - t53 * sigma[0] * t92 / 0.12e2;
  t324 = my_piecewise3(t2, 0, 0.7e1 / 0.9e3 * t71 * t214 * t187 - 0.203e3 / 0.45e4 * t71 * t224 * t298 + 0.7e1 / 0.15e3 * t71 * t134 * t302 - t71 * t128 * t198 / 0.12e3 + 0.7e1 / 0.3e3 * t71 * t134 * t309 - t71 * t78 * t319 / 0.4e2);
  tv3rhosigma20 = 0.2e1 * rho[0] * t324 + 0.2e1 * t203;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t327 = t187 * t115;
  t331 = t115 * t198;
  t338 = t3 / t4 / t51 * t17;
  t340 = 0.1e1 / t31 / t144;
  t346 = my_piecewise3(t2, 0, -0.203e3 / 0.45e4 * t71 * t224 * t327 + 0.7e1 / 0.1e3 * t71 * t134 * t331 - t338 * t340 * t77 * params->cc / 0.384e4);
  tv3sigma30 = 0.2e1 * rho[0] * t346;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t353 = t33 * t77;
  t357 = t123 * t133;
  t364 = t66 * t223;
  t377 = t18 / t76 / t221 / t60;
  t378 = t135 * t135;
  t386 = t155 * t155;
  t413 = 0.1e2 / 0.27e2 * t6 * t17 * t81 * t61 - t71 * t353 * t96 / 0.27e2 - 0.7e1 / 0.225e3 * t71 * t357 * t135 + t71 * t210 * t155 / 0.3e2 - 0.203e3 / 0.3375e4 * t71 * t364 * t225 + 0.7e1 / 0.75e2 * t71 * t214 * t229 - t71 * t128 * t248 / 0.3e2 + 0.2233e4 / 0.16875e5 * t71 * t377 * t378 - 0.203e3 / 0.75e3 * t71 * t224 * t135 * t155 + 0.7e1 / 0.1e3 * t71 * t134 * t386 + 0.7e1 / 0.75e2 * t71 * t134 * t96 * t248 - t71 * t78 * (0.2618e4 / 0.243e3 * t26 * t29 / t31 / t85 + 0.5225e4 / 0.729e3 * t41 * t43 / t18 / t91 + 0.55e2 / 0.4e1 * t53 * t54 / t55 / t44) / 0.4e2;
  t414 = my_piecewise3(t2, 0, t413);
  tv4rho40 = 0.2e1 * rho[0] * t414 + 0.8e1 * t253;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t444 = t6 * t19;
  t445 = t223 * t115;
  t477 = t71 * t210 * t179 / 0.6e2 - t71 * t128 * t287 / 0.4e2 - t71 * t78 * (-0.154e3 / 0.81e2 * t21 * t104 * t234 - 0.418e3 / 0.243e3 * t41 * t108 * t239 - 0.15e2 / 0.4e1 * t53 * t42 * t244) / 0.4e2 - 0.203e3 / 0.45e4 * t71 * t364 * t266 + 0.2233e4 / 0.16875e5 * t71 * t377 * t115 * t225 - 0.203e3 / 0.15e4 * t444 * t445 * t229 + 0.7e1 / 0.15e3 * t71 * t214 * t270 + 0.7e1 / 0.3e3 * t71 * t214 * t274 - 0.203e3 / 0.15e4 * t71 * t224 * t179 * t135 + 0.7e1 / 0.1e3 * t71 * t134 * t287 * t96 + 0.7e1 / 0.1e3 * t71 * t134 * t179 * t155 + 0.7e1 / 0.3e3 * t71 * t134 * t115 * t248 - t71 * t353 * t115 / 0.108e3 - 0.7e1 / 0.45e3 * t71 * t357 * t166;
  t478 = my_piecewise3(t2, 0, t477);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t478 + 0.6e1 * t292;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t502 = t179 * t179;
  t541 = -0.7e1 / 0.135e4 * t71 * t357 * t187 - 0.203e3 / 0.675e4 * t71 * t364 * t298 + 0.7e1 / 0.225e3 * t71 * t214 * t302 + 0.2233e4 / 0.16875e5 * t71 * t377 * t187 * t135 - 0.203e3 / 0.1125e4 * t444 * t445 * t270 - 0.203e3 / 0.45e4 * t71 * t224 * t187 * t155 + 0.7e1 / 0.15e3 * t71 * t134 * t502 + 0.7e1 / 0.15e3 * t71 * t134 * t115 * t287 + t71 * t210 * t198 / 0.18e3 + 0.7e1 / 0.45e3 * t71 * t214 * t309 - t71 * t128 * t319 / 0.6e2 - 0.203e3 / 0.45e4 * t71 * t224 * t198 * t135 + 0.7e1 / 0.15e3 * t71 * t134 * t319 * t96 + 0.7e1 / 0.3e3 * t71 * t134 * t198 * t155 - t71 * t78 * (0.19e2 / 0.81e2 * t38 * t191 * t146 + 0.3e1 / 0.4e1 * t53 * sigma[0] * t151) / 0.4e2;
  t542 = my_piecewise3(t2, 0, t541);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t542 + 0.4e1 * t324;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t576 = t340 * t133;
  t582 = my_piecewise3(t2, 0, -0.203e3 / 0.135e5 * t71 * t364 * t327 + 0.2233e4 / 0.16875e5 * t71 * t377 * t327 * t96 - 0.203e3 / 0.15e4 * t71 * t224 * t187 * t179 + 0.7e1 / 0.3e3 * t71 * t214 * t331 - 0.203e3 / 0.15e4 * t444 * t445 * t309 + 0.7e1 / 0.1e3 * t71 * t134 * t179 * t198 + 0.7e1 / 0.1e3 * t71 * t134 * t115 * t319 + 0.23e2 / 0.1152e5 * t338 / t31 / t55 * t77 * params->cc + 0.7e1 / 0.288e5 * t338 * t576 * params->cc * t96);
  tv4rhosigma30 = 0.2e1 * rho[0] * t582 + 0.2e1 * t346;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t585 = t187 * t187;
  t593 = t198 * t198;
  t602 = my_piecewise3(t2, 0, 0.2233e4 / 0.16875e5 * t71 * t377 * t585 - 0.203e3 / 0.75e3 * t71 * t224 * t187 * t198 + 0.7e1 / 0.1e3 * t71 * t134 * t593 + 0.7e1 / 0.72e4 * t338 * t576 * t115 * params->cc);
  tv4sigma40 = 0.2e1 * rho[0] * t602;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t43;
  double t44, t46, t47, t48, t49, t50, t52, t56;
  double t58, t59, t60, t61, t65, t66, t70, t71;
  double t72, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t84, t86, t90, t91, t92, t93;
  double t95, t99, t100, t101, t105, t106, t110, tzk0;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->aa * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t33 * sigma[0];
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t43 = t28 * t28;
  t44 = params->bb * t43;
  t46 = 0.1e1 / t31 / t30;
  t47 = sigma[0] * sigma[0];
  t48 = t46 * t47;
  t49 = t35 * t35;
  t50 = t49 * rho[0];
  t52 = 0.1e1 / t36 / t50;
  t56 = t30 * t30;
  t58 = params->cc / t56;
  t59 = t47 * sigma[0];
  t60 = t49 * t49;
  t61 = 0.1e1 / t60;
  t65 = 0.1e1 + t29 * t34 * t39 / 0.24e2 + t44 * t48 * t52 / 0.576e3 + t58 * t59 * t61 / 0.2304e4;
  t66 = pow(t65, 0.1e1 / 0.15e2);
  t70 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t66);
  t71 = rho[1] <= p->dens_threshold;
  t72 = -t16;
  t74 = my_piecewise5(t14, t11, t10, t15, t72 * t7);
  t75 = 0.1e1 + t74;
  t76 = t75 <= p->zeta_threshold;
  t77 = POW_1_3(t75);
  t79 = my_piecewise3(t76, t22, t77 * t75);
  t80 = t79 * t26;
  t81 = t33 * sigma[2];
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t86 = 0.1e1 / t84 / t82;
  t90 = sigma[2] * sigma[2];
  t91 = t46 * t90;
  t92 = t82 * t82;
  t93 = t92 * rho[1];
  t95 = 0.1e1 / t83 / t93;
  t99 = t90 * sigma[2];
  t100 = t92 * t92;
  t101 = 0.1e1 / t100;
  t105 = 0.1e1 + t29 * t81 * t86 / 0.24e2 + t44 * t91 * t95 / 0.576e3 + t58 * t99 * t101 / 0.2304e4;
  t106 = pow(t105, 0.1e1 / 0.15e2);
  t110 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t80 * t106);
  tzk0 = t70 + t110;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t43;
  double t44, t46, t47, t48, t49, t50, t52, t56;
  double t58, t59, t60, t61, t65, t66, t70, t71;
  double t72, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t84, t86, t90, t91, t92, t93;
  double t95, t99, t100, t101, t105, t106, t110, tzk0;

  double t111, t112, t113, t115, t118, t123, t124, t128;
  double t129, t130, t131, t133, t134, t135, t136, t137;
  double t139, t143, t145, t149, t150, t154, t155, t159;
  double t160, t162, t165, t173, t175, tvrho0, t179, t182;
  double t188, t190, t193, t198, t199, t200, t202, t203;
  double t204, t205, t206, t208, t212, t214, t218, t219;
  double t223, t224, t228, tvrho1, t234, t241, t242, t245;
  double tvsigma0, tvsigma1, t249, t256, t257, t260, tvsigma2;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->aa * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t33 * sigma[0];
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t43 = t28 * t28;
  t44 = params->bb * t43;
  t46 = 0.1e1 / t31 / t30;
  t47 = sigma[0] * sigma[0];
  t48 = t46 * t47;
  t49 = t35 * t35;
  t50 = t49 * rho[0];
  t52 = 0.1e1 / t36 / t50;
  t56 = t30 * t30;
  t58 = params->cc / t56;
  t59 = t47 * sigma[0];
  t60 = t49 * t49;
  t61 = 0.1e1 / t60;
  t65 = 0.1e1 + t29 * t34 * t39 / 0.24e2 + t44 * t48 * t52 / 0.576e3 + t58 * t59 * t61 / 0.2304e4;
  t66 = pow(t65, 0.1e1 / 0.15e2);
  t70 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t66);
  t71 = rho[1] <= p->dens_threshold;
  t72 = -t16;
  t74 = my_piecewise5(t14, t11, t10, t15, t72 * t7);
  t75 = 0.1e1 + t74;
  t76 = t75 <= p->zeta_threshold;
  t77 = POW_1_3(t75);
  t79 = my_piecewise3(t76, t22, t77 * t75);
  t80 = t79 * t26;
  t81 = t33 * sigma[2];
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t86 = 0.1e1 / t84 / t82;
  t90 = sigma[2] * sigma[2];
  t91 = t46 * t90;
  t92 = t82 * t82;
  t93 = t92 * rho[1];
  t95 = 0.1e1 / t83 / t93;
  t99 = t90 * sigma[2];
  t100 = t92 * t92;
  t101 = 0.1e1 / t100;
  t105 = 0.1e1 + t29 * t81 * t86 / 0.24e2 + t44 * t91 * t95 / 0.576e3 + t58 * t99 * t101 / 0.2304e4;
  t106 = pow(t105, 0.1e1 / 0.15e2);
  t110 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t80 * t106);
  tzk0 = t70 + t110;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t111 = t6 * t6;
  t112 = 0.1e1 / t111;
  t113 = t16 * t112;
  t115 = my_piecewise5(t10, 0, t14, 0, t7 - t113);
  t118 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t115);
  t123 = t26 * t26;
  t124 = 0.1e1 / t123;
  t128 = t5 * t25 * t124 * t66 / 0.8e1;
  t129 = t5 * t25;
  t130 = t66 * t66;
  t131 = t130 * t130;
  t133 = t131 * t131;
  t134 = t133 * t131 * t130;
  t135 = 0.1e1 / t134;
  t136 = t26 * t135;
  t137 = t35 * rho[0];
  t139 = 0.1e1 / t37 / t137;
  t143 = t49 * t35;
  t145 = 0.1e1 / t36 / t143;
  t149 = t60 * rho[0];
  t150 = 0.1e1 / t149;
  t154 = -t29 * t34 * t139 / 0.9e1 - t44 * t48 * t145 / 0.108e3 - t58 * t59 * t150 / 0.288e3;
  t155 = t136 * t154;
  t159 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t118 * t26 * t66 - t128 - t129 * t155 / 0.4e2);
  t160 = t72 * t112;
  t162 = my_piecewise5(t14, 0, t10, 0, -t7 - t160);
  t165 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t162);
  t173 = t5 * t79 * t124 * t106 / 0.8e1;
  t175 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t165 * t26 * t106 - t173);
  tvrho0 = t70 + t110 + t6 * (t159 + t175);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t179 = my_piecewise5(t10, 0, t14, 0, -t7 - t113);
  t182 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t179);
  t188 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t182 * t26 * t66 - t128);
  t190 = my_piecewise5(t14, 0, t10, 0, t7 - t160);
  t193 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t190);
  t198 = t5 * t79;
  t199 = t106 * t106;
  t200 = t199 * t199;
  t202 = t200 * t200;
  t203 = t202 * t200 * t199;
  t204 = 0.1e1 / t203;
  t205 = t26 * t204;
  t206 = t82 * rho[1];
  t208 = 0.1e1 / t84 / t206;
  t212 = t92 * t82;
  t214 = 0.1e1 / t83 / t212;
  t218 = t100 * rho[1];
  t219 = 0.1e1 / t218;
  t223 = -t29 * t81 * t208 / 0.9e1 - t44 * t91 * t214 / 0.108e3 - t58 * t99 * t219 / 0.288e3;
  t224 = t205 * t223;
  t228 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t193 * t26 * t106 - t173 - t198 * t224 / 0.4e2);
  tvrho1 = t70 + t110 + t6 * (t188 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t234 = t46 * sigma[0];
  t241 = t29 * t33 * t39 / 0.24e2 + t44 * t234 * t52 / 0.288e3 + t58 * t47 * t61 / 0.768e3;
  t242 = t136 * t241;
  t245 = my_piecewise3(t1, 0, -t129 * t242 / 0.4e2);
  tvsigma0 = t6 * t245;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t249 = t46 * sigma[2];
  t256 = t29 * t33 * t86 / 0.24e2 + t44 * t249 * t95 / 0.288e3 + t58 * t90 * t101 / 0.768e3;
  t257 = t205 * t256;
  t260 = my_piecewise3(t71, 0, -t198 * t257 / 0.4e2);
  tvsigma2 = t6 * t260;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t43;
  double t44, t46, t47, t48, t49, t50, t52, t56;
  double t58, t59, t60, t61, t65, t66, t70, t71;
  double t72, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t84, t86, t90, t91, t92, t93;
  double t95, t99, t100, t101, t105, t106, t110, tzk0;

  double t111, t112, t113, t115, t118, t123, t124, t128;
  double t129, t130, t131, t133, t134, t135, t136, t137;
  double t139, t143, t145, t149, t150, t154, t155, t159;
  double t160, t162, t165, t173, t175, tvrho0, t179, t182;
  double t188, t190, t193, t198, t199, t200, t202, t203;
  double t204, t205, t206, t208, t212, t214, t218, t219;
  double t223, t224, t228, tvrho1, t234, t241, t242, t245;
  double tvsigma0, tvsigma1, t249, t256, t257, t260, tvsigma2;

  double t263, t264, t265, t268, t269, t270, t273, t277;
  double t284, t286, t290, t294, t295, t296, t297, t300;
  double t301, t302, t303, t307, t313, t318, t322, t323;
  double t327, t328, t329, t330, t333, t336, t340, t347;
  double t352, t354, tv2rho20, t357, t361, t365, t372, t374;
  double t380, t381, t385, t389, t396, t399, t402, t403;
  double t404, t407, tv2rho21, t412, t417, t421, t428, t429;
  double t434, t438, t444, t449, t450, t451, t452, t456;
  double t462, t467, t471, t472, t476, tv2rho22, t481, t483;
  double t484, t485, t497, t498, t502, tv2rhosigma0, tv2rhosigma1, t506;
  double t508, t510, tv2rhosigma2, t515, tv2rhosigma3, tv2rhosigma4, t519, t520;
  double t532, t533, t537, tv2rhosigma5, t539, t540, t549, t550;
  double t554, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t555, t556;
  double t565, t566, t570, tv2sigma25;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->aa * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t33 * sigma[0];
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t43 = t28 * t28;
  t44 = params->bb * t43;
  t46 = 0.1e1 / t31 / t30;
  t47 = sigma[0] * sigma[0];
  t48 = t46 * t47;
  t49 = t35 * t35;
  t50 = t49 * rho[0];
  t52 = 0.1e1 / t36 / t50;
  t56 = t30 * t30;
  t58 = params->cc / t56;
  t59 = t47 * sigma[0];
  t60 = t49 * t49;
  t61 = 0.1e1 / t60;
  t65 = 0.1e1 + t29 * t34 * t39 / 0.24e2 + t44 * t48 * t52 / 0.576e3 + t58 * t59 * t61 / 0.2304e4;
  t66 = pow(t65, 0.1e1 / 0.15e2);
  t70 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t66);
  t71 = rho[1] <= p->dens_threshold;
  t72 = -t16;
  t74 = my_piecewise5(t14, t11, t10, t15, t72 * t7);
  t75 = 0.1e1 + t74;
  t76 = t75 <= p->zeta_threshold;
  t77 = POW_1_3(t75);
  t79 = my_piecewise3(t76, t22, t77 * t75);
  t80 = t79 * t26;
  t81 = t33 * sigma[2];
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t86 = 0.1e1 / t84 / t82;
  t90 = sigma[2] * sigma[2];
  t91 = t46 * t90;
  t92 = t82 * t82;
  t93 = t92 * rho[1];
  t95 = 0.1e1 / t83 / t93;
  t99 = t90 * sigma[2];
  t100 = t92 * t92;
  t101 = 0.1e1 / t100;
  t105 = 0.1e1 + t29 * t81 * t86 / 0.24e2 + t44 * t91 * t95 / 0.576e3 + t58 * t99 * t101 / 0.2304e4;
  t106 = pow(t105, 0.1e1 / 0.15e2);
  t110 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t80 * t106);
  tzk0 = t70 + t110;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t111 = t6 * t6;
  t112 = 0.1e1 / t111;
  t113 = t16 * t112;
  t115 = my_piecewise5(t10, 0, t14, 0, t7 - t113);
  t118 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t115);
  t123 = t26 * t26;
  t124 = 0.1e1 / t123;
  t128 = t5 * t25 * t124 * t66 / 0.8e1;
  t129 = t5 * t25;
  t130 = t66 * t66;
  t131 = t130 * t130;
  t133 = t131 * t131;
  t134 = t133 * t131 * t130;
  t135 = 0.1e1 / t134;
  t136 = t26 * t135;
  t137 = t35 * rho[0];
  t139 = 0.1e1 / t37 / t137;
  t143 = t49 * t35;
  t145 = 0.1e1 / t36 / t143;
  t149 = t60 * rho[0];
  t150 = 0.1e1 / t149;
  t154 = -t29 * t34 * t139 / 0.9e1 - t44 * t48 * t145 / 0.108e3 - t58 * t59 * t150 / 0.288e3;
  t155 = t136 * t154;
  t159 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t118 * t26 * t66 - t128 - t129 * t155 / 0.4e2);
  t160 = t72 * t112;
  t162 = my_piecewise5(t14, 0, t10, 0, -t7 - t160);
  t165 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t162);
  t173 = t5 * t79 * t124 * t106 / 0.8e1;
  t175 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t165 * t26 * t106 - t173);
  tvrho0 = t70 + t110 + t6 * (t159 + t175);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t179 = my_piecewise5(t10, 0, t14, 0, -t7 - t113);
  t182 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t179);
  t188 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t182 * t26 * t66 - t128);
  t190 = my_piecewise5(t14, 0, t10, 0, t7 - t160);
  t193 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t190);
  t198 = t5 * t79;
  t199 = t106 * t106;
  t200 = t199 * t199;
  t202 = t200 * t200;
  t203 = t202 * t200 * t199;
  t204 = 0.1e1 / t203;
  t205 = t26 * t204;
  t206 = t82 * rho[1];
  t208 = 0.1e1 / t84 / t206;
  t212 = t92 * t82;
  t214 = 0.1e1 / t83 / t212;
  t218 = t100 * rho[1];
  t219 = 0.1e1 / t218;
  t223 = -t29 * t81 * t208 / 0.9e1 - t44 * t91 * t214 / 0.108e3 - t58 * t99 * t219 / 0.288e3;
  t224 = t205 * t223;
  t228 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t193 * t26 * t106 - t173 - t198 * t224 / 0.4e2);
  tvrho1 = t70 + t110 + t6 * (t188 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t234 = t46 * sigma[0];
  t241 = t29 * t33 * t39 / 0.24e2 + t44 * t234 * t52 / 0.288e3 + t58 * t47 * t61 / 0.768e3;
  t242 = t136 * t241;
  t245 = my_piecewise3(t1, 0, -t129 * t242 / 0.4e2);
  tvsigma0 = t6 * t245;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t249 = t46 * sigma[2];
  t256 = t29 * t33 * t86 / 0.24e2 + t44 * t249 * t95 / 0.288e3 + t58 * t90 * t101 / 0.768e3;
  t257 = t205 * t256;
  t260 = my_piecewise3(t71, 0, -t198 * t257 / 0.4e2);
  tvsigma2 = t6 * t260;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t263 = t23 * t23;
  t264 = 0.1e1 / t263;
  t265 = t115 * t115;
  t268 = t111 * t6;
  t269 = 0.1e1 / t268;
  t270 = t16 * t269;
  t273 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t112 + 0.2e1 * t270);
  t277 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t265 + 0.4e1 / 0.3e1 * t23 * t273);
  t284 = t5 * t118 * t124 * t66;
  t286 = t5 * t118;
  t290 = 0.1e1 / t123 / t6;
  t294 = t5 * t25 * t290 * t66 / 0.12e2;
  t295 = t124 * t135;
  t296 = t295 * t154;
  t297 = t129 * t296;
  t300 = 0.1e1 / t134 / t65;
  t301 = t26 * t300;
  t302 = t154 * t154;
  t303 = t301 * t302;
  t307 = 0.1e1 / t37 / t49;
  t313 = 0.1e1 / t36 / t49 / t137;
  t318 = 0.1e1 / t60 / t35;
  t322 = 0.11e2 / 0.27e2 * t29 * t34 * t307 + 0.19e2 / 0.324e3 * t44 * t48 * t313 + t58 * t59 * t318 / 0.32e2;
  t323 = t136 * t322;
  t327 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t26 * t66 - t284 / 0.4e1 - t286 * t155 / 0.2e2 + t294 - t297 / 0.6e2 + 0.7e1 / 0.3e3 * t129 * t303 - t129 * t323 / 0.4e2);
  t328 = t77 * t77;
  t329 = 0.1e1 / t328;
  t330 = t162 * t162;
  t333 = t72 * t269;
  t336 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t112 + 0.2e1 * t333);
  t340 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t330 + 0.4e1 / 0.3e1 * t77 * t336);
  t347 = t5 * t165 * t124 * t106;
  t352 = t5 * t79 * t290 * t106 / 0.12e2;
  t354 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t340 * t26 * t106 - t347 / 0.4e1 + t352);
  tv2rho20 = 0.2e1 * t159 + 0.2e1 * t175 + t6 * (t327 + t354);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t357 = t264 * t179;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t270);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t357 * t115 + 0.4e1 / 0.3e1 * t23 * t361);
  t372 = t5 * t182 * t124 * t66;
  t374 = t5 * t182;
  t380 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t365 * t26 * t66 - t372 / 0.8e1 - t374 * t155 / 0.4e2 - t284 / 0.8e1 + t294 - t297 / 0.12e3);
  t381 = t329 * t190;
  t385 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t333);
  t389 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t381 * t162 + 0.4e1 / 0.3e1 * t77 * t385);
  t396 = t5 * t193 * t124 * t106;
  t399 = t5 * t165;
  t402 = t124 * t204;
  t403 = t402 * t223;
  t404 = t198 * t403;
  t407 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t389 * t26 * t106 - t396 / 0.8e1 - t347 / 0.8e1 + t352 - t399 * t224 / 0.4e2 - t404 / 0.12e3);
  tv2rho21 = t159 + t175 + t188 + t228 + t6 * (t380 + t407);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t412 = t179 * t179;
  t417 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t112 + 0.2e1 * t270);
  t421 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t412 + 0.4e1 / 0.3e1 * t23 * t417);
  t428 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t421 * t26 * t66 - t372 / 0.4e1 + t294);
  t429 = t190 * t190;
  t434 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t112 + 0.2e1 * t333);
  t438 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t429 + 0.4e1 / 0.3e1 * t77 * t434);
  t444 = t5 * t193;
  t449 = 0.1e1 / t203 / t105;
  t450 = t26 * t449;
  t451 = t223 * t223;
  t452 = t450 * t451;
  t456 = 0.1e1 / t84 / t92;
  t462 = 0.1e1 / t83 / t92 / t206;
  t467 = 0.1e1 / t100 / t82;
  t471 = 0.11e2 / 0.27e2 * t29 * t81 * t456 + 0.19e2 / 0.324e3 * t44 * t91 * t462 + t58 * t99 * t467 / 0.32e2;
  t472 = t205 * t471;
  t476 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t438 * t26 * t106 - t396 / 0.4e1 - t444 * t224 / 0.2e2 + t352 - t404 / 0.6e2 + 0.7e1 / 0.3e3 * t198 * t452 - t198 * t472 / 0.4e2);
  tv2rho22 = 0.2e1 * t188 + 0.2e1 * t228 + t6 * (t428 + t476);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t481 = t295 * t241;
  t483 = t129 * t481 / 0.12e3;
  t484 = t241 * t154;
  t485 = t301 * t484;
  t497 = -t29 * t33 * t139 / 0.9e1 - t44 * t234 * t145 / 0.54e2 - t58 * t47 * t150 / 0.96e2;
  t498 = t136 * t497;
  t502 = my_piecewise3(t1, 0, -t286 * t242 / 0.4e2 - t483 + 0.7e1 / 0.3e3 * t129 * t485 - t129 * t498 / 0.4e2);
  tv2rhosigma0 = t6 * t502 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t506 = t402 * t256;
  t508 = t198 * t506 / 0.12e3;
  t510 = my_piecewise3(t71, 0, -t399 * t257 / 0.4e2 - t508);
  tv2rhosigma2 = t6 * t510 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t515 = my_piecewise3(t1, 0, -t374 * t242 / 0.4e2 - t483);
  tv2rhosigma3 = t6 * t515 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t519 = t256 * t223;
  t520 = t450 * t519;
  t532 = -t29 * t33 * t208 / 0.9e1 - t44 * t249 * t214 / 0.54e2 - t58 * t90 * t219 / 0.96e2;
  t533 = t205 * t532;
  t537 = my_piecewise3(t71, 0, -t444 * t257 / 0.4e2 - t508 + 0.7e1 / 0.3e3 * t198 * t520 - t198 * t533 / 0.4e2);
  tv2rhosigma5 = t6 * t537 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t539 = t241 * t241;
  t540 = t301 * t539;
  t549 = t44 * t46 * t52 / 0.288e3 + t58 * sigma[0] * t61 / 0.384e3;
  t550 = t136 * t549;
  t554 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t129 * t540 - t129 * t550 / 0.4e2);
  tv2sigma20 = t6 * t554;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t555 = t256 * t256;
  t556 = t450 * t555;
  t565 = t44 * t46 * t95 / 0.288e3 + t58 * sigma[2] * t101 / 0.384e3;
  t566 = t205 * t565;
  t570 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t198 * t556 - t198 * t566 / 0.4e2);
  tv2sigma25 = t6 * t570;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t43;
  double t44, t46, t47, t48, t49, t50, t52, t56;
  double t58, t59, t60, t61, t65, t66, t70, t71;
  double t72, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t84, t86, t90, t91, t92, t93;
  double t95, t99, t100, t101, t105, t106, t110, tzk0;

  double t111, t112, t113, t115, t118, t123, t124, t128;
  double t129, t130, t131, t133, t134, t135, t136, t137;
  double t139, t143, t145, t149, t150, t154, t155, t159;
  double t160, t162, t165, t173, t175, tvrho0, t179, t182;
  double t188, t190, t193, t198, t199, t200, t202, t203;
  double t204, t205, t206, t208, t212, t214, t218, t219;
  double t223, t224, t228, tvrho1, t234, t241, t242, t245;
  double tvsigma0, tvsigma1, t249, t256, t257, t260, tvsigma2;

  double t263, t264, t265, t268, t269, t270, t273, t277;
  double t284, t286, t290, t294, t295, t296, t297, t300;
  double t301, t302, t303, t307, t313, t318, t322, t323;
  double t327, t328, t329, t330, t333, t336, t340, t347;
  double t352, t354, tv2rho20, t357, t361, t365, t372, t374;
  double t380, t381, t385, t389, t396, t399, t402, t403;
  double t404, t407, tv2rho21, t412, t417, t421, t428, t429;
  double t434, t438, t444, t449, t450, t451, t452, t456;
  double t462, t467, t471, t472, t476, tv2rho22, t481, t483;
  double t484, t485, t497, t498, t502, tv2rhosigma0, tv2rhosigma1, t506;
  double t508, t510, tv2rhosigma2, t515, tv2rhosigma3, tv2rhosigma4, t519, t520;
  double t532, t533, t537, tv2rhosigma5, t539, t540, t549, t550;
  double t554, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t555, t556;
  double t565, t566, t570, tv2sigma25;

  double t574, t575, t578, t581, t582, t583, t586, t590;
  double t597, t598, t599, t601, t603, t604, t605, t606;
  double t609, t610, t615, t617, t622, t624, t629, t633;
  double t634, t635, t636, t638, t639, t642, t647, t652;
  double t656, t657, t660, t661, t663, t664, t667, t670;
  double t673, t677, t684, t688, t693, t695, tv3rho30, t698;
  double t699, t700, t703, t708, t709, t711, t715, t723;
  double t724, t729, t732, t743, t744, t745, t748, t753;
  double t755, t759, t767, t770, t774, t778, t779, t780;
  double t781, t784, tv3rho31, t787, t792, t796, t800, t807;
  double t809, t816, t817, t822, t826, t830, t837, t840;
  double t843, t849, t850, t851, t855, t856, t858, t859;
  double tv3rho32, t864, t871, t875, t883, t884, t890, t895;
  double t900, t904, t905, t908, t915, t919, t926, t928;
  double t929, t930, t931, t934, t935, t944, t945, tv3rho33;
  double t951, t957, t959, t960, t961, t963, t964, t966;
  double t967, t970, t971, t974, t975, t987, t988, t991;
  double t992, tv3rho2sigma0, tv3rho2sigma1, t997, t999, t1001, t1003, tv3rho2sigma2;
  double t1007, t1017, tv3rho2sigma3, tv3rho2sigma4, t1021, t1026, t1027, t1031;
  double t1032, t1035, tv3rho2sigma5, t1042, tv3rho2sigma6, tv3rho2sigma7, t1054, t1055;
  double t1058, t1059, t1062, t1063, t1075, t1076, t1079, t1080;
  double tv3rho2sigma8, t1084, t1086, t1087, t1088, t1091, t1092, t1097;
  double t1099, t1100, t1101, t1110, t1111, t1115, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1119, t1121, t1124, t1126, t1128;
  double tv3rhosigma25, t1135, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1139;
  double t1140, t1143, t1144, t1149, t1150, t1159, t1160, t1164;
  double tv3rhosigma211, t1166, t1167, t1170, t1171, t1176, t1177, t1178;
  double t1179, t1183, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1184, t1185, t1188, t1189, t1192;
  double t1193, t1194, t1198, tv3sigma39;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->aa * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t33 * sigma[0];
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t43 = t28 * t28;
  t44 = params->bb * t43;
  t46 = 0.1e1 / t31 / t30;
  t47 = sigma[0] * sigma[0];
  t48 = t46 * t47;
  t49 = t35 * t35;
  t50 = t49 * rho[0];
  t52 = 0.1e1 / t36 / t50;
  t56 = t30 * t30;
  t58 = params->cc / t56;
  t59 = t47 * sigma[0];
  t60 = t49 * t49;
  t61 = 0.1e1 / t60;
  t65 = 0.1e1 + t29 * t34 * t39 / 0.24e2 + t44 * t48 * t52 / 0.576e3 + t58 * t59 * t61 / 0.2304e4;
  t66 = pow(t65, 0.1e1 / 0.15e2);
  t70 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t66);
  t71 = rho[1] <= p->dens_threshold;
  t72 = -t16;
  t74 = my_piecewise5(t14, t11, t10, t15, t72 * t7);
  t75 = 0.1e1 + t74;
  t76 = t75 <= p->zeta_threshold;
  t77 = POW_1_3(t75);
  t79 = my_piecewise3(t76, t22, t77 * t75);
  t80 = t79 * t26;
  t81 = t33 * sigma[2];
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t86 = 0.1e1 / t84 / t82;
  t90 = sigma[2] * sigma[2];
  t91 = t46 * t90;
  t92 = t82 * t82;
  t93 = t92 * rho[1];
  t95 = 0.1e1 / t83 / t93;
  t99 = t90 * sigma[2];
  t100 = t92 * t92;
  t101 = 0.1e1 / t100;
  t105 = 0.1e1 + t29 * t81 * t86 / 0.24e2 + t44 * t91 * t95 / 0.576e3 + t58 * t99 * t101 / 0.2304e4;
  t106 = pow(t105, 0.1e1 / 0.15e2);
  t110 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t80 * t106);
  tzk0 = t70 + t110;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t111 = t6 * t6;
  t112 = 0.1e1 / t111;
  t113 = t16 * t112;
  t115 = my_piecewise5(t10, 0, t14, 0, t7 - t113);
  t118 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t115);
  t123 = t26 * t26;
  t124 = 0.1e1 / t123;
  t128 = t5 * t25 * t124 * t66 / 0.8e1;
  t129 = t5 * t25;
  t130 = t66 * t66;
  t131 = t130 * t130;
  t133 = t131 * t131;
  t134 = t133 * t131 * t130;
  t135 = 0.1e1 / t134;
  t136 = t26 * t135;
  t137 = t35 * rho[0];
  t139 = 0.1e1 / t37 / t137;
  t143 = t49 * t35;
  t145 = 0.1e1 / t36 / t143;
  t149 = t60 * rho[0];
  t150 = 0.1e1 / t149;
  t154 = -t29 * t34 * t139 / 0.9e1 - t44 * t48 * t145 / 0.108e3 - t58 * t59 * t150 / 0.288e3;
  t155 = t136 * t154;
  t159 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t118 * t26 * t66 - t128 - t129 * t155 / 0.4e2);
  t160 = t72 * t112;
  t162 = my_piecewise5(t14, 0, t10, 0, -t7 - t160);
  t165 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t162);
  t173 = t5 * t79 * t124 * t106 / 0.8e1;
  t175 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t165 * t26 * t106 - t173);
  tvrho0 = t70 + t110 + t6 * (t159 + t175);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t179 = my_piecewise5(t10, 0, t14, 0, -t7 - t113);
  t182 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t179);
  t188 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t182 * t26 * t66 - t128);
  t190 = my_piecewise5(t14, 0, t10, 0, t7 - t160);
  t193 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t190);
  t198 = t5 * t79;
  t199 = t106 * t106;
  t200 = t199 * t199;
  t202 = t200 * t200;
  t203 = t202 * t200 * t199;
  t204 = 0.1e1 / t203;
  t205 = t26 * t204;
  t206 = t82 * rho[1];
  t208 = 0.1e1 / t84 / t206;
  t212 = t92 * t82;
  t214 = 0.1e1 / t83 / t212;
  t218 = t100 * rho[1];
  t219 = 0.1e1 / t218;
  t223 = -t29 * t81 * t208 / 0.9e1 - t44 * t91 * t214 / 0.108e3 - t58 * t99 * t219 / 0.288e3;
  t224 = t205 * t223;
  t228 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t193 * t26 * t106 - t173 - t198 * t224 / 0.4e2);
  tvrho1 = t70 + t110 + t6 * (t188 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t234 = t46 * sigma[0];
  t241 = t29 * t33 * t39 / 0.24e2 + t44 * t234 * t52 / 0.288e3 + t58 * t47 * t61 / 0.768e3;
  t242 = t136 * t241;
  t245 = my_piecewise3(t1, 0, -t129 * t242 / 0.4e2);
  tvsigma0 = t6 * t245;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t249 = t46 * sigma[2];
  t256 = t29 * t33 * t86 / 0.24e2 + t44 * t249 * t95 / 0.288e3 + t58 * t90 * t101 / 0.768e3;
  t257 = t205 * t256;
  t260 = my_piecewise3(t71, 0, -t198 * t257 / 0.4e2);
  tvsigma2 = t6 * t260;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t263 = t23 * t23;
  t264 = 0.1e1 / t263;
  t265 = t115 * t115;
  t268 = t111 * t6;
  t269 = 0.1e1 / t268;
  t270 = t16 * t269;
  t273 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t112 + 0.2e1 * t270);
  t277 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t265 + 0.4e1 / 0.3e1 * t23 * t273);
  t284 = t5 * t118 * t124 * t66;
  t286 = t5 * t118;
  t290 = 0.1e1 / t123 / t6;
  t294 = t5 * t25 * t290 * t66 / 0.12e2;
  t295 = t124 * t135;
  t296 = t295 * t154;
  t297 = t129 * t296;
  t300 = 0.1e1 / t134 / t65;
  t301 = t26 * t300;
  t302 = t154 * t154;
  t303 = t301 * t302;
  t307 = 0.1e1 / t37 / t49;
  t313 = 0.1e1 / t36 / t49 / t137;
  t318 = 0.1e1 / t60 / t35;
  t322 = 0.11e2 / 0.27e2 * t29 * t34 * t307 + 0.19e2 / 0.324e3 * t44 * t48 * t313 + t58 * t59 * t318 / 0.32e2;
  t323 = t136 * t322;
  t327 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t26 * t66 - t284 / 0.4e1 - t286 * t155 / 0.2e2 + t294 - t297 / 0.6e2 + 0.7e1 / 0.3e3 * t129 * t303 - t129 * t323 / 0.4e2);
  t328 = t77 * t77;
  t329 = 0.1e1 / t328;
  t330 = t162 * t162;
  t333 = t72 * t269;
  t336 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t112 + 0.2e1 * t333);
  t340 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t330 + 0.4e1 / 0.3e1 * t77 * t336);
  t347 = t5 * t165 * t124 * t106;
  t352 = t5 * t79 * t290 * t106 / 0.12e2;
  t354 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t340 * t26 * t106 - t347 / 0.4e1 + t352);
  tv2rho20 = 0.2e1 * t159 + 0.2e1 * t175 + t6 * (t327 + t354);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t357 = t264 * t179;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t270);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t357 * t115 + 0.4e1 / 0.3e1 * t23 * t361);
  t372 = t5 * t182 * t124 * t66;
  t374 = t5 * t182;
  t380 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t365 * t26 * t66 - t372 / 0.8e1 - t374 * t155 / 0.4e2 - t284 / 0.8e1 + t294 - t297 / 0.12e3);
  t381 = t329 * t190;
  t385 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t333);
  t389 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t381 * t162 + 0.4e1 / 0.3e1 * t77 * t385);
  t396 = t5 * t193 * t124 * t106;
  t399 = t5 * t165;
  t402 = t124 * t204;
  t403 = t402 * t223;
  t404 = t198 * t403;
  t407 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t389 * t26 * t106 - t396 / 0.8e1 - t347 / 0.8e1 + t352 - t399 * t224 / 0.4e2 - t404 / 0.12e3);
  tv2rho21 = t159 + t175 + t188 + t228 + t6 * (t380 + t407);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t412 = t179 * t179;
  t417 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t112 + 0.2e1 * t270);
  t421 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t412 + 0.4e1 / 0.3e1 * t23 * t417);
  t428 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t421 * t26 * t66 - t372 / 0.4e1 + t294);
  t429 = t190 * t190;
  t434 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t112 + 0.2e1 * t333);
  t438 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t429 + 0.4e1 / 0.3e1 * t77 * t434);
  t444 = t5 * t193;
  t449 = 0.1e1 / t203 / t105;
  t450 = t26 * t449;
  t451 = t223 * t223;
  t452 = t450 * t451;
  t456 = 0.1e1 / t84 / t92;
  t462 = 0.1e1 / t83 / t92 / t206;
  t467 = 0.1e1 / t100 / t82;
  t471 = 0.11e2 / 0.27e2 * t29 * t81 * t456 + 0.19e2 / 0.324e3 * t44 * t91 * t462 + t58 * t99 * t467 / 0.32e2;
  t472 = t205 * t471;
  t476 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t438 * t26 * t106 - t396 / 0.4e1 - t444 * t224 / 0.2e2 + t352 - t404 / 0.6e2 + 0.7e1 / 0.3e3 * t198 * t452 - t198 * t472 / 0.4e2);
  tv2rho22 = 0.2e1 * t188 + 0.2e1 * t228 + t6 * (t428 + t476);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t481 = t295 * t241;
  t483 = t129 * t481 / 0.12e3;
  t484 = t241 * t154;
  t485 = t301 * t484;
  t497 = -t29 * t33 * t139 / 0.9e1 - t44 * t234 * t145 / 0.54e2 - t58 * t47 * t150 / 0.96e2;
  t498 = t136 * t497;
  t502 = my_piecewise3(t1, 0, -t286 * t242 / 0.4e2 - t483 + 0.7e1 / 0.3e3 * t129 * t485 - t129 * t498 / 0.4e2);
  tv2rhosigma0 = t6 * t502 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t506 = t402 * t256;
  t508 = t198 * t506 / 0.12e3;
  t510 = my_piecewise3(t71, 0, -t399 * t257 / 0.4e2 - t508);
  tv2rhosigma2 = t6 * t510 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t515 = my_piecewise3(t1, 0, -t374 * t242 / 0.4e2 - t483);
  tv2rhosigma3 = t6 * t515 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t519 = t256 * t223;
  t520 = t450 * t519;
  t532 = -t29 * t33 * t208 / 0.9e1 - t44 * t249 * t214 / 0.54e2 - t58 * t90 * t219 / 0.96e2;
  t533 = t205 * t532;
  t537 = my_piecewise3(t71, 0, -t444 * t257 / 0.4e2 - t508 + 0.7e1 / 0.3e3 * t198 * t520 - t198 * t533 / 0.4e2);
  tv2rhosigma5 = t6 * t537 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t539 = t241 * t241;
  t540 = t301 * t539;
  t549 = t44 * t46 * t52 / 0.288e3 + t58 * sigma[0] * t61 / 0.384e3;
  t550 = t136 * t549;
  t554 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t129 * t540 - t129 * t550 / 0.4e2);
  tv2sigma20 = t6 * t554;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t555 = t256 * t256;
  t556 = t450 * t555;
  t565 = t44 * t46 * t95 / 0.288e3 + t58 * sigma[2] * t101 / 0.384e3;
  t566 = t205 * t565;
  t570 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t198 * t556 - t198 * t566 / 0.4e2);
  tv2sigma25 = t6 * t570;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t574 = 0.1e1 / t263 / t19;
  t575 = t265 * t115;
  t578 = t264 * t115;
  t581 = t111 * t111;
  t582 = 0.1e1 / t581;
  t583 = t16 * t582;
  t586 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t269 - 0.6e1 * t583);
  t590 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t574 * t575 + 0.4e1 / 0.3e1 * t578 * t273 + 0.4e1 / 0.3e1 * t23 * t586);
  t597 = t124 * t300;
  t598 = t597 * t302;
  t599 = t129 * t598;
  t601 = t65 * t65;
  t603 = 0.1e1 / t134 / t601;
  t604 = t26 * t603;
  t605 = t302 * t154;
  t606 = t604 * t605;
  t609 = t154 * t322;
  t610 = t301 * t609;
  t615 = t5 * t277 * t124 * t66;
  t617 = t5 * t277;
  t622 = t5 * t118 * t290 * t66;
  t624 = t286 * t296;
  t629 = 0.1e1 / t123 / t111;
  t633 = 0.5e1 / 0.36e2 * t5 * t25 * t629 * t66;
  t634 = t290 * t135;
  t635 = t634 * t154;
  t636 = t129 * t635;
  t638 = t295 * t322;
  t639 = t129 * t638;
  t642 = 0.1e1 / t37 / t50;
  t647 = 0.1e1 / t36 / t60;
  t652 = 0.1e1 / t60 / t137;
  t656 = -0.154e3 / 0.81e2 * t29 * t34 * t642 - 0.209e3 / 0.486e3 * t44 * t48 * t647 - 0.5e1 / 0.16e2 * t58 * t59 * t652;
  t657 = t136 * t656;
  t660 = -0.3e1 / 0.8e1 * t5 * t590 * t26 * t66 + 0.7e1 / 0.1e3 * t286 * t303 + 0.7e1 / 0.3e3 * t599 - 0.203e3 / 0.45e4 * t129 * t606 + 0.7e1 / 0.1e3 * t129 * t610 - 0.3e1 / 0.8e1 * t615 - 0.3e1 / 0.4e2 * t617 * t155 + t622 / 0.4e1 - t624 / 0.2e2 - 0.3e1 / 0.4e2 * t286 * t323 - t633 + t636 / 0.6e2 - t639 / 0.4e2 - t129 * t657 / 0.4e2;
  t661 = my_piecewise3(t1, 0, t660);
  t663 = 0.1e1 / t328 / t75;
  t664 = t330 * t162;
  t667 = t329 * t162;
  t670 = t72 * t582;
  t673 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t269 - 0.6e1 * t670);
  t677 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t663 * t664 + 0.4e1 / 0.3e1 * t667 * t336 + 0.4e1 / 0.3e1 * t77 * t673);
  t684 = t5 * t340 * t124 * t106;
  t688 = t5 * t165 * t290 * t106;
  t693 = 0.5e1 / 0.36e2 * t5 * t79 * t629 * t106;
  t695 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t677 * t26 * t106 - 0.3e1 / 0.8e1 * t684 + t688 / 0.4e1 - t693);
  tv3rho30 = 0.3e1 * t327 + 0.3e1 * t354 + t6 * (t661 + t695);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t698 = 0.2e1 * t380;
  t699 = 0.2e1 * t407;
  t700 = t574 * t179;
  t703 = t264 * t361;
  t708 = 0.2e1 * t269;
  t709 = 0.6e1 * t583;
  t711 = my_piecewise5(t10, 0, t14, 0, t708 - t709);
  t715 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t700 * t265 + 0.8e1 / 0.9e1 * t703 * t115 + 0.4e1 / 0.9e1 * t357 * t273 + 0.4e1 / 0.3e1 * t23 * t711);
  t723 = t5 * t365 * t124 * t66 / 0.4e1;
  t724 = t5 * t365;
  t729 = t5 * t182 * t290 * t66;
  t732 = t374 * t296 / 0.6e2;
  t743 = -0.3e1 / 0.8e1 * t5 * t715 * t26 * t66 - t723 - t724 * t155 / 0.2e2 + t729 / 0.12e2 - t732 + 0.7e1 / 0.3e3 * t374 * t303 - t374 * t323 / 0.4e2 - t615 / 0.8e1 + t622 / 0.6e1 - t624 / 0.6e2 - t633 + t636 / 0.9e2 + 0.7e1 / 0.9e3 * t599 - t639 / 0.12e3;
  t744 = my_piecewise3(t1, 0, t743);
  t745 = t663 * t190;
  t748 = t329 * t385;
  t753 = 0.6e1 * t670;
  t755 = my_piecewise5(t14, 0, t10, 0, -t708 - t753);
  t759 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t745 * t330 + 0.8e1 / 0.9e1 * t748 * t162 + 0.4e1 / 0.9e1 * t381 * t336 + 0.4e1 / 0.3e1 * t77 * t755);
  t767 = t5 * t389 * t124 * t106 / 0.4e1;
  t770 = t5 * t193 * t290 * t106;
  t774 = t5 * t340;
  t778 = t399 * t403 / 0.6e2;
  t779 = t290 * t204;
  t780 = t779 * t223;
  t781 = t198 * t780;
  t784 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t759 * t26 * t106 - t767 + t770 / 0.12e2 - t684 / 0.8e1 + t688 / 0.6e1 - t693 - t774 * t224 / 0.4e2 - t778 + t781 / 0.18e3);
  tv3rho31 = t327 + t354 + t698 + t699 + t6 * (t744 + t784);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t787 = t574 * t412;
  t792 = t264 * t417;
  t796 = my_piecewise5(t10, 0, t14, 0, -t708 - t709);
  t800 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t787 * t115 + 0.8e1 / 0.9e1 * t357 * t361 + 0.4e1 / 0.9e1 * t792 * t115 + 0.4e1 / 0.3e1 * t23 * t796);
  t807 = t5 * t421 * t124 * t66;
  t809 = t5 * t421;
  t816 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t800 * t26 * t66 - t807 / 0.8e1 - t809 * t155 / 0.4e2 - t723 + t729 / 0.6e1 - t732 + t622 / 0.12e2 - t633 + t636 / 0.18e3);
  t817 = t663 * t429;
  t822 = t329 * t434;
  t826 = my_piecewise5(t14, 0, t10, 0, t708 - t753);
  t830 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t817 * t162 + 0.8e1 / 0.9e1 * t381 * t385 + 0.4e1 / 0.9e1 * t822 * t162 + 0.4e1 / 0.3e1 * t77 * t826);
  t837 = t5 * t438 * t124 * t106;
  t840 = t5 * t389;
  t843 = t444 * t403;
  t849 = t124 * t449;
  t850 = t849 * t451;
  t851 = t198 * t850;
  t855 = t402 * t471;
  t856 = t198 * t855;
  t858 = -0.3e1 / 0.8e1 * t5 * t830 * t26 * t106 - t837 / 0.8e1 - t767 + t770 / 0.6e1 - t840 * t224 / 0.2e2 - t843 / 0.6e2 + t688 / 0.12e2 - t693 - t778 + t781 / 0.9e2 + 0.7e1 / 0.3e3 * t399 * t452 + 0.7e1 / 0.9e3 * t851 - t399 * t472 / 0.4e2 - t856 / 0.12e3;
  t859 = my_piecewise3(t71, 0, t858);
  tv3rho32 = t698 + t699 + t428 + t476 + t6 * (t816 + t859);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t864 = t412 * t179;
  t871 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t269 - 0.6e1 * t583);
  t875 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t574 * t864 + 0.4e1 / 0.3e1 * t357 * t417 + 0.4e1 / 0.3e1 * t23 * t871);
  t883 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t875 * t26 * t66 - 0.3e1 / 0.8e1 * t807 + t729 / 0.4e1 - t633);
  t884 = t5 * t438;
  t890 = 0.1e1 / t84 / t93;
  t895 = 0.1e1 / t83 / t100;
  t900 = 0.1e1 / t100 / t206;
  t904 = -0.154e3 / 0.81e2 * t29 * t81 * t890 - 0.209e3 / 0.486e3 * t44 * t91 * t895 - 0.5e1 / 0.16e2 * t58 * t99 * t900;
  t905 = t205 * t904;
  t908 = t429 * t190;
  t915 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t269 - 0.6e1 * t670);
  t919 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t663 * t908 + 0.4e1 / 0.3e1 * t381 * t434 + 0.4e1 / 0.3e1 * t77 * t915);
  t926 = t105 * t105;
  t928 = 0.1e1 / t203 / t926;
  t929 = t26 * t928;
  t930 = t451 * t223;
  t931 = t929 * t930;
  t934 = t223 * t471;
  t935 = t450 * t934;
  t944 = -0.3e1 / 0.4e2 * t884 * t224 - 0.3e1 / 0.4e2 * t444 * t472 - t198 * t905 / 0.4e2 - 0.3e1 / 0.8e1 * t5 * t919 * t26 * t106 + 0.7e1 / 0.1e3 * t444 * t452 - 0.203e3 / 0.45e4 * t198 * t931 + 0.7e1 / 0.1e3 * t198 * t935 + t781 / 0.6e2 - t843 / 0.2e2 + 0.7e1 / 0.3e3 * t851 - t856 / 0.4e2 + t770 / 0.4e1 - 0.3e1 / 0.8e1 * t837 - t693;
  t945 = my_piecewise3(t71, 0, t944);
  tv3rho33 = 0.3e1 * t428 + 0.3e1 * t476 + t6 * (t883 + t945);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t951 = t286 * t481;
  t957 = t634 * t241;
  t959 = t129 * t957 / 0.18e3;
  t960 = t597 * t484;
  t961 = t129 * t960;
  t963 = t295 * t497;
  t964 = t129 * t963;
  t966 = t241 * t302;
  t967 = t604 * t966;
  t970 = t497 * t154;
  t971 = t301 * t970;
  t974 = t241 * t322;
  t975 = t301 * t974;
  t987 = 0.11e2 / 0.27e2 * t29 * t33 * t307 + 0.19e2 / 0.162e3 * t44 * t234 * t313 + 0.3e1 / 0.32e2 * t58 * t47 * t318;
  t988 = t136 * t987;
  t991 = -t617 * t242 / 0.4e2 - t951 / 0.6e2 + 0.7e1 / 0.15e3 * t286 * t485 - t286 * t498 / 0.2e2 + t959 + 0.7e1 / 0.45e3 * t961 - t964 / 0.6e2 - 0.203e3 / 0.45e4 * t129 * t967 + 0.7e1 / 0.15e3 * t129 * t971 + 0.7e1 / 0.3e3 * t129 * t975 - t129 * t988 / 0.4e2;
  t992 = my_piecewise3(t1, 0, t991);
  tv3rho2sigma0 = t6 * t992 + 0.2e1 * t502;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t997 = t399 * t506;
  t999 = t779 * t256;
  t1001 = t198 * t999 / 0.18e3;
  t1003 = my_piecewise3(t71, 0, -t774 * t257 / 0.4e2 - t997 / 0.6e2 + t1001);
  tv3rho2sigma2 = t6 * t1003 + 0.2e1 * t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1007 = t374 * t481;
  t1017 = my_piecewise3(t1, 0, -t724 * t242 / 0.4e2 - t1007 / 0.12e3 + 0.7e1 / 0.3e3 * t374 * t485 - t374 * t498 / 0.4e2 - t951 / 0.12e3 + t959 + 0.7e1 / 0.9e3 * t961 - t964 / 0.12e3);
  tv3rho2sigma3 = t6 * t1017 + t502 + t515;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1021 = t444 * t506;
  t1026 = t849 * t519;
  t1027 = t198 * t1026;
  t1031 = t402 * t532;
  t1032 = t198 * t1031;
  t1035 = my_piecewise3(t71, 0, -t840 * t257 / 0.4e2 - t1021 / 0.12e3 - t997 / 0.12e3 + t1001 + 0.7e1 / 0.3e3 * t399 * t520 + 0.7e1 / 0.9e3 * t1027 - t399 * t533 / 0.4e2 - t1032 / 0.12e3);
  tv3rho2sigma5 = t6 * t1035 + t510 + t537;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1042 = my_piecewise3(t1, 0, -t809 * t242 / 0.4e2 - t1007 / 0.6e2 + t959);
  tv3rho2sigma6 = t6 * t1042 + 0.2e1 * t515;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1054 = t256 * t451;
  t1055 = t929 * t1054;
  t1058 = t532 * t223;
  t1059 = t450 * t1058;
  t1062 = t256 * t471;
  t1063 = t450 * t1062;
  t1075 = 0.11e2 / 0.27e2 * t29 * t33 * t456 + 0.19e2 / 0.162e3 * t44 * t249 * t462 + 0.3e1 / 0.32e2 * t58 * t90 * t467;
  t1076 = t205 * t1075;
  t1079 = -t884 * t257 / 0.4e2 - t1021 / 0.6e2 + 0.7e1 / 0.15e3 * t444 * t520 - t444 * t533 / 0.2e2 + t1001 + 0.7e1 / 0.45e3 * t1027 - t1032 / 0.6e2 - 0.203e3 / 0.45e4 * t198 * t1055 + 0.7e1 / 0.15e3 * t198 * t1059 + 0.7e1 / 0.3e3 * t198 * t1063 - t198 * t1076 / 0.4e2;
  t1080 = my_piecewise3(t71, 0, t1079);
  tv3rho2sigma8 = t6 * t1080 + 0.2e1 * t537;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1084 = t597 * t539;
  t1086 = 0.7e1 / 0.9e3 * t129 * t1084;
  t1087 = t539 * t154;
  t1088 = t604 * t1087;
  t1091 = t241 * t497;
  t1092 = t301 * t1091;
  t1097 = t295 * t549;
  t1099 = t129 * t1097 / 0.12e3;
  t1100 = t549 * t154;
  t1101 = t301 * t1100;
  t1110 = -t44 * t46 * t145 / 0.54e2 - t58 * sigma[0] * t150 / 0.48e2;
  t1111 = t136 * t1110;
  t1115 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t286 * t540 + t1086 - 0.203e3 / 0.45e4 * t129 * t1088 + 0.7e1 / 0.15e3 * t129 * t1092 - t286 * t550 / 0.4e2 - t1099 + 0.7e1 / 0.3e3 * t129 * t1101 - t129 * t1111 / 0.4e2);
  tv3rhosigma20 = t6 * t1115 + t554;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1119 = t849 * t555;
  t1121 = 0.7e1 / 0.9e3 * t198 * t1119;
  t1124 = t402 * t565;
  t1126 = t198 * t1124 / 0.12e3;
  t1128 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t399 * t556 + t1121 - t399 * t566 / 0.4e2 - t1126);
  tv3rhosigma25 = t6 * t1128 + t570;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1135 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t374 * t540 + t1086 - t374 * t550 / 0.4e2 - t1099);
  tv3rhosigma26 = t6 * t1135 + t554;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1139 = t555 * t223;
  t1140 = t929 * t1139;
  t1143 = t256 * t532;
  t1144 = t450 * t1143;
  t1149 = t565 * t223;
  t1150 = t450 * t1149;
  t1159 = -t44 * t46 * t214 / 0.54e2 - t58 * sigma[2] * t219 / 0.48e2;
  t1160 = t205 * t1159;
  t1164 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t444 * t556 + t1121 - 0.203e3 / 0.45e4 * t198 * t1140 + 0.7e1 / 0.15e3 * t198 * t1144 - t444 * t566 / 0.4e2 - t1126 + 0.7e1 / 0.3e3 * t198 * t1150 - t198 * t1160 / 0.4e2);
  tv3rhosigma211 = t6 * t1164 + t570;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1166 = t539 * t241;
  t1167 = t604 * t1166;
  t1170 = t241 * t549;
  t1171 = t301 * t1170;
  t1176 = t2 / t3 / t56;
  t1177 = t1176 * t25;
  t1178 = params->cc * t61;
  t1179 = t136 * t1178;
  t1183 = my_piecewise3(t1, 0, -0.203e3 / 0.45e4 * t129 * t1167 + 0.7e1 / 0.1e3 * t129 * t1171 - t1177 * t1179 / 0.1536e5);
  tv3sigma30 = t6 * t1183;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1184 = t555 * t256;
  t1185 = t929 * t1184;
  t1188 = t256 * t565;
  t1189 = t450 * t1188;
  t1192 = t1176 * t79;
  t1193 = params->cc * t101;
  t1194 = t205 * t1193;
  t1198 = my_piecewise3(t71, 0, -0.203e3 / 0.45e4 * t198 * t1185 + 0.7e1 / 0.1e3 * t198 * t1189 - t1192 * t1194 / 0.1536e5);
  tv3sigma39 = t6 * t1198;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t32, t33, t34, t35, t36, t37, t39, t43;
  double t44, t46, t47, t48, t49, t50, t52, t56;
  double t58, t59, t60, t61, t65, t66, t70, t71;
  double t72, t74, t75, t76, t77, t79, t80, t81;
  double t82, t83, t84, t86, t90, t91, t92, t93;
  double t95, t99, t100, t101, t105, t106, t110, tzk0;

  double t111, t112, t113, t115, t118, t123, t124, t128;
  double t129, t130, t131, t133, t134, t135, t136, t137;
  double t139, t143, t145, t149, t150, t154, t155, t159;
  double t160, t162, t165, t173, t175, tvrho0, t179, t182;
  double t188, t190, t193, t198, t199, t200, t202, t203;
  double t204, t205, t206, t208, t212, t214, t218, t219;
  double t223, t224, t228, tvrho1, t234, t241, t242, t245;
  double tvsigma0, tvsigma1, t249, t256, t257, t260, tvsigma2;

  double t263, t264, t265, t268, t269, t270, t273, t277;
  double t284, t286, t290, t294, t295, t296, t297, t300;
  double t301, t302, t303, t307, t313, t318, t322, t323;
  double t327, t328, t329, t330, t333, t336, t340, t347;
  double t352, t354, tv2rho20, t357, t361, t365, t372, t374;
  double t380, t381, t385, t389, t396, t399, t402, t403;
  double t404, t407, tv2rho21, t412, t417, t421, t428, t429;
  double t434, t438, t444, t449, t450, t451, t452, t456;
  double t462, t467, t471, t472, t476, tv2rho22, t481, t483;
  double t484, t485, t497, t498, t502, tv2rhosigma0, tv2rhosigma1, t506;
  double t508, t510, tv2rhosigma2, t515, tv2rhosigma3, tv2rhosigma4, t519, t520;
  double t532, t533, t537, tv2rhosigma5, t539, t540, t549, t550;
  double t554, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t555, t556;
  double t565, t566, t570, tv2sigma25;

  double t574, t575, t578, t581, t582, t583, t586, t590;
  double t597, t598, t599, t601, t603, t604, t605, t606;
  double t609, t610, t615, t617, t622, t624, t629, t633;
  double t634, t635, t636, t638, t639, t642, t647, t652;
  double t656, t657, t660, t661, t663, t664, t667, t670;
  double t673, t677, t684, t688, t693, t695, tv3rho30, t698;
  double t699, t700, t703, t708, t709, t711, t715, t723;
  double t724, t729, t732, t743, t744, t745, t748, t753;
  double t755, t759, t767, t770, t774, t778, t779, t780;
  double t781, t784, tv3rho31, t787, t792, t796, t800, t807;
  double t809, t816, t817, t822, t826, t830, t837, t840;
  double t843, t849, t850, t851, t855, t856, t858, t859;
  double tv3rho32, t864, t871, t875, t883, t884, t890, t895;
  double t900, t904, t905, t908, t915, t919, t926, t928;
  double t929, t930, t931, t934, t935, t944, t945, tv3rho33;
  double t951, t957, t959, t960, t961, t963, t964, t966;
  double t967, t970, t971, t974, t975, t987, t988, t991;
  double t992, tv3rho2sigma0, tv3rho2sigma1, t997, t999, t1001, t1003, tv3rho2sigma2;
  double t1007, t1017, tv3rho2sigma3, tv3rho2sigma4, t1021, t1026, t1027, t1031;
  double t1032, t1035, tv3rho2sigma5, t1042, tv3rho2sigma6, tv3rho2sigma7, t1054, t1055;
  double t1058, t1059, t1062, t1063, t1075, t1076, t1079, t1080;
  double tv3rho2sigma8, t1084, t1086, t1087, t1088, t1091, t1092, t1097;
  double t1099, t1100, t1101, t1110, t1111, t1115, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1119, t1121, t1124, t1126, t1128;
  double tv3rhosigma25, t1135, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1139;
  double t1140, t1143, t1144, t1149, t1150, t1159, t1160, t1164;
  double tv3rhosigma211, t1166, t1167, t1170, t1171, t1176, t1177, t1178;
  double t1179, t1183, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t1184, t1185, t1188, t1189, t1192;
  double t1193, t1194, t1198, tv3sigma39;

  double t1201, t1205, t1209, t1211, t1213, t1215, t1220, t1221;
  double t1225, t1229, t1231, t1235, t1237, t1240, t1242, t1244;
  double t1265, t1271, t1284, t1288, t1291, t1295, t1299, t1301;
  double t1303, t1304, t1310, t1316, t1317, t1320, t1324, t1329;
  double t1331, t1332, t1334, t1335, t1341, t1346, t1349, t1353;
  double t1360, t1364, t1368, t1373, t1375, tv4rho40, t1380, t1386;
  double t1390, t1391, t1392, t1396, t1404, t1414, t1415, t1418;
  double t1436, t1437, t1439, t1443, t1450, t1455, t1457, t1474;
  double t1476, t1480, t1487, t1491, t1492, t1495, t1500, t1503;
  double t1505, t1506, t1507, t1509, t1511, t1512, tv4rho41, t1527;
  double t1540, t1544, t1551, t1553, t1558, t1560, t1580, t1582;
  double t1591, t1604, t1608, t1615, t1617, t1626, t1634, t1636;
  double t1638, t1640, t1642, t1644, t1647, t1652, t1654, tv4rho42;
  double t1675, t1679, t1686, t1688, t1697, t1698, t1699, t1701;
  double t1704, t1706, t1708, t1710, t1718, t1739, t1743, t1750;
  double t1754, t1766, t1769, t1771, tv4rho43, t1776, t1781, t1788;
  double t1792, t1801, t1805, t1806, t1810, t1818, t1849, t1850;
  double t1855, t1862, t1866, t1889, t1891, tv4rho44, t1897, t1898;
  double t1903, t1906, t1925, t1927, t1930, t1933, t1935, t1954;
  double t1961, t1966, t1972, t1973, t1977, t1979, tv4rho3sigma0, tv4rho3sigma1;
  double t1984, t1986, t1990, t1992, tv4rho3sigma2, t1994, t1996, t1999;
  double t2002, t2012, t2019, t2028, t2030, tv4rho3sigma3, tv4rho3sigma4, t2032;
  double t2036, t2037, t2044, t2046, t2051, t2053, t2055, t2056;
  double tv4rho3sigma5, t2060, t2070, t2071, tv4rho3sigma6, tv4rho3sigma7, t2075, t2080;
  double t2084, t2087, t2093, t2098, t2103, t2108, t2110, t2112;
  double tv4rho3sigma8, t2120, tv4rho3sigma9, tv4rho3sigma10, t2155, t2181, t2182, t2186;
  double t2188, tv4rho3sigma11, t2219, t2225, t2233, t2234, t2240, t2242;
  double t2252, t2260, t2262, t2265, t2267, t2269, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2274, t2278, t2281, t2285, t2287;
  double tv4rho2sigma25, t2291, t2302, t2311, t2312, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28;
  double tv4rho2sigma29, tv4rho2sigma210, t2316, t2322, t2327, t2331, t2337, t2342;
  double t2344, t2345, tv4rho2sigma211, t2355, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215;
  double tv4rho2sigma216, t2392, t2393, t2418, t2420, tv4rho2sigma217, t2426, t2439;
  double t2456, t2457, t2467, t2468, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33;
  double tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2474, t2479, t2485;
  double t2487, tv4rhosigma39, t2497, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314;
  double tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2525, t2535, t2536, tv4rhosigma319;
  double t2538, t2546, t2555, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44;
  double tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412;
  double tv4sigma413, t2556, t2564, t2573, tv4sigma414;

  gga_x_pw86_params *params;

  assert(p->params != NULL);
  params = (gga_x_pw86_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = M_CBRT6;
  t29 = params->aa * t28;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t33 * sigma[0];
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t43 = t28 * t28;
  t44 = params->bb * t43;
  t46 = 0.1e1 / t31 / t30;
  t47 = sigma[0] * sigma[0];
  t48 = t46 * t47;
  t49 = t35 * t35;
  t50 = t49 * rho[0];
  t52 = 0.1e1 / t36 / t50;
  t56 = t30 * t30;
  t58 = params->cc / t56;
  t59 = t47 * sigma[0];
  t60 = t49 * t49;
  t61 = 0.1e1 / t60;
  t65 = 0.1e1 + t29 * t34 * t39 / 0.24e2 + t44 * t48 * t52 / 0.576e3 + t58 * t59 * t61 / 0.2304e4;
  t66 = pow(t65, 0.1e1 / 0.15e2);
  t70 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t66);
  t71 = rho[1] <= p->dens_threshold;
  t72 = -t16;
  t74 = my_piecewise5(t14, t11, t10, t15, t72 * t7);
  t75 = 0.1e1 + t74;
  t76 = t75 <= p->zeta_threshold;
  t77 = POW_1_3(t75);
  t79 = my_piecewise3(t76, t22, t77 * t75);
  t80 = t79 * t26;
  t81 = t33 * sigma[2];
  t82 = rho[1] * rho[1];
  t83 = POW_1_3(rho[1]);
  t84 = t83 * t83;
  t86 = 0.1e1 / t84 / t82;
  t90 = sigma[2] * sigma[2];
  t91 = t46 * t90;
  t92 = t82 * t82;
  t93 = t92 * rho[1];
  t95 = 0.1e1 / t83 / t93;
  t99 = t90 * sigma[2];
  t100 = t92 * t92;
  t101 = 0.1e1 / t100;
  t105 = 0.1e1 + t29 * t81 * t86 / 0.24e2 + t44 * t91 * t95 / 0.576e3 + t58 * t99 * t101 / 0.2304e4;
  t106 = pow(t105, 0.1e1 / 0.15e2);
  t110 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t80 * t106);
  tzk0 = t70 + t110;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t111 = t6 * t6;
  t112 = 0.1e1 / t111;
  t113 = t16 * t112;
  t115 = my_piecewise5(t10, 0, t14, 0, t7 - t113);
  t118 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t115);
  t123 = t26 * t26;
  t124 = 0.1e1 / t123;
  t128 = t5 * t25 * t124 * t66 / 0.8e1;
  t129 = t5 * t25;
  t130 = t66 * t66;
  t131 = t130 * t130;
  t133 = t131 * t131;
  t134 = t133 * t131 * t130;
  t135 = 0.1e1 / t134;
  t136 = t26 * t135;
  t137 = t35 * rho[0];
  t139 = 0.1e1 / t37 / t137;
  t143 = t49 * t35;
  t145 = 0.1e1 / t36 / t143;
  t149 = t60 * rho[0];
  t150 = 0.1e1 / t149;
  t154 = -t29 * t34 * t139 / 0.9e1 - t44 * t48 * t145 / 0.108e3 - t58 * t59 * t150 / 0.288e3;
  t155 = t136 * t154;
  t159 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t118 * t26 * t66 - t128 - t129 * t155 / 0.4e2);
  t160 = t72 * t112;
  t162 = my_piecewise5(t14, 0, t10, 0, -t7 - t160);
  t165 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t162);
  t173 = t5 * t79 * t124 * t106 / 0.8e1;
  t175 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t165 * t26 * t106 - t173);
  tvrho0 = t70 + t110 + t6 * (t159 + t175);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t179 = my_piecewise5(t10, 0, t14, 0, -t7 - t113);
  t182 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t179);
  t188 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t182 * t26 * t66 - t128);
  t190 = my_piecewise5(t14, 0, t10, 0, t7 - t160);
  t193 = my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t190);
  t198 = t5 * t79;
  t199 = t106 * t106;
  t200 = t199 * t199;
  t202 = t200 * t200;
  t203 = t202 * t200 * t199;
  t204 = 0.1e1 / t203;
  t205 = t26 * t204;
  t206 = t82 * rho[1];
  t208 = 0.1e1 / t84 / t206;
  t212 = t92 * t82;
  t214 = 0.1e1 / t83 / t212;
  t218 = t100 * rho[1];
  t219 = 0.1e1 / t218;
  t223 = -t29 * t81 * t208 / 0.9e1 - t44 * t91 * t214 / 0.108e3 - t58 * t99 * t219 / 0.288e3;
  t224 = t205 * t223;
  t228 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t193 * t26 * t106 - t173 - t198 * t224 / 0.4e2);
  tvrho1 = t70 + t110 + t6 * (t188 + t228);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t234 = t46 * sigma[0];
  t241 = t29 * t33 * t39 / 0.24e2 + t44 * t234 * t52 / 0.288e3 + t58 * t47 * t61 / 0.768e3;
  t242 = t136 * t241;
  t245 = my_piecewise3(t1, 0, -t129 * t242 / 0.4e2);
  tvsigma0 = t6 * t245;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t249 = t46 * sigma[2];
  t256 = t29 * t33 * t86 / 0.24e2 + t44 * t249 * t95 / 0.288e3 + t58 * t90 * t101 / 0.768e3;
  t257 = t205 * t256;
  t260 = my_piecewise3(t71, 0, -t198 * t257 / 0.4e2);
  tvsigma2 = t6 * t260;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t263 = t23 * t23;
  t264 = 0.1e1 / t263;
  t265 = t115 * t115;
  t268 = t111 * t6;
  t269 = 0.1e1 / t268;
  t270 = t16 * t269;
  t273 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t112 + 0.2e1 * t270);
  t277 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t265 + 0.4e1 / 0.3e1 * t23 * t273);
  t284 = t5 * t118 * t124 * t66;
  t286 = t5 * t118;
  t290 = 0.1e1 / t123 / t6;
  t294 = t5 * t25 * t290 * t66 / 0.12e2;
  t295 = t124 * t135;
  t296 = t295 * t154;
  t297 = t129 * t296;
  t300 = 0.1e1 / t134 / t65;
  t301 = t26 * t300;
  t302 = t154 * t154;
  t303 = t301 * t302;
  t307 = 0.1e1 / t37 / t49;
  t313 = 0.1e1 / t36 / t49 / t137;
  t318 = 0.1e1 / t60 / t35;
  t322 = 0.11e2 / 0.27e2 * t29 * t34 * t307 + 0.19e2 / 0.324e3 * t44 * t48 * t313 + t58 * t59 * t318 / 0.32e2;
  t323 = t136 * t322;
  t327 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t26 * t66 - t284 / 0.4e1 - t286 * t155 / 0.2e2 + t294 - t297 / 0.6e2 + 0.7e1 / 0.3e3 * t129 * t303 - t129 * t323 / 0.4e2);
  t328 = t77 * t77;
  t329 = 0.1e1 / t328;
  t330 = t162 * t162;
  t333 = t72 * t269;
  t336 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t112 + 0.2e1 * t333);
  t340 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t330 + 0.4e1 / 0.3e1 * t77 * t336);
  t347 = t5 * t165 * t124 * t106;
  t352 = t5 * t79 * t290 * t106 / 0.12e2;
  t354 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t340 * t26 * t106 - t347 / 0.4e1 + t352);
  tv2rho20 = 0.2e1 * t159 + 0.2e1 * t175 + t6 * (t327 + t354);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t357 = t264 * t179;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t270);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t357 * t115 + 0.4e1 / 0.3e1 * t23 * t361);
  t372 = t5 * t182 * t124 * t66;
  t374 = t5 * t182;
  t380 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t365 * t26 * t66 - t372 / 0.8e1 - t374 * t155 / 0.4e2 - t284 / 0.8e1 + t294 - t297 / 0.12e3);
  t381 = t329 * t190;
  t385 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t333);
  t389 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t381 * t162 + 0.4e1 / 0.3e1 * t77 * t385);
  t396 = t5 * t193 * t124 * t106;
  t399 = t5 * t165;
  t402 = t124 * t204;
  t403 = t402 * t223;
  t404 = t198 * t403;
  t407 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t389 * t26 * t106 - t396 / 0.8e1 - t347 / 0.8e1 + t352 - t399 * t224 / 0.4e2 - t404 / 0.12e3);
  tv2rho21 = t159 + t175 + t188 + t228 + t6 * (t380 + t407);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t412 = t179 * t179;
  t417 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t112 + 0.2e1 * t270);
  t421 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t264 * t412 + 0.4e1 / 0.3e1 * t23 * t417);
  t428 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t421 * t26 * t66 - t372 / 0.4e1 + t294);
  t429 = t190 * t190;
  t434 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t112 + 0.2e1 * t333);
  t438 = my_piecewise3(t76, 0, 0.4e1 / 0.9e1 * t329 * t429 + 0.4e1 / 0.3e1 * t77 * t434);
  t444 = t5 * t193;
  t449 = 0.1e1 / t203 / t105;
  t450 = t26 * t449;
  t451 = t223 * t223;
  t452 = t450 * t451;
  t456 = 0.1e1 / t84 / t92;
  t462 = 0.1e1 / t83 / t92 / t206;
  t467 = 0.1e1 / t100 / t82;
  t471 = 0.11e2 / 0.27e2 * t29 * t81 * t456 + 0.19e2 / 0.324e3 * t44 * t91 * t462 + t58 * t99 * t467 / 0.32e2;
  t472 = t205 * t471;
  t476 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t438 * t26 * t106 - t396 / 0.4e1 - t444 * t224 / 0.2e2 + t352 - t404 / 0.6e2 + 0.7e1 / 0.3e3 * t198 * t452 - t198 * t472 / 0.4e2);
  tv2rho22 = 0.2e1 * t188 + 0.2e1 * t228 + t6 * (t428 + t476);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t481 = t295 * t241;
  t483 = t129 * t481 / 0.12e3;
  t484 = t241 * t154;
  t485 = t301 * t484;
  t497 = -t29 * t33 * t139 / 0.9e1 - t44 * t234 * t145 / 0.54e2 - t58 * t47 * t150 / 0.96e2;
  t498 = t136 * t497;
  t502 = my_piecewise3(t1, 0, -t286 * t242 / 0.4e2 - t483 + 0.7e1 / 0.3e3 * t129 * t485 - t129 * t498 / 0.4e2);
  tv2rhosigma0 = t6 * t502 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t506 = t402 * t256;
  t508 = t198 * t506 / 0.12e3;
  t510 = my_piecewise3(t71, 0, -t399 * t257 / 0.4e2 - t508);
  tv2rhosigma2 = t6 * t510 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t515 = my_piecewise3(t1, 0, -t374 * t242 / 0.4e2 - t483);
  tv2rhosigma3 = t6 * t515 + t245;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t519 = t256 * t223;
  t520 = t450 * t519;
  t532 = -t29 * t33 * t208 / 0.9e1 - t44 * t249 * t214 / 0.54e2 - t58 * t90 * t219 / 0.96e2;
  t533 = t205 * t532;
  t537 = my_piecewise3(t71, 0, -t444 * t257 / 0.4e2 - t508 + 0.7e1 / 0.3e3 * t198 * t520 - t198 * t533 / 0.4e2);
  tv2rhosigma5 = t6 * t537 + t260;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t539 = t241 * t241;
  t540 = t301 * t539;
  t549 = t44 * t46 * t52 / 0.288e3 + t58 * sigma[0] * t61 / 0.384e3;
  t550 = t136 * t549;
  t554 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t129 * t540 - t129 * t550 / 0.4e2);
  tv2sigma20 = t6 * t554;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t555 = t256 * t256;
  t556 = t450 * t555;
  t565 = t44 * t46 * t95 / 0.288e3 + t58 * sigma[2] * t101 / 0.384e3;
  t566 = t205 * t565;
  t570 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t198 * t556 - t198 * t566 / 0.4e2);
  tv2sigma25 = t6 * t570;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t574 = 0.1e1 / t263 / t19;
  t575 = t265 * t115;
  t578 = t264 * t115;
  t581 = t111 * t111;
  t582 = 0.1e1 / t581;
  t583 = t16 * t582;
  t586 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t269 - 0.6e1 * t583);
  t590 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t574 * t575 + 0.4e1 / 0.3e1 * t578 * t273 + 0.4e1 / 0.3e1 * t23 * t586);
  t597 = t124 * t300;
  t598 = t597 * t302;
  t599 = t129 * t598;
  t601 = t65 * t65;
  t603 = 0.1e1 / t134 / t601;
  t604 = t26 * t603;
  t605 = t302 * t154;
  t606 = t604 * t605;
  t609 = t154 * t322;
  t610 = t301 * t609;
  t615 = t5 * t277 * t124 * t66;
  t617 = t5 * t277;
  t622 = t5 * t118 * t290 * t66;
  t624 = t286 * t296;
  t629 = 0.1e1 / t123 / t111;
  t633 = 0.5e1 / 0.36e2 * t5 * t25 * t629 * t66;
  t634 = t290 * t135;
  t635 = t634 * t154;
  t636 = t129 * t635;
  t638 = t295 * t322;
  t639 = t129 * t638;
  t642 = 0.1e1 / t37 / t50;
  t647 = 0.1e1 / t36 / t60;
  t652 = 0.1e1 / t60 / t137;
  t656 = -0.154e3 / 0.81e2 * t29 * t34 * t642 - 0.209e3 / 0.486e3 * t44 * t48 * t647 - 0.5e1 / 0.16e2 * t58 * t59 * t652;
  t657 = t136 * t656;
  t660 = -0.3e1 / 0.8e1 * t5 * t590 * t26 * t66 + 0.7e1 / 0.1e3 * t286 * t303 + 0.7e1 / 0.3e3 * t599 - 0.203e3 / 0.45e4 * t129 * t606 + 0.7e1 / 0.1e3 * t129 * t610 - 0.3e1 / 0.8e1 * t615 - 0.3e1 / 0.4e2 * t617 * t155 + t622 / 0.4e1 - t624 / 0.2e2 - 0.3e1 / 0.4e2 * t286 * t323 - t633 + t636 / 0.6e2 - t639 / 0.4e2 - t129 * t657 / 0.4e2;
  t661 = my_piecewise3(t1, 0, t660);
  t663 = 0.1e1 / t328 / t75;
  t664 = t330 * t162;
  t667 = t329 * t162;
  t670 = t72 * t582;
  t673 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t269 - 0.6e1 * t670);
  t677 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t663 * t664 + 0.4e1 / 0.3e1 * t667 * t336 + 0.4e1 / 0.3e1 * t77 * t673);
  t684 = t5 * t340 * t124 * t106;
  t688 = t5 * t165 * t290 * t106;
  t693 = 0.5e1 / 0.36e2 * t5 * t79 * t629 * t106;
  t695 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t677 * t26 * t106 - 0.3e1 / 0.8e1 * t684 + t688 / 0.4e1 - t693);
  tv3rho30 = 0.3e1 * t327 + 0.3e1 * t354 + t6 * (t661 + t695);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t698 = 0.2e1 * t380;
  t699 = 0.2e1 * t407;
  t700 = t574 * t179;
  t703 = t264 * t361;
  t708 = 0.2e1 * t269;
  t709 = 0.6e1 * t583;
  t711 = my_piecewise5(t10, 0, t14, 0, t708 - t709);
  t715 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t700 * t265 + 0.8e1 / 0.9e1 * t703 * t115 + 0.4e1 / 0.9e1 * t357 * t273 + 0.4e1 / 0.3e1 * t23 * t711);
  t723 = t5 * t365 * t124 * t66 / 0.4e1;
  t724 = t5 * t365;
  t729 = t5 * t182 * t290 * t66;
  t732 = t374 * t296 / 0.6e2;
  t743 = -0.3e1 / 0.8e1 * t5 * t715 * t26 * t66 - t723 - t724 * t155 / 0.2e2 + t729 / 0.12e2 - t732 + 0.7e1 / 0.3e3 * t374 * t303 - t374 * t323 / 0.4e2 - t615 / 0.8e1 + t622 / 0.6e1 - t624 / 0.6e2 - t633 + t636 / 0.9e2 + 0.7e1 / 0.9e3 * t599 - t639 / 0.12e3;
  t744 = my_piecewise3(t1, 0, t743);
  t745 = t663 * t190;
  t748 = t329 * t385;
  t753 = 0.6e1 * t670;
  t755 = my_piecewise5(t14, 0, t10, 0, -t708 - t753);
  t759 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t745 * t330 + 0.8e1 / 0.9e1 * t748 * t162 + 0.4e1 / 0.9e1 * t381 * t336 + 0.4e1 / 0.3e1 * t77 * t755);
  t767 = t5 * t389 * t124 * t106 / 0.4e1;
  t770 = t5 * t193 * t290 * t106;
  t774 = t5 * t340;
  t778 = t399 * t403 / 0.6e2;
  t779 = t290 * t204;
  t780 = t779 * t223;
  t781 = t198 * t780;
  t784 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t759 * t26 * t106 - t767 + t770 / 0.12e2 - t684 / 0.8e1 + t688 / 0.6e1 - t693 - t774 * t224 / 0.4e2 - t778 + t781 / 0.18e3);
  tv3rho31 = t327 + t354 + t698 + t699 + t6 * (t744 + t784);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t787 = t574 * t412;
  t792 = t264 * t417;
  t796 = my_piecewise5(t10, 0, t14, 0, -t708 - t709);
  t800 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t787 * t115 + 0.8e1 / 0.9e1 * t357 * t361 + 0.4e1 / 0.9e1 * t792 * t115 + 0.4e1 / 0.3e1 * t23 * t796);
  t807 = t5 * t421 * t124 * t66;
  t809 = t5 * t421;
  t816 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t800 * t26 * t66 - t807 / 0.8e1 - t809 * t155 / 0.4e2 - t723 + t729 / 0.6e1 - t732 + t622 / 0.12e2 - t633 + t636 / 0.18e3);
  t817 = t663 * t429;
  t822 = t329 * t434;
  t826 = my_piecewise5(t14, 0, t10, 0, t708 - t753);
  t830 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t817 * t162 + 0.8e1 / 0.9e1 * t381 * t385 + 0.4e1 / 0.9e1 * t822 * t162 + 0.4e1 / 0.3e1 * t77 * t826);
  t837 = t5 * t438 * t124 * t106;
  t840 = t5 * t389;
  t843 = t444 * t403;
  t849 = t124 * t449;
  t850 = t849 * t451;
  t851 = t198 * t850;
  t855 = t402 * t471;
  t856 = t198 * t855;
  t858 = -0.3e1 / 0.8e1 * t5 * t830 * t26 * t106 - t837 / 0.8e1 - t767 + t770 / 0.6e1 - t840 * t224 / 0.2e2 - t843 / 0.6e2 + t688 / 0.12e2 - t693 - t778 + t781 / 0.9e2 + 0.7e1 / 0.3e3 * t399 * t452 + 0.7e1 / 0.9e3 * t851 - t399 * t472 / 0.4e2 - t856 / 0.12e3;
  t859 = my_piecewise3(t71, 0, t858);
  tv3rho32 = t698 + t699 + t428 + t476 + t6 * (t816 + t859);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t864 = t412 * t179;
  t871 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t269 - 0.6e1 * t583);
  t875 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t574 * t864 + 0.4e1 / 0.3e1 * t357 * t417 + 0.4e1 / 0.3e1 * t23 * t871);
  t883 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t875 * t26 * t66 - 0.3e1 / 0.8e1 * t807 + t729 / 0.4e1 - t633);
  t884 = t5 * t438;
  t890 = 0.1e1 / t84 / t93;
  t895 = 0.1e1 / t83 / t100;
  t900 = 0.1e1 / t100 / t206;
  t904 = -0.154e3 / 0.81e2 * t29 * t81 * t890 - 0.209e3 / 0.486e3 * t44 * t91 * t895 - 0.5e1 / 0.16e2 * t58 * t99 * t900;
  t905 = t205 * t904;
  t908 = t429 * t190;
  t915 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t269 - 0.6e1 * t670);
  t919 = my_piecewise3(t76, 0, -0.8e1 / 0.27e2 * t663 * t908 + 0.4e1 / 0.3e1 * t381 * t434 + 0.4e1 / 0.3e1 * t77 * t915);
  t926 = t105 * t105;
  t928 = 0.1e1 / t203 / t926;
  t929 = t26 * t928;
  t930 = t451 * t223;
  t931 = t929 * t930;
  t934 = t223 * t471;
  t935 = t450 * t934;
  t944 = -0.3e1 / 0.4e2 * t884 * t224 - 0.3e1 / 0.4e2 * t444 * t472 - t198 * t905 / 0.4e2 - 0.3e1 / 0.8e1 * t5 * t919 * t26 * t106 + 0.7e1 / 0.1e3 * t444 * t452 - 0.203e3 / 0.45e4 * t198 * t931 + 0.7e1 / 0.1e3 * t198 * t935 + t781 / 0.6e2 - t843 / 0.2e2 + 0.7e1 / 0.3e3 * t851 - t856 / 0.4e2 + t770 / 0.4e1 - 0.3e1 / 0.8e1 * t837 - t693;
  t945 = my_piecewise3(t71, 0, t944);
  tv3rho33 = 0.3e1 * t428 + 0.3e1 * t476 + t6 * (t883 + t945);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t951 = t286 * t481;
  t957 = t634 * t241;
  t959 = t129 * t957 / 0.18e3;
  t960 = t597 * t484;
  t961 = t129 * t960;
  t963 = t295 * t497;
  t964 = t129 * t963;
  t966 = t241 * t302;
  t967 = t604 * t966;
  t970 = t497 * t154;
  t971 = t301 * t970;
  t974 = t241 * t322;
  t975 = t301 * t974;
  t987 = 0.11e2 / 0.27e2 * t29 * t33 * t307 + 0.19e2 / 0.162e3 * t44 * t234 * t313 + 0.3e1 / 0.32e2 * t58 * t47 * t318;
  t988 = t136 * t987;
  t991 = -t617 * t242 / 0.4e2 - t951 / 0.6e2 + 0.7e1 / 0.15e3 * t286 * t485 - t286 * t498 / 0.2e2 + t959 + 0.7e1 / 0.45e3 * t961 - t964 / 0.6e2 - 0.203e3 / 0.45e4 * t129 * t967 + 0.7e1 / 0.15e3 * t129 * t971 + 0.7e1 / 0.3e3 * t129 * t975 - t129 * t988 / 0.4e2;
  t992 = my_piecewise3(t1, 0, t991);
  tv3rho2sigma0 = t6 * t992 + 0.2e1 * t502;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t997 = t399 * t506;
  t999 = t779 * t256;
  t1001 = t198 * t999 / 0.18e3;
  t1003 = my_piecewise3(t71, 0, -t774 * t257 / 0.4e2 - t997 / 0.6e2 + t1001);
  tv3rho2sigma2 = t6 * t1003 + 0.2e1 * t510;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1007 = t374 * t481;
  t1017 = my_piecewise3(t1, 0, -t724 * t242 / 0.4e2 - t1007 / 0.12e3 + 0.7e1 / 0.3e3 * t374 * t485 - t374 * t498 / 0.4e2 - t951 / 0.12e3 + t959 + 0.7e1 / 0.9e3 * t961 - t964 / 0.12e3);
  tv3rho2sigma3 = t6 * t1017 + t502 + t515;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1021 = t444 * t506;
  t1026 = t849 * t519;
  t1027 = t198 * t1026;
  t1031 = t402 * t532;
  t1032 = t198 * t1031;
  t1035 = my_piecewise3(t71, 0, -t840 * t257 / 0.4e2 - t1021 / 0.12e3 - t997 / 0.12e3 + t1001 + 0.7e1 / 0.3e3 * t399 * t520 + 0.7e1 / 0.9e3 * t1027 - t399 * t533 / 0.4e2 - t1032 / 0.12e3);
  tv3rho2sigma5 = t6 * t1035 + t510 + t537;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1042 = my_piecewise3(t1, 0, -t809 * t242 / 0.4e2 - t1007 / 0.6e2 + t959);
  tv3rho2sigma6 = t6 * t1042 + 0.2e1 * t515;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1054 = t256 * t451;
  t1055 = t929 * t1054;
  t1058 = t532 * t223;
  t1059 = t450 * t1058;
  t1062 = t256 * t471;
  t1063 = t450 * t1062;
  t1075 = 0.11e2 / 0.27e2 * t29 * t33 * t456 + 0.19e2 / 0.162e3 * t44 * t249 * t462 + 0.3e1 / 0.32e2 * t58 * t90 * t467;
  t1076 = t205 * t1075;
  t1079 = -t884 * t257 / 0.4e2 - t1021 / 0.6e2 + 0.7e1 / 0.15e3 * t444 * t520 - t444 * t533 / 0.2e2 + t1001 + 0.7e1 / 0.45e3 * t1027 - t1032 / 0.6e2 - 0.203e3 / 0.45e4 * t198 * t1055 + 0.7e1 / 0.15e3 * t198 * t1059 + 0.7e1 / 0.3e3 * t198 * t1063 - t198 * t1076 / 0.4e2;
  t1080 = my_piecewise3(t71, 0, t1079);
  tv3rho2sigma8 = t6 * t1080 + 0.2e1 * t537;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1084 = t597 * t539;
  t1086 = 0.7e1 / 0.9e3 * t129 * t1084;
  t1087 = t539 * t154;
  t1088 = t604 * t1087;
  t1091 = t241 * t497;
  t1092 = t301 * t1091;
  t1097 = t295 * t549;
  t1099 = t129 * t1097 / 0.12e3;
  t1100 = t549 * t154;
  t1101 = t301 * t1100;
  t1110 = -t44 * t46 * t145 / 0.54e2 - t58 * sigma[0] * t150 / 0.48e2;
  t1111 = t136 * t1110;
  t1115 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t286 * t540 + t1086 - 0.203e3 / 0.45e4 * t129 * t1088 + 0.7e1 / 0.15e3 * t129 * t1092 - t286 * t550 / 0.4e2 - t1099 + 0.7e1 / 0.3e3 * t129 * t1101 - t129 * t1111 / 0.4e2);
  tv3rhosigma20 = t6 * t1115 + t554;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1119 = t849 * t555;
  t1121 = 0.7e1 / 0.9e3 * t198 * t1119;
  t1124 = t402 * t565;
  t1126 = t198 * t1124 / 0.12e3;
  t1128 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t399 * t556 + t1121 - t399 * t566 / 0.4e2 - t1126);
  tv3rhosigma25 = t6 * t1128 + t570;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1135 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t374 * t540 + t1086 - t374 * t550 / 0.4e2 - t1099);
  tv3rhosigma26 = t6 * t1135 + t554;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1139 = t555 * t223;
  t1140 = t929 * t1139;
  t1143 = t256 * t532;
  t1144 = t450 * t1143;
  t1149 = t565 * t223;
  t1150 = t450 * t1149;
  t1159 = -t44 * t46 * t214 / 0.54e2 - t58 * sigma[2] * t219 / 0.48e2;
  t1160 = t205 * t1159;
  t1164 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t444 * t556 + t1121 - 0.203e3 / 0.45e4 * t198 * t1140 + 0.7e1 / 0.15e3 * t198 * t1144 - t444 * t566 / 0.4e2 - t1126 + 0.7e1 / 0.3e3 * t198 * t1150 - t198 * t1160 / 0.4e2);
  tv3rhosigma211 = t6 * t1164 + t570;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1166 = t539 * t241;
  t1167 = t604 * t1166;
  t1170 = t241 * t549;
  t1171 = t301 * t1170;
  t1176 = t2 / t3 / t56;
  t1177 = t1176 * t25;
  t1178 = params->cc * t61;
  t1179 = t136 * t1178;
  t1183 = my_piecewise3(t1, 0, -0.203e3 / 0.45e4 * t129 * t1167 + 0.7e1 / 0.1e3 * t129 * t1171 - t1177 * t1179 / 0.1536e5);
  tv3sigma30 = t6 * t1183;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1184 = t555 * t256;
  t1185 = t929 * t1184;
  t1188 = t256 * t565;
  t1189 = t450 * t1188;
  t1192 = t1176 * t79;
  t1193 = params->cc * t101;
  t1194 = t205 * t1193;
  t1198 = my_piecewise3(t71, 0, -0.203e3 / 0.45e4 * t198 * t1185 + 0.7e1 / 0.1e3 * t198 * t1189 - t1192 * t1194 / 0.1536e5);
  tv3sigma39 = t6 * t1198;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1201 = t322 * t322;
  t1205 = t286 * t598;
  t1209 = t290 * t300;
  t1211 = t129 * t1209 * t302;
  t1213 = t124 * t603;
  t1215 = t129 * t1213 * t605;
  t1220 = t26 / t134 / t601 / t65;
  t1221 = t302 * t302;
  t1225 = t617 * t296;
  t1229 = t286 * t635;
  t1231 = t286 * t638;
  t1235 = t629 * t135;
  t1237 = t129 * t1235 * t154;
  t1240 = t129 * t634 * t322;
  t1242 = 0.7e1 / 0.1e3 * t129 * t301 * t1201 + 0.7e1 / 0.75e2 * t1205 - 0.203e3 / 0.1125e4 * t286 * t606 - 0.7e1 / 0.225e3 * t1211 - 0.203e3 / 0.3375e4 * t1215 + 0.2233e4 / 0.16875e5 * t129 * t1220 * t1221 - t1225 / 0.1e2 - 0.3e1 / 0.2e2 * t617 * t323 + t1229 / 0.15e2 - t1231 / 0.1e2 - t286 * t657 / 0.1e2 - t1237 / 0.27e2 + t1240 / 0.3e2;
  t1244 = t129 * t295 * t656;
  t1265 = t5 * t590;
  t1271 = t129 * t597 * t609;
  t1284 = 0.1e1 / t123 / t268;
  t1288 = 0.1e2 / 0.27e2 * t5 * t25 * t1284 * t66;
  t1291 = t5 * t590 * t124 * t66;
  t1295 = t5 * t277 * t290 * t66;
  t1299 = t5 * t118 * t629 * t66;
  t1301 = t19 * t19;
  t1303 = 0.1e1 / t263 / t1301;
  t1304 = t265 * t265;
  t1310 = t273 * t273;
  t1316 = 0.1e1 / t581 / t6;
  t1317 = t16 * t1316;
  t1320 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t582 + 0.24e2 * t1317);
  t1324 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1303 * t1304 - 0.16e2 / 0.9e1 * t574 * t265 * t273 + 0.4e1 / 0.3e1 * t264 * t1310 + 0.16e2 / 0.9e1 * t578 * t586 + 0.4e1 / 0.3e1 * t23 * t1320);
  t1329 = -t1244 / 0.3e2 - t129 * t136 * (0.2618e4 / 0.243e3 * t29 * t34 / t37 / t143 + 0.5225e4 / 0.1458e4 * t44 * t48 / t36 / t149 + 0.55e2 / 0.16e2 * t58 * t59 / t60 / t49) / 0.4e2 - t1265 * t155 / 0.1e2 + 0.7e1 / 0.5e2 * t617 * t303 + 0.7e1 / 0.75e2 * t1271 - 0.203e3 / 0.75e3 * t129 * t604 * t302 * t322 + 0.7e1 / 0.75e2 * t129 * t301 * t154 * t656 + 0.7e1 / 0.25e2 * t286 * t610 + t1288 - t1291 / 0.2e1 + t1295 / 0.2e1 - 0.5e1 / 0.9e1 * t1299 - 0.3e1 / 0.8e1 * t5 * t1324 * t26 * t66;
  t1331 = my_piecewise3(t1, 0, t1242 + t1329);
  t1332 = t75 * t75;
  t1334 = 0.1e1 / t328 / t1332;
  t1335 = t330 * t330;
  t1341 = t336 * t336;
  t1346 = t72 * t1316;
  t1349 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t582 + 0.24e2 * t1346);
  t1353 = my_piecewise3(t76, 0, 0.4e2 / 0.81e2 * t1334 * t1335 - 0.16e2 / 0.9e1 * t663 * t330 * t336 + 0.4e1 / 0.3e1 * t329 * t1341 + 0.16e2 / 0.9e1 * t667 * t673 + 0.4e1 / 0.3e1 * t77 * t1349);
  t1360 = t5 * t677 * t124 * t106;
  t1364 = t5 * t340 * t290 * t106;
  t1368 = t5 * t165 * t629 * t106;
  t1373 = 0.1e2 / 0.27e2 * t5 * t79 * t1284 * t106;
  t1375 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t1353 * t26 * t106 - t1360 / 0.2e1 + t1364 / 0.2e1 - 0.5e1 / 0.9e1 * t1368 + t1373);
  tv4rho40 = 0.4e1 * t661 + 0.4e1 * t695 + t6 * (t1331 + t1375);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1380 = t374 * t598;
  t1386 = t724 * t296;
  t1390 = t374 * t635;
  t1391 = t1390 / 0.6e2;
  t1392 = t374 * t638;
  t1396 = t5 * t715;
  t1404 = 0.7e1 / 0.3e3 * t1380 - 0.203e3 / 0.45e4 * t374 * t606 + 0.7e1 / 0.1e3 * t724 * t303 - t1386 / 0.2e2 - 0.3e1 / 0.4e2 * t724 * t323 + t1391 - t1392 / 0.4e2 - t374 * t657 / 0.4e2 - 0.3e1 / 0.4e2 * t1396 * t155 + 0.7e1 / 0.3e3 * t1205 - 0.7e1 / 0.45e3 * t1211 - 0.203e3 / 0.135e5 * t1215 - t1225 / 0.4e2 + t1229 / 0.3e2;
  t1414 = t5 * t365 * t290 * t66;
  t1415 = t1414 / 0.4e1;
  t1418 = t5 * t182 * t629 * t66;
  t1436 = 0.12e2 * t582;
  t1437 = 0.24e2 * t1317;
  t1439 = my_piecewise5(t10, 0, t14, 0, -t1436 + t1437);
  t1443 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1303 * t179 * t575 - 0.8e1 / 0.9e1 * t574 * t361 * t265 - 0.8e1 / 0.9e1 * t700 * t115 * t273 + 0.4e1 / 0.3e1 * t264 * t711 * t115 + 0.4e1 / 0.3e1 * t703 * t273 + 0.4e1 / 0.9e1 * t357 * t586 + 0.4e1 / 0.3e1 * t23 * t1439);
  t1450 = t5 * t715 * t124 * t66;
  t1455 = -t1231 / 0.4e2 - t1237 / 0.36e2 + t1240 / 0.6e2 - t1244 / 0.12e3 + 0.7e1 / 0.3e3 * t1271 + 0.7e1 / 0.1e3 * t374 * t610 + t1415 - 0.5e1 / 0.36e2 * t1418 - 0.3e1 / 0.8e1 * t5 * t1443 * t26 * t66 - 0.3e1 / 0.8e1 * t1450 + t1288 - t1291 / 0.8e1 + t1295 / 0.4e1 - 0.5e1 / 0.12e2 * t1299;
  t1457 = my_piecewise3(t1, 0, t1404 + t1455);
  t1474 = 0.24e2 * t1346;
  t1476 = my_piecewise5(t14, 0, t10, 0, t1436 + t1474);
  t1480 = my_piecewise3(t76, 0, 0.4e2 / 0.81e2 * t1334 * t190 * t664 - 0.8e1 / 0.9e1 * t663 * t385 * t330 - 0.8e1 / 0.9e1 * t745 * t162 * t336 + 0.4e1 / 0.3e1 * t329 * t755 * t162 + 0.4e1 / 0.3e1 * t748 * t336 + 0.4e1 / 0.9e1 * t381 * t673 + 0.4e1 / 0.3e1 * t77 * t1476);
  t1487 = t5 * t759 * t124 * t106;
  t1491 = t5 * t389 * t290 * t106;
  t1492 = t1491 / 0.4e1;
  t1495 = t5 * t193 * t629 * t106;
  t1500 = t5 * t677;
  t1503 = t774 * t403;
  t1505 = t399 * t780;
  t1506 = t1505 / 0.6e2;
  t1507 = t629 * t204;
  t1509 = t198 * t1507 * t223;
  t1511 = -0.3e1 / 0.8e1 * t5 * t1480 * t26 * t106 - 0.3e1 / 0.8e1 * t1487 + t1492 - 0.5e1 / 0.36e2 * t1495 - t1360 / 0.8e1 + t1364 / 0.4e1 - 0.5e1 / 0.12e2 * t1368 + t1373 - t1500 * t224 / 0.4e2 - t1503 / 0.4e2 + t1506 - t1509 / 0.108e3;
  t1512 = my_piecewise3(t71, 0, t1511);
  tv4rho41 = t661 + t695 + 0.3e1 * t744 + 0.3e1 * t784 + t6 * (t1457 + t1512);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1527 = t361 * t361;
  t1540 = my_piecewise5(t10, 0, t14, 0, t1437);
  t1544 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1303 * t412 * t265 - 0.32e2 / 0.27e2 * t700 * t115 * t361 - 0.8e1 / 0.27e2 * t787 * t273 + 0.8e1 / 0.9e1 * t264 * t1527 + 0.8e1 / 0.9e1 * t357 * t711 - 0.8e1 / 0.27e2 * t574 * t417 * t265 + 0.8e1 / 0.9e1 * t264 * t796 * t115 + 0.4e1 / 0.9e1 * t792 * t273 + 0.4e1 / 0.3e1 * t23 * t1540);
  t1551 = t5 * t800 * t124 * t66;
  t1553 = t5 * t800;
  t1558 = t5 * t421 * t290 * t66;
  t1560 = t809 * t296;
  t1580 = t1390 / 0.45e2 - t1392 / 0.6e2 + t1295 / 0.12e2 - 0.5e1 / 0.18e2 * t1299 + t1229 / 0.9e2 + t1288 - t1237 / 0.54e2 + t1240 / 0.18e3 + 0.7e1 / 0.3e3 * t809 * t303 + 0.7e1 / 0.45e3 * t1380 - 0.7e1 / 0.135e4 * t1211;
  t1582 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1544 * t26 * t66 - t1551 / 0.4e1 - t1553 * t155 / 0.2e2 + t1558 / 0.12e2 - t1560 / 0.6e2 - t809 * t323 / 0.4e2 - t1450 / 0.4e1 + t1414 / 0.3e1 - t1386 / 0.3e2 - 0.5e1 / 0.18e2 * t1418 + t1580);
  t1591 = t385 * t385;
  t1604 = my_piecewise5(t14, 0, t10, 0, t1474);
  t1608 = my_piecewise3(t76, 0, 0.4e2 / 0.81e2 * t1334 * t429 * t330 - 0.32e2 / 0.27e2 * t745 * t162 * t385 - 0.8e1 / 0.27e2 * t817 * t336 + 0.8e1 / 0.9e1 * t329 * t1591 + 0.8e1 / 0.9e1 * t381 * t755 - 0.8e1 / 0.27e2 * t663 * t434 * t330 + 0.8e1 / 0.9e1 * t329 * t826 * t162 + 0.4e1 / 0.9e1 * t822 * t336 + 0.4e1 / 0.3e1 * t77 * t1604);
  t1615 = t5 * t438 * t290 * t106;
  t1617 = t5 * t759;
  t1626 = t5 * t830 * t124 * t106;
  t1634 = t840 * t403;
  t1636 = t444 * t780;
  t1638 = t399 * t850;
  t1640 = t290 * t449;
  t1642 = t198 * t1640 * t451;
  t1644 = t399 * t855;
  t1647 = t198 * t779 * t471;
  t1652 = -0.5e1 / 0.18e2 * t1368 + t1373 - t1634 / 0.3e2 + t1636 / 0.9e2 + 0.7e1 / 0.45e3 * t1638 - 0.7e1 / 0.135e4 * t1642 - t1644 / 0.6e2 + t1647 / 0.18e3 - t1503 / 0.6e2 + t1505 / 0.45e2 - t1509 / 0.54e2;
  t1654 = my_piecewise3(t71, 0, -0.3e1 / 0.8e1 * t5 * t1608 * t26 * t106 + t1615 / 0.12e2 - t1617 * t224 / 0.2e2 + 0.7e1 / 0.3e3 * t774 * t452 - t774 * t472 / 0.4e2 - t1626 / 0.4e1 - t1487 / 0.4e1 + t1491 / 0.3e1 - 0.5e1 / 0.18e2 * t1495 + t1364 / 0.12e2 + t1652);
  tv4rho42 = 0.2e1 * t744 + 0.2e1 * t784 + 0.2e1 * t816 + 0.2e1 * t859 + t6 * (t1582 + t1654);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1675 = my_piecewise5(t10, 0, t14, 0, t1436 + t1437);
  t1679 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1303 * t864 * t115 - 0.8e1 / 0.9e1 * t787 * t361 - 0.8e1 / 0.9e1 * t700 * t417 * t115 + 0.4e1 / 0.3e1 * t703 * t417 + 0.4e1 / 0.3e1 * t357 * t796 + 0.4e1 / 0.9e1 * t264 * t871 * t115 + 0.4e1 / 0.3e1 * t23 * t1675);
  t1686 = t5 * t875 * t124 * t66;
  t1688 = t5 * t875;
  t1697 = -0.3e1 / 0.8e1 * t5 * t1679 * t26 * t66 - t1686 / 0.8e1 - t1688 * t155 / 0.4e2 - 0.3e1 / 0.8e1 * t1551 + t1558 / 0.4e1 - t1560 / 0.4e2 + t1415 - 0.5e1 / 0.12e2 * t1418 + t1391 - 0.5e1 / 0.36e2 * t1299 + t1288 - t1237 / 0.108e3;
  t1698 = my_piecewise3(t1, 0, t1697);
  t1699 = t884 * t403;
  t1701 = t444 * t855;
  t1704 = t198 * t402 * t904;
  t1706 = t444 * t850;
  t1708 = t124 * t928;
  t1710 = t198 * t1708 * t930;
  t1718 = t5 * t830;
  t1739 = my_piecewise5(t14, 0, t10, 0, -t1436 + t1474);
  t1743 = my_piecewise3(t76, 0, 0.4e2 / 0.81e2 * t1334 * t908 * t162 - 0.8e1 / 0.9e1 * t817 * t385 - 0.8e1 / 0.9e1 * t745 * t434 * t162 + 0.4e1 / 0.3e1 * t748 * t434 + 0.4e1 / 0.3e1 * t381 * t826 + 0.4e1 / 0.9e1 * t329 * t915 * t162 + 0.4e1 / 0.3e1 * t77 * t1739);
  t1750 = t5 * t919 * t124 * t106;
  t1754 = -t1699 / 0.4e2 - t1701 / 0.4e2 - t1704 / 0.12e3 + 0.7e1 / 0.3e3 * t1706 - 0.203e3 / 0.135e5 * t1710 - t399 * t905 / 0.4e2 + 0.7e1 / 0.1e3 * t840 * t452 - 0.203e3 / 0.45e4 * t399 * t931 - 0.3e1 / 0.4e2 * t1718 * t224 - 0.3e1 / 0.4e2 * t840 * t472 - 0.3e1 / 0.8e1 * t5 * t1743 * t26 * t106 - t1750 / 0.8e1 - 0.3e1 / 0.8e1 * t1626 + t1615 / 0.4e1;
  t1766 = t198 * t849 * t934;
  t1769 = t1492 - 0.5e1 / 0.12e2 * t1495 - t1644 / 0.4e2 + t1647 / 0.6e2 - t1634 / 0.2e2 + t1636 / 0.3e2 + 0.7e1 / 0.3e3 * t1638 - 0.7e1 / 0.45e3 * t1642 - t1509 / 0.36e2 + t1506 + 0.7e1 / 0.1e3 * t399 * t935 + 0.7e1 / 0.3e3 * t1766 - 0.5e1 / 0.36e2 * t1368 + t1373;
  t1771 = my_piecewise3(t71, 0, t1754 + t1769);
  tv4rho43 = 0.3e1 * t816 + 0.3e1 * t859 + t883 + t945 + t6 * (t1698 + t1771);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1776 = t412 * t412;
  t1781 = t417 * t417;
  t1788 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t582 + 0.24e2 * t1317);
  t1792 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1303 * t1776 - 0.16e2 / 0.9e1 * t787 * t417 + 0.4e1 / 0.3e1 * t264 * t1781 + 0.16e2 / 0.9e1 * t357 * t871 + 0.4e1 / 0.3e1 * t23 * t1788);
  t1801 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1792 * t26 * t66 - t1686 / 0.2e1 + t1558 / 0.2e1 - 0.5e1 / 0.9e1 * t1418 + t1288);
  t1805 = t26 / t203 / t926 / t105;
  t1806 = t451 * t451;
  t1810 = t471 * t471;
  t1818 = t5 * t919;
  t1849 = 0.2233e4 / 0.16875e5 * t198 * t1805 * t1806 + 0.7e1 / 0.1e3 * t198 * t450 * t1810 + 0.7e1 / 0.5e2 * t884 * t452 - 0.203e3 / 0.1125e4 * t444 * t931 - t1818 * t224 / 0.1e2 - 0.3e1 / 0.2e2 * t884 * t472 - t444 * t905 / 0.1e2 - t198 * t205 * (0.2618e4 / 0.243e3 * t29 * t81 / t84 / t212 + 0.5225e4 / 0.1458e4 * t44 * t91 / t83 / t218 + 0.55e2 / 0.16e2 * t58 * t99 / t100 / t92) / 0.4e2 - t1699 / 0.1e2 - t1701 / 0.1e2 - t1704 / 0.3e2 + 0.7e1 / 0.75e2 * t1706 - 0.203e3 / 0.3375e4 * t1710;
  t1850 = t429 * t429;
  t1855 = t434 * t434;
  t1862 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t582 + 0.24e2 * t1346);
  t1866 = my_piecewise3(t76, 0, 0.4e2 / 0.81e2 * t1334 * t1850 - 0.16e2 / 0.9e1 * t817 * t434 + 0.4e1 / 0.3e1 * t329 * t1855 + 0.16e2 / 0.9e1 * t381 * t915 + 0.4e1 / 0.3e1 * t77 * t1862);
  t1889 = -0.3e1 / 0.8e1 * t5 * t1866 * t26 * t106 - t1750 / 0.2e1 + t1615 / 0.2e1 - 0.5e1 / 0.9e1 * t1495 + t1647 / 0.3e2 + t1636 / 0.15e2 - 0.7e1 / 0.225e3 * t1642 - t1509 / 0.27e2 + 0.7e1 / 0.25e2 * t444 * t935 + 0.7e1 / 0.75e2 * t198 * t450 * t904 * t223 - 0.203e3 / 0.75e3 * t198 * t929 * t451 * t471 + 0.7e1 / 0.75e2 * t1766 + t1373;
  t1891 = my_piecewise3(t71, 0, t1849 + t1889);
  tv4rho44 = 0.4e1 * t883 + 0.4e1 * t945 + t6 * (t1801 + t1891);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1897 = t129 * t1235 * t241 / 0.108e3;
  t1898 = t286 * t963;
  t1903 = t129 * t634 * t497;
  t1906 = t129 * t295 * t987;
  t1925 = t617 * t481;
  t1927 = t286 * t957;
  t1930 = t129 * t597 * t970;
  t1933 = t129 * t597 * t974;
  t1935 = -t1897 - t1898 / 0.2e2 - 0.3e1 / 0.4e2 * t286 * t988 + t1903 / 0.6e2 - t1906 / 0.4e2 - t129 * t136 * (-0.154e3 / 0.81e2 * t29 * t33 * t642 - 0.209e3 / 0.243e3 * t44 * t234 * t647 - 0.15e2 / 0.16e2 * t58 * t47 * t652) / 0.4e2 - t1265 * t242 / 0.4e2 - 0.3e1 / 0.4e2 * t617 * t498 - t1925 / 0.4e2 + t1927 / 0.6e2 + 0.7e1 / 0.15e3 * t1930 + 0.7e1 / 0.3e3 * t1933;
  t1954 = t286 * t960;
  t1961 = t129 * t1209 * t484;
  t1966 = t129 * t1213 * t966;
  t1972 = t5 * t27;
  t1973 = t603 * t241;
  t1977 = -0.203e3 / 0.15e4 * t129 * t604 * t497 * t302 + 0.7e1 / 0.1e3 * t129 * t301 * t987 * t154 + 0.7e1 / 0.1e3 * t129 * t301 * t497 * t322 + 0.7e1 / 0.3e3 * t129 * t301 * t241 * t656 + 0.7e1 / 0.1e3 * t617 * t485 + 0.7e1 / 0.15e3 * t1954 + 0.7e1 / 0.5e2 * t286 * t971 + 0.7e1 / 0.1e3 * t286 * t975 - 0.7e1 / 0.45e3 * t1961 - 0.203e3 / 0.15e4 * t286 * t967 - 0.203e3 / 0.45e4 * t1966 + 0.2233e4 / 0.16875e5 * t129 * t1220 * t241 * t605 - 0.203e3 / 0.15e4 * t1972 * t1973 * t609;
  t1979 = my_piecewise3(t1, 0, t1935 + t1977);
  tv4rho3sigma0 = t6 * t1979 + 0.3e1 * t992;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1984 = t774 * t506;
  t1986 = t399 * t999;
  t1990 = t198 * t1507 * t256 / 0.108e3;
  t1992 = my_piecewise3(t71, 0, -t1500 * t257 / 0.4e2 - t1984 / 0.4e2 + t1986 / 0.6e2 - t1990);
  tv4rho3sigma2 = t6 * t1992 + 0.3e1 * t1003;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1994 = 0.2e1 * t1017;
  t1996 = t724 * t481 / 0.6e2;
  t1999 = t374 * t957;
  t2002 = 0.7e1 / 0.45e3 * t374 * t960;
  t2012 = -t1996 + 0.7e1 / 0.15e3 * t724 * t485 + t1999 / 0.18e3 + t2002 + 0.7e1 / 0.15e3 * t374 * t971 + 0.7e1 / 0.3e3 * t374 * t975 + 0.7e1 / 0.45e3 * t1930 + 0.7e1 / 0.9e3 * t1933 - t1925 / 0.12e3 + t1927 / 0.9e2 + 0.7e1 / 0.45e3 * t1954;
  t2019 = t374 * t963 / 0.6e2;
  t2028 = -t1897 - 0.7e1 / 0.675e3 * t1961 - t1396 * t242 / 0.4e2 - t724 * t498 / 0.2e2 - t2019 - t374 * t988 / 0.4e2 - t1898 / 0.6e2 + t1903 / 0.9e2 - t1906 / 0.12e3 - 0.203e3 / 0.45e4 * t374 * t967 - 0.203e3 / 0.135e5 * t1966;
  t2030 = my_piecewise3(t1, 0, t2012 + t2028);
  tv4rho3sigma3 = t6 * t2030 + t1994 + t992;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2032 = 0.2e1 * t1035;
  t2036 = t840 * t506 / 0.6e2;
  t2037 = t444 * t999;
  t2044 = 0.7e1 / 0.45e3 * t399 * t1026;
  t2046 = t198 * t1640 * t519;
  t2051 = t399 * t1031 / 0.6e2;
  t2053 = t198 * t779 * t532;
  t2055 = -t1617 * t257 / 0.4e2 - t2036 + t2037 / 0.18e3 - t1984 / 0.12e3 + t1986 / 0.9e2 - t1990 + 0.7e1 / 0.3e3 * t774 * t520 + t2044 - 0.7e1 / 0.135e4 * t2046 - t774 * t533 / 0.4e2 - t2051 + t2053 / 0.18e3;
  t2056 = my_piecewise3(t71, 0, t2055);
  tv4rho3sigma5 = t6 * t2056 + t1003 + t2032;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2060 = t809 * t481;
  t2070 = -t1553 * t242 / 0.4e2 - t2060 / 0.12e3 + 0.7e1 / 0.3e3 * t809 * t485 - t809 * t498 / 0.4e2 - t1996 + t1999 / 0.9e2 + t2002 - t2019 + t1927 / 0.18e3 - t1897 - 0.7e1 / 0.135e4 * t1961 + t1903 / 0.18e3;
  t2071 = my_piecewise3(t1, 0, t2070);
  tv4rho3sigma6 = t6 * t2071 + t1042 + t1994;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2075 = t884 * t506;
  t2080 = t444 * t1026;
  t2084 = t444 * t1031;
  t2087 = -t1718 * t257 / 0.4e2 - t2075 / 0.12e3 - t2036 + t2037 / 0.9e2 + 0.7e1 / 0.15e3 * t840 * t520 + 0.7e1 / 0.45e3 * t2080 - t840 * t533 / 0.2e2 - t2084 / 0.6e2 + t1986 / 0.18e3 - t1990 + t2044;
  t2093 = t198 * t1708 * t1054;
  t2098 = t198 * t849 * t1058;
  t2103 = t198 * t849 * t1062;
  t2108 = t198 * t402 * t1075;
  t2110 = -0.7e1 / 0.675e3 * t2046 - t2051 + t2053 / 0.9e2 - 0.203e3 / 0.45e4 * t399 * t1055 - 0.203e3 / 0.135e5 * t2093 + 0.7e1 / 0.15e3 * t399 * t1059 + 0.7e1 / 0.45e3 * t2098 + 0.7e1 / 0.3e3 * t399 * t1063 + 0.7e1 / 0.9e3 * t2103 - t399 * t1076 / 0.4e2 - t2108 / 0.12e3;
  t2112 = my_piecewise3(t71, 0, t2087 + t2110);
  tv4rho3sigma8 = t6 * t2112 + t1080 + t2032;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2120 = my_piecewise3(t1, 0, -t1688 * t242 / 0.4e2 - t2060 / 0.4e2 + t1999 / 0.6e2 - t1897);
  tv4rho3sigma9 = t6 * t2120 + 0.3e1 * t1042;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2155 = -t198 * t205 * (-0.154e3 / 0.81e2 * t29 * t33 * t890 - 0.209e3 / 0.243e3 * t44 * t249 * t895 - 0.15e2 / 0.16e2 * t58 * t90 * t900) / 0.4e2 - t1818 * t257 / 0.4e2 - 0.3e1 / 0.4e2 * t884 * t533 - 0.3e1 / 0.4e2 * t444 * t1076 - t2108 / 0.4e2 - t2075 / 0.4e2 - t2084 / 0.2e2 + t2053 / 0.6e2 + t2037 / 0.6e2 - t1990 - 0.203e3 / 0.15e4 * t198 * t929 * t532 * t451 + 0.7e1 / 0.1e3 * t198 * t450 * t1075 * t223;
  t2181 = t5 * t80;
  t2182 = t928 * t256;
  t2186 = 0.7e1 / 0.1e3 * t198 * t450 * t532 * t471 + 0.7e1 / 0.3e3 * t198 * t450 * t256 * t904 + 0.7e1 / 0.1e3 * t884 * t520 + 0.7e1 / 0.5e2 * t444 * t1059 + 0.7e1 / 0.1e3 * t444 * t1063 + 0.7e1 / 0.15e3 * t2080 - 0.203e3 / 0.45e4 * t2093 + 0.7e1 / 0.15e3 * t2098 + 0.7e1 / 0.3e3 * t2103 - 0.203e3 / 0.15e4 * t444 * t1055 + 0.2233e4 / 0.16875e5 * t198 * t1805 * t256 * t930 - 0.7e1 / 0.45e3 * t2046 - 0.203e3 / 0.15e4 * t2181 * t2182 * t934;
  t2188 = my_piecewise3(t71, 0, t2155 + t2186);
  tv4rho3sigma11 = t6 * t2188 + 0.3e1 * t1080;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2219 = t129 * t295 * t1110;
  t2225 = t497 * t497;
  t2233 = 0.2233e4 / 0.16875e5 * t129 * t1220 * t539 * t302 - 0.203e3 / 0.1125e4 * t1972 * t1973 * t970 - 0.203e3 / 0.45e4 * t129 * t604 * t549 * t302 - t129 * t136 * (0.19e2 / 0.162e3 * t44 * t46 * t313 + 0.3e1 / 0.16e2 * t58 * sigma[0] * t318) / 0.4e2 + 0.7e1 / 0.3e3 * t617 * t540 - t617 * t550 / 0.4e2 - t286 * t1111 / 0.2e2 - t2219 / 0.6e2 - 0.203e3 / 0.45e4 * t129 * t604 * t539 * t322 + 0.7e1 / 0.15e3 * t129 * t301 * t2225 + 0.7e1 / 0.15e3 * t129 * t301 * t241 * t987;
  t2234 = t286 * t1097;
  t2240 = t129 * t634 * t549 / 0.18e3;
  t2242 = t129 * t597 * t1100;
  t2252 = t286 * t1084;
  t2260 = 0.7e1 / 0.135e4 * t129 * t1209 * t539;
  t2262 = t129 * t1213 * t1087;
  t2265 = t129 * t597 * t1091;
  t2267 = -t2234 / 0.6e2 + 0.7e1 / 0.15e3 * t286 * t1101 + t2240 + 0.7e1 / 0.45e3 * t2242 + 0.7e1 / 0.15e3 * t129 * t301 * t1110 * t154 + 0.7e1 / 0.3e3 * t129 * t301 * t549 * t322 + 0.7e1 / 0.45e3 * t2252 - 0.203e3 / 0.225e4 * t286 * t1088 + 0.7e1 / 0.75e2 * t286 * t1092 - t2260 - 0.203e3 / 0.675e4 * t2262 + 0.7e1 / 0.225e3 * t2265;
  t2269 = my_piecewise3(t1, 0, t2233 + t2267);
  tv4rho2sigma20 = t6 * t2269 + 0.2e1 * t1115;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2274 = t399 * t1119;
  t2278 = 0.7e1 / 0.135e4 * t198 * t1640 * t555;
  t2281 = t399 * t1124;
  t2285 = t198 * t779 * t565 / 0.18e3;
  t2287 = my_piecewise3(t71, 0, 0.7e1 / 0.3e3 * t774 * t556 + 0.7e1 / 0.45e3 * t2274 - t2278 - t774 * t566 / 0.4e2 - t2281 / 0.6e2 + t2285);
  tv4rho2sigma25 = t6 * t2287 + 0.2e1 * t1128;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2291 = t374 * t1084;
  t2302 = t374 * t1097;
  t2311 = 0.7e1 / 0.3e3 * t724 * t540 + 0.7e1 / 0.9e3 * t2291 - 0.203e3 / 0.45e4 * t374 * t1088 + 0.7e1 / 0.15e3 * t374 * t1092 + 0.7e1 / 0.9e3 * t2252 - t2260 - 0.203e3 / 0.135e5 * t2262 + 0.7e1 / 0.45e3 * t2265 - t724 * t550 / 0.4e2 - t2302 / 0.12e3 + 0.7e1 / 0.3e3 * t374 * t1101 - t374 * t1111 / 0.4e2 - t2234 / 0.12e3 + t2240 + 0.7e1 / 0.9e3 * t2242 - t2219 / 0.12e3;
  t2312 = my_piecewise3(t1, 0, t2311);
  tv4rho2sigma26 = t6 * t2312 + t1115 + t1135;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2316 = t444 * t1119;
  t2322 = t198 * t1708 * t1139;
  t2327 = t198 * t849 * t1143;
  t2331 = t444 * t1124;
  t2337 = t198 * t849 * t1149;
  t2342 = t198 * t402 * t1159;
  t2344 = 0.7e1 / 0.3e3 * t840 * t556 + 0.7e1 / 0.9e3 * t2316 + 0.7e1 / 0.9e3 * t2274 - t2278 - 0.203e3 / 0.45e4 * t399 * t1140 - 0.203e3 / 0.135e5 * t2322 + 0.7e1 / 0.15e3 * t399 * t1144 + 0.7e1 / 0.45e3 * t2327 - t840 * t566 / 0.4e2 - t2331 / 0.12e3 - t2281 / 0.12e3 + t2285 + 0.7e1 / 0.3e3 * t399 * t1150 + 0.7e1 / 0.9e3 * t2337 - t399 * t1160 / 0.4e2 - t2342 / 0.12e3;
  t2345 = my_piecewise3(t71, 0, t2344);
  tv4rho2sigma211 = t6 * t2345 + t1128 + t1164;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2355 = my_piecewise3(t1, 0, 0.7e1 / 0.3e3 * t809 * t540 + 0.7e1 / 0.45e3 * t2291 - t2260 - t809 * t550 / 0.4e2 - t2302 / 0.6e2 + t2240);
  tv4rho2sigma212 = t6 * t2355 + 0.2e1 * t1135;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2392 = 0.2233e4 / 0.16875e5 * t198 * t1805 * t555 * t451 - 0.203e3 / 0.1125e4 * t2181 * t2182 * t1058 - 0.203e3 / 0.45e4 * t198 * t929 * t565 * t451 - 0.203e3 / 0.675e4 * t2322 + 0.7e1 / 0.225e3 * t2327 + 0.7e1 / 0.45e3 * t2337 - t198 * t205 * (0.19e2 / 0.162e3 * t44 * t46 * t462 + 0.3e1 / 0.16e2 * t58 * sigma[2] * t467) / 0.4e2 + 0.7e1 / 0.3e3 * t884 * t556 - t884 * t566 / 0.4e2 - t444 * t1160 / 0.2e2 - 0.203e3 / 0.45e4 * t198 * t929 * t555 * t471;
  t2393 = t532 * t532;
  t2418 = 0.7e1 / 0.15e3 * t198 * t450 * t2393 + 0.7e1 / 0.15e3 * t198 * t450 * t256 * t1075 + 0.7e1 / 0.15e3 * t444 * t1150 + 0.7e1 / 0.15e3 * t198 * t450 * t1159 * t223 + 0.7e1 / 0.3e3 * t198 * t450 * t565 * t471 - t2342 / 0.6e2 - 0.203e3 / 0.225e4 * t444 * t1140 + 0.7e1 / 0.75e2 * t444 * t1144 + t2285 + 0.7e1 / 0.45e3 * t2316 - t2331 / 0.6e2 - t2278;
  t2420 = my_piecewise3(t71, 0, t2392 + t2418);
  tv4rho2sigma217 = t6 * t2420 + 0.2e1 * t1164;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2426 = 0.203e3 / 0.135e5 * t129 * t1213 * t1166;
  t2439 = 0.7e1 / 0.3e3 * t129 * t597 * t1170;
  t2456 = t1177 * t295 * t1178 / 0.4608e5;
  t2457 = t1176 * t27;
  t2467 = -0.203e3 / 0.45e4 * t286 * t1167 - t2426 + 0.2233e4 / 0.16875e5 * t129 * t1220 * t1166 * t154 - 0.203e3 / 0.15e4 * t129 * t604 * t539 * t497 + 0.7e1 / 0.1e3 * t286 * t1171 + t2439 - 0.203e3 / 0.15e4 * t1972 * t1973 * t1100 + 0.7e1 / 0.1e3 * t129 * t301 * t497 * t549 + 0.7e1 / 0.1e3 * t129 * t301 * t241 * t1110 - t1176 * t118 * t1179 / 0.1536e5 - t2456 + 0.7e1 / 0.1152e6 * t2457 * t300 * params->cc * t61 * t154 + t1177 * t136 * params->cc * t150 / 0.192e4;
  t2468 = my_piecewise3(t1, 0, t2467);
  tv4rhosigma30 = t6 * t2468 + t1183;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2474 = 0.203e3 / 0.135e5 * t198 * t1708 * t1184;
  t2479 = 0.7e1 / 0.3e3 * t198 * t849 * t1188;
  t2485 = t1192 * t402 * t1193 / 0.4608e5;
  t2487 = my_piecewise3(t71, 0, -0.203e3 / 0.45e4 * t399 * t1185 - t2474 + 0.7e1 / 0.1e3 * t399 * t1189 + t2479 - t1176 * t165 * t1194 / 0.1536e5 - t2485);
  tv4rhosigma39 = t6 * t2487 + t1198;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2497 = my_piecewise3(t1, 0, -0.203e3 / 0.45e4 * t374 * t1167 - t2426 + 0.7e1 / 0.1e3 * t374 * t1171 + t2439 - t1176 * t182 * t1179 / 0.1536e5 - t2456);
  tv4rhosigma310 = t6 * t2497 + t1183;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2525 = t1176 * t80;
  t2535 = -0.203e3 / 0.45e4 * t444 * t1185 - t2474 + 0.2233e4 / 0.16875e5 * t198 * t1805 * t1184 * t223 - 0.203e3 / 0.15e4 * t198 * t929 * t555 * t532 + 0.7e1 / 0.1e3 * t444 * t1189 + t2479 - 0.203e3 / 0.15e4 * t2181 * t2182 * t1149 + 0.7e1 / 0.1e3 * t198 * t450 * t532 * t565 + 0.7e1 / 0.1e3 * t198 * t450 * t256 * t1159 - t1176 * t193 * t1194 / 0.1536e5 - t2485 + 0.7e1 / 0.1152e6 * t2525 * t449 * params->cc * t101 * t223 + t1192 * t205 * params->cc * t219 / 0.192e4;
  t2536 = my_piecewise3(t71, 0, t2535);
  tv4rhosigma319 = t6 * t2536 + t1198;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2538 = t539 * t539;
  t2546 = t549 * t549;
  t2555 = my_piecewise3(t1, 0, 0.2233e4 / 0.16875e5 * t129 * t1220 * t2538 - 0.203e3 / 0.75e3 * t129 * t604 * t539 * t549 + 0.7e1 / 0.1e3 * t129 * t301 * t2546 + 0.7e1 / 0.288e5 * t2457 * t300 * t241 * t1178);
  tv4sigma40 = t6 * t2555;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2556 = t555 * t555;
  t2564 = t565 * t565;
  t2573 = my_piecewise3(t71, 0, 0.2233e4 / 0.16875e5 * t198 * t1805 * t2556 - 0.203e3 / 0.75e3 * t198 * t929 * t555 * t565 + 0.7e1 / 0.1e3 * t198 * t450 * t2564 + 0.7e1 / 0.288e5 * t2525 * t449 * t256 * t1193);
  tv4sigma414 = t6 * t2573;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

