/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_47 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 9542, "epsg", 9542,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RRAF 1991 + IGN 2008 LD height\",GEOGCS[\"RRA");
    add_srs_wkt (p, 1,
        "F 1991\",DATUM[\"Reseau_de_Reference_des_Antilles_Franca");
    add_srs_wkt (p, 2,
        "ises_1991\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1047\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4558\"]],VERT_CS[\"IGN 2008 LD h");
    add_srs_wkt (p, 8,
        "eight\",VERT_DATUM[\"IGN 2008 LD\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 9,
        "\",\"1250\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 10,
        "\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9130\"]],AUTHORITY[\"EPSG\",\"9542\"]]");
    p = add_epsg_def_ex (filter, first, last, 9543, "epsg", 9543,
        "ITRF2005", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2005", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +geoidgrids=za_cdngi_sageoid2");
    add_proj4text (p, 1,
        "010.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ITRF2005 + SA LLD height\",GEOGCS[\"ITRF2005\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"International_Terrestrial_Reference_Frame_2005\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6896\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"8998\"]],VERT_CS[\"SA LLD height\",VERT_DATU");
    add_srs_wkt (p, 8,
        "M[\"South Africa Land Levelling Datum\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 9,
        "EPSG\",\"1262\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 10,
        "9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9279\"]],AUTHORITY[\"EPSG\",\"9543\"]]");
    p = add_epsg_def_ex (filter, first, last, 9544, "epsg", 9544,
        "NAD83(CSRS)v6", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_6", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS)v6 + CGVD2013(CGG2013a) height\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(CSRS)v6\",DATUM[\"North_American_Datum_of_");
    add_srs_wkt (p, 2,
        "1983_CSRS_version_6\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"8252\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 8,
        "VD2013(CGG2013a) height\",VERT_DATUM[\"Canadian Geodetic");
    add_srs_wkt (p, 9,
        " Vertical Datum of 2013 (CGG2013a)\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 10,
        "SG\",\"1256\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9245\"]],AUTHORITY[\"EPSG\",\"9544\"]]");
    p = add_epsg_def_ex (filter, first, last, 9546, "epsg", 9546,
        "LTF2004(G)", 1, 1,
        "GRS 1980", "Greenwich",
        "Lyon_Turin_Ferroviaire_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LTF2004(G)\",DATUM[\"Lyon Turin Ferroviaire 20");
    add_srs_wkt (p, 1,
        "04\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"Engineering survey and map");
    add_srs_wkt (p, 9,
        "ping for the Trans-Europe Lyon-Turin (TELT) railway proj");
    add_srs_wkt (p, 10,
        "ect.\"],AREA[\"France and Italy - on or related to the r");
    add_srs_wkt (p, 11,
        "ail route from Lyon to Turin.\"],BBOX[44.87,4.65,45.89,7");
    add_srs_wkt (p, 12,
        ".88]],ID[\"EPSG\",9546]]");
    p = add_epsg_def_ex (filter, first, last, 9547, "epsg", 9547,
        "LTF2004(G)", 1, 1,
        "GRS 1980", "Greenwich",
        "Lyon_Turin_Ferroviaire_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LTF2004(G)\",DATUM[\"Lyon_Turin_Ferroviaire_200");
    add_srs_wkt (p, 1,
        "4\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1295\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9547\"]]");
    p = add_epsg_def_ex (filter, first, last, 9656, "epsg", 9656,
        "ETRF2000-PL", 1, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=pl_gugik_geoid2011-PL-KRON86-NH.tif +vunits=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRF2000-PL + Baltic 1986 height\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "TRF2000-PL\",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9702");
    add_srs_wkt (p, 7,
        "\"]],VERT_CS[\"Baltic 1986 height\",VERT_DATUM[\"Baltic ");
    add_srs_wkt (p, 8,
        "1986\",2005,AUTHORITY[\"EPSG\",\"1296\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 10,
        "height\",UP],AUTHORITY[\"EPSG\",\"9650\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9656\"]]");
    p = add_epsg_def_ex (filter, first, last, 9657, "epsg", 9657,
        "ETRF2000-PL", 1, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=pl_gugik_geoid2011-PL-EVRF2007-NH.tif +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRF2000-PL + EVRF2007-PL height\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "TRF2000-PL\",DATUM[\"ETRF2000_Poland\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1305\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9702");
    add_srs_wkt (p, 7,
        "\"]],VERT_CS[\"EVRF2007-PL height\",VERT_DATUM[\"Europea");
    add_srs_wkt (p, 8,
        "n Vertical Reference Frame 2007 Poland\",2005,AUTHORITY[");
    add_srs_wkt (p, 9,
        "\"EPSG\",\"1297\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9651\"]],AUTHORITY[\"EPSG\",\"9657\"]]");
    p = add_epsg_def_ex (filter, first, last, 9674, "epsg", 9674,
        "NAD83 / USFS R6 Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=34 +lon_0=-120 +lat_1=43 +lat_2=48 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / USFS R6 Albers\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_center\",34],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",-120],PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",48],PARAMETER[\"false_easting\",60");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9674\"]]");
    p = add_epsg_def_ex (filter, first, last, 9678, "epsg", 9678,
        "Gulshan 303 / Bangladesh Transverse Mercator", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Gulshan_303", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-2000000 +ellps=evrst30 +towgs84=283.729,735.942,261.1");
    add_proj4text (p, 2,
        "43,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Gulshan 303 / Bangladesh Transverse Mercator\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Gulshan 303\",DATUM[\"Gulshan_303\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6682\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4682\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",90],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",-2000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"9678\"]]");
    p = add_epsg_def_ex (filter, first, last, 9680, "epsg", 9680,
        "WGS 84 / TM 90 NE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 90 NE\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",90],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 11,
        "H],AUTHORITY[\"EPSG\",\"9680\"]]");
    p = add_epsg_def_ex (filter, first, last, 9695, "epsg", 9695,
        "REDGEOMIN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Para_Mineria_en_Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"REDGEOMIN\",DYNAMIC[FRAMEEPOCH[2019]],DATUM[\"");
    add_srs_wkt (p, 1,
        "Red Geodesica Para Mineria en Chile\",ELLIPSOID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"Geodesy, cadastre, engineering survey, topographi");
    add_srs_wkt (p, 10,
        "c mapping.\"],AREA[\"Chile - onshore and offshore. Inclu");
    add_srs_wkt (p, 11,
        "des Easter Island, Juan Fernandez Islands, San Felix, an");
    add_srs_wkt (p, 12,
        "d Sala y Gomez.\"],BBOX[-59.87,-113.21,-17.5,-65.72]],ID");
    add_srs_wkt (p, 13,
        "[\"EPSG\",9695]]");
    p = add_epsg_def_ex (filter, first, last, 9696, "epsg", 9696,
        "REDGEOMIN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Para_Mineria_en_Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"REDGEOMIN\",DATUM[\"Red_Geodesica_Para_Mineria_");
    add_srs_wkt (p, 1,
        "en_Chile\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1304\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9696\"]]");
    p = add_epsg_def_ex (filter, first, last, 9697, "epsg", 9697,
        "REDGEOMIN / UTM zone 12S", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Para_Mineria_en_Chile", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REDGEOMIN / UTM zone 12S\",GEOGCS[\"REDGEOMIN\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Red_Geodesica_Para_Mineria_en_Chile\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1304\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9696\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-111],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9697\"]]");
    p = add_epsg_def_ex (filter, first, last, 9698, "epsg", 9698,
        "REDGEOMIN / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Para_Mineria_en_Chile", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REDGEOMIN / UTM zone 18S\",GEOGCS[\"REDGEOMIN\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Red_Geodesica_Para_Mineria_en_Chile\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1304\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9696\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9698\"]]");
    p = add_epsg_def_ex (filter, first, last, 9699, "epsg", 9699,
        "REDGEOMIN / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Para_Mineria_en_Chile", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REDGEOMIN / UTM zone 19S\",GEOGCS[\"REDGEOMIN\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Red_Geodesica_Para_Mineria_en_Chile\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"1304\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9696\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9699\"]]");
    p = add_epsg_def_ex (filter, first, last, 9701, "epsg", 9701,
        "ETRF2000-PL", 1, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF2000-PL\",DATUM[\"ETRF2000 Poland\",ELLIPS");
    add_srs_wkt (p, 1,
        "OID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metr");
    add_srs_wkt (p, 2,
        "e\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 3,
        "174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic lati");
    add_srs_wkt (p, 4,
        "tude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433]],AXIS[\"geodetic longitude (Lon)\",east,ORD");
    add_srs_wkt (p, 6,
        "ER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"e");
    add_srs_wkt (p, 7,
        "llipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Poland - onshore a");
    add_srs_wkt (p, 9,
        "nd offshore.\"],BBOX[49,14.14,55.93,24.15]],ID[\"EPSG\",");
    add_srs_wkt (p, 10,
        "9701]]");
    p = add_epsg_def_ex (filter, first, last, 9702, "epsg", 9702,
        "ETRF2000-PL", 1, 1,
        "GRS 1980", "Greenwich",
        "ETRF2000_Poland", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRF2000-PL\",DATUM[\"ETRF2000_Poland\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"1305\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9702\"]]");
    p = add_epsg_def_ex (filter, first, last, 9705, "epsg", 9705,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 + MSL height\",GEOGCS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],VERT_CS[\"MSL height\",");
    add_srs_wkt (p, 7,
        "VERT_DATUM[\"Mean Sea Level\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "5100\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 9,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 10,
        "5714\"]],AUTHORITY[\"EPSG\",\"9705\"]]");
    p = add_epsg_def_ex (filter, first, last, 9707, "epsg", 9707,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +geoidgrids=us_nga_egm96_15.t");
    add_proj4text (p, 1,
        "if +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"WGS 84 + EGM96 height\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],VERT_CS[\"EGM96 heig");
    add_srs_wkt (p, 7,
        "ht\",VERT_DATUM[\"EGM96 geoid\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 8,
        "\"5171\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 9,
        "],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"5773\"]],AUTHORITY[\"EPSG\",\"9707\"]]");
    p = add_epsg_def_ex (filter, first, last, 9709, "epsg", 9709,
        "NAD83(CSRS) / UTM zone 23N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 23N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-45],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9709\"]]");
    p = add_epsg_def_ex (filter, first, last, 9711, "epsg", 9711,
        "NAD83(CSRS) / UTM zone 23N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +units=m +vunits=m +no_d");
    add_proj4text (p, 1,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 23N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 23N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-45],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9709\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"9711\"]]");
    p = add_epsg_def_ex (filter, first, last, 9712, "epsg", 9712,
        "NAD83 / UTM zone 24N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 24N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-39],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9712\"]]");
    p = add_epsg_def_ex (filter, first, last, 9713, "epsg", 9713,
        "NAD83(CSRS) / UTM zone 24N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 24N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-39],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9713\"]]");
    p = add_epsg_def_ex (filter, first, last, 9714, "epsg", 9714,
        "NAD83(CSRS) / UTM zone 24N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +units=m +vunits=m +no_d");
    add_proj4text (p, 1,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 24N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 24N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-39],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9713\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"9714\"]]");
    p = add_epsg_def_ex (filter, first, last, 9715, "epsg", 9715,
        "NAD83(CSRS) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +units=m +vunits=m +no_d");
    add_proj4text (p, 1,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 15N + CGVD2013a height");
    add_srs_wkt (p, 1,
        "\",PROJCS[\"NAD83(CSRS) / UTM zone 15N\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 2,
        "CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3159\"]],VERT_CS[\"CGVD2013(CGG2013a) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013a)\",2005,AUTHORITY[\"EPSG\",\"1256\"]],U");
    add_srs_wkt (p, 16,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gra");
    add_srs_wkt (p, 17,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"9245\"]],");
    add_srs_wkt (p, 18,
        "AUTHORITY[\"EPSG\",\"9715\"]]");
    p = add_epsg_def_ex (filter, first, last, 9716, "epsg", 9716,
        "IGM95 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Istituto_Geografico_Militaire_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGM95 / UTM zone 34N\",GEOGCS[\"IGM95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Istituto_Geografico_Militaire_1995\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6670\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4670\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"971");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 9723, "epsg", 9723,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Genoa 1942 height\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4258\"]],VERT_CS[\"Genoa 1942 height\",VERT_D");
    add_srs_wkt (p, 8,
        "ATUM[\"Genoa 1942\",2005,AUTHORITY[\"EPSG\",\"1051\"]],U");
    add_srs_wkt (p, 9,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gra");
    add_srs_wkt (p, 10,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"5214\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9723\"]]");
    p = add_epsg_def_ex (filter, first, last, 9724, "epsg", 9724,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Catania 1965 height\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4258\"]],VERT_CS[\"Catania 1965 height\",VER");
    add_srs_wkt (p, 8,
        "T_DATUM[\"Catania 1965\",2005,AUTHORITY[\"EPSG\",\"1306\"");
    add_srs_wkt (p, 9,
        "]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 10,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"9721\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"9724\"]]");
    p = add_epsg_def_ex (filter, first, last, 9725, "epsg", 9725,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Cagliari 1956 height\",GEOGCS[\"ETRS");
    add_srs_wkt (p, 1,
        "89\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4258\"]],VERT_CS[\"Cagliari 1956 height\",VE");
    add_srs_wkt (p, 8,
        "RT_DATUM[\"Cagliari 1956\",2005,AUTHORITY[\"EPSG\",\"130");
    add_srs_wkt (p, 9,
        "7\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 10,
        "S[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 11,
        "22\"]],AUTHORITY[\"EPSG\",\"9725\"]]");
    p = add_epsg_def_ex (filter, first, last, 9739, "epsg", 9739,
        "EOS21-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "EOS21_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"EOS21-IRF\",DATUM[\"EOS21_Intermediate_Referenc");
    add_srs_wkt (p, 1,
        "e_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1308\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"9739\"]]");
    p = add_epsg_def_ex (filter, first, last, 9741, "epsg", 9741,
        "EOS21 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EOS21_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=56.35 +lon_0=-2.75 +k=1 +x_0=74996.92");
    add_proj4text (p, 1,
        "7 +y_0=133508.35 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"EOS21 Grid\",GEOGCS[\"EOS21-IRF\",DATUM[\"EOS21");
    add_srs_wkt (p, 1,
        "_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1308\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9739\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",56.35],PARAMETER[\"central_meridian\",-2");
    add_srs_wkt (p, 8,
        ".75],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",74996.927],PARAMETER[\"false_northing\",133508.35");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9741\"]]");
    p = add_epsg_def_ex (filter, first, last, 9742, "epsg", 9742,
        "EOS21 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EOS21_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=56.35 +lon_0=-2.75 +k=1 +x_0=74996.92");
    add_proj4text (p, 1,
        "7 +y_0=133508.35 +ellps=GRS80 +units=m +geoidgrids=uk_os");
    add_proj4text (p, 2,
        "_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"EOS21 Grid + ODN height\",PROJCS[\"EOS21 Grid");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"EOS21-IRF\",DATUM[\"EOS21_Intermediate_Refer");
    add_srs_wkt (p, 2,
        "ence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1308");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"9739\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",56");
    add_srs_wkt (p, 8,
        ".35],PARAMETER[\"central_meridian\",-2.75],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",74996.927],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",133508.35],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9741\"]],VER");
    add_srs_wkt (p, 13,
        "T_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn\"");
    add_srs_wkt (p, 14,
        ",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 16,
        "\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 17,
        "\"9742\"]]");
    p = add_epsg_def_ex (filter, first, last, 9748, "epsg", 9748,
        "NAD83(2011) / Alabama East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.8333333333333 +k=0.99");
    add_proj4text (p, 1,
        "996 +x_0=200000.0001016 +y_0=0 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alabama East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",30.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.8333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",656166.667],PARAMETER[\"false_northing\",0],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9748\"]]");
    p = add_epsg_def_ex (filter, first, last, 9749, "epsg", 9749,
        "NAD83(2011) / Alabama West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alabama West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",30],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-87.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999933333],PARAMETER[\"false_easting\",196850");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 11,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9749\"]]");
    p = add_epsg_def_ex (filter, first, last, 9754, "epsg", 9754,
        "WGS 84 (G2139)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G2139", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (G2139)\",DYNAMIC[FRAMEEPOCH[2016]],DAT");
    add_srs_wkt (p, 1,
        "UM[\"World Geodetic System 1984 (G2139)\",ELLIPSOID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 4,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 5,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 7,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 8,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 9,
        "[SCOPE[\"Geodesy. Navigation and positioning using GPS s");
    add_srs_wkt (p, 10,
        "atellite system.\"],AREA[\"World.\"],BBOX[-90,-180,90,18");
    add_srs_wkt (p, 11,
        "0]],ID[\"EPSG\",9754]]");
    p = add_epsg_def_ex (filter, first, last, 9755, "epsg", 9755,
        "WGS 84 (G2139)", 1, 1,
        "WGS 84", "Greenwich",
        "World_Geodetic_System_1984_G2139", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 84 (G2139)\",DATUM[\"World_Geodetic_System_");
    add_srs_wkt (p, 1,
        "1984_G2139\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1309\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9755\"]]");
    p = add_epsg_def_ex (filter, first, last, 9758, "epsg", 9758,
        "ECML14_NB-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "ECML14_NB_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ECML14_NB-IRF\",DATUM[\"ECML14_NB_Intermediate_");
    add_srs_wkt (p, 1,
        "Reference_Frame\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "1310\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"9758\"]]");
    p = add_epsg_def_ex (filter, first, last, 9761, "epsg", 9761,
        "ECML14_NB Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "ECML14_NB_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=55.05 +lon_0=-1.55 +k=1 +x_0=112242.8");
    add_proj4text (p, 1,
        "512 +y_0=402313.7432 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ECML14_NB Grid\",GEOGCS[\"ECML14_NB-IRF\",DATUM");
    add_srs_wkt (p, 1,
        "[\"ECML14_NB_Intermediate_Reference_Frame\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],AUTHORITY[\"EPSG\",\"1310\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9758\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",55.05],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-1.55],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",112242.8512],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",402313.7432],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9761\"]]");
    p = add_epsg_def_ex (filter, first, last, 9762, "epsg", 9762,
        "ECML14_NB Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "ECML14_NB_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=55.05 +lon_0=-1.55 +k=1 +x_0=112242.8");
    add_proj4text (p, 1,
        "512 +y_0=402313.7432 +ellps=GRS80 +units=m +geoidgrids=u");
    add_proj4text (p, 2,
        "k_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ECML14_NB Grid + ODN height\",PROJCS[\"ECML14");
    add_srs_wkt (p, 1,
        "_NB Grid\",GEOGCS[\"ECML14_NB-IRF\",DATUM[\"ECML14_NB_In");
    add_srs_wkt (p, 2,
        "termediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1310\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9758\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",55.05],PARAMETER[\"central_meridian\",-1.5");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",112242.8512],PARAMETER[\"false_northing\",402313.74");
    add_srs_wkt (p, 11,
        "32],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9761\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Ord");
    add_srs_wkt (p, 14,
        "nance Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]],");
    add_srs_wkt (p, 15,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gr");
    add_srs_wkt (p, 16,
        "avity-related height\",UP],AUTHORITY[\"EPSG\",\"5701\"]]");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"9762\"]]");
    p = add_epsg_def_ex (filter, first, last, 9763, "epsg", 9763,
        "EWR2-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "EWR2_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"EWR2-IRF\",DATUM[\"EWR2_Intermediate_Reference_");
    add_srs_wkt (p, 1,
        "Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1311\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9763\"]]");
    p = add_epsg_def_ex (filter, first, last, 9766, "epsg", 9766,
        "EWR2 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EWR2_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=51.95 +lon_0=-0.9 +k=1 +x_0=192519.97");
    add_proj4text (p, 1,
        "15 +y_0=146942.6806 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"EWR2 Grid\",GEOGCS[\"EWR2-IRF\",DATUM[\"EWR2_In");
    add_srs_wkt (p, 1,
        "termediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1311\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9763\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",51.95],PARAMETER[\"central_meridian\",-0.9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",192519.9715],PARAMETER[\"false_northing\",146942.680");
    add_srs_wkt (p, 10,
        "6],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9766\"]]");
    p = add_epsg_def_ex (filter, first, last, 9767, "epsg", 9767,
        "EWR2 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "EWR2_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=51.95 +lon_0=-0.9 +k=1 +x_0=192519.97");
    add_proj4text (p, 1,
        "15 +y_0=146942.6806 +ellps=GRS80 +units=m +geoidgrids=uk");
    add_proj4text (p, 2,
        "_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"EWR2 Grid + ODN height\",PROJCS[\"EWR2 Grid\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"EWR2-IRF\",DATUM[\"EWR2_Intermediate_Reference");
    add_srs_wkt (p, 2,
        "_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1311\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9763\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",51.95]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-0.9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",192519.9715],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",146942.6806],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9766\"]],VERT");
    add_srs_wkt (p, 13,
        "_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn\",");
    add_srs_wkt (p, 14,
        "2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 16,
        ",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "9767\"]]");
    p = add_epsg_def_ex (filter, first, last, 9776, "epsg", 9776,
        "RGF93 v2", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93 v2\",DATUM[\"Reseau Geodesique Francais ");
    add_srs_wkt (p, 1,
        "1993 v2\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,L");
    add_srs_wkt (p, 2,
        "ENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNI");
    add_srs_wkt (p, 3,
        "T[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS");
    add_srs_wkt (p, 4,
        "[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433]],AXIS[\"geodetic longitude ");
    add_srs_wkt (p, 6,
        "(Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENG");
    add_srs_wkt (p, 8,
        "THUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, land an");
    add_srs_wkt (p, 9,
        "d sea navigation and safety of life purposes.\"],AREA[\"");
    add_srs_wkt (p, 10,
        "France - onshore and offshore, mainland and Corsica.\"],");
    add_srs_wkt (p, 11,
        "BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",9776]]");
    p = add_epsg_def_ex (filter, first, last, 9777, "epsg", 9777,
        "RGF93 v2", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 v2\",DATUM[\"Reseau_Geodesique_Francais_1");
    add_srs_wkt (p, 1,
        "993_v2\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1312\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9777\"]]");
    p = add_epsg_def_ex (filter, first, last, 9778, "epsg", 9778,
        "RGF93 v2 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93 v2 (lon-lat)\",DATUM[\"Reseau Geodesique");
    add_srs_wkt (p, 1,
        " Francais 1993 v2\",ELLIPSOID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 4,
        "al,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],AN");
    add_srs_wkt (p, 5,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic ");
    add_srs_wkt (p, 6,
        "latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORD");
    add_srs_wkt (p, 8,
        "ER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"France - onshore and offshore, mainland and Corsica.");
    add_srs_wkt (p, 10,
        "\"],BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",9778]]");
    p = add_epsg_def_ex (filter, first, last, 9779, "epsg", 9779,
        "RGF93 v2 (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 v2 (lon-lat)\",DATUM[\"Reseau_Geodesique_");
    add_srs_wkt (p, 1,
        "Francais_1993_v2\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AUTHORITY[\"EPSG\",\"9779\"]]");
    p = add_epsg_def_ex (filter, first, last, 9781, "epsg", 9781,
        "RGF93 v2b", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93 v2b\",DATUM[\"Reseau Geodesique Francais");
    add_srs_wkt (p, 1,
        " 1993 v2b\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy; air, land ");
    add_srs_wkt (p, 9,
        "and sea navigation and safety of life purposes.\"],AREA[");
    add_srs_wkt (p, 10,
        "\"France - onshore and offshore, mainland and Corsica.\"");
    add_srs_wkt (p, 11,
        "],BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",9781]]");
    p = add_epsg_def_ex (filter, first, last, 9782, "epsg", 9782,
        "RGF93 v2b", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 v2b\",DATUM[\"Reseau_Geodesique_Francais_");
    add_srs_wkt (p, 1,
        "1993_v2b\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1313\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9782\"]]");
    p = add_epsg_def_ex (filter, first, last, 9783, "epsg", 9783,
        "RGF93 v2b (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93 v2b (lon-lat)\",DATUM[\"Reseau Geodesiqu");
    add_srs_wkt (p, 1,
        "e Francais 1993 v2b\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic longitude (Lon)\",east,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " latitude (Lat)\",north,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"GIS.\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"France - onshore and offshore, mainland and Corsica");
    add_srs_wkt (p, 10,
        ".\"],BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",9783]]");
    p = add_epsg_def_ex (filter, first, last, 9784, "epsg", 9784,
        "RGF93 v2b (lon-lat)", 1, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "none", "degree",
        "Geodetic longitude", "East", "Geodetic latitude", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93 v2b (lon-lat)\",DATUM[\"Reseau_Geodesique");
    add_srs_wkt (p, 1,
        "_Francais_1993_v2b\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1313\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Longitude\",EAST],AXIS[\"Latitu");
    add_srs_wkt (p, 6,
        "de\",NORTH],AUTHORITY[\"EPSG\",\"9784\"]]");
    p = add_epsg_def_ex (filter, first, last, 9785, "epsg", 9785,
        "RGF93 v2b", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RGF93 v2b + NGF-IGN69 height\",GEOGCS[\"RGF93");
    add_srs_wkt (p, 1,
        " v2b\",DATUM[\"Reseau_Geodesique_Francais_1993_v2b\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9782\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM");
    add_srs_wkt (p, 8,
        "[\"Nivellement General de la France - IGN69\",2005,AUTHO");
    add_srs_wkt (p, 9,
        "RITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 10,
        "SG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"9785\"]]");
    p = add_epsg_def_ex (filter, first, last, 9793, "epsg", 9793,
        "RGF93 v2 / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=46.5 +lon_0=3 +lat_1=49 +lat_2=44 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / Lambert-93\",GEOGCS[\"RGF93 v2\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Reseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9777\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",3],PARAMETER[\"standard_parallel_1\",49],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",44],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",700000],PARAMETER[\"false_northing\",6600000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9793\"]]");
    p = add_epsg_def_ex (filter, first, last, 9794, "epsg", 9794,
        "RGF93 v2b / Lambert-93", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=46.5 +lon_0=3 +lat_1=49 +lat_2=44 +x_0=");
    add_proj4text (p, 1,
        "700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / Lambert-93\",GEOGCS[\"RGF93 v2b\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",3],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"standard_parallel_2\",44],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",700000],PARAMETER[\"false_northing\",660000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9794\"]]");
    p = add_epsg_def_ex (filter, first, last, 9821, "epsg", 9821,
        "UCS-2000 / LCS-32 Kyiv region", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-32 Kyiv region\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",30.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",300");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9821\"]]");
    p = add_epsg_def_ex (filter, first, last, 9822, "epsg", 9822,
        "RGF93 v2 / CC42", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=42 +lon_0=3 +lat_1=41.25 +lat_2=42.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC42\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",42],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",41.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",42.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",1200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9822\"]]");
    p = add_epsg_def_ex (filter, first, last, 9823, "epsg", 9823,
        "RGF93 v2 / CC43", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43 +lon_0=3 +lat_1=42.25 +lat_2=43.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC43\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",43],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",42.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",43.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",2200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9823\"]]");
    p = add_epsg_def_ex (filter, first, last, 9824, "epsg", 9824,
        "RGF93 v2 / CC44", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=44 +lon_0=3 +lat_1=43.25 +lat_2=44.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC44\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",44],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",43.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",44.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",3200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9824\"]]");
    p = add_epsg_def_ex (filter, first, last, 9825, "epsg", 9825,
        "RGF93 v2 / CC45", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45 +lon_0=3 +lat_1=44.25 +lat_2=45.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC45\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",45],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",44.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",45.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",4200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9825\"]]");
    p = add_epsg_def_ex (filter, first, last, 9826, "epsg", 9826,
        "RGF93 v2 / CC46", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=46 +lon_0=3 +lat_1=45.25 +lat_2=46.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC46\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",46],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",45.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",46.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",5200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9826\"]]");
    p = add_epsg_def_ex (filter, first, last, 9827, "epsg", 9827,
        "RGF93 v2 / CC47", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=47 +lon_0=3 +lat_1=46.25 +lat_2=47.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC47\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",47],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",46.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",47.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",6200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9827\"]]");
    p = add_epsg_def_ex (filter, first, last, 9828, "epsg", 9828,
        "RGF93 v2 / CC48", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=48 +lon_0=3 +lat_1=47.25 +lat_2=48.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC48\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",48],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",47.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",48.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",7200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9828\"]]");
    p = add_epsg_def_ex (filter, first, last, 9829, "epsg", 9829,
        "RGF93 v2 / CC49", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=49 +lon_0=3 +lat_1=48.25 +lat_2=49.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC49\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",49],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",48.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",49.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",8200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9829\"]]");
    p = add_epsg_def_ex (filter, first, last, 9830, "epsg", 9830,
        "RGF93 v2 / CC50", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=50 +lon_0=3 +lat_1=49.25 +lat_2=50.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2 / CC50\",GEOGCS[\"RGF93 v2\",DATUM[\"R");
    add_srs_wkt (p, 1,
        "eseau_Geodesique_Francais_1993_v2\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"97");
    add_srs_wkt (p, 6,
        "77\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",50],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",3],PARAMETER[\"standard_parallel_1\",49.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",50.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1700000],PARAMETER[\"false_northing\",9200000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9830\"]]");
    p = add_epsg_def_ex (filter, first, last, 9831, "epsg", 9831,
        "UCS-2000 / LCS-01 Crimea", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-01 Crimea\",GEOGCS[\"UCS-2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",6378");
    add_srs_wkt (p, 2,
        "245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",34.5],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"scale_factor\",1],PARAMETER[\"false_easting\",300000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9831\"]]");
    p = add_epsg_def_ex (filter, first, last, 9832, "epsg", 9832,
        "UCS-2000 / LCS-05 Vinnytsia", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.6666666666667 +k=1 +x_0=3");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-05 Vinnytsia\",GEOGCS[\"UCS-2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",6");
    add_srs_wkt (p, 2,
        "378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",28.666666666");
    add_srs_wkt (p, 8,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",300000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9832");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 9833, "epsg", 9833,
        "UCS-2000 / LCS-07 Volyn", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24.8333333333333 +k=1 +x_0=3");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-07 Volyn\",GEOGCS[\"UCS-2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",63782");
    add_srs_wkt (p, 2,
        "45,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",24.8333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",300000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9833\"]]");
    p = add_epsg_def_ex (filter, first, last, 9834, "epsg", 9834,
        "UCS-2000 / LCS-12 Dnipropetrovsk", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=35 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-12 Dnipropetrovsk\",GEOGCS[\"UCS");
    add_srs_wkt (p, 1,
        "-2000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 194");
    add_srs_wkt (p, 2,
        "0\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",35],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 9,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9834\"]]");
    p = add_epsg_def_ex (filter, first, last, 9835, "epsg", 9835,
        "UCS-2000 / LCS-14 Donetsk", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=37.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-14 Donetsk\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",37.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9835\"]]");
    p = add_epsg_def_ex (filter, first, last, 9836, "epsg", 9836,
        "UCS-2000 / LCS-18 Zhytomyr", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-18 Zhytomyr\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",28.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9836\"]]");
    p = add_epsg_def_ex (filter, first, last, 9837, "epsg", 9837,
        "UCS-2000 / LCS-21 Zakarpattia", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-21 Zakarpattia\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",23.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",300");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9837\"]]");
    p = add_epsg_def_ex (filter, first, last, 9838, "epsg", 9838,
        "UCS-2000 / LCS-23 Zaporizhzhia", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-23 Zaporizhzhia\",GEOGCS[\"UCS-2");
    add_srs_wkt (p, 1,
        "000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",36],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9838\"]]");
    p = add_epsg_def_ex (filter, first, last, 9839, "epsg", 9839,
        "UCS-2000 / LCS-26 Ivano-Frankivsk", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24.75 +k=1 +x_0=300000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-26 Ivano-Frankivsk\",GEOGCS[\"UC");
    add_srs_wkt (p, 1,
        "S-2000\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 19");
    add_srs_wkt (p, 2,
        "40\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",24.75]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",300000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9839\"]]");
    p = add_epsg_def_ex (filter, first, last, 9840, "epsg", 9840,
        "UCS-2000 / LCS-35 Kirovohrad", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=32 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-35 Kirovohrad\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",32],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9840\"]]");
    p = add_epsg_def_ex (filter, first, last, 9841, "epsg", 9841,
        "UCS-2000 / LCS-44 Luhansk", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-44 Luhansk\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",39],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",300000],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"9841\"]]");
    p = add_epsg_def_ex (filter, first, last, 9842, "epsg", 9842,
        "RGF93 v2b / CC42", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=42 +lon_0=3 +lat_1=41.25 +lat_2=42.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC42\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",42],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",41.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",42.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",1200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9842\"]]");
    p = add_epsg_def_ex (filter, first, last, 9843, "epsg", 9843,
        "RGF93 v2b / CC43", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43 +lon_0=3 +lat_1=42.25 +lat_2=43.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC43\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",43],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",42.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",43.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",2200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9843\"]]");
    p = add_epsg_def_ex (filter, first, last, 9844, "epsg", 9844,
        "RGF93 v2b / CC44", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=44 +lon_0=3 +lat_1=43.25 +lat_2=44.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC44\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",44],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",43.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",44.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",3200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9844\"]]");
    p = add_epsg_def_ex (filter, first, last, 9845, "epsg", 9845,
        "RGF93 v2b / CC45", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45 +lon_0=3 +lat_1=44.25 +lat_2=45.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC45\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",45],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",44.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",45.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",4200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9845\"]]");
    p = add_epsg_def_ex (filter, first, last, 9846, "epsg", 9846,
        "RGF93 v2b / CC46", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=46 +lon_0=3 +lat_1=45.25 +lat_2=46.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC46\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",46],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",45.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",46.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",5200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9846\"]]");
    p = add_epsg_def_ex (filter, first, last, 9847, "epsg", 9847,
        "RGF93 v2b / CC47", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=47 +lon_0=3 +lat_1=46.25 +lat_2=47.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC47\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",47],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",46.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",47.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",6200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9847\"]]");
    p = add_epsg_def_ex (filter, first, last, 9848, "epsg", 9848,
        "RGF93 v2b / CC48", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=48 +lon_0=3 +lat_1=47.25 +lat_2=48.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC48\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",48],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",47.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",48.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",7200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9848\"]]");
    p = add_epsg_def_ex (filter, first, last, 9849, "epsg", 9849,
        "RGF93 v2b / CC49", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=49 +lon_0=3 +lat_1=48.25 +lat_2=49.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC49\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",49],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",48.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",49.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",8200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9849\"]]");
    p = add_epsg_def_ex (filter, first, last, 9850, "epsg", 9850,
        "RGF93 v2b / CC50", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993_v2b", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=50 +lon_0=3 +lat_1=49.25 +lat_2=50.75 +");
    add_proj4text (p, 1,
        "x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGF93 v2b / CC50\",GEOGCS[\"RGF93 v2b\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Reseau_Geodesique_Francais_1993_v2b\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1313\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9782\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",50],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"standard_parallel_1\",49.25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",50.75],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1700000],PARAMETER[\"false_northing\",9200000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9850\"]]");
    p = add_epsg_def_ex (filter, first, last, 9851, "epsg", 9851,
        "UCS-2000 / LCS-46 Lviv", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-46 Lviv\",GEOGCS[\"UCS-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637824");
    add_srs_wkt (p, 2,
        "5,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",24],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 10,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"9851\"]]");
    p = add_epsg_def_ex (filter, first, last, 9852, "epsg", 9852,
        "UCS-2000 / LCS-48 Mykolaiv", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31.8333333333333 +k=1 +x_0=3");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-48 Mykolaiv\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",31.83333333333");
    add_srs_wkt (p, 8,
        "33],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",300000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9852\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 9853, "epsg", 9853,
        "UCS-2000 / LCS-51 Odessa", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-51 Odessa\",GEOGCS[\"UCS-2000\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",6378");
    add_srs_wkt (p, 2,
        "245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",30],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",1],PARAMETER[\"false_easting\",300000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"9853\"]]");
    p = add_epsg_def_ex (filter, first, last, 9854, "epsg", 9854,
        "UCS-2000 / LCS-53 Poltava", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33.8333333333333 +k=1 +x_0=3");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-53 Poltava\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",33.83333333333");
    add_srs_wkt (p, 8,
        "33],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",300000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9854\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 9855, "epsg", 9855,
        "UCS-2000 / LCS-56 Rivne", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-56 Rivne\",GEOGCS[\"UCS-2000\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",63782");
    add_srs_wkt (p, 2,
        "45,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 10,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"9855\"]]");
    p = add_epsg_def_ex (filter, first, last, 9856, "epsg", 9856,
        "UCS-2000 / LCS-59 Sumy", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-59 Sumy\",GEOGCS[\"UCS-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637824");
    add_srs_wkt (p, 2,
        "5,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",34.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",1],PARAMETER[\"false_easting\",300000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"9856\"]]");
    p = add_epsg_def_ex (filter, first, last, 9857, "epsg", 9857,
        "UCS-2000 / LCS-61 Ternopil", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-61 Ternopil\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",25.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9857\"]]");
    p = add_epsg_def_ex (filter, first, last, 9858, "epsg", 9858,
        "UCS-2000 / LCS-63 Kharkiv", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-63 Kharkiv\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",36.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9858\"]]");
    p = add_epsg_def_ex (filter, first, last, 9859, "epsg", 9859,
        "UCS-2000 / LCS-65 Kherson", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-65 Kherson\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",33.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9859\"]]");
    p = add_epsg_def_ex (filter, first, last, 9860, "epsg", 9860,
        "UCS-2000 / LCS-68 Khmelnytsky", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-68 Khmelnytsky\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",27],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9860\"]]");
    p = add_epsg_def_ex (filter, first, last, 9861, "epsg", 9861,
        "UCS-2000 / LCS-71 Cherkasy", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-71 Cherkasy\",GEOGCS[\"UCS-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",637");
    add_srs_wkt (p, 2,
        "8245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",31.5],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9861\"]]");
    p = add_epsg_def_ex (filter, first, last, 9862, "epsg", 9862,
        "UCS-2000 / LCS-73 Chernivtsi", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-73 Chernivtsi\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",26],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9862\"]]");
    p = add_epsg_def_ex (filter, first, last, 9863, "epsg", 9863,
        "UCS-2000 / LCS-74 Chernihiv", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=32 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-74 Chernihiv\",GEOGCS[\"UCS-2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",6");
    add_srs_wkt (p, 2,
        "378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",32],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9863\"]]");
    p = add_epsg_def_ex (filter, first, last, 9864, "epsg", 9864,
        "UCS-2000 / LCS-80 Kyiv city", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=300000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-80 Kyiv city\",GEOGCS[\"UCS-2000");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",6");
    add_srs_wkt (p, 2,
        "378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",30.5],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3000");
    add_srs_wkt (p, 9,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9864\"]]");
    p = add_epsg_def_ex (filter, first, last, 9865, "epsg", 9865,
        "UCS-2000 / LCS-85 Sevastopol", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / LCS-85 Sevastopol\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1077\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5561\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",33],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"9865\"]]");
    p = add_epsg_def_ex (filter, first, last, 9866, "epsg", 9866,
        "MRH21-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "MRH21_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MRH21-IRF\",DATUM[\"MRH21_Intermediate_Referenc");
    add_srs_wkt (p, 1,
        "e_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1314\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"9866\"]]");
    p = add_epsg_def_ex (filter, first, last, 9869, "epsg", 9869,
        "MRH21 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MRH21_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.3 +lon_0=-1.8 +k=1 +x_0=227286.988");
    add_proj4text (p, 1,
        "1 +y_0=265751.2874 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MRH21 Grid\",GEOGCS[\"MRH21-IRF\",DATUM[\"MRH21");
    add_srs_wkt (p, 1,
        "_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1314\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9866\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",52.3],PARAMETER[\"central_meridian\",-1.");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",227286.9881],PARAMETER[\"false_northing\",265751.28");
    add_srs_wkt (p, 10,
        "74],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9869\"]]");
    p = add_epsg_def_ex (filter, first, last, 9870, "epsg", 9870,
        "MRH21 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MRH21_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.3 +lon_0=-1.8 +k=1 +x_0=227286.988");
    add_proj4text (p, 1,
        "1 +y_0=265751.2874 +ellps=GRS80 +units=m +geoidgrids=uk_");
    add_proj4text (p, 2,
        "os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"MRH21 Grid + ODN height\",PROJCS[\"MRH21 Grid");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"MRH21-IRF\",DATUM[\"MRH21_Intermediate_Refer");
    add_srs_wkt (p, 2,
        "ence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1314");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"9866\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",52");
    add_srs_wkt (p, 8,
        ".3],PARAMETER[\"central_meridian\",-1.8],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",227286.9881],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",265751.2874],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9869\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn");
    add_srs_wkt (p, 14,
        "\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related heig");
    add_srs_wkt (p, 16,
        "ht\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9870\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

