## About

*Libconfig* is a simple library for processing structured configuration 
files, like [this one](test.cfg.txt). This file format is more compact 
and more readable than XML. And unlike XML, it is type-aware, so it is 
not necessary to do string parsing in application code.

*Libconfig* is very compact -- a fraction of the size of the _expat_ XML 
parser library. This makes it well-suited for memory-constrained systems 
like handheld devices.

The library includes bindings for both the C and C++ languages. It works 
on POSIX-compliant UNIX and UNIX-like systems (GNU/Linux, Mac OS X, 
FreeBSD), Android, and Windows (2000, XP and later).

## Documentation

Documentation is included in the distribution
in the form of a _texinfo_ manual. The documentation is
also available in the following formats:

- [HTML](libconfig_manual.html)
- [PDF](libconfig_manual.pdf)

## License

*Libconfig* is distributed under the terms of the [GNU Lesser General 
Public License](http://www.gnu.org/licenses/lgpl.html). This license was 
chosen over the standard GNU license to allow *libconfig* to be used 
with non-free programs.

## Downloads

Download *libconfig* now! Source code and full documentation are 
included. Windows users may build the package using either gcc in the 
MinGW environment or with Visual Studio 2008 or later using the provided 
solution file.

<center>
<a href="dist/libconfig-1.7.2.tar.gz"><b>libconfig-1.7.2.tar.gz</b></a>
</center>
