/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-alpha.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of the 3MF Library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 2.4.1

*/

#include "lib3mf_abi.hpp"
#include "lib3mf_interfaces.hpp"
#include "lib3mf_interfaceexception.hpp"
#include "lib3mf_interfacejournal.hpp"

#include <map>

using namespace Lib3MF::Impl;

PLib3MFInterfaceJournal m_GlobalJournal;

Lib3MFResult handleLib3MFException(IBase * pIBaseClass, ELib3MFInterfaceException & Exception, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = Exception.getErrorCode();

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

Lib3MFResult handleStdException(IBase * pIBaseClass, std::exception & Exception, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = LIB3MF_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

Lib3MFResult handleUnhandledException(IBase * pIBaseClass, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = LIB3MF_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/
Lib3MFResult lib3mf_base_classtypeid(Lib3MF_Base pBase, Lib3MF_uint64 * pClassTypeId)
{
	IBase* pIBaseClass = (IBase *)pBase;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBase, "Base", "ClassTypeId");
		}
		if (pClassTypeId == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBase = dynamic_cast<IBase*>(pIBaseClass);
		if (!pIBase)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pClassTypeId = pIBase->ClassTypeId();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("ClassTypeId", *pClassTypeId);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Writer
**************************************************************************************************************************/
Lib3MFResult lib3mf_writer_writetofile(Lib3MF_Writer pWriter, const char * pFilename)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToFile");
			pJournalEntry->addStringParameter("Filename", pFilename);
		}
		if (pFilename == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFilename(pFilename);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToFile(sFilename);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getstreamsize(Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetStreamSize");
		}
		if (pStreamSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStreamSize = pIWriter->GetStreamSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("StreamSize", *pStreamSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_writetobuffer(Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToBuffer");
		}
		if ((!pBufferBuffer) && !(pBufferNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToBuffer(nBufferBufferSize, pBufferNeededCount, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_writetocallback(Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToCallback(pTheWriteCallback, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setprogresscallback(Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetProgressCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetProgressCallback(pProgressCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetDecimalPrecision");
		}
		if (pDecimalPrecision == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pDecimalPrecision = pIWriter->GetDecimalPrecision();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("DecimalPrecision", *pDecimalPrecision);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetDecimalPrecision");
			pJournalEntry->addUInt32Parameter("DecimalPrecision", nDecimalPrecision);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetDecimalPrecision(nDecimalPrecision);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setstrictmodeactive(Lib3MF_Writer pWriter, bool bStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetStrictModeActive");
			pJournalEntry->addBooleanParameter("StrictModeActive", bStrictModeActive);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetStrictModeActive(bStrictModeActive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getstrictmodeactive(Lib3MF_Writer pWriter, bool * pStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetStrictModeActive");
		}
		if (pStrictModeActive == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStrictModeActive = pIWriter->GetStrictModeActive();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("StrictModeActive", *pStrictModeActive);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getwarning(Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetWarning");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pErrorCode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pWarningBuffer) && !(pWarningNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWarning("");
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pWarningBuffer == nullptr);
		if (isCacheCall) {
			sWarning = pIWriter->GetWarning(nIndex, *pErrorCode);

			pIWriter->_setCache (new ParameterCache_2<Lib3MF_uint32, std::string> (*pErrorCode, sWarning));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<Lib3MF_uint32, std::string>*> (pIWriter->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pErrorCode, sWarning);
			pIWriter->_setCache (nullptr);
		}
		
		if (pWarningNeededChars)
			*pWarningNeededChars = (Lib3MF_uint32) (sWarning.size()+1);
		if (pWarningBuffer) {
			if (sWarning.size() >= nWarningBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iWarning = 0; iWarning < sWarning.size(); iWarning++)
				pWarningBuffer[iWarning] = sWarning[iWarning];
			pWarningBuffer[sWarning.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ErrorCode", *pErrorCode);
			pJournalEntry->addStringResult("Warning", sWarning.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getwarningcount(Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetWarningCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIWriter->GetWarningCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_addkeywrappingcallback(Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "AddKeyWrappingCallback");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->AddKeyWrappingCallback(sConsumerID, pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setcontentencryptioncallback(Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetContentEncryptionCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetContentEncryptionCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Reader
**************************************************************************************************************************/
Lib3MFResult lib3mf_reader_readfromfile(Lib3MF_Reader pReader, const char * pFilename)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromFile");
			pJournalEntry->addStringParameter("Filename", pFilename);
		}
		if (pFilename == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFilename(pFilename);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromFile(sFilename);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_readfrombuffer(Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromBuffer");
		}
		if ( (!pBufferBuffer) && (nBufferBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromBuffer(nBufferBufferSize, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_readfromcallback(Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromCallback");
			pJournalEntry->addUInt64Parameter("StreamSize", nStreamSize);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromCallback(pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setprogresscallback(Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetProgressCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetProgressCallback(pProgressCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_addrelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "AddRelationToRead");
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sRelationShipType(pRelationShipType);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->AddRelationToRead(sRelationShipType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_removerelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "RemoveRelationToRead");
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sRelationShipType(pRelationShipType);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->RemoveRelationToRead(sRelationShipType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setstrictmodeactive(Lib3MF_Reader pReader, bool bStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetStrictModeActive");
			pJournalEntry->addBooleanParameter("StrictModeActive", bStrictModeActive);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetStrictModeActive(bStrictModeActive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getstrictmodeactive(Lib3MF_Reader pReader, bool * pStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetStrictModeActive");
		}
		if (pStrictModeActive == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStrictModeActive = pIReader->GetStrictModeActive();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("StrictModeActive", *pStrictModeActive);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getwarning(Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetWarning");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pErrorCode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pWarningBuffer) && !(pWarningNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWarning("");
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pWarningBuffer == nullptr);
		if (isCacheCall) {
			sWarning = pIReader->GetWarning(nIndex, *pErrorCode);

			pIReader->_setCache (new ParameterCache_2<Lib3MF_uint32, std::string> (*pErrorCode, sWarning));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<Lib3MF_uint32, std::string>*> (pIReader->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pErrorCode, sWarning);
			pIReader->_setCache (nullptr);
		}
		
		if (pWarningNeededChars)
			*pWarningNeededChars = (Lib3MF_uint32) (sWarning.size()+1);
		if (pWarningBuffer) {
			if (sWarning.size() >= nWarningBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iWarning = 0; iWarning < sWarning.size(); iWarning++)
				pWarningBuffer[iWarning] = sWarning[iWarning];
			pWarningBuffer[sWarning.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ErrorCode", *pErrorCode);
			pJournalEntry->addStringResult("Warning", sWarning.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getwarningcount(Lib3MF_Reader pReader, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetWarningCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIReader->GetWarningCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_addkeywrappingcallback(Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "AddKeyWrappingCallback");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->AddKeyWrappingCallback(sConsumerID, pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setcontentencryptioncallback(Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetContentEncryptionCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetContentEncryptionCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for PackagePart
**************************************************************************************************************************/
Lib3MFResult lib3mf_packagepart_getpath(Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pPackagePart;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pPackagePart, "PackagePart", "GetPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClass);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPathBuffer == nullptr);
		if (isCacheCall) {
			sPath = pIPackagePart->GetPath();

			pIPackagePart->_setCache (new ParameterCache_1<std::string> (sPath));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIPackagePart->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPath);
			pIPackagePart->_setCache (nullptr);
		}
		
		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_packagepart_setpath(Lib3MF_PackagePart pPackagePart, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pPackagePart;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pPackagePart, "PackagePart", "SetPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClass);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIPackagePart->SetPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Resource
**************************************************************************************************************************/
Lib3MFResult lib3mf_resource_getresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIResource->GetResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_getuniqueresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetUniqueResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIResource->GetUniqueResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_packagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "PackagePart");
		}
		if (pPackagePart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePackagePart(nullptr);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePackagePart = pIResource->PackagePart();

		*pPackagePart = (IBase*)(pBasePackagePart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("PackagePart", *pPackagePart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_setpackagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "SetPackagePart");
			pJournalEntry->addHandleParameter("PackagePart", pPackagePart);
		}
		IBase* pIBaseClassPackagePart = (IBase *)pPackagePart;
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClassPackagePart);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResource->SetPackagePart(pIPackagePart);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_getmodelresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetModelResourceID");
		}
		if (pModelResourceId == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pModelResourceId = pIResource->GetModelResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ModelResourceId", *pModelResourceId);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourceiterator_movenext(Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "MoveNext");
		}
		if (pHasNext == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasNext = pIResourceIterator->MoveNext();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasNext", *pHasNext);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_moveprevious(Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "MovePrevious");
		}
		if (pHasPrevious == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasPrevious = pIResourceIterator->MovePrevious();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrevious", *pHasPrevious);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_getcurrent(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "GetCurrent");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIResourceIterator->GetCurrent();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_clone(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "Clone");
		}
		if (pOutResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseOutResourceIterator(nullptr);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutResourceIterator = pIResourceIterator->Clone();

		*pOutResourceIterator = (IBase*)(pBaseOutResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("OutResourceIterator", *pOutResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_count(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "Count");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIResourceIterator->Count();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for SliceStackIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_slicestackiterator_getcurrentslicestack(Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource)
{
	IBase* pIBaseClass = (IBase *)pSliceStackIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStackIterator, "SliceStackIterator", "GetCurrentSliceStack");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ISliceStackIterator* pISliceStackIterator = dynamic_cast<ISliceStackIterator*>(pIBaseClass);
		if (!pISliceStackIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pISliceStackIterator->GetCurrentSliceStack();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_objectiterator_getcurrentobject(Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource)
{
	IBase* pIBaseClass = (IBase *)pObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObjectIterator, "ObjectIterator", "GetCurrentObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IObjectIterator* pIObjectIterator = dynamic_cast<IObjectIterator*>(pIBaseClass);
		if (!pIObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIObjectIterator->GetCurrentObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MeshObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_meshobjectiterator_getcurrentmeshobject(Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource)
{
	IBase* pIBaseClass = (IBase *)pMeshObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObjectIterator, "MeshObjectIterator", "GetCurrentMeshObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IMeshObjectIterator* pIMeshObjectIterator = dynamic_cast<IMeshObjectIterator*>(pIBaseClass);
		if (!pIMeshObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIMeshObjectIterator->GetCurrentMeshObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComponentsObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_componentsobjectiterator_getcurrentcomponentsobject(Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource)
{
	IBase* pIBaseClass = (IBase *)pComponentsObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObjectIterator, "ComponentsObjectIterator", "GetCurrentComponentsObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IComponentsObjectIterator* pIComponentsObjectIterator = dynamic_cast<IComponentsObjectIterator*>(pIBaseClass);
		if (!pIComponentsObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIComponentsObjectIterator->GetCurrentComponentsObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2diterator_getcurrenttexture2d(Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource)
{
	IBase* pIBaseClass = (IBase *)pTexture2DIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DIterator, "Texture2DIterator", "GetCurrentTexture2D");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ITexture2DIterator* pITexture2DIterator = dynamic_cast<ITexture2DIterator*>(pIBaseClass);
		if (!pITexture2DIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pITexture2DIterator->GetCurrentTexture2D();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BaseMaterialGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroupIterator, "BaseMaterialGroupIterator", "GetCurrentBaseMaterialGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IBaseMaterialGroupIterator* pIBaseMaterialGroupIterator = dynamic_cast<IBaseMaterialGroupIterator*>(pIBaseClass);
		if (!pIBaseMaterialGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIBaseMaterialGroupIterator->GetCurrentBaseMaterialGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ColorGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_colorgroupiterator_getcurrentcolorgroup(Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pColorGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroupIterator, "ColorGroupIterator", "GetCurrentColorGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IColorGroupIterator* pIColorGroupIterator = dynamic_cast<IColorGroupIterator*>(pIBaseClass);
		if (!pIColorGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIColorGroupIterator->GetCurrentColorGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroupIterator, "Texture2DGroupIterator", "GetCurrentTexture2DGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ITexture2DGroupIterator* pITexture2DGroupIterator = dynamic_cast<ITexture2DGroupIterator*>(pIBaseClass);
		if (!pITexture2DGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pITexture2DGroupIterator->GetCurrentTexture2DGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for CompositeMaterialsIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_compositematerialsiterator_getcurrentcompositematerials(Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterialsIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterialsIterator, "CompositeMaterialsIterator", "GetCurrentCompositeMaterials");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ICompositeMaterialsIterator* pICompositeMaterialsIterator = dynamic_cast<ICompositeMaterialsIterator*>(pIBaseClass);
		if (!pICompositeMaterialsIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pICompositeMaterialsIterator->GetCurrentCompositeMaterials();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MultiPropertyGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroupIterator, "MultiPropertyGroupIterator", "GetCurrentMultiPropertyGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IMultiPropertyGroupIterator* pIMultiPropertyGroupIterator = dynamic_cast<IMultiPropertyGroupIterator*>(pIBaseClass);
		if (!pIMultiPropertyGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIMultiPropertyGroupIterator->GetCurrentMultiPropertyGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Image3DIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_image3diterator_getcurrentimage3d(Lib3MF_Image3DIterator pImage3DIterator, Lib3MF_Image3D * pResource)
{
	IBase* pIBaseClass = (IBase *)pImage3DIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImage3DIterator, "Image3DIterator", "GetCurrentImage3D");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IImage3DIterator* pIImage3DIterator = dynamic_cast<IImage3DIterator*>(pIBaseClass);
		if (!pIImage3DIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIImage3DIterator->GetCurrentImage3D();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for FunctionIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_functioniterator_getcurrentfunction(Lib3MF_FunctionIterator pFunctionIterator, Lib3MF_Function * pResource)
{
	IBase* pIBaseClass = (IBase *)pFunctionIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionIterator, "FunctionIterator", "GetCurrentFunction");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IFunctionIterator* pIFunctionIterator = dynamic_cast<IFunctionIterator*>(pIBaseClass);
		if (!pIFunctionIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIFunctionIterator->GetCurrentFunction();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for LevelSetIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_levelsetiterator_getcurrentlevelset(Lib3MF_LevelSetIterator pLevelSetIterator, Lib3MF_LevelSet * pResource)
{
	IBase* pIBaseClass = (IBase *)pLevelSetIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSetIterator, "LevelSetIterator", "GetCurrentLevelSet");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ILevelSetIterator* pILevelSetIterator = dynamic_cast<ILevelSetIterator*>(pIBaseClass);
		if (!pILevelSetIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pILevelSetIterator->GetCurrentLevelSet();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MetaData
**************************************************************************************************************************/
Lib3MFResult lib3mf_metadata_getnamespace(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetNameSpace");
		}
		if ( (!pNameSpaceBuffer) && !(pNameSpaceNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameSpaceBuffer == nullptr);
		if (isCacheCall) {
			sNameSpace = pIMetaData->GetNameSpace();

			pIMetaData->_setCache (new ParameterCache_1<std::string> (sNameSpace));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIMetaData->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sNameSpace);
			pIMetaData->_setCache (nullptr);
		}
		
		if (pNameSpaceNeededChars)
			*pNameSpaceNeededChars = (Lib3MF_uint32) (sNameSpace.size()+1);
		if (pNameSpaceBuffer) {
			if (sNameSpace.size() >= nNameSpaceBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iNameSpace = 0; iNameSpace < sNameSpace.size(); iNameSpace++)
				pNameSpaceBuffer[iNameSpace] = sNameSpace[iNameSpace];
			pNameSpaceBuffer[sNameSpace.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("NameSpace", sNameSpace.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setnamespace(Lib3MF_MetaData pMetaData, const char * pNameSpace)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetNameSpace");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetNameSpace(sNameSpace);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getname(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pIMetaData->GetName();

			pIMetaData->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIMetaData->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pIMetaData->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setname(Lib3MF_MetaData pMetaData, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getkey(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetKey");
		}
		if ( (!pKeyBuffer) && !(pKeyNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKey("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pKeyBuffer == nullptr);
		if (isCacheCall) {
			sKey = pIMetaData->GetKey();

			pIMetaData->_setCache (new ParameterCache_1<std::string> (sKey));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIMetaData->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sKey);
			pIMetaData->_setCache (nullptr);
		}
		
		if (pKeyNeededChars)
			*pKeyNeededChars = (Lib3MF_uint32) (sKey.size()+1);
		if (pKeyBuffer) {
			if (sKey.size() >= nKeyBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKey = 0; iKey < sKey.size(); iKey++)
				pKeyBuffer[iKey] = sKey[iKey];
			pKeyBuffer[sKey.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Key", sKey.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getmustpreserve(Lib3MF_MetaData pMetaData, bool * pMustPreserve)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetMustPreserve");
		}
		if (pMustPreserve == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMustPreserve = pIMetaData->GetMustPreserve();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("MustPreserve", *pMustPreserve);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setmustpreserve(Lib3MF_MetaData pMetaData, bool bMustPreserve)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetMustPreserve");
			pJournalEntry->addBooleanParameter("MustPreserve", bMustPreserve);
		}
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetMustPreserve(bMustPreserve);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_gettype(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetType");
		}
		if ( (!pTypeBuffer) && !(pTypeNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sType("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pTypeBuffer == nullptr);
		if (isCacheCall) {
			sType = pIMetaData->GetType();

			pIMetaData->_setCache (new ParameterCache_1<std::string> (sType));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIMetaData->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sType);
			pIMetaData->_setCache (nullptr);
		}
		
		if (pTypeNeededChars)
			*pTypeNeededChars = (Lib3MF_uint32) (sType.size()+1);
		if (pTypeBuffer) {
			if (sType.size() >= nTypeBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iType = 0; iType < sType.size(); iType++)
				pTypeBuffer[iType] = sType[iType];
			pTypeBuffer[sType.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Type", sType.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_settype(Lib3MF_MetaData pMetaData, const char * pType)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetType");
			pJournalEntry->addStringParameter("Type", pType);
		}
		if (pType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sType(pType);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetType(sType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getvalue(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetValue");
		}
		if ( (!pValueBuffer) && !(pValueNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sValue("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pValueBuffer == nullptr);
		if (isCacheCall) {
			sValue = pIMetaData->GetValue();

			pIMetaData->_setCache (new ParameterCache_1<std::string> (sValue));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIMetaData->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sValue);
			pIMetaData->_setCache (nullptr);
		}
		
		if (pValueNeededChars)
			*pValueNeededChars = (Lib3MF_uint32) (sValue.size()+1);
		if (pValueBuffer) {
			if (sValue.size() >= nValueBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iValue = 0; iValue < sValue.size(); iValue++)
				pValueBuffer[iValue] = sValue[iValue];
			pValueBuffer[sValue.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Value", sValue.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setvalue(Lib3MF_MetaData pMetaData, const char * pValue)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetValue");
			pJournalEntry->addStringParameter("Value", pValue);
		}
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sValue(pValue);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetValue(sValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MetaDataGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_metadatagroup_getmetadatacount(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaDataCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMetaDataGroup->GetMetaDataCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_getmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaData");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->GetMetaData(nIndex);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_getmetadatabykey(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaDataByKey");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		std::string sName(pName);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->GetMetaDataByKey(sNameSpace, sName);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_removemetadatabyindex(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "RemoveMetaDataByIndex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaDataGroup->RemoveMetaDataByIndex(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_removemetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "RemoveMetaData");
			pJournalEntry->addHandleParameter("TheMetaData", pTheMetaData);
		}
		IBase* pIBaseClassTheMetaData = (IBase *)pTheMetaData;
		IMetaData* pITheMetaData = dynamic_cast<IMetaData*>(pIBaseClassTheMetaData);
		if (!pITheMetaData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaDataGroup->RemoveMetaData(pITheMetaData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_addmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "AddMetaData");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
			pJournalEntry->addStringParameter("Name", pName);
			pJournalEntry->addStringParameter("Value", pValue);
			pJournalEntry->addStringParameter("Type", pType);
			pJournalEntry->addBooleanParameter("MustPreserve", bMustPreserve);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		std::string sName(pName);
		std::string sValue(pValue);
		std::string sType(pType);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->AddMetaData(sNameSpace, sName, sValue, sType, bMustPreserve);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for TriangleSet
**************************************************************************************************************************/
Lib3MFResult lib3mf_triangleset_setname(Lib3MF_TriangleSet pTriangleSet, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_getname(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pITriangleSet->GetName();

			pITriangleSet->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pITriangleSet->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pITriangleSet->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_setidentifier(Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_getidentifier(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pIdentifierBuffer == nullptr);
		if (isCacheCall) {
			sIdentifier = pITriangleSet->GetIdentifier();

			pITriangleSet->_setCache (new ParameterCache_1<std::string> (sIdentifier));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pITriangleSet->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sIdentifier);
			pITriangleSet->_setCache (nullptr);
		}
		
		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_addtriangle(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "AddTriangle");
			pJournalEntry->addUInt32Parameter("TriangleIndex", nTriangleIndex);
		}
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->AddTriangle(nTriangleIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_removetriangle(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "RemoveTriangle");
			pJournalEntry->addUInt32Parameter("TriangleIndex", nTriangleIndex);
		}
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->RemoveTriangle(nTriangleIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_clear(Lib3MF_TriangleSet pTriangleSet)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "Clear");
		}
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->Clear();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_settrianglelist(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "SetTriangleList");
		}
		if ( (!pTriangleIndicesBuffer) && (nTriangleIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->SetTriangleList(nTriangleIndicesBufferSize, pTriangleIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_gettrianglelist(Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint64 nTriangleIndicesBufferSize, Lib3MF_uint64* pTriangleIndicesNeededCount, Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "GetTriangleList");
		}
		if ((!pTriangleIndicesBuffer) && !(pTriangleIndicesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->GetTriangleList(nTriangleIndicesBufferSize, pTriangleIndicesNeededCount, pTriangleIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_addtrianglelist(Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "AddTriangleList");
		}
		if ( (!pTriangleIndicesBuffer) && (nTriangleIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->AddTriangleList(nTriangleIndicesBufferSize, pTriangleIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_merge(Lib3MF_TriangleSet pTriangleSet, Lib3MF_TriangleSet pOtherTriangleSet, bool bDeleteOther)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "Merge");
			pJournalEntry->addHandleParameter("OtherTriangleSet", pOtherTriangleSet);
			pJournalEntry->addBooleanParameter("DeleteOther", bDeleteOther);
		}
		IBase* pIBaseClassOtherTriangleSet = (IBase *)pOtherTriangleSet;
		ITriangleSet* pIOtherTriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClassOtherTriangleSet);
		if (!pIOtherTriangleSet)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->Merge(pIOtherTriangleSet, bDeleteOther);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_deleteset(Lib3MF_TriangleSet pTriangleSet)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "DeleteSet");
		}
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITriangleSet->DeleteSet();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_triangleset_duplicate(Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier, Lib3MF_TriangleSet * pNewSet)
{
	IBase* pIBaseClass = (IBase *)pTriangleSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTriangleSet, "TriangleSet", "Duplicate");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNewSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseNewSet(nullptr);
		ITriangleSet* pITriangleSet = dynamic_cast<ITriangleSet*>(pIBaseClass);
		if (!pITriangleSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNewSet = pITriangleSet->Duplicate(sIdentifier);

		*pNewSet = (IBase*)(pBaseNewSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("NewSet", *pNewSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Object
**************************************************************************************************************************/
Lib3MFResult lib3mf_object_gettype(Lib3MF_Object pObject, eLib3MFObjectType * pObjectType)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetType");
		}
		if (pObjectType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pObjectType = pIObject->GetType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ObjectType", "ObjectType", (Lib3MF_int32)(*pObjectType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_settype(Lib3MF_Object pObject, eLib3MFObjectType eObjectType)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetType");
			pJournalEntry->addEnumParameter("ObjectType", "ObjectType", (Lib3MF_int32)(eObjectType));
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetType(eObjectType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getname(Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pIObject->GetName();

			pIObject->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIObject->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pIObject->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setname(Lib3MF_Object pObject, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getpartnumber(Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetPartNumber");
		}
		if ( (!pPartNumberBuffer) && !(pPartNumberNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPartNumberBuffer == nullptr);
		if (isCacheCall) {
			sPartNumber = pIObject->GetPartNumber();

			pIObject->_setCache (new ParameterCache_1<std::string> (sPartNumber));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIObject->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPartNumber);
			pIObject->_setCache (nullptr);
		}
		
		if (pPartNumberNeededChars)
			*pPartNumberNeededChars = (Lib3MF_uint32) (sPartNumber.size()+1);
		if (pPartNumberBuffer) {
			if (sPartNumber.size() >= nPartNumberBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPartNumber = 0; iPartNumber < sPartNumber.size(); iPartNumber++)
				pPartNumberBuffer[iPartNumber] = sPartNumber[iPartNumber];
			pPartNumberBuffer[sPartNumber.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("PartNumber", sPartNumber.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setpartnumber(Lib3MF_Object pObject, const char * pPartNumber)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetPartNumber");
			pJournalEntry->addStringParameter("PartNumber", pPartNumber);
		}
		if (pPartNumber == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber(pPartNumber);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetPartNumber(sPartNumber);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_ismeshobject(Lib3MF_Object pObject, bool * pIsMeshObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsMeshObject");
		}
		if (pIsMeshObject == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsMeshObject = pIObject->IsMeshObject();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsMeshObject", *pIsMeshObject);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_iscomponentsobject(Lib3MF_Object pObject, bool * pIsComponentsObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsComponentsObject");
		}
		if (pIsComponentsObject == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsComponentsObject = pIObject->IsComponentsObject();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsComponentsObject", *pIsComponentsObject);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_islevelsetobject(Lib3MF_Object pObject, bool * pIsLevelSetObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsLevelSetObject");
		}
		if (pIsLevelSetObject == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsLevelSetObject = pIObject->IsLevelSetObject();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsLevelSetObject", *pIsLevelSetObject);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_isvalid(Lib3MF_Object pObject, bool * pIsValid)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsValid");
		}
		if (pIsValid == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsValid = pIObject->IsValid();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsValid", *pIsValid);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setattachmentasthumbnail(Lib3MF_Object pObject, Lib3MF_Attachment pAttachment)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetAttachmentAsThumbnail");
			pJournalEntry->addHandleParameter("Attachment", pAttachment);
		}
		IBase* pIBaseClassAttachment = (IBase *)pAttachment;
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClassAttachment);
		if (!pIAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetAttachmentAsThumbnail(pIAttachment);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getthumbnailattachment(Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIObject->GetThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_clearthumbnailattachment(Lib3MF_Object pObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "ClearThumbnailAttachment");
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->ClearThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getoutbox(Lib3MF_Object pObject, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIObject->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getuuid(Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIObject->GetUUID(*pHasUUID);

			pIObject->_setCache (new ParameterCache_2<bool, std::string> (*pHasUUID, sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<bool, std::string>*> (pIObject->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pHasUUID, sUUID);
			pIObject->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setuuid(Lib3MF_Object pObject, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getmetadatagroup(Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetMetaDataGroup");
		}
		if (pMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaDataGroup(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaDataGroup = pIObject->GetMetaDataGroup();

		*pMetaDataGroup = (IBase*)(pBaseMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaDataGroup", *pMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetSlicesMeshResolution");
			pJournalEntry->addEnumParameter("MeshResolution", "SlicesMeshResolution", (Lib3MF_int32)(eMeshResolution));
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetSlicesMeshResolution(eMeshResolution);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetSlicesMeshResolution");
		}
		if (pMeshResolution == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMeshResolution = pIObject->GetSlicesMeshResolution();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("MeshResolution", "SlicesMeshResolution", (Lib3MF_int32)(*pMeshResolution));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_hasslices(Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "HasSlices");
			pJournalEntry->addBooleanParameter("Recursive", bRecursive);
		}
		if (pHasSlices == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasSlices = pIObject->HasSlices(bRecursive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasSlices", *pHasSlices);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_clearslicestack(Lib3MF_Object pObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "ClearSliceStack");
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->ClearSliceStack();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetSliceStack");
		}
		if (pSliceStackInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStackInstance(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStackInstance = pIObject->GetSliceStack();

		*pSliceStackInstance = (IBase*)(pBaseSliceStackInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStackInstance", *pSliceStackInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_assignslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "AssignSliceStack");
			pJournalEntry->addHandleParameter("SliceStackInstance", pSliceStackInstance);
		}
		IBase* pIBaseClassSliceStackInstance = (IBase *)pSliceStackInstance;
		ISliceStack* pISliceStackInstance = dynamic_cast<ISliceStack*>(pIBaseClassSliceStackInstance);
		if (!pISliceStackInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->AssignSliceStack(pISliceStackInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MeshObject
**************************************************************************************************************************/
Lib3MFResult lib3mf_meshobject_getvertexcount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertexCount");
		}
		if (pVertexCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pVertexCount = pIMeshObject->GetVertexCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("VertexCount", *pVertexCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettrianglecount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleCount");
		}
		if (pVertexCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pVertexCount = pIMeshObject->GetTriangleCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("VertexCount", *pVertexCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pCoordinates == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCoordinates = pIMeshObject->GetVertex(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetVertex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetVertex(nIndex, *pCoordinates);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_addvertex(Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "AddVertex");
		}
		if (pNewIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pNewIndex = pIMeshObject->AddVertex(*pCoordinates);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("NewIndex", *pNewIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getvertices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertices");
		}
		if ((!pVerticesBuffer) && !(pVerticesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetVertices(nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangle");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pIndices == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndices = pIMeshObject->GetTriangle(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_settriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetTriangle");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetTriangle(nIndex, *pIndices);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_addtriangle(Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "AddTriangle");
		}
		if (pNewIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pNewIndex = pIMeshObject->AddTriangle(*pIndices);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("NewIndex", *pNewIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangleindices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleIndices");
		}
		if ((!pIndicesBuffer) && !(pIndicesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetTriangleIndices(nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetObjectLevelProperty");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetObjectLevelProperty(nUniqueResourceID, nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetObjectLevelProperty");
		}
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pPropertyID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pHasObjectLevelProperty == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasObjectLevelProperty = pIMeshObject->GetObjectLevelProperty(*pUniqueResourceID, *pPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->addBooleanResult("HasObjectLevelProperty", *pHasObjectLevelProperty);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_settriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetTriangleProperties");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetTriangleProperties(nIndex, *pProperties);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleProperties");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pProperty)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetTriangleProperties(nIndex, *pProperty);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setalltriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetAllTriangleProperties");
		}
		if ( (!pPropertiesArrayBuffer) && (nPropertiesArrayBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetAllTriangleProperties(nPropertiesArrayBufferSize, pPropertiesArrayBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getalltriangleproperties(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetAllTriangleProperties");
		}
		if ((!pPropertiesArrayBuffer) && !(pPropertiesArrayNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetAllTriangleProperties(nPropertiesArrayBufferSize, pPropertiesArrayNeededCount, pPropertiesArrayBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_clearallproperties(Lib3MF_MeshObject pMeshObject)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "ClearAllProperties");
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->ClearAllProperties();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setgeometry(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetGeometry");
		}
		if ( (!pVerticesBuffer) && (nVerticesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetGeometry(nVerticesBufferSize, pVerticesBuffer, nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_ismanifoldandoriented(Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "IsManifoldAndOriented");
		}
		if (pIsManifoldAndOriented == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsManifoldAndOriented = pIMeshObject->IsManifoldAndOriented();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsManifoldAndOriented", *pIsManifoldAndOriented);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_beamlattice(Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "BeamLattice");
		}
		if (pTheBeamLattice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheBeamLattice(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheBeamLattice = pIMeshObject->BeamLattice();

		*pTheBeamLattice = (IBase*)(pBaseTheBeamLattice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheBeamLattice", *pTheBeamLattice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getvolumedata(Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData * pTheVolumeData)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVolumeData");
		}
		if (pTheVolumeData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheVolumeData(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheVolumeData = pIMeshObject->GetVolumeData();

		*pTheVolumeData = (IBase*)(pBaseTheVolumeData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheVolumeData", *pTheVolumeData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setvolumedata(Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData pTheVolumeData)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetVolumeData");
			pJournalEntry->addHandleParameter("TheVolumeData", pTheVolumeData);
		}
		IBase* pIBaseClassTheVolumeData = (IBase *)pTheVolumeData;
		IVolumeData* pITheVolumeData = dynamic_cast<IVolumeData*>(pIBaseClassTheVolumeData);
		if (!pITheVolumeData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetVolumeData(pITheVolumeData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_addtriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, const char * pName, Lib3MF_TriangleSet * pTheTriangleSet)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "AddTriangleSet");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTheTriangleSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sName(pName);
		IBase* pBaseTheTriangleSet(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheTriangleSet = pIMeshObject->AddTriangleSet(sIdentifier, sName);

		*pTheTriangleSet = (IBase*)(pBaseTheTriangleSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheTriangleSet", *pTheTriangleSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_hastriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, bool * pTriangleSetExists)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "HasTriangleSet");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTriangleSetExists == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTriangleSetExists = pIMeshObject->HasTriangleSet(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("TriangleSetExists", *pTriangleSetExists);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_findtriangleset(Lib3MF_MeshObject pMeshObject, const char * pIdentifier, Lib3MF_TriangleSet * pTheTriangleSet)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "FindTriangleSet");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTheTriangleSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseTheTriangleSet(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheTriangleSet = pIMeshObject->FindTriangleSet(sIdentifier);

		*pTheTriangleSet = (IBase*)(pBaseTheTriangleSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheTriangleSet", *pTheTriangleSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettrianglesetcount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleSetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMeshObject->GetTriangleSetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangleset(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, Lib3MF_TriangleSet * pTheTriangleSet)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleSet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pTheTriangleSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheTriangleSet(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheTriangleSet = pIMeshObject->GetTriangleSet(nIndex);

		*pTheTriangleSet = (IBase*)(pBaseTheTriangleSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheTriangleSet", *pTheTriangleSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for LevelSet
**************************************************************************************************************************/
Lib3MFResult lib3mf_levelset_getfunction(Lib3MF_LevelSet pLevelSet, Lib3MF_Function * pTheFunction)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetFunction");
		}
		if (pTheFunction == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheFunction(nullptr);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheFunction = pILevelSet->GetFunction();

		*pTheFunction = (IBase*)(pBaseTheFunction);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheFunction", *pTheFunction);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setfunction(Lib3MF_LevelSet pLevelSet, Lib3MF_Function pTheFunction)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetFunction");
			pJournalEntry->addHandleParameter("TheFunction", pTheFunction);
		}
		IBase* pIBaseClassTheFunction = (IBase *)pTheFunction;
		IFunction* pITheFunction = dynamic_cast<IFunction*>(pIBaseClassTheFunction);
		if (!pITheFunction)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetFunction(pITheFunction);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_gettransform(Lib3MF_LevelSet pLevelSet, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pILevelSet->GetTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_settransform(Lib3MF_LevelSet pLevelSet, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetTransform");
		}
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getchannelname(Lib3MF_LevelSet pLevelSet, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetChannelName");
		}
		if ( (!pChannelNameBuffer) && !(pChannelNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sChannelName("");
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pChannelNameBuffer == nullptr);
		if (isCacheCall) {
			sChannelName = pILevelSet->GetChannelName();

			pILevelSet->_setCache (new ParameterCache_1<std::string> (sChannelName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pILevelSet->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sChannelName);
			pILevelSet->_setCache (nullptr);
		}
		
		if (pChannelNameNeededChars)
			*pChannelNameNeededChars = (Lib3MF_uint32) (sChannelName.size()+1);
		if (pChannelNameBuffer) {
			if (sChannelName.size() >= nChannelNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iChannelName = 0; iChannelName < sChannelName.size(); iChannelName++)
				pChannelNameBuffer[iChannelName] = sChannelName[iChannelName];
			pChannelNameBuffer[sChannelName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ChannelName", sChannelName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setchannelname(Lib3MF_LevelSet pLevelSet, const char * pChannelName)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetChannelName");
			pJournalEntry->addStringParameter("ChannelName", pChannelName);
		}
		if (pChannelName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sChannelName(pChannelName);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetChannelName(sChannelName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setminfeaturesize(Lib3MF_LevelSet pLevelSet, Lib3MF_double dMinFeatureSize)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetMinFeatureSize");
			pJournalEntry->addDoubleParameter("MinFeatureSize", dMinFeatureSize);
		}
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetMinFeatureSize(dMinFeatureSize);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getminfeaturesize(Lib3MF_LevelSet pLevelSet, Lib3MF_double * pMinFeatureSize)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetMinFeatureSize");
		}
		if (pMinFeatureSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMinFeatureSize = pILevelSet->GetMinFeatureSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("MinFeatureSize", *pMinFeatureSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setfallbackvalue(Lib3MF_LevelSet pLevelSet, Lib3MF_double dFallBackValue)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetFallBackValue");
			pJournalEntry->addDoubleParameter("FallBackValue", dFallBackValue);
		}
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetFallBackValue(dFallBackValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getfallbackvalue(Lib3MF_LevelSet pLevelSet, Lib3MF_double * pFallBackValue)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetFallBackValue");
		}
		if (pFallBackValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pFallBackValue = pILevelSet->GetFallBackValue();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("FallBackValue", *pFallBackValue);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setmeshbboxonly(Lib3MF_LevelSet pLevelSet, bool bMeshBBoxOnly)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetMeshBBoxOnly");
			pJournalEntry->addBooleanParameter("MeshBBoxOnly", bMeshBBoxOnly);
		}
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetMeshBBoxOnly(bMeshBBoxOnly);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getmeshbboxonly(Lib3MF_LevelSet pLevelSet, bool * pMeshBBoxOnly)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetMeshBBoxOnly");
		}
		if (pMeshBBoxOnly == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMeshBBoxOnly = pILevelSet->GetMeshBBoxOnly();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("MeshBBoxOnly", *pMeshBBoxOnly);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setmesh(Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject pTheMesh)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetMesh");
			pJournalEntry->addHandleParameter("TheMesh", pTheMesh);
		}
		IBase* pIBaseClassTheMesh = (IBase *)pTheMesh;
		IMeshObject* pITheMesh = dynamic_cast<IMeshObject*>(pIBaseClassTheMesh);
		if (!pITheMesh)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetMesh(pITheMesh);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getmesh(Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject * pTheMesh)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetMesh");
		}
		if (pTheMesh == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheMesh(nullptr);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheMesh = pILevelSet->GetMesh();

		*pTheMesh = (IBase*)(pBaseTheMesh);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheMesh", *pTheMesh);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_getvolumedata(Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData * pTheVolumeData)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "GetVolumeData");
		}
		if (pTheVolumeData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheVolumeData(nullptr);
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheVolumeData = pILevelSet->GetVolumeData();

		*pTheVolumeData = (IBase*)(pBaseTheVolumeData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheVolumeData", *pTheVolumeData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_levelset_setvolumedata(Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData pTheVolumeData)
{
	IBase* pIBaseClass = (IBase *)pLevelSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pLevelSet, "LevelSet", "SetVolumeData");
			pJournalEntry->addHandleParameter("TheVolumeData", pTheVolumeData);
		}
		IBase* pIBaseClassTheVolumeData = (IBase *)pTheVolumeData;
		IVolumeData* pITheVolumeData = dynamic_cast<IVolumeData*>(pIBaseClassTheVolumeData);
		if (!pITheVolumeData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ILevelSet* pILevelSet = dynamic_cast<ILevelSet*>(pIBaseClass);
		if (!pILevelSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pILevelSet->SetVolumeData(pITheVolumeData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BeamLattice
**************************************************************************************************************************/
Lib3MFResult lib3mf_beamlattice_getminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetMinLength");
		}
		if (pMinLength == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMinLength = pIBeamLattice->GetMinLength();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("MinLength", *pMinLength);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetMinLength");
			pJournalEntry->addDoubleParameter("MinLength", dMinLength);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetMinLength(dMinLength);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetClipping");
		}
		if (!pClipMode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetClipping(*pClipMode, *pUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ClipMode", "BeamLatticeClipMode", (Lib3MF_int32)(*pClipMode));
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetClipping");
			pJournalEntry->addEnumParameter("ClipMode", "BeamLatticeClipMode", (Lib3MF_int32)(eClipMode));
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetClipping(eClipMode, nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getrepresentation(Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetRepresentation");
		}
		if (pHasRepresentation == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasRepresentation = pIBeamLattice->GetRepresentation(*pUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasRepresentation", *pHasRepresentation);
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setrepresentation(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetRepresentation");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetRepresentation(nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBallOptions");
		}
		if (!pBallMode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBallRadius)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBallOptions(*pBallMode, *pBallRadius);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("BallMode", "BeamLatticeBallMode", (Lib3MF_int32)(*pBallMode));
			pJournalEntry->addDoubleResult("BallRadius", *pBallRadius);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBallOptions");
			pJournalEntry->addEnumParameter("BallMode", "BeamLatticeBallMode", (Lib3MF_int32)(eBallMode));
			pJournalEntry->addDoubleParameter("BallRadius", dBallRadius);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBallOptions(eBallMode, dBallRadius);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBeamCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeam");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBeamInfo == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pBeamInfo = pIBeamLattice->GetBeam(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addbeam(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBeam");
		}
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pIBeamLattice->AddBeam(*pBeamInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBeam");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBeam(nIndex, *pBeamInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setbeams(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBeams");
		}
		if ( (!pBeamInfoBuffer) && (nBeamInfoBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBeams(nBeamInfoBufferSize, pBeamInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeams(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeams");
		}
		if ((!pBeamInfoBuffer) && !(pBeamInfoNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBeams(nBeamInfoBufferSize, pBeamInfoNeededCount, pBeamInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBallCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBallCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBall");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBallInfo == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pBallInfo = pIBeamLattice->GetBall(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addball(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBall");
		}
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pIBeamLattice->AddBall(*pBallInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBall");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBall(nIndex, *pBallInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setballs(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBalls");
		}
		if ( (!pBallInfoBuffer) && (nBallInfoBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBalls(nBallInfoBufferSize, pBallInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballs(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBalls");
		}
		if ((!pBallInfoBuffer) && !(pBallInfoNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBalls(nBallInfoBufferSize, pBallInfoNeededCount, pBallInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamsetcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamSetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBeamSetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBeamSet");
		}
		if (pBeamSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBeamSet(nullptr);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBeamSet = pIBeamLattice->AddBeamSet();

		*pBeamSet = (IBase*)(pBaseBeamSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BeamSet", *pBeamSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamSet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBeamSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBeamSet(nullptr);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBeamSet = pIBeamLattice->GetBeamSet(nIndex);

		*pBeamSet = (IBase*)(pBaseBeamSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BeamSet", *pBeamSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for FunctionReference
**************************************************************************************************************************/
Lib3MFResult lib3mf_functionreference_getfunctionresourceid(Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "GetFunctionResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIFunctionReference->GetFunctionResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_setfunctionresourceid(Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 nUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "SetFunctionResourceID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionReference->SetFunctionResourceID(nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_gettransform(Lib3MF_FunctionReference pFunctionReference, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "GetTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pIFunctionReference->GetTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_settransform(Lib3MF_FunctionReference pFunctionReference, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "SetTransform");
		}
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionReference->SetTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_getchannelname(Lib3MF_FunctionReference pFunctionReference, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "GetChannelName");
		}
		if ( (!pChannelNameBuffer) && !(pChannelNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sChannelName("");
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pChannelNameBuffer == nullptr);
		if (isCacheCall) {
			sChannelName = pIFunctionReference->GetChannelName();

			pIFunctionReference->_setCache (new ParameterCache_1<std::string> (sChannelName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIFunctionReference->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sChannelName);
			pIFunctionReference->_setCache (nullptr);
		}
		
		if (pChannelNameNeededChars)
			*pChannelNameNeededChars = (Lib3MF_uint32) (sChannelName.size()+1);
		if (pChannelNameBuffer) {
			if (sChannelName.size() >= nChannelNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iChannelName = 0; iChannelName < sChannelName.size(); iChannelName++)
				pChannelNameBuffer[iChannelName] = sChannelName[iChannelName];
			pChannelNameBuffer[sChannelName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ChannelName", sChannelName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_setchannelname(Lib3MF_FunctionReference pFunctionReference, const char * pChannelName)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "SetChannelName");
			pJournalEntry->addStringParameter("ChannelName", pChannelName);
		}
		if (pChannelName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sChannelName(pChannelName);
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionReference->SetChannelName(sChannelName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_setminfeaturesize(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dMinFeatureSize)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "SetMinFeatureSize");
			pJournalEntry->addDoubleParameter("MinFeatureSize", dMinFeatureSize);
		}
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionReference->SetMinFeatureSize(dMinFeatureSize);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_getminfeaturesize(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pMinFeatureSize)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "GetMinFeatureSize");
		}
		if (pMinFeatureSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMinFeatureSize = pIFunctionReference->GetMinFeatureSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("MinFeatureSize", *pMinFeatureSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_setfallbackvalue(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dFallBackValue)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "SetFallBackValue");
			pJournalEntry->addDoubleParameter("FallBackValue", dFallBackValue);
		}
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionReference->SetFallBackValue(dFallBackValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionreference_getfallbackvalue(Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pFallBackValue)
{
	IBase* pIBaseClass = (IBase *)pFunctionReference;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionReference, "FunctionReference", "GetFallBackValue");
		}
		if (pFallBackValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionReference* pIFunctionReference = dynamic_cast<IFunctionReference*>(pIBaseClass);
		if (!pIFunctionReference)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pFallBackValue = pIFunctionReference->GetFallBackValue();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("FallBackValue", *pFallBackValue);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for VolumeDataColor
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for MaterialMapping
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for VolumeDataComposite
**************************************************************************************************************************/
Lib3MFResult lib3mf_volumedatacomposite_getbasematerialgroup(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "GetBaseMaterialGroup");
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pIVolumeDataComposite->GetBaseMaterialGroup();

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedatacomposite_setbasematerialgroup(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "SetBaseMaterialGroup");
			pJournalEntry->addHandleParameter("BaseMaterialGroupInstance", pBaseMaterialGroupInstance);
		}
		IBase* pIBaseClassBaseMaterialGroupInstance = (IBase *)pBaseMaterialGroupInstance;
		IBaseMaterialGroup* pIBaseMaterialGroupInstance = dynamic_cast<IBaseMaterialGroup*>(pIBaseClassBaseMaterialGroupInstance);
		if (!pIBaseMaterialGroupInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeDataComposite->SetBaseMaterialGroup(pIBaseMaterialGroupInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedatacomposite_getmaterialmappingcount(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "GetMaterialMappingCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIVolumeDataComposite->GetMaterialMappingCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedatacomposite_getmaterialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex, Lib3MF_MaterialMapping * pTheMaterialMapping)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "GetMaterialMapping");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pTheMaterialMapping == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheMaterialMapping(nullptr);
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheMaterialMapping = pIVolumeDataComposite->GetMaterialMapping(nIndex);

		*pTheMaterialMapping = (IBase*)(pBaseTheMaterialMapping);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheMaterialMapping", *pTheMaterialMapping);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedatacomposite_addmaterialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, const sLib3MFTransform * pTransform, Lib3MF_MaterialMapping * pTheMaterialMapping)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "AddMaterialMapping");
		}
		if (pTheMaterialMapping == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheMaterialMapping(nullptr);
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheMaterialMapping = pIVolumeDataComposite->AddMaterialMapping(*pTransform);

		*pTheMaterialMapping = (IBase*)(pBaseTheMaterialMapping);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheMaterialMapping", *pTheMaterialMapping);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedatacomposite_removematerialmapping(Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataComposite;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataComposite, "VolumeDataComposite", "RemoveMaterialMapping");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IVolumeDataComposite* pIVolumeDataComposite = dynamic_cast<IVolumeDataComposite*>(pIBaseClass);
		if (!pIVolumeDataComposite)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeDataComposite->RemoveMaterialMapping(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for VolumeDataProperty
**************************************************************************************************************************/
Lib3MFResult lib3mf_volumedataproperty_getname(Lib3MF_VolumeDataProperty pVolumeDataProperty, const Lib3MF_uint32 nPropertyNameBufferSize, Lib3MF_uint32* pPropertyNameNeededChars, char * pPropertyNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataProperty;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataProperty, "VolumeDataProperty", "GetName");
		}
		if ( (!pPropertyNameBuffer) && !(pPropertyNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPropertyName("");
		IVolumeDataProperty* pIVolumeDataProperty = dynamic_cast<IVolumeDataProperty*>(pIBaseClass);
		if (!pIVolumeDataProperty)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPropertyNameBuffer == nullptr);
		if (isCacheCall) {
			sPropertyName = pIVolumeDataProperty->GetName();

			pIVolumeDataProperty->_setCache (new ParameterCache_1<std::string> (sPropertyName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIVolumeDataProperty->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPropertyName);
			pIVolumeDataProperty->_setCache (nullptr);
		}
		
		if (pPropertyNameNeededChars)
			*pPropertyNameNeededChars = (Lib3MF_uint32) (sPropertyName.size()+1);
		if (pPropertyNameBuffer) {
			if (sPropertyName.size() >= nPropertyNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPropertyName = 0; iPropertyName < sPropertyName.size(); iPropertyName++)
				pPropertyNameBuffer[iPropertyName] = sPropertyName[iPropertyName];
			pPropertyNameBuffer[sPropertyName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("PropertyName", sPropertyName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedataproperty_setisrequired(Lib3MF_VolumeDataProperty pVolumeDataProperty, bool bIsRequired)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataProperty;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataProperty, "VolumeDataProperty", "SetIsRequired");
			pJournalEntry->addBooleanParameter("IsRequired", bIsRequired);
		}
		IVolumeDataProperty* pIVolumeDataProperty = dynamic_cast<IVolumeDataProperty*>(pIBaseClass);
		if (!pIVolumeDataProperty)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeDataProperty->SetIsRequired(bIsRequired);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedataproperty_isrequired(Lib3MF_VolumeDataProperty pVolumeDataProperty, bool * pIsRequired)
{
	IBase* pIBaseClass = (IBase *)pVolumeDataProperty;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeDataProperty, "VolumeDataProperty", "IsRequired");
		}
		if (pIsRequired == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IVolumeDataProperty* pIVolumeDataProperty = dynamic_cast<IVolumeDataProperty*>(pIBaseClass);
		if (!pIVolumeDataProperty)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsRequired = pIVolumeDataProperty->IsRequired();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsRequired", *pIsRequired);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for VolumeData
**************************************************************************************************************************/
Lib3MFResult lib3mf_volumedata_getcomposite(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "GetComposite");
		}
		if (pTheCompositeData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheCompositeData(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheCompositeData = pIVolumeData->GetComposite();

		*pTheCompositeData = (IBase*)(pBaseTheCompositeData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheCompositeData", *pTheCompositeData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_createnewcomposite(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "CreateNewComposite");
		}
		if (pTheCompositeData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheCompositeData(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheCompositeData = pIVolumeData->CreateNewComposite();

		*pTheCompositeData = (IBase*)(pBaseTheCompositeData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheCompositeData", *pTheCompositeData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_removecomposite(Lib3MF_VolumeData pVolumeData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "RemoveComposite");
		}
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeData->RemoveComposite();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_getcolor(Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataColor * pTheColorData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "GetColor");
		}
		if (pTheColorData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheColorData(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheColorData = pIVolumeData->GetColor();

		*pTheColorData = (IBase*)(pBaseTheColorData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheColorData", *pTheColorData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_createnewcolor(Lib3MF_VolumeData pVolumeData, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataColor * pTheColorData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "CreateNewColor");
			pJournalEntry->addHandleParameter("TheFunction", pTheFunction);
		}
		if (pTheColorData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassTheFunction = (IBase *)pTheFunction;
		IFunction* pITheFunction = dynamic_cast<IFunction*>(pIBaseClassTheFunction);
		if (!pITheFunction)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheColorData(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheColorData = pIVolumeData->CreateNewColor(pITheFunction);

		*pTheColorData = (IBase*)(pBaseTheColorData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheColorData", *pTheColorData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_removecolor(Lib3MF_VolumeData pVolumeData)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "RemoveColor");
		}
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeData->RemoveColor();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_getpropertycount(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "GetPropertyCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIVolumeData->GetPropertyCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_getproperty(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "GetProperty");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pTheVolumeDataProperty == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheVolumeDataProperty(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheVolumeDataProperty = pIVolumeData->GetProperty(nIndex);

		*pTheVolumeDataProperty = (IBase*)(pBaseTheVolumeDataProperty);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheVolumeDataProperty", *pTheVolumeDataProperty);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_addpropertyfromfunction(Lib3MF_VolumeData pVolumeData, const char * pName, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "AddPropertyFromFunction");
			pJournalEntry->addStringParameter("Name", pName);
			pJournalEntry->addHandleParameter("TheFunction", pTheFunction);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTheVolumeDataProperty == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBase* pIBaseClassTheFunction = (IBase *)pTheFunction;
		IFunction* pITheFunction = dynamic_cast<IFunction*>(pIBaseClassTheFunction);
		if (!pITheFunction)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheVolumeDataProperty(nullptr);
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheVolumeDataProperty = pIVolumeData->AddPropertyFromFunction(sName, pITheFunction);

		*pTheVolumeDataProperty = (IBase*)(pBaseTheVolumeDataProperty);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheVolumeDataProperty", *pTheVolumeDataProperty);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_volumedata_removeproperty(Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex)
{
	IBase* pIBaseClass = (IBase *)pVolumeData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pVolumeData, "VolumeData", "RemoveProperty");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IVolumeData* pIVolumeData = dynamic_cast<IVolumeData*>(pIBaseClass);
		if (!pIVolumeData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIVolumeData->RemoveProperty(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Component
**************************************************************************************************************************/
Lib3MFResult lib3mf_component_getobjectresource(Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetObjectResource");
		}
		if (pObjectResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseObjectResource(nullptr);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseObjectResource = pIComponent->GetObjectResource();

		*pObjectResource = (IBase*)(pBaseObjectResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ObjectResource", *pObjectResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_getobjectresourceid(Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetObjectResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIComponent->GetObjectResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_getuuid(Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIComponent->GetUUID(*pHasUUID);

			pIComponent->_setCache (new ParameterCache_2<bool, std::string> (*pHasUUID, sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<bool, std::string>*> (pIComponent->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pHasUUID, sUUID);
			pIComponent->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_setuuid(Lib3MF_Component pComponent, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIComponent->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_hastransform(Lib3MF_Component pComponent, bool * pHasTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "HasTransform");
		}
		if (pHasTransform == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasTransform = pIComponent->HasTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasTransform", *pHasTransform);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_gettransform(Lib3MF_Component pComponent, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pIComponent->GetTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_settransform(Lib3MF_Component pComponent, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "SetTransform");
		}
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIComponent->SetTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComponentsObject
**************************************************************************************************************************/
Lib3MFResult lib3mf_componentsobject_addcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "AddComponent");
			pJournalEntry->addHandleParameter("ObjectResource", pObjectResource);
		}
		if (pComponentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassObjectResource = (IBase *)pObjectResource;
		IObject* pIObjectResource = dynamic_cast<IObject*>(pIBaseClassObjectResource);
		if (!pIObjectResource)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseComponentInstance(nullptr);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentInstance = pIComponentsObject->AddComponent(pIObjectResource, *pTransform);

		*pComponentInstance = (IBase*)(pBaseComponentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentInstance", *pComponentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_componentsobject_getcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "GetComponent");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pComponentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentInstance(nullptr);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentInstance = pIComponentsObject->GetComponent(nIndex);

		*pComponentInstance = (IBase*)(pBaseComponentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentInstance", *pComponentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_componentsobject_getcomponentcount(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "GetComponentCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIComponentsObject->GetComponentCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BeamSet
**************************************************************************************************************************/
Lib3MFResult lib3mf_beamset_setname(Lib3MF_BeamSet pBeamSet, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getname(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pIBeamSet->GetName();

			pIBeamSet->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIBeamSet->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pIBeamSet->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setidentifier(Lib3MF_BeamSet pBeamSet, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getidentifier(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pIdentifierBuffer == nullptr);
		if (isCacheCall) {
			sIdentifier = pIBeamSet->GetIdentifier();

			pIBeamSet->_setCache (new ParameterCache_1<std::string> (sIdentifier));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIBeamSet->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sIdentifier);
			pIBeamSet->_setCache (nullptr);
		}
		
		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetReferenceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamSet->GetReferenceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetReferences");
		}
		if ( (!pReferencesBuffer) && (nReferencesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetReferences(nReferencesBufferSize, pReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetReferences");
		}
		if ((!pReferencesBuffer) && !(pReferencesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->GetReferences(nReferencesBufferSize, pReferencesNeededCount, pReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getballreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetBallReferenceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamSet->GetBallReferenceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setballreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetBallReferences");
		}
		if ( (!pBallReferencesBuffer) && (nBallReferencesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetBallReferences(nBallReferencesBufferSize, pBallReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getballreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetBallReferences");
		}
		if ((!pBallReferencesBuffer) && !(pBallReferencesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->GetBallReferences(nBallReferencesBufferSize, pBallReferencesNeededCount, pBallReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BaseMaterialGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_basematerialgroup_getcount(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBaseMaterialGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getallpropertyids(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_addmaterial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "AddMaterial");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIBaseMaterialGroup->AddMaterial(sName, *pDisplayColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_removematerial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "RemoveMaterial");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->RemoveMaterial(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetName");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pIBaseMaterialGroup->GetName(nPropertyID);

			pIBaseMaterialGroup->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIBaseMaterialGroup->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pIBaseMaterialGroup->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_setname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "SetName");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->SetName(nPropertyID, sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_setdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "SetDisplayColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->SetDisplayColor(nPropertyID, *pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetDisplayColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheColor = pIBaseMaterialGroup->GetDisplayColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ColorGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_colorgroup_getcount(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIColorGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_getallpropertyids(Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_addcolor(Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "AddColor");
		}
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIColorGroup->AddColor(*pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_removecolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "RemoveColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->RemoveColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_setcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "SetColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->SetColor(nPropertyID, *pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_getcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheColor = pIColorGroup->GetColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2dgroup_getcount(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pITexture2DGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_getallpropertyids(Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2DGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_addtex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "AddTex2Coord");
		}
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pITexture2DGroup->AddTex2Coord(*pUVCoordinate);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_gettex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetTex2Coord");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pUVCoordinate == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUVCoordinate = pITexture2DGroup->GetTex2Coord(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_removetex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "RemoveTex2Coord");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2DGroup->RemoveTex2Coord(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_gettexture2d(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetTexture2D");
		}
		if (pTexture2DInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTexture2DInstance(nullptr);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DInstance = pITexture2DGroup->GetTexture2D();

		*pTexture2DInstance = (IBase*)(pBaseTexture2DInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DInstance", *pTexture2DInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for CompositeMaterials
**************************************************************************************************************************/
Lib3MFResult lib3mf_compositematerials_getcount(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pICompositeMaterials->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getallpropertyids(Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getbasematerialgroup(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetBaseMaterialGroup");
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pICompositeMaterials->GetBaseMaterialGroup();

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_addcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "AddComposite");
		}
		if ( (!pCompositeBuffer) && (nCompositeBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pICompositeMaterials->AddComposite(nCompositeBufferSize, pCompositeBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_removecomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "RemoveComposite");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->RemoveComposite(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetComposite");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ((!pCompositeBuffer) && !(pCompositeNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->GetComposite(nPropertyID, nCompositeBufferSize, pCompositeNeededCount, pCompositeBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MultiPropertyGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_multipropertygroup_getcount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMultiPropertyGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getallpropertyids(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_addmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "AddMultiProperty");
		}
		if ( (!pPropertyIDsBuffer) && (nPropertyIDsBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIMultiPropertyGroup->AddMultiProperty(nPropertyIDsBufferSize, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_setmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "SetMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ( (!pPropertyIDsBuffer) && (nPropertyIDsBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->SetMultiProperty(nPropertyID, nPropertyIDsBufferSize, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->GetMultiProperty(nPropertyID, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_removemultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "RemoveMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->RemoveMultiProperty(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getlayercount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetLayerCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMultiPropertyGroup->GetLayerCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_addlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "AddLayer");
		}
		if (pLayerIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pLayerIndex = pIMultiPropertyGroup->AddLayer(*pTheLayer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("LayerIndex", *pLayerIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetLayer");
			pJournalEntry->addUInt32Parameter("LayerIndex", nLayerIndex);
		}
		if (pTheLayer == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheLayer = pIMultiPropertyGroup->GetLayer(nLayerIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_removelayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "RemoveLayer");
			pJournalEntry->addUInt32Parameter("LayerIndex", nLayerIndex);
		}
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->RemoveLayer(nLayerIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Image3D
**************************************************************************************************************************/
Lib3MFResult lib3mf_image3d_getname(Lib3MF_Image3D pImage3D, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImage3D, "Image3D", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IImage3D* pIImage3D = dynamic_cast<IImage3D*>(pIBaseClass);
		if (!pIImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pNameBuffer == nullptr);
		if (isCacheCall) {
			sName = pIImage3D->GetName();

			pIImage3D->_setCache (new ParameterCache_1<std::string> (sName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImage3D->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sName);
			pIImage3D->_setCache (nullptr);
		}
		
		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_image3d_setname(Lib3MF_Image3D pImage3D, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImage3D, "Image3D", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IImage3D* pIImage3D = dynamic_cast<IImage3D*>(pIBaseClass);
		if (!pIImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImage3D->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_image3d_isimagestack(Lib3MF_Image3D pImage3D, bool * pIsImageStack)
{
	IBase* pIBaseClass = (IBase *)pImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImage3D, "Image3D", "IsImageStack");
		}
		if (pIsImageStack == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImage3D* pIImage3D = dynamic_cast<IImage3D*>(pIBaseClass);
		if (!pIImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsImageStack = pIImage3D->IsImageStack();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsImageStack", *pIsImageStack);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ImageStack
**************************************************************************************************************************/
Lib3MFResult lib3mf_imagestack_getrowcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pRowCount)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "GetRowCount");
		}
		if (pRowCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pRowCount = pIImageStack->GetRowCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("RowCount", *pRowCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_setrowcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nRowCount)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "SetRowCount");
			pJournalEntry->addUInt32Parameter("RowCount", nRowCount);
		}
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImageStack->SetRowCount(nRowCount);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_getcolumncount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pColumnCount)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "GetColumnCount");
		}
		if (pColumnCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pColumnCount = pIImageStack->GetColumnCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ColumnCount", *pColumnCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_setcolumncount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nColumnCount)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "SetColumnCount");
			pJournalEntry->addUInt32Parameter("ColumnCount", nColumnCount);
		}
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImageStack->SetColumnCount(nColumnCount);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_getsheetcount(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pSheetCount)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "GetSheetCount");
		}
		if (pSheetCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pSheetCount = pIImageStack->GetSheetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("SheetCount", *pSheetCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_getsheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pSheet)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "GetSheet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pSheet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSheet(nullptr);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSheet = pIImageStack->GetSheet(nIndex);

		*pSheet = (IBase*)(pBaseSheet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Sheet", *pSheet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_setsheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment pSheet)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "SetSheet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
			pJournalEntry->addHandleParameter("Sheet", pSheet);
		}
		IBase* pIBaseClassSheet = (IBase *)pSheet;
		IAttachment* pISheet = dynamic_cast<IAttachment*>(pIBaseClassSheet);
		if (!pISheet)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImageStack->SetSheet(nIndex, pISheet);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_createemptysheet(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_Attachment * pSheet)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "CreateEmptySheet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pSheet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IBase* pBaseSheet(nullptr);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSheet = pIImageStack->CreateEmptySheet(nIndex, sPath);

		*pSheet = (IBase*)(pBaseSheet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Sheet", *pSheet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_createsheetfrombuffer(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_uint64 nDataBufferSize, const Lib3MF_uint8 * pDataBuffer, Lib3MF_Attachment * pSheet)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "CreateSheetFromBuffer");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pDataBuffer) && (nDataBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pSheet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IBase* pBaseSheet(nullptr);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSheet = pIImageStack->CreateSheetFromBuffer(nIndex, sPath, nDataBufferSize, pDataBuffer);

		*pSheet = (IBase*)(pBaseSheet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Sheet", *pSheet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_imagestack_createsheetfromfile(Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, const char * pFileName, Lib3MF_Attachment * pSheet)
{
	IBase* pIBaseClass = (IBase *)pImageStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImageStack, "ImageStack", "CreateSheetFromFile");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
			pJournalEntry->addStringParameter("Path", pPath);
			pJournalEntry->addStringParameter("FileName", pFileName);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pFileName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pSheet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		std::string sFileName(pFileName);
		IBase* pBaseSheet(nullptr);
		IImageStack* pIImageStack = dynamic_cast<IImageStack*>(pIBaseClass);
		if (!pIImageStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSheet = pIImageStack->CreateSheetFromFile(nIndex, sPath, sFileName);

		*pSheet = (IBase*)(pBaseSheet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Sheet", *pSheet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Attachment
**************************************************************************************************************************/
Lib3MFResult lib3mf_attachment_getpath(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPathBuffer == nullptr);
		if (isCacheCall) {
			sPath = pIAttachment->GetPath();

			pIAttachment->_setCache (new ParameterCache_1<std::string> (sPath));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIAttachment->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPath);
			pIAttachment->_setCache (nullptr);
		}
		
		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_setpath(Lib3MF_Attachment pAttachment, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "SetPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->SetPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_packagepart(Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "PackagePart");
		}
		if (pPackagePart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePackagePart(nullptr);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePackagePart = pIAttachment->PackagePart();

		*pPackagePart = (IBase*)(pBasePackagePart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("PackagePart", *pPackagePart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_getrelationshiptype(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetRelationShipType");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPathBuffer == nullptr);
		if (isCacheCall) {
			sPath = pIAttachment->GetRelationShipType();

			pIAttachment->_setCache (new ParameterCache_1<std::string> (sPath));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIAttachment->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPath);
			pIAttachment->_setCache (nullptr);
		}
		
		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_setrelationshiptype(Lib3MF_Attachment pAttachment, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "SetRelationShipType");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->SetRelationShipType(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_writetofile(Lib3MF_Attachment pAttachment, const char * pFileName)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "WriteToFile");
			pJournalEntry->addStringParameter("FileName", pFileName);
		}
		if (pFileName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFileName(pFileName);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->WriteToFile(sFileName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfromfile(Lib3MF_Attachment pAttachment, const char * pFileName)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromFile");
			pJournalEntry->addStringParameter("FileName", pFileName);
		}
		if (pFileName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFileName(pFileName);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromFile(sFileName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfromcallback(Lib3MF_Attachment pAttachment, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromCallback");
			pJournalEntry->addUInt64Parameter("StreamSize", nStreamSize);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromCallback(pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_getstreamsize(Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetStreamSize");
		}
		if (pStreamSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStreamSize = pIAttachment->GetStreamSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("StreamSize", *pStreamSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_writetobuffer(Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "WriteToBuffer");
		}
		if ((!pBufferBuffer) && !(pBufferNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->WriteToBuffer(nBufferBufferSize, pBufferNeededCount, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfrombuffer(Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromBuffer");
		}
		if ( (!pBufferBuffer) && (nBufferBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromBuffer(nBufferBufferSize, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2D
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2d_getattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pITexture2D->GetAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetAttachment");
			pJournalEntry->addHandleParameter("Attachment", pAttachment);
		}
		IBase* pIBaseClassAttachment = (IBase *)pAttachment;
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClassAttachment);
		if (!pIAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetAttachment(pIAttachment);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_getcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetContentType");
		}
		if (pContentType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pContentType = pITexture2D->GetContentType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ContentType", "TextureType", (Lib3MF_int32)(*pContentType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetContentType");
			pJournalEntry->addEnumParameter("ContentType", "TextureType", (Lib3MF_int32)(eContentType));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetContentType(eContentType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_gettilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetTileStyleUV");
		}
		if (!pTileStyleU)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pTileStyleV)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->GetTileStyleUV(*pTileStyleU, *pTileStyleV);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleU));
			pJournalEntry->addEnumResult("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleV));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_settilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetTileStyleUV");
			pJournalEntry->addEnumParameter("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(eTileStyleU));
			pJournalEntry->addEnumParameter("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(eTileStyleV));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetTileStyleUV(eTileStyleU, eTileStyleV);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_getfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetFilter");
		}
		if (pFilter == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pFilter = pITexture2D->GetFilter();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Filter", "TextureFilter", (Lib3MF_int32)(*pFilter));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetFilter");
			pJournalEntry->addEnumParameter("Filter", "TextureFilter", (Lib3MF_int32)(eFilter));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetFilter(eFilter);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ImplicitPort
**************************************************************************************************************************/
Lib3MFResult lib3mf_implicitport_getidentifier(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pIdentifierBuffer == nullptr);
		if (isCacheCall) {
			sIdentifier = pIImplicitPort->GetIdentifier();

			pIImplicitPort->_setCache (new ParameterCache_1<std::string> (sIdentifier));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitPort->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sIdentifier);
			pIImplicitPort->_setCache (nullptr);
		}
		
		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_setidentifier(Lib3MF_ImplicitPort pImplicitPort, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitPort->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_getdisplayname(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "GetDisplayName");
		}
		if ( (!pDisplayNameBuffer) && !(pDisplayNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName("");
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pDisplayNameBuffer == nullptr);
		if (isCacheCall) {
			sDisplayName = pIImplicitPort->GetDisplayName();

			pIImplicitPort->_setCache (new ParameterCache_1<std::string> (sDisplayName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitPort->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sDisplayName);
			pIImplicitPort->_setCache (nullptr);
		}
		
		if (pDisplayNameNeededChars)
			*pDisplayNameNeededChars = (Lib3MF_uint32) (sDisplayName.size()+1);
		if (pDisplayNameBuffer) {
			if (sDisplayName.size() >= nDisplayNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iDisplayName = 0; iDisplayName < sDisplayName.size(); iDisplayName++)
				pDisplayNameBuffer[iDisplayName] = sDisplayName[iDisplayName];
			pDisplayNameBuffer[sDisplayName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("DisplayName", sDisplayName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_setdisplayname(Lib3MF_ImplicitPort pImplicitPort, const char * pDisplayName)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "SetDisplayName");
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
		}
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName(pDisplayName);
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitPort->SetDisplayName(sDisplayName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_settype(Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType eImplicitPortType)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "SetType");
			pJournalEntry->addEnumParameter("ImplicitPortType", "ImplicitPortType", (Lib3MF_int32)(eImplicitPortType));
		}
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitPort->SetType(eImplicitPortType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_gettype(Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType * pImplicitPortType)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "GetType");
		}
		if (pImplicitPortType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pImplicitPortType = pIImplicitPort->GetType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ImplicitPortType", "ImplicitPortType", (Lib3MF_int32)(*pImplicitPortType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_getreference(Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nReferenceBufferSize, Lib3MF_uint32* pReferenceNeededChars, char * pReferenceBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "GetReference");
		}
		if ( (!pReferenceBuffer) && !(pReferenceNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sReference("");
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pReferenceBuffer == nullptr);
		if (isCacheCall) {
			sReference = pIImplicitPort->GetReference();

			pIImplicitPort->_setCache (new ParameterCache_1<std::string> (sReference));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitPort->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sReference);
			pIImplicitPort->_setCache (nullptr);
		}
		
		if (pReferenceNeededChars)
			*pReferenceNeededChars = (Lib3MF_uint32) (sReference.size()+1);
		if (pReferenceBuffer) {
			if (sReference.size() >= nReferenceBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iReference = 0; iReference < sReference.size(); iReference++)
				pReferenceBuffer[iReference] = sReference[iReference];
			pReferenceBuffer[sReference.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Reference", sReference.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitport_setreference(Lib3MF_ImplicitPort pImplicitPort, const char * pReference)
{
	IBase* pIBaseClass = (IBase *)pImplicitPort;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPort, "ImplicitPort", "SetReference");
			pJournalEntry->addStringParameter("Reference", pReference);
		}
		if (pReference == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sReference(pReference);
		IImplicitPort* pIImplicitPort = dynamic_cast<IImplicitPort*>(pIBaseClass);
		if (!pIImplicitPort)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitPort->SetReference(sReference);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Iterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_iterator_movenext(Lib3MF_Iterator pIterator, bool * pHasNext)
{
	IBase* pIBaseClass = (IBase *)pIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pIterator, "Iterator", "MoveNext");
		}
		if (pHasNext == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IIterator* pIIterator = dynamic_cast<IIterator*>(pIBaseClass);
		if (!pIIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasNext = pIIterator->MoveNext();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasNext", *pHasNext);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_iterator_moveprevious(Lib3MF_Iterator pIterator, bool * pHasPrevious)
{
	IBase* pIBaseClass = (IBase *)pIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pIterator, "Iterator", "MovePrevious");
		}
		if (pHasPrevious == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IIterator* pIIterator = dynamic_cast<IIterator*>(pIBaseClass);
		if (!pIIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasPrevious = pIIterator->MovePrevious();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrevious", *pHasPrevious);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_iterator_count(Lib3MF_Iterator pIterator, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pIterator, "Iterator", "Count");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IIterator* pIIterator = dynamic_cast<IIterator*>(pIBaseClass);
		if (!pIIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIIterator->Count();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ImplicitPortIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_implicitportiterator_getcurrent(Lib3MF_ImplicitPortIterator pImplicitPortIterator, Lib3MF_ImplicitPort * pPort)
{
	IBase* pIBaseClass = (IBase *)pImplicitPortIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitPortIterator, "ImplicitPortIterator", "GetCurrent");
		}
		if (pPort == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePort(nullptr);
		IImplicitPortIterator* pIImplicitPortIterator = dynamic_cast<IImplicitPortIterator*>(pIBaseClass);
		if (!pIImplicitPortIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePort = pIImplicitPortIterator->GetCurrent();

		*pPort = (IBase*)(pBasePort);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Port", *pPort);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ImplicitNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_implicitnode_getidentifier(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pIdentifierBuffer == nullptr);
		if (isCacheCall) {
			sIdentifier = pIImplicitNode->GetIdentifier();

			pIImplicitNode->_setCache (new ParameterCache_1<std::string> (sIdentifier));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitNode->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sIdentifier);
			pIImplicitNode->_setCache (nullptr);
		}
		
		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_setidentifier(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitNode->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_getdisplayname(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetDisplayName");
		}
		if ( (!pDisplayNameBuffer) && !(pDisplayNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName("");
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pDisplayNameBuffer == nullptr);
		if (isCacheCall) {
			sDisplayName = pIImplicitNode->GetDisplayName();

			pIImplicitNode->_setCache (new ParameterCache_1<std::string> (sDisplayName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitNode->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sDisplayName);
			pIImplicitNode->_setCache (nullptr);
		}
		
		if (pDisplayNameNeededChars)
			*pDisplayNameNeededChars = (Lib3MF_uint32) (sDisplayName.size()+1);
		if (pDisplayNameBuffer) {
			if (sDisplayName.size() >= nDisplayNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iDisplayName = 0; iDisplayName < sDisplayName.size(); iDisplayName++)
				pDisplayNameBuffer[iDisplayName] = sDisplayName[iDisplayName];
			pDisplayNameBuffer[sDisplayName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("DisplayName", sDisplayName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_setdisplayname(Lib3MF_ImplicitNode pImplicitNode, const char * pDisplayName)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "SetDisplayName");
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
		}
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName(pDisplayName);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitNode->SetDisplayName(sDisplayName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_gettag(Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nTagBufferSize, Lib3MF_uint32* pTagNeededChars, char * pTagBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetTag");
		}
		if ( (!pTagBuffer) && !(pTagNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sTag("");
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pTagBuffer == nullptr);
		if (isCacheCall) {
			sTag = pIImplicitNode->GetTag();

			pIImplicitNode->_setCache (new ParameterCache_1<std::string> (sTag));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitNode->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sTag);
			pIImplicitNode->_setCache (nullptr);
		}
		
		if (pTagNeededChars)
			*pTagNeededChars = (Lib3MF_uint32) (sTag.size()+1);
		if (pTagBuffer) {
			if (sTag.size() >= nTagBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iTag = 0; iTag < sTag.size(); iTag++)
				pTagBuffer[iTag] = sTag[iTag];
			pTagBuffer[sTag.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Tag", sTag.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_settag(Lib3MF_ImplicitNode pImplicitNode, const char * pTag)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "SetTag");
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sTag(pTag);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitNode->SetTag(sTag);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_getnodetype(Lib3MF_ImplicitNode pImplicitNode, eLib3MFImplicitNodeType * pType)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetNodeType");
		}
		if (pType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pType = pIImplicitNode->GetNodeType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Type", "ImplicitNodeType", (Lib3MF_int32)(*pType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_addinput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "AddInput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPort == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		IBase* pBasePort(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePort = pIImplicitNode->AddInput(sIdentifier, sDisplayName);

		*pPort = (IBase*)(pBasePort);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Port", *pPort);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_getinputs(Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetInputs");
		}
		if (pIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseIterator(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseIterator = pIImplicitNode->GetInputs();

		*pIterator = (IBase*)(pBaseIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Iterator", *pIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_addoutput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "AddOutput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPort == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		IBase* pBasePort(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePort = pIImplicitNode->AddOutput(sIdentifier, sDisplayName);

		*pPort = (IBase*)(pBasePort);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Port", *pPort);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_getoutputs(Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "GetOutputs");
		}
		if (pIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseIterator(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseIterator = pIImplicitNode->GetOutputs();

		*pIterator = (IBase*)(pBaseIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Iterator", *pIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_findinput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pInput)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "FindInput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pInput == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseInput(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseInput = pIImplicitNode->FindInput(sIdentifier);

		*pInput = (IBase*)(pBaseInput);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Input", *pInput);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_findoutput(Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "FindOutput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pOutput == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseOutput(nullptr);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutput = pIImplicitNode->FindOutput(sIdentifier);

		*pOutput = (IBase*)(pBaseOutput);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Output", *pOutput);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitnode_aretypesvalid(Lib3MF_ImplicitNode pImplicitNode, bool * pValid)
{
	IBase* pIBaseClass = (IBase *)pImplicitNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitNode, "ImplicitNode", "AreTypesValid");
		}
		if (pValid == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IImplicitNode* pIImplicitNode = dynamic_cast<IImplicitNode*>(pIBaseClass);
		if (!pIImplicitNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pValid = pIImplicitNode->AreTypesValid();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("Valid", *pValid);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for OneInputNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_oneinputnode_getinputa(Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pInput)
{
	IBase* pIBaseClass = (IBase *)pOneInputNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pOneInputNode, "OneInputNode", "GetInputA");
		}
		if (pInput == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseInput(nullptr);
		IOneInputNode* pIOneInputNode = dynamic_cast<IOneInputNode*>(pIBaseClass);
		if (!pIOneInputNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseInput = pIOneInputNode->GetInputA();

		*pInput = (IBase*)(pBaseInput);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Input", *pInput);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_oneinputnode_getoutputresult(Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pResult)
{
	IBase* pIBaseClass = (IBase *)pOneInputNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pOneInputNode, "OneInputNode", "GetOutputResult");
		}
		if (pResult == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResult(nullptr);
		IOneInputNode* pIOneInputNode = dynamic_cast<IOneInputNode*>(pIBaseClass);
		if (!pIOneInputNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResult = pIOneInputNode->GetOutputResult();

		*pResult = (IBase*)(pBaseResult);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Result", *pResult);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for SinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for CosNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for TanNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ArcSinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ArcCosNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ArcTanNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for SinhNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for CoshNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for TanhNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for RoundNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for CeilNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for FloorNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for SignNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for FractNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for AbsNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ExpNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for LogNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Log2Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Log10Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for LengthNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for TransposeNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for InverseNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for SqrtNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ResourceIdNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourceidnode_setresource(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource pResource)
{
	IBase* pIBaseClass = (IBase *)pResourceIdNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIdNode, "ResourceIdNode", "SetResource");
			pJournalEntry->addHandleParameter("Resource", pResource);
		}
		IBase* pIBaseClassResource = (IBase *)pResource;
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClassResource);
		if (!pIResource)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IResourceIdNode* pIResourceIdNode = dynamic_cast<IResourceIdNode*>(pIBaseClass);
		if (!pIResourceIdNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResourceIdNode->SetResource(pIResource);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceidnode_getresource(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource * pResource)
{
	IBase* pIBaseClass = (IBase *)pResourceIdNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIdNode, "ResourceIdNode", "GetResource");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IResourceIdNode* pIResourceIdNode = dynamic_cast<IResourceIdNode*>(pIBaseClass);
		if (!pIResourceIdNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIResourceIdNode->GetResource();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceidnode_getoutputvalue(Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_ImplicitPort * pValue)
{
	IBase* pIBaseClass = (IBase *)pResourceIdNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIdNode, "ResourceIdNode", "GetOutputValue");
		}
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseValue(nullptr);
		IResourceIdNode* pIResourceIdNode = dynamic_cast<IResourceIdNode*>(pIBaseClass);
		if (!pIResourceIdNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseValue = pIResourceIdNode->GetOutputValue();

		*pValue = (IBase*)(pBaseValue);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Value", *pValue);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for TwoInputNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_twoinputnode_getinputb(Lib3MF_TwoInputNode pTwoInputNode, Lib3MF_ImplicitPort * pB)
{
	IBase* pIBaseClass = (IBase *)pTwoInputNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTwoInputNode, "TwoInputNode", "GetInputB");
		}
		if (pB == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseB(nullptr);
		ITwoInputNode* pITwoInputNode = dynamic_cast<ITwoInputNode*>(pIBaseClass);
		if (!pITwoInputNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseB = pITwoInputNode->GetInputB();

		*pB = (IBase*)(pBaseB);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("B", *pB);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for AdditionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for SubtractionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for MultiplicationNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for DivisionNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for DotNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for CrossNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ArcTan2Node
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for MatVecMultiplicationNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for MinNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for MaxNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for FmodNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for ModNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for PowNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for SelectNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_selectnode_getinputb(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pB)
{
	IBase* pIBaseClass = (IBase *)pSelectNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSelectNode, "SelectNode", "GetInputB");
		}
		if (pB == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseB(nullptr);
		ISelectNode* pISelectNode = dynamic_cast<ISelectNode*>(pIBaseClass);
		if (!pISelectNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseB = pISelectNode->GetInputB();

		*pB = (IBase*)(pBaseB);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("B", *pB);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_selectnode_getinputc(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pC)
{
	IBase* pIBaseClass = (IBase *)pSelectNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSelectNode, "SelectNode", "GetInputC");
		}
		if (pC == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseC(nullptr);
		ISelectNode* pISelectNode = dynamic_cast<ISelectNode*>(pIBaseClass);
		if (!pISelectNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseC = pISelectNode->GetInputC();

		*pC = (IBase*)(pBaseC);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("C", *pC);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_selectnode_getinputd(Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pD)
{
	IBase* pIBaseClass = (IBase *)pSelectNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSelectNode, "SelectNode", "GetInputD");
		}
		if (pD == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseD(nullptr);
		ISelectNode* pISelectNode = dynamic_cast<ISelectNode*>(pIBaseClass);
		if (!pISelectNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseD = pISelectNode->GetInputD();

		*pD = (IBase*)(pBaseD);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("D", *pD);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ClampNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_clampnode_getinputmin(Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMin)
{
	IBase* pIBaseClass = (IBase *)pClampNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pClampNode, "ClampNode", "GetInputMin");
		}
		if (pMin == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMin(nullptr);
		IClampNode* pIClampNode = dynamic_cast<IClampNode*>(pIBaseClass);
		if (!pIClampNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMin = pIClampNode->GetInputMin();

		*pMin = (IBase*)(pBaseMin);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Min", *pMin);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_clampnode_getinputmax(Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMax)
{
	IBase* pIBaseClass = (IBase *)pClampNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pClampNode, "ClampNode", "GetInputMax");
		}
		if (pMax == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMax(nullptr);
		IClampNode* pIClampNode = dynamic_cast<IClampNode*>(pIBaseClass);
		if (!pIClampNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMax = pIClampNode->GetInputMax();

		*pMax = (IBase*)(pBaseMax);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Max", *pMax);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComposeVectorNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_composevectornode_getinputx(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pX)
{
	IBase* pIBaseClass = (IBase *)pComposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeVectorNode, "ComposeVectorNode", "GetInputX");
		}
		if (pX == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseX(nullptr);
		IComposeVectorNode* pIComposeVectorNode = dynamic_cast<IComposeVectorNode*>(pIBaseClass);
		if (!pIComposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseX = pIComposeVectorNode->GetInputX();

		*pX = (IBase*)(pBaseX);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("X", *pX);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composevectornode_getinputy(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pY)
{
	IBase* pIBaseClass = (IBase *)pComposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeVectorNode, "ComposeVectorNode", "GetInputY");
		}
		if (pY == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseY(nullptr);
		IComposeVectorNode* pIComposeVectorNode = dynamic_cast<IComposeVectorNode*>(pIBaseClass);
		if (!pIComposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseY = pIComposeVectorNode->GetInputY();

		*pY = (IBase*)(pBaseY);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Y", *pY);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composevectornode_getinputz(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pZ)
{
	IBase* pIBaseClass = (IBase *)pComposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeVectorNode, "ComposeVectorNode", "GetInputZ");
		}
		if (pZ == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseZ(nullptr);
		IComposeVectorNode* pIComposeVectorNode = dynamic_cast<IComposeVectorNode*>(pIBaseClass);
		if (!pIComposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseZ = pIComposeVectorNode->GetInputZ();

		*pZ = (IBase*)(pBaseZ);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Z", *pZ);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composevectornode_getoutputresult(Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pResult)
{
	IBase* pIBaseClass = (IBase *)pComposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeVectorNode, "ComposeVectorNode", "GetOutputResult");
		}
		if (pResult == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResult(nullptr);
		IComposeVectorNode* pIComposeVectorNode = dynamic_cast<IComposeVectorNode*>(pIBaseClass);
		if (!pIComposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResult = pIComposeVectorNode->GetOutputResult();

		*pResult = (IBase*)(pBaseResult);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Result", *pResult);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for VectorFromScalarNode
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for DecomposeVectorNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_decomposevectornode_getinputa(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pA)
{
	IBase* pIBaseClass = (IBase *)pDecomposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pDecomposeVectorNode, "DecomposeVectorNode", "GetInputA");
		}
		if (pA == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseA(nullptr);
		IDecomposeVectorNode* pIDecomposeVectorNode = dynamic_cast<IDecomposeVectorNode*>(pIBaseClass);
		if (!pIDecomposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseA = pIDecomposeVectorNode->GetInputA();

		*pA = (IBase*)(pBaseA);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("A", *pA);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_decomposevectornode_getoutputx(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pX)
{
	IBase* pIBaseClass = (IBase *)pDecomposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pDecomposeVectorNode, "DecomposeVectorNode", "GetOutputX");
		}
		if (pX == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseX(nullptr);
		IDecomposeVectorNode* pIDecomposeVectorNode = dynamic_cast<IDecomposeVectorNode*>(pIBaseClass);
		if (!pIDecomposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseX = pIDecomposeVectorNode->GetOutputX();

		*pX = (IBase*)(pBaseX);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("X", *pX);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_decomposevectornode_getoutputy(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pY)
{
	IBase* pIBaseClass = (IBase *)pDecomposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pDecomposeVectorNode, "DecomposeVectorNode", "GetOutputY");
		}
		if (pY == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseY(nullptr);
		IDecomposeVectorNode* pIDecomposeVectorNode = dynamic_cast<IDecomposeVectorNode*>(pIBaseClass);
		if (!pIDecomposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseY = pIDecomposeVectorNode->GetOutputY();

		*pY = (IBase*)(pBaseY);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Y", *pY);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_decomposevectornode_getoutputz(Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pZ)
{
	IBase* pIBaseClass = (IBase *)pDecomposeVectorNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pDecomposeVectorNode, "DecomposeVectorNode", "GetOutputZ");
		}
		if (pZ == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseZ(nullptr);
		IDecomposeVectorNode* pIDecomposeVectorNode = dynamic_cast<IDecomposeVectorNode*>(pIBaseClass);
		if (!pIDecomposeVectorNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseZ = pIDecomposeVectorNode->GetOutputZ();

		*pZ = (IBase*)(pBaseZ);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Z", *pZ);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComposeMatrixNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_composematrixnode_getinputm00(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM00)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM00");
		}
		if (pM00 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM00(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM00 = pIComposeMatrixNode->GetInputM00();

		*pM00 = (IBase*)(pBaseM00);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M00", *pM00);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm01(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM01)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM01");
		}
		if (pM01 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM01(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM01 = pIComposeMatrixNode->GetInputM01();

		*pM01 = (IBase*)(pBaseM01);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M01", *pM01);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm02(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM02)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM02");
		}
		if (pM02 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM02(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM02 = pIComposeMatrixNode->GetInputM02();

		*pM02 = (IBase*)(pBaseM02);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M02", *pM02);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm03(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM03)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM03");
		}
		if (pM03 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM03(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM03 = pIComposeMatrixNode->GetInputM03();

		*pM03 = (IBase*)(pBaseM03);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M03", *pM03);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm10(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM10)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM10");
		}
		if (pM10 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM10(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM10 = pIComposeMatrixNode->GetInputM10();

		*pM10 = (IBase*)(pBaseM10);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M10", *pM10);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm11(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM11)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM11");
		}
		if (pM11 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM11(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM11 = pIComposeMatrixNode->GetInputM11();

		*pM11 = (IBase*)(pBaseM11);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M11", *pM11);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm12(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM12)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM12");
		}
		if (pM12 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM12(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM12 = pIComposeMatrixNode->GetInputM12();

		*pM12 = (IBase*)(pBaseM12);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M12", *pM12);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm13(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM13)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM13");
		}
		if (pM13 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM13(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM13 = pIComposeMatrixNode->GetInputM13();

		*pM13 = (IBase*)(pBaseM13);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M13", *pM13);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm20(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM20)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM20");
		}
		if (pM20 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM20(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM20 = pIComposeMatrixNode->GetInputM20();

		*pM20 = (IBase*)(pBaseM20);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M20", *pM20);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm21(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM21)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM21");
		}
		if (pM21 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM21(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM21 = pIComposeMatrixNode->GetInputM21();

		*pM21 = (IBase*)(pBaseM21);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M21", *pM21);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm22(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM22)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM22");
		}
		if (pM22 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM22(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM22 = pIComposeMatrixNode->GetInputM22();

		*pM22 = (IBase*)(pBaseM22);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M22", *pM22);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm23(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM23)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM23");
		}
		if (pM23 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM23(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM23 = pIComposeMatrixNode->GetInputM23();

		*pM23 = (IBase*)(pBaseM23);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M23", *pM23);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm30(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM30)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM30");
		}
		if (pM30 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM30(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM30 = pIComposeMatrixNode->GetInputM30();

		*pM30 = (IBase*)(pBaseM30);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M30", *pM30);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm31(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM31)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM31");
		}
		if (pM31 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM31(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM31 = pIComposeMatrixNode->GetInputM31();

		*pM31 = (IBase*)(pBaseM31);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M31", *pM31);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm32(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM32)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM32");
		}
		if (pM32 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM32(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM32 = pIComposeMatrixNode->GetInputM32();

		*pM32 = (IBase*)(pBaseM32);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M32", *pM32);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getinputm33(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM33)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetInputM33");
		}
		if (pM33 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseM33(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseM33 = pIComposeMatrixNode->GetInputM33();

		*pM33 = (IBase*)(pBaseM33);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("M33", *pM33);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_composematrixnode_getoutputresult(Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pResult)
{
	IBase* pIBaseClass = (IBase *)pComposeMatrixNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComposeMatrixNode, "ComposeMatrixNode", "GetOutputResult");
		}
		if (pResult == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResult(nullptr);
		IComposeMatrixNode* pIComposeMatrixNode = dynamic_cast<IComposeMatrixNode*>(pIBaseClass);
		if (!pIComposeMatrixNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResult = pIComposeMatrixNode->GetOutputResult();

		*pResult = (IBase*)(pBaseResult);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Result", *pResult);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MatrixFromRowsNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_matrixfromrowsnode_getinputa(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow0)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromRowsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromRowsNode, "MatrixFromRowsNode", "GetInputA");
		}
		if (pRow0 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRow0(nullptr);
		IMatrixFromRowsNode* pIMatrixFromRowsNode = dynamic_cast<IMatrixFromRowsNode*>(pIBaseClass);
		if (!pIMatrixFromRowsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRow0 = pIMatrixFromRowsNode->GetInputA();

		*pRow0 = (IBase*)(pBaseRow0);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Row0", *pRow0);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromrowsnode_getinputb(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow1)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromRowsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromRowsNode, "MatrixFromRowsNode", "GetInputB");
		}
		if (pRow1 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRow1(nullptr);
		IMatrixFromRowsNode* pIMatrixFromRowsNode = dynamic_cast<IMatrixFromRowsNode*>(pIBaseClass);
		if (!pIMatrixFromRowsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRow1 = pIMatrixFromRowsNode->GetInputB();

		*pRow1 = (IBase*)(pBaseRow1);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Row1", *pRow1);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromrowsnode_getinputc(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow2)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromRowsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromRowsNode, "MatrixFromRowsNode", "GetInputC");
		}
		if (pRow2 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRow2(nullptr);
		IMatrixFromRowsNode* pIMatrixFromRowsNode = dynamic_cast<IMatrixFromRowsNode*>(pIBaseClass);
		if (!pIMatrixFromRowsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRow2 = pIMatrixFromRowsNode->GetInputC();

		*pRow2 = (IBase*)(pBaseRow2);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Row2", *pRow2);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromrowsnode_getinputd(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow3)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromRowsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromRowsNode, "MatrixFromRowsNode", "GetInputD");
		}
		if (pRow3 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRow3(nullptr);
		IMatrixFromRowsNode* pIMatrixFromRowsNode = dynamic_cast<IMatrixFromRowsNode*>(pIBaseClass);
		if (!pIMatrixFromRowsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRow3 = pIMatrixFromRowsNode->GetInputD();

		*pRow3 = (IBase*)(pBaseRow3);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Row3", *pRow3);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromrowsnode_getoutputresult(Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pResult)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromRowsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromRowsNode, "MatrixFromRowsNode", "GetOutputResult");
		}
		if (pResult == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResult(nullptr);
		IMatrixFromRowsNode* pIMatrixFromRowsNode = dynamic_cast<IMatrixFromRowsNode*>(pIBaseClass);
		if (!pIMatrixFromRowsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResult = pIMatrixFromRowsNode->GetOutputResult();

		*pResult = (IBase*)(pBaseResult);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Result", *pResult);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MatrixFromColumnsNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputa(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn0)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromColumnsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromColumnsNode, "MatrixFromColumnsNode", "GetInputA");
		}
		if (pColumn0 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColumn0(nullptr);
		IMatrixFromColumnsNode* pIMatrixFromColumnsNode = dynamic_cast<IMatrixFromColumnsNode*>(pIBaseClass);
		if (!pIMatrixFromColumnsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColumn0 = pIMatrixFromColumnsNode->GetInputA();

		*pColumn0 = (IBase*)(pBaseColumn0);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Column0", *pColumn0);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputb(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn1)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromColumnsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromColumnsNode, "MatrixFromColumnsNode", "GetInputB");
		}
		if (pColumn1 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColumn1(nullptr);
		IMatrixFromColumnsNode* pIMatrixFromColumnsNode = dynamic_cast<IMatrixFromColumnsNode*>(pIBaseClass);
		if (!pIMatrixFromColumnsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColumn1 = pIMatrixFromColumnsNode->GetInputB();

		*pColumn1 = (IBase*)(pBaseColumn1);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Column1", *pColumn1);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputc(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn2)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromColumnsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromColumnsNode, "MatrixFromColumnsNode", "GetInputC");
		}
		if (pColumn2 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColumn2(nullptr);
		IMatrixFromColumnsNode* pIMatrixFromColumnsNode = dynamic_cast<IMatrixFromColumnsNode*>(pIBaseClass);
		if (!pIMatrixFromColumnsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColumn2 = pIMatrixFromColumnsNode->GetInputC();

		*pColumn2 = (IBase*)(pBaseColumn2);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Column2", *pColumn2);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromcolumnsnode_getinputd(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn3)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromColumnsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromColumnsNode, "MatrixFromColumnsNode", "GetInputD");
		}
		if (pColumn3 == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColumn3(nullptr);
		IMatrixFromColumnsNode* pIMatrixFromColumnsNode = dynamic_cast<IMatrixFromColumnsNode*>(pIBaseClass);
		if (!pIMatrixFromColumnsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColumn3 = pIMatrixFromColumnsNode->GetInputD();

		*pColumn3 = (IBase*)(pBaseColumn3);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Column3", *pColumn3);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_matrixfromcolumnsnode_getoutputresult(Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pResult)
{
	IBase* pIBaseClass = (IBase *)pMatrixFromColumnsNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMatrixFromColumnsNode, "MatrixFromColumnsNode", "GetOutputResult");
		}
		if (pResult == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResult(nullptr);
		IMatrixFromColumnsNode* pIMatrixFromColumnsNode = dynamic_cast<IMatrixFromColumnsNode*>(pIBaseClass);
		if (!pIMatrixFromColumnsNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResult = pIMatrixFromColumnsNode->GetOutputResult();

		*pResult = (IBase*)(pBaseResult);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Result", *pResult);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ConstantNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_constantnode_setconstant(Lib3MF_ConstantNode pConstantNode, Lib3MF_double dValue)
{
	IBase* pIBaseClass = (IBase *)pConstantNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstantNode, "ConstantNode", "SetConstant");
			pJournalEntry->addDoubleParameter("Value", dValue);
		}
		IConstantNode* pIConstantNode = dynamic_cast<IConstantNode*>(pIBaseClass);
		if (!pIConstantNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIConstantNode->SetConstant(dValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constantnode_getconstant(Lib3MF_ConstantNode pConstantNode, Lib3MF_double * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstantNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstantNode, "ConstantNode", "GetConstant");
		}
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IConstantNode* pIConstantNode = dynamic_cast<IConstantNode*>(pIBaseClass);
		if (!pIConstantNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pValue = pIConstantNode->GetConstant();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("Value", *pValue);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constantnode_getoutputvalue(Lib3MF_ConstantNode pConstantNode, Lib3MF_ImplicitPort * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstantNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstantNode, "ConstantNode", "GetOutputValue");
		}
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseValue(nullptr);
		IConstantNode* pIConstantNode = dynamic_cast<IConstantNode*>(pIBaseClass);
		if (!pIConstantNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseValue = pIConstantNode->GetOutputValue();

		*pValue = (IBase*)(pBaseValue);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Value", *pValue);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ConstVecNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_constvecnode_setvector(Lib3MF_ConstVecNode pConstVecNode, const sLib3MFVector * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstVecNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstVecNode, "ConstVecNode", "SetVector");
		}
		IConstVecNode* pIConstVecNode = dynamic_cast<IConstVecNode*>(pIBaseClass);
		if (!pIConstVecNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIConstVecNode->SetVector(*pValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constvecnode_getvector(Lib3MF_ConstVecNode pConstVecNode, sLib3MFVector * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstVecNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstVecNode, "ConstVecNode", "GetVector");
		}
		if (pValue == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IConstVecNode* pIConstVecNode = dynamic_cast<IConstVecNode*>(pIBaseClass);
		if (!pIConstVecNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pValue = pIConstVecNode->GetVector();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constvecnode_getoutputvector(Lib3MF_ConstVecNode pConstVecNode, Lib3MF_ImplicitPort * pVector)
{
	IBase* pIBaseClass = (IBase *)pConstVecNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstVecNode, "ConstVecNode", "GetOutputVector");
		}
		if (pVector == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseVector(nullptr);
		IConstVecNode* pIConstVecNode = dynamic_cast<IConstVecNode*>(pIBaseClass);
		if (!pIConstVecNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseVector = pIConstVecNode->GetOutputVector();

		*pVector = (IBase*)(pBaseVector);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Vector", *pVector);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ConstMatNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_constmatnode_setmatrix(Lib3MF_ConstMatNode pConstMatNode, const sLib3MFMatrix4x4 * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstMatNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstMatNode, "ConstMatNode", "SetMatrix");
		}
		IConstMatNode* pIConstMatNode = dynamic_cast<IConstMatNode*>(pIBaseClass);
		if (!pIConstMatNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIConstMatNode->SetMatrix(*pValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constmatnode_getmatrix(Lib3MF_ConstMatNode pConstMatNode, sLib3MFMatrix4x4 * pValue)
{
	IBase* pIBaseClass = (IBase *)pConstMatNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstMatNode, "ConstMatNode", "GetMatrix");
		}
		if (pValue == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IConstMatNode* pIConstMatNode = dynamic_cast<IConstMatNode*>(pIBaseClass);
		if (!pIConstMatNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pValue = pIConstMatNode->GetMatrix();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_constmatnode_getoutputmatrix(Lib3MF_ConstMatNode pConstMatNode, Lib3MF_ImplicitPort * pMatrix)
{
	IBase* pIBaseClass = (IBase *)pConstMatNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConstMatNode, "ConstMatNode", "GetOutputMatrix");
		}
		if (pMatrix == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMatrix(nullptr);
		IConstMatNode* pIConstMatNode = dynamic_cast<IConstMatNode*>(pIBaseClass);
		if (!pIConstMatNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMatrix = pIConstMatNode->GetOutputMatrix();

		*pMatrix = (IBase*)(pBaseMatrix);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Matrix", *pMatrix);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MeshNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_meshnode_getinputmesh(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pMesh)
{
	IBase* pIBaseClass = (IBase *)pMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshNode, "MeshNode", "GetInputMesh");
		}
		if (pMesh == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMesh(nullptr);
		IMeshNode* pIMeshNode = dynamic_cast<IMeshNode*>(pIBaseClass);
		if (!pIMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMesh = pIMeshNode->GetInputMesh();

		*pMesh = (IBase*)(pBaseMesh);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Mesh", *pMesh);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshnode_getinputpos(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pPos)
{
	IBase* pIBaseClass = (IBase *)pMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshNode, "MeshNode", "GetInputPos");
		}
		if (pPos == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePos(nullptr);
		IMeshNode* pIMeshNode = dynamic_cast<IMeshNode*>(pIBaseClass);
		if (!pIMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePos = pIMeshNode->GetInputPos();

		*pPos = (IBase*)(pBasePos);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Pos", *pPos);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshnode_getoutputdistance(Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pDistance)
{
	IBase* pIBaseClass = (IBase *)pMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshNode, "MeshNode", "GetOutputDistance");
		}
		if (pDistance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseDistance(nullptr);
		IMeshNode* pIMeshNode = dynamic_cast<IMeshNode*>(pIBaseClass);
		if (!pIMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseDistance = pIMeshNode->GetOutputDistance();

		*pDistance = (IBase*)(pBaseDistance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Distance", *pDistance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for UnsignedMeshNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_unsignedmeshnode_getinputmesh(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pMesh)
{
	IBase* pIBaseClass = (IBase *)pUnsignedMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pUnsignedMeshNode, "UnsignedMeshNode", "GetInputMesh");
		}
		if (pMesh == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMesh(nullptr);
		IUnsignedMeshNode* pIUnsignedMeshNode = dynamic_cast<IUnsignedMeshNode*>(pIBaseClass);
		if (!pIUnsignedMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMesh = pIUnsignedMeshNode->GetInputMesh();

		*pMesh = (IBase*)(pBaseMesh);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Mesh", *pMesh);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_unsignedmeshnode_getinputpos(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pPos)
{
	IBase* pIBaseClass = (IBase *)pUnsignedMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pUnsignedMeshNode, "UnsignedMeshNode", "GetInputPos");
		}
		if (pPos == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePos(nullptr);
		IUnsignedMeshNode* pIUnsignedMeshNode = dynamic_cast<IUnsignedMeshNode*>(pIBaseClass);
		if (!pIUnsignedMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePos = pIUnsignedMeshNode->GetInputPos();

		*pPos = (IBase*)(pBasePos);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Pos", *pPos);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_unsignedmeshnode_getoutputdistance(Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pDistance)
{
	IBase* pIBaseClass = (IBase *)pUnsignedMeshNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pUnsignedMeshNode, "UnsignedMeshNode", "GetOutputDistance");
		}
		if (pDistance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseDistance(nullptr);
		IUnsignedMeshNode* pIUnsignedMeshNode = dynamic_cast<IUnsignedMeshNode*>(pIBaseClass);
		if (!pIUnsignedMeshNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseDistance = pIUnsignedMeshNode->GetOutputDistance();

		*pDistance = (IBase*)(pBaseDistance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Distance", *pDistance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for FunctionCallNode
**************************************************************************************************************************/
Lib3MFResult lib3mf_functioncallnode_getinputfunctionid(Lib3MF_FunctionCallNode pFunctionCallNode, Lib3MF_ImplicitPort * pFunction)
{
	IBase* pIBaseClass = (IBase *)pFunctionCallNode;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionCallNode, "FunctionCallNode", "GetInputFunctionID");
		}
		if (pFunction == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseFunction(nullptr);
		IFunctionCallNode* pIFunctionCallNode = dynamic_cast<IFunctionCallNode*>(pIBaseClass);
		if (!pIFunctionCallNode)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseFunction = pIFunctionCallNode->GetInputFunctionID();

		*pFunction = (IBase*)(pBaseFunction);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Function", *pFunction);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for NodeIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_nodeiterator_getcurrent(Lib3MF_NodeIterator pNodeIterator, Lib3MF_ImplicitNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pNodeIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pNodeIterator, "NodeIterator", "GetCurrent");
		}
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseNode(nullptr);
		INodeIterator* pINodeIterator = dynamic_cast<INodeIterator*>(pIBaseClass);
		if (!pINodeIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pINodeIterator->GetCurrent();

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Function
**************************************************************************************************************************/
Lib3MFResult lib3mf_function_getdisplayname(Lib3MF_Function pFunction, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "GetDisplayName");
		}
		if ( (!pDisplayNameBuffer) && !(pDisplayNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName("");
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pDisplayNameBuffer == nullptr);
		if (isCacheCall) {
			sDisplayName = pIFunction->GetDisplayName();

			pIFunction->_setCache (new ParameterCache_1<std::string> (sDisplayName));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIFunction->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sDisplayName);
			pIFunction->_setCache (nullptr);
		}
		
		if (pDisplayNameNeededChars)
			*pDisplayNameNeededChars = (Lib3MF_uint32) (sDisplayName.size()+1);
		if (pDisplayNameBuffer) {
			if (sDisplayName.size() >= nDisplayNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iDisplayName = 0; iDisplayName < sDisplayName.size(); iDisplayName++)
				pDisplayNameBuffer[iDisplayName] = sDisplayName[iDisplayName];
			pDisplayNameBuffer[sDisplayName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("DisplayName", sDisplayName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_setdisplayname(Lib3MF_Function pFunction, const char * pDisplayName)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "SetDisplayName");
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
		}
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sDisplayName(pDisplayName);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunction->SetDisplayName(sDisplayName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_addinput(Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "AddInput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addEnumParameter("Type", "ImplicitPortType", (Lib3MF_int32)(eType));
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPort == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		IBase* pBasePort(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePort = pIFunction->AddInput(sIdentifier, sDisplayName, eType);

		*pPort = (IBase*)(pBasePort);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Port", *pPort);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_getinputs(Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "GetInputs");
		}
		if (pIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseIterator(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseIterator = pIFunction->GetInputs();

		*pIterator = (IBase*)(pBaseIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Iterator", *pIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_removeinput(Lib3MF_Function pFunction, Lib3MF_ImplicitPort pInput)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "RemoveInput");
			pJournalEntry->addHandleParameter("Input", pInput);
		}
		IBase* pIBaseClassInput = (IBase *)pInput;
		IImplicitPort* pIInput = dynamic_cast<IImplicitPort*>(pIBaseClassInput);
		if (!pIInput)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunction->RemoveInput(pIInput);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_addoutput(Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "AddOutput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addEnumParameter("Type", "ImplicitPortType", (Lib3MF_int32)(eType));
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPort == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		IBase* pBasePort(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePort = pIFunction->AddOutput(sIdentifier, sDisplayName, eType);

		*pPort = (IBase*)(pBasePort);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Port", *pPort);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_getoutputs(Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "GetOutputs");
		}
		if (pIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseIterator(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseIterator = pIFunction->GetOutputs();

		*pIterator = (IBase*)(pBaseIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Iterator", *pIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_removeoutput(Lib3MF_Function pFunction, Lib3MF_ImplicitPort pOutput)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "RemoveOutput");
			pJournalEntry->addHandleParameter("Output", pOutput);
		}
		IBase* pIBaseClassOutput = (IBase *)pOutput;
		IImplicitPort* pIOutput = dynamic_cast<IImplicitPort*>(pIBaseClassOutput);
		if (!pIOutput)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunction->RemoveOutput(pIOutput);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_findinput(Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pInput)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "FindInput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pInput == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseInput(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseInput = pIFunction->FindInput(sIdentifier);

		*pInput = (IBase*)(pBaseInput);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Input", *pInput);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_function_findoutput(Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput)
{
	IBase* pIBaseClass = (IBase *)pFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunction, "Function", "FindOutput");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pOutput == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseOutput(nullptr);
		IFunction* pIFunction = dynamic_cast<IFunction*>(pIBaseClass);
		if (!pIFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutput = pIFunction->FindOutput(sIdentifier);

		*pOutput = (IBase*)(pBaseOutput);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Output", *pOutput);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ImplicitFunction
**************************************************************************************************************************/
Lib3MFResult lib3mf_implicitfunction_getidentifier(Lib3MF_ImplicitFunction pImplicitFunction, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pIdentifierBuffer == nullptr);
		if (isCacheCall) {
			sIdentifier = pIImplicitFunction->GetIdentifier();

			pIImplicitFunction->_setCache (new ParameterCache_1<std::string> (sIdentifier));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIImplicitFunction->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sIdentifier);
			pIImplicitFunction->_setCache (nullptr);
		}
		
		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_setidentifier(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addnode(Lib3MF_ImplicitFunction pImplicitFunction, eLib3MFImplicitNodeType eNodeType, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ImplicitNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddNode");
			pJournalEntry->addEnumParameter("NodeType", "ImplicitNodeType", (Lib3MF_int32)(eNodeType));
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddNode(eNodeType, sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addsinnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSinNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSinNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addcosnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CosNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddCosNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddCosNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addtannode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddTanNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddTanNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addarcsinnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcSinNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddArcSinNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddArcSinNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addarccosnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcCosNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddArcCosNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddArcCosNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addarctan2node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcTan2Node * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddArcTan2Node");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddArcTan2Node(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addsinhnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinhNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSinhNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSinhNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addcoshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CoshNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddCoshNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddCoshNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addtanhnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanhNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddTanhNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddTanhNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addroundnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_RoundNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddRoundNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddRoundNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addceilnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CeilNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddCeilNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddCeilNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addfloornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FloorNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddFloorNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddFloorNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addsignnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SignNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSignNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSignNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addfractnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FractNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddFractNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddFractNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addabsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AbsNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddAbsNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddAbsNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addexpnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ExpNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddExpNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddExpNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlognode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_LogNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLogNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddLogNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlog2node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log2Node * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLog2Node");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddLog2Node(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlog10node(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log10Node * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLog10Node");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddLog10Node(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlengthnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_LengthNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLengthNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddLengthNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addtransposenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TransposeNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddTransposeNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddTransposeNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addinversenode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_InverseNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddInverseNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddInverseNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addsqrtnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SqrtNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSqrtNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSqrtNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addresourceidnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ResourceIdNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddResourceIdNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddResourceIdNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addadditionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AdditionNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddAdditionNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddAdditionNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addsubtractionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SubtractionNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSubtractionNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSubtractionNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmultiplicationnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MultiplicationNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMultiplicationNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMultiplicationNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_adddivisionnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_DivisionNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddDivisionNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddDivisionNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_adddotnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DotNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddDotNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddDotNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addcrossnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_CrossNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddCrossNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddCrossNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmatvecmultiplicationnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatVecMultiplicationNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMatVecMultiplicationNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMatVecMultiplicationNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addminnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MinNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMinNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMinNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmaxnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MaxNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMaxNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMaxNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addfmodnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FmodNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddFmodNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddFmodNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addpownode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_PowNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddPowNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddPowNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addselectnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SelectNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddSelectNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddSelectNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addclampnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ClampNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddClampNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addEnumParameter("Configuration", "ImplicitNodeConfiguration", (Lib3MF_int32)(eConfiguration));
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddClampNode(sIdentifier, eConfiguration, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addcomposevectornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeVectorNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddComposeVectorNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddComposeVectorNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addvectorfromscalarnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_VectorFromScalarNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddVectorFromScalarNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddVectorFromScalarNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_adddecomposevectornode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DecomposeVectorNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddDecomposeVectorNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddDecomposeVectorNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addcomposematrixnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeMatrixNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddComposeMatrixNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddComposeMatrixNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmatrixfromrowsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromRowsNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMatrixFromRowsNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMatrixFromRowsNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmatrixfromcolumnsnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromColumnsNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMatrixFromColumnsNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMatrixFromColumnsNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addconstantnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstantNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddConstantNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddConstantNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addconstvecnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstVecNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddConstVecNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddConstVecNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addconstmatnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstMatNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddConstMatNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddConstMatNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addmeshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MeshNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddMeshNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddMeshNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addunsignedmeshnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_UnsignedMeshNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddUnsignedMeshNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddUnsignedMeshNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addfunctioncallnode(Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_FunctionCallNode * pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddFunctionCallNode");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
			pJournalEntry->addStringParameter("DisplayName", pDisplayName);
			pJournalEntry->addStringParameter("Tag", pTag);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pDisplayName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTag == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pNode == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		std::string sDisplayName(pDisplayName);
		std::string sTag(pTag);
		IBase* pBaseNode(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseNode = pIImplicitFunction->AddFunctionCallNode(sIdentifier, sDisplayName, sTag);

		*pNode = (IBase*)(pBaseNode);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Node", *pNode);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_getnodes(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_NodeIterator * pIterator)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "GetNodes");
		}
		if (pIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseIterator(nullptr);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseIterator = pIImplicitFunction->GetNodes();

		*pIterator = (IBase*)(pBaseIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Iterator", *pIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_removenode(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitNode pNode)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "RemoveNode");
			pJournalEntry->addHandleParameter("Node", pNode);
		}
		IBase* pIBaseClassNode = (IBase *)pNode;
		IImplicitNode* pINode = dynamic_cast<IImplicitNode*>(pIBaseClassNode);
		if (!pINode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->RemoveNode(pINode);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlink(Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitPort pSource, Lib3MF_ImplicitPort pTarget)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLink");
			pJournalEntry->addHandleParameter("Source", pSource);
			pJournalEntry->addHandleParameter("Target", pTarget);
		}
		IBase* pIBaseClassSource = (IBase *)pSource;
		IImplicitPort* pISource = dynamic_cast<IImplicitPort*>(pIBaseClassSource);
		if (!pISource)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pIBaseClassTarget = (IBase *)pTarget;
		IImplicitPort* pITarget = dynamic_cast<IImplicitPort*>(pIBaseClassTarget);
		if (!pITarget)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->AddLink(pISource, pITarget);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_addlinkbynames(Lib3MF_ImplicitFunction pImplicitFunction, const char * pSource, const char * pTarget)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "AddLinkByNames");
			pJournalEntry->addStringParameter("Source", pSource);
			pJournalEntry->addStringParameter("Target", pTarget);
		}
		if (pSource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pTarget == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sSource(pSource);
		std::string sTarget(pTarget);
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->AddLinkByNames(sSource, sTarget);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_clear(Lib3MF_ImplicitFunction pImplicitFunction)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "Clear");
		}
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->Clear();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_implicitfunction_sortnodestopologically(Lib3MF_ImplicitFunction pImplicitFunction)
{
	IBase* pIBaseClass = (IBase *)pImplicitFunction;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pImplicitFunction, "ImplicitFunction", "SortNodesTopologically");
		}
		IImplicitFunction* pIImplicitFunction = dynamic_cast<IImplicitFunction*>(pIBaseClass);
		if (!pIImplicitFunction)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIImplicitFunction->SortNodesTopologically();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for FunctionFromImage3D
**************************************************************************************************************************/
Lib3MFResult lib3mf_functionfromimage3d_getimage3d(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D * pImage3D)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "GetImage3D");
		}
		if (pImage3D == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseImage3D(nullptr);
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseImage3D = pIFunctionFromImage3D->GetImage3D();

		*pImage3D = (IBase*)(pBaseImage3D);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Image3D", *pImage3D);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_setimage3d(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D pImage3D)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "SetImage3D");
			pJournalEntry->addHandleParameter("Image3D", pImage3D);
		}
		IBase* pIBaseClassImage3D = (IBase *)pImage3D;
		IImage3D* pIImage3D = dynamic_cast<IImage3D*>(pIBaseClassImage3D);
		if (!pIImage3D)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->SetImage3D(pIImage3D);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_setfilter(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter eFilter)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "SetFilter");
			pJournalEntry->addEnumParameter("Filter", "TextureFilter", (Lib3MF_int32)(eFilter));
		}
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->SetFilter(eFilter);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_getfilter(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter * pFilter)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "GetFilter");
		}
		if (pFilter == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pFilter = pIFunctionFromImage3D->GetFilter();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Filter", "TextureFilter", (Lib3MF_int32)(*pFilter));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_settilestyles(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV, eLib3MFTextureTileStyle eTileStyleW)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "SetTileStyles");
			pJournalEntry->addEnumParameter("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(eTileStyleU));
			pJournalEntry->addEnumParameter("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(eTileStyleV));
			pJournalEntry->addEnumParameter("TileStyleW", "TextureTileStyle", (Lib3MF_int32)(eTileStyleW));
		}
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->SetTileStyles(eTileStyleU, eTileStyleV, eTileStyleW);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_gettilestyles(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV, eLib3MFTextureTileStyle * pTileStyleW)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "GetTileStyles");
		}
		if (!pTileStyleU)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pTileStyleV)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pTileStyleW)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->GetTileStyles(*pTileStyleU, *pTileStyleV, *pTileStyleW);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleU));
			pJournalEntry->addEnumResult("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleV));
			pJournalEntry->addEnumResult("TileStyleW", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleW));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_getoffset(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pOffset)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "GetOffset");
		}
		if (pOffset == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOffset = pIFunctionFromImage3D->GetOffset();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("Offset", *pOffset);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_setoffset(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dOffset)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "SetOffset");
			pJournalEntry->addDoubleParameter("Offset", dOffset);
		}
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->SetOffset(dOffset);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_getscale(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pScale)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "GetScale");
		}
		if (pScale == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pScale = pIFunctionFromImage3D->GetScale();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("Scale", *pScale);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_functionfromimage3d_setscale(Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dScale)
{
	IBase* pIBaseClass = (IBase *)pFunctionFromImage3D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pFunctionFromImage3D, "FunctionFromImage3D", "SetScale");
			pJournalEntry->addDoubleParameter("Scale", dScale);
		}
		IFunctionFromImage3D* pIFunctionFromImage3D = dynamic_cast<IFunctionFromImage3D*>(pIBaseClass);
		if (!pIFunctionFromImage3D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIFunctionFromImage3D->SetScale(dScale);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BuildItem
**************************************************************************************************************************/
Lib3MFResult lib3mf_builditem_getobjectresource(Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectResource");
		}
		if (pObjectResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseObjectResource(nullptr);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseObjectResource = pIBuildItem->GetObjectResource();

		*pObjectResource = (IBase*)(pBaseObjectResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ObjectResource", *pObjectResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getuuid(Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIBuildItem->GetUUID(*pHasUUID);

			pIBuildItem->_setCache (new ParameterCache_2<bool, std::string> (*pHasUUID, sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<bool, std::string>*> (pIBuildItem->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pHasUUID, sUUID);
			pIBuildItem->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setuuid(Lib3MF_BuildItem pBuildItem, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getobjectresourceid(Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIBuildItem->GetObjectResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_hasobjecttransform(Lib3MF_BuildItem pBuildItem, bool * pHasTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "HasObjectTransform");
		}
		if (pHasTransform == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasTransform = pIBuildItem->HasObjectTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasTransform", *pHasTransform);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getobjecttransform(Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pIBuildItem->GetObjectTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setobjecttransform(Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetObjectTransform");
		}
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetObjectTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getpartnumber(Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetPartNumber");
		}
		if ( (!pPartNumberBuffer) && !(pPartNumberNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber("");
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPartNumberBuffer == nullptr);
		if (isCacheCall) {
			sPartNumber = pIBuildItem->GetPartNumber();

			pIBuildItem->_setCache (new ParameterCache_1<std::string> (sPartNumber));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIBuildItem->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPartNumber);
			pIBuildItem->_setCache (nullptr);
		}
		
		if (pPartNumberNeededChars)
			*pPartNumberNeededChars = (Lib3MF_uint32) (sPartNumber.size()+1);
		if (pPartNumberBuffer) {
			if (sPartNumber.size() >= nPartNumberBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPartNumber = 0; iPartNumber < sPartNumber.size(); iPartNumber++)
				pPartNumberBuffer[iPartNumber] = sPartNumber[iPartNumber];
			pPartNumberBuffer[sPartNumber.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("PartNumber", sPartNumber.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setpartnumber(Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetPartNumber");
			pJournalEntry->addStringParameter("SetPartnumber", pSetPartnumber);
		}
		if (pSetPartnumber == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sSetPartnumber(pSetPartnumber);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetPartNumber(sSetPartnumber);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getmetadatagroup(Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetMetaDataGroup");
		}
		if (pMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaDataGroup(nullptr);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaDataGroup = pIBuildItem->GetMetaDataGroup();

		*pMetaDataGroup = (IBase*)(pBaseMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaDataGroup", *pMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getoutbox(Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIBuildItem->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BuildItemIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_builditemiterator_movenext(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "MoveNext");
		}
		if (pHasNext == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasNext = pIBuildItemIterator->MoveNext();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasNext", *pHasNext);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_moveprevious(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "MovePrevious");
		}
		if (pHasPrevious == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasPrevious = pIBuildItemIterator->MovePrevious();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrevious", *pHasPrevious);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_getcurrent(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "GetCurrent");
		}
		if (pBuildItem == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBuildItem(nullptr);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItem = pIBuildItemIterator->GetCurrent();

		*pBuildItem = (IBase*)(pBaseBuildItem);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItem", *pBuildItem);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_clone(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "Clone");
		}
		if (pOutBuildItemIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseOutBuildItemIterator(nullptr);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutBuildItemIterator = pIBuildItemIterator->Clone();

		*pOutBuildItemIterator = (IBase*)(pBaseOutBuildItemIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("OutBuildItemIterator", *pOutBuildItemIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_count(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "Count");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBuildItemIterator->Count();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Slice
**************************************************************************************************************************/
Lib3MFResult lib3mf_slice_setvertices(Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "SetVertices");
		}
		if ( (!pVerticesBuffer) && (nVerticesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->SetVertices(nVerticesBufferSize, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getvertices(Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetVertices");
		}
		if ((!pVerticesBuffer) && !(pVerticesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->GetVertices(nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getvertexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetVertexCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetVertexCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_addpolygon(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "AddPolygon");
		}
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pISlice->AddPolygon(nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygoncount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetPolygonCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_setpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "SetPolygonIndices");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->SetPolygonIndices(nIndex, nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonIndices");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if ((!pIndicesBuffer) && !(pIndicesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->GetPolygonIndices(nIndex, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygonindexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonIndexCount");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetPolygonIndexCount(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getztop(Lib3MF_Slice pSlice, Lib3MF_double * pZTop)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetZTop");
		}
		if (pZTop == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pZTop = pISlice->GetZTop();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("ZTop", *pZTop);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for SliceStack
**************************************************************************************************************************/
Lib3MFResult lib3mf_slicestack_getbottomz(Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetBottomZ");
		}
		if (pZBottom == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pZBottom = pISliceStack->GetBottomZ();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("ZBottom", *pZBottom);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicecount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISliceStack->GetSliceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslice(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSlice");
			pJournalEntry->addUInt64Parameter("SliceIndex", nSliceIndex);
		}
		if (pTheSlice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSlice(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSlice = pISliceStack->GetSlice(nSliceIndex);

		*pTheSlice = (IBase*)(pBaseTheSlice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSlice", *pTheSlice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_addslice(Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "AddSlice");
			pJournalEntry->addDoubleParameter("ZTop", dZTop);
		}
		if (pTheSlice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSlice(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSlice = pISliceStack->AddSlice(dZTop);

		*pTheSlice = (IBase*)(pBaseTheSlice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSlice", *pTheSlice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicerefcount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceRefCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISliceStack->GetSliceRefCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_addslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "AddSliceStackReference");
			pJournalEntry->addHandleParameter("TheSliceStack", pTheSliceStack);
		}
		IBase* pIBaseClassTheSliceStack = (IBase *)pTheSliceStack;
		ISliceStack* pITheSliceStack = dynamic_cast<ISliceStack*>(pIBaseClassTheSliceStack);
		if (!pITheSliceStack)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->AddSliceStackReference(pITheSliceStack);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceStackReference");
			pJournalEntry->addUInt64Parameter("SliceRefIndex", nSliceRefIndex);
		}
		if (pTheSliceStack == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSliceStack(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSliceStack = pISliceStack->GetSliceStackReference(nSliceRefIndex);

		*pTheSliceStack = (IBase*)(pBaseTheSliceStack);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSliceStack", *pTheSliceStack);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_collapseslicereferences(Lib3MF_SliceStack pSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "CollapseSliceReferences");
		}
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->CollapseSliceReferences();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_setownpath(Lib3MF_SliceStack pSliceStack, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "SetOwnPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->SetOwnPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getownpath(Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetOwnPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pPathBuffer == nullptr);
		if (isCacheCall) {
			sPath = pISliceStack->GetOwnPath();

			pISliceStack->_setCache (new ParameterCache_1<std::string> (sPath));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pISliceStack->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sPath);
			pISliceStack->_setCache (nullptr);
		}
		
		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Consumer
**************************************************************************************************************************/
Lib3MFResult lib3mf_consumer_getconsumerid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetConsumerID");
		}
		if ( (!pConsumerIDBuffer) && !(pConsumerIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pConsumerIDBuffer == nullptr);
		if (isCacheCall) {
			sConsumerID = pIConsumer->GetConsumerID();

			pIConsumer->_setCache (new ParameterCache_1<std::string> (sConsumerID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIConsumer->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sConsumerID);
			pIConsumer->_setCache (nullptr);
		}
		
		if (pConsumerIDNeededChars)
			*pConsumerIDNeededChars = (Lib3MF_uint32) (sConsumerID.size()+1);
		if (pConsumerIDBuffer) {
			if (sConsumerID.size() >= nConsumerIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iConsumerID = 0; iConsumerID < sConsumerID.size(); iConsumerID++)
				pConsumerIDBuffer[iConsumerID] = sConsumerID[iConsumerID];
			pConsumerIDBuffer[sConsumerID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ConsumerID", sConsumerID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_consumer_getkeyid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetKeyID");
		}
		if ( (!pKeyIDBuffer) && !(pKeyIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKeyID("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pKeyIDBuffer == nullptr);
		if (isCacheCall) {
			sKeyID = pIConsumer->GetKeyID();

			pIConsumer->_setCache (new ParameterCache_1<std::string> (sKeyID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIConsumer->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sKeyID);
			pIConsumer->_setCache (nullptr);
		}
		
		if (pKeyIDNeededChars)
			*pKeyIDNeededChars = (Lib3MF_uint32) (sKeyID.size()+1);
		if (pKeyIDBuffer) {
			if (sKeyID.size() >= nKeyIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKeyID = 0; iKeyID < sKeyID.size(); iKeyID++)
				pKeyIDBuffer[iKeyID] = sKeyID[iKeyID];
			pKeyIDBuffer[sKeyID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("KeyID", sKeyID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_consumer_getkeyvalue(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetKeyValue");
		}
		if ( (!pKeyValueBuffer) && !(pKeyValueNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKeyValue("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pKeyValueBuffer == nullptr);
		if (isCacheCall) {
			sKeyValue = pIConsumer->GetKeyValue();

			pIConsumer->_setCache (new ParameterCache_1<std::string> (sKeyValue));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIConsumer->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sKeyValue);
			pIConsumer->_setCache (nullptr);
		}
		
		if (pKeyValueNeededChars)
			*pKeyValueNeededChars = (Lib3MF_uint32) (sKeyValue.size()+1);
		if (pKeyValueBuffer) {
			if (sKeyValue.size() >= nKeyValueBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKeyValue = 0; iKeyValue < sKeyValue.size(); iKeyValue++)
				pKeyValueBuffer[iKeyValue] = sKeyValue[iKeyValue];
			pKeyValueBuffer[sKeyValue.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("KeyValue", sKeyValue.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for AccessRight
**************************************************************************************************************************/
Lib3MFResult lib3mf_accessright_getconsumer(Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetConsumer");
		}
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseConsumer(nullptr);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIAccessRight->GetConsumer();

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getwrappingalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetWrappingAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetWrappingAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "WrappingAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getmgfalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetMgfAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetMgfAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "MgfAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getdigestmethod(Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetDigestMethod");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetDigestMethod();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "DigestMethod", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ContentEncryptionParams
**************************************************************************************************************************/
Lib3MFResult lib3mf_contentencryptionparams_getencryptionalgorithm(Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetEncryptionAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIContentEncryptionParams->GetEncryptionAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "EncryptionAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getkey(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetKey");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetKey(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getinitializationvector(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetInitializationVector");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetInitializationVector(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetAuthenticationTag");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetAuthenticationTag(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_setauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "SetAuthenticationTag");
		}
		if ( (!pByteDataBuffer) && (nByteDataBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->SetAuthenticationTag(nByteDataBufferSize, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getadditionalauthenticationdata(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetAdditionalAuthenticationData");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetAdditionalAuthenticationData(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getdescriptor(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetDescriptor");
		}
		if (pDescriptor == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pDescriptor = pIContentEncryptionParams->GetDescriptor();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Descriptor", *pDescriptor);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getkeyuuid(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetKeyUUID");
		}
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIContentEncryptionParams->GetKeyUUID();

			pIContentEncryptionParams->_setCache (new ParameterCache_1<std::string> (sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIContentEncryptionParams->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sUUID);
			pIContentEncryptionParams->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceData
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourcedata_getpath(Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetPath");
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePath(nullptr);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePath = pIResourceData->GetPath();

		*pPath = (IBase*)(pBasePath);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Path", *pPath);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getencryptionalgorithm(Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetEncryptionAlgorithm");
		}
		if (pEncryptionAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pEncryptionAlgorithm = pIResourceData->GetEncryptionAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("EncryptionAlgorithm", "EncryptionAlgorithm", (Lib3MF_int32)(*pEncryptionAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getcompression(Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetCompression");
		}
		if (pCompression == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCompression = pIResourceData->GetCompression();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Compression", "Compression", (Lib3MF_int32)(*pCompression));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getadditionalauthenticationdata(Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetAdditionalAuthenticationData");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResourceData->GetAdditionalAuthenticationData(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceDataGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourcedatagroup_getkeyuuid(Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "GetKeyUUID");
		}
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIResourceDataGroup->GetKeyUUID();

			pIResourceDataGroup->_setCache (new ParameterCache_1<std::string> (sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIResourceDataGroup->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sUUID);
			pIResourceDataGroup->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_addaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "AddAccessRight");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
			pJournalEntry->addEnumParameter("WrappingAlgorithm", "WrappingAlgorithm", (Lib3MF_int32)(eWrappingAlgorithm));
			pJournalEntry->addEnumParameter("MgfAlgorithm", "MgfAlgorithm", (Lib3MF_int32)(eMgfAlgorithm));
			pJournalEntry->addEnumParameter("DigestMethod", "DigestMethod", (Lib3MF_int32)(eDigestMethod));
		}
		if (pTheAccessRight == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheAccessRight(nullptr);
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheAccessRight = pIResourceDataGroup->AddAccessRight(pIConsumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod);

		*pTheAccessRight = (IBase*)(pBaseTheAccessRight);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheAccessRight", *pTheAccessRight);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_findaccessrightbyconsumer(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "FindAccessRightByConsumer");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		if (pTheAccessRight == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheAccessRight(nullptr);
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheAccessRight = pIResourceDataGroup->FindAccessRightByConsumer(pIConsumer);

		*pTheAccessRight = (IBase*)(pBaseTheAccessRight);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheAccessRight", *pTheAccessRight);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_removeaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "RemoveAccessRight");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResourceDataGroup->RemoveAccessRight(pIConsumer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for KeyStore
**************************************************************************************************************************/
Lib3MFResult lib3mf_keystore_addconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddConsumer");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addStringParameter("KeyID", pKeyID);
			pJournalEntry->addStringParameter("KeyValue", pKeyValue);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pKeyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pKeyValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		std::string sKeyID(pKeyID);
		std::string sKeyValue(pKeyValue);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->AddConsumer(sConsumerID, sKeyID, sKeyValue);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getconsumercount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetConsumerCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetConsumerCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetConsumer");
			pJournalEntry->addUInt64Parameter("ConsumerIndex", nConsumerIndex);
		}
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->GetConsumer(nConsumerIndex);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveConsumer");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveConsumer(pIConsumer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindConsumer");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->FindConsumer(sConsumerID);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatagroupcount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataGroupCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetResourceDataGroupCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_addresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddResourceDataGroup");
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->AddResourceDataGroup();

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataGroup");
			pJournalEntry->addUInt64Parameter("ResourceDataIndex", nResourceDataIndex);
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->GetResourceDataGroup(nResourceDataIndex);

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveResourceDataGroup");
			pJournalEntry->addHandleParameter("ResourceDataGroup", pResourceDataGroup);
		}
		IBase* pIBaseClassResourceDataGroup = (IBase *)pResourceDataGroup;
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClassResourceDataGroup);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveResourceDataGroup(pIResourceDataGroup);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindResourceDataGroup");
			pJournalEntry->addHandleParameter("PartPath", pPartPath);
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassPartPath = (IBase *)pPartPath;
		IPackagePart* pIPartPath = dynamic_cast<IPackagePart*>(pIBaseClassPartPath);
		if (!pIPartPath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->FindResourceDataGroup(pIPartPath);

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_addresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddResourceData");
			pJournalEntry->addHandleParameter("ResourceDataGroup", pResourceDataGroup);
			pJournalEntry->addHandleParameter("PartPath", pPartPath);
			pJournalEntry->addEnumParameter("Algorithm", "EncryptionAlgorithm", (Lib3MF_int32)(eAlgorithm));
			pJournalEntry->addEnumParameter("Compression", "Compression", (Lib3MF_int32)(eCompression));
		}
		if ( (!pAdditionalAuthenticationDataBuffer) && (nAdditionalAuthenticationDataBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassResourceDataGroup = (IBase *)pResourceDataGroup;
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClassResourceDataGroup);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pIBaseClassPartPath = (IBase *)pPartPath;
		IPackagePart* pIPartPath = dynamic_cast<IPackagePart*>(pIBaseClassPartPath);
		if (!pIPartPath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->AddResourceData(pIResourceDataGroup, pIPartPath, eAlgorithm, eCompression, nAdditionalAuthenticationDataBufferSize, pAdditionalAuthenticationDataBuffer);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveResourceData");
			pJournalEntry->addHandleParameter("ResourceData", pResourceData);
		}
		IBase* pIBaseClassResourceData = (IBase *)pResourceData;
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClassResourceData);
		if (!pIResourceData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveResourceData(pIResourceData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindResourceData");
			pJournalEntry->addHandleParameter("ResourcePath", pResourcePath);
		}
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassResourcePath = (IBase *)pResourcePath;
		IPackagePart* pIResourcePath = dynamic_cast<IPackagePart*>(pIBaseClassResourcePath);
		if (!pIResourcePath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->FindResourceData(pIResourcePath);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatacount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetResourceDataCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceData");
			pJournalEntry->addUInt64Parameter("ResourceDataIndex", nResourceDataIndex);
		}
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->GetResourceData(nResourceDataIndex);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getuuid(Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIKeyStore->GetUUID(*pHasUUID);

			pIKeyStore->_setCache (new ParameterCache_2<bool, std::string> (*pHasUUID, sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<bool, std::string>*> (pIKeyStore->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pHasUUID, sUUID);
			pIKeyStore->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_setuuid(Lib3MF_KeyStore pKeyStore, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Model
**************************************************************************************************************************/
Lib3MFResult lib3mf_model_rootmodelpart(Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RootModelPart");
		}
		if (pRootModelPart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRootModelPart(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRootModelPart = pIModel->RootModelPart();

		*pRootModelPart = (IBase*)(pBaseRootModelPart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("RootModelPart", *pRootModelPart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_findorcreatepackagepart(Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "FindOrCreatePackagePart");
			pJournalEntry->addStringParameter("AbsolutePath", pAbsolutePath);
		}
		if (pAbsolutePath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pModelPart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sAbsolutePath(pAbsolutePath);
		IBase* pBaseModelPart(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseModelPart = pIModel->FindOrCreatePackagePart(sAbsolutePath);

		*pModelPart = (IBase*)(pBaseModelPart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ModelPart", *pModelPart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setunit(Lib3MF_Model pModel, eLib3MFModelUnit eUnit)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetUnit");
			pJournalEntry->addEnumParameter("Unit", "ModelUnit", (Lib3MF_int32)(eUnit));
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetUnit(eUnit);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getunit(Lib3MF_Model pModel, eLib3MFModelUnit * pUnit)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetUnit");
		}
		if (pUnit == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUnit = pIModel->GetUnit();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Unit", "ModelUnit", (Lib3MF_int32)(*pUnit));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getlanguage(Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetLanguage");
		}
		if ( (!pLanguageBuffer) && !(pLanguageNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sLanguage("");
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pLanguageBuffer == nullptr);
		if (isCacheCall) {
			sLanguage = pIModel->GetLanguage();

			pIModel->_setCache (new ParameterCache_1<std::string> (sLanguage));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_1<std::string>*> (pIModel->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (sLanguage);
			pIModel->_setCache (nullptr);
		}
		
		if (pLanguageNeededChars)
			*pLanguageNeededChars = (Lib3MF_uint32) (sLanguage.size()+1);
		if (pLanguageBuffer) {
			if (sLanguage.size() >= nLanguageBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iLanguage = 0; iLanguage < sLanguage.size(); iLanguage++)
				pLanguageBuffer[iLanguage] = sLanguage[iLanguage];
			pLanguageBuffer[sLanguage.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Language", sLanguage.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setlanguage(Lib3MF_Model pModel, const char * pLanguage)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetLanguage");
			pJournalEntry->addStringParameter("Language", pLanguage);
		}
		if (pLanguage == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sLanguage(pLanguage);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetLanguage(sLanguage);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_querywriter(Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "QueryWriter");
			pJournalEntry->addStringParameter("WriterClass", pWriterClass);
		}
		if (pWriterClass == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pWriterInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWriterClass(pWriterClass);
		IBase* pBaseWriterInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseWriterInstance = pIModel->QueryWriter(sWriterClass);

		*pWriterInstance = (IBase*)(pBaseWriterInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("WriterInstance", *pWriterInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_queryreader(Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "QueryReader");
			pJournalEntry->addStringParameter("ReaderClass", pReaderClass);
		}
		if (pReaderClass == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pReaderInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sReaderClass(pReaderClass);
		IBase* pBaseReaderInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseReaderInstance = pIModel->QueryReader(sReaderClass);

		*pReaderInstance = (IBase*)(pBaseReaderInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ReaderInstance", *pReaderInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getresourcebyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Resource * pResource)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetResourceByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIModel->GetResourceByID(nUniqueResourceID);

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pTextureInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTextureInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTextureInstance = pIModel->GetTexture2DByID(nUniqueResourceID);

		*pTextureInstance = (IBase*)(pBaseTextureInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TextureInstance", *pTextureInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getpropertytypebyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetPropertyTypeByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pThePropertyType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pThePropertyType = pIModel->GetPropertyTypeByID(nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ThePropertyType", "PropertyType", (Lib3MF_int32)(*pThePropertyType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbasematerialgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBaseMaterialGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pIModel->GetBaseMaterialGroupByID(nUniqueResourceID);

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pTexture2DGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTexture2DGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DGroupInstance = pIModel->GetTexture2DGroupByID(nUniqueResourceID);

		*pTexture2DGroupInstance = (IBase*)(pBaseTexture2DGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DGroupInstance", *pTexture2DGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcompositematerialsbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetCompositeMaterialsByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pCompositeMaterialsInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseCompositeMaterialsInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseCompositeMaterialsInstance = pIModel->GetCompositeMaterialsByID(nUniqueResourceID);

		*pCompositeMaterialsInstance = (IBase*)(pBaseCompositeMaterialsInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("CompositeMaterialsInstance", *pCompositeMaterialsInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmultipropertygroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMultiPropertyGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pMultiPropertyGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMultiPropertyGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMultiPropertyGroupInstance = pIModel->GetMultiPropertyGroupByID(nUniqueResourceID);

		*pMultiPropertyGroupInstance = (IBase*)(pBaseMultiPropertyGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MultiPropertyGroupInstance", *pMultiPropertyGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmeshobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMeshObjectByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pMeshObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMeshObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMeshObjectInstance = pIModel->GetMeshObjectByID(nUniqueResourceID);

		*pMeshObjectInstance = (IBase*)(pBaseMeshObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MeshObjectInstance", *pMeshObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcomponentsobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetComponentsObjectByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pComponentsObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentsObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentsObjectInstance = pIModel->GetComponentsObjectByID(nUniqueResourceID);

		*pComponentsObjectInstance = (IBase*)(pBaseComponentsObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentsObjectInstance", *pComponentsObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcolorgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetColorGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pColorGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColorGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColorGroupInstance = pIModel->GetColorGroupByID(nUniqueResourceID);

		*pColorGroupInstance = (IBase*)(pBaseColorGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ColorGroupInstance", *pColorGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getslicestackbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetSliceStackByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pSliceStacInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStacInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStacInstance = pIModel->GetSliceStackByID(nUniqueResourceID);

		*pSliceStacInstance = (IBase*)(pBaseSliceStacInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStacInstance", *pSliceStacInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getlevelsetbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_LevelSet * pLevelSetObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetLevelSetByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pLevelSetObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseLevelSetObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseLevelSetObjectInstance = pIModel->GetLevelSetByID(nUniqueResourceID);

		*pLevelSetObjectInstance = (IBase*)(pBaseLevelSetObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("LevelSetObjectInstance", *pLevelSetObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbuilduuid(Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBuildUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		bool isCacheCall = (pUUIDBuffer == nullptr);
		if (isCacheCall) {
			sUUID = pIModel->GetBuildUUID(*pHasUUID);

			pIModel->_setCache (new ParameterCache_2<bool, std::string> (*pHasUUID, sUUID));
		}
		else {
			auto cache = dynamic_cast<ParameterCache_2<bool, std::string>*> (pIModel->_getCache ());
			if (cache == nullptr)
				throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
			cache->retrieveData (*pHasUUID, sUUID);
			pIModel->_setCache (nullptr);
		}
		
		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setbuilduuid(Lib3MF_Model pModel, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetBuildUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetBuildUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbuilditems(Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBuildItems");
		}
		if (pBuildItemIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBuildItemIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItemIterator = pIModel->GetBuildItems();

		*pBuildItemIterator = (IBase*)(pBaseBuildItemIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItemIterator", *pBuildItemIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getoutbox(Lib3MF_Model pModel, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIModel->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getresources(Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetResources");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetResources();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getobjects(Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmeshobjects(Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMeshObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetMeshObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcomponentsobjects(Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetComponentsObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetComponentsObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2ds(Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2Ds");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetTexture2Ds();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbasematerialgroups(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBaseMaterialGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetBaseMaterialGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcolorgroups(Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetColorGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetColorGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dgroups(Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetTexture2DGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcompositematerials(Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetCompositeMaterials");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetCompositeMaterials();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmultipropertygroups(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMultiPropertyGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetMultiPropertyGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getslicestacks(Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetSliceStacks");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetSliceStacks();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getimage3ds(Lib3MF_Model pModel, Lib3MF_Image3DIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetImage3Ds");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetImage3Ds();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_mergetomodel(Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "MergeToModel");
		}
		if (pMergedModelInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMergedModelInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMergedModelInstance = pIModel->MergeToModel();

		*pMergedModelInstance = (IBase*)(pBaseMergedModelInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MergedModelInstance", *pMergedModelInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_mergefrommodel(Lib3MF_Model pModel, Lib3MF_Model pModelInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "MergeFromModel");
			pJournalEntry->addHandleParameter("ModelInstance", pModelInstance);
		}
		IBase* pIBaseClassModelInstance = (IBase *)pModelInstance;
		IModel* pIModelInstance = dynamic_cast<IModel*>(pIBaseClassModelInstance);
		if (!pIModelInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->MergeFromModel(pIModelInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addmeshobject(Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddMeshObject");
		}
		if (pMeshObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMeshObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMeshObjectInstance = pIModel->AddMeshObject();

		*pMeshObjectInstance = (IBase*)(pBaseMeshObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MeshObjectInstance", *pMeshObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcomponentsobject(Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddComponentsObject");
		}
		if (pComponentsObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentsObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentsObjectInstance = pIModel->AddComponentsObject();

		*pComponentsObjectInstance = (IBase*)(pBaseComponentsObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentsObjectInstance", *pComponentsObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addslicestack(Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddSliceStack");
			pJournalEntry->addDoubleParameter("ZBottom", dZBottom);
		}
		if (pSliceStackInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStackInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStackInstance = pIModel->AddSliceStack(dZBottom);

		*pSliceStackInstance = (IBase*)(pBaseSliceStackInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStackInstance", *pSliceStackInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addtexture2dfromattachment(Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddTexture2DFromAttachment");
			pJournalEntry->addHandleParameter("TextureAttachment", pTextureAttachment);
		}
		if (pTexture2DInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassTextureAttachment = (IBase *)pTextureAttachment;
		IAttachment* pITextureAttachment = dynamic_cast<IAttachment*>(pIBaseClassTextureAttachment);
		if (!pITextureAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTexture2DInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DInstance = pIModel->AddTexture2DFromAttachment(pITextureAttachment);

		*pTexture2DInstance = (IBase*)(pBaseTexture2DInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DInstance", *pTexture2DInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addbasematerialgroup(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddBaseMaterialGroup");
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pIModel->AddBaseMaterialGroup();

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcolorgroup(Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddColorGroup");
		}
		if (pColorGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColorGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColorGroupInstance = pIModel->AddColorGroup();

		*pColorGroupInstance = (IBase*)(pBaseColorGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ColorGroupInstance", *pColorGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addtexture2dgroup(Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddTexture2DGroup");
			pJournalEntry->addHandleParameter("Texture2DInstance", pTexture2DInstance);
		}
		if (pTexture2DGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassTexture2DInstance = (IBase *)pTexture2DInstance;
		ITexture2D* pITexture2DInstance = dynamic_cast<ITexture2D*>(pIBaseClassTexture2DInstance);
		if (!pITexture2DInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTexture2DGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DGroupInstance = pIModel->AddTexture2DGroup(pITexture2DInstance);

		*pTexture2DGroupInstance = (IBase*)(pBaseTexture2DGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DGroupInstance", *pTexture2DGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcompositematerials(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddCompositeMaterials");
			pJournalEntry->addHandleParameter("BaseMaterialGroupInstance", pBaseMaterialGroupInstance);
		}
		if (pCompositeMaterialsInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassBaseMaterialGroupInstance = (IBase *)pBaseMaterialGroupInstance;
		IBaseMaterialGroup* pIBaseMaterialGroupInstance = dynamic_cast<IBaseMaterialGroup*>(pIBaseClassBaseMaterialGroupInstance);
		if (!pIBaseMaterialGroupInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseCompositeMaterialsInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseCompositeMaterialsInstance = pIModel->AddCompositeMaterials(pIBaseMaterialGroupInstance);

		*pCompositeMaterialsInstance = (IBase*)(pBaseCompositeMaterialsInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("CompositeMaterialsInstance", *pCompositeMaterialsInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addmultipropertygroup(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddMultiPropertyGroup");
		}
		if (pMultiPropertyGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMultiPropertyGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMultiPropertyGroupInstance = pIModel->AddMultiPropertyGroup();

		*pMultiPropertyGroupInstance = (IBase*)(pBaseMultiPropertyGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MultiPropertyGroupInstance", *pMultiPropertyGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addimagestack(Lib3MF_Model pModel, Lib3MF_uint32 nColumnCount, Lib3MF_uint32 nRowCount, Lib3MF_uint32 nSheetCount, Lib3MF_ImageStack * pInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddImageStack");
			pJournalEntry->addUInt32Parameter("ColumnCount", nColumnCount);
			pJournalEntry->addUInt32Parameter("RowCount", nRowCount);
			pJournalEntry->addUInt32Parameter("SheetCount", nSheetCount);
		}
		if (pInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseInstance = pIModel->AddImageStack(nColumnCount, nRowCount, nSheetCount);

		*pInstance = (IBase*)(pBaseInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Instance", *pInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getimagestackbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ImageStack * pImageStackInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetImageStackByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pImageStackInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseImageStackInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseImageStackInstance = pIModel->GetImageStackByID(nUniqueResourceID);

		*pImageStackInstance = (IBase*)(pBaseImageStackInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ImageStackInstance", *pImageStackInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addbuilditem(Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddBuildItem");
			pJournalEntry->addHandleParameter("Object", pObject);
		}
		if (pBuildItemInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassObject = (IBase *)pObject;
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClassObject);
		if (!pIObject)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseBuildItemInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItemInstance = pIModel->AddBuildItem(pIObject, *pTransform);

		*pBuildItemInstance = (IBase*)(pBaseBuildItemInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItemInstance", *pBuildItemInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removebuilditem(Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveBuildItem");
			pJournalEntry->addHandleParameter("BuildItemInstance", pBuildItemInstance);
		}
		IBase* pIBaseClassBuildItemInstance = (IBase *)pBuildItemInstance;
		IBuildItem* pIBuildItemInstance = dynamic_cast<IBuildItem*>(pIBaseClassBuildItemInstance);
		if (!pIBuildItemInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveBuildItem(pIBuildItemInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmetadatagroup(Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMetaDataGroup");
		}
		if (pTheMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheMetaDataGroup(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheMetaDataGroup = pIModel->GetMetaDataGroup();

		*pTheMetaDataGroup = (IBase*)(pBaseTheMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheMetaDataGroup", *pTheMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addattachment(Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddAttachment");
			pJournalEntry->addStringParameter("URI", pURI);
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pURI == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sURI(pURI);
		std::string sRelationShipType(pRelationShipType);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->AddAttachment(sURI, sRelationShipType);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removeattachment(Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveAttachment");
			pJournalEntry->addHandleParameter("AttachmentInstance", pAttachmentInstance);
		}
		IBase* pIBaseClassAttachmentInstance = (IBase *)pAttachmentInstance;
		IAttachment* pIAttachmentInstance = dynamic_cast<IAttachment*>(pIBaseClassAttachmentInstance);
		if (!pIAttachmentInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveAttachment(pIAttachmentInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getattachment(Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetAttachment");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->GetAttachment(nIndex);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_findattachment(Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "FindAttachment");
			pJournalEntry->addStringParameter("URI", pURI);
		}
		if (pURI == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sURI(pURI);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->FindAttachment(sURI);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getattachmentcount(Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetAttachmentCount");
		}
		if (pAttachmentCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAttachmentCount = pIModel->GetAttachmentCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("AttachmentCount", *pAttachmentCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_haspackagethumbnailattachment(Lib3MF_Model pModel, bool * pHasThumbnail)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "HasPackageThumbnailAttachment");
		}
		if (pHasThumbnail == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasThumbnail = pIModel->HasPackageThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasThumbnail", *pHasThumbnail);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_createpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "CreatePackageThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIModel->CreatePackageThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetPackageThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIModel->GetPackageThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removepackagethumbnailattachment(Lib3MF_Model pModel)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemovePackageThumbnailAttachment");
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemovePackageThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcustomcontenttype(Lib3MF_Model pModel, const char * pExtension, const char * pContentType)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddCustomContentType");
			pJournalEntry->addStringParameter("Extension", pExtension);
			pJournalEntry->addStringParameter("ContentType", pContentType);
		}
		if (pExtension == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pContentType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sExtension(pExtension);
		std::string sContentType(pContentType);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->AddCustomContentType(sExtension, sContentType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removecustomcontenttype(Lib3MF_Model pModel, const char * pExtension)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveCustomContentType");
			pJournalEntry->addStringParameter("Extension", pExtension);
		}
		if (pExtension == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sExtension(pExtension);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveCustomContentType(sExtension);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setrandomnumbercallback(Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetRandomNumberCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetRandomNumberCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getkeystore(Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetKeyStore");
		}
		if (pKeyStore == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseKeyStore(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseKeyStore = pIModel->GetKeyStore();

		*pKeyStore = (IBase*)(pBaseKeyStore);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("KeyStore", *pKeyStore);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getfunctions(Lib3MF_Model pModel, Lib3MF_FunctionIterator * pTheResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetFunctions");
		}
		if (pTheResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheResourceIterator = pIModel->GetFunctions();

		*pTheResourceIterator = (IBase*)(pBaseTheResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheResourceIterator", *pTheResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addimplicitfunction(Lib3MF_Model pModel, Lib3MF_ImplicitFunction * pFunctionInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddImplicitFunction");
		}
		if (pFunctionInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseFunctionInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseFunctionInstance = pIModel->AddImplicitFunction();

		*pFunctionInstance = (IBase*)(pBaseFunctionInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("FunctionInstance", *pFunctionInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addfunctionfromimage3d(Lib3MF_Model pModel, Lib3MF_Image3D pImage3DInstance, Lib3MF_FunctionFromImage3D * pFunctionInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddFunctionFromImage3D");
			pJournalEntry->addHandleParameter("Image3DInstance", pImage3DInstance);
		}
		if (pFunctionInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassImage3DInstance = (IBase *)pImage3DInstance;
		IImage3D* pIImage3DInstance = dynamic_cast<IImage3D*>(pIBaseClassImage3DInstance);
		if (!pIImage3DInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseFunctionInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseFunctionInstance = pIModel->AddFunctionFromImage3D(pIImage3DInstance);

		*pFunctionInstance = (IBase*)(pBaseFunctionInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("FunctionInstance", *pFunctionInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addvolumedata(Lib3MF_Model pModel, Lib3MF_VolumeData * pVolumeDataInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddVolumeData");
		}
		if (pVolumeDataInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseVolumeDataInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseVolumeDataInstance = pIModel->AddVolumeData();

		*pVolumeDataInstance = (IBase*)(pBaseVolumeDataInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("VolumeDataInstance", *pVolumeDataInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addlevelset(Lib3MF_Model pModel, Lib3MF_LevelSet * pLevelSetInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddLevelSet");
		}
		if (pLevelSetInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseLevelSetInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseLevelSetInstance = pIModel->AddLevelSet();

		*pLevelSetInstance = (IBase*)(pBaseLevelSetInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("LevelSetInstance", *pLevelSetInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getlevelsets(Lib3MF_Model pModel, Lib3MF_LevelSetIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetLevelSets");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetLevelSets();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removeresource(Lib3MF_Model pModel, Lib3MF_Resource pResource)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveResource");
			pJournalEntry->addHandleParameter("Resource", pResource);
		}
		IBase* pIBaseClassResource = (IBase *)pResource;
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClassResource);
		if (!pIResource)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveResource(pIResource);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}



/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

Lib3MFResult Lib3MF::Impl::Lib3MF_GetProcAddress (const char * pProcName, void ** ppProcAddress)
{
	if (pProcName == nullptr)
		return LIB3MF_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return LIB3MF_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	if (sProcName == "lib3mf_base_classtypeid") 
		*ppProcAddress = (void*) &lib3mf_base_classtypeid;
	if (sProcName == "lib3mf_writer_writetofile") 
		*ppProcAddress = (void*) &lib3mf_writer_writetofile;
	if (sProcName == "lib3mf_writer_getstreamsize") 
		*ppProcAddress = (void*) &lib3mf_writer_getstreamsize;
	if (sProcName == "lib3mf_writer_writetobuffer") 
		*ppProcAddress = (void*) &lib3mf_writer_writetobuffer;
	if (sProcName == "lib3mf_writer_writetocallback") 
		*ppProcAddress = (void*) &lib3mf_writer_writetocallback;
	if (sProcName == "lib3mf_writer_setprogresscallback") 
		*ppProcAddress = (void*) &lib3mf_writer_setprogresscallback;
	if (sProcName == "lib3mf_writer_getdecimalprecision") 
		*ppProcAddress = (void*) &lib3mf_writer_getdecimalprecision;
	if (sProcName == "lib3mf_writer_setdecimalprecision") 
		*ppProcAddress = (void*) &lib3mf_writer_setdecimalprecision;
	if (sProcName == "lib3mf_writer_setstrictmodeactive") 
		*ppProcAddress = (void*) &lib3mf_writer_setstrictmodeactive;
	if (sProcName == "lib3mf_writer_getstrictmodeactive") 
		*ppProcAddress = (void*) &lib3mf_writer_getstrictmodeactive;
	if (sProcName == "lib3mf_writer_getwarning") 
		*ppProcAddress = (void*) &lib3mf_writer_getwarning;
	if (sProcName == "lib3mf_writer_getwarningcount") 
		*ppProcAddress = (void*) &lib3mf_writer_getwarningcount;
	if (sProcName == "lib3mf_writer_addkeywrappingcallback") 
		*ppProcAddress = (void*) &lib3mf_writer_addkeywrappingcallback;
	if (sProcName == "lib3mf_writer_setcontentencryptioncallback") 
		*ppProcAddress = (void*) &lib3mf_writer_setcontentencryptioncallback;
	if (sProcName == "lib3mf_reader_readfromfile") 
		*ppProcAddress = (void*) &lib3mf_reader_readfromfile;
	if (sProcName == "lib3mf_reader_readfrombuffer") 
		*ppProcAddress = (void*) &lib3mf_reader_readfrombuffer;
	if (sProcName == "lib3mf_reader_readfromcallback") 
		*ppProcAddress = (void*) &lib3mf_reader_readfromcallback;
	if (sProcName == "lib3mf_reader_setprogresscallback") 
		*ppProcAddress = (void*) &lib3mf_reader_setprogresscallback;
	if (sProcName == "lib3mf_reader_addrelationtoread") 
		*ppProcAddress = (void*) &lib3mf_reader_addrelationtoread;
	if (sProcName == "lib3mf_reader_removerelationtoread") 
		*ppProcAddress = (void*) &lib3mf_reader_removerelationtoread;
	if (sProcName == "lib3mf_reader_setstrictmodeactive") 
		*ppProcAddress = (void*) &lib3mf_reader_setstrictmodeactive;
	if (sProcName == "lib3mf_reader_getstrictmodeactive") 
		*ppProcAddress = (void*) &lib3mf_reader_getstrictmodeactive;
	if (sProcName == "lib3mf_reader_getwarning") 
		*ppProcAddress = (void*) &lib3mf_reader_getwarning;
	if (sProcName == "lib3mf_reader_getwarningcount") 
		*ppProcAddress = (void*) &lib3mf_reader_getwarningcount;
	if (sProcName == "lib3mf_reader_addkeywrappingcallback") 
		*ppProcAddress = (void*) &lib3mf_reader_addkeywrappingcallback;
	if (sProcName == "lib3mf_reader_setcontentencryptioncallback") 
		*ppProcAddress = (void*) &lib3mf_reader_setcontentencryptioncallback;
	if (sProcName == "lib3mf_packagepart_getpath") 
		*ppProcAddress = (void*) &lib3mf_packagepart_getpath;
	if (sProcName == "lib3mf_packagepart_setpath") 
		*ppProcAddress = (void*) &lib3mf_packagepart_setpath;
	if (sProcName == "lib3mf_resource_getresourceid") 
		*ppProcAddress = (void*) &lib3mf_resource_getresourceid;
	if (sProcName == "lib3mf_resource_getuniqueresourceid") 
		*ppProcAddress = (void*) &lib3mf_resource_getuniqueresourceid;
	if (sProcName == "lib3mf_resource_packagepart") 
		*ppProcAddress = (void*) &lib3mf_resource_packagepart;
	if (sProcName == "lib3mf_resource_setpackagepart") 
		*ppProcAddress = (void*) &lib3mf_resource_setpackagepart;
	if (sProcName == "lib3mf_resource_getmodelresourceid") 
		*ppProcAddress = (void*) &lib3mf_resource_getmodelresourceid;
	if (sProcName == "lib3mf_resourceiterator_movenext") 
		*ppProcAddress = (void*) &lib3mf_resourceiterator_movenext;
	if (sProcName == "lib3mf_resourceiterator_moveprevious") 
		*ppProcAddress = (void*) &lib3mf_resourceiterator_moveprevious;
	if (sProcName == "lib3mf_resourceiterator_getcurrent") 
		*ppProcAddress = (void*) &lib3mf_resourceiterator_getcurrent;
	if (sProcName == "lib3mf_resourceiterator_clone") 
		*ppProcAddress = (void*) &lib3mf_resourceiterator_clone;
	if (sProcName == "lib3mf_resourceiterator_count") 
		*ppProcAddress = (void*) &lib3mf_resourceiterator_count;
	if (sProcName == "lib3mf_slicestackiterator_getcurrentslicestack") 
		*ppProcAddress = (void*) &lib3mf_slicestackiterator_getcurrentslicestack;
	if (sProcName == "lib3mf_objectiterator_getcurrentobject") 
		*ppProcAddress = (void*) &lib3mf_objectiterator_getcurrentobject;
	if (sProcName == "lib3mf_meshobjectiterator_getcurrentmeshobject") 
		*ppProcAddress = (void*) &lib3mf_meshobjectiterator_getcurrentmeshobject;
	if (sProcName == "lib3mf_componentsobjectiterator_getcurrentcomponentsobject") 
		*ppProcAddress = (void*) &lib3mf_componentsobjectiterator_getcurrentcomponentsobject;
	if (sProcName == "lib3mf_texture2diterator_getcurrenttexture2d") 
		*ppProcAddress = (void*) &lib3mf_texture2diterator_getcurrenttexture2d;
	if (sProcName == "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup;
	if (sProcName == "lib3mf_colorgroupiterator_getcurrentcolorgroup") 
		*ppProcAddress = (void*) &lib3mf_colorgroupiterator_getcurrentcolorgroup;
	if (sProcName == "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup;
	if (sProcName == "lib3mf_compositematerialsiterator_getcurrentcompositematerials") 
		*ppProcAddress = (void*) &lib3mf_compositematerialsiterator_getcurrentcompositematerials;
	if (sProcName == "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup;
	if (sProcName == "lib3mf_image3diterator_getcurrentimage3d") 
		*ppProcAddress = (void*) &lib3mf_image3diterator_getcurrentimage3d;
	if (sProcName == "lib3mf_functioniterator_getcurrentfunction") 
		*ppProcAddress = (void*) &lib3mf_functioniterator_getcurrentfunction;
	if (sProcName == "lib3mf_levelsetiterator_getcurrentlevelset") 
		*ppProcAddress = (void*) &lib3mf_levelsetiterator_getcurrentlevelset;
	if (sProcName == "lib3mf_metadata_getnamespace") 
		*ppProcAddress = (void*) &lib3mf_metadata_getnamespace;
	if (sProcName == "lib3mf_metadata_setnamespace") 
		*ppProcAddress = (void*) &lib3mf_metadata_setnamespace;
	if (sProcName == "lib3mf_metadata_getname") 
		*ppProcAddress = (void*) &lib3mf_metadata_getname;
	if (sProcName == "lib3mf_metadata_setname") 
		*ppProcAddress = (void*) &lib3mf_metadata_setname;
	if (sProcName == "lib3mf_metadata_getkey") 
		*ppProcAddress = (void*) &lib3mf_metadata_getkey;
	if (sProcName == "lib3mf_metadata_getmustpreserve") 
		*ppProcAddress = (void*) &lib3mf_metadata_getmustpreserve;
	if (sProcName == "lib3mf_metadata_setmustpreserve") 
		*ppProcAddress = (void*) &lib3mf_metadata_setmustpreserve;
	if (sProcName == "lib3mf_metadata_gettype") 
		*ppProcAddress = (void*) &lib3mf_metadata_gettype;
	if (sProcName == "lib3mf_metadata_settype") 
		*ppProcAddress = (void*) &lib3mf_metadata_settype;
	if (sProcName == "lib3mf_metadata_getvalue") 
		*ppProcAddress = (void*) &lib3mf_metadata_getvalue;
	if (sProcName == "lib3mf_metadata_setvalue") 
		*ppProcAddress = (void*) &lib3mf_metadata_setvalue;
	if (sProcName == "lib3mf_metadatagroup_getmetadatacount") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_getmetadatacount;
	if (sProcName == "lib3mf_metadatagroup_getmetadata") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_getmetadata;
	if (sProcName == "lib3mf_metadatagroup_getmetadatabykey") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_getmetadatabykey;
	if (sProcName == "lib3mf_metadatagroup_removemetadatabyindex") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_removemetadatabyindex;
	if (sProcName == "lib3mf_metadatagroup_removemetadata") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_removemetadata;
	if (sProcName == "lib3mf_metadatagroup_addmetadata") 
		*ppProcAddress = (void*) &lib3mf_metadatagroup_addmetadata;
	if (sProcName == "lib3mf_triangleset_setname") 
		*ppProcAddress = (void*) &lib3mf_triangleset_setname;
	if (sProcName == "lib3mf_triangleset_getname") 
		*ppProcAddress = (void*) &lib3mf_triangleset_getname;
	if (sProcName == "lib3mf_triangleset_setidentifier") 
		*ppProcAddress = (void*) &lib3mf_triangleset_setidentifier;
	if (sProcName == "lib3mf_triangleset_getidentifier") 
		*ppProcAddress = (void*) &lib3mf_triangleset_getidentifier;
	if (sProcName == "lib3mf_triangleset_addtriangle") 
		*ppProcAddress = (void*) &lib3mf_triangleset_addtriangle;
	if (sProcName == "lib3mf_triangleset_removetriangle") 
		*ppProcAddress = (void*) &lib3mf_triangleset_removetriangle;
	if (sProcName == "lib3mf_triangleset_clear") 
		*ppProcAddress = (void*) &lib3mf_triangleset_clear;
	if (sProcName == "lib3mf_triangleset_settrianglelist") 
		*ppProcAddress = (void*) &lib3mf_triangleset_settrianglelist;
	if (sProcName == "lib3mf_triangleset_gettrianglelist") 
		*ppProcAddress = (void*) &lib3mf_triangleset_gettrianglelist;
	if (sProcName == "lib3mf_triangleset_addtrianglelist") 
		*ppProcAddress = (void*) &lib3mf_triangleset_addtrianglelist;
	if (sProcName == "lib3mf_triangleset_merge") 
		*ppProcAddress = (void*) &lib3mf_triangleset_merge;
	if (sProcName == "lib3mf_triangleset_deleteset") 
		*ppProcAddress = (void*) &lib3mf_triangleset_deleteset;
	if (sProcName == "lib3mf_triangleset_duplicate") 
		*ppProcAddress = (void*) &lib3mf_triangleset_duplicate;
	if (sProcName == "lib3mf_object_gettype") 
		*ppProcAddress = (void*) &lib3mf_object_gettype;
	if (sProcName == "lib3mf_object_settype") 
		*ppProcAddress = (void*) &lib3mf_object_settype;
	if (sProcName == "lib3mf_object_getname") 
		*ppProcAddress = (void*) &lib3mf_object_getname;
	if (sProcName == "lib3mf_object_setname") 
		*ppProcAddress = (void*) &lib3mf_object_setname;
	if (sProcName == "lib3mf_object_getpartnumber") 
		*ppProcAddress = (void*) &lib3mf_object_getpartnumber;
	if (sProcName == "lib3mf_object_setpartnumber") 
		*ppProcAddress = (void*) &lib3mf_object_setpartnumber;
	if (sProcName == "lib3mf_object_ismeshobject") 
		*ppProcAddress = (void*) &lib3mf_object_ismeshobject;
	if (sProcName == "lib3mf_object_iscomponentsobject") 
		*ppProcAddress = (void*) &lib3mf_object_iscomponentsobject;
	if (sProcName == "lib3mf_object_islevelsetobject") 
		*ppProcAddress = (void*) &lib3mf_object_islevelsetobject;
	if (sProcName == "lib3mf_object_isvalid") 
		*ppProcAddress = (void*) &lib3mf_object_isvalid;
	if (sProcName == "lib3mf_object_setattachmentasthumbnail") 
		*ppProcAddress = (void*) &lib3mf_object_setattachmentasthumbnail;
	if (sProcName == "lib3mf_object_getthumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_object_getthumbnailattachment;
	if (sProcName == "lib3mf_object_clearthumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_object_clearthumbnailattachment;
	if (sProcName == "lib3mf_object_getoutbox") 
		*ppProcAddress = (void*) &lib3mf_object_getoutbox;
	if (sProcName == "lib3mf_object_getuuid") 
		*ppProcAddress = (void*) &lib3mf_object_getuuid;
	if (sProcName == "lib3mf_object_setuuid") 
		*ppProcAddress = (void*) &lib3mf_object_setuuid;
	if (sProcName == "lib3mf_object_getmetadatagroup") 
		*ppProcAddress = (void*) &lib3mf_object_getmetadatagroup;
	if (sProcName == "lib3mf_object_setslicesmeshresolution") 
		*ppProcAddress = (void*) &lib3mf_object_setslicesmeshresolution;
	if (sProcName == "lib3mf_object_getslicesmeshresolution") 
		*ppProcAddress = (void*) &lib3mf_object_getslicesmeshresolution;
	if (sProcName == "lib3mf_object_hasslices") 
		*ppProcAddress = (void*) &lib3mf_object_hasslices;
	if (sProcName == "lib3mf_object_clearslicestack") 
		*ppProcAddress = (void*) &lib3mf_object_clearslicestack;
	if (sProcName == "lib3mf_object_getslicestack") 
		*ppProcAddress = (void*) &lib3mf_object_getslicestack;
	if (sProcName == "lib3mf_object_assignslicestack") 
		*ppProcAddress = (void*) &lib3mf_object_assignslicestack;
	if (sProcName == "lib3mf_meshobject_getvertexcount") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getvertexcount;
	if (sProcName == "lib3mf_meshobject_gettrianglecount") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettrianglecount;
	if (sProcName == "lib3mf_meshobject_getvertex") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getvertex;
	if (sProcName == "lib3mf_meshobject_setvertex") 
		*ppProcAddress = (void*) &lib3mf_meshobject_setvertex;
	if (sProcName == "lib3mf_meshobject_addvertex") 
		*ppProcAddress = (void*) &lib3mf_meshobject_addvertex;
	if (sProcName == "lib3mf_meshobject_getvertices") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getvertices;
	if (sProcName == "lib3mf_meshobject_gettriangle") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettriangle;
	if (sProcName == "lib3mf_meshobject_settriangle") 
		*ppProcAddress = (void*) &lib3mf_meshobject_settriangle;
	if (sProcName == "lib3mf_meshobject_addtriangle") 
		*ppProcAddress = (void*) &lib3mf_meshobject_addtriangle;
	if (sProcName == "lib3mf_meshobject_gettriangleindices") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettriangleindices;
	if (sProcName == "lib3mf_meshobject_setobjectlevelproperty") 
		*ppProcAddress = (void*) &lib3mf_meshobject_setobjectlevelproperty;
	if (sProcName == "lib3mf_meshobject_getobjectlevelproperty") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getobjectlevelproperty;
	if (sProcName == "lib3mf_meshobject_settriangleproperties") 
		*ppProcAddress = (void*) &lib3mf_meshobject_settriangleproperties;
	if (sProcName == "lib3mf_meshobject_gettriangleproperties") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettriangleproperties;
	if (sProcName == "lib3mf_meshobject_setalltriangleproperties") 
		*ppProcAddress = (void*) &lib3mf_meshobject_setalltriangleproperties;
	if (sProcName == "lib3mf_meshobject_getalltriangleproperties") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getalltriangleproperties;
	if (sProcName == "lib3mf_meshobject_clearallproperties") 
		*ppProcAddress = (void*) &lib3mf_meshobject_clearallproperties;
	if (sProcName == "lib3mf_meshobject_setgeometry") 
		*ppProcAddress = (void*) &lib3mf_meshobject_setgeometry;
	if (sProcName == "lib3mf_meshobject_ismanifoldandoriented") 
		*ppProcAddress = (void*) &lib3mf_meshobject_ismanifoldandoriented;
	if (sProcName == "lib3mf_meshobject_beamlattice") 
		*ppProcAddress = (void*) &lib3mf_meshobject_beamlattice;
	if (sProcName == "lib3mf_meshobject_getvolumedata") 
		*ppProcAddress = (void*) &lib3mf_meshobject_getvolumedata;
	if (sProcName == "lib3mf_meshobject_setvolumedata") 
		*ppProcAddress = (void*) &lib3mf_meshobject_setvolumedata;
	if (sProcName == "lib3mf_meshobject_addtriangleset") 
		*ppProcAddress = (void*) &lib3mf_meshobject_addtriangleset;
	if (sProcName == "lib3mf_meshobject_hastriangleset") 
		*ppProcAddress = (void*) &lib3mf_meshobject_hastriangleset;
	if (sProcName == "lib3mf_meshobject_findtriangleset") 
		*ppProcAddress = (void*) &lib3mf_meshobject_findtriangleset;
	if (sProcName == "lib3mf_meshobject_gettrianglesetcount") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettrianglesetcount;
	if (sProcName == "lib3mf_meshobject_gettriangleset") 
		*ppProcAddress = (void*) &lib3mf_meshobject_gettriangleset;
	if (sProcName == "lib3mf_levelset_getfunction") 
		*ppProcAddress = (void*) &lib3mf_levelset_getfunction;
	if (sProcName == "lib3mf_levelset_setfunction") 
		*ppProcAddress = (void*) &lib3mf_levelset_setfunction;
	if (sProcName == "lib3mf_levelset_gettransform") 
		*ppProcAddress = (void*) &lib3mf_levelset_gettransform;
	if (sProcName == "lib3mf_levelset_settransform") 
		*ppProcAddress = (void*) &lib3mf_levelset_settransform;
	if (sProcName == "lib3mf_levelset_getchannelname") 
		*ppProcAddress = (void*) &lib3mf_levelset_getchannelname;
	if (sProcName == "lib3mf_levelset_setchannelname") 
		*ppProcAddress = (void*) &lib3mf_levelset_setchannelname;
	if (sProcName == "lib3mf_levelset_setminfeaturesize") 
		*ppProcAddress = (void*) &lib3mf_levelset_setminfeaturesize;
	if (sProcName == "lib3mf_levelset_getminfeaturesize") 
		*ppProcAddress = (void*) &lib3mf_levelset_getminfeaturesize;
	if (sProcName == "lib3mf_levelset_setfallbackvalue") 
		*ppProcAddress = (void*) &lib3mf_levelset_setfallbackvalue;
	if (sProcName == "lib3mf_levelset_getfallbackvalue") 
		*ppProcAddress = (void*) &lib3mf_levelset_getfallbackvalue;
	if (sProcName == "lib3mf_levelset_setmeshbboxonly") 
		*ppProcAddress = (void*) &lib3mf_levelset_setmeshbboxonly;
	if (sProcName == "lib3mf_levelset_getmeshbboxonly") 
		*ppProcAddress = (void*) &lib3mf_levelset_getmeshbboxonly;
	if (sProcName == "lib3mf_levelset_setmesh") 
		*ppProcAddress = (void*) &lib3mf_levelset_setmesh;
	if (sProcName == "lib3mf_levelset_getmesh") 
		*ppProcAddress = (void*) &lib3mf_levelset_getmesh;
	if (sProcName == "lib3mf_levelset_getvolumedata") 
		*ppProcAddress = (void*) &lib3mf_levelset_getvolumedata;
	if (sProcName == "lib3mf_levelset_setvolumedata") 
		*ppProcAddress = (void*) &lib3mf_levelset_setvolumedata;
	if (sProcName == "lib3mf_beamlattice_getminlength") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getminlength;
	if (sProcName == "lib3mf_beamlattice_setminlength") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setminlength;
	if (sProcName == "lib3mf_beamlattice_getclipping") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getclipping;
	if (sProcName == "lib3mf_beamlattice_setclipping") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setclipping;
	if (sProcName == "lib3mf_beamlattice_getrepresentation") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getrepresentation;
	if (sProcName == "lib3mf_beamlattice_setrepresentation") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setrepresentation;
	if (sProcName == "lib3mf_beamlattice_getballoptions") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getballoptions;
	if (sProcName == "lib3mf_beamlattice_setballoptions") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setballoptions;
	if (sProcName == "lib3mf_beamlattice_getbeamcount") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getbeamcount;
	if (sProcName == "lib3mf_beamlattice_getbeam") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getbeam;
	if (sProcName == "lib3mf_beamlattice_addbeam") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_addbeam;
	if (sProcName == "lib3mf_beamlattice_setbeam") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setbeam;
	if (sProcName == "lib3mf_beamlattice_setbeams") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setbeams;
	if (sProcName == "lib3mf_beamlattice_getbeams") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getbeams;
	if (sProcName == "lib3mf_beamlattice_getballcount") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getballcount;
	if (sProcName == "lib3mf_beamlattice_getball") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getball;
	if (sProcName == "lib3mf_beamlattice_addball") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_addball;
	if (sProcName == "lib3mf_beamlattice_setball") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setball;
	if (sProcName == "lib3mf_beamlattice_setballs") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_setballs;
	if (sProcName == "lib3mf_beamlattice_getballs") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getballs;
	if (sProcName == "lib3mf_beamlattice_getbeamsetcount") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getbeamsetcount;
	if (sProcName == "lib3mf_beamlattice_addbeamset") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_addbeamset;
	if (sProcName == "lib3mf_beamlattice_getbeamset") 
		*ppProcAddress = (void*) &lib3mf_beamlattice_getbeamset;
	if (sProcName == "lib3mf_functionreference_getfunctionresourceid") 
		*ppProcAddress = (void*) &lib3mf_functionreference_getfunctionresourceid;
	if (sProcName == "lib3mf_functionreference_setfunctionresourceid") 
		*ppProcAddress = (void*) &lib3mf_functionreference_setfunctionresourceid;
	if (sProcName == "lib3mf_functionreference_gettransform") 
		*ppProcAddress = (void*) &lib3mf_functionreference_gettransform;
	if (sProcName == "lib3mf_functionreference_settransform") 
		*ppProcAddress = (void*) &lib3mf_functionreference_settransform;
	if (sProcName == "lib3mf_functionreference_getchannelname") 
		*ppProcAddress = (void*) &lib3mf_functionreference_getchannelname;
	if (sProcName == "lib3mf_functionreference_setchannelname") 
		*ppProcAddress = (void*) &lib3mf_functionreference_setchannelname;
	if (sProcName == "lib3mf_functionreference_setminfeaturesize") 
		*ppProcAddress = (void*) &lib3mf_functionreference_setminfeaturesize;
	if (sProcName == "lib3mf_functionreference_getminfeaturesize") 
		*ppProcAddress = (void*) &lib3mf_functionreference_getminfeaturesize;
	if (sProcName == "lib3mf_functionreference_setfallbackvalue") 
		*ppProcAddress = (void*) &lib3mf_functionreference_setfallbackvalue;
	if (sProcName == "lib3mf_functionreference_getfallbackvalue") 
		*ppProcAddress = (void*) &lib3mf_functionreference_getfallbackvalue;
	if (sProcName == "lib3mf_volumedatacomposite_getbasematerialgroup") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_getbasematerialgroup;
	if (sProcName == "lib3mf_volumedatacomposite_setbasematerialgroup") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_setbasematerialgroup;
	if (sProcName == "lib3mf_volumedatacomposite_getmaterialmappingcount") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_getmaterialmappingcount;
	if (sProcName == "lib3mf_volumedatacomposite_getmaterialmapping") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_getmaterialmapping;
	if (sProcName == "lib3mf_volumedatacomposite_addmaterialmapping") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_addmaterialmapping;
	if (sProcName == "lib3mf_volumedatacomposite_removematerialmapping") 
		*ppProcAddress = (void*) &lib3mf_volumedatacomposite_removematerialmapping;
	if (sProcName == "lib3mf_volumedataproperty_getname") 
		*ppProcAddress = (void*) &lib3mf_volumedataproperty_getname;
	if (sProcName == "lib3mf_volumedataproperty_setisrequired") 
		*ppProcAddress = (void*) &lib3mf_volumedataproperty_setisrequired;
	if (sProcName == "lib3mf_volumedataproperty_isrequired") 
		*ppProcAddress = (void*) &lib3mf_volumedataproperty_isrequired;
	if (sProcName == "lib3mf_volumedata_getcomposite") 
		*ppProcAddress = (void*) &lib3mf_volumedata_getcomposite;
	if (sProcName == "lib3mf_volumedata_createnewcomposite") 
		*ppProcAddress = (void*) &lib3mf_volumedata_createnewcomposite;
	if (sProcName == "lib3mf_volumedata_removecomposite") 
		*ppProcAddress = (void*) &lib3mf_volumedata_removecomposite;
	if (sProcName == "lib3mf_volumedata_getcolor") 
		*ppProcAddress = (void*) &lib3mf_volumedata_getcolor;
	if (sProcName == "lib3mf_volumedata_createnewcolor") 
		*ppProcAddress = (void*) &lib3mf_volumedata_createnewcolor;
	if (sProcName == "lib3mf_volumedata_removecolor") 
		*ppProcAddress = (void*) &lib3mf_volumedata_removecolor;
	if (sProcName == "lib3mf_volumedata_getpropertycount") 
		*ppProcAddress = (void*) &lib3mf_volumedata_getpropertycount;
	if (sProcName == "lib3mf_volumedata_getproperty") 
		*ppProcAddress = (void*) &lib3mf_volumedata_getproperty;
	if (sProcName == "lib3mf_volumedata_addpropertyfromfunction") 
		*ppProcAddress = (void*) &lib3mf_volumedata_addpropertyfromfunction;
	if (sProcName == "lib3mf_volumedata_removeproperty") 
		*ppProcAddress = (void*) &lib3mf_volumedata_removeproperty;
	if (sProcName == "lib3mf_component_getobjectresource") 
		*ppProcAddress = (void*) &lib3mf_component_getobjectresource;
	if (sProcName == "lib3mf_component_getobjectresourceid") 
		*ppProcAddress = (void*) &lib3mf_component_getobjectresourceid;
	if (sProcName == "lib3mf_component_getuuid") 
		*ppProcAddress = (void*) &lib3mf_component_getuuid;
	if (sProcName == "lib3mf_component_setuuid") 
		*ppProcAddress = (void*) &lib3mf_component_setuuid;
	if (sProcName == "lib3mf_component_hastransform") 
		*ppProcAddress = (void*) &lib3mf_component_hastransform;
	if (sProcName == "lib3mf_component_gettransform") 
		*ppProcAddress = (void*) &lib3mf_component_gettransform;
	if (sProcName == "lib3mf_component_settransform") 
		*ppProcAddress = (void*) &lib3mf_component_settransform;
	if (sProcName == "lib3mf_componentsobject_addcomponent") 
		*ppProcAddress = (void*) &lib3mf_componentsobject_addcomponent;
	if (sProcName == "lib3mf_componentsobject_getcomponent") 
		*ppProcAddress = (void*) &lib3mf_componentsobject_getcomponent;
	if (sProcName == "lib3mf_componentsobject_getcomponentcount") 
		*ppProcAddress = (void*) &lib3mf_componentsobject_getcomponentcount;
	if (sProcName == "lib3mf_beamset_setname") 
		*ppProcAddress = (void*) &lib3mf_beamset_setname;
	if (sProcName == "lib3mf_beamset_getname") 
		*ppProcAddress = (void*) &lib3mf_beamset_getname;
	if (sProcName == "lib3mf_beamset_setidentifier") 
		*ppProcAddress = (void*) &lib3mf_beamset_setidentifier;
	if (sProcName == "lib3mf_beamset_getidentifier") 
		*ppProcAddress = (void*) &lib3mf_beamset_getidentifier;
	if (sProcName == "lib3mf_beamset_getreferencecount") 
		*ppProcAddress = (void*) &lib3mf_beamset_getreferencecount;
	if (sProcName == "lib3mf_beamset_setreferences") 
		*ppProcAddress = (void*) &lib3mf_beamset_setreferences;
	if (sProcName == "lib3mf_beamset_getreferences") 
		*ppProcAddress = (void*) &lib3mf_beamset_getreferences;
	if (sProcName == "lib3mf_beamset_getballreferencecount") 
		*ppProcAddress = (void*) &lib3mf_beamset_getballreferencecount;
	if (sProcName == "lib3mf_beamset_setballreferences") 
		*ppProcAddress = (void*) &lib3mf_beamset_setballreferences;
	if (sProcName == "lib3mf_beamset_getballreferences") 
		*ppProcAddress = (void*) &lib3mf_beamset_getballreferences;
	if (sProcName == "lib3mf_basematerialgroup_getcount") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_getcount;
	if (sProcName == "lib3mf_basematerialgroup_getallpropertyids") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_getallpropertyids;
	if (sProcName == "lib3mf_basematerialgroup_addmaterial") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_addmaterial;
	if (sProcName == "lib3mf_basematerialgroup_removematerial") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_removematerial;
	if (sProcName == "lib3mf_basematerialgroup_getname") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_getname;
	if (sProcName == "lib3mf_basematerialgroup_setname") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_setname;
	if (sProcName == "lib3mf_basematerialgroup_setdisplaycolor") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_setdisplaycolor;
	if (sProcName == "lib3mf_basematerialgroup_getdisplaycolor") 
		*ppProcAddress = (void*) &lib3mf_basematerialgroup_getdisplaycolor;
	if (sProcName == "lib3mf_colorgroup_getcount") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_getcount;
	if (sProcName == "lib3mf_colorgroup_getallpropertyids") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_getallpropertyids;
	if (sProcName == "lib3mf_colorgroup_addcolor") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_addcolor;
	if (sProcName == "lib3mf_colorgroup_removecolor") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_removecolor;
	if (sProcName == "lib3mf_colorgroup_setcolor") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_setcolor;
	if (sProcName == "lib3mf_colorgroup_getcolor") 
		*ppProcAddress = (void*) &lib3mf_colorgroup_getcolor;
	if (sProcName == "lib3mf_texture2dgroup_getcount") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_getcount;
	if (sProcName == "lib3mf_texture2dgroup_getallpropertyids") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_getallpropertyids;
	if (sProcName == "lib3mf_texture2dgroup_addtex2coord") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_addtex2coord;
	if (sProcName == "lib3mf_texture2dgroup_gettex2coord") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_gettex2coord;
	if (sProcName == "lib3mf_texture2dgroup_removetex2coord") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_removetex2coord;
	if (sProcName == "lib3mf_texture2dgroup_gettexture2d") 
		*ppProcAddress = (void*) &lib3mf_texture2dgroup_gettexture2d;
	if (sProcName == "lib3mf_compositematerials_getcount") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_getcount;
	if (sProcName == "lib3mf_compositematerials_getallpropertyids") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_getallpropertyids;
	if (sProcName == "lib3mf_compositematerials_getbasematerialgroup") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_getbasematerialgroup;
	if (sProcName == "lib3mf_compositematerials_addcomposite") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_addcomposite;
	if (sProcName == "lib3mf_compositematerials_removecomposite") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_removecomposite;
	if (sProcName == "lib3mf_compositematerials_getcomposite") 
		*ppProcAddress = (void*) &lib3mf_compositematerials_getcomposite;
	if (sProcName == "lib3mf_multipropertygroup_getcount") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_getcount;
	if (sProcName == "lib3mf_multipropertygroup_getallpropertyids") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_getallpropertyids;
	if (sProcName == "lib3mf_multipropertygroup_addmultiproperty") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_addmultiproperty;
	if (sProcName == "lib3mf_multipropertygroup_setmultiproperty") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_setmultiproperty;
	if (sProcName == "lib3mf_multipropertygroup_getmultiproperty") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_getmultiproperty;
	if (sProcName == "lib3mf_multipropertygroup_removemultiproperty") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_removemultiproperty;
	if (sProcName == "lib3mf_multipropertygroup_getlayercount") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_getlayercount;
	if (sProcName == "lib3mf_multipropertygroup_addlayer") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_addlayer;
	if (sProcName == "lib3mf_multipropertygroup_getlayer") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_getlayer;
	if (sProcName == "lib3mf_multipropertygroup_removelayer") 
		*ppProcAddress = (void*) &lib3mf_multipropertygroup_removelayer;
	if (sProcName == "lib3mf_image3d_getname") 
		*ppProcAddress = (void*) &lib3mf_image3d_getname;
	if (sProcName == "lib3mf_image3d_setname") 
		*ppProcAddress = (void*) &lib3mf_image3d_setname;
	if (sProcName == "lib3mf_image3d_isimagestack") 
		*ppProcAddress = (void*) &lib3mf_image3d_isimagestack;
	if (sProcName == "lib3mf_imagestack_getrowcount") 
		*ppProcAddress = (void*) &lib3mf_imagestack_getrowcount;
	if (sProcName == "lib3mf_imagestack_setrowcount") 
		*ppProcAddress = (void*) &lib3mf_imagestack_setrowcount;
	if (sProcName == "lib3mf_imagestack_getcolumncount") 
		*ppProcAddress = (void*) &lib3mf_imagestack_getcolumncount;
	if (sProcName == "lib3mf_imagestack_setcolumncount") 
		*ppProcAddress = (void*) &lib3mf_imagestack_setcolumncount;
	if (sProcName == "lib3mf_imagestack_getsheetcount") 
		*ppProcAddress = (void*) &lib3mf_imagestack_getsheetcount;
	if (sProcName == "lib3mf_imagestack_getsheet") 
		*ppProcAddress = (void*) &lib3mf_imagestack_getsheet;
	if (sProcName == "lib3mf_imagestack_setsheet") 
		*ppProcAddress = (void*) &lib3mf_imagestack_setsheet;
	if (sProcName == "lib3mf_imagestack_createemptysheet") 
		*ppProcAddress = (void*) &lib3mf_imagestack_createemptysheet;
	if (sProcName == "lib3mf_imagestack_createsheetfrombuffer") 
		*ppProcAddress = (void*) &lib3mf_imagestack_createsheetfrombuffer;
	if (sProcName == "lib3mf_imagestack_createsheetfromfile") 
		*ppProcAddress = (void*) &lib3mf_imagestack_createsheetfromfile;
	if (sProcName == "lib3mf_attachment_getpath") 
		*ppProcAddress = (void*) &lib3mf_attachment_getpath;
	if (sProcName == "lib3mf_attachment_setpath") 
		*ppProcAddress = (void*) &lib3mf_attachment_setpath;
	if (sProcName == "lib3mf_attachment_packagepart") 
		*ppProcAddress = (void*) &lib3mf_attachment_packagepart;
	if (sProcName == "lib3mf_attachment_getrelationshiptype") 
		*ppProcAddress = (void*) &lib3mf_attachment_getrelationshiptype;
	if (sProcName == "lib3mf_attachment_setrelationshiptype") 
		*ppProcAddress = (void*) &lib3mf_attachment_setrelationshiptype;
	if (sProcName == "lib3mf_attachment_writetofile") 
		*ppProcAddress = (void*) &lib3mf_attachment_writetofile;
	if (sProcName == "lib3mf_attachment_readfromfile") 
		*ppProcAddress = (void*) &lib3mf_attachment_readfromfile;
	if (sProcName == "lib3mf_attachment_readfromcallback") 
		*ppProcAddress = (void*) &lib3mf_attachment_readfromcallback;
	if (sProcName == "lib3mf_attachment_getstreamsize") 
		*ppProcAddress = (void*) &lib3mf_attachment_getstreamsize;
	if (sProcName == "lib3mf_attachment_writetobuffer") 
		*ppProcAddress = (void*) &lib3mf_attachment_writetobuffer;
	if (sProcName == "lib3mf_attachment_readfrombuffer") 
		*ppProcAddress = (void*) &lib3mf_attachment_readfrombuffer;
	if (sProcName == "lib3mf_texture2d_getattachment") 
		*ppProcAddress = (void*) &lib3mf_texture2d_getattachment;
	if (sProcName == "lib3mf_texture2d_setattachment") 
		*ppProcAddress = (void*) &lib3mf_texture2d_setattachment;
	if (sProcName == "lib3mf_texture2d_getcontenttype") 
		*ppProcAddress = (void*) &lib3mf_texture2d_getcontenttype;
	if (sProcName == "lib3mf_texture2d_setcontenttype") 
		*ppProcAddress = (void*) &lib3mf_texture2d_setcontenttype;
	if (sProcName == "lib3mf_texture2d_gettilestyleuv") 
		*ppProcAddress = (void*) &lib3mf_texture2d_gettilestyleuv;
	if (sProcName == "lib3mf_texture2d_settilestyleuv") 
		*ppProcAddress = (void*) &lib3mf_texture2d_settilestyleuv;
	if (sProcName == "lib3mf_texture2d_getfilter") 
		*ppProcAddress = (void*) &lib3mf_texture2d_getfilter;
	if (sProcName == "lib3mf_texture2d_setfilter") 
		*ppProcAddress = (void*) &lib3mf_texture2d_setfilter;
	if (sProcName == "lib3mf_implicitport_getidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitport_getidentifier;
	if (sProcName == "lib3mf_implicitport_setidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitport_setidentifier;
	if (sProcName == "lib3mf_implicitport_getdisplayname") 
		*ppProcAddress = (void*) &lib3mf_implicitport_getdisplayname;
	if (sProcName == "lib3mf_implicitport_setdisplayname") 
		*ppProcAddress = (void*) &lib3mf_implicitport_setdisplayname;
	if (sProcName == "lib3mf_implicitport_settype") 
		*ppProcAddress = (void*) &lib3mf_implicitport_settype;
	if (sProcName == "lib3mf_implicitport_gettype") 
		*ppProcAddress = (void*) &lib3mf_implicitport_gettype;
	if (sProcName == "lib3mf_implicitport_getreference") 
		*ppProcAddress = (void*) &lib3mf_implicitport_getreference;
	if (sProcName == "lib3mf_implicitport_setreference") 
		*ppProcAddress = (void*) &lib3mf_implicitport_setreference;
	if (sProcName == "lib3mf_iterator_movenext") 
		*ppProcAddress = (void*) &lib3mf_iterator_movenext;
	if (sProcName == "lib3mf_iterator_moveprevious") 
		*ppProcAddress = (void*) &lib3mf_iterator_moveprevious;
	if (sProcName == "lib3mf_iterator_count") 
		*ppProcAddress = (void*) &lib3mf_iterator_count;
	if (sProcName == "lib3mf_implicitportiterator_getcurrent") 
		*ppProcAddress = (void*) &lib3mf_implicitportiterator_getcurrent;
	if (sProcName == "lib3mf_implicitnode_getidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_getidentifier;
	if (sProcName == "lib3mf_implicitnode_setidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_setidentifier;
	if (sProcName == "lib3mf_implicitnode_getdisplayname") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_getdisplayname;
	if (sProcName == "lib3mf_implicitnode_setdisplayname") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_setdisplayname;
	if (sProcName == "lib3mf_implicitnode_gettag") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_gettag;
	if (sProcName == "lib3mf_implicitnode_settag") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_settag;
	if (sProcName == "lib3mf_implicitnode_getnodetype") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_getnodetype;
	if (sProcName == "lib3mf_implicitnode_addinput") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_addinput;
	if (sProcName == "lib3mf_implicitnode_getinputs") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_getinputs;
	if (sProcName == "lib3mf_implicitnode_addoutput") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_addoutput;
	if (sProcName == "lib3mf_implicitnode_getoutputs") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_getoutputs;
	if (sProcName == "lib3mf_implicitnode_findinput") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_findinput;
	if (sProcName == "lib3mf_implicitnode_findoutput") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_findoutput;
	if (sProcName == "lib3mf_implicitnode_aretypesvalid") 
		*ppProcAddress = (void*) &lib3mf_implicitnode_aretypesvalid;
	if (sProcName == "lib3mf_oneinputnode_getinputa") 
		*ppProcAddress = (void*) &lib3mf_oneinputnode_getinputa;
	if (sProcName == "lib3mf_oneinputnode_getoutputresult") 
		*ppProcAddress = (void*) &lib3mf_oneinputnode_getoutputresult;
	if (sProcName == "lib3mf_resourceidnode_setresource") 
		*ppProcAddress = (void*) &lib3mf_resourceidnode_setresource;
	if (sProcName == "lib3mf_resourceidnode_getresource") 
		*ppProcAddress = (void*) &lib3mf_resourceidnode_getresource;
	if (sProcName == "lib3mf_resourceidnode_getoutputvalue") 
		*ppProcAddress = (void*) &lib3mf_resourceidnode_getoutputvalue;
	if (sProcName == "lib3mf_twoinputnode_getinputb") 
		*ppProcAddress = (void*) &lib3mf_twoinputnode_getinputb;
	if (sProcName == "lib3mf_selectnode_getinputb") 
		*ppProcAddress = (void*) &lib3mf_selectnode_getinputb;
	if (sProcName == "lib3mf_selectnode_getinputc") 
		*ppProcAddress = (void*) &lib3mf_selectnode_getinputc;
	if (sProcName == "lib3mf_selectnode_getinputd") 
		*ppProcAddress = (void*) &lib3mf_selectnode_getinputd;
	if (sProcName == "lib3mf_clampnode_getinputmin") 
		*ppProcAddress = (void*) &lib3mf_clampnode_getinputmin;
	if (sProcName == "lib3mf_clampnode_getinputmax") 
		*ppProcAddress = (void*) &lib3mf_clampnode_getinputmax;
	if (sProcName == "lib3mf_composevectornode_getinputx") 
		*ppProcAddress = (void*) &lib3mf_composevectornode_getinputx;
	if (sProcName == "lib3mf_composevectornode_getinputy") 
		*ppProcAddress = (void*) &lib3mf_composevectornode_getinputy;
	if (sProcName == "lib3mf_composevectornode_getinputz") 
		*ppProcAddress = (void*) &lib3mf_composevectornode_getinputz;
	if (sProcName == "lib3mf_composevectornode_getoutputresult") 
		*ppProcAddress = (void*) &lib3mf_composevectornode_getoutputresult;
	if (sProcName == "lib3mf_decomposevectornode_getinputa") 
		*ppProcAddress = (void*) &lib3mf_decomposevectornode_getinputa;
	if (sProcName == "lib3mf_decomposevectornode_getoutputx") 
		*ppProcAddress = (void*) &lib3mf_decomposevectornode_getoutputx;
	if (sProcName == "lib3mf_decomposevectornode_getoutputy") 
		*ppProcAddress = (void*) &lib3mf_decomposevectornode_getoutputy;
	if (sProcName == "lib3mf_decomposevectornode_getoutputz") 
		*ppProcAddress = (void*) &lib3mf_decomposevectornode_getoutputz;
	if (sProcName == "lib3mf_composematrixnode_getinputm00") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm00;
	if (sProcName == "lib3mf_composematrixnode_getinputm01") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm01;
	if (sProcName == "lib3mf_composematrixnode_getinputm02") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm02;
	if (sProcName == "lib3mf_composematrixnode_getinputm03") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm03;
	if (sProcName == "lib3mf_composematrixnode_getinputm10") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm10;
	if (sProcName == "lib3mf_composematrixnode_getinputm11") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm11;
	if (sProcName == "lib3mf_composematrixnode_getinputm12") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm12;
	if (sProcName == "lib3mf_composematrixnode_getinputm13") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm13;
	if (sProcName == "lib3mf_composematrixnode_getinputm20") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm20;
	if (sProcName == "lib3mf_composematrixnode_getinputm21") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm21;
	if (sProcName == "lib3mf_composematrixnode_getinputm22") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm22;
	if (sProcName == "lib3mf_composematrixnode_getinputm23") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm23;
	if (sProcName == "lib3mf_composematrixnode_getinputm30") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm30;
	if (sProcName == "lib3mf_composematrixnode_getinputm31") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm31;
	if (sProcName == "lib3mf_composematrixnode_getinputm32") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm32;
	if (sProcName == "lib3mf_composematrixnode_getinputm33") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getinputm33;
	if (sProcName == "lib3mf_composematrixnode_getoutputresult") 
		*ppProcAddress = (void*) &lib3mf_composematrixnode_getoutputresult;
	if (sProcName == "lib3mf_matrixfromrowsnode_getinputa") 
		*ppProcAddress = (void*) &lib3mf_matrixfromrowsnode_getinputa;
	if (sProcName == "lib3mf_matrixfromrowsnode_getinputb") 
		*ppProcAddress = (void*) &lib3mf_matrixfromrowsnode_getinputb;
	if (sProcName == "lib3mf_matrixfromrowsnode_getinputc") 
		*ppProcAddress = (void*) &lib3mf_matrixfromrowsnode_getinputc;
	if (sProcName == "lib3mf_matrixfromrowsnode_getinputd") 
		*ppProcAddress = (void*) &lib3mf_matrixfromrowsnode_getinputd;
	if (sProcName == "lib3mf_matrixfromrowsnode_getoutputresult") 
		*ppProcAddress = (void*) &lib3mf_matrixfromrowsnode_getoutputresult;
	if (sProcName == "lib3mf_matrixfromcolumnsnode_getinputa") 
		*ppProcAddress = (void*) &lib3mf_matrixfromcolumnsnode_getinputa;
	if (sProcName == "lib3mf_matrixfromcolumnsnode_getinputb") 
		*ppProcAddress = (void*) &lib3mf_matrixfromcolumnsnode_getinputb;
	if (sProcName == "lib3mf_matrixfromcolumnsnode_getinputc") 
		*ppProcAddress = (void*) &lib3mf_matrixfromcolumnsnode_getinputc;
	if (sProcName == "lib3mf_matrixfromcolumnsnode_getinputd") 
		*ppProcAddress = (void*) &lib3mf_matrixfromcolumnsnode_getinputd;
	if (sProcName == "lib3mf_matrixfromcolumnsnode_getoutputresult") 
		*ppProcAddress = (void*) &lib3mf_matrixfromcolumnsnode_getoutputresult;
	if (sProcName == "lib3mf_constantnode_setconstant") 
		*ppProcAddress = (void*) &lib3mf_constantnode_setconstant;
	if (sProcName == "lib3mf_constantnode_getconstant") 
		*ppProcAddress = (void*) &lib3mf_constantnode_getconstant;
	if (sProcName == "lib3mf_constantnode_getoutputvalue") 
		*ppProcAddress = (void*) &lib3mf_constantnode_getoutputvalue;
	if (sProcName == "lib3mf_constvecnode_setvector") 
		*ppProcAddress = (void*) &lib3mf_constvecnode_setvector;
	if (sProcName == "lib3mf_constvecnode_getvector") 
		*ppProcAddress = (void*) &lib3mf_constvecnode_getvector;
	if (sProcName == "lib3mf_constvecnode_getoutputvector") 
		*ppProcAddress = (void*) &lib3mf_constvecnode_getoutputvector;
	if (sProcName == "lib3mf_constmatnode_setmatrix") 
		*ppProcAddress = (void*) &lib3mf_constmatnode_setmatrix;
	if (sProcName == "lib3mf_constmatnode_getmatrix") 
		*ppProcAddress = (void*) &lib3mf_constmatnode_getmatrix;
	if (sProcName == "lib3mf_constmatnode_getoutputmatrix") 
		*ppProcAddress = (void*) &lib3mf_constmatnode_getoutputmatrix;
	if (sProcName == "lib3mf_meshnode_getinputmesh") 
		*ppProcAddress = (void*) &lib3mf_meshnode_getinputmesh;
	if (sProcName == "lib3mf_meshnode_getinputpos") 
		*ppProcAddress = (void*) &lib3mf_meshnode_getinputpos;
	if (sProcName == "lib3mf_meshnode_getoutputdistance") 
		*ppProcAddress = (void*) &lib3mf_meshnode_getoutputdistance;
	if (sProcName == "lib3mf_unsignedmeshnode_getinputmesh") 
		*ppProcAddress = (void*) &lib3mf_unsignedmeshnode_getinputmesh;
	if (sProcName == "lib3mf_unsignedmeshnode_getinputpos") 
		*ppProcAddress = (void*) &lib3mf_unsignedmeshnode_getinputpos;
	if (sProcName == "lib3mf_unsignedmeshnode_getoutputdistance") 
		*ppProcAddress = (void*) &lib3mf_unsignedmeshnode_getoutputdistance;
	if (sProcName == "lib3mf_functioncallnode_getinputfunctionid") 
		*ppProcAddress = (void*) &lib3mf_functioncallnode_getinputfunctionid;
	if (sProcName == "lib3mf_nodeiterator_getcurrent") 
		*ppProcAddress = (void*) &lib3mf_nodeiterator_getcurrent;
	if (sProcName == "lib3mf_function_getdisplayname") 
		*ppProcAddress = (void*) &lib3mf_function_getdisplayname;
	if (sProcName == "lib3mf_function_setdisplayname") 
		*ppProcAddress = (void*) &lib3mf_function_setdisplayname;
	if (sProcName == "lib3mf_function_addinput") 
		*ppProcAddress = (void*) &lib3mf_function_addinput;
	if (sProcName == "lib3mf_function_getinputs") 
		*ppProcAddress = (void*) &lib3mf_function_getinputs;
	if (sProcName == "lib3mf_function_removeinput") 
		*ppProcAddress = (void*) &lib3mf_function_removeinput;
	if (sProcName == "lib3mf_function_addoutput") 
		*ppProcAddress = (void*) &lib3mf_function_addoutput;
	if (sProcName == "lib3mf_function_getoutputs") 
		*ppProcAddress = (void*) &lib3mf_function_getoutputs;
	if (sProcName == "lib3mf_function_removeoutput") 
		*ppProcAddress = (void*) &lib3mf_function_removeoutput;
	if (sProcName == "lib3mf_function_findinput") 
		*ppProcAddress = (void*) &lib3mf_function_findinput;
	if (sProcName == "lib3mf_function_findoutput") 
		*ppProcAddress = (void*) &lib3mf_function_findoutput;
	if (sProcName == "lib3mf_implicitfunction_getidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_getidentifier;
	if (sProcName == "lib3mf_implicitfunction_setidentifier") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_setidentifier;
	if (sProcName == "lib3mf_implicitfunction_addnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addnode;
	if (sProcName == "lib3mf_implicitfunction_addsinnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addsinnode;
	if (sProcName == "lib3mf_implicitfunction_addcosnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addcosnode;
	if (sProcName == "lib3mf_implicitfunction_addtannode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addtannode;
	if (sProcName == "lib3mf_implicitfunction_addarcsinnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addarcsinnode;
	if (sProcName == "lib3mf_implicitfunction_addarccosnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addarccosnode;
	if (sProcName == "lib3mf_implicitfunction_addarctan2node") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addarctan2node;
	if (sProcName == "lib3mf_implicitfunction_addsinhnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addsinhnode;
	if (sProcName == "lib3mf_implicitfunction_addcoshnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addcoshnode;
	if (sProcName == "lib3mf_implicitfunction_addtanhnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addtanhnode;
	if (sProcName == "lib3mf_implicitfunction_addroundnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addroundnode;
	if (sProcName == "lib3mf_implicitfunction_addceilnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addceilnode;
	if (sProcName == "lib3mf_implicitfunction_addfloornode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addfloornode;
	if (sProcName == "lib3mf_implicitfunction_addsignnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addsignnode;
	if (sProcName == "lib3mf_implicitfunction_addfractnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addfractnode;
	if (sProcName == "lib3mf_implicitfunction_addabsnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addabsnode;
	if (sProcName == "lib3mf_implicitfunction_addexpnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addexpnode;
	if (sProcName == "lib3mf_implicitfunction_addlognode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlognode;
	if (sProcName == "lib3mf_implicitfunction_addlog2node") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlog2node;
	if (sProcName == "lib3mf_implicitfunction_addlog10node") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlog10node;
	if (sProcName == "lib3mf_implicitfunction_addlengthnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlengthnode;
	if (sProcName == "lib3mf_implicitfunction_addtransposenode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addtransposenode;
	if (sProcName == "lib3mf_implicitfunction_addinversenode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addinversenode;
	if (sProcName == "lib3mf_implicitfunction_addsqrtnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addsqrtnode;
	if (sProcName == "lib3mf_implicitfunction_addresourceidnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addresourceidnode;
	if (sProcName == "lib3mf_implicitfunction_addadditionnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addadditionnode;
	if (sProcName == "lib3mf_implicitfunction_addsubtractionnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addsubtractionnode;
	if (sProcName == "lib3mf_implicitfunction_addmultiplicationnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmultiplicationnode;
	if (sProcName == "lib3mf_implicitfunction_adddivisionnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_adddivisionnode;
	if (sProcName == "lib3mf_implicitfunction_adddotnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_adddotnode;
	if (sProcName == "lib3mf_implicitfunction_addcrossnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addcrossnode;
	if (sProcName == "lib3mf_implicitfunction_addmatvecmultiplicationnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmatvecmultiplicationnode;
	if (sProcName == "lib3mf_implicitfunction_addminnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addminnode;
	if (sProcName == "lib3mf_implicitfunction_addmaxnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmaxnode;
	if (sProcName == "lib3mf_implicitfunction_addfmodnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addfmodnode;
	if (sProcName == "lib3mf_implicitfunction_addpownode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addpownode;
	if (sProcName == "lib3mf_implicitfunction_addselectnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addselectnode;
	if (sProcName == "lib3mf_implicitfunction_addclampnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addclampnode;
	if (sProcName == "lib3mf_implicitfunction_addcomposevectornode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addcomposevectornode;
	if (sProcName == "lib3mf_implicitfunction_addvectorfromscalarnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addvectorfromscalarnode;
	if (sProcName == "lib3mf_implicitfunction_adddecomposevectornode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_adddecomposevectornode;
	if (sProcName == "lib3mf_implicitfunction_addcomposematrixnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addcomposematrixnode;
	if (sProcName == "lib3mf_implicitfunction_addmatrixfromrowsnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmatrixfromrowsnode;
	if (sProcName == "lib3mf_implicitfunction_addmatrixfromcolumnsnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmatrixfromcolumnsnode;
	if (sProcName == "lib3mf_implicitfunction_addconstantnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addconstantnode;
	if (sProcName == "lib3mf_implicitfunction_addconstvecnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addconstvecnode;
	if (sProcName == "lib3mf_implicitfunction_addconstmatnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addconstmatnode;
	if (sProcName == "lib3mf_implicitfunction_addmeshnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addmeshnode;
	if (sProcName == "lib3mf_implicitfunction_addunsignedmeshnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addunsignedmeshnode;
	if (sProcName == "lib3mf_implicitfunction_addfunctioncallnode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addfunctioncallnode;
	if (sProcName == "lib3mf_implicitfunction_getnodes") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_getnodes;
	if (sProcName == "lib3mf_implicitfunction_removenode") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_removenode;
	if (sProcName == "lib3mf_implicitfunction_addlink") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlink;
	if (sProcName == "lib3mf_implicitfunction_addlinkbynames") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_addlinkbynames;
	if (sProcName == "lib3mf_implicitfunction_clear") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_clear;
	if (sProcName == "lib3mf_implicitfunction_sortnodestopologically") 
		*ppProcAddress = (void*) &lib3mf_implicitfunction_sortnodestopologically;
	if (sProcName == "lib3mf_functionfromimage3d_getimage3d") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_getimage3d;
	if (sProcName == "lib3mf_functionfromimage3d_setimage3d") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_setimage3d;
	if (sProcName == "lib3mf_functionfromimage3d_setfilter") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_setfilter;
	if (sProcName == "lib3mf_functionfromimage3d_getfilter") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_getfilter;
	if (sProcName == "lib3mf_functionfromimage3d_settilestyles") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_settilestyles;
	if (sProcName == "lib3mf_functionfromimage3d_gettilestyles") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_gettilestyles;
	if (sProcName == "lib3mf_functionfromimage3d_getoffset") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_getoffset;
	if (sProcName == "lib3mf_functionfromimage3d_setoffset") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_setoffset;
	if (sProcName == "lib3mf_functionfromimage3d_getscale") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_getscale;
	if (sProcName == "lib3mf_functionfromimage3d_setscale") 
		*ppProcAddress = (void*) &lib3mf_functionfromimage3d_setscale;
	if (sProcName == "lib3mf_builditem_getobjectresource") 
		*ppProcAddress = (void*) &lib3mf_builditem_getobjectresource;
	if (sProcName == "lib3mf_builditem_getuuid") 
		*ppProcAddress = (void*) &lib3mf_builditem_getuuid;
	if (sProcName == "lib3mf_builditem_setuuid") 
		*ppProcAddress = (void*) &lib3mf_builditem_setuuid;
	if (sProcName == "lib3mf_builditem_getobjectresourceid") 
		*ppProcAddress = (void*) &lib3mf_builditem_getobjectresourceid;
	if (sProcName == "lib3mf_builditem_hasobjecttransform") 
		*ppProcAddress = (void*) &lib3mf_builditem_hasobjecttransform;
	if (sProcName == "lib3mf_builditem_getobjecttransform") 
		*ppProcAddress = (void*) &lib3mf_builditem_getobjecttransform;
	if (sProcName == "lib3mf_builditem_setobjecttransform") 
		*ppProcAddress = (void*) &lib3mf_builditem_setobjecttransform;
	if (sProcName == "lib3mf_builditem_getpartnumber") 
		*ppProcAddress = (void*) &lib3mf_builditem_getpartnumber;
	if (sProcName == "lib3mf_builditem_setpartnumber") 
		*ppProcAddress = (void*) &lib3mf_builditem_setpartnumber;
	if (sProcName == "lib3mf_builditem_getmetadatagroup") 
		*ppProcAddress = (void*) &lib3mf_builditem_getmetadatagroup;
	if (sProcName == "lib3mf_builditem_getoutbox") 
		*ppProcAddress = (void*) &lib3mf_builditem_getoutbox;
	if (sProcName == "lib3mf_builditemiterator_movenext") 
		*ppProcAddress = (void*) &lib3mf_builditemiterator_movenext;
	if (sProcName == "lib3mf_builditemiterator_moveprevious") 
		*ppProcAddress = (void*) &lib3mf_builditemiterator_moveprevious;
	if (sProcName == "lib3mf_builditemiterator_getcurrent") 
		*ppProcAddress = (void*) &lib3mf_builditemiterator_getcurrent;
	if (sProcName == "lib3mf_builditemiterator_clone") 
		*ppProcAddress = (void*) &lib3mf_builditemiterator_clone;
	if (sProcName == "lib3mf_builditemiterator_count") 
		*ppProcAddress = (void*) &lib3mf_builditemiterator_count;
	if (sProcName == "lib3mf_slice_setvertices") 
		*ppProcAddress = (void*) &lib3mf_slice_setvertices;
	if (sProcName == "lib3mf_slice_getvertices") 
		*ppProcAddress = (void*) &lib3mf_slice_getvertices;
	if (sProcName == "lib3mf_slice_getvertexcount") 
		*ppProcAddress = (void*) &lib3mf_slice_getvertexcount;
	if (sProcName == "lib3mf_slice_addpolygon") 
		*ppProcAddress = (void*) &lib3mf_slice_addpolygon;
	if (sProcName == "lib3mf_slice_getpolygoncount") 
		*ppProcAddress = (void*) &lib3mf_slice_getpolygoncount;
	if (sProcName == "lib3mf_slice_setpolygonindices") 
		*ppProcAddress = (void*) &lib3mf_slice_setpolygonindices;
	if (sProcName == "lib3mf_slice_getpolygonindices") 
		*ppProcAddress = (void*) &lib3mf_slice_getpolygonindices;
	if (sProcName == "lib3mf_slice_getpolygonindexcount") 
		*ppProcAddress = (void*) &lib3mf_slice_getpolygonindexcount;
	if (sProcName == "lib3mf_slice_getztop") 
		*ppProcAddress = (void*) &lib3mf_slice_getztop;
	if (sProcName == "lib3mf_slicestack_getbottomz") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getbottomz;
	if (sProcName == "lib3mf_slicestack_getslicecount") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getslicecount;
	if (sProcName == "lib3mf_slicestack_getslice") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getslice;
	if (sProcName == "lib3mf_slicestack_addslice") 
		*ppProcAddress = (void*) &lib3mf_slicestack_addslice;
	if (sProcName == "lib3mf_slicestack_getslicerefcount") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getslicerefcount;
	if (sProcName == "lib3mf_slicestack_addslicestackreference") 
		*ppProcAddress = (void*) &lib3mf_slicestack_addslicestackreference;
	if (sProcName == "lib3mf_slicestack_getslicestackreference") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getslicestackreference;
	if (sProcName == "lib3mf_slicestack_collapseslicereferences") 
		*ppProcAddress = (void*) &lib3mf_slicestack_collapseslicereferences;
	if (sProcName == "lib3mf_slicestack_setownpath") 
		*ppProcAddress = (void*) &lib3mf_slicestack_setownpath;
	if (sProcName == "lib3mf_slicestack_getownpath") 
		*ppProcAddress = (void*) &lib3mf_slicestack_getownpath;
	if (sProcName == "lib3mf_consumer_getconsumerid") 
		*ppProcAddress = (void*) &lib3mf_consumer_getconsumerid;
	if (sProcName == "lib3mf_consumer_getkeyid") 
		*ppProcAddress = (void*) &lib3mf_consumer_getkeyid;
	if (sProcName == "lib3mf_consumer_getkeyvalue") 
		*ppProcAddress = (void*) &lib3mf_consumer_getkeyvalue;
	if (sProcName == "lib3mf_accessright_getconsumer") 
		*ppProcAddress = (void*) &lib3mf_accessright_getconsumer;
	if (sProcName == "lib3mf_accessright_getwrappingalgorithm") 
		*ppProcAddress = (void*) &lib3mf_accessright_getwrappingalgorithm;
	if (sProcName == "lib3mf_accessright_getmgfalgorithm") 
		*ppProcAddress = (void*) &lib3mf_accessright_getmgfalgorithm;
	if (sProcName == "lib3mf_accessright_getdigestmethod") 
		*ppProcAddress = (void*) &lib3mf_accessright_getdigestmethod;
	if (sProcName == "lib3mf_contentencryptionparams_getencryptionalgorithm") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getencryptionalgorithm;
	if (sProcName == "lib3mf_contentencryptionparams_getkey") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getkey;
	if (sProcName == "lib3mf_contentencryptionparams_getinitializationvector") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getinitializationvector;
	if (sProcName == "lib3mf_contentencryptionparams_getauthenticationtag") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getauthenticationtag;
	if (sProcName == "lib3mf_contentencryptionparams_setauthenticationtag") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_setauthenticationtag;
	if (sProcName == "lib3mf_contentencryptionparams_getadditionalauthenticationdata") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getadditionalauthenticationdata;
	if (sProcName == "lib3mf_contentencryptionparams_getdescriptor") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getdescriptor;
	if (sProcName == "lib3mf_contentencryptionparams_getkeyuuid") 
		*ppProcAddress = (void*) &lib3mf_contentencryptionparams_getkeyuuid;
	if (sProcName == "lib3mf_resourcedata_getpath") 
		*ppProcAddress = (void*) &lib3mf_resourcedata_getpath;
	if (sProcName == "lib3mf_resourcedata_getencryptionalgorithm") 
		*ppProcAddress = (void*) &lib3mf_resourcedata_getencryptionalgorithm;
	if (sProcName == "lib3mf_resourcedata_getcompression") 
		*ppProcAddress = (void*) &lib3mf_resourcedata_getcompression;
	if (sProcName == "lib3mf_resourcedata_getadditionalauthenticationdata") 
		*ppProcAddress = (void*) &lib3mf_resourcedata_getadditionalauthenticationdata;
	if (sProcName == "lib3mf_resourcedatagroup_getkeyuuid") 
		*ppProcAddress = (void*) &lib3mf_resourcedatagroup_getkeyuuid;
	if (sProcName == "lib3mf_resourcedatagroup_addaccessright") 
		*ppProcAddress = (void*) &lib3mf_resourcedatagroup_addaccessright;
	if (sProcName == "lib3mf_resourcedatagroup_findaccessrightbyconsumer") 
		*ppProcAddress = (void*) &lib3mf_resourcedatagroup_findaccessrightbyconsumer;
	if (sProcName == "lib3mf_resourcedatagroup_removeaccessright") 
		*ppProcAddress = (void*) &lib3mf_resourcedatagroup_removeaccessright;
	if (sProcName == "lib3mf_keystore_addconsumer") 
		*ppProcAddress = (void*) &lib3mf_keystore_addconsumer;
	if (sProcName == "lib3mf_keystore_getconsumercount") 
		*ppProcAddress = (void*) &lib3mf_keystore_getconsumercount;
	if (sProcName == "lib3mf_keystore_getconsumer") 
		*ppProcAddress = (void*) &lib3mf_keystore_getconsumer;
	if (sProcName == "lib3mf_keystore_removeconsumer") 
		*ppProcAddress = (void*) &lib3mf_keystore_removeconsumer;
	if (sProcName == "lib3mf_keystore_findconsumer") 
		*ppProcAddress = (void*) &lib3mf_keystore_findconsumer;
	if (sProcName == "lib3mf_keystore_getresourcedatagroupcount") 
		*ppProcAddress = (void*) &lib3mf_keystore_getresourcedatagroupcount;
	if (sProcName == "lib3mf_keystore_addresourcedatagroup") 
		*ppProcAddress = (void*) &lib3mf_keystore_addresourcedatagroup;
	if (sProcName == "lib3mf_keystore_getresourcedatagroup") 
		*ppProcAddress = (void*) &lib3mf_keystore_getresourcedatagroup;
	if (sProcName == "lib3mf_keystore_removeresourcedatagroup") 
		*ppProcAddress = (void*) &lib3mf_keystore_removeresourcedatagroup;
	if (sProcName == "lib3mf_keystore_findresourcedatagroup") 
		*ppProcAddress = (void*) &lib3mf_keystore_findresourcedatagroup;
	if (sProcName == "lib3mf_keystore_addresourcedata") 
		*ppProcAddress = (void*) &lib3mf_keystore_addresourcedata;
	if (sProcName == "lib3mf_keystore_removeresourcedata") 
		*ppProcAddress = (void*) &lib3mf_keystore_removeresourcedata;
	if (sProcName == "lib3mf_keystore_findresourcedata") 
		*ppProcAddress = (void*) &lib3mf_keystore_findresourcedata;
	if (sProcName == "lib3mf_keystore_getresourcedatacount") 
		*ppProcAddress = (void*) &lib3mf_keystore_getresourcedatacount;
	if (sProcName == "lib3mf_keystore_getresourcedata") 
		*ppProcAddress = (void*) &lib3mf_keystore_getresourcedata;
	if (sProcName == "lib3mf_keystore_getuuid") 
		*ppProcAddress = (void*) &lib3mf_keystore_getuuid;
	if (sProcName == "lib3mf_keystore_setuuid") 
		*ppProcAddress = (void*) &lib3mf_keystore_setuuid;
	if (sProcName == "lib3mf_model_rootmodelpart") 
		*ppProcAddress = (void*) &lib3mf_model_rootmodelpart;
	if (sProcName == "lib3mf_model_findorcreatepackagepart") 
		*ppProcAddress = (void*) &lib3mf_model_findorcreatepackagepart;
	if (sProcName == "lib3mf_model_setunit") 
		*ppProcAddress = (void*) &lib3mf_model_setunit;
	if (sProcName == "lib3mf_model_getunit") 
		*ppProcAddress = (void*) &lib3mf_model_getunit;
	if (sProcName == "lib3mf_model_getlanguage") 
		*ppProcAddress = (void*) &lib3mf_model_getlanguage;
	if (sProcName == "lib3mf_model_setlanguage") 
		*ppProcAddress = (void*) &lib3mf_model_setlanguage;
	if (sProcName == "lib3mf_model_querywriter") 
		*ppProcAddress = (void*) &lib3mf_model_querywriter;
	if (sProcName == "lib3mf_model_queryreader") 
		*ppProcAddress = (void*) &lib3mf_model_queryreader;
	if (sProcName == "lib3mf_model_getresourcebyid") 
		*ppProcAddress = (void*) &lib3mf_model_getresourcebyid;
	if (sProcName == "lib3mf_model_gettexture2dbyid") 
		*ppProcAddress = (void*) &lib3mf_model_gettexture2dbyid;
	if (sProcName == "lib3mf_model_getpropertytypebyid") 
		*ppProcAddress = (void*) &lib3mf_model_getpropertytypebyid;
	if (sProcName == "lib3mf_model_getbasematerialgroupbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getbasematerialgroupbyid;
	if (sProcName == "lib3mf_model_gettexture2dgroupbyid") 
		*ppProcAddress = (void*) &lib3mf_model_gettexture2dgroupbyid;
	if (sProcName == "lib3mf_model_getcompositematerialsbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getcompositematerialsbyid;
	if (sProcName == "lib3mf_model_getmultipropertygroupbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getmultipropertygroupbyid;
	if (sProcName == "lib3mf_model_getmeshobjectbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getmeshobjectbyid;
	if (sProcName == "lib3mf_model_getcomponentsobjectbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getcomponentsobjectbyid;
	if (sProcName == "lib3mf_model_getcolorgroupbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getcolorgroupbyid;
	if (sProcName == "lib3mf_model_getslicestackbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getslicestackbyid;
	if (sProcName == "lib3mf_model_getlevelsetbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getlevelsetbyid;
	if (sProcName == "lib3mf_model_getbuilduuid") 
		*ppProcAddress = (void*) &lib3mf_model_getbuilduuid;
	if (sProcName == "lib3mf_model_setbuilduuid") 
		*ppProcAddress = (void*) &lib3mf_model_setbuilduuid;
	if (sProcName == "lib3mf_model_getbuilditems") 
		*ppProcAddress = (void*) &lib3mf_model_getbuilditems;
	if (sProcName == "lib3mf_model_getoutbox") 
		*ppProcAddress = (void*) &lib3mf_model_getoutbox;
	if (sProcName == "lib3mf_model_getresources") 
		*ppProcAddress = (void*) &lib3mf_model_getresources;
	if (sProcName == "lib3mf_model_getobjects") 
		*ppProcAddress = (void*) &lib3mf_model_getobjects;
	if (sProcName == "lib3mf_model_getmeshobjects") 
		*ppProcAddress = (void*) &lib3mf_model_getmeshobjects;
	if (sProcName == "lib3mf_model_getcomponentsobjects") 
		*ppProcAddress = (void*) &lib3mf_model_getcomponentsobjects;
	if (sProcName == "lib3mf_model_gettexture2ds") 
		*ppProcAddress = (void*) &lib3mf_model_gettexture2ds;
	if (sProcName == "lib3mf_model_getbasematerialgroups") 
		*ppProcAddress = (void*) &lib3mf_model_getbasematerialgroups;
	if (sProcName == "lib3mf_model_getcolorgroups") 
		*ppProcAddress = (void*) &lib3mf_model_getcolorgroups;
	if (sProcName == "lib3mf_model_gettexture2dgroups") 
		*ppProcAddress = (void*) &lib3mf_model_gettexture2dgroups;
	if (sProcName == "lib3mf_model_getcompositematerials") 
		*ppProcAddress = (void*) &lib3mf_model_getcompositematerials;
	if (sProcName == "lib3mf_model_getmultipropertygroups") 
		*ppProcAddress = (void*) &lib3mf_model_getmultipropertygroups;
	if (sProcName == "lib3mf_model_getslicestacks") 
		*ppProcAddress = (void*) &lib3mf_model_getslicestacks;
	if (sProcName == "lib3mf_model_getimage3ds") 
		*ppProcAddress = (void*) &lib3mf_model_getimage3ds;
	if (sProcName == "lib3mf_model_mergetomodel") 
		*ppProcAddress = (void*) &lib3mf_model_mergetomodel;
	if (sProcName == "lib3mf_model_mergefrommodel") 
		*ppProcAddress = (void*) &lib3mf_model_mergefrommodel;
	if (sProcName == "lib3mf_model_addmeshobject") 
		*ppProcAddress = (void*) &lib3mf_model_addmeshobject;
	if (sProcName == "lib3mf_model_addcomponentsobject") 
		*ppProcAddress = (void*) &lib3mf_model_addcomponentsobject;
	if (sProcName == "lib3mf_model_addslicestack") 
		*ppProcAddress = (void*) &lib3mf_model_addslicestack;
	if (sProcName == "lib3mf_model_addtexture2dfromattachment") 
		*ppProcAddress = (void*) &lib3mf_model_addtexture2dfromattachment;
	if (sProcName == "lib3mf_model_addbasematerialgroup") 
		*ppProcAddress = (void*) &lib3mf_model_addbasematerialgroup;
	if (sProcName == "lib3mf_model_addcolorgroup") 
		*ppProcAddress = (void*) &lib3mf_model_addcolorgroup;
	if (sProcName == "lib3mf_model_addtexture2dgroup") 
		*ppProcAddress = (void*) &lib3mf_model_addtexture2dgroup;
	if (sProcName == "lib3mf_model_addcompositematerials") 
		*ppProcAddress = (void*) &lib3mf_model_addcompositematerials;
	if (sProcName == "lib3mf_model_addmultipropertygroup") 
		*ppProcAddress = (void*) &lib3mf_model_addmultipropertygroup;
	if (sProcName == "lib3mf_model_addimagestack") 
		*ppProcAddress = (void*) &lib3mf_model_addimagestack;
	if (sProcName == "lib3mf_model_getimagestackbyid") 
		*ppProcAddress = (void*) &lib3mf_model_getimagestackbyid;
	if (sProcName == "lib3mf_model_addbuilditem") 
		*ppProcAddress = (void*) &lib3mf_model_addbuilditem;
	if (sProcName == "lib3mf_model_removebuilditem") 
		*ppProcAddress = (void*) &lib3mf_model_removebuilditem;
	if (sProcName == "lib3mf_model_getmetadatagroup") 
		*ppProcAddress = (void*) &lib3mf_model_getmetadatagroup;
	if (sProcName == "lib3mf_model_addattachment") 
		*ppProcAddress = (void*) &lib3mf_model_addattachment;
	if (sProcName == "lib3mf_model_removeattachment") 
		*ppProcAddress = (void*) &lib3mf_model_removeattachment;
	if (sProcName == "lib3mf_model_getattachment") 
		*ppProcAddress = (void*) &lib3mf_model_getattachment;
	if (sProcName == "lib3mf_model_findattachment") 
		*ppProcAddress = (void*) &lib3mf_model_findattachment;
	if (sProcName == "lib3mf_model_getattachmentcount") 
		*ppProcAddress = (void*) &lib3mf_model_getattachmentcount;
	if (sProcName == "lib3mf_model_haspackagethumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_model_haspackagethumbnailattachment;
	if (sProcName == "lib3mf_model_createpackagethumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_model_createpackagethumbnailattachment;
	if (sProcName == "lib3mf_model_getpackagethumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_model_getpackagethumbnailattachment;
	if (sProcName == "lib3mf_model_removepackagethumbnailattachment") 
		*ppProcAddress = (void*) &lib3mf_model_removepackagethumbnailattachment;
	if (sProcName == "lib3mf_model_addcustomcontenttype") 
		*ppProcAddress = (void*) &lib3mf_model_addcustomcontenttype;
	if (sProcName == "lib3mf_model_removecustomcontenttype") 
		*ppProcAddress = (void*) &lib3mf_model_removecustomcontenttype;
	if (sProcName == "lib3mf_model_setrandomnumbercallback") 
		*ppProcAddress = (void*) &lib3mf_model_setrandomnumbercallback;
	if (sProcName == "lib3mf_model_getkeystore") 
		*ppProcAddress = (void*) &lib3mf_model_getkeystore;
	if (sProcName == "lib3mf_model_getfunctions") 
		*ppProcAddress = (void*) &lib3mf_model_getfunctions;
	if (sProcName == "lib3mf_model_addimplicitfunction") 
		*ppProcAddress = (void*) &lib3mf_model_addimplicitfunction;
	if (sProcName == "lib3mf_model_addfunctionfromimage3d") 
		*ppProcAddress = (void*) &lib3mf_model_addfunctionfromimage3d;
	if (sProcName == "lib3mf_model_addvolumedata") 
		*ppProcAddress = (void*) &lib3mf_model_addvolumedata;
	if (sProcName == "lib3mf_model_addlevelset") 
		*ppProcAddress = (void*) &lib3mf_model_addlevelset;
	if (sProcName == "lib3mf_model_getlevelsets") 
		*ppProcAddress = (void*) &lib3mf_model_getlevelsets;
	if (sProcName == "lib3mf_model_removeresource") 
		*ppProcAddress = (void*) &lib3mf_model_removeresource;
	if (sProcName == "lib3mf_getlibraryversion") 
		*ppProcAddress = (void*) &lib3mf_getlibraryversion;
	if (sProcName == "lib3mf_getprereleaseinformation") 
		*ppProcAddress = (void*) &lib3mf_getprereleaseinformation;
	if (sProcName == "lib3mf_getbuildinformation") 
		*ppProcAddress = (void*) &lib3mf_getbuildinformation;
	if (sProcName == "lib3mf_getspecificationversion") 
		*ppProcAddress = (void*) &lib3mf_getspecificationversion;
	if (sProcName == "lib3mf_createmodel") 
		*ppProcAddress = (void*) &lib3mf_createmodel;
	if (sProcName == "lib3mf_release") 
		*ppProcAddress = (void*) &lib3mf_release;
	if (sProcName == "lib3mf_acquire") 
		*ppProcAddress = (void*) &lib3mf_acquire;
	if (sProcName == "lib3mf_setjournal") 
		*ppProcAddress = (void*) &lib3mf_setjournal;
	if (sProcName == "lib3mf_getlasterror") 
		*ppProcAddress = (void*) &lib3mf_getlasterror;
	if (sProcName == "lib3mf_getsymbollookupmethod") 
		*ppProcAddress = (void*) &lib3mf_getsymbollookupmethod;
	if (sProcName == "lib3mf_retrieveprogressmessage") 
		*ppProcAddress = (void*) &lib3mf_retrieveprogressmessage;
	if (sProcName == "lib3mf_rgbatocolor") 
		*ppProcAddress = (void*) &lib3mf_rgbatocolor;
	if (sProcName == "lib3mf_floatrgbatocolor") 
		*ppProcAddress = (void*) &lib3mf_floatrgbatocolor;
	if (sProcName == "lib3mf_colortorgba") 
		*ppProcAddress = (void*) &lib3mf_colortorgba;
	if (sProcName == "lib3mf_colortofloatrgba") 
		*ppProcAddress = (void*) &lib3mf_colortofloatrgba;
	if (sProcName == "lib3mf_getidentitytransform") 
		*ppProcAddress = (void*) &lib3mf_getidentitytransform;
	if (sProcName == "lib3mf_getuniformscaletransform") 
		*ppProcAddress = (void*) &lib3mf_getuniformscaletransform;
	if (sProcName == "lib3mf_getscaletransform") 
		*ppProcAddress = (void*) &lib3mf_getscaletransform;
	if (sProcName == "lib3mf_gettranslationtransform") 
		*ppProcAddress = (void*) &lib3mf_gettranslationtransform;
	
	if (*ppProcAddress == nullptr) 
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	return LIB3MF_SUCCESS;
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
Lib3MFResult lib3mf_getlibraryversion(Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetLibraryVersion");
		}
		if (!pMajor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::GetLibraryVersion(*pMajor, *pMinor, *pMicro);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Major", *pMajor);
			pJournalEntry->addUInt32Result("Minor", *pMinor);
			pJournalEntry->addUInt32Result("Micro", *pMicro);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getprereleaseinformation(bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetPrereleaseInformation");
		}
		if (pHasPrereleaseInfo == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pPrereleaseInfoBuffer) && !(pPrereleaseInfoNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPrereleaseInfo("");
		*pHasPrereleaseInfo = CWrapper::GetPrereleaseInformation(sPrereleaseInfo);

		if (pPrereleaseInfoNeededChars)
			*pPrereleaseInfoNeededChars = (Lib3MF_uint32) (sPrereleaseInfo.size()+1);
		if (pPrereleaseInfoBuffer) {
			if (sPrereleaseInfo.size() >= nPrereleaseInfoBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPrereleaseInfo = 0; iPrereleaseInfo < sPrereleaseInfo.size(); iPrereleaseInfo++)
				pPrereleaseInfoBuffer[iPrereleaseInfo] = sPrereleaseInfo[iPrereleaseInfo];
			pPrereleaseInfoBuffer[sPrereleaseInfo.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrereleaseInfo", *pHasPrereleaseInfo);
			pJournalEntry->addStringResult("PrereleaseInfo", sPrereleaseInfo.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getbuildinformation(bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetBuildInformation");
		}
		if (pHasBuildInfo == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pBuildInformationBuffer) && !(pBuildInformationNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sBuildInformation("");
		*pHasBuildInfo = CWrapper::GetBuildInformation(sBuildInformation);

		if (pBuildInformationNeededChars)
			*pBuildInformationNeededChars = (Lib3MF_uint32) (sBuildInformation.size()+1);
		if (pBuildInformationBuffer) {
			if (sBuildInformation.size() >= nBuildInformationBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iBuildInformation = 0; iBuildInformation < sBuildInformation.size(); iBuildInformation++)
				pBuildInformationBuffer[iBuildInformation] = sBuildInformation[iBuildInformation];
			pBuildInformationBuffer[sBuildInformation.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasBuildInfo", *pHasBuildInfo);
			pJournalEntry->addStringResult("BuildInformation", sBuildInformation.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getspecificationversion(const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetSpecificationVersion");
			pJournalEntry->addStringParameter("SpecificationURL", pSpecificationURL);
		}
		if (pSpecificationURL == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pIsSupported)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMajor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sSpecificationURL(pSpecificationURL);
		CWrapper::GetSpecificationVersion(sSpecificationURL, *pIsSupported, *pMajor, *pMinor, *pMicro);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsSupported", *pIsSupported);
			pJournalEntry->addUInt32Result("Major", *pMajor);
			pJournalEntry->addUInt32Result("Minor", *pMinor);
			pJournalEntry->addUInt32Result("Micro", *pMicro);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_createmodel(Lib3MF_Model * pModel)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("CreateModel");
		}
		if (pModel == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseModel(nullptr);
		pBaseModel = CWrapper::CreateModel();

		*pModel = (IBase*)(pBaseModel);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Model", *pModel);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_release(Lib3MF_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("Release");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		CWrapper::Release(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_acquire(Lib3MF_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("Acquire");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		CWrapper::Acquire(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_setjournal(const char * pJournalPath)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pJournalPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sJournalPath(pJournalPath);
		m_GlobalJournal = nullptr;
		if (sJournalPath != "") {
			m_GlobalJournal = std::make_shared<CLib3MFInterfaceJournal> (sJournalPath);
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

Lib3MFResult lib3mf_getlasterror(Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetLastError");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		if ( (!pLastErrorStringBuffer) && !(pLastErrorStringNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pHasLastError == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		std::string sLastErrorString("");
		*pHasLastError = CWrapper::GetLastError(pIInstance, sLastErrorString);

		if (pLastErrorStringNeededChars)
			*pLastErrorStringNeededChars = (Lib3MF_uint32) (sLastErrorString.size()+1);
		if (pLastErrorStringBuffer) {
			if (sLastErrorString.size() >= nLastErrorStringBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iLastErrorString = 0; iLastErrorString < sLastErrorString.size(); iLastErrorString++)
				pLastErrorStringBuffer[iLastErrorString] = sLastErrorString[iLastErrorString];
			pLastErrorStringBuffer[sLastErrorString.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("LastErrorString", sLastErrorString.c_str());
			pJournalEntry->addBooleanResult("HasLastError", *pHasLastError);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getsymbollookupmethod(Lib3MF_pvoid * pSymbolLookupMethod)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetSymbolLookupMethod");
		}
		if (pSymbolLookupMethod == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pSymbolLookupMethod = (void*)&Lib3MF::Impl::Lib3MF_GetProcAddress;
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addPointerResult("SymbolLookupMethod", *pSymbolLookupMethod);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_retrieveprogressmessage(eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("RetrieveProgressMessage");
			pJournalEntry->addEnumParameter("TheProgressIdentifier", "ProgressIdentifier", (Lib3MF_int32)(eTheProgressIdentifier));
		}
		if ( (!pProgressMessageBuffer) && !(pProgressMessageNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sProgressMessage("");
		CWrapper::RetrieveProgressMessage(eTheProgressIdentifier, sProgressMessage);

		if (pProgressMessageNeededChars)
			*pProgressMessageNeededChars = (Lib3MF_uint32) (sProgressMessage.size()+1);
		if (pProgressMessageBuffer) {
			if (sProgressMessage.size() >= nProgressMessageBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iProgressMessage = 0; iProgressMessage < sProgressMessage.size(); iProgressMessage++)
				pProgressMessageBuffer[iProgressMessage] = sProgressMessage[iProgressMessage];
			pProgressMessageBuffer[sProgressMessage.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ProgressMessage", sProgressMessage.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_rgbatocolor(Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("RGBAToColor");
			pJournalEntry->addUInt8Parameter("Red", nRed);
			pJournalEntry->addUInt8Parameter("Green", nGreen);
			pJournalEntry->addUInt8Parameter("Blue", nBlue);
			pJournalEntry->addUInt8Parameter("Alpha", nAlpha);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTheColor = CWrapper::RGBAToColor(nRed, nGreen, nBlue, nAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_floatrgbatocolor(Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("FloatRGBAToColor");
			pJournalEntry->addSingleParameter("Red", fRed);
			pJournalEntry->addSingleParameter("Green", fGreen);
			pJournalEntry->addSingleParameter("Blue", fBlue);
			pJournalEntry->addSingleParameter("Alpha", fAlpha);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTheColor = CWrapper::FloatRGBAToColor(fRed, fGreen, fBlue, fAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colortorgba(const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("ColorToRGBA");
		}
		if (!pRed)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pGreen)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBlue)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pAlpha)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::ColorToRGBA(*pTheColor, *pRed, *pGreen, *pBlue, *pAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt8Result("Red", *pRed);
			pJournalEntry->addUInt8Result("Green", *pGreen);
			pJournalEntry->addUInt8Result("Blue", *pBlue);
			pJournalEntry->addUInt8Result("Alpha", *pAlpha);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colortofloatrgba(const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("ColorToFloatRGBA");
		}
		if (!pRed)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pGreen)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBlue)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pAlpha)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::ColorToFloatRGBA(*pTheColor, *pRed, *pGreen, *pBlue, *pAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addSingleResult("Red", *pRed);
			pJournalEntry->addSingleResult("Green", *pGreen);
			pJournalEntry->addSingleResult("Blue", *pBlue);
			pJournalEntry->addSingleResult("Alpha", *pAlpha);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getidentitytransform(sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetIdentityTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetIdentityTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getuniformscaletransform(Lib3MF_single fFactor, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetUniformScaleTransform");
			pJournalEntry->addSingleParameter("Factor", fFactor);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetUniformScaleTransform(fFactor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getscaletransform(Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetScaleTransform");
			pJournalEntry->addSingleParameter("FactorX", fFactorX);
			pJournalEntry->addSingleParameter("FactorY", fFactorY);
			pJournalEntry->addSingleParameter("FactorZ", fFactorZ);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetScaleTransform(fFactorX, fFactorY, fFactorZ);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_gettranslationtransform(Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetTranslationTransform");
			pJournalEntry->addSingleParameter("VectorX", fVectorX);
			pJournalEntry->addSingleParameter("VectorY", fVectorY);
			pJournalEntry->addSingleParameter("VectorZ", fVectorZ);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetTranslationTransform(fVectorX, fVectorY, fVectorZ);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


