#pragma once

#include "common/option.h"

typedef enum __attribute__((__packed__)) FFPackagesFlags
{
    FF_PACKAGES_FLAG_NONE = 0,
    FF_PACKAGES_FLAG_APK_BIT = 1ULL << 0,
    FF_PACKAGES_FLAG_BREW_BIT = 1ULL << 1,
    FF_PACKAGES_FLAG_CHOCO_BIT = 1ULL << 2,
    FF_PACKAGES_FLAG_DPKG_BIT = 1ULL << 3,
    FF_PACKAGES_FLAG_EMERGE_BIT = 1ULL << 4,
    FF_PACKAGES_FLAG_EOPKG_BIT = 1ULL << 5,
    FF_PACKAGES_FLAG_FLATPAK_BIT = 1ULL << 6,
    FF_PACKAGES_FLAG_NIX_BIT = 1ULL << 7,
    FF_PACKAGES_FLAG_OPKG_BIT = 1ULL << 8,
    FF_PACKAGES_FLAG_PACMAN_BIT = 1ULL << 9,
    FF_PACKAGES_FLAG_PALUDIS_BIT = 1ULL << 10,
    FF_PACKAGES_FLAG_PKG_BIT = 1ULL << 11,
    FF_PACKAGES_FLAG_PKGTOOL_BIT = 1ULL << 12,
    FF_PACKAGES_FLAG_MACPORTS_BIT = 1ULL << 13,
    FF_PACKAGES_FLAG_RPM_BIT = 1ULL << 14,
    FF_PACKAGES_FLAG_SCOOP_BIT = 1ULL << 15,
    FF_PACKAGES_FLAG_SNAP_BIT = 1ULL << 16,
    FF_PACKAGES_FLAG_WINGET_BIT = 1ULL << 17,
    FF_PACKAGES_FLAG_XBPS_BIT = 1ULL << 18,
    FF_PACKAGES_FLAG_AM_BIT = 1ULL << 19,
    FF_PACKAGES_FLAG_SORCERY_BIT = 1ULL << 20,
    FF_PACKAGES_FLAG_LPKG_BIT = 1ULL << 21,
    FF_PACKAGES_FLAG_LPKGBUILD_BIT = 1ULL << 22,
    FF_PACKAGES_FLAG_GUIX_BIT = 1ULL << 23,
    FF_PACKAGES_FLAG_LINGLONG_BIT = 1ULL << 24,
    FF_PACKAGES_FLAG_PACSTALL_BIT = 1ULL << 25,
    FF_PACKAGES_FLAG_MPORT_BIT = 1ULL << 26,
    FF_PACKAGES_FLAG_PKGSRC_BIT = 1ULL << 27,
    FF_PACKAGES_FLAG_HPKG_BIT = 1ULL << 28,
    FF_PACKAGES_FLAG_PISI_BIT = 1ULL << 29,
    FF_PACKAGES_FLAG_SOAR_BIT = 1ULL << 30,
    FF_PACKAGES_FLAG_FORCE_UNSIGNED = UINT64_MAX,
} FFPackagesFlags;
static_assert(sizeof(FFPackagesFlags) == sizeof(uint64_t), "");

typedef struct FFPackagesOptions
{
    FFModuleArgs moduleArgs;

    FFPackagesFlags disabled;
    bool combined;
} FFPackagesOptions;

static_assert(sizeof(FFPackagesOptions) <= FF_OPTION_MAX_SIZE, "FFPackagesOptions size exceeds maximum allowed size");
